% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singular.R
\name{singular}
\alias{singular}
\alias{scale_singular}
\title{singular.}
\usage{
singular()

scale_singular(vis, property, name = property, label = name,
  points = TRUE, domain = NULL, override = NULL)
}
\arguments{
\item{vis}{A ggvis object.}

\item{property}{The name of a property, such as "x", "y", "fill", "stroke", etc.}

\item{name}{Name of the scale, such as "x", "y", "fill", etc. Can also be an
arbitrary name like "foo".}

\item{label}{Label for the scale. Used for axis or legend titles.}

\item{points}{If \code{TRUE} (default), distributes the ordinal values over a
quantitative range at uniformly spaced points. The spacing of the points
can be adjusted using the padding property. If \code{FALSE}, the ordinal
scale will construct evenly-spaced bands, rather than points. Note that
if any mark is added with a \code{\link{band}()} prop, then the scale for
that prop will automatically have \code{points} set to \code{FALSE}.}

\item{domain}{The domain of the scale, representing the set of data values.
For ordinal scales, a character vector; for quantitative scales, a numeric
vector of length two. Either value (but not both) may be NA, in which
case \code{domainMin} or \code{domainMax} is set. For dynamic scales, this
can also be a reactive which returns the appropriate type of vector.}

\item{override}{Should the domain specified by this ggvis_scale object
override other ggvis_scale objects for the same scale? Useful when domain is
manually specified. For example, by default, the domain of the scale
will contain the range of the data, but when this is TRUE, the specified
domain will override, and the domain can be smaller than the range of the
data. If \code{FALSE}, the \code{domain} will not behave this way. If
left \code{NULL}, then it will be treated as \code{TRUE} whenever
\code{domain} is non-NULL.}
}
\description{
Use singular when you want constant x or y position.
}
\examples{
mtcars \%>\% ggvis("", ~mpg) \%>\%
  layer_points() \%>\%
  scale_nominal("x") \%>\%
  add_axis("x", title = "", tick_size_major = 0)

# OR
mtcars \%>\% ggvis("", ~mpg) \%>\%
  layer_points() \%>\%
  scale_singular("x")

# OR, even simpler
mtcars \%>\% ggvis(singular(), ~mpg) \%>\% layer_points()

# In the other direction:
mtcars \%>\% ggvis(~mpg, singular()) \%>\% layer_points()
}
