% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/later.R
\name{run_now}
\alias{run_now}
\title{Execute scheduled operations}
\usage{
run_now(timeoutSecs = 0L)
}
\arguments{
\item{timeoutSecs}{Wait (block) for up to this number of seconds waiting for
an operation to be ready to run. If \code{0}, then return immediately if there
are no operations that are ready to run. If \code{Inf} or negative, then wait as
long as it takes (if none are scheduled, then this will block forever).}
}
\value{
A logical indicating whether any callbacks were actually run.
}
\description{
Normally, operations scheduled with \code{\link[=later]{later()}} will not execute unless/until
no other R code is on the stack (i.e. at the top-level). If you need to run
blocking R code for a long time and want to allow scheduled operations to run
at well-defined points of your own operation, you can call \code{run_now()} at
those points and any operations that are due to run will do so.
}
\details{
If one of the callbacks throws an error, the error will \emph{not} be caught, and
subsequent callbacks will not be executed (until \code{run_now()} is called again,
or control returns to the R prompt). You must use your own
\link[base:conditions]{tryCatch} if you want to handle errors.
}
