% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{ExampleData.RLum.Analysis}
\alias{ExampleData.RLum.Analysis}
\title{Example data as \linkS4class{RLum.Analysis} objects}
\format{\code{IRSAR.RF.Data}: IRSAR.RF.Data on coarse grain feldspar

Each object contains data needed for the given protocol analysis.}
\source{
\strong{IRSAR.RF.Data}

These data were kindly provided by Tobias Lauer and Matthias Krbetschek.

\tabular{ll}{
Lab: \tab Luminescence Laboratory TU Bergakademie Freiberg\cr
Lab-Code: \tab ZEU/SA1\cr
Location: \tab Zeuchfeld (Zeuchfeld Sandur; Saxony-Anhalt/Germany)\cr
Material: \tab K-feldspar (130-200 \eqn{\mu}m)\cr
Reference: \tab Kreutzer et al. (2014)
}
}
\description{
Collection of different \linkS4class{RLum.Analysis} objects for
protocol analysis.
}
\section{Version}{
 0.1
}

\examples{

##load data
data(ExampleData.RLum.Analysis, envir = environment())

##plot data
plot_RLum(IRSAR.RF.Data)

}
\references{
\strong{IRSAR.RF.Data}

Kreutzer, S., Lauer, T., Meszner, S., Krbetschek, M.R., Faust, D., Fuchs,
M., 2014. Chronology of the Quaternary profile Zeuchfeld in Saxony-Anhalt /
Germany - a preliminary luminescence dating study. Zeitschrift fuer
Geomorphologie 58, 5-26. doi: 10.1127/0372-8854/2012/S-00112
}
\keyword{datasets}
