% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMultiplexerParamSet.R
\name{makeModelMultiplexerParamSet}
\alias{makeModelMultiplexerParamSet}
\title{Creates a parameter set for model multiplexer tuning.}
\usage{
makeModelMultiplexerParamSet(multiplexer, ..., .check = TRUE)
}
\arguments{
\item{multiplexer}{(\link{ModelMultiplexer})\cr
The muliplexer learner.}

\item{...}{(\link[ParamHelpers:ParamSet]{ParamHelpers::ParamSet} | \link[ParamHelpers:Param]{ParamHelpers::Param})\cr
(a) First option: Named param sets. Names must correspond to base learners.
You only need to enter the parameters you want to tune without reference
to the \code{selected.learner} field in any way.\cr
(b) Second option. Just the params you would enter in the param sets.
Even shorter to create. Only works when it can be uniquely identified to which
learner each of your passed parameters belongs.}

\item{.check}{(\link{logical})\cr
Check that for each param in \code{...} one param in found in the base learners.
Default is \code{TRUE}}
}
\value{
\link{ParamSet}.
}
\description{
Handy way to create the param set with less typing.

The following is done automatically:
\itemize{
\item{The \code{selected.learner} param is created}
\item{Parameter names are prefixed.}
\item{The \code{requires} field of each param is set.
This makes all parameters subordinate to \code{selected.learner}}
}
}
\examples{
# See makeModelMultiplexer
}
\seealso{
Other multiplexer: \code{\link{makeModelMultiplexer}}

Other tune: \code{\link{TuneControl}},
  \code{\link{getNestedTuneResultsOptPathDf}},
  \code{\link{getNestedTuneResultsX}},
  \code{\link{getResamplingIndices}},
  \code{\link{getTuneResult}},
  \code{\link{makeModelMultiplexer}},
  \code{\link{makeTuneControlCMAES}},
  \code{\link{makeTuneControlDesign}},
  \code{\link{makeTuneControlGenSA}},
  \code{\link{makeTuneControlGrid}},
  \code{\link{makeTuneControlIrace}},
  \code{\link{makeTuneControlMBO}},
  \code{\link{makeTuneControlRandom}},
  \code{\link{makeTuneWrapper}}, \code{\link{tuneParams}},
  \code{\link{tuneThreshold}}
}
\concept{multiplexer}
\concept{tune}
