% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_create.R
\name{collection_create}
\alias{collection_create}
\title{Add a collection}
\usage{
collection_create(conn, name, numShards = 1, maxShardsPerNode = 1,
  createNodeSet = NULL, collection.configName = NULL,
  replicationFactor = 1, router.name = NULL, shards = NULL,
  createNodeSet.shuffle = TRUE, router.field = NULL,
  autoAddReplicas = FALSE, async = NULL, raw = FALSE,
  callopts = list(), ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{numShards}{(integer) The number of shards to be created as part of the
collection. This is a required parameter when using the 'compositeId' router.}

\item{maxShardsPerNode}{(integer) When creating collections, the shards and/or replicas
are spread across all available (i.e., live) nodes, and two replicas of the same shard
will never be on the same node. If a node is not live when the CREATE operation is called,
it will not get any parts of the new collection, which could lead to too many replicas
being created on a single live node. Defining maxShardsPerNode sets a limit on the number
of replicas CREATE will spread to each node. If the entire collection can not be fit into
the live nodes, no collection will be created at all. Default: 1}

\item{createNodeSet}{(logical) Allows defining the nodes to spread the new collection
across. If not provided, the CREATE operation will create shard-replica spread across all
live Solr nodes. The format is a comma-separated list of node_names, such as
localhost:8983_solr, localhost:8984_solr, localhost:8985_solr. Default: \code{NULL}}

\item{collection.configName}{(character) Defines the name of the configurations (which
must already be stored in ZooKeeper) to use for this collection. If not provided, Solr
will default to the collection name as the configuration name. Default: \code{compositeId}}

\item{replicationFactor}{(integer) The number of replicas to be created for each shard.
Default: 1}

\item{router.name}{(character) The router name that will be used. The router defines
how documents will be distributed among the shards. The value can be either \code{implicit},
which uses an internal default hash, or \code{compositeId}, which allows defining the specific
shard to assign documents to. When using the 'implicit' router, the shards parameter is
required. When using the 'compositeId' router, the numShards parameter is required.
For more information, see also the section Document Routing. Default: \code{compositeId}}

\item{shards}{(character) A comma separated list of shard names, e.g.,
shard-x,shard-y,shard-z . This is a required parameter when using the 'implicit' router.}

\item{createNodeSet.shuffle}{(logical)    Controls wether or not the shard-replicas created
for this collection will be assigned to the nodes specified by the createNodeSet in a
sequential manner, or if the list of nodes should be shuffled prior to creating individual
replicas.  A 'false' value makes the results of a collection creation predictible and
gives more exact control over the location of the individual shard-replicas, but 'true'
can be a better choice for ensuring replicas are distributed evenly across nodes. Ignored
if createNodeSet is not also specified. Default: \code{TRUE}}

\item{router.field}{(character) If this field is specified, the router will look at the
value of the field in an input document to compute the hash and identify a shard instead of
looking at the uniqueKey field. If the field specified is null in the document, the document
will be rejected. Please note that RealTime Get or retrieval by id would also require the
parameter \emph{route} (or shard.keys) to avoid a distributed search.}

\item{autoAddReplicas}{(logical)    When set to true, enables auto addition of replicas on
shared file systems. See the section autoAddReplicas Settings for more details on settings
and overrides. Default: \code{FALSE}}

\item{async}{(character) Request ID to track this action which will be processed
asynchronously}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{...}{You can pass in parameters like \code{property.name=value}    to set
core property name to value. See the section Defining core.properties for
details on supported properties and values.
(https://lucene.apache.org/solr/guide/7_0/defining-core-properties.html)}
}
\description{
Add a collection
}
\examples{
\dontrun{
# connect
(cli <- SolrClient$new())

if (!cli$collection_exists("helloWorld")) {
  cli$collection_create(name = "helloWorld")
}
if (!cli$collection_exists("tablesChairs")) {
  cli$collection_create(name = "tablesChairs")
}
}
}
