/******************************************************************************
 *
 * Copyright(c) 2019 - 2020 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#ifndef __PHL_SCAN_H__
#define __PHL_SCAN_H__

/* Header file for application to invoke scan service */
#define PHL_SSID_LEN 32
struct rtw_phl_ssid {
	u32 ssid_len;
	u8 ssid[PHL_SSID_LEN];
};

enum phl_scan_mode {
	NULL_MODE,  /* End of Scanning */
	NORMAL_SCAN_MODE, /* OFF CHANNEL : non-operation channel*/
	BACKOP_MODE,
	P2P_SCAN_MODE,
	P2P_LISTEN_MODE,
	MAX_MODE,
};

/* Scan type including active and passive scan. */
enum rtw_phl_scan_type {
	RTW_PHL_SCAN_PASSIVE,
	RTW_PHL_SCAN_ACTIVE,
	RTW_PHL_SCAN_MIX,
};

enum phl_ext_act_scan_state {
	EXT_ACT_SCAN_DISABLE,
	EXT_ACT_SCAN_ENABLE,
	EXT_ACT_SCAN_TRIGGER,
	EXT_ACT_SCAN_DONE,
};

struct phl_scan_channel {
	_os_list list;

	u16 channel; /* channel number */
	u16 duration; /* 0: use default, otherwise: channel scan time */
	enum channel_width bw; /* 0: use default 20Mhz */
	enum chan_offset offset;
	enum rtw_phl_scan_type type; /* active scan: 1, passive scan: 0 */
	u8 scan_mode; /* according to phl_scan_mode */
	u8 ext_act_scan; /* according to phl_ext_act_scan_state */
};

enum scan_result {
	SCAN_REQ_ABORT, /* abort a non-started(queued) scan */
	SCAN_REQ_CANCEL, /* cancel a started scan */
	SCAN_REQ_COMPLETE /* scan complete */
};

enum scan_bkop_mode {
	SCAN_BKOP_NONE,
	SCAN_BKOP_CNT,
	SCAN_BKOP_TIMER
};

#define SCAN_SSID_AMOUNT 9 /* for WEXT_CSCAN_AMOUNT 9 */
#define SCAN_CH_AMOUNT (14+37)
struct rtw_phl_scan_param {
	u32 max_scan_time;
	#ifdef CONFIG_PHL_CMD_SCAN_BKOP_TIME
	u32 max_listen_time;
	#endif
	struct rtw_phl_ssid ssid[SCAN_SSID_AMOUNT];
	u8 ssid_num;
	u8 repeat; /* 255 means scan forever until cancel */

	u8 ch_num;
	struct phl_scan_channel *ch;
	u32 ch_sz;
	int ch_idx; /* current scaned cahnnel index, init vaule = (-1) */

	/* back op param */
	enum scan_bkop_mode back_op_mode;
	u8 back_op_ch_cnt; /* every back_op_ch_cnt go back to op ch */

	/* every 'back_op_off_ch_dur_ms' go back to op ch
	 * back_op_off_ch_dur_ms have to large than ch->duration
	 * 0 : not specify
	*/
	u16 back_op_ch_dur_ms; /* op ch stay time; 0 : use default value */
	u16 back_op_off_ch_dur_ms;
	u16 back_op_off_ch_ext_dur_ms; /* extend when off_ch_tx (MGNT_TX) */

	struct rtw_phl_scan_ops *ops;
	void *priv; /* ops private */

	struct rtw_wifi_role_t *wifi_role;
	/* scan fsm internal use
	 * represent current scanning channel
	 */
	struct phl_scan_channel *scan_ch;

#ifdef CONFIG_PHL_CMD_SCAN
	struct phl_queue chlist;
	struct phl_scan_channel back_op_ch[MAX_WIFI_ROLE_NUMBER];

	_os_timer scan_timer; /* handle in phl_cmd_scan */
	u8 fltr_mode; /* backup filter mode before off channel */
	u8 state;
#endif
	/* create for computing scan time */
	u32 enqueue_time;
	u32 start_time;
	u32 end_time;
	u32 total_scan_time;

	u32 token; /* unique id, generated by rtw_phl_scan_request() */
	const char *name;
	enum scan_result result;
	u32 ext_act_scan_period;
};

enum PRECEDE {
	TO_TAIL, /* normal case */
	TO_HEAD, /* insert to head */
	IMMEDIATE /* cancel previous scan and run immediately */
};

struct rtw_phl_scan_ops {
	int (*scan_issue_pbreq)(void *priv, struct rtw_phl_scan_param *param);
	u8 (*scan_issue_null_data)(void *priv, u8 ridx, bool ps);
	int (*scan_start)(void *priv, struct rtw_phl_scan_param *param);
	int (*scan_ch_ready)(void *priv, struct rtw_phl_scan_param *param);
	int (*scan_off_ch_tx)(void *priv,
		struct rtw_phl_scan_param *param, void *data);
	int (*scan_complete)(void *priv, struct rtw_phl_scan_param *param);
};

enum rtw_phl_status rtw_phl_scan_cancel(void *phl);
enum rtw_phl_status rtw_phl_scan_request(void *phl,
	struct rtw_phl_scan_param *pbuf, enum PRECEDE order);
enum rtw_phl_status rtw_phl_scan_del_request(void *phl,
	u32 token);
enum rtw_phl_status rtw_phl_scan_pause(void *phl);
enum rtw_phl_status rtw_phl_scan_resume(void *phl);
enum rtw_phl_status rtw_phl_scan_force_active_scan(void *phl,
	u16 channel, u16 duration);
int rtw_phl_scan_inprogress_req_num(void *phl);
enum rtw_phl_status rtw_phl_scan_running_req(void *phl,
	struct rtw_phl_scan_param **param);
bool rtw_phl_scan_scanning_req(void *phl, u32 token, u32 *token_running);
enum rtw_phl_status rtw_phl_scan_off_ch_tx(void *phl, void *data, int len);

/* CMD_DISP SCAN*/
enum rtw_phl_status rtw_phl_cmd_scan_request(void *phl,
	struct rtw_phl_scan_param *param, enum PRECEDE order);
enum rtw_phl_status rtw_phl_cmd_scan_cancel(void *phl,
				struct rtw_phl_scan_param *param);
int rtw_phl_cmd_scan_inprogress(void *phl, u8 band_idx);

#endif /* __PHL_SCAN_H__ */

