#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the features/changes added for release 1.58:

   - Handling of PGP encrypted messages

tac

rm -f test.log test.out

for PGP in 0 1; do
  $ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
    'file_name_tpl = ./.tmp.$$$' \
    'header_rev = 0' \
    'feat_testing = 1' \
    "feat_trust_pgp = $PGP" \
    'feat_force_name = 1' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>>test.log >>test.out
From xxx@example.com  Thu Aug  3 07:32:10 2000
Return-Path: <xxx@example.com>
Received: from example.com (root@example.com [149.144.245.5])
	by example.com (8.9.3/8.9.3) with ESMTP id HAA01305
	for <bre@example.com>; Thu, 3 Aug 2000 07:32:03 GMT
From: xxx@example.com
Date: Thu, 3 Aug 2000 06:39:59 GMT
Message-Id: <200008030639.GAA23780@example.com>
MIME-Version: 1.0
Sender: xxx@example.com
Subject: Testing version 1.58
To: fake@example.com
Content-Type: text/plain; charset="iso-8859-1"
Content-Transfer-Encoding: 8bit

-----BEGIN PGP MESSAGE-----
Version: GnuPG v1.0.6 (GNU/Linux)
Comment: For info see http://www.gnupg.org

hQEOA1USfm+7kflAEAP8DDDl0gai5IiMzT2h8cCDsmdAfuTmOPHmU+Ztfwk4ES5a
WBYqnDFmjwRgemo2kHZ6Zzy1va8sUeOg33or9Cnaz78cIuk9dt0rhKZpeXlt80HT
QKVJoVqeiSkOfpktRwhH3igJHcjAx5SNFq6BwL6ku/vj2rQHtIe1qBq2t5QWdGUE
AJfMg3kNHKIY2<object>ww98sI4NpBIO9HPIOJ5+Yn137PwbIkoomvuxEX7NpUW
nusrKdWnrD0dlgfbIt743D/hU38tjv2M1yoLJygA3RjryM4Tp+uzKMVC+9RyoyXE
MK9ZBoSihWDuFhWi/2NergXF0cM2zN87vNGhVNP5w1ZchQEOA/W9zIlSOtkfEAP9
=38M2
-----END PGP MESSAGE-----

EOF
  echo "*** Exit code was $? ***" >>test.out
done

exit 0
