// Copyright 2016 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/xfa_basic_data.h"

#include "xfa/fxfa/include/fxfa_basic.h"
#include "xfa/fxfa/parser/xfa_script.h"
#include "xfa/fxfa/parser/xfa_script_datawindow.h"
#include "xfa/fxfa/parser/xfa_script_eventpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_hostpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_layoutpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_logpseudomodel.h"
#include "xfa/fxfa/parser/xfa_script_signaturepseudomodel.h"

const XFA_SCRIPTHIERARCHY g_XFAScriptIndex[] = {
    {0, 0, 0, 2, 316},      {0, 0, 2, 2, 316},       {0, 0, 4, 2, 316},
    {0, 0, 6, 8, 316},      {0, 0, 14, 4, 316},      {0, 0, 18, 5, 317},
    {0, 0, 23, 2, 316},     {0, 0, 25, 1, 316},      {0, 0, 26, 12, 316},
    {0, 0, 38, 2, 316},     {0, 0, 40, 1, 316},      {0, 0, 41, 3, 316},
    {0, 0, 44, 2, 316},     {0, 0, 46, 6, 316},      {0, 0, 52, 0, 316},
    {0, 0, 52, 2, 319},     {0, 0, 54, 2, 316},      {0, 0, 56, 6, 316},
    {0, 0, 62, 0, 316},     {0, 0, 62, 0, 316},      {0, 0, 62, 2, 316},
    {0, 0, 64, 2, 316},     {0, 0, 66, 6, 316},      {0, 0, 72, 4, 316},
    {0, 0, 76, 7, 316},     {0, 0, 83, 2, 320},      {0, 0, 85, 3, 316},
    {0, 0, 88, 3, 316},     {0, 0, 91, 2, 320},      {0, 0, 93, 6, 320},
    {0, 0, 99, 4, 316},     {0, 0, 103, 2, 316},     {0, 0, 105, 3, 319},
    {0, 0, 108, 4, 316},    {0, 0, 112, 3, 316},     {0, 0, 115, 2, 316},
    {0, 0, 117, 6, 316},    {0, 0, 123, 12, 316},    {0, 0, 135, 2, 316},
    {0, 0, 137, 5, 316},    {0, 0, 142, 2, 316},     {0, 0, 144, 3, 316},
    {0, 0, 147, 1, 316},    {0, 0, 148, 14, 316},    {0, 0, 162, 2, 316},
    {0, 0, 164, 2, 316},    {0, 0, 166, 3, 316},     {0, 0, 169, 2, 316},
    {0, 0, 171, 2, 316},    {0, 0, 173, 2, 316},     {0, 0, 175, 4, 316},
    {0, 0, 179, 2, 316},    {0, 0, 181, 2, 316},     {0, 0, 183, 0, 319},
    {0, 0, 183, 20, 316},   {0, 0, 203, 1, 316},     {0, 0, 204, 3, 316},
    {0, 0, 207, 2, 316},    {0, 0, 209, 0, 316},     {0, 0, 209, 2, 316},
    {0, 0, 211, 2, 316},    {0, 0, 213, 4, 320},     {0, 0, 217, 0, 316},
    {0, 0, 217, 1, 316},    {0, 0, 218, 3, 316},     {0, 4, 221, 0, 312},
    {4, 1, 221, 1, 316},    {5, 0, 222, 2, 316},     {5, 1, 224, 3, -1},
    {6, 0, 227, 0, 316},    {6, 0, 227, 2, 316},     {6, 0, 229, 2, 316},
    {6, 0, 231, 3, 316},    {6, 0, 234, 2, 316},     {6, 0, 236, 6, 316},
    {6, 0, 242, 10, 317},   {6, 0, 252, 9, 316},     {6, 0, 261, 5, 318},
    {6, 0, 266, 4, 318},    {6, 0, 270, 2, 316},     {6, 0, 272, 2, 316},
    {6, 0, 274, 5, 316},    {6, 0, 279, 3, 316},     {6, 0, 282, 2, 316},
    {6, 0, 284, 2, 316},    {6, 0, 286, 2, 316},     {6, 0, 288, 2, 316},
    {6, 0, 290, 4, 316},    {6, 0, 294, 3, 316},     {6, 0, 297, 3, 316},
    {6, 0, 300, 2, 316},    {6, 0, 302, 2, 316},     {6, 0, 304, 2, 316},
    {6, 13, 306, 36, 317},  {19, 0, 342, 3, 316},    {19, 0, 345, 2, 316},
    {19, 0, 347, 2, 316},   {19, 0, 349, 2, 316},    {19, 0, 351, 7, 317},
    {19, 2, 358, 16, 312},  {21, 0, 374, 2, 320},    {21, 0, 376, 2, 316},
    {21, 0, 378, 0, 316},   {21, 0, 378, 2, 316},    {21, 0, 380, 6, 316},
    {21, 0, 386, 3, 316},   {21, 0, 389, 2, 316},    {21, 0, 391, 4, 316},
    {21, 0, 395, 0, 316},   {21, 5, 395, 30, 316},   {26, 0, 425, 2, 320},
    {26, 0, 427, 3, 316},   {26, 0, 430, 2, 320},    {26, 0, 432, 5, 316},
    {26, 0, 437, 2, 316},   {26, 0, 439, 3, 316},    {26, 0, 442, 2, 316},
    {26, 0, 444, 8, 316},   {26, 0, 452, 1, 316},    {26, 0, 453, 2, 316},
    {26, 0, 455, 2, 316},   {26, 0, 457, 4, 316},    {26, 0, 461, 0, 316},
    {26, 0, 461, 2, 316},   {26, 0, 463, 2, 316},    {26, 0, 465, 6, 318},
    {26, 5, 471, 31, 317},  {31, 0, 502, 2, 320},    {31, 0, 504, 2, 316},
    {31, 0, 506, 2, 316},   {31, 0, 508, 4, 320},    {31, 16, 512, 14, 312},
    {47, 0, 526, 2, 316},   {47, 0, 528, 2, 316},    {47, 0, 530, 2, 316},
    {47, 0, 532, 2, 316},   {47, 0, 534, 3, 316},    {47, 0, 537, 2, 316},
    {47, 0, 539, 3, 316},   {47, 0, 542, 3, 316},    {47, 0, 545, 4, 318},
    {47, 0, 549, 4, 316},   {47, 0, 553, 2, 316},    {47, 0, 555, 0, 316},
    {47, 0, 555, 2, 316},   {47, 0, 557, 3, 316},    {47, 0, 560, 6, 316},
    {47, 0, 566, 2, 316},   {47, 0, 568, 2, 316},    {47, 0, 570, 3, 316},
    {47, 19, 573, 1, 312},  {66, 0, 574, 2, 316},    {66, 0, 576, 8, 316},
    {66, 0, 584, 2, 316},   {66, 0, 586, 4, 316},    {66, 0, 590, 5, 316},
    {66, 0, 595, 3, 316},   {66, 0, 598, 2, 320},    {66, 0, 600, 3, 316},
    {66, 0, 603, 7, 316},   {66, 0, 610, 3, 316},    {66, 0, 613, 0, 316},
    {66, 0, 613, 4, 317},   {66, 0, 617, 4, 318},    {66, 0, 621, 2, 320},
    {66, 0, 623, 5, 316},   {66, 0, 628, 2, 316},    {66, 0, 630, 2, 316},
    {66, 0, 632, 2, 320},   {66, 0, 634, 2, 320},    {66, 0, 636, 4, 316},
    {66, 0, 640, 2, 316},   {66, 0, 642, 1, 316},    {66, 0, 643, 1, 316},
    {66, 0, 644, 4, 316},   {66, 0, 648, 3, 316},    {66, 7, 651, 2, 319},
    {73, 0, 653, 2, 316},   {73, 0, 655, 2, 316},    {73, 0, 657, 3, 316},
    {73, 4, 660, 4, 312},   {77, 0, 664, 10, 316},   {77, 0, 674, 2, 316},
    {77, 0, 676, 4, 316},   {77, 0, 680, 4, 316},    {77, 0, 684, 3, 316},
    {77, 0, 687, 2, 316},   {77, 0, 689, 2, 316},    {77, 0, 691, 8, 317},
    {77, 0, 699, 3, 316},   {77, 0, 702, 3, 316},    {77, 0, 705, 2, 316},
    {77, 0, 707, 2, 316},   {77, 0, 709, 5, 316},    {77, 0, 714, 4, 316},
    {77, 0, 718, 2, 316},   {77, 0, 720, 8, 318},    {77, 0, 728, 1, 316},
    {77, 0, 729, 2, 320},   {77, 0, 731, 3, 316},    {77, 1, 734, 4, 316},
    {78, 0, 738, 5, 316},   {78, 0, 743, 3, 316},    {78, 0, 746, 1, 316},
    {78, 0, 747, 2, 320},   {78, 0, 749, 0, 313},    {78, 0, 749, 2, 316},
    {78, 5, 751, 3, 316},   {83, 0, 754, 5, 316},    {83, 0, 759, 7, 316},
    {83, 0, 766, 6, 316},   {83, 0, 772, 3, 316},    {83, 0, 775, 2, 316},
    {83, 0, 777, 5, 316},   {83, 0, 782, 2, 316},    {83, 0, 784, 0, 314},
    {83, 0, 784, 2, 316},   {83, 0, 786, 1, 316},    {83, 0, 787, 2, 316},
    {83, 0, 789, 5, 316},   {83, 0, 794, 2, 316},    {83, 0, 796, 1, 316},
    {83, 0, 797, 2, 316},   {83, 0, 799, 2, 316},    {83, 0, 801, 6, 316},
    {83, 0, 807, 2, 316},   {83, 0, 809, 2, 320},    {83, 0, 811, 3, 316},
    {83, 0, 814, 4, 316},   {83, 0, 818, 2, 316},    {83, 0, 820, 2, 316},
    {83, 0, 822, 2, 316},   {83, 0, 824, 2, 316},    {83, 0, 826, 2, 316},
    {83, 0, 828, 2, 316},   {83, 0, 830, 4, 318},    {83, 1, 834, 2, 316},
    {84, 0, 836, 5, 316},   {84, 0, 841, 20, 317},   {84, 0, 861, 2, 316},
    {84, 0, 863, 0, 316},   {84, 0, 863, 2, 316},    {84, 0, 865, 4, 320},
    {84, 0, 869, 0, 316},   {84, 0, 869, 2, 316},    {84, 0, 871, 1, 316},
    {84, 0, 872, 2, 316},   {84, 0, 874, 3, 316},    {84, 0, 877, 2, 316},
    {84, 0, 879, 2, 316},   {84, 0, 881, 4, 316},    {84, 0, 885, 3, 316},
    {84, 0, 888, 17, 316},  {84, 6, 905, 1, 319},    {90, 0, 906, 2, 316},
    {90, 0, 908, 2, 320},   {90, 0, 910, 2, 320},    {90, 0, 912, 2, 316},
    {90, 0, 914, 2, 316},   {90, 0, 916, 4, 318},    {90, 0, 920, 2, 316},
    {90, 5, 922, 0, 312},   {95, 0, 922, 2, 316},    {95, 0, 924, 4, 316},
    {95, 0, 928, 4, 316},   {95, 0, 932, 6, 316},    {95, 0, 938, 2, 316},
    {95, 0, 940, 4, 316},   {95, 0, 944, 3, 316},    {95, 0, 947, 3, 316},
    {95, 0, 950, 2, 316},   {95, 0, 952, 3, 316},    {95, 0, 955, 0, 316},
    {95, 0, 955, 0, 316},   {95, 0, 955, 2, 316},    {95, 0, 957, 7, 316},
    {95, 0, 964, 2, 316},   {95, 0, 966, 0, 319},    {95, 0, 966, 7, 316},
    {95, 0, 973, 2, 316},   {95, 0, 975, 2, 316},    {95, 3, 977, 1, 316},
    {98, 0, 978, 2, 320},   {98, 0, 980, 4, 316},    {98, 0, 984, 0, 316},
    {98, 0, 984, 2, 316},   {98, 0, 986, 2, 316},    {98, 0, 988, 4, 316},
    {98, 0, 992, 1, 316},   {98, 0, 993, 2, 316},    {98, 0, 995, 2, 316},
    {98, 0, 997, 3, 316},   {98, 0, 1000, 2, 317},   {98, 0, 1002, 0, 316},
    {98, 0, 1002, 4, 316},  {98, 0, 1006, 4, 316},   {98, 0, 1010, 2, 316},
    {98, 0, 1012, 3, 316},  {98, 0, 1015, 4, 316},   {98, 0, 1019, 7, 316},
    {98, 0, 1026, 4, 316},  {98, 0, 1030, 1, 313},   {98, 17, 1031, 3, 316},
    {115, 0, 1034, 5, 316}, {115, 0, 1039, 2, 316},  {115, 0, 1041, 1, 316},
    {115, 0, 1042, 4, 316}, {115, 0, 1046, 2, 316},  {115, 0, 1048, 2, 316},
    {115, 0, 1050, 1, 316}, {115, 0, 1051, 2, 316},  {115, 0, 1053, 5, 316},
    {115, 0, 1058, 1, -1},  {115, 4, 1059, 1, 312},  {119, 1, 1060, 0, 313},
    {120, 2, 1060, 8, 312}, {122, 11, 1068, 6, 315}, {133, 2, 1074, 0, 316},
    {135, 0, 1074, 0, 316}, {135, 3, 1074, 2, 316},  {138, 0, 1076, 2, 316},
};

const XFA_METHODINFO g_SomMethodData[] = {
    {0x3c752495, L"verify",
     (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::Verify},
    {0xa68635f1, L"sign",
     (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::Sign},
    {0xa7f2c5e6, L"enumerate",
     (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::Enumerate},
    {0xd8ed1467, L"clear",
     (XFA_METHOD_CALLBACK)&CScript_SignaturePseudoModel::Clear},
    {0x4bdcce13, L"execute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_WsdlConnection_Execute},
    {0x1c296ba4, L"restore",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Delta_Restore},
    {0x7d123a9, L"clearItems",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ClearItems},
    {0xfb0b007, L"execEvent",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecEvent},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecInitialize},
    {0x7bb919c2, L"deleteItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_DeleteItem},
    {0x9f053d5e, L"getSaveItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_GetSaveItem},
    {0xbbd32747, L"boundItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_BoundItem},
    {0xc492d950, L"getItemState",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_GetItemState},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecCalculate},
    {0xd8930d0e, L"setItems",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_SetItems},
    {0xe0f15045, L"getDisplayItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_GetDisplayItem},
    {0xe23acddc, L"setItemState",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_SetItemState},
    {0xe2dfb2f8, L"addItem",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_AddItem},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Field_ExecValidate},
    {0x461079ef, L"emit", (XFA_METHOD_CALLBACK)&CScript_EventPseudoModel::Emit},
    {0xfec90c63, L"reset",
     (XFA_METHOD_CALLBACK)&CScript_EventPseudoModel::Reset},
    {0xfb0b007, L"execEvent",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecEvent},
    {0x3d832221, L"selectedMember",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_SelectedMember},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecInitialize},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecCalculate},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ExclGroup_ExecValidate},
    {0xfb0b007, L"execEvent",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecEvent},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecInitialize},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecCalculate},
    {0xd9b9b1f1, L"getInvalidObjects",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_GetInvalidObjects},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Subform_ExecValidate},
    {0xa366b7c, L"exportData",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::ExportData},
    {0x16cc226c, L"gotoURL",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::GotoURL},
    {0x1e0722f5, L"pageDown",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::PageDown},
    {0x3e66cb2c, L"setFocus",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::SetFocus},
    {0x4ac9faae, L"openList",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::OpenList},
    {0x7b89714f, L"response",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::Response},
    {0x7fd9fd58, L"documentInBatch",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::DocumentInBatch},
    {0xaf1d019d, L"resetData",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::ResetData},
    {0xb07be13c, L"beep", (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::Beep},
    {0xb1882ca0, L"getFocus",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::GetFocus},
    {0xbf4ba9ee, L"messageBox",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::MessageBox},
    {0xd6d4dbc1, L"documentCountInBatch",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::DocumentCountInBatch},
    {0xdd7676ed, L"print",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::Print},
    {0xe2f863d0, L"currentDateTime",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::CurrentDateTime},
    {0xf995d0f5, L"importData",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::ImportData},
    {0xfeb96b62, L"pageUp",
     (XFA_METHOD_CALLBACK)&CScript_HostPseudoModel::PageUp},
    {0x68, L"h", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::H},
    {0x77, L"w", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::W},
    {0x78, L"x", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::X},
    {0x79, L"y", (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::Y},
    {0x5460206, L"pageCount",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::PageCount},
    {0x5eb5b0f, L"pageSpan",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::PageSpan},
    {0x10f1b1bd, L"page",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::Page},
    {0x1c1e6318, L"pageContent",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::PageContent},
    {0x1c1f4a5c, L"absPageCount",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::AbsPageCount},
    {0x1ec47db5, L"absPageCountInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::AbsPageCountInBatch},
    {0x2e4ecbdb, L"sheetCountInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::SheetCountInBatch},
    {0x2fcff4b5, L"relayout",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::Relayout},
    {0x3bf1c2a5, L"absPageSpan",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::AbsPageSpan},
    {0x5775c2cc, L"absPageInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::AbsPageInBatch},
    {0x8c5feb32, L"sheetInBatch",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::SheetInBatch},
    {0x8f3a8379, L"sheet",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::Sheet},
    {0x96f3c4cb, L"relayoutPageArea",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::RelayoutPageArea},
    {0xd2a4a542, L"sheetCount",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::SheetCount},
    {0xe74f0653, L"absPage",
     (XFA_METHOD_CALLBACK)&CScript_LayoutPseudoModel::AbsPage},
    {0x44c352ad, L"formNodes",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_FormNodes},
    {0x45efb847, L"remerge",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_Remerge},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_ExecInitialize},
    {0x712c6afa, L"createNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_CreateNode},
    {0xa8a35e25, L"recalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_Recalculate},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_ExecCalculate},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Template_ExecValidate},
    {0x4cc1c0f9, L"moveCurrentRecord",
     (XFA_METHOD_CALLBACK)&CScript_DataWindow::MoveCurrentRecord},
    {0x5779d65f, L"record", (XFA_METHOD_CALLBACK)&CScript_DataWindow::Record},
    {0x8a476498, L"gotoRecord",
     (XFA_METHOD_CALLBACK)&CScript_DataWindow::GotoRecord},
    {0xaac241c8, L"isRecordGroup",
     (XFA_METHOD_CALLBACK)&CScript_DataWindow::IsRecordGroup},
    {0x1c6f4277, L"evaluate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Manifest_Evaluate},
    {0x2afec2cc, L"moveInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_MoveInstance},
    {0x2bf94a63, L"removeInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_RemoveInstance},
    {0x303adaf4, L"setInstances",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_SetInstances},
    {0x4d76b89e, L"addInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_AddInstance},
    {0xc660dc8a, L"insertInstance",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_InstanceManager_InsertInstance},
    {0xddfd1ea1, L"metadata",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Desc_Metadata},
    {0x44c352ad, L"formNodes",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_FormNodes},
    {0x45efb847, L"remerge",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_Remerge},
    {0x6716ce97, L"execInitialize",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_ExecInitialize},
    {0xa8a35e25, L"recalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_Recalculate},
    {0xc6013cd3, L"execCalculate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_ExecCalculate},
    {0xef8ce48f, L"execValidate",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Form_ExecValidate},
    {0x60490a85, L"message",
     (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::Message},
    {0x60ecfcc9, L"traceDeactivate",
     (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::TraceDeactivate},
    {0x86a0f4c0, L"traceActivate",
     (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::TraceActivate},
    {0x93eac39a, L"traceEnabled",
     (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::TraceEnabled},
    {0xd1227e6f, L"trace", (XFA_METHOD_CALLBACK)&CScript_LogPseudoModel::Trace},
    {0x36c0ee14, L"getAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Packet_GetAttribute},
    {0x5468e2a0, L"setAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Packet_SetAttribute},
    {0xadc48de2, L"removeAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Packet_RemoveAttribute},
    {0x3848b3f, L"next", (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Next},
    {0x14e25bc8, L"cancelBatch",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_CancelBatch},
    {0x3ce05d68, L"first",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_First},
    {0x649e1e65, L"updateBatch",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_UpdateBatch},
    {0x6a3405dd, L"previous",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Previous},
    {0x74818fb3, L"isBOF",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_IsBOF},
    {0x74d07a76, L"isEOF",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_IsEOF},
    {0x7613cb66, L"cancel",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Cancel},
    {0x7baca2e3, L"update",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Update},
    {0x8b90e1f2, L"open", (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Open},
    {0x9c6471b3, L"delete",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Delete},
    {0xa7315093, L"addNew",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_AddNew},
    {0xa7ce5f8d, L"requery",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Requery},
    {0xc7368674, L"resync",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Resync},
    {0xd9f47f36, L"close",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Close},
    {0xf54481d4, L"last", (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_Last},
    {0xf7965460, L"hasDataChanged",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_Source_HasDataChanged},
    {0x6275f6af, L"item",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Item},
    {0x7033bfd5, L"insert",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Insert},
    {0x9cab7cae, L"remove",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Remove},
    {0xda12e518, L"append",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_ListClass_Append},
    {0xd892a054, L"namedItem",
     (XFA_METHOD_CALLBACK)&CXFA_NodeList::Script_TreelistClass_NamedItem},
    {0xba2dd386, L"resolveNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_TreeClass_ResolveNode},
    {0xe509e2b9, L"resolveNodes",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_TreeClass_ResolveNodes},
    {0x1bca1ebd, L"applyXSL",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_ApplyXSL},
    {0x36c0ee14, L"getAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_GetAttribute},
    {0x5468e2a0, L"setAttribute",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SetAttribute},
    {0x5ee00996, L"setElement",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SetElement},
    {0x92dada4f, L"saveFilteredXML",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SaveFilteredXML},
    {0x9c456500, L"saveXML",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_SaveXML},
    {0xabd3200a, L"getElement",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_GetElement},
    {0xb269c60d, L"isPropertySpecified",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_IsPropertySpecified},
    {0xb528be91, L"loadXML",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_LoadXML},
    {0xd9f46591, L"clone",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_Clone},
    {0xe006a76b, L"assignNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_NodeClass_AssignNode},
    {0x7303fcea, L"getDelta",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ContainerClass_GetDelta},
    {0xe7742c9d, L"getDeltas",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ContainerClass_GetDeltas},
    {0x30ff6aad, L"clearErrorList",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ModelClass_ClearErrorList},
    {0x712c6afa, L"createNode",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ModelClass_CreateNode},
    {0x83a6411d, L"isCompatibleNS",
     (XFA_METHOD_CALLBACK)&CXFA_Node::Script_ModelClass_IsCompatibleNS},
};
const int32_t g_iSomMethodCount =
    sizeof(g_SomMethodData) / sizeof(XFA_METHODINFO);

const XFA_SCRIPTATTRIBUTEINFO g_SomAttributeData[] = {
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb3543a6, L"max",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Max, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x45a6daf8, L"eofAction",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EofAction, XFA_SCRIPT_Basic},
    {0x5ec958c0, L"cursorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CursorType, XFA_SCRIPT_Basic},
    {0x79975f2b, L"lockType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LockType, XFA_SCRIPT_Basic},
    {0xa5340ff5, L"bofAction",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BofAction, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc5762157, L"cursorLocation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CursorLocation, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1ee2d24d, L"instanceIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_InstanceIndex, -1,
     XFA_SCRIPT_Basic},
    {0x8c99377e, L"relation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relation, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x3106c3a, L"beforeTarget",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BeforeTarget, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x13a08bdb, L"overflowTarget",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverflowTarget, XFA_SCRIPT_Basic},
    {0x169134a1, L"overflowLeader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverflowLeader, XFA_SCRIPT_Basic},
    {0x20914367, L"overflowTrailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverflowTrailer, XFA_SCRIPT_Basic},
    {0x453eaf38, L"startNew",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartNew, XFA_SCRIPT_Basic},
    {0x64110ab5, L"bookendTrailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BookendTrailer, XFA_SCRIPT_Basic},
    {0xb6b44172, L"after",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_After, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc3c1442f, L"bookendLeader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BookendLeader, XFA_SCRIPT_Basic},
    {0xcb150479, L"afterTarget",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AfterTarget, XFA_SCRIPT_Basic},
    {0xf4ffce73, L"before",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Before, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue_Read, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x47cfa43a, L"allowNeutral",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AllowNeutral, XFA_SCRIPT_Basic},
    {0x7c2fd80b, L"mark",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Mark, XFA_SCRIPT_Basic},
    {0x8ed182d1, L"shape",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Shape, XFA_SCRIPT_Basic},
    {0xa686975b, L"size",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Size, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5c054755, L"startAngle",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartAngle, XFA_SCRIPT_Basic},
    {0x74788f8b, L"sweepAngle",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SweepAngle, XFA_SCRIPT_Basic},
    {0x9d833d75, L"circular",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Circular, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xb0e5485d, L"bind",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Bind, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xcd7f7b54, L"from",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_From, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8e29d794, L"signatureType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SignatureType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe11a2cbc, L"permissions",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Permissions, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x453eaf38, L"startNew",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartNew, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xa6118c89, L"targetType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TargetType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x2d574d58, L"this", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Xfa_This,
     -1, XFA_SCRIPT_Object},
    {0x4fdc3454, L"timeStamp",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TimeStamp, XFA_SCRIPT_Basic},
    {0xb598a1f7, L"uuid",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Uuid, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xcfea02e, L"leftInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LeftInset, XFA_SCRIPT_Basic},
    {0x1356caf8, L"bottomInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BottomInset, XFA_SCRIPT_Basic},
    {0x25764436, L"topInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TopInset, XFA_SCRIPT_Basic},
    {0x8a692521, L"rightInset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RightInset, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1e459b8f, L"nonRepudiation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_NonRepudiation, XFA_SCRIPT_Basic},
    {0x2bb3f470, L"encipherOnly",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EncipherOnly, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x5f760b50, L"digitalSignature",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DigitalSignature, XFA_SCRIPT_Basic},
    {0x69aa2292, L"crlSign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CrlSign, XFA_SCRIPT_Basic},
    {0x98fd4d81, L"keyAgreement",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KeyAgreement, XFA_SCRIPT_Basic},
    {0xa66404cb, L"keyEncipherment",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KeyEncipherment, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xca5dc27c, L"dataEncipherment",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataEncipherment, XFA_SCRIPT_Basic},
    {0xe8f118a8, L"keyCertSign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KeyCertSign, XFA_SCRIPT_Basic},
    {0xfea53ec6, L"decipherOnly",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DecipherOnly, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8b90e1f2, L"open",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Open, XFA_SCRIPT_Basic},
    {0x957fa006, L"commitOn",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CommitOn, XFA_SCRIPT_Basic},
    {0xb12128b7, L"textEntry",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextEntry, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0x8d4f1c7, L"textIndent",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextIndent, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2a82d99c, L"marginRight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MarginRight, XFA_SCRIPT_Basic},
    {0x534729c9, L"marginLeft",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MarginLeft, XFA_SCRIPT_Basic},
    {0x5739d1ff, L"radixOffset",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RadixOffset, XFA_SCRIPT_Basic},
    {0x577682ac, L"preserve",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Preserve, XFA_SCRIPT_Basic},
    {0x731e0665, L"spaceBelow",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SpaceBelow, XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x836d4d7c, L"tabDefault",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TabDefault, XFA_SCRIPT_Basic},
    {0x8fa01790, L"tabStops",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TabStops, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd4b01921, L"lineHeight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LineHeight, XFA_SCRIPT_Basic},
    {0xe18b5659, L"spaceAbove",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SpaceAbove, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd861f8af, L"addRevocationInfo",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AddRevocationInfo, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6128d8d, L"activity",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Activity, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x43e349b, L"dataRowCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataRowCount, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x28e17e91, L"dataPrep",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataPrep, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x3650557e, L"textLocation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextLocation, XFA_SCRIPT_Basic},
    {0x3b582286, L"moduleWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ModuleWidth, XFA_SCRIPT_Basic},
    {0x52666f1c, L"printCheckDigit",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PrintCheckDigit, XFA_SCRIPT_Basic},
    {0x5404d6df, L"moduleHeight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ModuleHeight, XFA_SCRIPT_Basic},
    {0x5ab23b6c, L"startChar",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartChar, XFA_SCRIPT_Basic},
    {0x7c732a66, L"truncate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Truncate, XFA_SCRIPT_Basic},
    {0x8d181d61, L"wideNarrowRatio",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_WideNarrowRatio, XFA_SCRIPT_Basic},
    {0x99800d7a, L"errorCorrectionLevel",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ErrorCorrectionLevel, XFA_SCRIPT_Basic},
    {0x9a63da3d, L"upsMode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UpsMode, XFA_SCRIPT_Basic},
    {0xaf754613, L"checksum",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Checksum, XFA_SCRIPT_Basic},
    {0xb045fbc5, L"charEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CharEncoding, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc035c6b1, L"dataColumnCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataColumnCount, XFA_SCRIPT_Basic},
    {0xd3c84d25, L"rowColumnRatio",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RowColumnRatio, XFA_SCRIPT_Basic},
    {0xd57c513c, L"dataLength",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataLength, XFA_SCRIPT_Basic},
    {0xf575ca75, L"endChar",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EndChar, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x28dee6e9, L"format",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Format, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x60d4c8b1, L"output",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Output, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6a39990, L"input",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Input, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x2b5df51e, L"dataDescription",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataDescription, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x6c0d9600, L"currentValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Delta_CurrentValue, -1,
     XFA_SCRIPT_Basic},
    {0x942643f0, L"savedValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Delta_SavedValue, -1,
     XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Delta_Target, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd4cc53f8, L"highlight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Highlight, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x5518c25, L"break",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Break, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1059ec18, L"level",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_Integer,
     XFA_ATTRIBUTE_Level, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f105f72, L"wordCharacterCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_WordCharacterCount, XFA_SCRIPT_Basic},
    {0x3d123c26, L"hyphenate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hyphenate, XFA_SCRIPT_Basic},
    {0x66539c48, L"excludeInitialCap",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ExcludeInitialCap, XFA_SCRIPT_Basic},
    {0x6a95c976, L"pushCharacterCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PushCharacterCount, XFA_SCRIPT_Basic},
    {0x982bd892, L"remainCharacterCount",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RemainCharacterCount, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe5c96d6a, L"excludeAllCaps",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ExcludeAllCaps, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8af2e657, L"maxChars",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxChars, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc080cd3, L"url",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Url, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa6710262, L"credentialServerPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CredentialServerPolicy, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc2ba0923, L"urlPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UrlPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x78bff531, L"numberOfCells",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_Integer,
     XFA_ATTRIBUTE_NumberOfCells, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1abbd7e0, L"dataNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DataNode, -1,
     XFA_SCRIPT_Object},
    {0x25839852, L"access",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Access, XFA_SCRIPT_Basic},
    {0x2ee7678f, L"rotate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Rotate, XFA_SCRIPT_Basic},
    {0x3b1ddd06, L"fillColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FillColor, -1,
     XFA_SCRIPT_Basic},
    {0x54c399e3, L"formattedValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_FormattedValue, -1,
     XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x5a3b375d, L"borderColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderColor, -1,
     XFA_SCRIPT_Basic},
    {0x5e936ed6, L"fontColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FontColor, -1,
     XFA_SCRIPT_Basic},
    {0x6826c408, L"parentSubform",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_ParentSubform, -1,
     XFA_SCRIPT_Basic},
    {0x79b67434, L"mandatoryMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_MandatoryMessage, -1,
     XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x85fd6faf, L"mandatory",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_Mandatory, -1,
     XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0x964fb42e, L"formatMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_FormatMessage, -1,
     XFA_SCRIPT_Basic},
    {0xa03cf627, L"rawValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xa60dd202, L"length",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_Length, -1,
     XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbc8fa350, L"locale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Locale, XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xc4fed09b, L"accessKey",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AccessKey, XFA_SCRIPT_Basic},
    {0xcabfa3d0, L"validationMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_ValidationMessage, -1,
     XFA_SCRIPT_Basic},
    {0xdcecd663, L"editValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_EditValue, -1,
     XFA_SCRIPT_Basic},
    {0xe07e5061, L"selectedIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Field_SelectedIndex, -1,
     XFA_SCRIPT_Basic},
    {0xf65e34be, L"borderWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderWidth, -1,
     XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd843798, L"fullText",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::FullText, -1,
     XFA_SCRIPT_Basic},
    {0x1b6d1cf5, L"reenter",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::Reenter, -1,
     XFA_SCRIPT_Basic},
    {0x1e6ffa9a, L"prevContentType",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::PrevContentType, -1,
     XFA_SCRIPT_Basic},
    {0x25a3c206, L"soapFaultString",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::SoapFaultString, -1,
     XFA_SCRIPT_Basic},
    {0x2e00c007, L"newContentType",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::NewContentType, -1,
     XFA_SCRIPT_Basic},
    {0x4570500f, L"modifier",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::Modifier, -1,
     XFA_SCRIPT_Basic},
    {0x50e2e33b, L"selEnd",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::SelEnd, -1,
     XFA_SCRIPT_Basic},
    {0x57de87c2, L"prevText",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::PrevText, -1,
     XFA_SCRIPT_Basic},
    {0x6ea04e0a, L"soapFaultCode",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::SoapFaultCode, -1,
     XFA_SCRIPT_Basic},
    {0x6f6556cf, L"newText",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::NewText, -1,
     XFA_SCRIPT_Basic},
    {0x891f4606, L"change",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::Change, -1,
     XFA_SCRIPT_Basic},
    {0x8fa3c19e, L"shift",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::Shift, -1,
     XFA_SCRIPT_Basic},
    {0xa9d9b2e1, L"keyDown",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::KeyDown, -1,
     XFA_SCRIPT_Basic},
    {0xbfc89db2, L"selStart",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::SelStart, -1,
     XFA_SCRIPT_Basic},
    {0xc32a5812, L"commitKey",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::CommitKey, -1,
     XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_EventPseudoModel::Target, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xa2e3514, L"cap",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Cap, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5392ea58, L"stroke",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Stroke, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x94446dcc, L"thickness",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Thickness, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1ec8ab2c, L"rate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Rate, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x7b29630a, L"sourceBelow",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SourceBelow, XFA_SCRIPT_Basic},
    {0x8fc36c0a, L"outputBelow",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OutputBelow, XFA_SCRIPT_Basic},
    {0xe996b2fe, L"sourceAbove",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_SourceAbove, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xf23332f, L"errorText",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_ErrorText, -1,
     XFA_SCRIPT_Basic},
    {0x1abbd7e0, L"dataNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DataNode, -1,
     XFA_SCRIPT_Object},
    {0x25839852, L"access",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Access, XFA_SCRIPT_Basic},
    {0x3b1ddd06, L"fillColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FillColor, -1,
     XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x5a3b375d, L"borderColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderColor, -1,
     XFA_SCRIPT_Basic},
    {0x79b67434, L"mandatoryMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_MandatoryMessage, -1,
     XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x7e7e845e, L"layout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Layout, XFA_SCRIPT_Basic},
    {0x846599f8, L"transient",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_Transient, -1,
     XFA_SCRIPT_Basic},
    {0x85fd6faf, L"mandatory",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_Mandatory, -1,
     XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xa03cf627, L"rawValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_DefaultAndRawValue,
     -1, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ExclGroup_DefaultAndRawValue,
     -1, XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xc4fed09b, L"accessKey",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AccessKey, XFA_SCRIPT_Basic},
    {0xcabfa3d0, L"validationMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_ValidationMessage, -1,
     XFA_SCRIPT_Basic},
    {0xf65e34be, L"borderWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderWidth, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xeda9017a, L"scope",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Scope, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0x6cfa828a, L"runAt",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RunAt, XFA_SCRIPT_Basic},
    {0xa1b0d2f5, L"executeType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ExecuteType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x54fa722c, L"transferEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TransferEncoding, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue_Read, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd171b240, L"aspect",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Aspect, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue_Read, -1,
     XFA_SCRIPT_Basic},
    {0xdb55fec5, L"href",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Href, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x7f6fd3d7, L"server",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Server, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x4b8bc840, L"fracDigits",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FracDigits, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xde7f92ba, L"leadDigits",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LeadDigits, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1414d431, L"allowMacro",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AllowMacro, XFA_SCRIPT_Basic},
    {0x1517dfa1, L"columnWidths",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColumnWidths, XFA_SCRIPT_Basic},
    {0x1abbd7e0, L"dataNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DataNode, -1,
     XFA_SCRIPT_Object},
    {0x1ee2d24d, L"instanceIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_InstanceIndex, -1,
     XFA_SCRIPT_Basic},
    {0x25839852, L"access",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Access, XFA_SCRIPT_Basic},
    {0x3b1ddd06, L"fillColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_FillColor, -1,
     XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x5a3b375d, L"borderColor",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderColor, -1,
     XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x7e7e845e, L"layout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Layout, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0x9cc17d75, L"mergeMode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MergeMode, XFA_SCRIPT_Basic},
    {0x9f3e9510, L"instanceManager",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Subform_InstanceManager, -1,
     XFA_SCRIPT_Object},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbc8fa350, L"locale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Subform_Locale, -1,
     XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xcabfa3d0, L"validationMessage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_ValidationMessage, -1,
     XFA_SCRIPT_Basic},
    {0xe4c3a5e5, L"restoreState",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RestoreState, XFA_SCRIPT_Basic},
    {0xeda9017a, L"scope",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Scope, XFA_SCRIPT_Basic},
    {0xf65e34be, L"borderWidth",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_BorderWidth, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0x5a50e9e6, L"version",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Handler_Version, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x4107ed, L"foxitAppType",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::FoxitAppType, -1,
     XFA_SCRIPT_Basic},
    {0x31b19c1, L"name", (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::Name,
     -1, XFA_SCRIPT_Basic},
    {0x66c1ae9, L"validationsEnabled",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::ValidationsEnabled, -1,
     XFA_SCRIPT_Basic},
    {0x14d04502, L"title",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::Title, -1,
     XFA_SCRIPT_Basic},
    {0x193afe8b, L"foxitName",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::FoxitName, -1,
     XFA_SCRIPT_Basic},
    {0x392ae445, L"platform",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::Platform, -1,
     XFA_SCRIPT_Basic},
    {0x5a50e9e6, L"version",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::Version, -1,
     XFA_SCRIPT_Basic},
    {0x66cb1eed, L"variation",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::Variation, -1,
     XFA_SCRIPT_Basic},
    {0x7717cbc4, L"language",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::Language, -1,
     XFA_SCRIPT_Basic},
    {0x86698963, L"appType",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::AppType, -1,
     XFA_SCRIPT_Basic},
    {0x94ff9e8d, L"calculationsEnabled",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::CalculationsEnabled, -1,
     XFA_SCRIPT_Basic},
    {0xbcd44940, L"currentPage",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::CurrentPage, -1,
     XFA_SCRIPT_Basic},
    {0xd4286870, L"foxitVersion",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::FoxitVersion, -1,
     XFA_SCRIPT_Basic},
    {0xd592b920, L"numPages",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_HostPseudoModel::NumPages, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x24d85167, L"timeout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Timeout, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x7d9fd7c5, L"mode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Mode, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x7d9fd7c5, L"mode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_SubmitFormat_Mode, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2038c9b2, L"role",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Role, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xfcef86b5, L"ready",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_LayoutPseudoModel::Ready, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5392ea58, L"stroke",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Stroke, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x7b95e661, L"inverted",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Inverted, XFA_SCRIPT_Basic},
    {0x94446dcc, L"thickness",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Thickness, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe8dddf50, L"join",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Join, XFA_SCRIPT_Basic},
    {0xe948b9a8, L"radius",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Radius, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xabfa6c4f, L"cSpace",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CSpace, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0x3848b3f, L"next",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Next, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x6a3405dd, L"previous",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Previous, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf6b59543, L"intact",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Intact, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x268b7ec1, L"commandType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CommandType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbde9abda, L"data",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Data, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x5b707a35, L"scriptTest",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ScriptTest, XFA_SCRIPT_Basic},
    {0x6b6ddcfb, L"nullTest",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_NullTest, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xe64b1129, L"formatTest",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FormatTest, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8c99377e, L"relation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relation, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x25363, L"to",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_To, XFA_SCRIPT_Basic},
    {0x66642f8f, L"force",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Force, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xcd7f7b54, L"from",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_From, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0x2b5df51e, L"dataDescription",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataDescription, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x226ca8f1, L"operation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Operation, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xfb67185, L"recordsBefore",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::RecordsBefore, -1,
     XFA_SCRIPT_Basic},
    {0x21d5dfcb, L"currentRecordNumber",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::CurrentRecordNumber, -1,
     XFA_SCRIPT_Basic},
    {0x312af044, L"recordsAfter",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::RecordsAfter, -1,
     XFA_SCRIPT_Basic},
    {0x6aab37cb, L"isDefined",
     (XFA_ATTRIBUTE_CALLBACK)&CScript_DataWindow::IsDefined, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x6cfa828a, L"runAt",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_RunAt, XFA_SCRIPT_Basic},
    {0xa021b738, L"stateless",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Script_Stateless, -1,
     XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xadc4c77b, L"binding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Binding, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x7a0cc471, L"passwordChar",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PasswordChar, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x14a32d52, L"pagePosition",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_PagePosition, XFA_SCRIPT_Basic},
    {0x8340ea66, L"oddOrEven",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OddOrEven, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xa85e74f3, L"initialNumber",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_InitialNumber, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe9ba472, L"numbered",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Numbered, XFA_SCRIPT_Basic},
    {0xd70798c2, L"blankOrNotBlank",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BlankOrNotBlank, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x34ae103c, L"reserve",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Reserve, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf2009339, L"placement",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Placement, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x54fa722c, L"transferEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TransferEncoding, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc4547a08, L"maxLength",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxLength, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xdb55fec5, L"href",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Href, XFA_SCRIPT_Basic},
    {0x29418bb7, L"abbr",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Abbr, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf531b059, L"writingScript",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_WritingScript, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1b8dce3e, L"action",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Action, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb3543a6, L"max",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_InstanceManager_Max, -1,
     XFA_SCRIPT_Basic},
    {0xb356ca4, L"min",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_InstanceManager_Min, -1,
     XFA_SCRIPT_Basic},
    {0x6f544d49, L"count",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_InstanceManager_Count, -1,
     XFA_SCRIPT_Basic},
    {0x25363, L"to",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_To, XFA_SCRIPT_Basic},
    {0xa0933954, L"unicodeRange",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UnicodeRange, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xcd7f7b54, L"from",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_From, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x4ef3d02c, L"orientation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Orientation, XFA_SCRIPT_Basic},
    {0x65e30c67, L"imagingBBox",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ImagingBBox, XFA_SCRIPT_Basic},
    {0x9041d4b0, L"short",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Short, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe349d044, L"stock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Stock, XFA_SCRIPT_Basic},
    {0xf6b4afb0, L"long",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Long, XFA_SCRIPT_Basic},
    {0x5ce6195, L"vScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VScrollPolicy, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x1ef3a64a, L"allowRichText",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AllowRichText, XFA_SCRIPT_Basic},
    {0x5a32e493, L"multiLine",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MultiLine, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe6f99487, L"hScrollPolicy",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HScrollPolicy, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xd52482e0, L"maxEntries",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxEntries, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x8855805f, L"contains",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Contains, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xe372ae97, L"isNull",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_IsNull, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x2b5df51e, L"dataDescription",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DataDescription, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x226ca8f1, L"operation",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Operation, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x42fed1fd, L"contentType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ContentType, XFA_SCRIPT_Basic},
    {0x54fa722c, L"transferEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TransferEncoding, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xf197844d, L"match",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Match, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x28dee6e9, L"format",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Encrypt_Format, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x68, L"h", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_H, XFA_SCRIPT_Basic},
    {0x77, L"w", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_W, XFA_SCRIPT_Basic},
    {0x78, L"x", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_X, XFA_SCRIPT_Basic},
    {0x79, L"y", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Y, XFA_SCRIPT_Basic},
    {0x2282c73, L"hAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_HAlign, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2ee7678f, L"rotate",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Rotate, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0x7a7cc341, L"vAlign",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_VAlign, XFA_SCRIPT_Basic},
    {0x7c2ff6ae, L"maxH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxH, XFA_SCRIPT_Basic},
    {0x7c2ff6bd, L"maxW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MaxW, XFA_SCRIPT_Basic},
    {0x7d02356c, L"minH",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinH, XFA_SCRIPT_Basic},
    {0x7d02357b, L"minW",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_MinW, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xa03cf627, L"rawValue",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xac06e2b0, L"colSpan",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ColSpan, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbc8fa350, L"locale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Locale, XFA_SCRIPT_Basic},
    {0xc2bd40fd, L"anchorType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_AnchorType, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x39cdb0a2, L"priority",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Priority, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xeb511b54, L"disable",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Disable, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Value, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xcb0ac9, L"lineThrough",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LineThrough, XFA_SCRIPT_Basic},
    {0x2c1c7f1, L"typeface",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Typeface, XFA_SCRIPT_Basic},
    {0x8c74ae9, L"fontHorizontalScale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FontHorizontalScale, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2cd79033, L"kerningMode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_KerningMode, XFA_SCRIPT_Basic},
    {0x3a0273a6, L"underline",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Underline, XFA_SCRIPT_Basic},
    {0x4873c601, L"baselineShift",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_BaselineShift, XFA_SCRIPT_Basic},
    {0x4b319767, L"overlinePeriod",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_OverlinePeriod, XFA_SCRIPT_Basic},
    {0x79543055, L"letterSpacing",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LetterSpacing, XFA_SCRIPT_Basic},
    {0x8ec6204c, L"lineThroughPeriod",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LineThroughPeriod, XFA_SCRIPT_Basic},
    {0x907c7719, L"fontVerticalScale",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_FontVerticalScale, XFA_SCRIPT_Basic},
    {0xa686975b, L"size",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Size, XFA_SCRIPT_Basic},
    {0xb5e49bf2, L"posture",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Posture, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbd6e1d88, L"weight",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Weight, XFA_SCRIPT_Basic},
    {0xbd96a0e9, L"underlinePeriod",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_UnderlinePeriod, XFA_SCRIPT_Basic},
    {0xc0ec9fa4, L"overline",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Overline, XFA_SCRIPT_Basic},
    {0xaf754613, L"checksum",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Form_Checksum, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x8e1c2921, L"relevant",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Relevant, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xea7090a0, L"override",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Override, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x60a61edd, L"codeType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CodeType, XFA_SCRIPT_Basic},
    {0xb373a862, L"archive",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Archive, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xe1a26b56, L"codeBase",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_CodeBase, XFA_SCRIPT_Basic},
    {0xeb091003, L"classId",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ClassId, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0xc39a88bd, L"labelRef",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_LabelRef, XFA_SCRIPT_Basic},
    {0xd50f903a, L"valueRef",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_ValueRef, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xea7090a0, L"override",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Override, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Extras_Type, -1,
     XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x24d85167, L"timeout",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Timeout, XFA_SCRIPT_Basic},
    {0x47d03490, L"connection",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Connection, XFA_SCRIPT_Basic},
    {0x552d9ad5, L"usage",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usage, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc860f30a, L"delayedOpen",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_DelayedOpen, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x28dee6e9, L"format",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Format, XFA_SCRIPT_Basic},
    {0x824f21b7, L"embedPDF",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_EmbedPDF, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xdc75676c, L"textEncoding",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TextEncoding, XFA_SCRIPT_Basic},
    {0xf889e747, L"xdpContent",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_XdpContent, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x97be91b, L"content",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Packet_Content, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x4156ee3f, L"delimiter",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Delimiter, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x2f16a382, L"type",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Type, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x453eaf38, L"startNew",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_StartNew, XFA_SCRIPT_Basic},
    {0x9dcc3ab3, L"trailer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Trailer, XFA_SCRIPT_Basic},
    {0xa6118c89, L"targetType",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_TargetType, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xc8da4da7, L"target",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Target, XFA_SCRIPT_Basic},
    {0xcbcaf66d, L"leader",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Leader, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xabef37e3, L"slope",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Slope, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xd996fa9b, L"hand",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Hand, XFA_SCRIPT_Basic},
    {0xa60dd202, L"length",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_NodeList::Script_ListClass_Length, -1,
     XFA_SCRIPT_Basic},
    {0x20146, L"db", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Source_Db, -1,
     XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb3543a6, L"max", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Occur_Max,
     -1, XFA_SCRIPT_Basic},
    {0xb356ca4, L"min", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Occur_Min,
     -1, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x7d0b5fca, L"initial",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Initial, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x29418bb7, L"abbr",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Abbr, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0xbe52dfbf, L"desc",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Desc, XFA_SCRIPT_Basic},
    {0xf6b47749, L"lock",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_BOOL,
     XFA_ATTRIBUTE_Lock, XFA_SCRIPT_Basic},
    {0xbb8df5d, L"ref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Ref, XFA_SCRIPT_Basic},
    {0xc0811ed, L"use",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Use, XFA_SCRIPT_Basic},
    {0x570ce835, L"presence",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Presence, XFA_SCRIPT_Basic},
    {0xa5b410cf, L"save",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Save, XFA_SCRIPT_Basic},
    {0xbc254332, L"usehref",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Usehref, XFA_SCRIPT_Basic},
    {0xb2c80857, L"className",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Object::Script_ObjectClass_ClassName, -1,
     XFA_SCRIPT_Basic},
    {0xa60dd202, L"length",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_NodeList::Script_ListClass_Length, -1,
     XFA_SCRIPT_Basic},
    {0x31b19c1, L"name",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Name, XFA_SCRIPT_Basic},
    {0x9f9d0f9, L"all",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_All, -1,
     XFA_SCRIPT_Object},
    {0x4df15659, L"nodes",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_Nodes, -1,
     XFA_SCRIPT_Object},
    {0x78a8d6cf, L"classAll",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_ClassAll, -1,
     XFA_SCRIPT_Object},
    {0xcad6d8ca, L"parent",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_Parent, -1,
     XFA_SCRIPT_Object},
    {0xd5679c78, L"index",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_Index, -1,
     XFA_SCRIPT_Basic},
    {0xdb5b4bce, L"classIndex",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_ClassIndex, -1,
     XFA_SCRIPT_Basic},
    {0xe4989adf, L"somExpression",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_TreeClass_SomExpression, -1,
     XFA_SCRIPT_Basic},
    {0x21aed, L"id",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Attribute_String,
     XFA_ATTRIBUTE_Id, XFA_SCRIPT_Basic},
    {0x234a1, L"ns", (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_Ns,
     -1, XFA_SCRIPT_Basic},
    {0x50d1a9d1, L"model",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_Model, -1,
     XFA_SCRIPT_Object},
    {0xacb4823f, L"isContainer",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_IsContainer, -1,
     XFA_SCRIPT_Basic},
    {0xe372ae97, L"isNull",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_IsNull, -1,
     XFA_SCRIPT_Basic},
    {0xfe612a5b, L"oneOfChild",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_NodeClass_OneOfChild, -1,
     XFA_SCRIPT_Object},
    {0x97c1c65, L"context",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ModelClass_Context, -1,
     XFA_SCRIPT_Object},
    {0x58be2870, L"aliasNode",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_ModelClass_AliasNode, -1,
     XFA_SCRIPT_Object},
    {0xa52682bd, L"{default}",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
    {0xd6e27f1d, L"value",
     (XFA_ATTRIBUTE_CALLBACK)&CXFA_Node::Script_Som_DefaultValue, -1,
     XFA_SCRIPT_Basic},
};
const int32_t g_iSomAttributeCount =
    sizeof(g_SomAttributeData) / sizeof(XFA_ATTRIBUTEINFO);
