/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import net.tinyos.message.Message;
import net.tinyos.message.MessageListener;
import net.tinyos.message.MoteIF;
import net.tinyos.util.Messenger;
import net.tinyos.util.PrintStreamMessenger;

public class Oscilloscope
implements MessageListener {
    MoteIF mote;
    Data data;
    Window window;
    int interval = 1024;
    int version = -1;

    void run() {
        this.data = new Data(this);
        this.window = new Window(this);
        this.window.setup();
        this.mote = new MoteIF((Messenger)PrintStreamMessenger.err);
        this.mote.registerListener((Message)new OscilloscopeMsg(), (MessageListener)this);
    }

    void newNode(int n) {
        this.window.newNode(n);
    }

    public synchronized void messageReceived(int n, Message message) {
        if (message instanceof OscilloscopeMsg) {
            OscilloscopeMsg oscilloscopeMsg = (OscilloscopeMsg)message;
            this.periodUpdate(oscilloscopeMsg.get_version(), oscilloscopeMsg.get_interval());
            this.data.update(oscilloscopeMsg.get_id(), oscilloscopeMsg.get_count(), oscilloscopeMsg.get_readings());
            this.window.newData();
        }
    }

    void periodUpdate(int n, int n2) {
        if (n > this.version) {
            this.version = n;
            this.interval = n2;
            this.window.updateSamplePeriod();
        } else if (n < this.version) {
            this.sendInterval();
        }
    }

    synchronized boolean setInterval(int n) {
        if (n < 1 || n > 65535) {
            return false;
        }
        this.interval = n;
        ++this.version;
        this.sendInterval();
        return true;
    }

    void sendInterval() {
        OscilloscopeMsg oscilloscopeMsg = new OscilloscopeMsg();
        oscilloscopeMsg.set_version(this.version);
        oscilloscopeMsg.set_interval(this.interval);
        try {
            this.mote.send(65535, (Message)oscilloscopeMsg);
        }
        catch (IOException iOException) {
            this.window.error("Cannot send message to mote");
        }
    }

    void clear() {
        this.data = new Data(this);
    }

    public static void main(String[] stringArray) {
        Oscilloscope oscilloscope = new Oscilloscope();
        oscilloscope.run();
    }
}

