/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.message;

import java.io.IOException;
import net.tinyos.message.Message;
import net.tinyos.message.MessageListener;
import net.tinyos.message.Receiver;
import net.tinyos.message.Sender;
import net.tinyos.packet.BuildSource;
import net.tinyos.packet.PhoenixSource;
import net.tinyos.util.Messenger;
import net.tinyos.util.PrintStreamMessenger;

public class MoteIF {
    public static final int TOS_BCAST_ADDR = 65535;
    protected PhoenixSource source;
    protected Sender sender;
    protected Receiver receiver;

    public MoteIF() {
        this.init(BuildSource.makePhoenix(PrintStreamMessenger.err));
    }

    public MoteIF(Messenger messenger) {
        this.init(BuildSource.makePhoenix(messenger));
    }

    public MoteIF(PhoenixSource phoenixSource) {
        this.init(phoenixSource);
    }

    private void init(PhoenixSource phoenixSource) {
        this.source = phoenixSource;
        try {
            phoenixSource.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        try {
            phoenixSource.awaitStartup();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.receiver = new Receiver(phoenixSource);
        this.sender = new Sender(phoenixSource);
    }

    public PhoenixSource getSource() {
        return this.source;
    }

    public synchronized void send(int n, Message message) throws IOException {
        this.sender.send(n, message);
    }

    public synchronized void registerListener(Message message, MessageListener messageListener) {
        this.receiver.registerListener(message, messageListener);
    }

    public synchronized void deregisterListener(Message message, MessageListener messageListener) {
        this.receiver.deregisterListener(message, messageListener);
    }
}

