/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.message;

import net.tinyos.message.Message;

public class SerialPacket
extends Message {
    public static final int DEFAULT_MESSAGE_SIZE = 7;
    public static final int AM_TYPE = -1;

    public SerialPacket() {
        super(7);
        this.amTypeSet(-1);
    }

    public SerialPacket(int n) {
        super(n);
        this.amTypeSet(-1);
    }

    public SerialPacket(int n, int n2) {
        super(n, n2);
        this.amTypeSet(-1);
    }

    public SerialPacket(byte[] byArray) {
        super(byArray);
        this.amTypeSet(-1);
    }

    public SerialPacket(byte[] byArray, int n) {
        super(byArray, n);
        this.amTypeSet(-1);
    }

    public SerialPacket(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.amTypeSet(-1);
    }

    public SerialPacket(Message message, int n) {
        super(message, n, 7);
        this.amTypeSet(-1);
    }

    public SerialPacket(Message message, int n, int n2) {
        super(message, n, n2);
        this.amTypeSet(-1);
    }

    public String toString() {
        String string = "Message <SerialPacket> \n";
        try {
            string = string + "  [header.dest=0x" + Long.toHexString(this.get_header_dest()) + "]\n";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            string = string + "  [header.src=0x" + Long.toHexString(this.get_header_src()) + "]\n";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            string = string + "  [header.length=0x" + Long.toHexString(this.get_header_length()) + "]\n";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            string = string + "  [header.group=0x" + Long.toHexString(this.get_header_group()) + "]\n";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            string = string + "  [header.type=0x" + Long.toHexString(this.get_header_type()) + "]\n";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return string;
    }

    public static boolean isSigned_header_dest() {
        return false;
    }

    public static boolean isArray_header_dest() {
        return false;
    }

    public static int offset_header_dest() {
        return 0;
    }

    public static int offsetBits_header_dest() {
        return 0;
    }

    public int get_header_dest() {
        return (int)this.getUIntBEElement(SerialPacket.offsetBits_header_dest(), 16);
    }

    public void set_header_dest(int n) {
        this.setUIntBEElement(SerialPacket.offsetBits_header_dest(), 16, n);
    }

    public static int size_header_dest() {
        return 2;
    }

    public static int sizeBits_header_dest() {
        return 16;
    }

    public static boolean isSigned_header_src() {
        return false;
    }

    public static boolean isArray_header_src() {
        return false;
    }

    public static int offset_header_src() {
        return 2;
    }

    public static int offsetBits_header_src() {
        return 16;
    }

    public int get_header_src() {
        return (int)this.getUIntBEElement(SerialPacket.offsetBits_header_src(), 16);
    }

    public void set_header_src(int n) {
        this.setUIntBEElement(SerialPacket.offsetBits_header_src(), 16, n);
    }

    public static int size_header_src() {
        return 2;
    }

    public static int sizeBits_header_src() {
        return 16;
    }

    public static boolean isSigned_header_length() {
        return false;
    }

    public static boolean isArray_header_length() {
        return false;
    }

    public static int offset_header_length() {
        return 4;
    }

    public static int offsetBits_header_length() {
        return 32;
    }

    public short get_header_length() {
        return (short)this.getUIntBEElement(SerialPacket.offsetBits_header_length(), 8);
    }

    public void set_header_length(short s) {
        this.setUIntBEElement(SerialPacket.offsetBits_header_length(), 8, s);
    }

    public static int size_header_length() {
        return 1;
    }

    public static int sizeBits_header_length() {
        return 8;
    }

    public static boolean isSigned_header_group() {
        return false;
    }

    public static boolean isArray_header_group() {
        return false;
    }

    public static int offset_header_group() {
        return 5;
    }

    public static int offsetBits_header_group() {
        return 40;
    }

    public short get_header_group() {
        return (short)this.getUIntBEElement(SerialPacket.offsetBits_header_group(), 8);
    }

    public void set_header_group(short s) {
        this.setUIntBEElement(SerialPacket.offsetBits_header_group(), 8, s);
    }

    public static int size_header_group() {
        return 1;
    }

    public static int sizeBits_header_group() {
        return 8;
    }

    public static boolean isSigned_header_type() {
        return false;
    }

    public static boolean isArray_header_type() {
        return false;
    }

    public static int offset_header_type() {
        return 6;
    }

    public static int offsetBits_header_type() {
        return 48;
    }

    public short get_header_type() {
        return (short)this.getUIntBEElement(SerialPacket.offsetBits_header_type(), 8);
    }

    public void set_header_type(short s) {
        this.setUIntBEElement(SerialPacket.offsetBits_header_type(), 8, s);
    }

    public static int size_header_type() {
        return 1;
    }

    public static int sizeBits_header_type() {
        return 8;
    }

    public static boolean isSigned_data() {
        return false;
    }

    public static boolean isArray_data() {
        return true;
    }

    public static int offset_data(int n) {
        int n2 = 56;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (n2 += 0 + n * 8) / 8;
    }

    public static int offsetBits_data(int n) {
        int n2 = 56;
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n2 += 0 + n * 8;
    }

    public short[] get_data() {
        throw new IllegalArgumentException("Cannot get field as array - unknown size");
    }

    public void set_data(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            this.setElement_data(i, sArray[i]);
        }
    }

    public short getElement_data(int n) {
        return (short)this.getUIntBEElement(SerialPacket.offsetBits_data(n), 8);
    }

    public void setElement_data(int n, short s) {
        this.setUIntBEElement(SerialPacket.offsetBits_data(n), 8, s);
    }

    public static int elementSize_data() {
        return 1;
    }

    public static int elementSizeBits_data() {
        return 8;
    }

    public static int numDimensions_data() {
        return 1;
    }

    public static int numElements_data(int n) {
        int[] nArray = new int[]{0};
        if (n < 0 || n >= 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (nArray[n] == 0) {
            throw new IllegalArgumentException("Array dimension " + n + " has unknown size");
        }
        return nArray[n];
    }

    public void setString_data(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            this.setElement_data(n, (short)string.charAt(n));
        }
        this.setElement_data(n, (short)0);
    }

    public String getString_data() {
        int n;
        char[] cArray = new char[512];
        for (n = 0; n < cArray.length && (char)this.getElement_data(n) != '\u0000'; ++n) {
            cArray[n] = (char)this.getElement_data(n);
        }
        return new String(cArray, 0, n);
    }
}

