/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.tinyos.mviz.DDocument;
import net.tinyos.mviz.DLinkModelListener;
import net.tinyos.mviz.DMoteModel;

class DLinkModel
implements Serializable {
    public static final int VALUE = 0;
    public static final int MOTION = 1;
    public static final int ANY = 1;
    public DDocument root;
    private transient ArrayList listeners;
    protected int x12;
    protected int y12;
    protected int[] values;
    DMoteModel m1;
    DMoteModel m2;
    protected int COLOR_MAX = 230;

    public DLinkModel(DMoteModel dMoteModel, DMoteModel dMoteModel2, Random random, DDocument dDocument) {
        this.root = dDocument;
        this.m1 = dMoteModel;
        this.m2 = dMoteModel2;
        this.x12 = this.getMiddle(dMoteModel.x, dMoteModel2.x);
        this.y12 = this.getMiddle(dMoteModel.y, dMoteModel2.y);
        this.values = new int[dDocument.sensed_links.size()];
        for (int i = 0; i < dDocument.sensed_links.size(); ++i) {
            this.values[i] = 0;
        }
    }

    protected void setLinkValue(String string, int n) {
        int n2 = this.root.sensed_links.indexOf(string);
        if (n2 < 0) {
            return;
        }
        this.values[n2] = n;
    }

    private int getMiddle(int n, int n2) {
        return (n + n2) / 2;
    }

    public Color setColor(float f) {
        int n = (int)f % this.COLOR_MAX;
        return new Color(n + 15, n, n + 25);
    }

    public int getValue() {
        return this.values[this.root.selectedLinkIndex];
    }

    public int getValue(int n) {
        return this.values[n];
    }

    public int getValue(String string) {
        int n = this.root.sensed_links.indexOf(string);
        if (n < 0) {
            return 0;
        }
        return this.values[n];
    }

    public int getTop() {
        return Math.min(this.m1.y, this.m2.y);
    }

    public int getBottom() {
        return Math.max(this.m1.y, this.m2.y);
    }

    public int getLeft() {
        return Math.min(this.m1.x, this.m2.x);
    }

    public int getRight() {
        return Math.max(this.m1.x, this.m2.x);
    }

    public int getWidth() {
        return Math.abs(this.m1.x - this.m2.x);
    }

    public int getHeight() {
        return Math.abs(this.m1.y - this.m2.y);
    }

    protected Color getColor() {
        return Color.RED;
    }

    public void setValue(int n) {
        this.values[this.root.selectedLinkIndex] = n;
        this.fireChanges();
    }

    public int getLocX() {
        return this.x12;
    }

    public int getLocY() {
        return this.y12;
    }

    public void addListener(DLinkModelListener dLinkModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != dLinkModelListener) continue;
            return;
        }
        this.listeners.add(dLinkModelListener);
    }

    public void removeListener(DLinkModelListener dLinkModelListener) {
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != dLinkModelListener) continue;
            iterator.remove();
            return;
        }
    }

    protected void fireChanges() {
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((DLinkModelListener)iterator.next()).shapeChanged(this, 1);
        }
    }
}

