/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.packet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.tinyos.packet.ByteSource;

public abstract class StreamByteSource
implements ByteSource {
    protected InputStream is;
    protected OutputStream os;
    protected boolean opened;

    protected StreamByteSource() {
    }

    protected abstract void openStreams() throws IOException;

    protected abstract void closeStreams() throws IOException;

    public void open() throws IOException {
        this.openStreams();
        this.opened = true;
    }

    public void close() {
        if (this.opened) {
            this.opened = false;
            try {
                this.os.close();
                this.is.close();
                this.closeStreams();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws IOException {
        int n;
        if (!this.opened) {
            throw new IOException("not open");
        }
        try {
            n = this.is.read();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (n == -1) {
            this.close();
            throw new IOException("read error");
        }
        return (byte)n;
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (!this.opened) {
            throw new IOException("not open");
        }
        try {
            this.os.write(byArray);
            this.os.flush();
        }
        catch (IOException iOException) {
            this.close();
            throw new IOException("write error");
        }
    }
}

