/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.tinyos.packet.BuildSource;
import net.tinyos.packet.PacketListenerIF;
import net.tinyos.packet.PhoenixSource;
import net.tinyos.util.Messenger;
import net.tinyos.util.PrintStreamMessenger;

public class DiagMsg
implements PacketListenerIF {
    protected String delimiter = " ";
    protected SimpleDateFormat timestamp = new SimpleDateFormat("HH:mm:ss");
    static final int PACKET_TYPE_FIELD = 7;
    static final int PACKET_LENGTH_FIELD = 5;
    static final int PACKET_DATA_FIELD = 8;
    static final int PACKET_CRC_SIZE = 0;
    static final byte AM_DIAG_MSG = -79;
    protected PhoenixSource forwarder;
    protected byte[] packet;
    protected int end;
    protected int head;
    protected StringBuffer line;
    static final int TYPE_END = 0;
    static final int TYPE_INT8 = 1;
    static final int TYPE_UINT8 = 2;
    static final int TYPE_HEX8 = 3;
    static final int TYPE_INT16 = 4;
    static final int TYPE_UINT16 = 5;
    static final int TYPE_HEX16 = 6;
    static final int TYPE_INT32 = 7;
    static final int TYPE_UINT32 = 8;
    static final int TYPE_HEX32 = 9;
    static final int TYPE_FLOAT = 10;
    static final int TYPE_CHAR = 11;
    static final int TYPE_INT64 = 12;
    static final int TYPE_UINT64 = 13;
    static final int TYPE_ARRAY = 15;

    public DiagMsg(PhoenixSource phoenixSource) {
        this.forwarder = phoenixSource;
        phoenixSource.registerPacketListener(this);
    }

    public void run() {
        this.forwarder.run();
    }

    public static void main(String[] stringArray) throws Exception {
        PhoenixSource phoenixSource = null;
        if (stringArray.length == 0) {
            phoenixSource = BuildSource.makePhoenix(PrintStreamMessenger.err);
        } else if (stringArray.length == 2 && stringArray[0].equals("-comm")) {
            phoenixSource = BuildSource.makePhoenix(stringArray[1], (Messenger)PrintStreamMessenger.err);
        } else {
            System.err.println("usage: DiagMsg [-comm <source>]");
            System.exit(1);
        }
        DiagMsg diagMsg = new DiagMsg(phoenixSource);
        diagMsg.run();
    }

    public void packetReceived(byte[] byArray) {
        if (byArray[7] == -79) {
            try {
                System.out.println(this.timestamp.format(new Date()) + " " + this.decode(byArray));
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    protected synchronized String decode(byte[] byArray) throws Exception {
        this.packet = byArray;
        this.head = 8;
        this.end = 8 + byArray[5];
        if (this.end < this.head || this.end > byArray.length - 0) {
            throw new Exception("illegal message length");
        }
        this.line = new StringBuffer();
        while (this.head < this.end) {
            byte by = this.getByte();
            this.addSimple(by & 0xF);
            this.addSimple(by >> 4 & 0xF);
        }
        if (this.line.length() > 0 && this.line.substring(0, this.delimiter.length()).equals(this.delimiter)) {
            this.line.delete(0, this.delimiter.length());
        }
        return new String(this.line);
    }

    protected void addSimple(int n) throws Exception {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.addInt8();
                break;
            }
            case 2: {
                this.addUint8();
                break;
            }
            case 3: {
                this.addHex8();
                break;
            }
            case 4: {
                this.addInt16();
                break;
            }
            case 5: {
                this.addUint16();
                break;
            }
            case 6: {
                this.addHex16();
                break;
            }
            case 7: {
                this.addInt32();
                break;
            }
            case 8: {
                this.addUint32();
                break;
            }
            case 9: {
                this.addHex32();
                break;
            }
            case 10: {
                this.addReal();
                break;
            }
            case 11: {
                this.addChar();
                break;
            }
            case 12: {
                this.addInt64();
                break;
            }
            case 13: {
                this.addUint64();
                break;
            }
            case 15: {
                this.addArray();
                break;
            }
            default: {
                this.line.append(this.delimiter + "unknown");
            }
        }
    }

    protected void addArray() throws Exception {
        int n = this.getByte();
        int n2 = n >> 4 & 0xF;
        n &= 0xF;
        if (n2 == 11) {
            this.addStr(n);
        } else {
            this.line.append(this.delimiter + "[");
            while (--n >= 0) {
                this.addSimple(n2);
            }
            this.line.append(" ]");
        }
    }

    protected void check(int n) throws Exception {
        if (this.head + n > this.end) {
            throw new Exception("illegal message format");
        }
    }

    protected byte getByte() throws Exception {
        this.check(1);
        byte by = this.packet[this.head];
        ++this.head;
        return by;
    }

    protected short getShort() throws Exception {
        this.check(2);
        short s = this.packet[this.head];
        s = (short)(s & 0xFF);
        short s2 = this.packet[this.head + 1];
        s2 = (short)(s2 << 8);
        s2 = (short)(s2 & 0xFF00);
        s = (short)(s | s2);
        this.head += 2;
        return s;
    }

    protected int getInt() throws Exception {
        this.check(4);
        int n = this.packet[this.head];
        n &= 0xFF;
        int n2 = this.packet[this.head + 1];
        n2 <<= 8;
        n |= (n2 &= 0xFF00);
        n2 = this.packet[this.head + 2];
        n2 <<= 16;
        n |= (n2 &= 0xFF0000);
        n2 = this.packet[this.head + 3];
        n2 <<= 24;
        this.head += 4;
        return n |= (n2 &= 0xFF000000);
    }

    protected long getLong() throws Exception {
        this.check(8);
        long l = this.packet[this.head];
        l &= 0xFFL;
        long l2 = this.packet[this.head + 1];
        l2 &= 0xFFL;
        l |= (l2 <<= 8);
        l2 = this.packet[this.head + 2];
        l2 &= 0xFFL;
        l |= (l2 <<= 16);
        l2 = this.packet[this.head + 3];
        l2 &= 0xFFL;
        l |= (l2 <<= 24);
        l2 = this.packet[this.head + 4];
        l2 &= 0xFFL;
        l |= (l2 <<= 32);
        l2 = this.packet[this.head + 5];
        l2 &= 0xFFL;
        l |= (l2 <<= 40);
        l2 = this.packet[this.head + 6];
        l2 &= 0xFFL;
        l |= (l2 <<= 48);
        l2 = this.packet[this.head + 7];
        l2 &= 0xFFL;
        this.head += 8;
        return l |= (l2 <<= 56);
    }

    protected void addUint8() throws Exception {
        String string = Integer.toString(this.getByte() & 0xFF);
        this.line.append(this.delimiter + string);
    }

    protected void addInt8() throws Exception {
        String string = Byte.toString(this.getByte());
        this.line.append(this.delimiter + string);
    }

    protected void addHex8() throws Exception {
        String string = Integer.toHexString(this.getByte() & 0xFF);
        this.line.append(this.delimiter + "0x");
        for (int i = string.length(); i < 2; ++i) {
            this.line.append('0');
        }
        this.line.append(string);
    }

    protected void addUint16() throws Exception {
        String string = Integer.toString(this.getShort() & 0xFFFF);
        this.line.append(this.delimiter + string);
    }

    protected void addInt16() throws Exception {
        String string = Short.toString(this.getShort());
        this.line.append(this.delimiter + string);
    }

    protected void addHex16() throws Exception {
        String string = Integer.toHexString(this.getShort() & 0xFFFF);
        this.line.append(this.delimiter + "0x");
        for (int i = string.length(); i < 4; ++i) {
            this.line.append('0');
        }
        this.line.append(string);
    }

    protected void addUint32() throws Exception {
        String string = Long.toString((long)this.getInt() & 0xFFFFFFFFL);
        this.line.append(this.delimiter + string);
    }

    protected void addInt32() throws Exception {
        String string = Integer.toString(this.getInt());
        this.line.append(this.delimiter + string);
    }

    protected void addHex32() throws Exception {
        String string = Integer.toHexString(this.getInt());
        this.line.append(this.delimiter + "0x");
        for (int i = string.length(); i < 8; ++i) {
            this.line.append('0');
        }
        this.line.append(string);
    }

    protected void addInt64() throws Exception {
        String string = Long.toString(this.getLong());
        this.line.append(this.delimiter + string);
    }

    protected void addUint64() throws Exception {
        String string = Long.toString(this.getLong());
        this.line.append(this.delimiter + string);
    }

    protected void addReal() throws Exception {
        float f = Float.intBitsToFloat(this.getInt());
        this.line.append(this.delimiter + Float.toString(f));
    }

    protected void addChar() throws Exception {
        char c = (char)this.getByte();
        this.line.append(this.delimiter + "'" + c + "'");
    }

    protected void addStr(int n) throws Exception {
        this.line.append(this.delimiter + "\"");
        while (--n >= 0) {
            this.line.append((char)this.getByte());
        }
        this.line.append('\"');
    }
}

