/* $Id: network-table.h,v 1.5 2005/10/22 15:46:06 mschimek Exp $ */

/* Generated file, do not edit! */

struct country {
	uint16_t		cni_8301;	/* Packet 8/30 format 1 */
	uint16_t		cni_8302;	/* Packet 8/30 format 2 */
	uint16_t		cni_pdc_b;	/* Packet X/26 (PDC B) */
	uint16_t		cni_vps;	/* VPS */
	const char		country_code[4];
	const char *		name;		/* UTF-8 */
};

struct network {
	uint16_t		cni_8301;	/* Packet 8/30 format 1 */
	uint16_t		cni_8302;	/* Packet 8/30 format 2 */
	uint16_t		cni_pdc_b;	/* Packet X/26 (PDC B) */
	uint16_t		cni_vps;	/* VPS */
	unsigned int		country;
	const char *		name;		/* UTF-8 */
};

struct ttx_header {
	const char *		name;		/* UTF-8 */
	const uint8_t *		header;		/* raw Teletext data */
};

static const struct country
country_table [] = {
	{ 0x0000, 0x0000, 0x0000, 0x0000, "AA", "Unknown" },
	{ 0x4300, 0x0000, 0x0000, 0x0A00, "AT", "Austria" },
	{ 0x3200, 0x1600, 0x0000, 0x0000, "BE", "Belgium" },
	{ 0x4100, 0x2400, 0x3400, 0x0400, "CH", "Switzerland" },
	{ 0x0000, 0x3200, 0x0000, 0x0000, "CZ", "Czech Republic" },
	{ 0x4900, 0x0000, 0x3D00, 0x0D00, "DE", "Germany" },
	{ 0x0000, 0x2900, 0x0000, 0x0000, "DK", "Denmark" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "ES", "Spain" },
	{ 0x3500, 0x2600, 0x0000, 0x0000, "FI", "Finland" },
	{ 0x3300, 0x2F00, 0x3F00, 0x0000, "FR", "France" },
	{ 0x4400, 0x2C00, 0x3C00, 0x0000, "GB", "United Kingdom" },
	{ 0x3000, 0x2100, 0x3100, 0x0000, "GR", "Greece" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "HR", "Croatia" },
	{ 0x3600, 0x0000, 0x0000, 0x0000, "HU", "Hungary" },
	{ 0x0000, 0x4200, 0x3200, 0x0000, "IE", "Ireland" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "IS", "Iceland" },
	{ 0x3900, 0x1500, 0x0000, 0x0000, "IT", "Italy" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "LU", "Luxembourg" },
	{ 0x3100, 0x4800, 0x3800, 0x0000, "NL", "Netherlands" },
	{ 0x4700, 0x0000, 0x0000, 0x0000, "NO", "Norway" },
	{ 0x4800, 0x0000, 0x0000, 0x0000, "PL", "Poland" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "PT", "Portugal" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "SE", "Sweden" },
	{ 0xAA00, 0x0000, 0x0000, 0x0000, "SI", "Slovenia" },
	{ 0x0000, 0x3500, 0x3500, 0x0000, "SK", "Slovakia" },
	{ 0x0000, 0x0000, 0x0000, 0x0000, "SM", "San Marino" },
	{ 0x9000, 0x0000, 0x0000, 0x0000, "TR", "Turkey" },
	{ 0x7700, 0x0000, 0x0000, 0x0700, "UA", "Ukraine" },
};

static const struct network
network_table [] = {
	{ 0x0000, 0x0000, 0x0000, 0x0481,  3, "TeleZüri" },
	{ 0x0000, 0x0000, 0x0000, 0x0482,  3, "Teleclub Abo-Fernsehen" },
	{ 0x0000, 0x0000, 0x0000, 0x0483,  3, "Zürich 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0484,  3, "TeleBern" },
	{ 0x0000, 0x0000, 0x0000, 0x0485,  3, "Tele M1" },
	{ 0x0000, 0x0000, 0x0000, 0x0486,  3, "Star TV" },
	{ 0x0000, 0x0000, 0x0000, 0x0487,  3, "Pro 7" },
	{ 0x0000, 0x0000, 0x0000, 0x0488,  3, "TopTV" },
	{ 0x0000, 0x0000, 0x0000, 0x0AC3,  1, "ORF 3" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACB,  1, "ORF Burgenland" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACC,  1, "ORF Kärnten" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACD,  1, "ORF Niederösterreich" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACE,  1, "ORF Oberösterreich" },
	{ 0x0000, 0x0000, 0x0000, 0x0ACF,  1, "ORF Salzburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD0,  1, "ORF Steiermark" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD1,  1, "ORF Tirol" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD2,  1, "ORF Vorarlberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0AD3,  1, "ORF Wien" },
	{ 0x0000, 0x0000, 0x0000, 0x0D75,  5, "KDG Infokanal" },
	{ 0x0000, 0x0000, 0x0000, 0x0D76,  5, "DAS VIERTE" },
	{ 0x0000, 0x0000, 0x0000, 0x0D79,  5, "RTL Shop" },
	{ 0x0000, 0x0000, 0x0000, 0x0D7A,  5, "N24" },
	{ 0x0000, 0x0000, 0x0000, 0x0D7B,  5, "TV Berlin" },
	{ 0x0000, 0x0000, 0x0000, 0x0D7C,  5, "ONYX-TV" },
	{ 0x0000, 0x0000, 0x0000, 0x0D7E,  5, "Nickelodeon" },
	{ 0x0000, 0x0000, 0x0000, 0x0D81,  5, "ORB-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0D87,  5, "1A-Fernsehen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D88,  5, "VIVA" },
	{ 0x0000, 0x0000, 0x0000, 0x0D89,  5, "VIVA 2" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8A,  5, "Super RTL" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8B,  5, "RTL Club" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8C,  5, "n-tv" },
	{ 0x0000, 0x0000, 0x0000, 0x0D8D,  5, "DSF" },
	{ 0x0000, 0x0000, 0x0000, 0x0D90,  5, "RTL 2 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0D91,  5, "Eurosport" },
	{ 0x0000, 0x0000, 0x0000, 0x0D92,  5, "Kabel 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0D94,  5, "PRO 7" },
	{ 0x0000, 0x0000, 0x0000, 0x0D95,  5, "SAT 1 Brandenburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0D96,  5, "SAT 1 Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D97,  5, "SAT 1 Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D98,  5, "SAT 1 Mecklenb.-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0D99,  5, "SAT 1 Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9A,  5, "RTL Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9B,  5, "RTL Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9C,  5, "RTL Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9D,  5, "RTL Berlin" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9E,  5, "RTL Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0D9F,  5, "RTL Bremen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA0,  5, "RTL Nordrhein-Westfalen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA1,  5, "RTL Hessen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA2,  5, "RTL Rheinland-Pfalz" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA3,  5, "RTL Baden-Württemberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA4,  5, "RTL Bayern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA5,  5, "RTL Saarland" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA6,  5, "RTL Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA7,  5, "RTL Mecklenburg-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA8,  5, "RTL Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DA9,  5, "RTL Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAA,  5, "RTL Brandenburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAB,  5, "RTL" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAC,  5, "Premiere" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAD,  5, "SAT 1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAE,  5, "SAT 1 Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0DAF,  5, "SAT 1 Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB0,  5, "SAT 1 Berlin" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB1,  5, "SAT 1 Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB2,  5, "SAT 1 Bremen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB3,  5, "SAT 1 Nordrhein-Westfalen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB4,  5, "SAT 1 Hessen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB5,  5, "SAT 1 Rheinland-Pfalz" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB6,  5, "SAT 1 Baden-Württemberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB7,  5, "SAT 1 Bayern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB8,  5, "SAT 1 Saarland" },
	{ 0x0000, 0x0000, 0x0000, 0x0DB9,  5, "SAT 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBA,  5, "NEUN LIVE" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBB,  5, "Deutsche Welle TV Berlin" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBD,  5, "Berlin Offener Kanal" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBE,  5, "Berlin-Mix-Channel 2" },
	{ 0x0000, 0x0000, 0x0000, 0x0DBF,  5, "Berlin-Mix-Channel 1" },
	{ 0x0000, 0x0000, 0x0000, 0x0DC3,  5, "ARD/ZDF Vormittagsprogramm" },
	{ 0x0000, 0x0000, 0x0000, 0x0DC4,  5, "ARD-TV-Sternpunkt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DC5,  5, "ARD-TV-Sternpunkt-Fehler" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCA,  5, "BR-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCC,  5, "BR-3 Süd" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCD,  5, "BR-3 Nord" },
	{ 0x0000, 0x0000, 0x0000, 0x0DCE,  5, "HR-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD0,  5, "NDR-1 Dreiländerweit" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD1,  5, "NDR-1 Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD2,  5, "NDR-1 Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD3,  5, "NDR-1 Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD4,  5, "Nord-3 (NDR/SFB/RB)" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD6,  5, "NDR-3 Hamburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD7,  5, "NDR-3 Niedersachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD8,  5, "NDR-3 Schleswig-Holstein" },
	{ 0x0000, 0x0000, 0x0000, 0x0DD9,  5, "RB-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DDB,  5, "SFB-1 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DDD,  5, "SWR-1 Baden-Württemberg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DDE,  5, "SWR-1 Rheinland-Pfalz" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE0,  5, "Südwest 3 (SDR/SR/SWF)" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE2,  5, "SW 3 Saarland" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE3,  5, "SW 3 Baden-Württemb. Süd" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE5,  5, "WDR-1 Regionalprogramm" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE7,  5, "WDR-3 Bielefeld" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE8,  5, "WDR-3 Dortmund" },
	{ 0x0000, 0x0000, 0x0000, 0x0DE9,  5, "WDR-3 Düsseldorf" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEA,  5, "WDR-3 Köln" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEB,  5, "WDR-3 Münster" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEC,  5, "SW 3 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DED,  5, "SW 3 Baden-Württemberg Nord" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEE,  5, "SW 3 Mannheim" },
	{ 0x0000, 0x0000, 0x0000, 0x0DEF,  5, "SW 3 Regional" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF0,  5, "SWR1 / Regionalprogramm" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF1,  5, "NDR-1 Mecklenb.-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF2,  5, "NDR-3 Mecklenb.-Vorpommern" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF3,  5, "MDR-1 Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF4,  5, "MDR-3 Sachsen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF5,  5, "MDR Dresden" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF6,  5, "MDR-1 Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF7,  5, "WDR Dortmund" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF8,  5, "MDR-3 Sachsen-Anhalt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DF9,  5, "MDR Magdeburg" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFA,  5, "MDR-1 Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFB,  5, "MDR-3 Thüringen" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFC,  5, "MDR Erfurt" },
	{ 0x0000, 0x0000, 0x0000, 0x0DFD,  5, "MDR-1 Regional" },
	{ 0x01F2, 0x5BF1, 0x3B71, 0x0000, 10, "CNN International" },
	{ 0x0385, 0x0000, 0x0000, 0x0000, 12, "HRT" },
	{ 0x0404, 0x1604, 0x3604, 0x0000,  2, "VT4" },
	{ 0x0AE8, 0x0000, 0x0000, 0x0D14,  5, "PRO 7 Austria" },
	{ 0x0D8F, 0x0000, 0x0000, 0x0D8F,  5, "RTL 2" },
	{ 0x10E4, 0x2C34, 0x3C34, 0x0000, 10, "MERIDIAN" },
	{ 0x1609, 0x2C09, 0x3C09, 0x0000, 10, "CHANNEL 5 (2)" },
	{ 0x25D0, 0x2C30, 0x3C30, 0x0000, 10, "WESTCOUNTRY TV" },
	{ 0x28EB, 0x2C2B, 0x3C2B, 0x0000, 10, "CHANNEL 5 (3)" },
	{ 0x2F27, 0x2C37, 0x3C37, 0x0000, 10, "CENTRAL TV" },
	{ 0x3001, 0x2101, 0x3101, 0x0000, 11, "ET-1" },
	{ 0x3002, 0x2102, 0x3102, 0x0000, 11, "NET" },
	{ 0x3003, 0x2103, 0x3103, 0x0000, 11, "ET-3" },
	{ 0x3101, 0x4801, 0x3801, 0x0000, 18, "Nederland 1" },
	{ 0x3102, 0x4802, 0x3802, 0x0000, 18, "Nederland 2" },
	{ 0x3103, 0x4803, 0x3803, 0x0000, 18, "Nederland 3" },
	{ 0x3104, 0x4804, 0x3804, 0x0000, 18, "RTL 4" },
	{ 0x3105, 0x4805, 0x3805, 0x0000, 18, "RTL 5" },
	{ 0x3106, 0x4806, 0x3806, 0x0000, 18, "Yorin" },
	{ 0x3120, 0x4820, 0x3820, 0x0000, 18, "The BOX" },
	{ 0x3121, 0x0000, 0x0000, 0x0000, 18, "Discovery Netherlands" },
	{ 0x3122, 0x0000, 0x0000, 0x0000, 18, "Nickelodeon" },
	{ 0x3123, 0x0000, 0x0000, 0x0000, 18, "Animal Planet Benelux" },
	{ 0x3124, 0x0000, 0x0000, 0x0000, 18, "TALPA TV" },
	{ 0x3125, 0x0000, 0x0000, 0x0000, 18, "NET5" },
	{ 0x3126, 0x0000, 0x0000, 0x0000, 18, "SBS6" },
	{ 0x3128, 0x0000, 0x0000, 0x0000, 18, "V8" },
	{ 0x3130, 0x0000, 0x0000, 0x0000, 18, "TMF Netherlands" },
	{ 0x3131, 0x0000, 0x0000, 0x0000, 18, "TMF Belgian Flanders" },
	{ 0x3132, 0x0000, 0x0000, 0x0000, 18, "MTV NL" },
	{ 0x3137, 0x0000, 0x0000, 0x0000, 18, "RNN7" },
	{ 0x3147, 0x4847, 0x3847, 0x0000, 18, "RTL 7" },
	{ 0x3201, 0x1601, 0x3603, 0x0000,  2, "VRT TV1" },
	{ 0x3202, 0x1602, 0x3602, 0x0000,  2, "CANVAS" },
	{ 0x3203, 0x0000, 0x0000, 0x0000,  2, "RTBF 1" },
	{ 0x3204, 0x0000, 0x0000, 0x0000,  2, "RTBF 2" },
	{ 0x3205, 0x1605, 0x3605, 0x0000,  2, "VTM" },
	{ 0x3206, 0x1606, 0x3606, 0x0000,  2, "Kanaal2" },
	{ 0x3207, 0x0000, 0x0000, 0x0000,  2, "RTBF Sat" },
	{ 0x3209, 0x0000, 0x0000, 0x0000,  2, "RTL-TV1" },
	{ 0x320A, 0x0000, 0x0000, 0x0000,  2, "CLUB-RTL" },
	{ 0x320B, 0x0000, 0x0000, 0x0000, 10, "National Geographic Channel" },
	{ 0x320C, 0x0000, 0x0000, 0x0000,  2, "AB3" },
	{ 0x320D, 0x0000, 0x0000, 0x0000,  2, "AB4e" },
	{ 0x320E, 0x0000, 0x0000, 0x0000,  2, "Ring TV" },
	{ 0x320F, 0x0000, 0x0000, 0x0000,  2, "JIM.tv" },
	{ 0x3210, 0x0000, 0x0000, 0x0000,  2, "RTV-Kempen" },
	{ 0x3211, 0x0000, 0x0000, 0x0000,  2, "RTV-Mechelen" },
	{ 0x3212, 0x0000, 0x0000, 0x0000,  2, "MCM Belgium" },
	{ 0x3213, 0x0000, 0x0000, 0x0000,  2, "Vitaya" },
	{ 0x3214, 0x0000, 0x0000, 0x0000,  2, "WTV" },
	{ 0x3215, 0x0000, 0x0000, 0x0000,  2, "FocusTV" },
	{ 0x3216, 0x0000, 0x0000, 0x0000,  2, "Be 1 ana" },
	{ 0x3217, 0x0000, 0x0000, 0x0000,  2, "Be 1 num" },
	{ 0x3218, 0x0000, 0x0000, 0x0000,  2, "Be Ciné 1" },
	{ 0x3219, 0x0000, 0x0000, 0x0000,  2, "Be Sport 1" },
	{ 0x321A, 0x0000, 0x0000, 0x0000,  2, "PRIME Sport 1" },
	{ 0x321B, 0x0000, 0x0000, 0x0000,  2, "PRIME Sport 2" },
	{ 0x321C, 0x0000, 0x0000, 0x0000,  2, "PRIME Action" },
	{ 0x321D, 0x0000, 0x0000, 0x0000,  2, "PRIME One" },
	{ 0x321E, 0x0000, 0x0000, 0x0000,  2, "TV Brussel" },
	{ 0x321F, 0x0000, 0x0000, 0x0000,  2, "AVSe" },
	{ 0x3221, 0x0000, 0x0000, 0x0000,  2, "TV Limburg" },
	{ 0x3222, 0x0000, 0x0000, 0x0000,  2, "Kanaal 3" },
	{ 0x3223, 0x0000, 0x0000, 0x0000,  2, "ATV" },
	{ 0x3224, 0x0000, 0x0000, 0x0000,  2, "ROB TV" },
	{ 0x3225, 0x0000, 0x0000, 0x0000,  2, "PLUG TV" },
	{ 0x3226, 0x0000, 0x0000, 0x0000,  2, "Sporza" },
	{ 0x3230, 0x0000, 0x0000, 0x0000,  2, "Télé Bruxelles" },
	{ 0x3231, 0x0000, 0x0000, 0x0000,  2, "Télésambre" },
	{ 0x3232, 0x0000, 0x0000, 0x0000,  2, "TV Com" },
	{ 0x3233, 0x0000, 0x0000, 0x0000,  2, "Canal Zoom" },
	{ 0x3234, 0x0000, 0x0000, 0x0000,  2, "Vidéoscope" },
	{ 0x3235, 0x0000, 0x0000, 0x0000,  2, "Canal C" },
	{ 0x3236, 0x0000, 0x0000, 0x0000,  2, "Télé MB" },
	{ 0x3237, 0x0000, 0x0000, 0x0000,  2, "Antenne Centre" },
	{ 0x3238, 0x0000, 0x0000, 0x0000,  2, "Télévesdre" },
	{ 0x3239, 0x0000, 0x0000, 0x0000,  2, "RTC Télé Liège" },
	{ 0x3240, 0x0000, 0x0000, 0x0000,  2, "No tele" },
	{ 0x3241, 0x0000, 0x0000, 0x0000,  2, "TV Lux" },
	{ 0x325A, 0x0000, 0x0000, 0x0000,  2, "Kanaal Z - NL" },
	{ 0x325B, 0x0000, 0x0000, 0x0000,  2, "CANAL Z - FR" },
	{ 0x326A, 0x0000, 0x0000, 0x0000,  2, "CARTOON Network - NL" },
	{ 0x326B, 0x0000, 0x0000, 0x0000,  2, "CARTOON Network - FR" },
	{ 0x327A, 0x0000, 0x0000, 0x0000,  2, "LIBERTY CHANNEL - NL" },
	{ 0x327B, 0x0000, 0x0000, 0x0000,  2, "LIBERTY CHANNEL - FR" },
	{ 0x328A, 0x0000, 0x0000, 0x0000,  2, "TCM - NL" },
	{ 0x328B, 0x0000, 0x0000, 0x0000,  2, "TCM - FR" },
	{ 0x3298, 0x0000, 0x0000, 0x0000,  2, "Mozaiek/Mosaique" },
	{ 0x3299, 0x0000, 0x0000, 0x0000,  2, "Info Kanaal/Canal Info" },
	{ 0x32A7, 0x0000, 0x0000, 0x0000,  2, "Be 1 + 1h" },
	{ 0x32A8, 0x0000, 0x0000, 0x0000,  2, "Be Ciné 2" },
	{ 0x32A9, 0x0000, 0x0000, 0x0000,  2, "Be Sport 2" },
	{ 0x330A, 0x2F0A, 0x3F0A, 0x0000,  9, "Arte" },
	{ 0x3311, 0x2F11, 0x3F11, 0x0000,  9, "RFO1" },
	{ 0x3312, 0x2F12, 0x3F12, 0x0000,  9, "RFO2" },
	{ 0x3320, 0x2F20, 0x3F20, 0x0000,  9, "Aqui TV" },
	{ 0x3321, 0x2F21, 0x3F21, 0x0000,  9, "TLM" },
	{ 0x3322, 0x2F22, 0x3F22, 0x0000,  9, "TLT" },
	{ 0x3333, 0x0000, 0x0000, 0x0000, 14, "TV3" },
	{ 0x33B2, 0x0000, 0x0000, 0x0000,  9, "Sailing Channel" },
	{ 0x33C1, 0x2FC1, 0x3F41, 0x0000,  9, "AB1" },
	{ 0x33C2, 0x2FC2, 0x3F42, 0x0000,  9, "Canal J" },
	{ 0x33C3, 0x2FC3, 0x3F43, 0x0000,  9, "Canal Jimmy" },
	{ 0x33C4, 0x2FC4, 0x3F44, 0x0000,  9, "LCI" },
	{ 0x33C5, 0x2FC5, 0x3F45, 0x0000,  9, "La Chaîne Météo" },
	{ 0x33C6, 0x2FC6, 0x3F46, 0x0000,  9, "MCM" },
	{ 0x33C7, 0x2FC7, 0x3F47, 0x0000,  9, "TMC Monte-Carlo" },
	{ 0x33C8, 0x2FC8, 0x3F48, 0x0000,  9, "Paris Première" },
	{ 0x33C9, 0x2FC9, 0x3F49, 0x0000,  9, "Planète" },
	{ 0x33CA, 0x2FCA, 0x3F4A, 0x0000,  9, "Série Club" },
	{ 0x33CB, 0x2FCB, 0x3F4B, 0x0000,  9, "Télétoon" },
	{ 0x33CC, 0x2FCC, 0x3F4C, 0x0000,  9, "Téva" },
	{ 0x33F1, 0x2F01, 0x3F01, 0x0000,  9, "TF1" },
	{ 0x33F2, 0x2F02, 0x3F02, 0x0000,  9, "France 2" },
	{ 0x33F3, 0x2F03, 0x3F03, 0x0000,  9, "France 3" },
	{ 0x33F4, 0x2F04, 0x3F04, 0x0000,  9, "Canal+" },
	{ 0x33F5, 0x2F05, 0x3F05, 0x0000,  9, "France 5" },
	{ 0x33F6, 0x2F06, 0x3F06, 0x0000,  9, "M6" },
	{ 0x3402, 0x0000, 0x0000, 0x0000,  7, "ETB 2" },
	{ 0x3403, 0x0000, 0x0000, 0x0000,  7, "CANAL 9" },
	{ 0x3404, 0x0000, 0x0000, 0x0000,  7, "PUNT 2" },
	{ 0x3405, 0x0000, 0x0000, 0x0000,  7, "CCV" },
	{ 0x340A, 0x0000, 0x0000, 0x0000,  7, "Arte" },
	{ 0x3510, 0x0000, 0x0000, 0x0000, 21, "RTP1" },
	{ 0x3511, 0x0000, 0x0000, 0x0000, 21, "RTP2" },
	{ 0x3512, 0x0000, 0x0000, 0x0000, 21, "RTPAF" },
	{ 0x3513, 0x0000, 0x0000, 0x0000, 21, "RTPI" },
	{ 0x3514, 0x0000, 0x0000, 0x0000, 21, "RTPAZ" },
	{ 0x3515, 0x0000, 0x0000, 0x0000, 21, "RTPM" },
	{ 0x3531, 0x4201, 0x3201, 0x0000, 14, "RTE1" },
	{ 0x3532, 0x4202, 0x3202, 0x0000, 14, "Network 2" },
	{ 0x3533, 0x4203, 0x3203, 0x0000, 14, "Teilifis na Gaeilge" },
	{ 0x3541, 0x0000, 0x0000, 0x0000, 15, "Rikisutvarpid-Sjonvarp" },
	{ 0x3581, 0x2601, 0x3601, 0x0000,  8, "YLE1" },
	{ 0x3582, 0x2602, 0x3607, 0x0000,  8, "YLE2" },
	{ 0x358F, 0x260F, 0x3614, 0x0000,  8, "OWL3" },
	{ 0x3601, 0x0000, 0x0000, 0x0000, 13, "MTV1" },
	{ 0x3602, 0x0000, 0x0000, 0x0000, 13, "MTV2" },
	{ 0x3611, 0x0000, 0x0000, 0x0000, 13, "MTV1 Budapest" },
	{ 0x3621, 0x0000, 0x0000, 0x0000, 13, "MTV1 Pécs" },
	{ 0x3622, 0x0000, 0x0000, 0x0000, 13, "tv2" },
	{ 0x3631, 0x0000, 0x0000, 0x0000, 13, "MTV1 Szeged" },
	{ 0x3636, 0x0000, 0x0000, 0x0000, 13, "Duna Televizio" },
	{ 0x3641, 0x0000, 0x0000, 0x0000, 13, "MTV1 Szombathely" },
	{ 0x3651, 0x0000, 0x0000, 0x0000, 13, "MTV1 Debrecen" },
	{ 0x3661, 0x0000, 0x0000, 0x0000, 13, "MTV1 Miskolc" },
	{ 0x3781, 0x0000, 0x0000, 0x0000, 25, "RTV" },
	{ 0x37E5, 0x2C25, 0x3C25, 0x0000, 10, "SSVC" },
	{ 0x3901, 0x0000, 0x0000, 0x0000, 16, "RAI 1" },
	{ 0x3902, 0x0000, 0x0000, 0x0000, 16, "RAI 2" },
	{ 0x3903, 0x0000, 0x0000, 0x0000, 16, "RAI 3" },
	{ 0x3904, 0x0000, 0x0000, 0x0000, 16, "Rete A" },
	{ 0x3905, 0x1505, 0x0000, 0x0000, 16, "Canale Italia" },
	{ 0x3909, 0x0000, 0x0000, 0x0000, 16, "Telenova" },
	{ 0x390A, 0x0000, 0x0000, 0x0000, 16, "Arte" },
	{ 0x3910, 0x0000, 0x0000, 0x0000, 16, "TRS TV" },
	{ 0x3911, 0x1511, 0x0000, 0x0000, 16, "Sky Cinema Classic" },
	{ 0x3912, 0x1512, 0x0000, 0x0000, 16, "Sky Future use (canale 109)" },
	{ 0x3913, 0x1513, 0x0000, 0x0000, 16, "Sky Calcio 1" },
	{ 0x3914, 0x1514, 0x0000, 0x0000, 16, "Sky Calcio 2" },
	{ 0x3915, 0x1515, 0x0000, 0x0000, 16, "Sky Calcio 3" },
	{ 0x3916, 0x1516, 0x0000, 0x0000, 16, "Sky Calcio 4" },
	{ 0x3917, 0x1517, 0x0000, 0x0000, 16, "Sky Calcio 5" },
	{ 0x3918, 0x1518, 0x0000, 0x0000, 16, "Sky Calcio 6" },
	{ 0x3919, 0x1519, 0x0000, 0x0000, 16, "Sky Calcio 7" },
	{ 0x3920, 0x0000, 0x0000, 0x0000, 16, "RaiNews24" },
	{ 0x3921, 0x0000, 0x0000, 0x0000, 16, "RAI Med" },
	{ 0x3922, 0x0000, 0x0000, 0x0000, 16, "RAI Sport" },
	{ 0x3923, 0x0000, 0x0000, 0x0000, 16, "RAI Educational" },
	{ 0x3924, 0x0000, 0x0000, 0x0000, 16, "RAI Edu Lab" },
	{ 0x3925, 0x0000, 0x0000, 0x0000, 16, "RAI Nettuno 1" },
	{ 0x3926, 0x0000, 0x0000, 0x0000, 16, "RAI Nettuno 2" },
	{ 0x3927, 0x0000, 0x0000, 0x0000, 16, "Camera Deputati" },
	{ 0x3928, 0x0000, 0x0000, 0x0000, 16, "RAI Mosaico" },
	{ 0x3930, 0x0000, 0x0000, 0x0000, 16, "Discovery Italy" },
	{ 0x3933, 0x0000, 0x0000, 0x0000, 16, "MTV Italia" },
	{ 0x3934, 0x0000, 0x0000, 0x0000, 16, "MTV Brand New" },
	{ 0x3935, 0x0000, 0x0000, 0x0000, 16, "MTV Hits" },
	{ 0x3938, 0x0000, 0x0000, 0x0000, 16, "RTV38" },
	{ 0x3939, 0x0000, 0x0000, 0x0000, 16, "GAY TV" },
	{ 0x3940, 0x0000, 0x0000, 0x0000, 16, "Video Italia" },
	{ 0x3941, 0x0000, 0x0000, 0x0000, 16, "SAT 2000" },
	{ 0x3942, 0x1542, 0x0000, 0x0000, 16, "Jimmy" },
	{ 0x3943, 0x1543, 0x0000, 0x0000, 16, "Planet" },
	{ 0x3944, 0x1544, 0x0000, 0x0000, 16, "Cartoon Network" },
	{ 0x3945, 0x1545, 0x0000, 0x0000, 16, "Boomerang" },
	{ 0x3946, 0x1546, 0x0000, 0x0000, 16, "CNN International" },
	{ 0x3947, 0x1547, 0x0000, 0x0000, 16, "Cartoon Network +1" },
	{ 0x3948, 0x1548, 0x0000, 0x0000, 16, "Sky Sports 3" },
	{ 0x3949, 0x1549, 0x0000, 0x0000, 16, "Sky Diretta Gol" },
	{ 0x3950, 0x0000, 0x0000, 0x0000, 16, "RaiSat Album" },
	{ 0x3951, 0x0000, 0x0000, 0x0000, 16, "RaiSat Art" },
	{ 0x3952, 0x0000, 0x0000, 0x0000, 16, "RaiSat Cinema" },
	{ 0x3953, 0x0000, 0x0000, 0x0000, 16, "RaiSat Fiction" },
	{ 0x3954, 0x0000, 0x0000, 0x0000, 16, "RaiSat GamberoRosso" },
	{ 0x3955, 0x0000, 0x0000, 0x0000, 16, "RaiSat Ragazzi" },
	{ 0x3956, 0x0000, 0x0000, 0x0000, 16, "RaiSat Show" },
	{ 0x3957, 0x0000, 0x0000, 0x0000, 16, "RaiSat G. Rosso interattivo" },
	{ 0x3960, 0x1560, 0x0000, 0x0000, 16, "SCI FI CHANNEL" },
	{ 0x3961, 0x0000, 0x0000, 0x0000, 16, "Discovery Civilisations" },
	{ 0x3962, 0x0000, 0x0000, 0x0000, 16, "Discovery Travel and Adventure" },
	{ 0x3963, 0x0000, 0x0000, 0x0000, 16, "Discovery Science" },
	{ 0x3968, 0x1568, 0x0000, 0x0000, 16, "Sky Meteo24" },
	{ 0x3970, 0x0000, 0x0000, 0x0000, 16, "Sky Cinema 2" },
	{ 0x3971, 0x0000, 0x0000, 0x0000, 16, "Sky Cinema 3" },
	{ 0x3972, 0x0000, 0x0000, 0x0000, 16, "Sky Cinema Autore" },
	{ 0x3973, 0x0000, 0x0000, 0x0000, 16, "Sky Cinema Max" },
	{ 0x3974, 0x0000, 0x0000, 0x0000, 16, "Sky Cinema 16:9" },
	{ 0x3975, 0x0000, 0x0000, 0x0000, 16, "Sky Sports 2" },
	{ 0x3976, 0x0000, 0x0000, 0x0000, 16, "Sky TG24" },
	{ 0x3977, 0x1577, 0x0000, 0x0000, 16, "Fox" },
	{ 0x3978, 0x1578, 0x0000, 0x0000, 16, "Foxlife" },
	{ 0x3979, 0x1579, 0x0000, 0x0000, 16, "National Geographic Channel" },
	{ 0x3980, 0x1580, 0x0000, 0x0000, 16, "A1" },
	{ 0x3981, 0x1581, 0x0000, 0x0000, 16, "History Channel" },
	{ 0x3985, 0x0000, 0x0000, 0x0000, 16, "FOX Kids" },
	{ 0x3986, 0x0000, 0x0000, 0x0000, 16, "PEOPLE TV - RETE 7" },
	{ 0x3987, 0x0000, 0x0000, 0x0000, 16, "FOX Kids +1" },
	{ 0x3988, 0x0000, 0x0000, 0x0000, 16, "LA7" },
	{ 0x3989, 0x0000, 0x0000, 0x0000, 16, "PrimaTV" },
	{ 0x398A, 0x0000, 0x0000, 0x0000, 16, "SportItalia" },
	{ 0x3990, 0x1590, 0x0000, 0x0000, 16, "STUDIO UNIVERSAL" },
	{ 0x3991, 0x0000, 0x0000, 0x0000, 16, "Marcopolo" },
	{ 0x3992, 0x0000, 0x0000, 0x0000, 16, "Alice" },
	{ 0x3993, 0x0000, 0x0000, 0x0000, 16, "Nuvolari" },
	{ 0x3994, 0x0000, 0x0000, 0x0000, 16, "Leonardo" },
	{ 0x3996, 0x1596, 0x0000, 0x0000, 16, "SUPERPIPPA CHANNEL" },
	{ 0x3997, 0x0000, 0x0000, 0x0000, 16, "Tele+1" },
	{ 0x3998, 0x0000, 0x0000, 0x0000, 16, "Tele+2" },
	{ 0x3999, 0x0000, 0x0000, 0x0000, 16, "Tele+3" },
	{ 0x39A0, 0x15A0, 0x0000, 0x0000, 16, "Sky Calcio 8" },
	{ 0x39A1, 0x15A1, 0x0000, 0x0000, 16, "Sky Calcio 9" },
	{ 0x39A2, 0x15A2, 0x0000, 0x0000, 16, "Sky Calcio 10" },
	{ 0x39A3, 0x15A3, 0x0000, 0x0000, 16, "Sky Calcio 11" },
	{ 0x39A4, 0x15A4, 0x0000, 0x0000, 16, "Sky Calcio 12" },
	{ 0x39A5, 0x15A5, 0x0000, 0x0000, 16, "Sky Calcio 13" },
	{ 0x39A6, 0x15A6, 0x0000, 0x0000, 16, "Sky Calcio 14" },
	{ 0x39A7, 0x15A7, 0x0000, 0x0000, 16, "Telesanterno" },
	{ 0x39A8, 0x15A8, 0x0000, 0x0000, 16, "Telecentro" },
	{ 0x39A9, 0x15A9, 0x0000, 0x0000, 16, "Telestense" },
	{ 0x39B0, 0x15B0, 0x0000, 0x0000, 16, "Disney Channel +1" },
	{ 0x39B1, 0x0000, 0x0000, 0x0000, 16, "Sailing Channel" },
	{ 0x39B2, 0x15B2, 0x0000, 0x0000, 16, "Disney Channel" },
	{ 0x39B3, 0x15B3, 0x0000, 0x0000, 16, "7 Gold-Sestra Rete" },
	{ 0x39B4, 0x15B4, 0x0000, 0x0000, 16, "Rete 8-VGA" },
	{ 0x39B5, 0x15B5, 0x0000, 0x0000, 16, "Nuovarete" },
	{ 0x39B6, 0x15B6, 0x0000, 0x0000, 16, "Radio Italia TV" },
	{ 0x39B7, 0x15B7, 0x0000, 0x0000, 16, "Rete 7" },
	{ 0x39B8, 0x15B8, 0x0000, 0x0000, 16, "E! Entertainment Television" },
	{ 0x39B9, 0x15B9, 0x0000, 0x0000, 16, "Toon Disney" },
	{ 0x39C7, 0x15C7, 0x0000, 0x0000, 16, "Bassano TV" },
	{ 0x39C8, 0x15C8, 0x0000, 0x0000, 16, "ESPN Classic Sport" },
	{ 0x39CA, 0x0000, 0x0000, 0x0000, 16, "VIDEOLINA" },
	{ 0x39D1, 0x15D1, 0x0000, 0x0000, 16, "Mediaset Premium 5" },
	{ 0x39D2, 0x15D2, 0x0000, 0x0000, 16, "Mediaset Premium 1" },
	{ 0x39D3, 0x15D3, 0x0000, 0x0000, 16, "Mediaset Premium 2" },
	{ 0x39D4, 0x15D4, 0x0000, 0x0000, 16, "Mediaset Premium 3" },
	{ 0x39D5, 0x15D5, 0x0000, 0x0000, 16, "Mediaset Premium 4" },
	{ 0x39D6, 0x15D6, 0x0000, 0x0000, 16, "BOING" },
	{ 0x39D7, 0x15D7, 0x0000, 0x0000, 16, "Playlist Italia" },
	{ 0x39D8, 0x15D8, 0x0000, 0x0000, 16, "MATCH MUSIC" },
	{ 0x39E1, 0x15E1, 0x0000, 0x0000, 16, "National Geographic +1" },
	{ 0x39E2, 0x15E2, 0x0000, 0x0000, 16, "Histroy Channel +1" },
	{ 0x39E3, 0x15E3, 0x0000, 0x0000, 16, "Sky TV" },
	{ 0x39E4, 0x15E4, 0x0000, 0x0000, 16, "GXT" },
	{ 0x39E5, 0x15E5, 0x0000, 0x0000, 16, "Playhouse Disney" },
	{ 0x39E6, 0x15E6, 0x0000, 0x0000, 16, "Sky Canale 224" },
	{ 0x39F1, 0x0000, 0x0000, 0x0000, 16, "Teleradiocity" },
	{ 0x39F2, 0x0000, 0x0000, 0x0000, 16, "Teleradiocity Genova" },
	{ 0x39F3, 0x0000, 0x0000, 0x0000, 16, "Teleradiocity Lombardia" },
	{ 0x39F4, 0x0000, 0x0000, 0x0000, 16, "Telestar Piemonte" },
	{ 0x39F5, 0x0000, 0x0000, 0x0000, 16, "Telestar Liguria" },
	{ 0x39F6, 0x0000, 0x0000, 0x0000, 16, "Telestar Lombardia" },
	{ 0x39F7, 0x0000, 0x0000, 0x0000, 16, "Italia 8 Piemonte" },
	{ 0x39F8, 0x0000, 0x0000, 0x0000, 16, "Italia 8 Lombardia" },
	{ 0x3E00, 0x0000, 0x0000, 0x0000,  7, "TVE1" },
	{ 0x4000, 0x0000, 0x0000, 0x0000, 17, "RTL Télé Letzebuerg" },
	{ 0x4101, 0x24C1, 0x3441, 0x04C1,  3, "SRG Schweizer Fernsehen SF 1" },
	{ 0x4102, 0x24C2, 0x3442, 0x04C2,  3, "SSR Télévis. Suisse TSR 1" },
	{ 0x4103, 0x24C3, 0x3443, 0x04C3,  3, "SSR Televis. svizzera TSI 1" },
	{ 0x4107, 0x24C7, 0x3447, 0x04C7,  3, "SRG Schweizer Fernsehen SF 2" },
	{ 0x4108, 0x24C8, 0x3448, 0x04C8,  3, "SSR Télévis. Suisse TSR 2" },
	{ 0x4109, 0x24C9, 0x3449, 0x04C9,  3, "SSR Televis. svizzera TSI 2" },
	{ 0x410A, 0x24CA, 0x344A, 0x04CA,  3, "SRG SSR Sat Access" },
	{ 0x4121, 0x2421, 0x0000, 0x0000,  3, "U1" },
	{ 0x4201, 0x32C1, 0x3C21, 0x0000,  4, "CT 1" },
	{ 0x4202, 0x32C2, 0x3C22, 0x0000,  4, "CT 2" },
	{ 0x4203, 0x32C3, 0x3C23, 0x0000,  4, "NOVA TV" },
	{ 0x4204, 0x0000, 0x0000, 0x0000,  4, "Prima TV" },
	{ 0x4205, 0x0000, 0x0000, 0x0000,  4, "TV Praha" },
	{ 0x4206, 0x0000, 0x0000, 0x0000,  4, "TV HK" },
	{ 0x4207, 0x0000, 0x0000, 0x0000,  4, "TV Pardubice" },
	{ 0x4208, 0x0000, 0x0000, 0x0000,  4, "TV Brno" },
	{ 0x4211, 0x32D1, 0x3B01, 0x0000,  4, "CT1 Brno" },
	{ 0x4212, 0x32D2, 0x3B04, 0x0000,  4, "CT2 Brno" },
	{ 0x4221, 0x32E1, 0x3B02, 0x0000,  4, "CT1 Ostravia" },
	{ 0x4222, 0x32E2, 0x3B05, 0x0000,  4, "CT2 Ostravia" },
	{ 0x4231, 0x32F1, 0x3C25, 0x0000,  4, "CT1 Regional" },
	{ 0x4232, 0x32F2, 0x3B03, 0x0000,  4, "CT2 Regional" },
	{ 0x42A1, 0x35A1, 0x3521, 0x0000, 24, "STV1" },
	{ 0x42A2, 0x35A2, 0x3522, 0x0000, 24, "STV2" },
	{ 0x42A3, 0x35A3, 0x3523, 0x0000, 24, "STV1 Kosice" },
	{ 0x42A4, 0x35A4, 0x3524, 0x0000, 24, "STV2 Kosice" },
	{ 0x42A5, 0x35A5, 0x3525, 0x0000, 24, "STV1 B. Bystrica" },
	{ 0x42A6, 0x35A6, 0x3526, 0x0000, 24, "STV2 B. Bystrica" },
	{ 0x4301, 0x0000, 0x0000, 0x0AC1,  1, "ORF 1" },
	{ 0x4302, 0x0000, 0x0000, 0x0AC2,  1, "ORF 2" },
	{ 0x430C, 0x0000, 0x0000, 0x0ACA,  1, "ATV+" },
	{ 0x4401, 0x5BFA, 0x3B7A, 0x0000, 10, "UK GOLD" },
	{ 0x4402, 0x2C01, 0x3C01, 0x0000, 10, "UK LIVING" },
	{ 0x4403, 0x2C3C, 0x3C3C, 0x0000, 10, "WIRE TV" },
	{ 0x4404, 0x5BF0, 0x3B70, 0x0000, 10, "CHILDREN'S CHANNEL" },
	{ 0x4405, 0x5BEF, 0x3B6F, 0x0000, 10, "BRAVO" },
	{ 0x4406, 0x5BF7, 0x3B77, 0x0000, 10, "LEARNING CHANNEL" },
	{ 0x4407, 0x5BF2, 0x3B72, 0x0000, 10, "DISCOVERY" },
	{ 0x4408, 0x5BF3, 0x3B73, 0x0000, 10, "FAMILY CHANNEL" },
	{ 0x4409, 0x5BF8, 0x3B78, 0x0000, 10, "Live TV" },
	{ 0x4420, 0x0000, 0x0000, 0x0000, 10, "Discovery Home & Leisure" },
	{ 0x4440, 0x2C40, 0x3C40, 0x0000, 10, "BBC2" },
	{ 0x4441, 0x2C41, 0x3C41, 0x0000, 10, "BBC1 NI" },
	{ 0x4442, 0x2C42, 0x3C42, 0x0000, 10, "BBC2 Wales" },
	{ 0x4444, 0x2C44, 0x3C44, 0x0000, 10, "BBC2 Scotland" },
	{ 0x4457, 0x2C57, 0x3C57, 0x0000, 10, "BBC World" },
	{ 0x4468, 0x2C68, 0x3C68, 0x0000, 10, "BBC Prime" },
	{ 0x4469, 0x2C69, 0x3C69, 0x0000, 10, "BBC News 24" },
	{ 0x447B, 0x2C7B, 0x3C7B, 0x0000, 10, "BBC1 Scotland" },
	{ 0x447D, 0x2C7D, 0x3C7D, 0x0000, 10, "BBC1 Wales" },
	{ 0x447E, 0x2C7E, 0x3C7E, 0x0000, 10, "BBC2 NI" },
	{ 0x447F, 0x2C7F, 0x3C7F, 0x0000, 10, "BBC1" },
	{ 0x44C1, 0x0000, 0x0000, 0x0000, 10, "TNT / Cartoon Network" },
	{ 0x44D1, 0x5BCC, 0x3B4C, 0x0000, 10, "DISNEY CHANNEL UK" },
	{ 0x4502, 0x2902, 0x3902, 0x0000,  6, "TV2" },
	{ 0x4503, 0x2904, 0x3904, 0x0000,  6, "TV2 Zulu" },
	{ 0x4504, 0x0000, 0x0000, 0x0000,  6, "Discovery Denmark" },
	{ 0x4505, 0x2905, 0x0000, 0x0000,  6, "TV2 Charlie" },
	{ 0x4506, 0x2906, 0x0000, 0x0000,  6, "TV Danmark" },
	{ 0x4507, 0x2907, 0x0000, 0x0000,  6, "Kanal 5" },
	{ 0x4508, 0x2908, 0x0000, 0x0000,  6, "TV2 Film" },
	{ 0x4600, 0x4E00, 0x3E00, 0x0000, 22, "SVT Test Transmissions" },
	{ 0x4601, 0x4E01, 0x3E01, 0x0000, 22, "SVT 1" },
	{ 0x4602, 0x4E02, 0x3E02, 0x0000, 22, "SVT 2" },
	{ 0x4640, 0x4E40, 0x3E40, 0x0000, 22, "TV 4" },
	{ 0x4701, 0x0000, 0x0000, 0x0000, 19, "NRK1" },
	{ 0x4702, 0x0000, 0x0000, 0x0000, 19, "TV 2" },
	{ 0x4703, 0x0000, 0x0000, 0x0000, 19, "NRK2" },
	{ 0x4704, 0x0000, 0x0000, 0x0000, 19, "TV Norge" },
	{ 0x4720, 0x0000, 0x0000, 0x0000, 19, "Discovery Nordic" },
	{ 0x4801, 0x0000, 0x0000, 0x0000, 20, "TVP1" },
	{ 0x4802, 0x0000, 0x0000, 0x0000, 20, "TVP2" },
	{ 0x4810, 0x0000, 0x0000, 0x0000, 20, "TV Polonia" },
	{ 0x4820, 0x0000, 0x0000, 0x0000, 20, "TVN" },
	{ 0x4821, 0x0000, 0x0000, 0x0000, 20, "TVN Siedem" },
	{ 0x4822, 0x0000, 0x0000, 0x0000, 20, "TVN24" },
	{ 0x4830, 0x0000, 0x0000, 0x0000, 20, "Discovery Poland" },
	{ 0x4831, 0x0000, 0x0000, 0x0000, 20, "Animal Planet" },
	{ 0x4880, 0x0000, 0x0000, 0x0000, 20, "TVP Warszawa" },
	{ 0x4881, 0x0000, 0x0000, 0x0000, 20, "TVP Bialystok" },
	{ 0x4882, 0x0000, 0x0000, 0x0000, 20, "TVP Bydgoszcz" },
	{ 0x4883, 0x0000, 0x0000, 0x0000, 20, "TVP Gdansk" },
	{ 0x4884, 0x0000, 0x0000, 0x0000, 20, "TVP Katowice" },
	{ 0x4886, 0x0000, 0x0000, 0x0000, 20, "TVP Krakow" },
	{ 0x4887, 0x0000, 0x0000, 0x0000, 20, "TVP Lublin" },
	{ 0x4888, 0x0000, 0x0000, 0x0000, 20, "TVP Lodz" },
	{ 0x4890, 0x0000, 0x0000, 0x0000, 20, "TVP Rzeszow" },
	{ 0x4891, 0x0000, 0x0000, 0x0000, 20, "TVP Poznan" },
	{ 0x4892, 0x0000, 0x0000, 0x0000, 20, "TVP Szczecin" },
	{ 0x4893, 0x0000, 0x0000, 0x0000, 20, "TVP Wroclaw" },
	{ 0x4901, 0x0000, 0x3D41, 0x0DC1,  5, "ARD" },
	{ 0x4902, 0x0000, 0x3D42, 0x0DC2,  5, "ZDF" },
	{ 0x4908, 0x0000, 0x0000, 0x0DC8,  5, "Phoenix" },
	{ 0x490A, 0x0000, 0x3D05, 0x0D85,  5, "Arte" },
	{ 0x490C, 0x0000, 0x0000, 0x0D8E,  5, "VOX" },
	{ 0x4941, 0x0000, 0x0000, 0x0D41,  5, "FESTIVAL" },
	{ 0x4942, 0x0000, 0x0000, 0x0D42,  5, "MUXX" },
	{ 0x4943, 0x0000, 0x0000, 0x0D43,  5, "EXTRA" },
	{ 0x4944, 0x0000, 0x0000, 0x0000,  5, "BR-Alpha" },
	{ 0x4982, 0x0000, 0x0000, 0x0D82,  5, "ORB-3" },
	{ 0x49BD, 0x0000, 0x0000, 0x0D77,  5, "1-2-3.TV" },
	{ 0x49BE, 0x0000, 0x0000, 0x0D78,  5, "TELE-5" },
	{ 0x49BF, 0x0000, 0x0000, 0x0D7F,  5, "Home Shopping Europe" },
	{ 0x49C7, 0x0000, 0x0000, 0x0DC7,  5, "3sat" },
	{ 0x49C9, 0x0000, 0x0000, 0x0DC9,  5, "Kinderkanal" },
	{ 0x49CB, 0x0000, 0x3D4B, 0x0DCB,  5, "BR-3" },
	{ 0x49CF, 0x2903, 0x3903, 0x0000,  6, "DR2" },
	{ 0x49D4, 0x0000, 0x0000, 0x0DD5,  5, "NDR-3 Dreiländerweit" },
	{ 0x49D9, 0x0000, 0x0000, 0x0DDA,  5, "RB-3" },
	{ 0x49DC, 0x0000, 0x0000, 0x0DDC,  5, "SFB-3" },
	{ 0x49DF, 0x0000, 0x0000, 0x0DDF,  5, "SR-1 Regional" },
	{ 0x49E1, 0x0000, 0x0000, 0x0DE1,  5, "SW 3 Baden-Württemberg" },
	{ 0x49E4, 0x0000, 0x0000, 0x0DE4,  5, "SW 3 Rheinland-Pfalz" },
	{ 0x49E6, 0x0000, 0x0000, 0x0DE6,  5, "WDR-3" },
	{ 0x49FE, 0x0000, 0x0000, 0x0DFE,  5, "MDR-3" },
	{ 0x49FF, 0x0000, 0x0000, 0x0DCF,  5, "Hessen 3" },
	{ 0x4D54, 0x2C14, 0x3C14, 0x0000, 10, "MTV" },
	{ 0x4D58, 0x2C20, 0x3C20, 0x0000, 10, "VH-1" },
	{ 0x4D59, 0x2C21, 0x3C21, 0x0000, 10, "VH-1 German" },
	{ 0x4D5A, 0x5BF4, 0x3B74, 0x0000, 10, "GRANADA PLUS" },
	{ 0x4D5B, 0x5BF5, 0x3B75, 0x0000, 10, "GRANADA Timeshare" },
	{ 0x5AAF, 0x2C3F, 0x3C3F, 0x0000, 10, "HTV" },
	{ 0x5C44, 0x0000, 0x0000, 0x0000, 10, "QVC UK" },
	{ 0x5C49, 0x0000, 0x0000, 0x0D7D,  5, "QVC" },
	{ 0x7392, 0x2901, 0x3901, 0x0000,  6, "DR1" },
	{ 0x7700, 0x0000, 0x0000, 0x07C0, 27, "1+1" },
	{ 0x7705, 0x0000, 0x0000, 0x07C5, 27, "M1" },
	{ 0x7707, 0x0000, 0x0000, 0x0000, 27, "ICTV" },
	{ 0x7708, 0x0000, 0x0000, 0x07C8, 27, "Novy Kanal" },
	{ 0x82DD, 0x2C1D, 0x3C1D, 0x0000, 10, "CARLTON TV" },
	{ 0x82E1, 0x2C05, 0x3C05, 0x0000, 10, "CARLTON SELECT" },
	{ 0x833B, 0x2C3D, 0x3C3D, 0x0000, 10, "ULSTER TV" },
	{ 0x884B, 0x2C0B, 0x3C0B, 0x0000, 10, "LWT" },
	{ 0x8E71, 0x2C31, 0x3C31, 0x0E86, 10, "NBC Europe" },
	{ 0x8E72, 0x2C35, 0x3C35, 0x0000, 10, "CNBC Europe" },
	{ 0x9001, 0x4301, 0x3301, 0x0000, 26, "TRT-1" },
	{ 0x9002, 0x4302, 0x3302, 0x0000, 26, "TRT-2" },
	{ 0x9003, 0x4303, 0x3303, 0x0000, 26, "TRT-3" },
	{ 0x9004, 0x4304, 0x3304, 0x0000, 26, "TRT-4" },
	{ 0x9005, 0x4305, 0x3305, 0x0000, 26, "TRT-INT" },
	{ 0x9006, 0x4306, 0x3306, 0x0000, 26, "AVRASYA" },
	{ 0x9007, 0x0000, 0x0000, 0x0000, 26, "Show TV" },
	{ 0x9008, 0x0000, 0x0000, 0x0000, 26, "Cine 5" },
	{ 0x9009, 0x0000, 0x0000, 0x0000, 26, "Super Sport" },
	{ 0x900A, 0x0000, 0x0000, 0x0000, 26, "ATV" },
	{ 0x900B, 0x0000, 0x0000, 0x0000, 26, "KANAL D" },
	{ 0x900C, 0x0000, 0x0000, 0x0000, 26, "EURO D" },
	{ 0x900D, 0x0000, 0x0000, 0x0000, 26, "EKO TV" },
	{ 0x900E, 0x0000, 0x0000, 0x0000, 26, "BRAVO TV" },
	{ 0x900F, 0x0000, 0x0000, 0x0000, 26, "GALAKSI TV" },
	{ 0x9010, 0x0000, 0x0000, 0x0000, 26, "FUN TV" },
	{ 0x9011, 0x0000, 0x0000, 0x0000, 26, "TEMPO TV" },
	{ 0x9014, 0x0000, 0x0000, 0x0000, 26, "TGRT" },
	{ 0x9020, 0x0000, 0x0000, 0x0000, 26, "STAR TV" },
	{ 0x9021, 0x0000, 0x0000, 0x0000, 26, "STARMAX" },
	{ 0x9022, 0x0000, 0x0000, 0x0000, 26, "KANAL 6" },
	{ 0x9023, 0x0000, 0x0000, 0x0000, 26, "STAR 4" },
	{ 0x9024, 0x0000, 0x0000, 0x0000, 26, "STAR 5" },
	{ 0x9025, 0x0000, 0x0000, 0x0000, 26, "STAR 6" },
	{ 0x9026, 0x0000, 0x0000, 0x0000, 26, "STAR 7" },
	{ 0x9027, 0x0000, 0x0000, 0x0000, 26, "STAR 8" },
	{ 0x9602, 0x2C02, 0x3C02, 0x0000, 10, "CHANNEL 5 (1)" },
	{ 0xA460, 0x0000, 0x0000, 0x0000, 10, "Nickelodeon UK" },
	{ 0xA465, 0x0000, 0x0000, 0x0000, 10, "Paramount Comedy Channel UK" },
	{ 0xA55A, 0x0000, 0x0000, 0x0000,  7, "Canal+" },
	{ 0xA82C, 0x2C2C, 0x3C2C, 0x0000, 10, "TYNE TEES TV" },
	{ 0xAAE1, 0x0000, 0x0000, 0x0000, 23, "SLO1" },
	{ 0xAAE2, 0x0000, 0x0000, 0x0000, 23, "SLO2" },
	{ 0xAAE3, 0x0000, 0x0000, 0x0000, 23, "KC" },
	{ 0xAAE4, 0x0000, 0x0000, 0x0000, 23, "TLM" },
	{ 0xAAF1, 0x0000, 0x0000, 0x0000, 23, "SLO3" },
	{ 0xADD8, 0x2C18, 0x3C18, 0x0000, 10, "GRANADA TV" },
	{ 0xADDC, 0x5BD2, 0x3B52, 0x0000, 10, "GMTV" },
	{ 0xB4C7, 0x2C07, 0x3C07, 0x0000, 10, "S4C" },
	{ 0xB7F7, 0x2C27, 0x3C27, 0x0000, 10, "BORDER TV" },
	{ 0xBA01, 0x0000, 0x0000, 0x0000,  7, "ETB 1" },
	{ 0xC47B, 0x2C3B, 0x3C3B, 0x0000, 10, "CHANNEL 5 (4)" },
	{ 0xC4F4, 0x42F4, 0x3274, 0x0000, 10, "FilmFour" },
	{ 0xC8DE, 0x2C1E, 0x3C1E, 0x0000, 10, "ITV NETWORK" },
	{ 0xCA03, 0x0000, 0x0000, 0x0000,  7, "TV3" },
	{ 0xCA33, 0x0000, 0x0000, 0x0000,  7, "C33" },
	{ 0xE100, 0x0000, 0x0000, 0x0000,  7, "TVE2" },
	{ 0xE200, 0x0000, 0x0000, 0x0000,  7, "TVE Internacional Europa" },
	{ 0xE500, 0x1FE5, 0x0000, 0x0000,  7, "Tele5" },
	{ 0xF101, 0x2FE2, 0x3F62, 0x0000,  9, "Eurosport" },
	{ 0xF102, 0x2FE3, 0x3F63, 0x0000,  9, "Eurosport2" },
	{ 0xF103, 0x2FE4, 0x3F64, 0x0000,  9, "Eurosportnews" },
	{ 0xF33A, 0x2C3A, 0x3C3A, 0x0000, 10, "GRAMPIAN TV" },
	{ 0xF500, 0x2FE5, 0x3F65, 0x0000,  9, "TV5" },
	{ 0xF9D2, 0x2C12, 0x3C12, 0x0000, 10, "SCOTTISH TV" },
	{ 0xFA04, 0x0000, 0x0000, 0x0000, 16, "Rete 4" },
	{ 0xFA05, 0x0000, 0x0000, 0x0000, 16, "Canale 5" },
	{ 0xFA06, 0x0000, 0x0000, 0x0000, 16, "Italia 1" },
	{ 0xFA08, 0x0000, 0x0000, 0x0000, 16, "TMC" },
	{ 0xFA2C, 0x2C2D, 0x3C2D, 0x0000, 10, "YORKSHIRE TV" },
	{ 0xFB9C, 0x2C1C, 0x3C1C, 0x0000, 10, "ANGLIA TV" },
	{ 0xFCD1, 0x2C11, 0x3C11, 0x0000, 10, "CHANNEL 4" },
	{ 0xFCE4, 0x2C24, 0x3C24, 0x0000, 10, "CHANNEL TV" },
	{ 0xFCF3, 0x2C13, 0x3C13, 0x0000, 10, "RACING CHANNEL" },
	{ 0xFCF4, 0x5BF6, 0x3B76, 0x0000, 10, "HISTORY CHANNEL" },
	{ 0xFCF5, 0x2C15, 0x3C15, 0x0000, 10, "SCI FI CHANNEL" },
	{ 0xFCF6, 0x5BF9, 0x3B79, 0x0000, 10, "SKY TRAVEL" },
	{ 0xFCF7, 0x2C17, 0x3C17, 0x0000, 10, "SKY SOAPS" },
	{ 0xFCF8, 0x2C08, 0x3C08, 0x0000, 10, "SKY SPORTS 2" },
	{ 0xFCF9, 0x2C19, 0x3C19, 0x0000, 10, "SKY GOLD" },
	{ 0xFCFA, 0x2C1A, 0x3C1A, 0x0000, 10, "SKY SPORTS" },
	{ 0xFCFB, 0x2C1B, 0x3C1B, 0x0000, 10, "MOVIE CHANNEL" },
	{ 0xFCFC, 0x2C0C, 0x3C0C, 0x0000, 10, "SKY MOVIES PLUS" },
	{ 0xFCFD, 0x2C0D, 0x3C0D, 0x0000, 10, "SKY NEWS" },
	{ 0xFCFE, 0x2C0E, 0x3C0E, 0x0000, 10, "SKY ONE" },
	{ 0xFCFF, 0x2C0F, 0x3C0F, 0x0000, 10, "SKY TWO" },
	{ 0xFE01, 0x2FE1, 0x3F61, 0x0000,  9, "Euronews" },
};

/* 615 */

static const uint16_t
lookup_cni_8302 [] = {
	278, /* 1505 */
	282, /* 1511 */
	283, /* 1512 */
	284, /* 1513 */
	285, /* 1514 */
	286, /* 1515 */
	287, /* 1516 */
	288, /* 1517 */
	289, /* 1518 */
	290, /* 1519 */
	308, /* 1542 */
	309, /* 1543 */
	310, /* 1544 */
	311, /* 1545 */
	312, /* 1546 */
	313, /* 1547 */
	314, /* 1548 */
	315, /* 1549 */
	324, /* 1560 */
	328, /* 1568 */
	336, /* 1577 */
	337, /* 1578 */
	338, /* 1579 */
	339, /* 1580 */
	340, /* 1581 */
	347, /* 1590 */
	352, /* 1596 */
	356, /* 15A0 */
	357, /* 15A1 */
	358, /* 15A2 */
	359, /* 15A3 */
	360, /* 15A4 */
	361, /* 15A5 */
	362, /* 15A6 */
	363, /* 15A7 */
	364, /* 15A8 */
	365, /* 15A9 */
	366, /* 15B0 */
	368, /* 15B2 */
	369, /* 15B3 */
	370, /* 15B4 */
	371, /* 15B5 */
	372, /* 15B6 */
	373, /* 15B7 */
	374, /* 15B8 */
	375, /* 15B9 */
	376, /* 15C7 */
	377, /* 15C8 */
	379, /* 15D1 */
	380, /* 15D2 */
	381, /* 15D3 */
	382, /* 15D4 */
	383, /* 15D5 */
	384, /* 15D6 */
	385, /* 15D7 */
	386, /* 15D8 */
	387, /* 15E1 */
	388, /* 15E2 */
	389, /* 15E3 */
	390, /* 15E4 */
	391, /* 15E5 */
	392, /* 15E6 */
	157, /* 1601 */
	158, /* 1602 */
	127, /* 1604 */
	161, /* 1605 */
	162, /* 1606 */
	586, /* 1FE5 */
	135, /* 2101 */
	136, /* 2102 */
	137, /* 2103 */
	410, /* 2421 */
	403, /* 24C1 */
	404, /* 24C2 */
	405, /* 24C3 */
	406, /* 24C7 */
	407, /* 24C8 */
	408, /* 24C9 */
	409, /* 24CA */
	259, /* 2601 */
	260, /* 2602 */
	261, /* 260F */
	527, /* 2901 */
	457, /* 2902 */
	509, /* 2903 */
	458, /* 2904 */
	460, /* 2905 */
	461, /* 2906 */
	462, /* 2907 */
	463, /* 2908 */
	435, /* 2C01 */
	564, /* 2C02 */
	533, /* 2C05 */
	576, /* 2C07 */
	606, /* 2C08 */
	131, /* 2C09 */
	535, /* 2C0B */
	610, /* 2C0C */
	611, /* 2C0D */
	612, /* 2C0E */
	613, /* 2C0F */
	599, /* 2C11 */
	592, /* 2C12 */
	601, /* 2C13 */
	519, /* 2C14 */
	603, /* 2C15 */
	605, /* 2C17 */
	574, /* 2C18 */
	607, /* 2C19 */
	608, /* 2C1A */
	609, /* 2C1B */
	598, /* 2C1C */
	532, /* 2C1D */
	581, /* 2C1E */
	520, /* 2C20 */
	521, /* 2C21 */
	600, /* 2C24 */
	273, /* 2C25 */
	577, /* 2C27 */
	133, /* 2C2B */
	568, /* 2C2C */
	597, /* 2C2D */
	132, /* 2C30 */
	536, /* 2C31 */
	130, /* 2C34 */
	537, /* 2C35 */
	134, /* 2C37 */
	590, /* 2C3A */
	579, /* 2C3B */
	436, /* 2C3C */
	534, /* 2C3D */
	524, /* 2C3F */
	444, /* 2C40 */
	445, /* 2C41 */
	446, /* 2C42 */
	447, /* 2C44 */
	448, /* 2C57 */
	449, /* 2C68 */
	450, /* 2C69 */
	451, /* 2C7B */
	452, /* 2C7D */
	453, /* 2C7E */
	454, /* 2C7F */
	238, /* 2F01 */
	239, /* 2F02 */
	240, /* 2F03 */
	241, /* 2F04 */
	242, /* 2F05 */
	243, /* 2F06 */
	218, /* 2F0A */
	219, /* 2F11 */
	220, /* 2F12 */
	221, /* 2F20 */
	222, /* 2F21 */
	223, /* 2F22 */
	226, /* 2FC1 */
	227, /* 2FC2 */
	228, /* 2FC3 */
	229, /* 2FC4 */
	230, /* 2FC5 */
	231, /* 2FC6 */
	232, /* 2FC7 */
	233, /* 2FC8 */
	234, /* 2FC9 */
	235, /* 2FCA */
	236, /* 2FCB */
	237, /* 2FCC */
	614, /* 2FE1 */
	587, /* 2FE2 */
	588, /* 2FE3 */
	589, /* 2FE4 */
	591, /* 2FE5 */
	411, /* 32C1 */
	412, /* 32C2 */
	413, /* 32C3 */
	419, /* 32D1 */
	420, /* 32D2 */
	421, /* 32E1 */
	422, /* 32E2 */
	423, /* 32F1 */
	424, /* 32F2 */
	425, /* 35A1 */
	426, /* 35A2 */
	427, /* 35A3 */
	428, /* 35A4 */
	429, /* 35A5 */
	430, /* 35A6 */
	255, /* 4201 */
	256, /* 4202 */
	257, /* 4203 */
	580, /* 42F4 */
	538, /* 4301 */
	539, /* 4302 */
	540, /* 4303 */
	541, /* 4304 */
	542, /* 4305 */
	543, /* 4306 */
	138, /* 4801 */
	139, /* 4802 */
	140, /* 4803 */
	141, /* 4804 */
	142, /* 4805 */
	143, /* 4806 */
	144, /* 4820 */
	156, /* 4847 */
	464, /* 4E00 */
	465, /* 4E01 */
	466, /* 4E02 */
	467, /* 4E40 */
	456, /* 5BCC */
	575, /* 5BD2 */
	438, /* 5BEF */
	437, /* 5BF0 */
	125, /* 5BF1 */
	440, /* 5BF2 */
	441, /* 5BF3 */
	522, /* 5BF4 */
	523, /* 5BF5 */
	602, /* 5BF6 */
	439, /* 5BF7 */
	442, /* 5BF8 */
	604, /* 5BF9 */
	434, /* 5BFA */
};

static const uint16_t
lookup_cni_pdc_b [] = {
	135, /* 3101 */
	136, /* 3102 */
	137, /* 3103 */
	255, /* 3201 */
	256, /* 3202 */
	257, /* 3203 */
	580, /* 3274 */
	538, /* 3301 */
	539, /* 3302 */
	540, /* 3303 */
	541, /* 3304 */
	542, /* 3305 */
	543, /* 3306 */
	403, /* 3441 */
	404, /* 3442 */
	405, /* 3443 */
	406, /* 3447 */
	407, /* 3448 */
	408, /* 3449 */
	409, /* 344A */
	425, /* 3521 */
	426, /* 3522 */
	427, /* 3523 */
	428, /* 3524 */
	429, /* 3525 */
	430, /* 3526 */
	259, /* 3601 */
	158, /* 3602 */
	157, /* 3603 */
	127, /* 3604 */
	161, /* 3605 */
	162, /* 3606 */
	260, /* 3607 */
	261, /* 3614 */
	138, /* 3801 */
	139, /* 3802 */
	140, /* 3803 */
	141, /* 3804 */
	142, /* 3805 */
	143, /* 3806 */
	144, /* 3820 */
	156, /* 3847 */
	527, /* 3901 */
	457, /* 3902 */
	509, /* 3903 */
	458, /* 3904 */
	419, /* 3B01 */
	421, /* 3B02 */
	424, /* 3B03 */
	420, /* 3B04 */
	422, /* 3B05 */
	456, /* 3B4C */
	575, /* 3B52 */
	438, /* 3B6F */
	437, /* 3B70 */
	125, /* 3B71 */
	440, /* 3B72 */
	441, /* 3B73 */
	522, /* 3B74 */
	523, /* 3B75 */
	602, /* 3B76 */
	439, /* 3B77 */
	442, /* 3B78 */
	604, /* 3B79 */
	434, /* 3B7A */
	435, /* 3C01 */
	564, /* 3C02 */
	533, /* 3C05 */
	576, /* 3C07 */
	606, /* 3C08 */
	131, /* 3C09 */
	535, /* 3C0B */
	610, /* 3C0C */
	611, /* 3C0D */
	612, /* 3C0E */
	613, /* 3C0F */
	599, /* 3C11 */
	592, /* 3C12 */
	601, /* 3C13 */
	519, /* 3C14 */
	603, /* 3C15 */
	605, /* 3C17 */
	574, /* 3C18 */
	607, /* 3C19 */
	608, /* 3C1A */
	609, /* 3C1B */
	598, /* 3C1C */
	532, /* 3C1D */
	581, /* 3C1E */
	520, /* 3C20 */
	521, /* 3C21 */
	412, /* 3C22 */
	413, /* 3C23 */
	600, /* 3C24 */
	423, /* 3C25 */
	577, /* 3C27 */
	133, /* 3C2B */
	568, /* 3C2C */
	597, /* 3C2D */
	132, /* 3C30 */
	536, /* 3C31 */
	130, /* 3C34 */
	537, /* 3C35 */
	134, /* 3C37 */
	590, /* 3C3A */
	579, /* 3C3B */
	436, /* 3C3C */
	534, /* 3C3D */
	524, /* 3C3F */
	444, /* 3C40 */
	445, /* 3C41 */
	446, /* 3C42 */
	447, /* 3C44 */
	448, /* 3C57 */
	449, /* 3C68 */
	450, /* 3C69 */
	451, /* 3C7B */
	452, /* 3C7D */
	453, /* 3C7E */
	454, /* 3C7F */
	496, /* 3D05 */
	493, /* 3D41 */
	494, /* 3D42 */
	508, /* 3D4B */
	464, /* 3E00 */
	465, /* 3E01 */
	466, /* 3E02 */
	467, /* 3E40 */
	238, /* 3F01 */
	239, /* 3F02 */
	240, /* 3F03 */
	241, /* 3F04 */
	242, /* 3F05 */
	243, /* 3F06 */
	218, /* 3F0A */
	219, /* 3F11 */
	220, /* 3F12 */
	221, /* 3F20 */
	222, /* 3F21 */
	223, /* 3F22 */
	226, /* 3F41 */
	227, /* 3F42 */
	228, /* 3F43 */
	229, /* 3F44 */
	230, /* 3F45 */
	231, /* 3F46 */
	232, /* 3F47 */
	233, /* 3F48 */
	234, /* 3F49 */
	235, /* 3F4A */
	236, /* 3F4B */
	237, /* 3F4C */
	614, /* 3F61 */
	587, /* 3F62 */
	588, /* 3F63 */
	589, /* 3F64 */
	591, /* 3F65 */
};

static const uint16_t
lookup_cni_vps [] = {
	  0, /* 0481 */
	  1, /* 0482 */
	  2, /* 0483 */
	  3, /* 0484 */
	  4, /* 0485 */
	  5, /* 0486 */
	  6, /* 0487 */
	  7, /* 0488 */
	403, /* 04C1 */
	404, /* 04C2 */
	405, /* 04C3 */
	406, /* 04C7 */
	407, /* 04C8 */
	408, /* 04C9 */
	409, /* 04CA */
	528, /* 07C0 */
	529, /* 07C5 */
	531, /* 07C8 */
	431, /* 0AC1 */
	432, /* 0AC2 */
	  8, /* 0AC3 */
	433, /* 0ACA */
	  9, /* 0ACB */
	 10, /* 0ACC */
	 11, /* 0ACD */
	 12, /* 0ACE */
	 13, /* 0ACF */
	 14, /* 0AD0 */
	 15, /* 0AD1 */
	 16, /* 0AD2 */
	 17, /* 0AD3 */
	128, /* 0D14 */
	498, /* 0D41 */
	499, /* 0D42 */
	500, /* 0D43 */
	 18, /* 0D75 */
	 19, /* 0D76 */
	503, /* 0D77 */
	504, /* 0D78 */
	 20, /* 0D79 */
	 21, /* 0D7A */
	 22, /* 0D7B */
	 23, /* 0D7C */
	526, /* 0D7D */
	 24, /* 0D7E */
	505, /* 0D7F */
	 25, /* 0D81 */
	502, /* 0D82 */
	496, /* 0D85 */
	 26, /* 0D87 */
	 27, /* 0D88 */
	 28, /* 0D89 */
	 29, /* 0D8A */
	 30, /* 0D8B */
	 31, /* 0D8C */
	 32, /* 0D8D */
	497, /* 0D8E */
	129, /* 0D8F */
	 33, /* 0D90 */
	 34, /* 0D91 */
	 35, /* 0D92 */
	 36, /* 0D94 */
	 37, /* 0D95 */
	 38, /* 0D96 */
	 39, /* 0D97 */
	 40, /* 0D98 */
	 41, /* 0D99 */
	 42, /* 0D9A */
	 43, /* 0D9B */
	 44, /* 0D9C */
	 45, /* 0D9D */
	 46, /* 0D9E */
	 47, /* 0D9F */
	 48, /* 0DA0 */
	 49, /* 0DA1 */
	 50, /* 0DA2 */
	 51, /* 0DA3 */
	 52, /* 0DA4 */
	 53, /* 0DA5 */
	 54, /* 0DA6 */
	 55, /* 0DA7 */
	 56, /* 0DA8 */
	 57, /* 0DA9 */
	 58, /* 0DAA */
	 59, /* 0DAB */
	 60, /* 0DAC */
	 61, /* 0DAD */
	 62, /* 0DAE */
	 63, /* 0DAF */
	 64, /* 0DB0 */
	 65, /* 0DB1 */
	 66, /* 0DB2 */
	 67, /* 0DB3 */
	 68, /* 0DB4 */
	 69, /* 0DB5 */
	 70, /* 0DB6 */
	 71, /* 0DB7 */
	 72, /* 0DB8 */
	 73, /* 0DB9 */
	 74, /* 0DBA */
	 75, /* 0DBB */
	 76, /* 0DBD */
	 77, /* 0DBE */
	 78, /* 0DBF */
	493, /* 0DC1 */
	494, /* 0DC2 */
	 79, /* 0DC3 */
	 80, /* 0DC4 */
	 81, /* 0DC5 */
	506, /* 0DC7 */
	495, /* 0DC8 */
	507, /* 0DC9 */
	 82, /* 0DCA */
	508, /* 0DCB */
	 83, /* 0DCC */
	 84, /* 0DCD */
	 85, /* 0DCE */
	518, /* 0DCF */
	 86, /* 0DD0 */
	 87, /* 0DD1 */
	 88, /* 0DD2 */
	 89, /* 0DD3 */
	 90, /* 0DD4 */
	510, /* 0DD5 */
	 91, /* 0DD6 */
	 92, /* 0DD7 */
	 93, /* 0DD8 */
	 94, /* 0DD9 */
	511, /* 0DDA */
	 95, /* 0DDB */
	512, /* 0DDC */
	 96, /* 0DDD */
	 97, /* 0DDE */
	513, /* 0DDF */
	 98, /* 0DE0 */
	514, /* 0DE1 */
	 99, /* 0DE2 */
	100, /* 0DE3 */
	515, /* 0DE4 */
	101, /* 0DE5 */
	516, /* 0DE6 */
	102, /* 0DE7 */
	103, /* 0DE8 */
	104, /* 0DE9 */
	105, /* 0DEA */
	106, /* 0DEB */
	107, /* 0DEC */
	108, /* 0DED */
	109, /* 0DEE */
	110, /* 0DEF */
	111, /* 0DF0 */
	112, /* 0DF1 */
	113, /* 0DF2 */
	114, /* 0DF3 */
	115, /* 0DF4 */
	116, /* 0DF5 */
	117, /* 0DF6 */
	118, /* 0DF7 */
	119, /* 0DF8 */
	120, /* 0DF9 */
	121, /* 0DFA */
	122, /* 0DFB */
	123, /* 0DFC */
	124, /* 0DFD */
	517, /* 0DFE */
	536, /* 0E86 */
};

static const struct ttx_header
ttx_header_table [] = {
	{ "MTV", "### MTVtext   ##.##.##  " },
	{ "UPC Telekabel", "###?Wiener?Kabel?Text  " },
	{ "TW1", "###?TW1  " },
};

