/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.ksfl;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class KSFLUtilities {
    public static final long UINT48_MAX_VALUE = 0xFFFFFFFFFFFFL;
    private static final String[] LOOKUP_HEX = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B", "1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C", "3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D", "5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E", "7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA", "AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB", "CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1", "E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC", "ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF"};

    private KSFLUtilities() {
    }

    public static long reverseUInt48(long v) {
        return Long.reverseBytes(v) >>> 16;
    }

    public static long readUInt48(DataInput in) throws IOException {
        long l = ((long)in.readShort() & 0xFFFFL) << 32;
        return l |= (long)in.readInt() & 0xFFFFFFFFL;
    }

    public static void writeUInt48(DataOutput out, long v) throws IOException {
        out.writeShort((short)(v >>> 32 & 0xFFFFL));
        out.writeInt((int)(v & 0xFFFFFFFFL));
    }

    public static byte occ(byte[] type) {
        if (type.length < 1) {
            return 32;
        }
        return type[0];
    }

    public static byte occ(String type) {
        if (type.length() < 1) {
            return 32;
        }
        return (byte)type.charAt(0);
    }

    public static byte occ(char[] type) {
        if (type.length < 1) {
            return 32;
        }
        return (byte)type[0];
    }

    public static String occs(byte type) {
        return Character.toString((char)(type & 0xFF));
    }

    public static short tcc(byte[] type) {
        switch (type.length) {
            case 0: {
                return 8224;
            }
            case 1: {
                return (short)((type[0] & 0xFF) << 8 | 0x20);
            }
        }
        return (short)((type[0] & 0xFF) << 8 | type[1] & 0xFF);
    }

    public static int tcc(String type) {
        try {
            return KSFLUtilities.tcc(type.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException uee) {
            return KSFLUtilities.tcc(type.getBytes());
        }
    }

    public static int tcc(char[] type) {
        return KSFLUtilities.tcc(new String(type));
    }

    public static String tccs(short type) {
        byte[] a = new byte[]{(byte)(type >>> 8 & 0xFF), (byte)(type >>> 0 & 0xFF)};
        try {
            return new String(a, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(a);
        }
    }

    public static int fcc(byte[] type) {
        switch (type.length) {
            case 0: {
                return 0x20202020;
            }
            case 1: {
                return (type[0] & 0xFF) << 24 | 0x202020;
            }
            case 2: {
                return ((type[0] & 0xFF) << 8 | type[1] & 0xFF) << 16 | 0x2020;
            }
            case 3: {
                return (((type[0] & 0xFF) << 8 | type[1] & 0xFF) << 8 | type[2] & 0xFF) << 8 | 0x20;
            }
        }
        return (((type[0] & 0xFF) << 8 | type[1] & 0xFF) << 8 | type[2] & 0xFF) << 8 | type[3] & 0xFF;
    }

    public static int fcc(String type) {
        try {
            return KSFLUtilities.fcc(type.getBytes("MACROMAN"));
        }
        catch (UnsupportedEncodingException e) {
            return KSFLUtilities.fcc(type.getBytes());
        }
    }

    public static int fcc(char[] type) {
        return KSFLUtilities.fcc(new String(type));
    }

    public static String fccs(int type) {
        byte[] a = new byte[]{(byte)(type >> 24 & 0xFF), (byte)(type >> 16 & 0xFF), (byte)(type >> 8 & 0xFF), (byte)(type >> 0 & 0xFF)};
        try {
            return new String(a, "MACROMAN");
        }
        catch (UnsupportedEncodingException e) {
            return new String(a);
        }
    }

    public static long ecc(byte[] type) {
        long l = 0L;
        int i = 0;
        while (i < type.length && i < 8) {
            l <<= 8;
            l |= (long)type[i] & 0xFFL;
            ++i;
        }
        while (i < 8) {
            l <<= 8;
            l |= 0x20L;
            ++i;
        }
        return l;
    }

    public static long ecc(String type) {
        try {
            if (type.length() > 4) {
                return KSFLUtilities.ecc(type.getBytes("ISO-8859-1"));
            }
            return KSFLUtilities.ecc(type.getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException e) {
            return KSFLUtilities.ecc(type.getBytes());
        }
    }

    public static long ecc(char[] type) {
        return KSFLUtilities.ecc(new String(type));
    }

    public static long eccAdaptMacResType(int type) {
        return 0x4D61632000000000L | (long)type & 0xFFFFFFFFL;
    }

    public static long eccAdaptMacResType(String type) {
        return KSFLUtilities.ecc("Mac " + type);
    }

    public static long eccAdaptPalmResType(int type) {
        return 0x50616C6D00000000L | (long)type & 0xFFFFFFFFL;
    }

    public static long eccAdaptPalmResType(String type) {
        return KSFLUtilities.ecc("Palm" + type);
    }

    public static long eccAdaptProDOSFileType(int ftype, int atype) {
        byte[] a = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        return KSFLUtilities.ecc(new byte[]{80, 68, a[ftype >> 4 & 0xF], a[ftype & 0xF], a[atype >> 12 & 0xF], a[atype >> 8 & 0xF], a[atype >> 4 & 0xF], a[atype & 0xF]});
    }

    public static long eccAdaptFileExtension(String ext) {
        if (ext.contains(".")) {
            String[] ss = ext.split("\\.");
            ext = ss[ss.length - 1];
        }
        switch (ext.length()) {
            case 0: {
                return KSFLUtilities.ecc("Miscella");
            }
            case 1: {
                return KSFLUtilities.ecc("Miscell" + ext.toUpperCase());
            }
            case 2: 
            case 3: {
                return KSFLUtilities.ecc("Misc " + ext.toUpperCase());
            }
            case 4: {
                return KSFLUtilities.ecc("Misc" + ext.toUpperCase());
            }
            case 5: {
                return KSFLUtilities.ecc("Msc" + ext.toUpperCase());
            }
            case 6: {
                return KSFLUtilities.ecc("Ms" + ext.toUpperCase());
            }
        }
        return KSFLUtilities.ecc(ext.toUpperCase());
    }

    public static String eccs(long type) {
        byte[] a = new byte[]{(byte)(type >> 56 & 0xFFL), (byte)(type >> 48 & 0xFFL), (byte)(type >> 40 & 0xFFL), (byte)(type >> 32 & 0xFFL), (byte)(type >> 24 & 0xFFL), (byte)(type >> 16 & 0xFFL), (byte)(type >> 8 & 0xFFL), (byte)(type >> 0 & 0xFFL)};
        boolean utf16 = a[0] >= 0 && a[0] < 32 || a[0] == 127 || a[0] >= -128 && a[0] < -96 || a[1] >= 0 && a[1] < 32 || a[1] == 127 || a[1] >= -128 && a[1] < -96 || a[2] >= 0 && a[2] < 32 || a[2] == 127 || a[2] >= -128 && a[2] < -96 || a[3] >= 0 && a[3] < 32 || a[3] == 127 || a[3] >= -128 && a[3] < -96 || a[4] >= 0 && a[4] < 32 || a[4] == 127 || a[4] >= -128 && a[4] < -96 || a[5] >= 0 && a[5] < 32 || a[5] == 127 || a[5] >= -128 && a[5] < -96 || a[6] >= 0 && a[6] < 32 || a[6] == 127 || a[6] >= -128 && a[6] < -96 || a[7] >= 0 && a[7] < 32 || a[7] == 127 || a[7] >= -128 && a[7] < -96;
        try {
            return new String(a, utf16 ? "UTF-16BE" : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return new String(a);
        }
    }

    public static byte getByte(byte[] data, int i) {
        return data[i + 0];
    }

    public static short getShort(byte[] data, int i) {
        return (short)((data[i + 0] & 0xFF) << 8 | (data[i + 1] & 0xFF) << 0);
    }

    public static int getInt(byte[] data, int i) {
        return (data[i + 0] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | (data[i + 3] & 0xFF) << 0;
    }

    public static long getUInt48(byte[] data, int i) {
        return ((long)data[i + 0] & 0xFFL) << 40 | ((long)data[i + 1] & 0xFFL) << 32 | ((long)data[i + 2] & 0xFFL) << 24 | ((long)data[i + 3] & 0xFFL) << 16 | ((long)data[i + 4] & 0xFFL) << 8 | ((long)data[i + 5] & 0xFFL) << 0;
    }

    public static long getLong(byte[] data, int i) {
        return ((long)data[i + 0] & 0xFFL) << 56 | ((long)data[i + 1] & 0xFFL) << 48 | ((long)data[i + 2] & 0xFFL) << 40 | ((long)data[i + 3] & 0xFFL) << 32 | ((long)data[i + 4] & 0xFFL) << 24 | ((long)data[i + 5] & 0xFFL) << 16 | ((long)data[i + 6] & 0xFFL) << 8 | ((long)data[i + 7] & 0xFFL) << 0;
    }

    public static double getFixed(byte[] data, int i) {
        return (double)KSFLUtilities.getInt(data, i) / 65536.0;
    }

    public static float getFloat(byte[] data, int i) {
        return Float.intBitsToFloat(KSFLUtilities.getInt(data, i));
    }

    public static double getDouble(byte[] data, int i) {
        return Double.longBitsToDouble(KSFLUtilities.getLong(data, i));
    }

    public static Point getPoint(byte[] data, int i) {
        return new Point(KSFLUtilities.getShort(data, i + 2), KSFLUtilities.getShort(data, i + 0));
    }

    public static Rectangle getRect(byte[] data, int i) {
        return new Rectangle(KSFLUtilities.getShort(data, i + 2), KSFLUtilities.getShort(data, i + 0), KSFLUtilities.getShort(data, i + 6) - KSFLUtilities.getShort(data, i + 2), KSFLUtilities.getShort(data, i + 4) - KSFLUtilities.getShort(data, i + 0));
    }

    public static Color getColor24(byte[] data, int i) {
        return new Color(KSFLUtilities.getByte(data, i + 0) & 0xFF, KSFLUtilities.getByte(data, i + 1) & 0xFF, KSFLUtilities.getByte(data, i + 2) & 0xFF);
    }

    public static Color getColor32(byte[] data, int i) {
        return new Color(KSFLUtilities.getByte(data, i + 1) & 0xFF, KSFLUtilities.getByte(data, i + 2) & 0xFF, KSFLUtilities.getByte(data, i + 3) & 0xFF, KSFLUtilities.getByte(data, i + 0) & 0xFF);
    }

    public static Color getColor48(byte[] data, int i) {
        return new Color((float)(KSFLUtilities.getShort(data, i + 0) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(data, i + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(data, i + 4) & 0xFFFF) / 65535.0f);
    }

    public static Color getColor64(byte[] data, int i) {
        return new Color((float)(KSFLUtilities.getShort(data, i + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(data, i + 4) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(data, i + 6) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShort(data, i + 0) & 0xFFFF) / 65535.0f);
    }

    public static byte getByteLE(byte[] data, int i) {
        return data[i + 0];
    }

    public static short getShortLE(byte[] data, int i) {
        return (short)((data[i + 0] & 0xFF) << 0 | (data[i + 1] & 0xFF) << 8);
    }

    public static int getIntLE(byte[] data, int i) {
        return (data[i + 0] & 0xFF) << 0 | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | (data[i + 3] & 0xFF) << 24;
    }

    public static long getUInt48LE(byte[] data, int i) {
        return ((long)data[i + 0] & 0xFFL) << 0 | ((long)data[i + 1] & 0xFFL) << 8 | ((long)data[i + 2] & 0xFFL) << 16 | ((long)data[i + 3] & 0xFFL) << 24 | ((long)data[i + 4] & 0xFFL) << 32 | ((long)data[i + 5] & 0xFFL) << 40;
    }

    public static long getLongLE(byte[] data, int i) {
        return ((long)data[i + 0] & 0xFFL) << 0 | ((long)data[i + 1] & 0xFFL) << 8 | ((long)data[i + 2] & 0xFFL) << 16 | ((long)data[i + 3] & 0xFFL) << 24 | ((long)data[i + 4] & 0xFFL) << 32 | ((long)data[i + 5] & 0xFFL) << 40 | ((long)data[i + 6] & 0xFFL) << 48 | ((long)data[i + 7] & 0xFFL) << 56;
    }

    public static double getFixedLE(byte[] data, int i) {
        return (double)KSFLUtilities.getIntLE(data, i) / 65536.0;
    }

    public static float getFloatLE(byte[] data, int i) {
        return Float.intBitsToFloat(KSFLUtilities.getIntLE(data, i));
    }

    public static double getDoubleLE(byte[] data, int i) {
        return Double.longBitsToDouble(KSFLUtilities.getLongLE(data, i));
    }

    public static Point getPointLE(byte[] data, int i) {
        return new Point(KSFLUtilities.getShortLE(data, i + 2), KSFLUtilities.getShortLE(data, i + 0));
    }

    public static Rectangle getRectLE(byte[] data, int i) {
        return new Rectangle(KSFLUtilities.getShortLE(data, i + 2), KSFLUtilities.getShortLE(data, i + 0), KSFLUtilities.getShortLE(data, i + 6) - KSFLUtilities.getShortLE(data, i + 2), KSFLUtilities.getShortLE(data, i + 4) - KSFLUtilities.getShortLE(data, i + 0));
    }

    public static Color getColor24LE(byte[] data, int i) {
        return new Color(KSFLUtilities.getByteLE(data, i + 0) & 0xFF, KSFLUtilities.getByteLE(data, i + 1) & 0xFF, KSFLUtilities.getByteLE(data, i + 2) & 0xFF);
    }

    public static Color getColor32LE(byte[] data, int i) {
        return new Color(KSFLUtilities.getByteLE(data, i + 1) & 0xFF, KSFLUtilities.getByteLE(data, i + 2) & 0xFF, KSFLUtilities.getByteLE(data, i + 3) & 0xFF, KSFLUtilities.getByteLE(data, i + 0) & 0xFF);
    }

    public static Color getColor48LE(byte[] data, int i) {
        return new Color((float)(KSFLUtilities.getShortLE(data, i + 0) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShortLE(data, i + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShortLE(data, i + 4) & 0xFFFF) / 65535.0f);
    }

    public static Color getColor64LE(byte[] data, int i) {
        return new Color((float)(KSFLUtilities.getShortLE(data, i + 2) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShortLE(data, i + 4) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShortLE(data, i + 6) & 0xFFFF) / 65535.0f, (float)(KSFLUtilities.getShortLE(data, i + 0) & 0xFFFF) / 65535.0f);
    }

    public static byte getByte(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getByteLE(data, i) : KSFLUtilities.getByte(data, i);
    }

    public static short getShort(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getShortLE(data, i) : KSFLUtilities.getShort(data, i);
    }

    public static int getInt(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getIntLE(data, i) : KSFLUtilities.getInt(data, i);
    }

    public static long getUInt48(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getUInt48LE(data, i) : KSFLUtilities.getUInt48(data, i);
    }

    public static long getLong(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getLongLE(data, i) : KSFLUtilities.getLong(data, i);
    }

    public static double getFixed(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getFixedLE(data, i) : KSFLUtilities.getFixed(data, i);
    }

    public static float getFloat(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getFloatLE(data, i) : KSFLUtilities.getFloat(data, i);
    }

    public static double getDouble(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getDoubleLE(data, i) : KSFLUtilities.getDouble(data, i);
    }

    public static Point getPoint(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getPointLE(data, i) : KSFLUtilities.getPoint(data, i);
    }

    public static Rectangle getRect(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getRectLE(data, i) : KSFLUtilities.getRect(data, i);
    }

    public static Color getColor24(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getColor24LE(data, i) : KSFLUtilities.getColor24(data, i);
    }

    public static Color getColor32(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getColor32LE(data, i) : KSFLUtilities.getColor32(data, i);
    }

    public static Color getColor48(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getColor48LE(data, i) : KSFLUtilities.getColor48(data, i);
    }

    public static Color getColor64(byte[] data, int i, boolean le) {
        return le ? KSFLUtilities.getColor64LE(data, i) : KSFLUtilities.getColor64(data, i);
    }

    public static String getPString(byte[] data, int i) {
        return new String(data, i + 1, data[i] & 0xFF);
    }

    public static String getPString(byte[] data, int i, String encoding) throws UnsupportedEncodingException {
        return new String(data, i + 1, data[i] & 0xFF, encoding);
    }

    public static String getCString(byte[] data, int i) {
        int j = i;
        while (j < data.length && data[j] != 0) {
            ++j;
        }
        return new String(data, i, j - i);
    }

    public static String getCString(byte[] data, int i, String encoding) throws UnsupportedEncodingException {
        int j = i;
        while (j < data.length && data[j] != 0) {
            ++j;
        }
        return new String(data, i, j - i, encoding);
    }

    public static void putByte(byte[] data, int i, byte v) {
        data[i + 0] = v;
    }

    public static void putShort(byte[] data, int i, short v) {
        data[i + 0] = (byte)(v >>> 8 & 0xFF);
        data[i + 1] = (byte)(v >>> 0 & 0xFF);
    }

    public static void putInt(byte[] data, int i, int v) {
        data[i + 0] = (byte)(v >>> 24 & 0xFF);
        data[i + 1] = (byte)(v >>> 16 & 0xFF);
        data[i + 2] = (byte)(v >>> 8 & 0xFF);
        data[i + 3] = (byte)(v >>> 0 & 0xFF);
    }

    public static void putUInt48(byte[] data, int i, long v) {
        data[i + 0] = (byte)(v >>> 40 & 0xFFL);
        data[i + 1] = (byte)(v >>> 32 & 0xFFL);
        data[i + 2] = (byte)(v >>> 24 & 0xFFL);
        data[i + 3] = (byte)(v >>> 16 & 0xFFL);
        data[i + 4] = (byte)(v >>> 8 & 0xFFL);
        data[i + 5] = (byte)(v >>> 0 & 0xFFL);
    }

    public static void putLong(byte[] data, int i, long v) {
        data[i + 0] = (byte)(v >>> 56 & 0xFFL);
        data[i + 1] = (byte)(v >>> 48 & 0xFFL);
        data[i + 2] = (byte)(v >>> 40 & 0xFFL);
        data[i + 3] = (byte)(v >>> 32 & 0xFFL);
        data[i + 4] = (byte)(v >>> 24 & 0xFFL);
        data[i + 5] = (byte)(v >>> 16 & 0xFFL);
        data[i + 6] = (byte)(v >>> 8 & 0xFFL);
        data[i + 7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static void putFixed(byte[] data, int i, double v) {
        KSFLUtilities.putInt(data, i, (int)(v * 65536.0));
    }

    public static void putFloat(byte[] data, int i, float v) {
        KSFLUtilities.putInt(data, i, Float.floatToRawIntBits(v));
    }

    public static void putDouble(byte[] data, int i, double v) {
        KSFLUtilities.putLong(data, i, Double.doubleToRawLongBits(v));
    }

    public static void putPoint(byte[] data, int i, Point v) {
        KSFLUtilities.putShort(data, i + 2, (short)v.x);
        KSFLUtilities.putShort(data, i + 0, (short)v.y);
    }

    public static void putRect(byte[] data, int i, Rectangle v) {
        KSFLUtilities.putShort(data, i + 2, (short)v.x);
        KSFLUtilities.putShort(data, i + 0, (short)v.y);
        KSFLUtilities.putShort(data, i + 6, (short)(v.x + v.width));
        KSFLUtilities.putShort(data, i + 4, (short)(v.y + v.height));
    }

    public static void putColor24(byte[] data, int i, Color v) {
        KSFLUtilities.putByte(data, i + 0, (byte)v.getRed());
        KSFLUtilities.putByte(data, i + 1, (byte)v.getGreen());
        KSFLUtilities.putByte(data, i + 2, (byte)v.getBlue());
    }

    public static void putColor32(byte[] data, int i, Color v) {
        KSFLUtilities.putByte(data, i + 1, (byte)v.getRed());
        KSFLUtilities.putByte(data, i + 2, (byte)v.getGreen());
        KSFLUtilities.putByte(data, i + 3, (byte)v.getBlue());
        KSFLUtilities.putByte(data, i + 0, (byte)v.getAlpha());
    }

    public static void putColor48(byte[] data, int i, Color v) {
        float[] rgb = v.getRGBComponents(null);
        KSFLUtilities.putShort(data, i + 0, (short)Math.round(rgb[0] * 65535.0f));
        KSFLUtilities.putShort(data, i + 2, (short)Math.round(rgb[1] * 65535.0f));
        KSFLUtilities.putShort(data, i + 4, (short)Math.round(rgb[2] * 65535.0f));
    }

    public static void putColor64(byte[] data, int i, Color v) {
        float[] rgb = v.getRGBComponents(null);
        KSFLUtilities.putShort(data, i + 2, (short)Math.round(rgb[0] * 65535.0f));
        KSFLUtilities.putShort(data, i + 4, (short)Math.round(rgb[1] * 65535.0f));
        KSFLUtilities.putShort(data, i + 6, (short)Math.round(rgb[2] * 65535.0f));
        KSFLUtilities.putShort(data, i + 0, (short)Math.round(rgb[3] * 65535.0f));
    }

    public static void putByteLE(byte[] data, int i, byte v) {
        data[i + 0] = v;
    }

    public static void putShortLE(byte[] data, int i, short v) {
        data[i + 0] = (byte)(v >>> 0 & 0xFF);
        data[i + 1] = (byte)(v >>> 8 & 0xFF);
    }

    public static void putIntLE(byte[] data, int i, int v) {
        data[i + 0] = (byte)(v >>> 0 & 0xFF);
        data[i + 1] = (byte)(v >>> 8 & 0xFF);
        data[i + 2] = (byte)(v >>> 16 & 0xFF);
        data[i + 3] = (byte)(v >>> 24 & 0xFF);
    }

    public static void putUInt48LE(byte[] data, int i, long v) {
        data[i + 0] = (byte)(v >>> 0 & 0xFFL);
        data[i + 1] = (byte)(v >>> 8 & 0xFFL);
        data[i + 2] = (byte)(v >>> 16 & 0xFFL);
        data[i + 3] = (byte)(v >>> 24 & 0xFFL);
        data[i + 4] = (byte)(v >>> 32 & 0xFFL);
        data[i + 5] = (byte)(v >>> 40 & 0xFFL);
    }

    public static void putLongLE(byte[] data, int i, long v) {
        data[i + 0] = (byte)(v >>> 0 & 0xFFL);
        data[i + 1] = (byte)(v >>> 8 & 0xFFL);
        data[i + 2] = (byte)(v >>> 16 & 0xFFL);
        data[i + 3] = (byte)(v >>> 24 & 0xFFL);
        data[i + 4] = (byte)(v >>> 32 & 0xFFL);
        data[i + 5] = (byte)(v >>> 40 & 0xFFL);
        data[i + 6] = (byte)(v >>> 48 & 0xFFL);
        data[i + 7] = (byte)(v >>> 56 & 0xFFL);
    }

    public static void putFixedLE(byte[] data, int i, double v) {
        KSFLUtilities.putIntLE(data, i, (int)(v * 65536.0));
    }

    public static void putFloatLE(byte[] data, int i, float v) {
        KSFLUtilities.putIntLE(data, i, Float.floatToRawIntBits(v));
    }

    public static void putDoubleLE(byte[] data, int i, double v) {
        KSFLUtilities.putLongLE(data, i, Double.doubleToRawLongBits(v));
    }

    public static void putPointLE(byte[] data, int i, Point v) {
        KSFLUtilities.putShortLE(data, i + 2, (short)v.x);
        KSFLUtilities.putShortLE(data, i + 0, (short)v.y);
    }

    public static void putRectLE(byte[] data, int i, Rectangle v) {
        KSFLUtilities.putShortLE(data, i + 2, (short)v.x);
        KSFLUtilities.putShortLE(data, i + 0, (short)v.y);
        KSFLUtilities.putShortLE(data, i + 6, (short)(v.x + v.width));
        KSFLUtilities.putShortLE(data, i + 4, (short)(v.y + v.height));
    }

    public static void putColor24LE(byte[] data, int i, Color v) {
        KSFLUtilities.putByteLE(data, i + 0, (byte)v.getRed());
        KSFLUtilities.putByteLE(data, i + 1, (byte)v.getGreen());
        KSFLUtilities.putByteLE(data, i + 2, (byte)v.getBlue());
    }

    public static void putColor32LE(byte[] data, int i, Color v) {
        KSFLUtilities.putByteLE(data, i + 1, (byte)v.getRed());
        KSFLUtilities.putByteLE(data, i + 2, (byte)v.getGreen());
        KSFLUtilities.putByteLE(data, i + 3, (byte)v.getBlue());
        KSFLUtilities.putByteLE(data, i + 0, (byte)v.getAlpha());
    }

    public static void putColor48LE(byte[] data, int i, Color v) {
        float[] rgb = v.getRGBComponents(null);
        KSFLUtilities.putShortLE(data, i + 0, (short)Math.round(rgb[0] * 65535.0f));
        KSFLUtilities.putShortLE(data, i + 2, (short)Math.round(rgb[1] * 65535.0f));
        KSFLUtilities.putShortLE(data, i + 4, (short)Math.round(rgb[2] * 65535.0f));
    }

    public static void putColor64LE(byte[] data, int i, Color v) {
        float[] rgb = v.getRGBComponents(null);
        KSFLUtilities.putShortLE(data, i + 2, (short)Math.round(rgb[0] * 65535.0f));
        KSFLUtilities.putShortLE(data, i + 4, (short)Math.round(rgb[1] * 65535.0f));
        KSFLUtilities.putShortLE(data, i + 6, (short)Math.round(rgb[2] * 65535.0f));
        KSFLUtilities.putShortLE(data, i + 0, (short)Math.round(rgb[3] * 65535.0f));
    }

    public static void putByte(byte[] data, int i, boolean le, byte v) {
        if (le) {
            KSFLUtilities.putByteLE(data, i, v);
        } else {
            KSFLUtilities.putByte(data, i, v);
        }
    }

    public static void putShort(byte[] data, int i, boolean le, short v) {
        if (le) {
            KSFLUtilities.putShortLE(data, i, v);
        } else {
            KSFLUtilities.putShort(data, i, v);
        }
    }

    public static void putInt(byte[] data, int i, boolean le, int v) {
        if (le) {
            KSFLUtilities.putIntLE(data, i, v);
        } else {
            KSFLUtilities.putInt(data, i, v);
        }
    }

    public static void putUInt48(byte[] data, int i, boolean le, long v) {
        if (le) {
            KSFLUtilities.putUInt48LE(data, i, v);
        } else {
            KSFLUtilities.putUInt48(data, i, v);
        }
    }

    public static void putLong(byte[] data, int i, boolean le, long v) {
        if (le) {
            KSFLUtilities.putLongLE(data, i, v);
        } else {
            KSFLUtilities.putLong(data, i, v);
        }
    }

    public static void putFixed(byte[] data, int i, boolean le, double v) {
        if (le) {
            KSFLUtilities.putFixedLE(data, i, v);
        } else {
            KSFLUtilities.putFixed(data, i, v);
        }
    }

    public static void putFloat(byte[] data, int i, boolean le, float v) {
        if (le) {
            KSFLUtilities.putFloatLE(data, i, v);
        } else {
            KSFLUtilities.putFloat(data, i, v);
        }
    }

    public static void putDouble(byte[] data, int i, boolean le, double v) {
        if (le) {
            KSFLUtilities.putDoubleLE(data, i, v);
        } else {
            KSFLUtilities.putDouble(data, i, v);
        }
    }

    public static void putPoint(byte[] data, int i, boolean le, Point v) {
        if (le) {
            KSFLUtilities.putPointLE(data, i, v);
        } else {
            KSFLUtilities.putPoint(data, i, v);
        }
    }

    public static void putRect(byte[] data, int i, boolean le, Rectangle v) {
        if (le) {
            KSFLUtilities.putRectLE(data, i, v);
        } else {
            KSFLUtilities.putRect(data, i, v);
        }
    }

    public static void putColor24(byte[] data, int i, boolean le, Color v) {
        if (le) {
            KSFLUtilities.putColor24LE(data, i, v);
        } else {
            KSFLUtilities.putColor24(data, i, v);
        }
    }

    public static void putColor32(byte[] data, int i, boolean le, Color v) {
        if (le) {
            KSFLUtilities.putColor32LE(data, i, v);
        } else {
            KSFLUtilities.putColor32(data, i, v);
        }
    }

    public static void putColor48(byte[] data, int i, boolean le, Color v) {
        if (le) {
            KSFLUtilities.putColor48LE(data, i, v);
        } else {
            KSFLUtilities.putColor48(data, i, v);
        }
    }

    public static void putColor64(byte[] data, int i, boolean le, Color v) {
        if (le) {
            KSFLUtilities.putColor64LE(data, i, v);
        } else {
            KSFLUtilities.putColor64(data, i, v);
        }
    }

    public static byte[] copy(byte[] data) {
        if (data == null) {
            return new byte[0];
        }
        byte[] dd = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            dd[i] = data[i];
            ++i;
        }
        return dd;
    }

    public static byte[] copy(byte[] data, int off, int len) {
        byte[] dd = new byte[len];
        int si = off;
        int di = 0;
        while (si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        return dd;
    }

    public static byte[] cut(byte[] data, int off, int len) {
        byte[] dd = new byte[data.length - len];
        int si = 0;
        int di = 0;
        while (si < off && di < off && si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        si = off + len;
        di = off;
        while (si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        return dd;
    }

    public static byte[] paste(byte[] data, int off, byte[] pasted) {
        byte[] dd = new byte[data.length + pasted.length];
        int si = 0;
        int di = 0;
        while (si < off && di < off && si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        si = 0;
        di = off;
        while (si < pasted.length && di < dd.length) {
            dd[di] = pasted[si];
            ++si;
            ++di;
        }
        si = off;
        di = off + pasted.length;
        while (si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        return dd;
    }

    public static byte[] paste(byte[] data, int off, int pasted) {
        byte[] dd = new byte[data.length + pasted];
        int si = 0;
        int di = 0;
        while (si < off && di < off && si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        si = off;
        di = off + pasted;
        while (si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        return dd;
    }

    public static byte[] resize(byte[] data, int len) {
        byte[] dd = new byte[len];
        int si = 0;
        int di = 0;
        while (si < data.length && di < dd.length) {
            dd[di] = data[si];
            ++si;
            ++di;
        }
        return dd;
    }

    public static byte[] cut(RandomAccessFile f, long offset, int bytesToCut) throws IOException {
        if (bytesToCut <= 0) {
            return new byte[0];
        }
        byte[] stuff = new byte[bytesToCut];
        f.seek(offset);
        f.read(stuff);
        long l = f.length();
        byte[] junk = new byte[0x100000];
        long s = offset + (long)bytesToCut;
        long d = offset;
        while (s < l) {
            f.seek(s);
            f.read(junk);
            f.seek(d);
            f.write(junk);
            d += 0x100000L;
            s += 0x100000L;
        }
        f.setLength(Math.max(l - (long)bytesToCut, offset));
        return stuff;
    }

    public static long cut(RandomAccessFile f, long offset, long bytesToCut) throws IOException {
        if (bytesToCut <= 0L) {
            return 0L;
        }
        long l = f.length();
        byte[] junk = new byte[0x100000];
        long s = offset + bytesToCut;
        long d = offset;
        while (s < l) {
            f.seek(s);
            f.read(junk);
            f.seek(d);
            f.write(junk);
            d += 0x100000L;
            s += 0x100000L;
        }
        f.setLength(Math.max(l - bytesToCut, offset));
        return Math.min(l - offset, bytesToCut);
    }

    public static byte[] copy(RandomAccessFile f, long offset, int bytesToCopy) throws IOException {
        if (bytesToCopy <= 0) {
            return new byte[0];
        }
        byte[] stuff = new byte[bytesToCopy];
        f.seek(offset);
        f.read(stuff);
        return stuff;
    }

    public static byte[] paste(RandomAccessFile f, long offset, int bytesToPaste) throws IOException {
        if (bytesToPaste <= 0) {
            return new byte[0];
        }
        byte[] stuff = new byte[bytesToPaste];
        long l = f.length();
        long btm = l - offset - 1L & 0xFFFFFFFFFFF00000L;
        byte[] junk = new byte[0x100000];
        long s = offset + btm;
        long d = offset + btm + (long)bytesToPaste;
        while (s >= offset) {
            f.seek(s);
            f.read(junk);
            f.seek(d);
            f.write(junk);
            d -= 0x100000L;
            s -= 0x100000L;
        }
        f.seek(offset);
        f.write(stuff);
        f.setLength(l + (long)bytesToPaste);
        return stuff;
    }

    public static long paste(RandomAccessFile f, long offset, long bytesToPaste) throws IOException {
        if (bytesToPaste <= 0L) {
            return 0L;
        }
        long l = f.length();
        long btm = l - offset - 1L & 0xFFFFFFFFFFF00000L;
        byte[] junk = new byte[0x100000];
        long s = offset + btm;
        long d = offset + btm + bytesToPaste;
        while (s >= offset) {
            f.seek(s);
            f.read(junk);
            f.seek(d);
            f.write(junk);
            d -= 0x100000L;
            s -= 0x100000L;
        }
        f.seek(offset);
        long w = bytesToPaste;
        byte[] stuff = new byte[0x100000];
        while (w >= 0x100000L) {
            f.write(stuff);
            w -= 0x100000L;
        }
        if (w > 0L) {
            stuff = new byte[(int)w];
            f.write(stuff);
        }
        f.setLength(l + bytesToPaste);
        return bytesToPaste;
    }

    public static byte[] paste(RandomAccessFile f, long offset, byte[] stuff) throws IOException {
        if (stuff.length <= 0) {
            return new byte[0];
        }
        long l = f.length();
        long btm = l - offset - 1L & 0xFFFFFFFFFFF00000L;
        byte[] junk = new byte[0x100000];
        long s = offset + btm;
        long d = offset + btm + (long)stuff.length;
        while (s >= offset) {
            f.seek(s);
            f.read(junk);
            f.seek(d);
            f.write(junk);
            d -= 0x100000L;
            s -= 0x100000L;
        }
        f.seek(offset);
        f.write(stuff);
        f.setLength(l + (long)stuff.length);
        return stuff;
    }

    public static void printHexDump(PrintStream out, byte[] data) {
        int a = 0;
        while (a < data.length) {
            String h = "00000000" + Integer.toHexString(a).toUpperCase();
            out.print(String.valueOf(h.substring(h.length() - 8)) + ": ");
            int b = a;
            int c = 0;
            while (c < 16) {
                out.print(b < data.length ? LOOKUP_HEX[data[b] & 0xFF] : "  ");
                if ((b & 1) == 1) {
                    out.print(" ");
                }
                ++b;
                ++c;
            }
            out.print(" ");
            b = a;
            c = 0;
            while (b < data.length && c < 16) {
                if (data[b] >= 32 && data[b] < 127) {
                    out.print((char)data[b]);
                } else {
                    out.print(".");
                }
                ++b;
                ++c;
            }
            out.println();
            a += 16;
        }
    }
}

