# CHANGELOG


## v3.10.0 (2025-04-01)

### Chores

- Update dependabot.yml to increase GHA update frequency
  ([`53b72a1`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/53b72a18b7f889519eca49a9f5fb43199d56cb9b))

- Update deps ([#152](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/152),
  [`c4b0050`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/c4b0050678e01f2e92a92a419d8fd08f2f972045))

dependabot does not yet support new pyproject.toml format

- **ci**: Bump the github-actions group across 1 directory with 8 updates
  ([#150](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/150),
  [`1f67cb0`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/1f67cb0df49102ddd64c9d19ee44f33d1ecffc5d))

* chore(ci): bump the github-actions group across 1 directory with 8 updates

Bumps the github-actions group with 8 updates in the / directory:

| Package | From | To | | --- | --- | --- | |
  [actions/checkout](https://github.com/actions/checkout) | `3` | `4` | |
  [actions/setup-python](https://github.com/actions/setup-python) | `3` | `5` | |
  [pre-commit/action](https://github.com/pre-commit/action) | `2.0.3` | `3.0.1` | |
  [wagoid/commitlint-github-action](https://github.com/wagoid/commitlint-github-action) | `4.1.11` |
  `6.2.1` | | [codecov/codecov-action](https://github.com/codecov/codecov-action) | `3` | `5` | |
  [python-semantic-release/python-semantic-release](https://github.com/python-semantic-release/python-semantic-release)
  | `7.34.6` | `9.21.0` | |
  [browniebroke/hacktoberfest-labeler-action](https://github.com/browniebroke/hacktoberfest-labeler-action)
  | `2.2.0` | `2.3.0` | | [tiangolo/issue-manager](https://github.com/tiangolo/issue-manager) |
  `0.4.0` | `0.5.1` |

Updates `actions/checkout` from 3 to 4 - [Release
  notes](https://github.com/actions/checkout/releases) -
  [Changelog](https://github.com/actions/checkout/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/actions/checkout/compare/v3...v4)

Updates `actions/setup-python` from 3 to 5 - [Release
  notes](https://github.com/actions/setup-python/releases) -
  [Commits](https://github.com/actions/setup-python/compare/v3...v5)

Updates `pre-commit/action` from 2.0.3 to 3.0.1 - [Release
  notes](https://github.com/pre-commit/action/releases) -
  [Commits](https://github.com/pre-commit/action/compare/v2.0.3...v3.0.1)

Updates `wagoid/commitlint-github-action` from 4.1.11 to 6.2.1 -
  [Changelog](https://github.com/wagoid/commitlint-github-action/blob/master/CHANGELOG.md) -
  [Commits](https://github.com/wagoid/commitlint-github-action/compare/v4.1.11...v6.2.1)

Updates `codecov/codecov-action` from 3 to 5 - [Release
  notes](https://github.com/codecov/codecov-action/releases) -
  [Changelog](https://github.com/codecov/codecov-action/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/codecov/codecov-action/compare/v3...v5)

Updates `python-semantic-release/python-semantic-release` from 7.34.6 to 9.21.0 - [Release
  notes](https://github.com/python-semantic-release/python-semantic-release/releases) -
  [Changelog](https://github.com/python-semantic-release/python-semantic-release/blob/master/CHANGELOG.rst)
  -
  [Commits](https://github.com/python-semantic-release/python-semantic-release/compare/v7.34.6...v9.21.0)

Updates `browniebroke/hacktoberfest-labeler-action` from 2.2.0 to 2.3.0 - [Release
  notes](https://github.com/browniebroke/hacktoberfest-labeler-action/releases) -
  [Changelog](https://github.com/browniebroke/hacktoberfest-labeler-action/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/browniebroke/hacktoberfest-labeler-action/compare/v2.2.0...v2.3.0)

Updates `tiangolo/issue-manager` from 0.4.0 to 0.5.1 - [Release
  notes](https://github.com/tiangolo/issue-manager/releases) -
  [Commits](https://github.com/tiangolo/issue-manager/compare/0.4.0...0.5.1)

--- updated-dependencies: - dependency-name: actions/checkout dependency-type: direct:production

update-type: version-update:semver-major

dependency-group: github-actions

- dependency-name: actions/setup-python dependency-type: direct:production

- dependency-name: pre-commit/action dependency-type: direct:production

- dependency-name: wagoid/commitlint-github-action dependency-type: direct:production

- dependency-name: codecov/codecov-action dependency-type: direct:production

- dependency-name: python-semantic-release/python-semantic-release dependency-type:
  direct:production

- dependency-name: browniebroke/hacktoberfest-labeler-action dependency-type: direct:production

update-type: version-update:semver-minor

- dependency-name: tiangolo/issue-manager dependency-type: direct:production

dependency-group: github-actions ...

Signed-off-by: dependabot[bot] <support@github.com>

* chore: update pyproject

* chore: adjust actions

---------

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: J. Nick Koston <nick@koston.org>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#149](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/149),
  [`b71c2d6`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/b71c2d6f9a2fe8758a77da50a4e061e14106cd83))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#151](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/151),
  [`ace8adf`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ace8adf7c33317406bca6fbe210643beabadfe67))

updates: - [github.com/commitizen-tools/commitizen: v4.2.2 →
  v4.4.1](https://github.com/commitizen-tools/commitizen/compare/v4.2.2...v4.4.1) -
  [github.com/PyCQA/isort: 6.0.0 → 6.0.1](https://github.com/PyCQA/isort/compare/6.0.0...6.0.1) -
  [github.com/PyCQA/flake8: 7.1.2 → 7.2.0](https://github.com/PyCQA/flake8/compare/7.1.2...7.2.0)

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Switch to trusted publishing
  ([#153](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/153),
  [`4b8510c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4b8510c6fac4b0d640afbb8152f72ab383cd1dfd))


## v3.9.0 (2025-02-20)

### Chores

- Update dependabot.yml to include GHA
  ([`3158e20`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/3158e2074c11b99d2a11c21ccc197a1d1e93faf2))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#146](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/146),
  [`c9b4072`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/c9b4072d099ec9ca842a7a406eb47569a5265092))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#147](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/147),
  [`18cd61e`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/18cd61ed26a6de86879d6f34a6603b47d8a16452))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Add internal stop_discovery method for habluetooth
  ([#148](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/148),
  [`ae9feac`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ae9feac7138ace0ba62cb30112f29a3ce6f47b28))


## v3.8.1 (2025-02-04)

### Bug Fixes

- Update poetry to v2 ([#144](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/144),
  [`9b45308`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/9b45308e6055c4a42c50228b2e21b20e2adfd604))

### Chores

- **deps**: Bump bluetooth-adapters from 0.21.0 to 0.21.1
  ([#139](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/139),
  [`d6a5e37`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/d6a5e37f639a644ca6beed7a707e521f30f59757))

Bumps [bluetooth-adapters](https://github.com/bluetooth-devices/bluetooth-adapters) from 0.21.0 to
  0.21.1. - [Release notes](https://github.com/bluetooth-devices/bluetooth-adapters/releases) -
  [Changelog](https://github.com/Bluetooth-Devices/bluetooth-adapters/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/bluetooth-devices/bluetooth-adapters/compare/v0.21.0...v0.21.1)

--- updated-dependencies: - dependency-name: bluetooth-adapters dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump dbus-fast from 2.30.2 to 2.32.0
  ([#141](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/141),
  [`060341f`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/060341f63492556c63dda1a90c39a4bcce5b0268))

- **deps-dev**: Bump pytest-asyncio from 0.25.2 to 0.25.3
  ([#142](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/142),
  [`a29042c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/a29042c36d3ce638990e63b2acd160dd7c4d1823))

- **pre-commit.ci**: Pre-commit autoupdate
  ([#140](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/140),
  [`6a4e839`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/6a4e839c039b9f527612499707030cc03c4399b1))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#143](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/143),
  [`87c49e5`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/87c49e5483a61f8d1a13bffc26c954d4aef7cdb3))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>


## v3.8.0 (2025-01-21)

### Chores

- **deps**: Bump bluetooth-adapters from 0.20.2 to 0.21.0
  ([#137](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/137),
  [`bc3045c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/bc3045c1e44aea3a3075fabbe7172a7ac2a388dc))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump pytest-asyncio from 0.23.8 to 0.25.2
  ([#136](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/136),
  [`d71425a`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/d71425a0298418ec6674772e74dc683f2cfcfbb3))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

### Features

- Add method to fetch current allocations
  ([#138](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/138),
  [`4dc325b`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4dc325b4db5afc613064ba1257987a4a0e00fa7e))


## v3.7.0 (2025-01-18)

### Chores

- Create dependabot.yml
  ([`bece8dd`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/bece8dd77ef736a24a8b4ede66472ded83bc5759))

- Update Python 3.13 in CI
  ([#127](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/127),
  [`200dc40`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/200dc403c398ab3f5b328e9a0cd644bfe6e27ba3))

- **deps**: Bump aiohttp from 3.9.1 to 3.10.11
  ([#135](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/135),
  [`f713f8a`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f713f8a8bd458e7cdea31f9982f20e008cccd073))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump bluetooth-adapters from 0.16.2 to 0.20.2
  ([#128](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/128),
  [`c5f661d`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/c5f661d1d1e976bd66e42edc06b0633e42f1835d))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump dbus-fast from 2.21.0 to 2.30.2
  ([#129](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/129),
  [`717149c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/717149c289394b24b756a5e19cb024130ecee2a5))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump idna from 3.6 to 3.7
  ([#134](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/134),
  [`8afeaca`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/8afeacabe79580958fdbade047bc1b9a00144324))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump pytest from 7.4.4 to 8.3.4
  ([#131](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/131),
  [`9b5b266`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/9b5b266027e5b7eb523d438d72e5e9e7dbe89a3f))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump pytest-asyncio from 0.19.0 to 0.23.8
  ([#130](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/130),
  [`1506d86`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/1506d866c80fe0dd6f246fd4e8599ed79cfb7c0d))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump pytest-cov from 3.0.0 to 6.0.0
  ([#132](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/132),
  [`50a2912`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/50a291211532a186d8a1df8c7406e5185e9b4999))

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#120](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/120),
  [`4732a33`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4732a3346329c0532da07c745cc575cdd796cd52))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

Co-authored-by: J. Nick Koston <nick@koston.org>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#121](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/121),
  [`4eebb4e`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4eebb4e028a7935967ff3f2a2ac4e818a1f497d5))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#123](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/123),
  [`9d7a463`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/9d7a46368accb79622ec30ddee79c2f2beb3454c))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#124](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/124),
  [`7c8bd62`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/7c8bd629cee757661c58d00006b7d197aeb17410))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#125](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/125),
  [`edea1ad`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/edea1adc00ba0ea84e9eed1149057a6f37a30165))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#126](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/126),
  [`f009e05`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f009e0501735d2db725b15404ac67be2e7171b4d))

### Features

- Add support for getting callbacks on slot allocation change
  ([#133](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/133),
  [`ae21ecb`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ae21ecb8524555dceafbbe47fb5d3b62efd51f1a))


## v3.6.0 (2024-10-05)

### Chores

- **pre-commit.ci**: Pre-commit autoupdate
  ([#112](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/112),
  [`87b345f`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/87b345f05c27764232ff2aee0637fe2c9b1adf70))

* chore(pre-commit.ci): pre-commit autoupdate

updates: - [github.com/commitizen-tools/commitizen: v2.42.0 →
  v3.27.0](https://github.com/commitizen-tools/commitizen/compare/v2.42.0...v3.27.0) -
  [github.com/pre-commit/pre-commit-hooks: v4.4.0 →
  v4.6.0](https://github.com/pre-commit/pre-commit-hooks/compare/v4.4.0...v4.6.0) -
  [github.com/pre-commit/mirrors-prettier: v2.7.1 →
  v4.0.0-alpha.8](https://github.com/pre-commit/mirrors-prettier/compare/v2.7.1...v4.0.0-alpha.8) -
  [github.com/asottile/pyupgrade: v3.3.1 →
  v3.16.0](https://github.com/asottile/pyupgrade/compare/v3.3.1...v3.16.0) -
  [github.com/PyCQA/isort: 5.12.0 → 5.13.2](https://github.com/PyCQA/isort/compare/5.12.0...5.13.2)
  - [github.com/psf/black: 23.1.0 → 24.4.2](https://github.com/psf/black/compare/23.1.0...24.4.2) -
  [github.com/codespell-project/codespell: v2.2.2 →
  v2.3.0](https://github.com/codespell-project/codespell/compare/v2.2.2...v2.3.0) -
  [github.com/PyCQA/flake8: 6.0.0 → 7.1.0](https://github.com/PyCQA/flake8/compare/6.0.0...7.1.0) -
  [github.com/pre-commit/mirrors-mypy: v1.0.1 →
  v1.10.1](https://github.com/pre-commit/mirrors-mypy/compare/v1.0.1...v1.10.1) -
  [github.com/PyCQA/bandit: 1.7.4 → 1.7.9](https://github.com/PyCQA/bandit/compare/1.7.4...1.7.9)

* chore(pre-commit.ci): auto fixes

---------

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#113](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/113),
  [`4226fa2`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4226fa2569b02b1629cdc99e1be181dbdd568b37))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#114](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/114),
  [`92c271d`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/92c271dff0008fac509d602e0a7ea3b74c826f83))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#115](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/115),
  [`98c40cb`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/98c40cb482379f90e7861376ac9c391eaf05a08c))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#116](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/116),
  [`230b739`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/230b73900dfacddf5ba48f8ed2a2fc1d4f47edfe))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#117](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/117),
  [`ef36e57`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ef36e57234aca7cd04fd0e7922b809f01b41b777))

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

- **pre-commit.ci**: Pre-commit autoupdate
  ([#118](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/118),
  [`12b4f0b`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/12b4f0b09ef54044e519f52621a2b5b863b0efcc))

updates: - [github.com/commitizen-tools/commitizen: v3.29.0 →
  v3.29.1](https://github.com/commitizen-tools/commitizen/compare/v3.29.0...v3.29.1) -
  [github.com/PyCQA/bandit: 1.7.9 → 1.7.10](https://github.com/PyCQA/bandit/compare/1.7.9...1.7.10)

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>

### Features

- Add support for Python 3.13
  ([#119](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/119),
  [`f2c3fa5`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f2c3fa58217d4133b83aafd5ea885edc9e78ae85))


## v3.5.0 (2024-04-10)

### Features

- Add device path to the disconnect debug logging
  ([#111](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/111),
  [`8e010b3`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/8e010b3f3754b156e68699f5727be77d4f8412a3))


## v3.4.0 (2024-01-01)

### Chores

- Add python 3.12 to the CI
  ([#104](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/104),
  [`c6fac48`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/c6fac48a1dd240f0921d3e98736b8f08fad3428f))

### Features

- Add close_stale_connections_by_address
  ([#110](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/110),
  [`74de12f`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/74de12fb5a9269bce677cb76ae0f05daf1af343a))


## v3.3.0 (2023-10-25)

### Features

- Handle services changed during connecting
  ([#108](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/108),
  [`1c65413`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/1c65413cad1e6c42d6bf2c0a8cdec82d9d9a7484))


## v3.2.1 (2023-09-14)

### Bug Fixes

- Correct fetching the global bluez manager when its not running
  ([#106](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/106),
  [`38c63a9`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/38c63a974dd05f7a1e42d647e3ca13884e9b4e62))


## v3.2.0 (2023-09-14)

### Chores

- Log exception type when device disappears
  ([#105](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/105),
  [`445bd43`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/445bd43c62bb9f4afc60b3d359fa94aeaa3abd98))

### Features

- Remove devices on cache clear to cleanup disk cache
  ([#103](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/103),
  [`349e0de`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/349e0deeb2bee443e82d23b816bbd7036a476718))


## v3.1.3 (2023-09-07)

### Bug Fixes

- Ensure timeouts work with py3.11
  ([#102](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/102),
  [`4951aef`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4951aefd9de0e22235dbbd64a15357e67f496d87))


## v3.1.2 (2023-09-03)

### Bug Fixes

- Increase bleak safety timeout to allow for longer disconnect timeout
  ([#101](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/101),
  [`39380a7`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/39380a744b9aed832b51ad20671af86b99186560))


## v3.1.1 (2023-07-25)

### Bug Fixes

- Check more often for a device to reappear after the adapter runs out of slots
  ([#100](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/100),
  [`4c9c9c0`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4c9c9c0670c79d9425e26b761a20d588dd259a26))


## v3.1.0 (2023-07-19)

### Chores

- Bump python-semantic-release to fix release process
  ([#98](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/98),
  [`ee8ebcb`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ee8ebcbbe3761d32da6e8c542e2cfb10162706f2))

- Downgrade python-semantic-release
  ([#99](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/99),
  [`beee26f`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/beee26f53e5aae2ed78b7c05ea3e8c09b8c7c6a3))

- Fix ci ([#96](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/96),
  [`50da16b`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/50da16be853b075fabb7a6f81f85380a1ac15e86))

### Features

- Decrease backoff times ([#97](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/97),
  [`37b71c8`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/37b71c8bf1bd456de3d44ca4f7845de07c853bbc))

- Update the out of slots message to be more clear
  ([#95](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/95),
  [`9269a82`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/9269a82f5f1c88c382856c88e98102d1b83dc436))


## v3.0.2 (2023-03-25)

### Bug Fixes

- Bluez services cache clear was ineffective
  ([#93](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/93),
  [`ec86cb6`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ec86cb6788ba075920867b5cb06d1f5fa49d18ae))


## v3.0.1 (2023-03-18)

### Bug Fixes

- Update for bleak 0.20.0
  ([#92](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/92),
  [`78f9a1e`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/78f9a1e81768ee9543595a6c8673c8c635f63244))


## v3.0.0 (2023-02-25)

### Bug Fixes

- Bump python-semantic-release
  ([#90](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/90),
  [`c401988`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/c4019883c9bad3f91a20029e8adf35962a59a488))

- Lint ([#89](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/89),
  [`c3b5ff8`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/c3b5ff8870b8a5c6cb7972d9e1a0ca677cc0c78d))

- Typing for generic BleakClient classes and the retry_bluetooth_connection_error decorator
  ([#86](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/86),
  [`8ddf242`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/8ddf2426ff2fc5274dc2e8a905233a2c30f57fbb))

* fix: typing for the generic BleakClient client class

Using a bound TypeVar we can ensure that any client class we are dealing with is either BleakClient
  or a descendant of it and that type then stays consistent throughout the lifecycle.

Signed-off-by: Felix Kaechele <felix@kaechele.ca>

* fix: typing for the retry_bluetooth_connection_error decorator

Use TypeVar together with ParamVar to drop the use of the unsafe cast operation.

---------

Co-authored-by: J. Nick Koston <nick@koston.org>

### Chores

- Drop Python 3.9 support
  ([#88](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/88),
  [`58f9958`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/58f9958785b40d2fbade39ef7f56dab931f888a6))

BREAKING CHANGE: In preparation for the use of Python 3.10 typing features such as ParamSpec, which
  is unavailable on Python 3.9.

Following the schema of supporting the current and one previous Python release this drops support
  for Python 3.9.

Signed-off-by: Felix Kaechele <felix@kaechele.ca>

- Update pre-commit hooks
  ([#87](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/87),
  [`fd08a1c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/fd08a1cf76ce012feadcf4a491b0c31f346b783b))

Co-authored-by: J. Nick Koston <nick@koston.org>

### Breaking Changes

- In preparation for the use of Python 3.10 typing features such as ParamSpec, which is unavailable
  on Python 3.9.


## v2.13.1 (2023-01-12)

### Bug Fixes

- Make bluetooth-adapters install Linux only as well
  ([#85](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/85),
  [`910f0b7`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/910f0b7147c31d1133bc5d308d134a72e47c3ff5))

- Only import from bluetooth_adapters when running on linux
  ([#84](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/84),
  [`51926f7`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/51926f7a679437df875f7cb5b6e53253ae10f0b6))


## v2.13.0 (2022-12-23)

### Features

- Remove freshen fallback logic since Home Assistant always provides us the best path to the device
  now ([#83](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/83),
  [`0954d2d`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/0954d2dfc7ff06f3b7445140c644aeaf7ea36384))


## v2.12.1 (2022-12-22)

### Bug Fixes

- _on_characteristic_value_changed in BleakSlotManager should accept any arguments
  ([#82](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/82),
  [`71cc37e`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/71cc37ef6b0b7492fb58aaeb9115737e95bd9f0e))


## v2.12.0 (2022-12-22)

### Features

- Add utility function to get device_source
  ([#81](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/81),
  [`d72ce15`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/d72ce150edba658b4d4edb43f3bbd158cba9988f))


## v2.11.0 (2022-12-22)

### Features

- Add connection slot manager
  ([#80](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/80),
  [`d8bb8d9`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/d8bb8d96fb019152fb97e4006a8e6a1d11213a7d))


## v2.10.2 (2022-12-12)

### Bug Fixes

- Stop trying to get devices from bluez if dbus setup times out
  ([#78](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/78),
  [`a8da722`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/a8da7222d6d7ab725152141f560dc1bb681bf4cf))


## v2.10.1 (2022-12-05)

### Bug Fixes

- Optimize IS_LINUX check in restore_discoveries
  ([#77](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/77),
  [`f22eb33`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f22eb33e1d29d5a6ca8697061de9fbb1bf583bec))


## v2.10.0 (2022-12-05)

### Features

- Add restore_discoveries to fix missing devices
  ([#76](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/76),
  [`f4432ac`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f4432ac086abc0e847ac12818fa22cfaa04a3521))


## v2.9.0 (2022-12-03)

### Features

- Add function to clear the cache
  ([#75](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/75),
  [`6ca6011`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/6ca601104cd13cefa9c2d6db05cdc019aaf18329))


## v2.8.9 (2022-12-02)

### Bug Fixes

- Always log the connection attempt number
  ([#74](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/74),
  [`3306053`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/3306053a3903efa565355e2331b31db739bac094))


## v2.8.8 (2022-12-02)

### Bug Fixes

- Avoid logging connecting and connected since our BLEDevice may be stale
  ([#72](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/72),
  [`10e040c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/10e040c9eb563d31b3e0caf41ee390234e239c4f))

### Chores

- Add py311 to the CI ([#73](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/73),
  [`8bbe3f2`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/8bbe3f24772efd720f28135f376171a37c2897d9))


## v2.8.7 (2022-12-02)

### Bug Fixes

- Enable service cache by default since esp32s are unreliable without it
  ([#71](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/71),
  [`0e90c1c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/0e90c1c79fac01e5e0a39c51b733616d1d324aeb))


## v2.8.6 (2022-11-30)

### Bug Fixes

- Stop trying to check dbus once the socket is missing
  ([#70](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/70),
  [`74bd63b`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/74bd63b5b5c68eca6e7f0fa4e932a3ebab26a59e))


## v2.8.5 (2022-11-19)

### Bug Fixes

- Teach the connector about more esp32 errors and times
  ([#68](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/68),
  [`09cb73d`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/09cb73df4d6908665220df74f91aee4d200f6bad))


## v2.8.4 (2022-11-11)

### Bug Fixes

- Increase backoff when local ble adapter runs out of connection slots
  ([#67](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/67),
  [`cac7e57`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/cac7e57fbb13ee7beaa1eb18d51def661bc92ee3))


## v2.8.3 (2022-11-06)

### Bug Fixes

- Adjust connect timeout to match macos write timeout
  ([#66](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/66),
  [`1396fdc`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/1396fdc0b3235cf67ae919bf1c2a308d4437d023))


## v2.8.2 (2022-11-01)

### Bug Fixes

- Adjust backoffs for slower esp32 proxies
  ([#64](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/64),
  [`702a829`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/702a82921ad30fb4934b5056271cea842a758c08))


## v2.8.1 (2022-10-31)

### Bug Fixes

- Reduce logging as timeouts are expected
  ([#63](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/63),
  [`8b91838`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/8b918380d4772544e4471456df459f5d6d457a61))


## v2.8.0 (2022-10-31)

### Features

- Mark ESP_GATT_ERROR as a transient error
  ([#62](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/62),
  [`6d76ac4`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/6d76ac433c0d4727c12c4f7b4de0b039e7bbc4c2))


## v2.7.0 (2022-10-30)

### Features

- Log the adapter when connecting
  ([#61](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/61),
  [`ab873c8`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ab873c83da6dd37cd4da3e4e61c3f6fc1ffa0c9f))


## v2.6.0 (2022-10-30)

### Features

- Teach the connector about transient esp32 errors
  ([#60](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/60),
  [`486fbbc`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/486fbbc13b9665fcdacf79f7240240602c8f477a))


## v2.5.0 (2022-10-29)

### Features

- Increase timeouts now that bleak has resolved the timeout with service discovery and bluez
  ([#59](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/59),
  [`2a65e27`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/2a65e276ffe3ab598eb8f6eb3cf3bcf7a5269780))


## v2.4.2 (2022-10-24)

### Bug Fixes

- Missing backoff execution with esp32
  ([#58](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/58),
  [`3229424`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/3229424cae6dc7a9052efe080e110327eaa60f4d))


## v2.4.1 (2022-10-24)

### Bug Fixes

- Ensure we back off for longer when out of slots
  ([#57](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/57),
  [`efeced3`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/efeced3fa36fad7d0659e3ed30a7a150370dc923))


## v2.4.0 (2022-10-24)

### Features

- Improve handling of out of esp32 proxy connection slots
  ([#56](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/56),
  [`982b7ae`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/982b7ae1cc12d50a899329466fd4b760aaaec5ca))


## v2.3.2 (2022-10-22)

### Bug Fixes

- Ensure client is returned when debug is off
  ([#55](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/55),
  [`7ddcac8`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/7ddcac8f14126817cb5df4e7773739c6656dcd24))


## v2.3.1 (2022-10-18)

### Bug Fixes

- Do not attempt to disconnect non-bluez bledevices
  ([#54](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/54),
  [`54b6c84`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/54b6c8446629a216eeaf570f1677b67b38b6f081))


## v2.3.0 (2022-10-15)

### Features

- Add a retry_bluetooth_connection_error decorator
  ([#53](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/53),
  [`8bb706d`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/8bb706d09fa2cdaa3e2a3caf830dc92b26add4cc))


## v2.2.0 (2022-10-15)

### Features

- Update for new bleak 19
  ([#52](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/52),
  [`9baafa5`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/9baafa5cbffa9fcd8ee8bd3040014c0d06a2085c))


## v2.1.3 (2022-09-26)

### Bug Fixes

- Bump dbus-fast ([#51](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/51),
  [`68167a3`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/68167a3eee222c3b0c241616c302aacacb8a3cdd))


## v2.1.2 (2022-09-26)

### Bug Fixes

- Adjust stale comment in freshen_ble_device
  ([#50](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/50),
  [`6cabc1f`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/6cabc1f557629c7591cb1cef482ae5d9791349b5))


## v2.1.1 (2022-09-26)

### Bug Fixes

- Set disconnected_callback in the constructor for newer bleak compat
  ([#49](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/49),
  [`e2e25b3`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/e2e25b3d6077aac7c766ecb844b0b492e66efff1))


## v2.1.0 (2022-09-26)

### Features

- Add get_device_by_adapter api
  ([#48](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/48),
  [`238b1f0`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/238b1f09b07e4e65dbf79472adbe9f7932f553fc))


## v2.0.2 (2022-09-25)

### Bug Fixes

- Republish to fix python-semantic-release detecting the wrong version
  ([#47](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/47),
  [`65f3cf2`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/65f3cf23dc2eab0f666dd45bd7b82058d32e2ba2))

- Republish to fix semantic-release detecting the wrong version
  ([#46](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/46),
  [`0338653`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/03386533e1d7fcb0c6d7ec0c34c085a356f6ecd0))

### Features

- Updates for bleak 0.18.0
  ([#45](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/45),
  [`37b8729`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/37b872972f47216aa73a6e5b52ea7f9d5c116910))

BREAKING CHANGE: remove support for bleak < 0.18.0

### Breaking Changes

- Remove support for bleak < 0.18.0


## v1.17.3 (2022-09-24)

### Bug Fixes

- Log message when freshen fails
  ([#44](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/44),
  [`8365937`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/83659374d661c67b81ba204bda9d0f8bf886adf1))


## v1.17.2 (2022-09-23)

### Bug Fixes

- Add a guard to freshen_ble_device so it can be called on non-linux
  ([#43](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/43),
  [`4558a67`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4558a67d4a291f6986dbc7d80fc1cfb2c9f4b4da))


## v1.17.1 (2022-09-15)

### Bug Fixes

- Adjust backoff times to reduce race risk
  ([#40](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/40),
  [`786b442`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/786b442c5e0102b6693cf98f86770a6ad80e4157))


## v1.17.0 (2022-09-15)

### Features

- Provide a BLEAK_RETRY_EXCEPTIONS constant
  ([#39](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/39),
  [`55dc2e1`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/55dc2e141d9059ed544ab4f0d333d09c97f6fab0))


## v1.16.0 (2022-09-14)

### Features

- Do not disconnect unexpectedly connected devices if bleak supports reusing them
  ([#35](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/35),
  [`be603ce`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/be603ce379f6a46ee750e7c3bcbd79d533d2a3ff))

Bleak 0.17 supports connecting to devices that are already connected in BlueZ.

We now detect this and adjust the BLEDevice to point to the already connected device so they do not
  have to wait for a connection.

This also fixes a race where the connection times out but the connection is actually made on the bus
  but we think it failed because we hit the timeout, so the next attempt will instead sail right
  though and be connected.


## v1.15.1 (2022-09-13)

### Bug Fixes

- Revert requirement for newer bleak
  ([#34](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/34),
  [`fe7ec26`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/fe7ec26a7479855e6c37dd4f9b5ac86c93d8d1b8))


## v1.15.0 (2022-09-12)

### Features

- Bleak 0.17 support ([#33](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/33),
  [`ffce2c5`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ffce2c51d3acddfa1efa9e2a396956521a768dd1))


## v1.14.0 (2022-09-11)

### Features

- Implement a smarter backoff
  ([#32](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/32),
  [`8272daa`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/8272daa12d3553001b53f637407a720ab209a57f))


## v1.13.2 (2022-09-11)

### Bug Fixes

- Race during disconnect when unexpectedly connected
  ([#30](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/30),
  [`2ceef9f`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/2ceef9f49cedb3f2721f5d969b4117fe2cb2de7c))


## v1.13.1 (2022-09-11)

### Bug Fixes

- Disconnect unexpectedly connected devices on other adapters
  ([#29](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/29),
  [`85a3efe`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/85a3efe1589dc48eb009da7c3aaa69d7decfe26d))


## v1.13.0 (2022-09-10)

### Features

- Make get_device and close_stale_connections part of __all__
  ([#27](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/27),
  [`4d7edfd`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4d7edfd2f2597e8cba96c925a1e7f4ae55986623))


## v1.12.3 (2022-09-10)

### Bug Fixes

- Disconnect devices that are unexpectedly connected before connecting
  ([#26](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/26),
  [`47b31d3`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/47b31d38b481288472a6923d968a9c4dd6f2b1c6))


## v1.12.2 (2022-09-10)

### Bug Fixes

- Handle already connected devices with no rssi value
  ([#25](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/25),
  [`0dfd3b0`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/0dfd3b07ae6836a61d31c613534e3322dabd3761))


## v1.12.1 (2022-09-10)

### Bug Fixes

- Get_device returning no device when already connected
  ([#24](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/24),
  [`1063b76`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/1063b764959cabfdab572de85d1ad622e6ff7a20))


## v1.12.0 (2022-09-10)

### Features

- Add get_device helper to find already connected devices
  ([#23](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/23),
  [`595e6a0`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/595e6a09c06a29a55000e6b582db12b85884f75a))


## v1.11.1 (2022-09-10)

### Bug Fixes

- Handle Dbus EOFError while connecting
  ([#22](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/22),
  [`b0bc92d`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/b0bc92d00b77f570836fa59f4f88403152f78539))


## v1.11.0 (2022-08-20)

### Features

- Handle stale BLEDevices when an adapter goes offline
  ([#21](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/21),
  [`012c94c`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/012c94c17e81511f84764037a48be1ba686453b3))


## v1.10.1 (2022-08-19)

### Bug Fixes

- Add workaround for when get_services raises
  ([#20](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/20),
  [`1c92f6e`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/1c92f6ed3b643f8f739e7a27b56111cd71e23696))


## v1.10.0 (2022-08-19)

### Features

- Log path to the device ([#19](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/19),
  [`6a9f293`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/6a9f2930e06ee393f0b3885c3d845d485c18babd))


## v1.9.0 (2022-08-19)

### Features

- Add ble_device_callback to get a new BLEDevice between connect attempts
  ([#18](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/18),
  [`450268b`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/450268b8498f730576957f0dbb1cbe0dedbdf14a))


## v1.8.0 (2022-08-15)

### Features

- Add last known rssi to the debug log
  ([#17](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/17),
  [`1032317`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/10323172a1faacca01e6bfb690e92b9e5fb1bd80))


## v1.7.2 (2022-08-12)

### Bug Fixes

- Handle device going in and out of range frequently
  ([#16](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/16),
  [`89b8c1b`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/89b8c1ba63151043d0d6977b0c4a173cb616a9a5))


## v1.7.1 (2022-08-12)

### Bug Fixes

- Race during disconnect error
  ([#14](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/14),
  [`dccbbb1`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/dccbbb1e34028dbd3e3b155502bb70d1ffaa11a8))


## v1.7.0 (2022-08-11)

### Features

- Add ble_device_has_changed helper
  ([#13](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/13),
  [`0a23bb8`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/0a23bb8bbd2c8d0fafc20f3d2da36415ed4759be))


## v1.6.0 (2022-08-11)

### Features

- Cached services ([#11](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/11),
  [`1fe23d6`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/1fe23d6397a7ac2b5994778a9ddc06e687de5ba3))


## v1.5.0 (2022-08-08)

### Features

- Rethrow UnknownObject as BleakNotFoundError
  ([#12](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/12),
  [`a07c50e`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/a07c50e8a910aadc6cec806c0e8888a00def97f6))


## v1.4.0 (2022-08-05)

### Features

- Improve error reporting when there is a poor connection
  ([#10](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/10),
  [`d022777`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/d0227773ff01b4d665fd7bd3e94a330d61214f88))


## v1.3.0 (2022-08-04)

### Features

- Improve chance of connecting with poor signal
  ([#9](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/9),
  [`f0322e7`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f0322e73d450eaf0d088f0dd26a934f3fff40907))


## v1.2.0 (2022-08-03)

### Features

- Handle BrokenPipeError from dbus-next via bleak
  ([#8](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/8),
  [`21da55d`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/21da55dcc37754bcbf904c6ab8162cd4f091e2c4))


## v1.1.1 (2022-08-02)

### Bug Fixes

- Add back the bleak overall safety timeout
  ([#7](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/7),
  [`f3f8ded`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f3f8ded4082bb155d2626a3ec3c693b11bbc355b))


## v1.1.0 (2022-07-24)

### Features

- Pass additional kwargs to the client class
  ([#6](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/6),
  [`808e05b`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/808e05bc2d831307f3e093a9d9d42a2409a0a681))


## v1.0.2 (2022-07-22)

### Bug Fixes

- Push a new release now that pypi is working again
  ([#5](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/5),
  [`3480e22`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/3480e225e8567e6b4a75d166c6a5b3e4661ebb46))


## v1.0.1 (2022-07-22)

### Bug Fixes

- Add comments ([#4](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/4),
  [`4bc5563`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/4bc5563c23bc8cdb9ae44ede0d2ea86693968610))


## v1.0.0 (2022-07-22)


## v0.1.1 (2022-07-22)

### Bug Fixes

- Republish ([#3](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/3),
  [`2b1a504`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/2b1a5042f2250db16d655b1f18a24e74f82f77d2))


## v0.1.0 (2022-07-22)

### Features

- First release ([#2](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/2),
  [`f11f9b5`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/f11f9b5ea1a998bfbd407ffaff299d40243e4e0a))


## v0.0.1 (2022-07-22)

### Chores

- Initial commit
  ([`7128f20`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/7128f2035025491075f84ca9f9b86306291dd1da))

### Features

- Init repo ([#1](https://github.com/Bluetooth-Devices/bleak-retry-connector/pull/1),
  [`ea99576`](https://github.com/Bluetooth-Devices/bleak-retry-connector/commit/ea99576e4ef2ae10ecfbcd067256d8476d1bf8de))
