# Vulnerability Disclosure Policy 

## Introduction

This policy is intended to give security researchers clear guidelines for conducting vulnerability discovery activities and to convey our preferences in how to submit discovered vulnerabilities to us.

This policy describes **what systems and types of research** are covered under this policy, **how to send us** vulnerability reports, and **how long** we ask security researchers to wait before publicly disclosing vulnerabilities.

We encourage you to contact us to report potential vulnerabilities in our systems.

**For vulnerability reports email us at <caldera@mitre.org>**. Reports may be submitted anonymously.  

## Authorization 

If you make a good faith effort to comply with this policy during your security research, we will consider your research to be authorized we will work with you to understand and resolve the issue quickly.  

## Guidelines

Under this policy, "research" means activities in which you:

-   Notify us as soon as possible after you discover a real or potential security issue.

-   Only use exploits to the extent necessary to confirm a vulnerability's presence.

-   Provide us a reasonable amount of time to resolve the issue before you disclose it publicly.

-   Do not submit a high volume of low-quality reports.  

## Reporting a vulnerability

Information submitted under this policy will be used for defensive purposes only, i.e. to mitigate or remediate vulnerabilities. Since Caldera is run by a not-for-profit and is open source by nature, by
submitting a vulnerability, you acknowledge that you have no expectation of payment. However, we will ensure that credit is given to the bug finder.  

## What we would like to see from you

To help us triage and prioritize submissions, please include the following in your report:

- Affected version of Caldera (committed hash or version number), operating system used, and python version.

- Describe the location the vulnerability was discovered and the potential impact of exploitation.

- Offer a detailed description of the steps needed to reproduce the vulnerability (proof of concept scripts or screenshots are helpful).

- Be in English, if possible.  

## What you can expect from us

When you choose to share your contact information with us, we commit to coordinating with you as openly and as quickly as possible.

-   Within ***10 business days***, we will acknowledge that your report has been received.

-   After notifying the Caldera team, we will open reported issues to the public within ***90 days***, or after a fix is released (whichever comes first).

-   To the best of our ability, we will confirm the existence of the vulnerability to you and be as transparent as possible about what steps we are taking during the remediation process, including on issues or challenges that may delay resolution.

-   We will maintain an open dialogue to discuss issues.

-   We will work with you in issuing a CVE and receiving proper credit for helping us secure our platform.  

## Questions

Questions regarding this policy may be sent to [**caldera@mitre.org**](mailto:caldera@mitre.org). We also invite you to contact us with suggestions for improving this policy.  

## Document change history

  -----------------------------------------------------------------------------
  **Version**   **Date**                                **Description**
  ------------- --------------------------------------- -----------------------
  1.0           *Nov 15, 2022*                       First issuance.

  -----------------------------------------------------------------------------

