//go:build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by controller-gen. DO NOT EDIT.

package v1alpha2

import (
	"k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicy) DeepCopyInto(out *ClusterNetworkPolicy) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicy.
func (in *ClusterNetworkPolicy) DeepCopy() *ClusterNetworkPolicy {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterNetworkPolicy) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyEgressPeer) DeepCopyInto(out *ClusterNetworkPolicyEgressPeer) {
	*out = *in
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = new(v1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Pods != nil {
		in, out := &in.Pods, &out.Pods
		*out = new(NamespacedPod)
		(*in).DeepCopyInto(*out)
	}
	if in.Nodes != nil {
		in, out := &in.Nodes, &out.Nodes
		*out = new(v1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Networks != nil {
		in, out := &in.Networks, &out.Networks
		*out = make([]CIDR, len(*in))
		copy(*out, *in)
	}
	if in.DomainNames != nil {
		in, out := &in.DomainNames, &out.DomainNames
		*out = make([]DomainName, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyEgressPeer.
func (in *ClusterNetworkPolicyEgressPeer) DeepCopy() *ClusterNetworkPolicyEgressPeer {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyEgressPeer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyEgressRule) DeepCopyInto(out *ClusterNetworkPolicyEgressRule) {
	*out = *in
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = make([]ClusterNetworkPolicyEgressPeer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Protocols != nil {
		in, out := &in.Protocols, &out.Protocols
		*out = make([]ClusterNetworkPolicyProtocol, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyEgressRule.
func (in *ClusterNetworkPolicyEgressRule) DeepCopy() *ClusterNetworkPolicyEgressRule {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyEgressRule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyIngressPeer) DeepCopyInto(out *ClusterNetworkPolicyIngressPeer) {
	*out = *in
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = new(v1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Pods != nil {
		in, out := &in.Pods, &out.Pods
		*out = new(NamespacedPod)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyIngressPeer.
func (in *ClusterNetworkPolicyIngressPeer) DeepCopy() *ClusterNetworkPolicyIngressPeer {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyIngressPeer)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyIngressRule) DeepCopyInto(out *ClusterNetworkPolicyIngressRule) {
	*out = *in
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = make([]ClusterNetworkPolicyIngressPeer, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Protocols != nil {
		in, out := &in.Protocols, &out.Protocols
		*out = make([]ClusterNetworkPolicyProtocol, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyIngressRule.
func (in *ClusterNetworkPolicyIngressRule) DeepCopy() *ClusterNetworkPolicyIngressRule {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyIngressRule)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyList) DeepCopyInto(out *ClusterNetworkPolicyList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterNetworkPolicy, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyList.
func (in *ClusterNetworkPolicyList) DeepCopy() *ClusterNetworkPolicyList {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterNetworkPolicyList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyProtocol) DeepCopyInto(out *ClusterNetworkPolicyProtocol) {
	*out = *in
	if in.TCP != nil {
		in, out := &in.TCP, &out.TCP
		*out = new(ClusterNetworkPolicyProtocolTCP)
		(*in).DeepCopyInto(*out)
	}
	if in.UDP != nil {
		in, out := &in.UDP, &out.UDP
		*out = new(ClusterNetworkPolicyProtocolUDP)
		(*in).DeepCopyInto(*out)
	}
	if in.SCTP != nil {
		in, out := &in.SCTP, &out.SCTP
		*out = new(ClusterNetworkPolicyProtocolSCTP)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyProtocol.
func (in *ClusterNetworkPolicyProtocol) DeepCopy() *ClusterNetworkPolicyProtocol {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyProtocol)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyProtocolSCTP) DeepCopyInto(out *ClusterNetworkPolicyProtocolSCTP) {
	*out = *in
	if in.DestinationPort != nil {
		in, out := &in.DestinationPort, &out.DestinationPort
		*out = new(Port)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyProtocolSCTP.
func (in *ClusterNetworkPolicyProtocolSCTP) DeepCopy() *ClusterNetworkPolicyProtocolSCTP {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyProtocolSCTP)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyProtocolTCP) DeepCopyInto(out *ClusterNetworkPolicyProtocolTCP) {
	*out = *in
	if in.DestinationPort != nil {
		in, out := &in.DestinationPort, &out.DestinationPort
		*out = new(Port)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyProtocolTCP.
func (in *ClusterNetworkPolicyProtocolTCP) DeepCopy() *ClusterNetworkPolicyProtocolTCP {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyProtocolTCP)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyProtocolUDP) DeepCopyInto(out *ClusterNetworkPolicyProtocolUDP) {
	*out = *in
	if in.DestinationPort != nil {
		in, out := &in.DestinationPort, &out.DestinationPort
		*out = new(Port)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyProtocolUDP.
func (in *ClusterNetworkPolicyProtocolUDP) DeepCopy() *ClusterNetworkPolicyProtocolUDP {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyProtocolUDP)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicySpec) DeepCopyInto(out *ClusterNetworkPolicySpec) {
	*out = *in
	in.Subject.DeepCopyInto(&out.Subject)
	if in.Ingress != nil {
		in, out := &in.Ingress, &out.Ingress
		*out = make([]ClusterNetworkPolicyIngressRule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Egress != nil {
		in, out := &in.Egress, &out.Egress
		*out = make([]ClusterNetworkPolicyEgressRule, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicySpec.
func (in *ClusterNetworkPolicySpec) DeepCopy() *ClusterNetworkPolicySpec {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicySpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicyStatus) DeepCopyInto(out *ClusterNetworkPolicyStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]v1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicyStatus.
func (in *ClusterNetworkPolicyStatus) DeepCopy() *ClusterNetworkPolicyStatus {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicyStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetworkPolicySubject) DeepCopyInto(out *ClusterNetworkPolicySubject) {
	*out = *in
	if in.Namespaces != nil {
		in, out := &in.Namespaces, &out.Namespaces
		*out = new(v1.LabelSelector)
		(*in).DeepCopyInto(*out)
	}
	if in.Pods != nil {
		in, out := &in.Pods, &out.Pods
		*out = new(NamespacedPod)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetworkPolicySubject.
func (in *ClusterNetworkPolicySubject) DeepCopy() *ClusterNetworkPolicySubject {
	if in == nil {
		return nil
	}
	out := new(ClusterNetworkPolicySubject)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NamespacedPod) DeepCopyInto(out *NamespacedPod) {
	*out = *in
	in.NamespaceSelector.DeepCopyInto(&out.NamespaceSelector)
	in.PodSelector.DeepCopyInto(&out.PodSelector)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NamespacedPod.
func (in *NamespacedPod) DeepCopy() *NamespacedPod {
	if in == nil {
		return nil
	}
	out := new(NamespacedPod)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Port) DeepCopyInto(out *Port) {
	*out = *in
	if in.Range != nil {
		in, out := &in.Range, &out.Range
		*out = new(PortRange)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Port.
func (in *Port) DeepCopy() *Port {
	if in == nil {
		return nil
	}
	out := new(Port)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PortRange) DeepCopyInto(out *PortRange) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PortRange.
func (in *PortRange) DeepCopy() *PortRange {
	if in == nil {
		return nil
	}
	out := new(PortRange)
	in.DeepCopyInto(out)
	return out
}
