/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;

public record Interval(int begin, int length) implements Serializable
{
    public static final Interval INFINITE = new Interval(0, Integer.MAX_VALUE);

    public Interval() {
        this(0, 0);
    }

    public Interval(Interval interval) {
        this(interval.begin, interval.length);
    }

    public int center() {
        return this.begin + this.length / 2;
    }

    public boolean contains(int value) {
        return this.begin <= value && value < this.end();
    }

    public int distance(int point) {
        if (point < this.begin) {
            return this.begin - point;
        }
        if (point > this.end()) {
            return point - this.end();
        }
        return 0;
    }

    public int end() {
        return this.begin + this.length;
    }

    public Interval getCopy() {
        return new Interval(this.begin, this.length);
    }

    public Interval getIntersection(Interval interval) {
        int x1 = Math.max(this.begin, interval.begin);
        int x2 = Math.min(this.end(), interval.end());
        if (x2 - x1 < 0) {
            return new Interval();
        }
        return new Interval(x1, x2 - x1);
    }

    public Interval growLeading(int delta) {
        return new Interval(this.begin + delta, this.length - delta);
    }

    public Interval growTrailing(int delta) {
        return new Interval(this.begin, this.length + delta);
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean intersects(Interval interval) {
        return interval.begin < this.end() && this.begin < interval.end();
    }

    public boolean isLeadingOf(Interval interval) {
        return this.begin < interval.begin;
    }

    public boolean isTrailingOf(Interval interval) {
        return this.end() > interval.end();
    }

    public static int getRightMostIntervalIndex(Interval[] intervals, int value) {
        int index = -1;
        int i = 0;
        while (i < intervals.length) {
            Interval interval = intervals[i];
            if (interval.begin + interval.length / 2 < value) {
                index = i;
            }
            ++i;
        }
        return index;
    }
}

