/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.E4PartWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class CloseEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart(event);
        if (activePart instanceof IEditorPart) {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
            window.getActivePage().closeEditor((IEditorPart)activePart, true);
        } else if (activePart instanceof E4PartWrapper) {
            BundleContext context = FrameworkUtil.getBundle(IWorkbench.class).getBundleContext();
            ServiceReference reference = context.getServiceReference(IWorkbench.class);
            IEclipseContext eclipseContext = ((IWorkbench)context.getService(reference)).getApplication().getContext();
            EPartService partService = (EPartService)eclipseContext.get(EPartService.class);
            MPart wrappedPart = ((E4PartWrapper)activePart).wrappedPart;
            if (wrappedPart != null && partService != null && this.representsEditor(wrappedPart) && partService.savePart(wrappedPart, true)) {
                partService.hidePart(wrappedPart);
            }
        }
        return null;
    }

    private boolean representsEditor(MPart part) {
        List partTags = part.getTags();
        return partTags == null || partTags.isEmpty() ? false : partTags.stream().anyMatch(tag -> "Editor".equals(tag));
    }
}

