/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.LinkedHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.quickaccess.IQuickAccessComputer;
import org.eclipse.ui.quickaccess.IQuickAccessComputerExtension;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class OpenResourceQuickAccessComputer
implements IQuickAccessComputer,
IQuickAccessComputerExtension {
    private static final long TIMEOUT_MS = 200L;

    public QuickAccessElement[] computeElements(String query, IProgressMonitor monitor) {
        SearchPattern searchPattern = new SearchPattern();
        searchPattern.setPattern(query);
        LinkedHashMap res = new LinkedHashMap();
        long startTime = System.currentTimeMillis();
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(resourceProxy -> {
                String name;
                if (resourceProxy.isDerived() || !resourceProxy.isAccessible()) {
                    return false;
                }
                if (resourceProxy.getType() == 1 && searchPattern.matches(name = resourceProxy.getName())) {
                    IFile file = (IFile)resourceProxy.requestResource();
                    if (!res.containsKey(name)) {
                        res.put(name, file);
                    } else {
                        IFile previousFile = (IFile)res.get(name);
                        if (previousFile.getFullPath().segmentCount() > file.getFullPath().segmentCount()) {
                            res.put(file.getName(), file);
                        }
                    }
                }
                return !monitor.isCanceled() && System.currentTimeMillis() - startTime < 200L;
            }, 0);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        QuickAccessElement[] proposals = (QuickAccessElement[])res.values().stream().map(file -> new ResourceElement(labelProvider, (IFile)file)).toArray(QuickAccessElement[]::new);
        labelProvider.dispose();
        return proposals;
    }

    public QuickAccessElement[] computeElements() {
        return new QuickAccessElement[0];
    }

    public void resetState() {
    }

    public boolean needsRefresh() {
        return false;
    }

    static class ResourceElement
    extends QuickAccessElement {
        private final WorkbenchLabelProvider fLabelProvider;
        private final IFile fFile;

        ResourceElement(WorkbenchLabelProvider labelProvider, IFile resource) {
            this.fLabelProvider = labelProvider;
            this.fFile = resource;
        }

        public String getLabel() {
            return this.fLabelProvider.getText((Object)this.fFile);
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromImageDataProvider(arg_0 -> ((Image)this.fLabelProvider.getImage((Object)this.fFile)).getImageData(arg_0));
        }

        public String getId() {
            return this.fFile.getFullPath().toString();
        }

        public void execute() {
            try {
                IDE.openEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), this.fFile);
            }
            catch (PartInitException e) {
                IDEWorkbenchPlugin.log(e.getMessage(), e);
            }
        }
    }
}

