---
title: "Upgrading to DefectDojo Version 2.5.x"
toc_hide: true
weight: -20211208
description: legacy authorization removed
---
Legacy authorization has been completely removed with version 2.5.0. This includes removal of the migration of users
to the new authorization as described in https://documentation.defectdojo.com/getting_started/upgrading/#authorization.
If you are still using the legacy authorization, you should run the migration with ``./manage.py migrate_authorization_v2``
before upgrading to version 2.5.0

This release introduces the "Forgot password" functionality (`DD_FORGOT_PASSWORD`: default `True`). The function
allows sending an e-mail with the reset password link. Missing configuration or misconfiguration of SMTP
(`DD_EMAIL_URL`) could raise an error (HTTP-500). Check and test (for example by resetting your own password) if you
configured SMTP correctly. If you want to avoid HTTP-500 and you don't want to set up SMTP, you can just simply switch
off the "Forgot password" functionality (`DD_FORGOT_PASSWORD=False`).

Release renamed system setting `mail_notifications_from` to `email_from`. This value will not be used only for sending
notifications but also for sending the reset password emails. It is highly recommended to check the content of this
value if you are satisfied. If you installed DefectDojo earlier, you can expect `"from@example.com"` there. A fresh
installation will use `"no-reply@example.com"`

This release [updates](https://github.com/DefectDojo/django-DefectDojo/pull/5450) our helm dependencies. There is a breaking change if you are using the mysql database from the helm chart because we replaced the deprecated chart from the stable repo with a chart from bitnami. If you have persistance enabled, ensure to backup your data before upgrading. All data get lost when replacing the mysql chart during the upgrade. For data migration take a look at the mysql backup and restore process.

Furthermore we updated our kubernetes version. Current tests run on 1.18.16 and 1.22.0.
