# Generated by Django 3.1.13 on 2021-10-09 17:53

from django.conf import settings
import django.contrib.auth.models
import django.core.validators
from django.db import migrations, models
import django.db.migrations.operations.special
import django.db.models.deletion
import django.utils.timezone
import django_extensions.db.fields
import dojo.models
import multiselectfield.db.fields
import tagulous.models.fields
import tagulous.models.models
import logging

logger = logging.getLogger(__name__)


# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the
# RunPython operations to refer to the local versions:
# dojo.db_migrations.0001_initial
# dojo.db_migrations.0018_sonarqube_api_integration
# dojo.db_migrations.0042_risk_acceptance_improvements
# dojo.db_migrations.0047_jira_minimum_severity_default
# dojo.db_migrations.0049_create_endpoint_status
# dojo.db_migrations.0061_jira_webhook_secret
# dojo.db_migrations.0064_jira_refactor_populate
# dojo.db_migrations.0065_delete_empty_jira_project_configs
# dojo.db_migrations.0066_django_tagulous
# dojo.db_migrations.0069_risk_acceptance
# dojo.db_migrations.0082_last_status_update_populate
# dojo.db_migrations.0090_index_duplicate_finding

# VS 2021-10-09: All RunPython statements above removed, as they are not needed for fresh installs!

def log_me_0001(apps, schema_editor):
    logger.debug('0001 started!')


def log_me_0090(apps, schema_editor):
    logger.debug('0090 started!')


def update_collation(apps, schema_editor):
    print('Database vendor: {}'.format(schema_editor.connection.vendor))
    if not schema_editor.connection.vendor.startswith('mysql'):
        return
    schema_editor.execute('ALTER TABLE dojo_sonarqube_issue CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_bin')


def rollback_collation(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    replaces = [('dojo', '0001_initial'), ('dojo', '0002_auto_20190503_1817'), ('dojo', '0003_test_title'), ('dojo', '0004_cve_field'), ('dojo', '0005_repo_field'), ('dojo', '0006_django2_upgrade'), ('dojo', '0007_note_additions'), ('dojo', '0008_finding_mitigation'), ('dojo', '0009_endpoint_remediation'), ('dojo', '0010_jira_conf_configuration_name'), ('dojo', '0011_finding_template_activity'), ('dojo', '0012_jira_finding_age'), ('dojo', '0013_jira_info_level'), ('dojo', '0014_jira_conf_resolution_mappings'), ('dojo', '0015_findingimage_caption'), ('dojo', '0016_increase_filepath_length'), ('dojo', '0017_auto_20190827_1421'), ('dojo', '0018_sonarqube_api_integration'), ('dojo', '0019_notetype_additions'), ('dojo', '0020_system_settings_allow_anonymous_survey_repsonse'), ('dojo', '0021_cve_index'), ('dojo', '0022_google_sheet_sync_additions'), ('dojo', '0023_SAST_track_unique_vulnerabilities'), ('dojo', '0024_cve_fix_1553'), ('dojo', '0025_jira_security_issuetype'), ('dojo', '0026_login_banner'), ('dojo', '0027_jira_issue_type_settings'), ('dojo', '0028_finding_indices'), ('dojo', '0029_cve_regex'), ('dojo', '0030_prod_type_meta'), ('dojo', '0031_finding_component'), ('dojo', '0032_system_settings_enable_auditlog'), ('dojo', '0033_remove_finding_duplicate_list'), ('dojo', '0034_add_github_support'), ('dojo', '0035_push_all_issues_help_text_rename_gh_fields'), ('dojo', '0036_system_settings_email_address'), ('dojo', '0037_email_notification_overhaul'), ('dojo', '0038_timezone_update'), ('dojo', '0039_test_version'), ('dojo', '0040_finding_cwe_index'), ('dojo', '0041_engagement_survey_import'), ('dojo', '0042_risk_acceptance_improvements'), ('dojo', '0043_finding_hash_code_index'), ('dojo', '0044_required_prod_type'), ('dojo', '0045_slack_help_text'), ('dojo', '0046_endpoint_status'), ('dojo', '0047_jira_minimum_severity_default'), ('dojo', '0048_sla_notifications'), ('dojo', '0049_create_endpoint_status'), ('dojo', '0050_deduplication_on_engagement'), ('dojo', '0051_regulation_categories'), ('dojo', '0052_cvssv3_field'), ('dojo', '0053_engagement_notes'), ('dojo', '0054_dojometa_finding'), ('dojo', '0055_notifications_jira_update_verbose_name'), ('dojo', '0056_index_component_name'), ('dojo', '0057_ms_teams'), ('dojo', '0058_document_finding_model'), ('dojo', '0059_product_type_authorized_users'), ('dojo', '0060_false_p_dedupe_indices'), ('dojo', '0061_jira_webhook_secret'), ('dojo', '0062_add_vuln_id_from_tool'), ('dojo', '0063_jira_refactor'), ('dojo', '0064_jira_refactor_populate'), ('dojo', '0065_delete_empty_jira_project_configs'), ('dojo', '0066_django_tagulous'), ('dojo', '0067_max_dupes'), ('dojo', '0068_file_upload'), ('dojo', '0069_risk_acceptance'), ('dojo', '0070_increase_alert_field_size'), ('dojo', '0071_product_type_enhancement'), ('dojo', '0072_composite_index'), ('dojo', '0073_sheets_textfields'), ('dojo', '0074_notifications_close_engagement'), ('dojo', '0075_import_history'), ('dojo', '0076_authorization'), ('dojo', '0077_delete_dupulicates'), ('dojo', '0078_cvssv3_rename_verbose_name'), ('dojo', '0079_system_settings_disclaimer'), ('dojo', '0080_jira_issue_templates'), ('dojo', '0081_last_status_update'), ('dojo', '0082_last_status_update_populate'), ('dojo', '0083_remove_ipscan'), ('dojo', '0084_add_extras_in_tool'), ('dojo', '0085_add_publish_date_cvssv3_score'), ('dojo', '0086_finding_groups'), ('dojo', '0087_protect_jira_issues'), ('dojo', '0088_import_history_cicd'), ('dojo', '0089_unprotect_jira_project'), ('dojo', '0090_index_duplicate_finding')]

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('auth', '0008_alter_user_username_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.RunPython(log_me_0001),
        migrations.CreateModel(
            name='Benchmark_Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('objective', models.TextField()),
                ('references', models.TextField(blank=True, null=True)),
                ('enabled', models.BooleanField(default=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Benchmark_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('version', models.CharField(max_length=15)),
                ('benchmark_source', models.CharField(choices=[('PCI', 'PCI'), ('OWASP ASVS', 'OWASP ASVS'), ('OWASP Mobile ASVS', 'OWASP Mobile ASVS')], default='OWASP ASVS', max_length=20, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('enabled', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254)),
                ('team', models.CharField(max_length=100)),
                ('is_admin', models.BooleanField(default=False)),
                ('is_globally_read_only', models.BooleanField(default=False)),
                ('updated', models.DateTimeField(editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='CWE',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=1000)),
                ('description', models.CharField(max_length=2000)),
                ('number', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Development_Environment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='Endpoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('protocol', models.CharField(blank=True, help_text=b"The communication protocol such as 'http', 'ftp', etc.", max_length=10, null=True)),
                ('host', models.CharField(blank=True, help_text=b"The host name or IP address, you can also include the port number. For example'127.0.0.1', '127.0.0.1:8080', 'localhost', 'yourdomain.com'.", max_length=500, null=True)),
                ('fqdn', models.CharField(blank=True, max_length=500, null=True)),
                ('port', models.IntegerField(blank=True, help_text='The network port associated with the endpoint.', null=True)),
                ('path', models.CharField(blank=True, help_text=b"The location of the resource, it should start with a '/'. For example/endpoint/420/edit", max_length=500, null=True)),
                ('query', models.CharField(blank=True, help_text=b"The query string, the question mark should be omitted.For example 'group=4&team=8'", max_length=1000, null=True)),
                ('fragment', models.CharField(blank=True, help_text=b"The fragment identifier which follows the hash mark. The hash mark should be omitted. For example 'section-13', 'paragraph-2'.", max_length=500, null=True)),
            ],
            options={
                'ordering': ['product', 'protocol', 'host', 'path', 'query', 'fragment'],
            },
        ),
        migrations.CreateModel(
            name='Endpoint_Params',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('param', models.CharField(max_length=150)),
                ('value', models.CharField(max_length=150)),
                ('method', models.CharField(choices=[('GET', 'GET'), ('POST', 'POST')], max_length=20, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Engagement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=300, null=True)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('version', models.CharField(blank=True, help_text='Version of the product the engagement tested.', max_length=100, null=True)),
                ('first_contacted', models.DateField(blank=True, null=True)),
                ('target_start', models.DateField()),
                ('target_end', models.DateField()),
                ('reason', models.CharField(blank=True, max_length=2000, null=True)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('active', models.BooleanField(default=True, editable=False)),
                ('tracker', models.URLField(blank=True, help_text='Link to epic or ticket system with changes to version.', null=True)),
                ('test_strategy', models.URLField(blank=True, null=True)),
                ('threat_model', models.BooleanField(default=True)),
                ('api_test', models.BooleanField(default=True)),
                ('pen_test', models.BooleanField(default=True)),
                ('check_list', models.BooleanField(default=True)),
                ('status', models.CharField(choices=[('Not Started', 'Not Started'), ('Blocked', 'Blocked'), ('Cancelled', 'Cancelled'), ('Completed', 'Completed'), ('In Progress', 'In Progress'), ('On Hold', 'On Hold'), ('Waiting for Resource', 'Waiting for Resource')], default='', max_length=2000, null=True)),
                ('progress', models.CharField(default='threat_model', editable=False, max_length=100)),
                ('tmodel_path', models.CharField(blank=True, default='none', editable=False, max_length=1000, null=True)),
                ('risk_path', models.CharField(blank=True, default='none', editable=False, max_length=1000, null=True)),
                ('done_testing', models.BooleanField(default=False, editable=False)),
                ('engagement_type', models.CharField(choices=[('Interactive', 'Interactive'), ('CI/CD', 'CI/CD')], default='Interactive', max_length=30, null=True)),
                ('build_id', models.CharField(blank=True, help_text='Build ID of the product the engagement tested.', max_length=150, null=True, verbose_name='Build ID')),
                ('commit_hash', models.CharField(blank=True, help_text='Commit hash from repo', max_length=150, null=True, verbose_name='Commit Hash')),
                ('branch_tag', models.CharField(blank=True, help_text='Tag or branch of the product the engagement tested.', max_length=150, null=True, verbose_name='Branch/Tag')),
                ('source_code_management_uri', models.CharField(blank=True, help_text='Resource link to source code', max_length=600, null=True, verbose_name='Repo')),
                ('deduplication_on_engagement', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['-target_start'],
            },
        ),
        migrations.CreateModel(
            name='Engagement_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='FieldRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('field', models.CharField(max_length=200)),
                ('update_type', models.CharField(choices=[('Append', 'Append'), ('Replace', 'Replace')], max_length=30)),
                ('text', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='Finding',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.TextField(max_length=1000)),
                ('date', models.DateField(default=dojo.models.get_current_date)),
                ('cwe', models.IntegerField(blank=True, default=0, null=True)),
                ('url', models.TextField(blank=True, editable=False, null=True)),
                ('severity', models.CharField(help_text='The severity level of this flaw (Critical, High, Medium, Low, Informational)', max_length=200)),
                ('description', models.TextField()),
                ('mitigation', models.TextField()),
                ('impact', models.TextField()),
                ('steps_to_reproduce', models.TextField(blank=True, null=True)),
                ('severity_justification', models.TextField(blank=True, null=True)),
                ('references', models.TextField(blank=True, db_column='refs', null=True)),
                ('is_template', models.BooleanField(default=False)),
                ('active', models.BooleanField(default=True)),
                ('verified', models.BooleanField(default=True)),
                ('false_p', models.BooleanField(default=False, verbose_name='False Positive')),
                ('duplicate', models.BooleanField(default=False)),
                ('out_of_scope', models.BooleanField(default=False)),
                ('under_review', models.BooleanField(default=False)),
                ('under_defect_review', models.BooleanField(default=False)),
                ('thread_id', models.IntegerField(default=0, editable=False)),
                ('mitigated', models.DateTimeField(blank=True, editable=False, null=True)),
                ('numerical_severity', models.CharField(max_length=4)),
                ('last_reviewed', models.DateTimeField(editable=False, null=True)),
                ('line_number', models.CharField(blank=True, editable=False, max_length=200, null=True)),
                ('sourcefilepath', models.TextField(blank=True, editable=False, null=True)),
                ('sourcefile', models.TextField(blank=True, editable=False, null=True)),
                ('param', models.TextField(blank=True, editable=False, null=True)),
                ('payload', models.TextField(blank=True, editable=False, null=True)),
                ('hash_code', models.TextField(blank=True, null=True)),
                ('line', models.IntegerField(blank=True, null=True, verbose_name='Line number')),
                ('file_path', models.CharField(blank=True, max_length=1000, null=True)),
                ('static_finding', models.BooleanField(default=False)),
                ('dynamic_finding', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('scanner_confidence', models.IntegerField(blank=True, default=None, editable=False, help_text='Confidence level of vulnerability which is supplied by the scannner.', null=True)),
            ],
            options={
                'ordering': ('numerical_severity', '-date', 'title'),
            },
        ),
        migrations.CreateModel(
            name='FindingImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to=dojo.models.UniqueUploadNameProvider('finding_images'))),
                ('caption', models.CharField(blank=True, max_length=500)),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_Clone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jira_id', models.CharField(max_length=200)),
                ('jira_clone_id', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_Conf',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(help_text='For more information how to configure Jira, read the DefectDojo documentation.', max_length=2000, verbose_name='JIRA URL')),
                ('username', models.CharField(max_length=2000)),
                ('password', models.CharField(max_length=2000)),
                ('default_issue_type', models.CharField(choices=[('Task', 'Task'), ('Story', 'Story'), ('Epic', 'Epic'), ('Spike', 'Spike'), ('Bug', 'Bug')], default='Bug', max_length=9)),
                ('epic_name_id', models.IntegerField(help_text="To obtain the 'Epic name id' visit https://<YOUR JIRA URL>/rest/api/2/field and search for Epic Name. Copy the number out of cf[number] and paste it here.")),
                ('open_status_key', models.IntegerField(help_text='Transition ID to Re-Open JIRA issues, visit https://<YOUR JIRA URL>/rest/api/latest/issue/<ANY VALID ISSUE KEY>/transitions?expand=transitions.fields to find the ID for your JIRA instance', verbose_name='Reopen Transition ID')),
                ('close_status_key', models.IntegerField(help_text='Transition ID to Close JIRA issues, visit https://<YOUR JIRA URL>/rest/api/latest/issue/<ANY VALID ISSUE KEY>/transitions?expand=transitions.fields to find the ID for your JIRA instance', verbose_name='Close Transition ID')),
                ('low_mapping_severity', models.CharField(help_text="Maps to the 'Priority' field in Jira. For example: Low", max_length=200)),
                ('medium_mapping_severity', models.CharField(help_text="Maps to the 'Priority' field in Jira. For example: Medium", max_length=200)),
                ('high_mapping_severity', models.CharField(help_text="Maps to the 'Priority' field in Jira. For example: High", max_length=200)),
                ('critical_mapping_severity', models.CharField(help_text="Maps to the 'Priority' field in Jira. For example: Critical", max_length=200)),
                ('finding_text', models.TextField(blank=True, help_text='Additional text that will be added to the finding in Jira. For example including how the finding was created or who to contact for more information.', null=True)),
                ('configuration_name', models.CharField(default='', help_text='Enter a name to give to this configuration', max_length=2000)),
                ('info_mapping_severity', models.CharField(help_text="Maps to the 'Priority' field in Jira. For example: Info", max_length=200)),
                ('accepted_mapping_resolution', models.CharField(blank=True, help_text='JIRA resolution names (comma-separated values) that maps to an Accepted Finding', max_length=300, null=True)),
                ('false_positive_mapping_resolution', models.CharField(blank=True, help_text='JIRA resolution names (comma-separated values) that maps to a False Positive Finding', max_length=300, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='JIRA_Details_Cache',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jira_id', models.CharField(max_length=200)),
                ('jira_key', models.CharField(max_length=200)),
                ('jira_status', models.CharField(max_length=200)),
                ('jira_resolution', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='Language_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=100)),
                ('color', models.CharField(max_length=7, null=True, verbose_name='HTML color')),
            ],
        ),
        migrations.CreateModel(
            name='Network_Locations',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('location', models.CharField(help_text='Location of network testing: Examples: VPN, Internet or Internal.', max_length=500)),
            ],
        ),
        migrations.CreateModel(
            name='Notes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('entry', models.TextField()),
                ('date', models.DateTimeField(default=dojo.models.get_current_datetime, editable=False)),
                ('author', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='editor_notes_set', to=settings.AUTH_USER_MODEL)),
                ('edit_time', models.DateTimeField(default=dojo.models.get_current_datetime, editable=False, null=True)),
                ('edited', models.BooleanField(default=False)),
                ('editor', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='author_notes_set', to=settings.AUTH_USER_MODEL)),
                ('private', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['-date'],
            },
        ),
        migrations.CreateModel(
            name='Objects',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=100, null=True)),
                ('path', models.CharField(blank=True, max_length=600, null=True, verbose_name='Full file path')),
                ('folder', models.CharField(blank=True, max_length=400, null=True, verbose_name='Folder')),
                ('artifact', models.CharField(blank=True, max_length=400, null=True, verbose_name='Artifact')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Objects_Engagement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('build_id', models.CharField(max_length=150, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('full_url', models.URLField(blank=True, max_length=400, null=True)),
                ('type', models.CharField(max_length=30, null=True)),
                ('percentUnchanged', models.CharField(max_length=10, null=True)),
                ('engagement', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement')),
                ('object_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.objects')),
            ],
        ),
        migrations.CreateModel(
            name='Objects_Review',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(max_length=4000)),
                ('prod_manager', models.CharField(blank=True, default=0, max_length=200, null=True)),
                ('tech_contact', models.CharField(blank=True, default=0, max_length=200, null=True)),
                ('manager', models.CharField(blank=True, default=0, max_length=200, null=True)),
                ('created', models.DateTimeField(blank=True, editable=False, null=True)),
                ('updated', models.DateTimeField(blank=True, editable=False, null=True)),
                ('tid', models.IntegerField(default=0, editable=False)),
                ('prod_numeric_grade', models.IntegerField(blank=True, null=True)),
                ('business_criticality', models.CharField(blank=True, choices=[('very high', 'Very High'), ('high', 'High'), ('medium', 'Medium'), ('low', 'Low'), ('very low', 'Very Low'), ('none', 'None')], max_length=9, null=True)),
                ('platform', models.CharField(blank=True, choices=[('web service', 'API'), ('desktop', 'Desktop'), ('iot', 'Internet of Things'), ('mobile', 'Mobile'), ('we', 'We')], max_length=11, null=True)),
                ('lifecycle', models.CharField(blank=True, choices=[('construction', 'Construction'), ('production', 'Production'), ('retirement', 'Retirement')], max_length=12, null=True)),
                ('origin', models.CharField(blank=True, choices=[('third party library', 'Third Party Library'), ('purchased', 'Purchased'), ('contractor', 'Contractor Developed'), ('internal', 'Internally Developed'), ('open source', 'Open Source'), ('outsourced', 'Outsourced')], max_length=19, null=True)),
                ('user_records', models.PositiveIntegerField(blank=True, help_text='Estimate the number of user records within the application.', null=True)),
                ('revenue', models.DecimalField(blank=True, decimal_places=2, help_text=b"Estimate the application's revenue.", max_digits=15, null=True)),
                ('external_audience', models.BooleanField(default=False, help_text='Specify if the application is used by people outside the organization.')),
                ('internet_accessible', models.BooleanField(default=False, help_text='Specify if the application is accessible from the public internet.')),
                ('authorized_users', models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Product_Line',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('description', models.CharField(max_length=2000)),
            ],
        ),
        migrations.CreateModel(
            name='Product_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('critical_product', models.BooleanField(default=False)),
                ('key_product', models.BooleanField(default=False)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Regulation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of the legislation.', max_length=128)),
                ('acronym', models.CharField(help_text='A shortened representation of the name.', max_length=20, unique=True)),
                ('category', models.CharField(choices=[('privacy', 'Privacy'), ('finance', 'Finance'), ('education', 'Education'), ('medical', 'Medical'), ('other', 'Other')], help_text='The subject of the regulation.', max_length=9)),
                ('jurisdiction', models.CharField(help_text='The territory over which the regulation applies.', max_length=64)),
                ('description', models.TextField(blank=True, help_text="Information about the regulation's purpose.")),
                ('reference', models.URLField(blank=True, help_text='An external URL for more information.')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Report_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Rule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('enabled', models.BooleanField(default=True)),
                ('text', models.TextField()),
                ('operator', models.CharField(choices=[('Matches', 'Matches'), ('Contains', 'Contains')], max_length=30)),
                ('model_object', models.CharField(choices=[('Finding', 'Finding')], max_length=30)),
                ('match_field', models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue')], max_length=200)),
                ('match_text', models.TextField()),
                ('application', models.CharField(choices=[('Append', 'Append'), ('Replace', 'Replace')], max_length=200)),
                ('applies_to', models.CharField(choices=[('Finding', 'Finding')], max_length=30)),
                ('applied_field', models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue')], max_length=200)),
                ('child_rules', models.ManyToManyField(editable=False, related_name='_rule_child_rules_+', to='dojo.Rule')),
                ('parent_rule', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.rule')),
            ],
        ),
        migrations.CreateModel(
            name='Test',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(blank=True, null=True)),
                ('target_start', models.DateTimeField()),
                ('target_end', models.DateTimeField()),
                ('estimated_time', models.TimeField(blank=True, editable=False, null=True)),
                ('actual_time', models.TimeField(blank=True, editable=False, null=True)),
                ('percent_complete', models.IntegerField(blank=True, null=True)),
                ('updated', models.DateTimeField(auto_now=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('engagement', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement')),
                ('environment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.development_environment')),
                ('lead', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('notes', models.ManyToManyField(blank=True, editable=False, to='dojo.Notes')),
            ],
        ),
        migrations.CreateModel(
            name='Test_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, unique=True)),
                ('static_tool', models.BooleanField(default=False)),
                ('dynamic_tool', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Testing_Guide_Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=300)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Tool_Configuration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('url', models.CharField(max_length=2000, null=True)),
                ('authentication_type', models.CharField(blank=True, choices=[('API', 'API Key'), ('Password', 'Username/Password'), ('SSH', 'SSH')], max_length=15, null=True)),
                ('username', models.CharField(blank=True, max_length=200, null=True)),
                ('password', models.CharField(blank=True, max_length=600, null=True)),
                ('auth_title', models.CharField(blank=True, max_length=200, null=True, verbose_name='Title for SSH/API Key')),
                ('ssh', models.CharField(blank=True, max_length=6000, null=True)),
                ('api_key', models.CharField(blank=True, max_length=600, null=True, verbose_name='API Key')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Tool_Product_Settings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('url', models.CharField(blank=True, max_length=2000, null=True)),
                ('tool_project_id', models.CharField(blank=True, max_length=200, null=True)),
                ('notes', models.ManyToManyField(blank=True, editable=False, to='dojo.Notes')),
                ('product', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
                ('tool_configuration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tool_configuration', to='dojo.tool_configuration')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Tool_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(max_length=2000, null=True)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Dojo_User',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'ordering': ['first_name'],
            },
            bases=('auth.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='VA',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.TextField(default='none', editable=False)),
                ('status', models.BooleanField(default=False, editable=False)),
                ('start', models.CharField(max_length=100)),
                ('result', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.test')),
                ('user', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Tool_Product_History',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_scan', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('succesfull', models.BooleanField(default=True, verbose_name='Succesfully')),
                ('configuration_details', models.CharField(blank=True, max_length=2000, null=True)),
                ('product', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.tool_product_settings')),
            ],
        ),
        migrations.AddField(
            model_name='tool_configuration',
            name='tool_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tool_type', to='dojo.tool_type'),
        ),
        migrations.CreateModel(
            name='Testing_Guide',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(blank=True, help_text='Test Unique Identifier', max_length=20, null=True)),
                ('name', models.CharField(help_text='Name of the test', max_length=400)),
                ('summary', models.CharField(help_text='Summary of the test', max_length=800)),
                ('objective', models.CharField(help_text='Objective of the test', max_length=800)),
                ('how_to_test', models.TextField(default=None, help_text='How to test the objective')),
                ('results_expected', models.CharField(help_text='What the results look like for a test', max_length=800)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('testing_guide_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.testing_guide_category')),
            ],
        ),
        migrations.AddField(
            model_name='test',
            name='test_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.test_type'),
        ),
        migrations.CreateModel(
            name='ScanSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('addresses', models.TextField(default='none')),
                ('date', models.DateTimeField(blank=True, default=dojo.models.get_current_datetime, editable=False)),
                ('frequency', models.CharField(blank=True, max_length=10000, null=True)),
                ('email', models.CharField(max_length=512)),
                ('protocol', models.CharField(default='TCP', max_length=10)),
                ('product', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
                ('user', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Scan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(blank=True, default=dojo.models.get_current_datetime, editable=False)),
                ('protocol', models.CharField(default='TCP', max_length=10)),
                ('status', models.CharField(default='Pending', editable=False, max_length=10)),
                ('baseline', models.BooleanField(default=False, verbose_name='Current Baseline')),
                ('scan_settings', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.scansettings')),
            ],
        ),
        migrations.CreateModel(
            name='Risk_Acceptance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', models.FileField(editable=False, upload_to='risk/%Y/%m/%d', verbose_name='Risk Acceptance File')),
                ('expiration_date', models.DateTimeField(blank=True, default=None, null=True)),
                ('accepted_by', models.CharField(blank=True, default=None, help_text='The entity or person that accepts the risk.', max_length=200, null=True, verbose_name='Accepted By')),
                ('compensating_control', models.TextField(blank=True, default=None, help_text='If a compensating control exists to mitigate the finding or reduce risk, then list the compensating control(s).', null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('accepted_findings', models.ManyToManyField(to='dojo.Finding')),
                ('notes', models.ManyToManyField(editable=False, to='dojo.Notes')),
                ('reporter', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Report',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('type', models.CharField(default='Finding', max_length=100)),
                ('format', models.CharField(default='AsciiDoc', max_length=15)),
                ('task_id', models.CharField(max_length=50)),
                ('file', models.FileField(null=True, upload_to='reports/%Y/%m/%d', verbose_name='Report File')),
                ('status', models.CharField(default='requested', max_length=10)),
                ('options', models.TextField()),
                ('datetime', models.DateTimeField(auto_now_add=True)),
                ('done_datetime', models.DateTimeField(null=True)),
                ('requester', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-datetime'],
            },
        ),
        migrations.AddField(
            model_name='product',
            name='prod_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='prod_type', to='dojo.product_type'),
        ),
        migrations.AddField(
            model_name='product',
            name='product_manager',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='product_manager', to='dojo.dojo_user'),
        ),
        migrations.AddField(
            model_name='product',
            name='regulations',
            field=models.ManyToManyField(blank=True, to='dojo.Regulation'),
        ),
        migrations.AddField(
            model_name='product',
            name='team_manager',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='team_manager', to='dojo.dojo_user'),
        ),
        migrations.AddField(
            model_name='product',
            name='technical_contact',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='technical_contact', to='dojo.dojo_user'),
        ),
        migrations.AddField(
            model_name='objects',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product'),
        ),
        migrations.AddField(
            model_name='objects',
            name='review_status',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.objects_review'),
        ),
        migrations.CreateModel(
            name='Notifications',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('engagement_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('test_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('results_added', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('report_created', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('jira_update', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('upcoming_engagement', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('stale_engagement', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('auto_close_engagement', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('user_mentioned', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('code_review', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('review_requested', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('other', multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24)),
                ('user', models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='IPScan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('address', models.TextField(default='none', editable=False)),
                ('services', models.CharField(max_length=800, null=True)),
                ('scan', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.scan')),
            ],
        ),
        migrations.CreateModel(
            name='FindingImageAccessToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(max_length=255)),
                ('size', models.CharField(choices=[('small', 'Small'), ('medium', 'Medium'), ('large', 'Large'), ('thumbnail', 'Thumbnail'), ('original', 'Original')], default='medium', max_length=9)),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.findingimage')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='finding',
            name='defect_review_requested_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='defect_review_requested_by', to='dojo.dojo_user'),
        ),
        migrations.AddField(
            model_name='finding',
            name='duplicate_finding',
            field=models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='original_finding', to='dojo.finding'),
        ),
        migrations.AddField(
            model_name='finding',
            name='duplicate_list',
            field=models.ManyToManyField(blank=True, editable=False, related_name='_finding_duplicate_list_+', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='finding',
            name='endpoints',
            field=models.ManyToManyField(blank=True, to='dojo.Endpoint'),
        ),
        migrations.AddField(
            model_name='finding',
            name='found_by',
            field=models.ManyToManyField(editable=False, to='dojo.Test_Type'),
        ),
        migrations.AddField(
            model_name='finding',
            name='images',
            field=models.ManyToManyField(blank=True, to='dojo.FindingImage'),
        ),
        migrations.AddField(
            model_name='finding',
            name='last_reviewed_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='last_reviewed_by', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='mitigated_by',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='mitigated_by', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='notes',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Notes'),
        ),
        migrations.AddField(
            model_name='finding',
            name='reporter',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='reporter', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='review_requested_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='review_requested_by', to='dojo.dojo_user'),
        ),
        migrations.AddField(
            model_name='finding',
            name='reviewers',
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='finding',
            name='test',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.test'),
        ),
        migrations.CreateModel(
            name='Engagement_Presets',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default=None, help_text='Brief description of preset.', max_length=500)),
                ('notes', models.CharField(blank=True, help_text='Description of what needs to be tested or setting up environment for testing', max_length=2000, null=True)),
                ('scope', models.CharField(blank=True, default=None, help_text="Scope of Engagement testing, IP's/Resources/URL's)", max_length=800)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('network_locations', models.ManyToManyField(blank=True, default=None, to='dojo.Network_Locations')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
                ('test_type', models.ManyToManyField(blank=True, default=None, to='dojo.Test_Type')),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.AddField(
            model_name='engagement',
            name='build_server',
            field=models.ForeignKey(blank=True, help_text='Build server responsible for CI/CD test', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='build_server', to='dojo.tool_configuration', verbose_name='Build Server'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='eng_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement_type'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='lead',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='engagement',
            name='orchestration_engine',
            field=models.ForeignKey(blank=True, help_text='Orchestration service responsible for CI/CD test', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='orchestration', to='dojo.tool_configuration', verbose_name='Orchestration Engine'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='preset',
            field=models.ForeignKey(blank=True, help_text='Settings and notes for performing this engagement.', null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement_presets'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='report_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.report_type'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='requester',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.contact'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='risk_acceptance',
            field=models.ManyToManyField(blank=True, default=None, editable=False, to='dojo.Risk_Acceptance'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='source_code_management_server',
            field=models.ForeignKey(blank=True, help_text='Source code server for CI/CD test', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='source_code_management_server', to='dojo.tool_configuration', verbose_name='SCM Server'),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='endpoint_params',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Endpoint_Params'),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='product',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.product'),
        ),
        migrations.CreateModel(
            name='Cred_User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('username', models.CharField(max_length=200)),
                ('password', models.CharField(max_length=600)),
                ('role', models.CharField(max_length=200)),
                ('authentication', models.CharField(choices=[('Form', 'Form Authentication'), ('SSO', 'SSO Redirect')], default='Form', max_length=15)),
                ('http_authentication', models.CharField(blank=True, choices=[('Basic', 'Basic'), ('NTLM', 'NTLM')], max_length=15, null=True)),
                ('description', models.CharField(blank=True, max_length=2000, null=True)),
                ('url', models.URLField(max_length=2000)),
                ('login_regex', models.CharField(blank=True, max_length=200, null=True)),
                ('logout_regex', models.CharField(blank=True, max_length=200, null=True)),
                ('is_valid', models.BooleanField(default=True, verbose_name='Login is valid')),
                ('environment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.development_environment')),
                ('notes', models.ManyToManyField(blank=True, editable=False, to='dojo.Notes')),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Cred_Mapping',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_authn_provider', models.BooleanField(default=False, verbose_name='Authentication Provider')),
                ('url', models.URLField(blank=True, max_length=2000, null=True)),
                ('cred_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cred_user', to='dojo.cred_user', verbose_name='Credential')),
                ('engagement', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='engagement', to='dojo.engagement')),
                ('finding', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='finding', to='dojo.finding')),
                ('product', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='product', to='dojo.product')),
                ('test', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='test', to='dojo.test')),
            ],
        ),
        migrations.CreateModel(
            name='Check_List',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_management', models.CharField(default='none', max_length=50)),
                ('encryption_crypto', models.CharField(default='none', max_length=50)),
                ('configuration_management', models.CharField(default='', max_length=50)),
                ('authentication', models.CharField(default='none', max_length=50)),
                ('authorization_and_access_control', models.CharField(default='none', max_length=50)),
                ('data_input_sanitization_validation', models.CharField(default='none', max_length=50)),
                ('sensitive_data', models.CharField(default='none', max_length=50)),
                ('other', models.CharField(default='none', max_length=50)),
                ('auth_issues', models.ManyToManyField(blank=True, related_name='auth_issues', to='dojo.Finding')),
                ('author_issues', models.ManyToManyField(blank=True, related_name='author_issues', to='dojo.Finding')),
                ('config_issues', models.ManyToManyField(blank=True, related_name='config_issues', to='dojo.Finding')),
                ('crypto_issues', models.ManyToManyField(blank=True, related_name='crypto_issues', to='dojo.Finding')),
                ('data_issues', models.ManyToManyField(blank=True, related_name='data_issues', to='dojo.Finding')),
                ('engagement', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, related_name='eng_for_check', to='dojo.engagement')),
                ('other_issues', models.ManyToManyField(blank=True, related_name='other_issues', to='dojo.Finding')),
                ('sensitive_issues', models.ManyToManyField(blank=True, related_name='sensitive_issues', to='dojo.Finding')),
                ('session_issues', models.ManyToManyField(blank=True, related_name='session_issues', to='dojo.Finding')),
            ],
        ),
        migrations.CreateModel(
            name='BurpRawRequestResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('burpRequestBase64', models.BinaryField()),
                ('burpResponseBase64', models.BinaryField()),
                ('finding', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.finding')),
            ],
        ),
        migrations.CreateModel(
            name='Benchmark_Requirement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('objective_number', models.CharField(max_length=15, null=True)),
                ('objective', models.TextField()),
                ('references', models.TextField(blank=True, null=True)),
                ('level_1', models.BooleanField(default=False)),
                ('level_2', models.BooleanField(default=False)),
                ('level_3', models.BooleanField(default=False)),
                ('enabled', models.BooleanField(default=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.benchmark_category')),
                ('cwe_mapping', models.ManyToManyField(blank=True, to='dojo.CWE')),
                ('testing_guide', models.ManyToManyField(blank=True, to='dojo.Testing_Guide')),
            ],
        ),
        migrations.AddField(
            model_name='benchmark_category',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.benchmark_type', verbose_name='Benchmark Type'),
        ),
        migrations.CreateModel(
            name='App_Analysis',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('confidence', models.IntegerField(blank=True, null=True, verbose_name='Confidence level')),
                ('version', models.CharField(blank=True, max_length=200, null=True, verbose_name='Version Number')),
                ('icon', models.CharField(blank=True, max_length=200, null=True)),
                ('website', models.URLField(blank=True, max_length=400, null=True)),
                ('website_found', models.URLField(blank=True, max_length=400, null=True)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Alerts',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=100)),
                ('description', models.CharField(max_length=2000, null=True)),
                ('url', models.URLField(max_length=2000, null=True)),
                ('source', models.CharField(default='Generic', max_length=100)),
                ('icon', models.CharField(default='icon-user-check', max_length=25)),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('user_id', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='Languages',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('files', models.IntegerField(blank=True, null=True, verbose_name='Number of files')),
                ('blank', models.IntegerField(blank=True, null=True, verbose_name='Number of blank lines')),
                ('comment', models.IntegerField(blank=True, null=True, verbose_name='Number of comment lines')),
                ('code', models.IntegerField(blank=True, null=True, verbose_name='Number of code lines')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('language', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.language_type')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('language', 'product')},
            },
        ),
        migrations.CreateModel(
            name='DojoMeta',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=120)),
                ('value', models.CharField(max_length=300)),
                ('endpoint', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='endpoint_meta', to='dojo.endpoint')),
                ('product', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='product_meta', to='dojo.product')),
            ],
            options={
                'unique_together': {('product', 'name'), ('endpoint', 'name')},
            },
        ),
        migrations.CreateModel(
            name='Benchmark_Product_Summary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desired_level', models.CharField(choices=[('Level 1', 'Level 1'), ('Level 2', 'Level 2'), ('Level 3', 'Level 3')], default='Level 1', max_length=15)),
                ('current_level', models.CharField(blank=True, choices=[('Level 1', 'Level 1'), ('Level 2', 'Level 2'), ('Level 3', 'Level 3')], default='None', max_length=15, null=True)),
                ('asvs_level_1_benchmark', models.IntegerField(default=0, help_text='Total number of active benchmarks for this application.')),
                ('asvs_level_1_score', models.IntegerField(default=0, help_text='ASVS Level 1 Score')),
                ('asvs_level_2_benchmark', models.IntegerField(default=0, help_text='Total number of active benchmarks for this application.')),
                ('asvs_level_2_score', models.IntegerField(default=0, help_text='ASVS Level 2 Score')),
                ('asvs_level_3_benchmark', models.IntegerField(default=0, help_text='Total number of active benchmarks for this application.')),
                ('asvs_level_3_score', models.IntegerField(default=0, help_text='ASVS Level 3 Score')),
                ('publish', models.BooleanField(default=False, help_text='Publish score to Product.')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('benchmark_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.benchmark_type')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
            ],
            options={
                'unique_together': {('product', 'benchmark_type')},
            },
        ),
        migrations.CreateModel(
            name='Benchmark_Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pass_fail', models.BooleanField(default=False, help_text='Does the product meet the requirement?', verbose_name='Pass')),
                ('enabled', models.BooleanField(default=True, help_text='Applicable for this specific product.')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('updated', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.benchmark_requirement')),
                ('notes', models.ManyToManyField(blank=True, editable=False, to='dojo.Notes')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
            ],
            options={
                'unique_together': {('product', 'control')},
            },
        ),
        migrations.AlterField(
            model_name='finding',
            name='hash_code',
            field=models.TextField(blank=True, editable=False, null=True),
        ),
        migrations.AddField(
            model_name='test',
            name='title',
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name='engagement',
            name='source_code_management_uri',
            field=models.URLField(blank=True, help_text=b'Resource link to source code', max_length=600, null=True, verbose_name=b'Repo'),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='fragment',
            field=models.CharField(blank=True, help_text="The fragment identifier which follows the hash mark. The hash mark should be omitted. For example 'section-13', 'paragraph-2'.", max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='host',
            field=models.CharField(blank=True, help_text="The host name or IP address, you can also include the port number. For example'127.0.0.1', '127.0.0.1:8080', 'localhost', 'yourdomain.com'.", max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='path',
            field=models.CharField(blank=True, help_text="The location of the resource, it should start with a '/'. For example/endpoint/420/edit", max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='protocol',
            field=models.CharField(blank=True, help_text="The communication protocol such as 'http', 'ftp', etc.", max_length=10, null=True),
        ),
        migrations.AlterField(
            model_name='endpoint',
            name='query',
            field=models.CharField(blank=True, help_text="The query string, the question mark should be omitted.For example 'group=4&team=8'", max_length=1000, null=True),
        ),
        migrations.AlterField(
            model_name='engagement',
            name='source_code_management_uri',
            field=models.URLField(blank=True, help_text='Resource link to source code', max_length=600, null=True, verbose_name='Repo'),
        ),
        migrations.AddField(
            model_name='finding',
            name='cve',
            field=models.TextField(max_length=20, null=True, validators=[django.core.validators.RegexValidator(message="CVE must be entered in the format: 'CVE-9999-9999'. ", regex='^CVE-\\d{4}-\\d{4,7}$')]),
        ),
        migrations.CreateModel(
            name='JIRA_PKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('project_key', models.CharField(blank=True, max_length=200)),
                ('component', models.CharField(blank=True, max_length=200)),
                ('push_all_issues', models.BooleanField(blank=True, default=False)),
                ('enable_engagement_epic_mapping', models.BooleanField(blank=True, default=False)),
                ('push_notes', models.BooleanField(blank=True, default=False)),
                ('conf', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.jira_conf', verbose_name='JIRA Configuration')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
            ],
        ),
        migrations.AlterField(
            model_name='product',
            name='platform',
            field=models.CharField(blank=True, choices=[('web service', 'API'), ('desktop', 'Desktop'), ('iot', 'Internet of Things'), ('mobile', 'Mobile'), ('web', 'Web')], max_length=11, null=True),
        ),
        migrations.AlterField(
            model_name='product',
            name='revenue',
            field=models.DecimalField(blank=True, decimal_places=2, help_text="Estimate the application's revenue.", max_digits=15, null=True),
        ),
        migrations.CreateModel(
            name='Stub_Finding',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.TextField(max_length=1000)),
                ('date', models.DateField(default=dojo.models.get_current_date)),
                ('severity', models.CharField(blank=True, max_length=200, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('reporter', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('test', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.test')),
            ],
            options={
                'ordering': ('-date', 'title'),
            },
        ),
        migrations.CreateModel(
            name='UserContactInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=150, null=True)),
                ('phone_number', models.CharField(blank=True, help_text="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", max_length=15, validators=[django.core.validators.RegexValidator(message="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')])),
                ('cell_number', models.CharField(blank=True, help_text="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", max_length=15, validators=[django.core.validators.RegexValidator(message="Phone number must be entered in the format: '+999999999'. Up to 15 digits allowed.", regex='^\\+?1?\\d{9,15}$')])),
                ('twitter_username', models.CharField(blank=True, max_length=150, null=True)),
                ('github_username', models.CharField(blank=True, max_length=150, null=True)),
                ('slack_username', models.CharField(blank=True, help_text='Email address associated with your slack account', max_length=150, null=True, verbose_name='Slack Email Address')),
                ('slack_user_id', models.CharField(blank=True, max_length=25, null=True)),
                ('hipchat_username', models.CharField(blank=True, max_length=150, null=True)),
                ('block_execution', models.BooleanField(default=False, help_text="Instead of async deduping a finding the findings will be deduped synchronously and will 'block' the user until completion.")),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='NoteHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('data', models.TextField()),
                ('time', models.DateTimeField(default=dojo.models.get_current_datetime, editable=False, null=True)),
                ('current_editor', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='notes',
            name='history',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.NoteHistory'),
        ),
        migrations.AddField(
            model_name='finding',
            name='is_Mitigated',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='remediated',
            field=models.BooleanField(blank=True, default=False),
        ),
        migrations.AlterField(
            model_name='finding',
            name='dynamic_finding',
            field=models.BooleanField(default=True),
        ),
        migrations.CreateModel(
            name='Finding_Template',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.TextField(max_length=1000)),
                ('cwe', models.IntegerField(blank=True, default=None, null=True)),
                ('severity', models.CharField(blank=True, max_length=200, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('mitigation', models.TextField(blank=True, null=True)),
                ('impact', models.TextField(blank=True, null=True)),
                ('references', models.TextField(blank=True, db_column='refs', null=True)),
                ('numerical_severity', models.CharField(blank=True, editable=False, max_length=4, null=True)),
                ('template_match', models.BooleanField(default=False, help_text='Enables this template for matching remediation advice. Match will be applied to all active, verified findings by CWE.', verbose_name='Template Match Enabled')),
                ('template_match_title', models.BooleanField(default=False, help_text='Matches by title text (contains search) and CWE.', verbose_name='Match Template by Title and CWE')),
                ('cve', models.TextField(max_length=20, null=True, validators=[django.core.validators.RegexValidator(message="CVE must be entered in the format: 'CVE-9999-9999'. ", regex='^CVE-\\d{4}-\\d{4,7}$')])),
                ('last_used', models.DateTimeField(editable=False, null=True)),
            ],
            options={
                'ordering': ['-cwe'],
            },
        ),
        migrations.AddField(
            model_name='finding',
            name='jira_change',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='jira_creation',
            field=models.DateTimeField(null=True),
        ),
        migrations.CreateModel(
            name='System_Settings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enable_deduplication', models.BooleanField(default=False, help_text='With this setting turned on, Dojo deduplicates findings by comparing endpoints, cwe fields, and titles. If two findings share a URL and have the same CWE or title, Dojo marks the less recent finding as a duplicate. When deduplication is enabled, a list of deduplicated findings is added to the engagement view.', verbose_name='Deduplicate findings')),
                ('delete_dupulicates', models.BooleanField(default=False)),
                ('max_dupes', models.IntegerField(blank=True, help_text='When enabled, if a single issue reaches the maximum number of duplicates, the oldest will be deleted.', null=True, verbose_name='Max Duplicates')),
                ('enable_jira', models.BooleanField(default=False, verbose_name='Enable JIRA integration')),
                ('enable_jira_web_hook', models.BooleanField(default=False, verbose_name='Enable JIRA web hook. Please note: It is strongly recommended to whitelist the Jira server using a proxy such as Nginx.')),
                ('jira_minimum_severity', models.CharField(blank=True, choices=[('Critical', 'Critical'), ('High', 'High'), ('Medium', 'Medium'), ('Low', 'Low'), ('Info', 'Info')], default='None', max_length=20, null=True)),
                ('jira_labels', models.CharField(blank=True, help_text='JIRA issue labels space seperated', max_length=200, null=True)),
                ('enable_slack_notifications', models.BooleanField(default=False, verbose_name='Enable Slack notifications')),
                ('slack_channel', models.CharField(blank=True, default='', max_length=100)),
                ('slack_token', models.CharField(blank=True, default='', help_text='Token required for interacting with Slack. Get one at https://api.slack.com/tokens', max_length=100)),
                ('slack_username', models.CharField(blank=True, default='', max_length=100)),
                ('enable_hipchat_notifications', models.BooleanField(default=False, verbose_name='Enable HipChat notifications')),
                ('hipchat_site', models.CharField(blank=True, default='', help_text='The full fqdn of your hipchat site, e.g. "yoursite.hipchat.com"', max_length=100)),
                ('hipchat_channel', models.CharField(blank=True, default='', max_length=100)),
                ('hipchat_token', models.CharField(blank=True, default='', help_text='Token required for interacting with HipChat. Get one at https://patriktest.hipchat.com/addons/', max_length=100)),
                ('enable_mail_notifications', models.BooleanField(default=False)),
                ('mail_notifications_from', models.CharField(blank=True, default='from@example.com', max_length=200)),
                ('mail_notifications_to', models.CharField(blank=True, default='', max_length=200)),
                ('s_finding_severity_naming', models.BooleanField(default=False, help_text='With this setting turned on, Dojo will display S0, S1, S2, etc in most places, whereas if turned off Critical, High, Medium, etc will be displayed.')),
                ('false_positive_history', models.BooleanField(default=False, help_text='DefectDojo will automatically mark the finding as a false positive if the finding has been previously marked as a false positive.')),
                ('url_prefix', models.CharField(blank=True, default='', help_text="URL prefix if DefectDojo is installed in it's own virtual subdirectory.", max_length=300)),
                ('team_name', models.CharField(blank=True, default='', max_length=100)),
                ('time_zone', models.CharField(choices=[('Africa/Abidjan', 'Africa/Abidjan'), ('Africa/Accra', 'Africa/Accra'), ('Africa/Addis_Ababa', 'Africa/Addis_Ababa'), ('Africa/Algiers', 'Africa/Algiers'), ('Africa/Asmara', 'Africa/Asmara'), ('Africa/Asmera', 'Africa/Asmera'), ('Africa/Bamako', 'Africa/Bamako'), ('Africa/Bangui', 'Africa/Bangui'), ('Africa/Banjul', 'Africa/Banjul'), ('Africa/Bissau', 'Africa/Bissau'), ('Africa/Blantyre', 'Africa/Blantyre'), ('Africa/Brazzaville', 'Africa/Brazzaville'), ('Africa/Bujumbura', 'Africa/Bujumbura'), ('Africa/Cairo', 'Africa/Cairo'), ('Africa/Casablanca', 'Africa/Casablanca'), ('Africa/Ceuta', 'Africa/Ceuta'), ('Africa/Conakry', 'Africa/Conakry'), ('Africa/Dakar', 'Africa/Dakar'), ('Africa/Dar_es_Salaam', 'Africa/Dar_es_Salaam'), ('Africa/Djibouti', 'Africa/Djibouti'), ('Africa/Douala', 'Africa/Douala'), ('Africa/El_Aaiun', 'Africa/El_Aaiun'), ('Africa/Freetown', 'Africa/Freetown'), ('Africa/Gaborone', 'Africa/Gaborone'), ('Africa/Harare', 'Africa/Harare'), ('Africa/Johannesburg', 'Africa/Johannesburg'), ('Africa/Juba', 'Africa/Juba'), ('Africa/Kampala', 'Africa/Kampala'), ('Africa/Khartoum', 'Africa/Khartoum'), ('Africa/Kigali', 'Africa/Kigali'), ('Africa/Kinshasa', 'Africa/Kinshasa'), ('Africa/Lagos', 'Africa/Lagos'), ('Africa/Libreville', 'Africa/Libreville'), ('Africa/Lome', 'Africa/Lome'), ('Africa/Luanda', 'Africa/Luanda'), ('Africa/Lubumbashi', 'Africa/Lubumbashi'), ('Africa/Lusaka', 'Africa/Lusaka'), ('Africa/Malabo', 'Africa/Malabo'), ('Africa/Maputo', 'Africa/Maputo'), ('Africa/Maseru', 'Africa/Maseru'), ('Africa/Mbabane', 'Africa/Mbabane'), ('Africa/Mogadishu', 'Africa/Mogadishu'), ('Africa/Monrovia', 'Africa/Monrovia'), ('Africa/Nairobi', 'Africa/Nairobi'), ('Africa/Ndjamena', 'Africa/Ndjamena'), ('Africa/Niamey', 'Africa/Niamey'), ('Africa/Nouakchott', 'Africa/Nouakchott'), ('Africa/Ouagadougou', 'Africa/Ouagadougou'), ('Africa/Porto-Novo', 'Africa/Porto-Novo'), ('Africa/Sao_Tome', 'Africa/Sao_Tome'), ('Africa/Timbuktu', 'Africa/Timbuktu'), ('Africa/Tripoli', 'Africa/Tripoli'), ('Africa/Tunis', 'Africa/Tunis'), ('Africa/Windhoek', 'Africa/Windhoek'), ('America/Adak', 'America/Adak'), ('America/Anchorage', 'America/Anchorage'), ('America/Anguilla', 'America/Anguilla'), ('America/Antigua', 'America/Antigua'), ('America/Araguaina', 'America/Araguaina'), ('America/Argentina/Buenos_Aires', 'America/Argentina/Buenos_Aires'), ('America/Argentina/Catamarca', 'America/Argentina/Catamarca'), ('America/Argentina/ComodRivadavia', 'America/Argentina/ComodRivadavia'), ('America/Argentina/Cordoba', 'America/Argentina/Cordoba'), ('America/Argentina/Jujuy', 'America/Argentina/Jujuy'), ('America/Argentina/La_Rioja', 'America/Argentina/La_Rioja'), ('America/Argentina/Mendoza', 'America/Argentina/Mendoza'), ('America/Argentina/Rio_Gallegos', 'America/Argentina/Rio_Gallegos'), ('America/Argentina/Salta', 'America/Argentina/Salta'), ('America/Argentina/San_Juan', 'America/Argentina/San_Juan'), ('America/Argentina/San_Luis', 'America/Argentina/San_Luis'), ('America/Argentina/Tucuman', 'America/Argentina/Tucuman'), ('America/Argentina/Ushuaia', 'America/Argentina/Ushuaia'), ('America/Aruba', 'America/Aruba'), ('America/Asuncion', 'America/Asuncion'), ('America/Atikokan', 'America/Atikokan'), ('America/Atka', 'America/Atka'), ('America/Bahia', 'America/Bahia'), ('America/Bahia_Banderas', 'America/Bahia_Banderas'), ('America/Barbados', 'America/Barbados'), ('America/Belem', 'America/Belem'), ('America/Belize', 'America/Belize'), ('America/Blanc-Sablon', 'America/Blanc-Sablon'), ('America/Boa_Vista', 'America/Boa_Vista'), ('America/Bogota', 'America/Bogota'), ('America/Boise', 'America/Boise'), ('America/Buenos_Aires', 'America/Buenos_Aires'), ('America/Cambridge_Bay', 'America/Cambridge_Bay'), ('America/Campo_Grande', 'America/Campo_Grande'), ('America/Cancun', 'America/Cancun'), ('America/Caracas', 'America/Caracas'), ('America/Catamarca', 'America/Catamarca'), ('America/Cayenne', 'America/Cayenne'), ('America/Cayman', 'America/Cayman'), ('America/Chicago', 'America/Chicago'), ('America/Chihuahua', 'America/Chihuahua'), ('America/Coral_Harbour', 'America/Coral_Harbour'), ('America/Cordoba', 'America/Cordoba'), ('America/Costa_Rica', 'America/Costa_Rica'), ('America/Creston', 'America/Creston'), ('America/Cuiaba', 'America/Cuiaba'), ('America/Curacao', 'America/Curacao'), ('America/Danmarkshavn', 'America/Danmarkshavn'), ('America/Dawson', 'America/Dawson'), ('America/Dawson_Creek', 'America/Dawson_Creek'), ('America/Denver', 'America/Denver'), ('America/Detroit', 'America/Detroit'), ('America/Dominica', 'America/Dominica'), ('America/Edmonton', 'America/Edmonton'), ('America/Eirunepe', 'America/Eirunepe'), ('America/El_Salvador', 'America/El_Salvador'), ('America/Ensenada', 'America/Ensenada'), ('America/Fort_Nelson', 'America/Fort_Nelson'), ('America/Fort_Wayne', 'America/Fort_Wayne'), ('America/Fortaleza', 'America/Fortaleza'), ('America/Glace_Bay', 'America/Glace_Bay'), ('America/Godthab', 'America/Godthab'), ('America/Goose_Bay', 'America/Goose_Bay'), ('America/Grand_Turk', 'America/Grand_Turk'), ('America/Grenada', 'America/Grenada'), ('America/Guadeloupe', 'America/Guadeloupe'), ('America/Guatemala', 'America/Guatemala'), ('America/Guayaquil', 'America/Guayaquil'), ('America/Guyana', 'America/Guyana'), ('America/Halifax', 'America/Halifax'), ('America/Havana', 'America/Havana'), ('America/Hermosillo', 'America/Hermosillo'), ('America/Indiana/Indianapolis', 'America/Indiana/Indianapolis'), ('America/Indiana/Knox', 'America/Indiana/Knox'), ('America/Indiana/Marengo', 'America/Indiana/Marengo'), ('America/Indiana/Petersburg', 'America/Indiana/Petersburg'), ('America/Indiana/Tell_City', 'America/Indiana/Tell_City'), ('America/Indiana/Vevay', 'America/Indiana/Vevay'), ('America/Indiana/Vincennes', 'America/Indiana/Vincennes'), ('America/Indiana/Winamac', 'America/Indiana/Winamac'), ('America/Indianapolis', 'America/Indianapolis'), ('America/Inuvik', 'America/Inuvik'), ('America/Iqaluit', 'America/Iqaluit'), ('America/Jamaica', 'America/Jamaica'), ('America/Jujuy', 'America/Jujuy'), ('America/Juneau', 'America/Juneau'), ('America/Kentucky/Louisville', 'America/Kentucky/Louisville'), ('America/Kentucky/Monticello', 'America/Kentucky/Monticello'), ('America/Knox_IN', 'America/Knox_IN'), ('America/Kralendijk', 'America/Kralendijk'), ('America/La_Paz', 'America/La_Paz'), ('America/Lima', 'America/Lima'), ('America/Los_Angeles', 'America/Los_Angeles'), ('America/Louisville', 'America/Louisville'), ('America/Lower_Princes', 'America/Lower_Princes'), ('America/Maceio', 'America/Maceio'), ('America/Managua', 'America/Managua'), ('America/Manaus', 'America/Manaus'), ('America/Marigot', 'America/Marigot'), ('America/Martinique', 'America/Martinique'), ('America/Matamoros', 'America/Matamoros'), ('America/Mazatlan', 'America/Mazatlan'), ('America/Mendoza', 'America/Mendoza'), ('America/Menominee', 'America/Menominee'), ('America/Merida', 'America/Merida'), ('America/Metlakatla', 'America/Metlakatla'), ('America/Mexico_City', 'America/Mexico_City'), ('America/Miquelon', 'America/Miquelon'), ('America/Moncton', 'America/Moncton'), ('America/Monterrey', 'America/Monterrey'), ('America/Montevideo', 'America/Montevideo'), ('America/Montreal', 'America/Montreal'), ('America/Montserrat', 'America/Montserrat'), ('America/Nassau', 'America/Nassau'), ('America/New_York', 'America/New_York'), ('America/Nipigon', 'America/Nipigon'), ('America/Nome', 'America/Nome'), ('America/Noronha', 'America/Noronha'), ('America/North_Dakota/Beulah', 'America/North_Dakota/Beulah'), ('America/North_Dakota/Center', 'America/North_Dakota/Center'), ('America/North_Dakota/New_Salem', 'America/North_Dakota/New_Salem'), ('America/Ojinaga', 'America/Ojinaga'), ('America/Panama', 'America/Panama'), ('America/Pangnirtung', 'America/Pangnirtung'), ('America/Paramaribo', 'America/Paramaribo'), ('America/Phoenix', 'America/Phoenix'), ('America/Port-au-Prince', 'America/Port-au-Prince'), ('America/Port_of_Spain', 'America/Port_of_Spain'), ('America/Porto_Acre', 'America/Porto_Acre'), ('America/Porto_Velho', 'America/Porto_Velho'), ('America/Puerto_Rico', 'America/Puerto_Rico'), ('America/Punta_Arenas', 'America/Punta_Arenas'), ('America/Rainy_River', 'America/Rainy_River'), ('America/Rankin_Inlet', 'America/Rankin_Inlet'), ('America/Recife', 'America/Recife'), ('America/Regina', 'America/Regina'), ('America/Resolute', 'America/Resolute'), ('America/Rio_Branco', 'America/Rio_Branco'), ('America/Rosario', 'America/Rosario'), ('America/Santa_Isabel', 'America/Santa_Isabel'), ('America/Santarem', 'America/Santarem'), ('America/Santiago', 'America/Santiago'), ('America/Santo_Domingo', 'America/Santo_Domingo'), ('America/Sao_Paulo', 'America/Sao_Paulo'), ('America/Scoresbysund', 'America/Scoresbysund'), ('America/Shiprock', 'America/Shiprock'), ('America/Sitka', 'America/Sitka'), ('America/St_Barthelemy', 'America/St_Barthelemy'), ('America/St_Johns', 'America/St_Johns'), ('America/St_Kitts', 'America/St_Kitts'), ('America/St_Lucia', 'America/St_Lucia'), ('America/St_Thomas', 'America/St_Thomas'), ('America/St_Vincent', 'America/St_Vincent'), ('America/Swift_Current', 'America/Swift_Current'), ('America/Tegucigalpa', 'America/Tegucigalpa'), ('America/Thule', 'America/Thule'), ('America/Thunder_Bay', 'America/Thunder_Bay'), ('America/Tijuana', 'America/Tijuana'), ('America/Toronto', 'America/Toronto'), ('America/Tortola', 'America/Tortola'), ('America/Vancouver', 'America/Vancouver'), ('America/Virgin', 'America/Virgin'), ('America/Whitehorse', 'America/Whitehorse'), ('America/Winnipeg', 'America/Winnipeg'), ('America/Yakutat', 'America/Yakutat'), ('America/Yellowknife', 'America/Yellowknife'), ('Antarctica/Casey', 'Antarctica/Casey'), ('Antarctica/Davis', 'Antarctica/Davis'), ('Antarctica/DumontDUrville', 'Antarctica/DumontDUrville'), ('Antarctica/Macquarie', 'Antarctica/Macquarie'), ('Antarctica/Mawson', 'Antarctica/Mawson'), ('Antarctica/McMurdo', 'Antarctica/McMurdo'), ('Antarctica/Palmer', 'Antarctica/Palmer'), ('Antarctica/Rothera', 'Antarctica/Rothera'), ('Antarctica/South_Pole', 'Antarctica/South_Pole'), ('Antarctica/Syowa', 'Antarctica/Syowa'), ('Antarctica/Troll', 'Antarctica/Troll'), ('Antarctica/Vostok', 'Antarctica/Vostok'), ('Arctic/Longyearbyen', 'Arctic/Longyearbyen'), ('Asia/Aden', 'Asia/Aden'), ('Asia/Almaty', 'Asia/Almaty'), ('Asia/Amman', 'Asia/Amman'), ('Asia/Anadyr', 'Asia/Anadyr'), ('Asia/Aqtau', 'Asia/Aqtau'), ('Asia/Aqtobe', 'Asia/Aqtobe'), ('Asia/Ashgabat', 'Asia/Ashgabat'), ('Asia/Ashkhabad', 'Asia/Ashkhabad'), ('Asia/Atyrau', 'Asia/Atyrau'), ('Asia/Baghdad', 'Asia/Baghdad'), ('Asia/Bahrain', 'Asia/Bahrain'), ('Asia/Baku', 'Asia/Baku'), ('Asia/Bangkok', 'Asia/Bangkok'), ('Asia/Barnaul', 'Asia/Barnaul'), ('Asia/Beirut', 'Asia/Beirut'), ('Asia/Bishkek', 'Asia/Bishkek'), ('Asia/Brunei', 'Asia/Brunei'), ('Asia/Calcutta', 'Asia/Calcutta'), ('Asia/Chita', 'Asia/Chita'), ('Asia/Choibalsan', 'Asia/Choibalsan'), ('Asia/Chongqing', 'Asia/Chongqing'), ('Asia/Chungking', 'Asia/Chungking'), ('Asia/Colombo', 'Asia/Colombo'), ('Asia/Dacca', 'Asia/Dacca'), ('Asia/Damascus', 'Asia/Damascus'), ('Asia/Dhaka', 'Asia/Dhaka'), ('Asia/Dili', 'Asia/Dili'), ('Asia/Dubai', 'Asia/Dubai'), ('Asia/Dushanbe', 'Asia/Dushanbe'), ('Asia/Famagusta', 'Asia/Famagusta'), ('Asia/Gaza', 'Asia/Gaza'), ('Asia/Harbin', 'Asia/Harbin'), ('Asia/Hebron', 'Asia/Hebron'), ('Asia/Ho_Chi_Minh', 'Asia/Ho_Chi_Minh'), ('Asia/Hong_Kong', 'Asia/Hong_Kong'), ('Asia/Hovd', 'Asia/Hovd'), ('Asia/Irkutsk', 'Asia/Irkutsk'), ('Asia/Istanbul', 'Asia/Istanbul'), ('Asia/Jakarta', 'Asia/Jakarta'), ('Asia/Jayapura', 'Asia/Jayapura'), ('Asia/Jerusalem', 'Asia/Jerusalem'), ('Asia/Kabul', 'Asia/Kabul'), ('Asia/Kamchatka', 'Asia/Kamchatka'), ('Asia/Karachi', 'Asia/Karachi'), ('Asia/Kashgar', 'Asia/Kashgar'), ('Asia/Kathmandu', 'Asia/Kathmandu'), ('Asia/Katmandu', 'Asia/Katmandu'), ('Asia/Khandyga', 'Asia/Khandyga'), ('Asia/Kolkata', 'Asia/Kolkata'), ('Asia/Krasnoyarsk', 'Asia/Krasnoyarsk'), ('Asia/Kuala_Lumpur', 'Asia/Kuala_Lumpur'), ('Asia/Kuching', 'Asia/Kuching'), ('Asia/Kuwait', 'Asia/Kuwait'), ('Asia/Macao', 'Asia/Macao'), ('Asia/Macau', 'Asia/Macau'), ('Asia/Magadan', 'Asia/Magadan'), ('Asia/Makassar', 'Asia/Makassar'), ('Asia/Manila', 'Asia/Manila'), ('Asia/Muscat', 'Asia/Muscat'), ('Asia/Nicosia', 'Asia/Nicosia'), ('Asia/Novokuznetsk', 'Asia/Novokuznetsk'), ('Asia/Novosibirsk', 'Asia/Novosibirsk'), ('Asia/Omsk', 'Asia/Omsk'), ('Asia/Oral', 'Asia/Oral'), ('Asia/Phnom_Penh', 'Asia/Phnom_Penh'), ('Asia/Pontianak', 'Asia/Pontianak'), ('Asia/Pyongyang', 'Asia/Pyongyang'), ('Asia/Qatar', 'Asia/Qatar'), ('Asia/Qostanay', 'Asia/Qostanay'), ('Asia/Qyzylorda', 'Asia/Qyzylorda'), ('Asia/Rangoon', 'Asia/Rangoon'), ('Asia/Riyadh', 'Asia/Riyadh'), ('Asia/Saigon', 'Asia/Saigon'), ('Asia/Sakhalin', 'Asia/Sakhalin'), ('Asia/Samarkand', 'Asia/Samarkand'), ('Asia/Seoul', 'Asia/Seoul'), ('Asia/Shanghai', 'Asia/Shanghai'), ('Asia/Singapore', 'Asia/Singapore'), ('Asia/Srednekolymsk', 'Asia/Srednekolymsk'), ('Asia/Taipei', 'Asia/Taipei'), ('Asia/Tashkent', 'Asia/Tashkent'), ('Asia/Tbilisi', 'Asia/Tbilisi'), ('Asia/Tehran', 'Asia/Tehran'), ('Asia/Tel_Aviv', 'Asia/Tel_Aviv'), ('Asia/Thimbu', 'Asia/Thimbu'), ('Asia/Thimphu', 'Asia/Thimphu'), ('Asia/Tokyo', 'Asia/Tokyo'), ('Asia/Tomsk', 'Asia/Tomsk'), ('Asia/Ujung_Pandang', 'Asia/Ujung_Pandang'), ('Asia/Ulaanbaatar', 'Asia/Ulaanbaatar'), ('Asia/Ulan_Bator', 'Asia/Ulan_Bator'), ('Asia/Urumqi', 'Asia/Urumqi'), ('Asia/Ust-Nera', 'Asia/Ust-Nera'), ('Asia/Vientiane', 'Asia/Vientiane'), ('Asia/Vladivostok', 'Asia/Vladivostok'), ('Asia/Yakutsk', 'Asia/Yakutsk'), ('Asia/Yangon', 'Asia/Yangon'), ('Asia/Yekaterinburg', 'Asia/Yekaterinburg'), ('Asia/Yerevan', 'Asia/Yerevan'), ('Atlantic/Azores', 'Atlantic/Azores'), ('Atlantic/Bermuda', 'Atlantic/Bermuda'), ('Atlantic/Canary', 'Atlantic/Canary'), ('Atlantic/Cape_Verde', 'Atlantic/Cape_Verde'), ('Atlantic/Faeroe', 'Atlantic/Faeroe'), ('Atlantic/Faroe', 'Atlantic/Faroe'), ('Atlantic/Jan_Mayen', 'Atlantic/Jan_Mayen'), ('Atlantic/Madeira', 'Atlantic/Madeira'), ('Atlantic/Reykjavik', 'Atlantic/Reykjavik'), ('Atlantic/South_Georgia', 'Atlantic/South_Georgia'), ('Atlantic/St_Helena', 'Atlantic/St_Helena'), ('Atlantic/Stanley', 'Atlantic/Stanley'), ('Australia/ACT', 'Australia/ACT'), ('Australia/Adelaide', 'Australia/Adelaide'), ('Australia/Brisbane', 'Australia/Brisbane'), ('Australia/Broken_Hill', 'Australia/Broken_Hill'), ('Australia/Canberra', 'Australia/Canberra'), ('Australia/Currie', 'Australia/Currie'), ('Australia/Darwin', 'Australia/Darwin'), ('Australia/Eucla', 'Australia/Eucla'), ('Australia/Hobart', 'Australia/Hobart'), ('Australia/LHI', 'Australia/LHI'), ('Australia/Lindeman', 'Australia/Lindeman'), ('Australia/Lord_Howe', 'Australia/Lord_Howe'), ('Australia/Melbourne', 'Australia/Melbourne'), ('Australia/NSW', 'Australia/NSW'), ('Australia/North', 'Australia/North'), ('Australia/Perth', 'Australia/Perth'), ('Australia/Queensland', 'Australia/Queensland'), ('Australia/South', 'Australia/South'), ('Australia/Sydney', 'Australia/Sydney'), ('Australia/Tasmania', 'Australia/Tasmania'), ('Australia/Victoria', 'Australia/Victoria'), ('Australia/West', 'Australia/West'), ('Australia/Yancowinna', 'Australia/Yancowinna'), ('Brazil/Acre', 'Brazil/Acre'), ('Brazil/DeNoronha', 'Brazil/DeNoronha'), ('Brazil/East', 'Brazil/East'), ('Brazil/West', 'Brazil/West'), ('CET', 'CET'), ('CST6CDT', 'CST6CDT'), ('Canada/Atlantic', 'Canada/Atlantic'), ('Canada/Central', 'Canada/Central'), ('Canada/Eastern', 'Canada/Eastern'), ('Canada/Mountain', 'Canada/Mountain'), ('Canada/Newfoundland', 'Canada/Newfoundland'), ('Canada/Pacific', 'Canada/Pacific'), ('Canada/Saskatchewan', 'Canada/Saskatchewan'), ('Canada/Yukon', 'Canada/Yukon'), ('Chile/Continental', 'Chile/Continental'), ('Chile/EasterIsland', 'Chile/EasterIsland'), ('Cuba', 'Cuba'), ('EET', 'EET'), ('EST', 'EST'), ('EST5EDT', 'EST5EDT'), ('Egypt', 'Egypt'), ('Eire', 'Eire'), ('Etc/GMT', 'Etc/GMT'), ('Etc/GMT+0', 'Etc/GMT+0'), ('Etc/GMT+1', 'Etc/GMT+1'), ('Etc/GMT+10', 'Etc/GMT+10'), ('Etc/GMT+11', 'Etc/GMT+11'), ('Etc/GMT+12', 'Etc/GMT+12'), ('Etc/GMT+2', 'Etc/GMT+2'), ('Etc/GMT+3', 'Etc/GMT+3'), ('Etc/GMT+4', 'Etc/GMT+4'), ('Etc/GMT+5', 'Etc/GMT+5'), ('Etc/GMT+6', 'Etc/GMT+6'), ('Etc/GMT+7', 'Etc/GMT+7'), ('Etc/GMT+8', 'Etc/GMT+8'), ('Etc/GMT+9', 'Etc/GMT+9'), ('Etc/GMT-0', 'Etc/GMT-0'), ('Etc/GMT-1', 'Etc/GMT-1'), ('Etc/GMT-10', 'Etc/GMT-10'), ('Etc/GMT-11', 'Etc/GMT-11'), ('Etc/GMT-12', 'Etc/GMT-12'), ('Etc/GMT-13', 'Etc/GMT-13'), ('Etc/GMT-14', 'Etc/GMT-14'), ('Etc/GMT-2', 'Etc/GMT-2'), ('Etc/GMT-3', 'Etc/GMT-3'), ('Etc/GMT-4', 'Etc/GMT-4'), ('Etc/GMT-5', 'Etc/GMT-5'), ('Etc/GMT-6', 'Etc/GMT-6'), ('Etc/GMT-7', 'Etc/GMT-7'), ('Etc/GMT-8', 'Etc/GMT-8'), ('Etc/GMT-9', 'Etc/GMT-9'), ('Etc/GMT0', 'Etc/GMT0'), ('Etc/Greenwich', 'Etc/Greenwich'), ('Etc/UCT', 'Etc/UCT'), ('Etc/UTC', 'Etc/UTC'), ('Etc/Universal', 'Etc/Universal'), ('Etc/Zulu', 'Etc/Zulu'), ('Europe/Amsterdam', 'Europe/Amsterdam'), ('Europe/Andorra', 'Europe/Andorra'), ('Europe/Astrakhan', 'Europe/Astrakhan'), ('Europe/Athens', 'Europe/Athens'), ('Europe/Belfast', 'Europe/Belfast'), ('Europe/Belgrade', 'Europe/Belgrade'), ('Europe/Berlin', 'Europe/Berlin'), ('Europe/Bratislava', 'Europe/Bratislava'), ('Europe/Brussels', 'Europe/Brussels'), ('Europe/Bucharest', 'Europe/Bucharest'), ('Europe/Budapest', 'Europe/Budapest'), ('Europe/Busingen', 'Europe/Busingen'), ('Europe/Chisinau', 'Europe/Chisinau'), ('Europe/Copenhagen', 'Europe/Copenhagen'), ('Europe/Dublin', 'Europe/Dublin'), ('Europe/Gibraltar', 'Europe/Gibraltar'), ('Europe/Guernsey', 'Europe/Guernsey'), ('Europe/Helsinki', 'Europe/Helsinki'), ('Europe/Isle_of_Man', 'Europe/Isle_of_Man'), ('Europe/Istanbul', 'Europe/Istanbul'), ('Europe/Jersey', 'Europe/Jersey'), ('Europe/Kaliningrad', 'Europe/Kaliningrad'), ('Europe/Kiev', 'Europe/Kiev'), ('Europe/Kirov', 'Europe/Kirov'), ('Europe/Lisbon', 'Europe/Lisbon'), ('Europe/Ljubljana', 'Europe/Ljubljana'), ('Europe/London', 'Europe/London'), ('Europe/Luxembourg', 'Europe/Luxembourg'), ('Europe/Madrid', 'Europe/Madrid'), ('Europe/Malta', 'Europe/Malta'), ('Europe/Mariehamn', 'Europe/Mariehamn'), ('Europe/Minsk', 'Europe/Minsk'), ('Europe/Monaco', 'Europe/Monaco'), ('Europe/Moscow', 'Europe/Moscow'), ('Europe/Nicosia', 'Europe/Nicosia'), ('Europe/Oslo', 'Europe/Oslo'), ('Europe/Paris', 'Europe/Paris'), ('Europe/Podgorica', 'Europe/Podgorica'), ('Europe/Prague', 'Europe/Prague'), ('Europe/Riga', 'Europe/Riga'), ('Europe/Rome', 'Europe/Rome'), ('Europe/Samara', 'Europe/Samara'), ('Europe/San_Marino', 'Europe/San_Marino'), ('Europe/Sarajevo', 'Europe/Sarajevo'), ('Europe/Saratov', 'Europe/Saratov'), ('Europe/Simferopol', 'Europe/Simferopol'), ('Europe/Skopje', 'Europe/Skopje'), ('Europe/Sofia', 'Europe/Sofia'), ('Europe/Stockholm', 'Europe/Stockholm'), ('Europe/Tallinn', 'Europe/Tallinn'), ('Europe/Tirane', 'Europe/Tirane'), ('Europe/Tiraspol', 'Europe/Tiraspol'), ('Europe/Ulyanovsk', 'Europe/Ulyanovsk'), ('Europe/Uzhgorod', 'Europe/Uzhgorod'), ('Europe/Vaduz', 'Europe/Vaduz'), ('Europe/Vatican', 'Europe/Vatican'), ('Europe/Vienna', 'Europe/Vienna'), ('Europe/Vilnius', 'Europe/Vilnius'), ('Europe/Volgograd', 'Europe/Volgograd'), ('Europe/Warsaw', 'Europe/Warsaw'), ('Europe/Zagreb', 'Europe/Zagreb'), ('Europe/Zaporozhye', 'Europe/Zaporozhye'), ('Europe/Zurich', 'Europe/Zurich'), ('GB', 'GB'), ('GB-Eire', 'GB-Eire'), ('GMT', 'GMT'), ('GMT+0', 'GMT+0'), ('GMT-0', 'GMT-0'), ('GMT0', 'GMT0'), ('Greenwich', 'Greenwich'), ('HST', 'HST'), ('Hongkong', 'Hongkong'), ('Iceland', 'Iceland'), ('Indian/Antananarivo', 'Indian/Antananarivo'), ('Indian/Chagos', 'Indian/Chagos'), ('Indian/Christmas', 'Indian/Christmas'), ('Indian/Cocos', 'Indian/Cocos'), ('Indian/Comoro', 'Indian/Comoro'), ('Indian/Kerguelen', 'Indian/Kerguelen'), ('Indian/Mahe', 'Indian/Mahe'), ('Indian/Maldives', 'Indian/Maldives'), ('Indian/Mauritius', 'Indian/Mauritius'), ('Indian/Mayotte', 'Indian/Mayotte'), ('Indian/Reunion', 'Indian/Reunion'), ('Iran', 'Iran'), ('Israel', 'Israel'), ('Jamaica', 'Jamaica'), ('Japan', 'Japan'), ('Kwajalein', 'Kwajalein'), ('Libya', 'Libya'), ('MET', 'MET'), ('MST', 'MST'), ('MST7MDT', 'MST7MDT'), ('Mexico/BajaNorte', 'Mexico/BajaNorte'), ('Mexico/BajaSur', 'Mexico/BajaSur'), ('Mexico/General', 'Mexico/General'), ('NZ', 'NZ'), ('NZ-CHAT', 'NZ-CHAT'), ('Navajo', 'Navajo'), ('PRC', 'PRC'), ('PST8PDT', 'PST8PDT'), ('Pacific/Apia', 'Pacific/Apia'), ('Pacific/Auckland', 'Pacific/Auckland'), ('Pacific/Bougainville', 'Pacific/Bougainville'), ('Pacific/Chatham', 'Pacific/Chatham'), ('Pacific/Chuuk', 'Pacific/Chuuk'), ('Pacific/Easter', 'Pacific/Easter'), ('Pacific/Efate', 'Pacific/Efate'), ('Pacific/Enderbury', 'Pacific/Enderbury'), ('Pacific/Fakaofo', 'Pacific/Fakaofo'), ('Pacific/Fiji', 'Pacific/Fiji'), ('Pacific/Funafuti', 'Pacific/Funafuti'), ('Pacific/Galapagos', 'Pacific/Galapagos'), ('Pacific/Gambier', 'Pacific/Gambier'), ('Pacific/Guadalcanal', 'Pacific/Guadalcanal'), ('Pacific/Guam', 'Pacific/Guam'), ('Pacific/Honolulu', 'Pacific/Honolulu'), ('Pacific/Johnston', 'Pacific/Johnston'), ('Pacific/Kiritimati', 'Pacific/Kiritimati'), ('Pacific/Kosrae', 'Pacific/Kosrae'), ('Pacific/Kwajalein', 'Pacific/Kwajalein'), ('Pacific/Majuro', 'Pacific/Majuro'), ('Pacific/Marquesas', 'Pacific/Marquesas'), ('Pacific/Midway', 'Pacific/Midway'), ('Pacific/Nauru', 'Pacific/Nauru'), ('Pacific/Niue', 'Pacific/Niue'), ('Pacific/Norfolk', 'Pacific/Norfolk'), ('Pacific/Noumea', 'Pacific/Noumea'), ('Pacific/Pago_Pago', 'Pacific/Pago_Pago'), ('Pacific/Palau', 'Pacific/Palau'), ('Pacific/Pitcairn', 'Pacific/Pitcairn'), ('Pacific/Pohnpei', 'Pacific/Pohnpei'), ('Pacific/Ponape', 'Pacific/Ponape'), ('Pacific/Port_Moresby', 'Pacific/Port_Moresby'), ('Pacific/Rarotonga', 'Pacific/Rarotonga'), ('Pacific/Saipan', 'Pacific/Saipan'), ('Pacific/Samoa', 'Pacific/Samoa'), ('Pacific/Tahiti', 'Pacific/Tahiti'), ('Pacific/Tarawa', 'Pacific/Tarawa'), ('Pacific/Tongatapu', 'Pacific/Tongatapu'), ('Pacific/Truk', 'Pacific/Truk'), ('Pacific/Wake', 'Pacific/Wake'), ('Pacific/Wallis', 'Pacific/Wallis'), ('Pacific/Yap', 'Pacific/Yap'), ('Poland', 'Poland'), ('Portugal', 'Portugal'), ('ROC', 'ROC'), ('ROK', 'ROK'), ('Singapore', 'Singapore'), ('Turkey', 'Turkey'), ('UCT', 'UCT'), ('US/Alaska', 'US/Alaska'), ('US/Aleutian', 'US/Aleutian'), ('US/Arizona', 'US/Arizona'), ('US/Central', 'US/Central'), ('US/East-Indiana', 'US/East-Indiana'), ('US/Eastern', 'US/Eastern'), ('US/Hawaii', 'US/Hawaii'), ('US/Indiana-Starke', 'US/Indiana-Starke'), ('US/Michigan', 'US/Michigan'), ('US/Mountain', 'US/Mountain'), ('US/Pacific', 'US/Pacific'), ('US/Samoa', 'US/Samoa'), ('UTC', 'UTC'), ('Universal', 'Universal'), ('W-SU', 'W-SU'), ('WET', 'WET'), ('Zulu', 'Zulu')], default='UTC', max_length=50)),
                ('display_endpoint_uri', models.BooleanField(default=False, help_text='Displays the full endpoint URI in the endpoint view.', verbose_name='Display Endpoint Full URI')),
                ('enable_product_grade', models.BooleanField(default=False, help_text='Displays a grade letter next to a product to show the overall health.', verbose_name='Enable Product Grading')),
                ('product_grade', models.CharField(blank=True, max_length=800)),
                ('product_grade_a', models.IntegerField(default=90, help_text="Percentage score for an 'A' >=", verbose_name='Grade A')),
                ('product_grade_b', models.IntegerField(default=80, help_text="Percentage score for a 'B' >=", verbose_name='Grade B')),
                ('product_grade_c', models.IntegerField(default=70, help_text="Percentage score for a 'C' >=", verbose_name='Grade C')),
                ('product_grade_d', models.IntegerField(default=60, help_text="Percentage score for a 'D' >=", verbose_name='Grade D')),
                ('product_grade_f', models.IntegerField(default=59, help_text="Percentage score for an 'F' <=", verbose_name='Grade F')),
                ('enable_benchmark', models.BooleanField(default=True, help_text='Enables Benchmarks such as the OWASP ASVS (Application Security Verification Standard)', verbose_name='Enable Benchmarks')),
                ('enable_template_match', models.BooleanField(default=False, help_text='Enables global remediation advice and matching on CWE and Title. The text will be replaced for mitigation, impact and references on a finding. Useful for providing consistent impact and remediation advice regardless of the scanner.', verbose_name='Enable Remediation Advice')),
                ('engagement_auto_close', models.BooleanField(default=False, help_text='Closes an engagement after 3 days (default) past due date including last update.', verbose_name='Enable Engagement Auto-Close')),
                ('engagement_auto_close_days', models.IntegerField(default=3, help_text='Closes an engagement after the specified number of days past due date including last update.', verbose_name='Engagement Auto-Close Days')),
                ('enable_finding_sla', models.BooleanField(default=True, help_text="Enables Finding SLA's for time to remediate.", verbose_name="Enable Finding SLA's")),
                ('sla_critical', models.IntegerField(default=7, help_text='# of days to remediate a critical finding.', verbose_name='Critical Finding SLA Days')),
                ('sla_high', models.IntegerField(default=30, help_text='# of days to remediate a high finding.', verbose_name='High Finding SLA Days')),
                ('sla_medium', models.IntegerField(default=90, help_text='# of days to remediate a medium finding.', verbose_name='Medium Finding SLA Days')),
                ('sla_low', models.IntegerField(default=120, help_text='# of days to remediate a low finding.', verbose_name='Low Finding SLA Days')),
            ],
        ),
        migrations.AlterField(
            model_name='finding',
            name='file_path',
            field=models.CharField(blank=True, max_length=4000, null=True),
        ),
        migrations.CreateModel(
            name='JIRA_Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('jira_id', models.CharField(max_length=200)),
                ('jira_key', models.CharField(max_length=200)),
                ('engagement', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement')),
                ('finding', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.finding')),
            ],
        ),
        migrations.CreateModel(
            name='Sonarqube_Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(help_text='SonarQube issue key', max_length=30, unique=True)),
                ('status', models.CharField(help_text='SonarQube issue status', max_length=20)),
                ('type', models.CharField(help_text='SonarQube issue type', max_length=15)),
            ],
        ),
        migrations.CreateModel(
            name='Child_Rule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('Matches', 'Matches'), ('Contains', 'Contains')], max_length=30)),
                ('model_object', models.CharField(choices=[('Finding', 'Finding')], max_length=30)),
                ('match_field', models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue')], max_length=200)),
                ('match_text', models.TextField()),
                ('parent_rule', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.rule')),
            ],
        ),
        migrations.CreateModel(
            name='Sonarqube_Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sonarqube_project_key', models.CharField(blank=True, max_length=200, null=True, verbose_name='SonarQube Project Key')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
                ('sonarqube_tool_config', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.tool_configuration', verbose_name='SonarQube Configuration')),
            ],
        ),
        migrations.CreateModel(
            name='Sonarqube_Issue_Transition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, editable=False)),
                ('finding_status', models.CharField(max_length=100)),
                ('sonarqube_status', models.CharField(max_length=50)),
                ('transitions', models.CharField(max_length=100)),
                ('sonarqube_issue', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.sonarqube_issue')),
            ],
            options={
                'ordering': ('-created',),
            },
        ),
        migrations.AddField(
            model_name='finding',
            name='sonarqube_issue',
            field=models.ForeignKey(blank=True, help_text='SonarQube issue', null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.sonarqube_issue'),
        ),
        migrations.RunPython(
            code=update_collation,
            reverse_code=rollback_collation,
            atomic=False,
        ),
        migrations.CreateModel(
            name='Note_Type',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.CharField(max_length=200)),
                ('is_single', models.BooleanField(default=False)),
                ('is_active', models.BooleanField(default=True)),
                ('is_mandatory', models.BooleanField(default=True)),
            ],
        ),
        migrations.AddField(
            model_name='notehistory',
            name='note_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.note_type'),
        ),
        migrations.AddField(
            model_name='notes',
            name='note_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='note_type', to='dojo.note_type'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='allow_anonymous_survey_repsonse',
            field=models.BooleanField(default=False, help_text='Enable anyone with a link to the survey to answer a survey', verbose_name='Allow Anonymous Survey Responses'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='cve',
            field=models.CharField(max_length=20, null=True, validators=[django.core.validators.RegexValidator(message="CVE must be entered in the format: 'CVE-9999-9999'. ", regex='^CVE-\\d{4}-\\d{4,7}$')]),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['cve'], name='dojo_findin_cve_dccd4b_idx'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='credentials',
            field=models.CharField(blank=True, max_length=3000),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='column_widths',
            field=models.CharField(blank=True, max_length=1500),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='drive_folder_ID',
            field=models.CharField(blank=True, max_length=100),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='enable_google_sheets',
            field=models.BooleanField(blank=True, default=False, null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='nb_occurences',
            field=models.IntegerField(blank=True, help_text='Number of occurences in the source tool when several vulnerabilites were found and aggregated by the scanner', null=True, verbose_name='Number of occurences'),
        ),
        migrations.AddField(
            model_name='finding',
            name='sast_sink_object',
            field=models.CharField(blank=True, help_text='Sink object (variable, function...) of the attack vector', max_length=500, null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='sast_source_file_path',
            field=models.CharField(blank=True, help_text='Source filepath of the attack vector', max_length=4000, null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='sast_source_line',
            field=models.IntegerField(blank=True, help_text='Source line number of the attack vector', null=True, verbose_name='Line number'),
        ),
        migrations.AddField(
            model_name='finding',
            name='sast_source_object',
            field=models.CharField(blank=True, help_text='Source object (variable, function...) of the attack vector', max_length=500, null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='unique_id_from_tool',
            field=models.CharField(blank=True, help_text='Vulnerability technical id from the source tool. Allows to track unique vulnerabilities', max_length=500, null=True),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='finding',
            name='file_path',
            field=models.CharField(blank=True, help_text='File name with path. For SAST, when source (start of the attack vector) and sink (end of the attack vector) information are available, put sink information here', max_length=4000, null=True),
        ),
        migrations.AlterField(
            model_name='finding',
            name='line',
            field=models.IntegerField(blank=True, help_text='Line number. For SAST, when source (start of the attack vector) and sink (end of the attack vector) information are available, put sink information here', null=True, verbose_name='Line number'),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='finding',
            name='cve',
            field=models.CharField(max_length=28, null=True, validators=[django.core.validators.RegexValidator(message="Vulnerability ID must be entered in the format: 'ABC-9999-9999'. ", regex='^[A-Z]{1,10}-\\d{4}-\\d{4,12}$')]),
        ),
        migrations.AlterField(
            model_name='finding_template',
            name='cve',
            field=models.CharField(max_length=28, null=True, validators=[django.core.validators.RegexValidator(message="Vulnerability ID must be entered in the format: 'ABC-9999-9999'. ", regex='^[A-Z]{1,10}-\\d{4}-\\d{4,12}$')]),
        ),
        migrations.AlterField(
            model_name='jira_conf',
            name='default_issue_type',
            field=models.CharField(choices=[('Task', 'Task'), ('Story', 'Story'), ('Epic', 'Epic'), ('Spike', 'Spike'), ('Bug', 'Bug'), ('Security', 'Security')], default='Bug', max_length=9),
        ),
        migrations.CreateModel(
            name='BannerConf',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('banner_enable', models.BooleanField(blank=True, default=False, null=True)),
                ('banner_message', models.CharField(default='', help_text="This message will be displayed on the login page. It can contain basic html tags, for example <a href='https://www.fred.com' style='color: #337ab7;' target='_blank'>https://example.com</a>", max_length=500)),
            ],
        ),
        migrations.AlterField(
            model_name='jira_conf',
            name='default_issue_type',
            field=models.CharField(choices=[('Task', 'Task'), ('Story', 'Story'), ('Epic', 'Epic'), ('Spike', 'Spike'), ('Bug', 'Bug'), ('Security', 'Security')], default='Bug', help_text='You can define extra issue types in settings.py', max_length=15),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['false_p'], name='dojo_findin_false_p_aac0c7_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['verified'], name='dojo_findin_verifie_beb0fc_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['mitigated'], name='dojo_findin_mitigat_946a13_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['active'], name='dojo_findin_active_d51077_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['date'], name='dojo_findin_date_8e9143_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['out_of_scope'], name='dojo_findin_out_of__26856e_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['numerical_severity'], name='dojo_findin_numeric_83d93b_idx'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='title',
            field=models.CharField(max_length=511),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['title'], name='dojo_findin_title_78f900_idx'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='cve',
            field=models.CharField(help_text='CVE or other vulnerability identifier', max_length=28, null=True, validators=[django.core.validators.RegexValidator(message="Vulnerability ID must be entered in the format: 'ABC-9999-9999'.", regex='^[A-Z]{1,10}(-\\d+)+$')]),
        ),
        migrations.AlterField(
            model_name='finding_template',
            name='cve',
            field=models.CharField(max_length=28, null=True, validators=[django.core.validators.RegexValidator(message="Vulnerability ID must be entered in the format: 'ABC-9999-9999'.", regex='^[A-Z]{1,10}(-\\d+)+$')]),
        ),
        migrations.AlterModelOptions(
            name='product_type',
            options={'ordering': ('name',)},
        ),
        migrations.AddField(
            model_name='finding',
            name='component_name',
            field=models.CharField(blank=True, help_text='Name of the component containing the finding. ', max_length=200, null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='component_version',
            field=models.CharField(blank=True, help_text='Version of the component.', max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='enable_auditlog',
            field=models.BooleanField(default=True, help_text="With this setting turned on, Dojo maintains an audit log of changes made to entities (Findings, Tests, Engagements, Procuts, ...)If you run big import you may want to disable this because the way django-auditlog currently works, there's a big performance hit. Especially during (re-)imports.", verbose_name='Enable audit logging'),
        ),
        migrations.RemoveField(
            model_name='finding',
            name='duplicate_list',
        ),
        migrations.CreateModel(
            name='GITHUB_Clone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('github_id', models.CharField(max_length=200)),
                ('github_clone_id', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='GITHUB_Conf',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('configuration_name', models.CharField(default='', help_text='Enter a name to give to this configuration', max_length=2000)),
                ('api_key', models.CharField(default='', help_text='Enter your Github API Key', max_length=2000)),
            ],
        ),
        migrations.CreateModel(
            name='GITHUB_Details_Cache',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('github_id', models.CharField(max_length=200)),
                ('github_key', models.CharField(max_length=200)),
                ('github_status', models.CharField(max_length=200)),
                ('github_resolution', models.CharField(max_length=200)),
            ],
        ),
        migrations.AddField(
            model_name='system_settings',
            name='enable_github',
            field=models.BooleanField(default=False, verbose_name='Enable GITHUB integration'),
        ),
        migrations.CreateModel(
            name='GITHUB_Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('issue_id', models.CharField(max_length=200)),
                ('issue_url', models.URLField(max_length=2000, verbose_name='GitHub issue URL')),
                ('finding', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.finding')),
            ],
        ),
        migrations.AlterField(
            model_name='jira_pkey',
            name='push_all_issues',
            field=models.BooleanField(blank=True, default=False, help_text='Automatically maintain parity with JIRA. Always create and update JIRA tickets for findings in this Product.'),
        ),
        migrations.CreateModel(
            name='GITHUB_PKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('git_project', models.CharField(blank=True, help_text='Specify your project location. (:user/:repo)', max_length=200, verbose_name='Github project')),
                ('git_push_notes', models.BooleanField(blank=True, default=False, help_text='Notes added to findings will be automatically added to the corresponding github issue')),
                ('git_conf', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.github_conf', verbose_name='Github Configuration')),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
            ],
        ),
        migrations.AddField(
            model_name='system_settings',
            name='email_address',
            field=models.EmailField(blank=True, max_length=100),
        ),
        migrations.RenameField(
            model_name='notifications',
            old_name='results_added',
            new_name='scan_added',
        ),
        migrations.AlterField(
            model_name='notifications',
            name='user',
            field=models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.dojo_user'),
        ),
        migrations.AddField(
            model_name='notifications',
            name='product',
            field=models.ForeignKey(default=None, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.product'),
        ),
        migrations.AddConstraint(
            model_name='notifications',
            constraint=models.UniqueConstraint(fields=('user', 'product'), name='notifications_user_product'),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='scan_added',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Triggered whenever an (re-)import has been done that created/updated/closed findings.', max_length=24),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='time_zone',
            field=models.CharField(choices=[('Africa/Abidjan', 'Africa/Abidjan'), ('Africa/Accra', 'Africa/Accra'), ('Africa/Addis_Ababa', 'Africa/Addis_Ababa'), ('Africa/Algiers', 'Africa/Algiers'), ('Africa/Asmara', 'Africa/Asmara'), ('Africa/Asmera', 'Africa/Asmera'), ('Africa/Bamako', 'Africa/Bamako'), ('Africa/Bangui', 'Africa/Bangui'), ('Africa/Banjul', 'Africa/Banjul'), ('Africa/Bissau', 'Africa/Bissau'), ('Africa/Blantyre', 'Africa/Blantyre'), ('Africa/Brazzaville', 'Africa/Brazzaville'), ('Africa/Bujumbura', 'Africa/Bujumbura'), ('Africa/Cairo', 'Africa/Cairo'), ('Africa/Casablanca', 'Africa/Casablanca'), ('Africa/Ceuta', 'Africa/Ceuta'), ('Africa/Conakry', 'Africa/Conakry'), ('Africa/Dakar', 'Africa/Dakar'), ('Africa/Dar_es_Salaam', 'Africa/Dar_es_Salaam'), ('Africa/Djibouti', 'Africa/Djibouti'), ('Africa/Douala', 'Africa/Douala'), ('Africa/El_Aaiun', 'Africa/El_Aaiun'), ('Africa/Freetown', 'Africa/Freetown'), ('Africa/Gaborone', 'Africa/Gaborone'), ('Africa/Harare', 'Africa/Harare'), ('Africa/Johannesburg', 'Africa/Johannesburg'), ('Africa/Juba', 'Africa/Juba'), ('Africa/Kampala', 'Africa/Kampala'), ('Africa/Khartoum', 'Africa/Khartoum'), ('Africa/Kigali', 'Africa/Kigali'), ('Africa/Kinshasa', 'Africa/Kinshasa'), ('Africa/Lagos', 'Africa/Lagos'), ('Africa/Libreville', 'Africa/Libreville'), ('Africa/Lome', 'Africa/Lome'), ('Africa/Luanda', 'Africa/Luanda'), ('Africa/Lubumbashi', 'Africa/Lubumbashi'), ('Africa/Lusaka', 'Africa/Lusaka'), ('Africa/Malabo', 'Africa/Malabo'), ('Africa/Maputo', 'Africa/Maputo'), ('Africa/Maseru', 'Africa/Maseru'), ('Africa/Mbabane', 'Africa/Mbabane'), ('Africa/Mogadishu', 'Africa/Mogadishu'), ('Africa/Monrovia', 'Africa/Monrovia'), ('Africa/Nairobi', 'Africa/Nairobi'), ('Africa/Ndjamena', 'Africa/Ndjamena'), ('Africa/Niamey', 'Africa/Niamey'), ('Africa/Nouakchott', 'Africa/Nouakchott'), ('Africa/Ouagadougou', 'Africa/Ouagadougou'), ('Africa/Porto-Novo', 'Africa/Porto-Novo'), ('Africa/Sao_Tome', 'Africa/Sao_Tome'), ('Africa/Timbuktu', 'Africa/Timbuktu'), ('Africa/Tripoli', 'Africa/Tripoli'), ('Africa/Tunis', 'Africa/Tunis'), ('Africa/Windhoek', 'Africa/Windhoek'), ('America/Adak', 'America/Adak'), ('America/Anchorage', 'America/Anchorage'), ('America/Anguilla', 'America/Anguilla'), ('America/Antigua', 'America/Antigua'), ('America/Araguaina', 'America/Araguaina'), ('America/Argentina/Buenos_Aires', 'America/Argentina/Buenos_Aires'), ('America/Argentina/Catamarca', 'America/Argentina/Catamarca'), ('America/Argentina/ComodRivadavia', 'America/Argentina/ComodRivadavia'), ('America/Argentina/Cordoba', 'America/Argentina/Cordoba'), ('America/Argentina/Jujuy', 'America/Argentina/Jujuy'), ('America/Argentina/La_Rioja', 'America/Argentina/La_Rioja'), ('America/Argentina/Mendoza', 'America/Argentina/Mendoza'), ('America/Argentina/Rio_Gallegos', 'America/Argentina/Rio_Gallegos'), ('America/Argentina/Salta', 'America/Argentina/Salta'), ('America/Argentina/San_Juan', 'America/Argentina/San_Juan'), ('America/Argentina/San_Luis', 'America/Argentina/San_Luis'), ('America/Argentina/Tucuman', 'America/Argentina/Tucuman'), ('America/Argentina/Ushuaia', 'America/Argentina/Ushuaia'), ('America/Aruba', 'America/Aruba'), ('America/Asuncion', 'America/Asuncion'), ('America/Atikokan', 'America/Atikokan'), ('America/Atka', 'America/Atka'), ('America/Bahia', 'America/Bahia'), ('America/Bahia_Banderas', 'America/Bahia_Banderas'), ('America/Barbados', 'America/Barbados'), ('America/Belem', 'America/Belem'), ('America/Belize', 'America/Belize'), ('America/Blanc-Sablon', 'America/Blanc-Sablon'), ('America/Boa_Vista', 'America/Boa_Vista'), ('America/Bogota', 'America/Bogota'), ('America/Boise', 'America/Boise'), ('America/Buenos_Aires', 'America/Buenos_Aires'), ('America/Cambridge_Bay', 'America/Cambridge_Bay'), ('America/Campo_Grande', 'America/Campo_Grande'), ('America/Cancun', 'America/Cancun'), ('America/Caracas', 'America/Caracas'), ('America/Catamarca', 'America/Catamarca'), ('America/Cayenne', 'America/Cayenne'), ('America/Cayman', 'America/Cayman'), ('America/Chicago', 'America/Chicago'), ('America/Chihuahua', 'America/Chihuahua'), ('America/Coral_Harbour', 'America/Coral_Harbour'), ('America/Cordoba', 'America/Cordoba'), ('America/Costa_Rica', 'America/Costa_Rica'), ('America/Creston', 'America/Creston'), ('America/Cuiaba', 'America/Cuiaba'), ('America/Curacao', 'America/Curacao'), ('America/Danmarkshavn', 'America/Danmarkshavn'), ('America/Dawson', 'America/Dawson'), ('America/Dawson_Creek', 'America/Dawson_Creek'), ('America/Denver', 'America/Denver'), ('America/Detroit', 'America/Detroit'), ('America/Dominica', 'America/Dominica'), ('America/Edmonton', 'America/Edmonton'), ('America/Eirunepe', 'America/Eirunepe'), ('America/El_Salvador', 'America/El_Salvador'), ('America/Ensenada', 'America/Ensenada'), ('America/Fort_Nelson', 'America/Fort_Nelson'), ('America/Fort_Wayne', 'America/Fort_Wayne'), ('America/Fortaleza', 'America/Fortaleza'), ('America/Glace_Bay', 'America/Glace_Bay'), ('America/Godthab', 'America/Godthab'), ('America/Goose_Bay', 'America/Goose_Bay'), ('America/Grand_Turk', 'America/Grand_Turk'), ('America/Grenada', 'America/Grenada'), ('America/Guadeloupe', 'America/Guadeloupe'), ('America/Guatemala', 'America/Guatemala'), ('America/Guayaquil', 'America/Guayaquil'), ('America/Guyana', 'America/Guyana'), ('America/Halifax', 'America/Halifax'), ('America/Havana', 'America/Havana'), ('America/Hermosillo', 'America/Hermosillo'), ('America/Indiana/Indianapolis', 'America/Indiana/Indianapolis'), ('America/Indiana/Knox', 'America/Indiana/Knox'), ('America/Indiana/Marengo', 'America/Indiana/Marengo'), ('America/Indiana/Petersburg', 'America/Indiana/Petersburg'), ('America/Indiana/Tell_City', 'America/Indiana/Tell_City'), ('America/Indiana/Vevay', 'America/Indiana/Vevay'), ('America/Indiana/Vincennes', 'America/Indiana/Vincennes'), ('America/Indiana/Winamac', 'America/Indiana/Winamac'), ('America/Indianapolis', 'America/Indianapolis'), ('America/Inuvik', 'America/Inuvik'), ('America/Iqaluit', 'America/Iqaluit'), ('America/Jamaica', 'America/Jamaica'), ('America/Jujuy', 'America/Jujuy'), ('America/Juneau', 'America/Juneau'), ('America/Kentucky/Louisville', 'America/Kentucky/Louisville'), ('America/Kentucky/Monticello', 'America/Kentucky/Monticello'), ('America/Knox_IN', 'America/Knox_IN'), ('America/Kralendijk', 'America/Kralendijk'), ('America/La_Paz', 'America/La_Paz'), ('America/Lima', 'America/Lima'), ('America/Los_Angeles', 'America/Los_Angeles'), ('America/Louisville', 'America/Louisville'), ('America/Lower_Princes', 'America/Lower_Princes'), ('America/Maceio', 'America/Maceio'), ('America/Managua', 'America/Managua'), ('America/Manaus', 'America/Manaus'), ('America/Marigot', 'America/Marigot'), ('America/Martinique', 'America/Martinique'), ('America/Matamoros', 'America/Matamoros'), ('America/Mazatlan', 'America/Mazatlan'), ('America/Mendoza', 'America/Mendoza'), ('America/Menominee', 'America/Menominee'), ('America/Merida', 'America/Merida'), ('America/Metlakatla', 'America/Metlakatla'), ('America/Mexico_City', 'America/Mexico_City'), ('America/Miquelon', 'America/Miquelon'), ('America/Moncton', 'America/Moncton'), ('America/Monterrey', 'America/Monterrey'), ('America/Montevideo', 'America/Montevideo'), ('America/Montreal', 'America/Montreal'), ('America/Montserrat', 'America/Montserrat'), ('America/Nassau', 'America/Nassau'), ('America/New_York', 'America/New_York'), ('America/Nipigon', 'America/Nipigon'), ('America/Nome', 'America/Nome'), ('America/Noronha', 'America/Noronha'), ('America/North_Dakota/Beulah', 'America/North_Dakota/Beulah'), ('America/North_Dakota/Center', 'America/North_Dakota/Center'), ('America/North_Dakota/New_Salem', 'America/North_Dakota/New_Salem'), ('America/Nuuk', 'America/Nuuk'), ('America/Ojinaga', 'America/Ojinaga'), ('America/Panama', 'America/Panama'), ('America/Pangnirtung', 'America/Pangnirtung'), ('America/Paramaribo', 'America/Paramaribo'), ('America/Phoenix', 'America/Phoenix'), ('America/Port-au-Prince', 'America/Port-au-Prince'), ('America/Port_of_Spain', 'America/Port_of_Spain'), ('America/Porto_Acre', 'America/Porto_Acre'), ('America/Porto_Velho', 'America/Porto_Velho'), ('America/Puerto_Rico', 'America/Puerto_Rico'), ('America/Punta_Arenas', 'America/Punta_Arenas'), ('America/Rainy_River', 'America/Rainy_River'), ('America/Rankin_Inlet', 'America/Rankin_Inlet'), ('America/Recife', 'America/Recife'), ('America/Regina', 'America/Regina'), ('America/Resolute', 'America/Resolute'), ('America/Rio_Branco', 'America/Rio_Branco'), ('America/Rosario', 'America/Rosario'), ('America/Santa_Isabel', 'America/Santa_Isabel'), ('America/Santarem', 'America/Santarem'), ('America/Santiago', 'America/Santiago'), ('America/Santo_Domingo', 'America/Santo_Domingo'), ('America/Sao_Paulo', 'America/Sao_Paulo'), ('America/Scoresbysund', 'America/Scoresbysund'), ('America/Shiprock', 'America/Shiprock'), ('America/Sitka', 'America/Sitka'), ('America/St_Barthelemy', 'America/St_Barthelemy'), ('America/St_Johns', 'America/St_Johns'), ('America/St_Kitts', 'America/St_Kitts'), ('America/St_Lucia', 'America/St_Lucia'), ('America/St_Thomas', 'America/St_Thomas'), ('America/St_Vincent', 'America/St_Vincent'), ('America/Swift_Current', 'America/Swift_Current'), ('America/Tegucigalpa', 'America/Tegucigalpa'), ('America/Thule', 'America/Thule'), ('America/Thunder_Bay', 'America/Thunder_Bay'), ('America/Tijuana', 'America/Tijuana'), ('America/Toronto', 'America/Toronto'), ('America/Tortola', 'America/Tortola'), ('America/Vancouver', 'America/Vancouver'), ('America/Virgin', 'America/Virgin'), ('America/Whitehorse', 'America/Whitehorse'), ('America/Winnipeg', 'America/Winnipeg'), ('America/Yakutat', 'America/Yakutat'), ('America/Yellowknife', 'America/Yellowknife'), ('Antarctica/Casey', 'Antarctica/Casey'), ('Antarctica/Davis', 'Antarctica/Davis'), ('Antarctica/DumontDUrville', 'Antarctica/DumontDUrville'), ('Antarctica/Macquarie', 'Antarctica/Macquarie'), ('Antarctica/Mawson', 'Antarctica/Mawson'), ('Antarctica/McMurdo', 'Antarctica/McMurdo'), ('Antarctica/Palmer', 'Antarctica/Palmer'), ('Antarctica/Rothera', 'Antarctica/Rothera'), ('Antarctica/South_Pole', 'Antarctica/South_Pole'), ('Antarctica/Syowa', 'Antarctica/Syowa'), ('Antarctica/Troll', 'Antarctica/Troll'), ('Antarctica/Vostok', 'Antarctica/Vostok'), ('Arctic/Longyearbyen', 'Arctic/Longyearbyen'), ('Asia/Aden', 'Asia/Aden'), ('Asia/Almaty', 'Asia/Almaty'), ('Asia/Amman', 'Asia/Amman'), ('Asia/Anadyr', 'Asia/Anadyr'), ('Asia/Aqtau', 'Asia/Aqtau'), ('Asia/Aqtobe', 'Asia/Aqtobe'), ('Asia/Ashgabat', 'Asia/Ashgabat'), ('Asia/Ashkhabad', 'Asia/Ashkhabad'), ('Asia/Atyrau', 'Asia/Atyrau'), ('Asia/Baghdad', 'Asia/Baghdad'), ('Asia/Bahrain', 'Asia/Bahrain'), ('Asia/Baku', 'Asia/Baku'), ('Asia/Bangkok', 'Asia/Bangkok'), ('Asia/Barnaul', 'Asia/Barnaul'), ('Asia/Beirut', 'Asia/Beirut'), ('Asia/Bishkek', 'Asia/Bishkek'), ('Asia/Brunei', 'Asia/Brunei'), ('Asia/Calcutta', 'Asia/Calcutta'), ('Asia/Chita', 'Asia/Chita'), ('Asia/Choibalsan', 'Asia/Choibalsan'), ('Asia/Chongqing', 'Asia/Chongqing'), ('Asia/Chungking', 'Asia/Chungking'), ('Asia/Colombo', 'Asia/Colombo'), ('Asia/Dacca', 'Asia/Dacca'), ('Asia/Damascus', 'Asia/Damascus'), ('Asia/Dhaka', 'Asia/Dhaka'), ('Asia/Dili', 'Asia/Dili'), ('Asia/Dubai', 'Asia/Dubai'), ('Asia/Dushanbe', 'Asia/Dushanbe'), ('Asia/Famagusta', 'Asia/Famagusta'), ('Asia/Gaza', 'Asia/Gaza'), ('Asia/Harbin', 'Asia/Harbin'), ('Asia/Hebron', 'Asia/Hebron'), ('Asia/Ho_Chi_Minh', 'Asia/Ho_Chi_Minh'), ('Asia/Hong_Kong', 'Asia/Hong_Kong'), ('Asia/Hovd', 'Asia/Hovd'), ('Asia/Irkutsk', 'Asia/Irkutsk'), ('Asia/Istanbul', 'Asia/Istanbul'), ('Asia/Jakarta', 'Asia/Jakarta'), ('Asia/Jayapura', 'Asia/Jayapura'), ('Asia/Jerusalem', 'Asia/Jerusalem'), ('Asia/Kabul', 'Asia/Kabul'), ('Asia/Kamchatka', 'Asia/Kamchatka'), ('Asia/Karachi', 'Asia/Karachi'), ('Asia/Kashgar', 'Asia/Kashgar'), ('Asia/Kathmandu', 'Asia/Kathmandu'), ('Asia/Katmandu', 'Asia/Katmandu'), ('Asia/Khandyga', 'Asia/Khandyga'), ('Asia/Kolkata', 'Asia/Kolkata'), ('Asia/Krasnoyarsk', 'Asia/Krasnoyarsk'), ('Asia/Kuala_Lumpur', 'Asia/Kuala_Lumpur'), ('Asia/Kuching', 'Asia/Kuching'), ('Asia/Kuwait', 'Asia/Kuwait'), ('Asia/Macao', 'Asia/Macao'), ('Asia/Macau', 'Asia/Macau'), ('Asia/Magadan', 'Asia/Magadan'), ('Asia/Makassar', 'Asia/Makassar'), ('Asia/Manila', 'Asia/Manila'), ('Asia/Muscat', 'Asia/Muscat'), ('Asia/Nicosia', 'Asia/Nicosia'), ('Asia/Novokuznetsk', 'Asia/Novokuznetsk'), ('Asia/Novosibirsk', 'Asia/Novosibirsk'), ('Asia/Omsk', 'Asia/Omsk'), ('Asia/Oral', 'Asia/Oral'), ('Asia/Phnom_Penh', 'Asia/Phnom_Penh'), ('Asia/Pontianak', 'Asia/Pontianak'), ('Asia/Pyongyang', 'Asia/Pyongyang'), ('Asia/Qatar', 'Asia/Qatar'), ('Asia/Qostanay', 'Asia/Qostanay'), ('Asia/Qyzylorda', 'Asia/Qyzylorda'), ('Asia/Rangoon', 'Asia/Rangoon'), ('Asia/Riyadh', 'Asia/Riyadh'), ('Asia/Saigon', 'Asia/Saigon'), ('Asia/Sakhalin', 'Asia/Sakhalin'), ('Asia/Samarkand', 'Asia/Samarkand'), ('Asia/Seoul', 'Asia/Seoul'), ('Asia/Shanghai', 'Asia/Shanghai'), ('Asia/Singapore', 'Asia/Singapore'), ('Asia/Srednekolymsk', 'Asia/Srednekolymsk'), ('Asia/Taipei', 'Asia/Taipei'), ('Asia/Tashkent', 'Asia/Tashkent'), ('Asia/Tbilisi', 'Asia/Tbilisi'), ('Asia/Tehran', 'Asia/Tehran'), ('Asia/Tel_Aviv', 'Asia/Tel_Aviv'), ('Asia/Thimbu', 'Asia/Thimbu'), ('Asia/Thimphu', 'Asia/Thimphu'), ('Asia/Tokyo', 'Asia/Tokyo'), ('Asia/Tomsk', 'Asia/Tomsk'), ('Asia/Ujung_Pandang', 'Asia/Ujung_Pandang'), ('Asia/Ulaanbaatar', 'Asia/Ulaanbaatar'), ('Asia/Ulan_Bator', 'Asia/Ulan_Bator'), ('Asia/Urumqi', 'Asia/Urumqi'), ('Asia/Ust-Nera', 'Asia/Ust-Nera'), ('Asia/Vientiane', 'Asia/Vientiane'), ('Asia/Vladivostok', 'Asia/Vladivostok'), ('Asia/Yakutsk', 'Asia/Yakutsk'), ('Asia/Yangon', 'Asia/Yangon'), ('Asia/Yekaterinburg', 'Asia/Yekaterinburg'), ('Asia/Yerevan', 'Asia/Yerevan'), ('Atlantic/Azores', 'Atlantic/Azores'), ('Atlantic/Bermuda', 'Atlantic/Bermuda'), ('Atlantic/Canary', 'Atlantic/Canary'), ('Atlantic/Cape_Verde', 'Atlantic/Cape_Verde'), ('Atlantic/Faeroe', 'Atlantic/Faeroe'), ('Atlantic/Faroe', 'Atlantic/Faroe'), ('Atlantic/Jan_Mayen', 'Atlantic/Jan_Mayen'), ('Atlantic/Madeira', 'Atlantic/Madeira'), ('Atlantic/Reykjavik', 'Atlantic/Reykjavik'), ('Atlantic/South_Georgia', 'Atlantic/South_Georgia'), ('Atlantic/St_Helena', 'Atlantic/St_Helena'), ('Atlantic/Stanley', 'Atlantic/Stanley'), ('Australia/ACT', 'Australia/ACT'), ('Australia/Adelaide', 'Australia/Adelaide'), ('Australia/Brisbane', 'Australia/Brisbane'), ('Australia/Broken_Hill', 'Australia/Broken_Hill'), ('Australia/Canberra', 'Australia/Canberra'), ('Australia/Currie', 'Australia/Currie'), ('Australia/Darwin', 'Australia/Darwin'), ('Australia/Eucla', 'Australia/Eucla'), ('Australia/Hobart', 'Australia/Hobart'), ('Australia/LHI', 'Australia/LHI'), ('Australia/Lindeman', 'Australia/Lindeman'), ('Australia/Lord_Howe', 'Australia/Lord_Howe'), ('Australia/Melbourne', 'Australia/Melbourne'), ('Australia/NSW', 'Australia/NSW'), ('Australia/North', 'Australia/North'), ('Australia/Perth', 'Australia/Perth'), ('Australia/Queensland', 'Australia/Queensland'), ('Australia/South', 'Australia/South'), ('Australia/Sydney', 'Australia/Sydney'), ('Australia/Tasmania', 'Australia/Tasmania'), ('Australia/Victoria', 'Australia/Victoria'), ('Australia/West', 'Australia/West'), ('Australia/Yancowinna', 'Australia/Yancowinna'), ('Brazil/Acre', 'Brazil/Acre'), ('Brazil/DeNoronha', 'Brazil/DeNoronha'), ('Brazil/East', 'Brazil/East'), ('Brazil/West', 'Brazil/West'), ('CET', 'CET'), ('CST6CDT', 'CST6CDT'), ('Canada/Atlantic', 'Canada/Atlantic'), ('Canada/Central', 'Canada/Central'), ('Canada/Eastern', 'Canada/Eastern'), ('Canada/Mountain', 'Canada/Mountain'), ('Canada/Newfoundland', 'Canada/Newfoundland'), ('Canada/Pacific', 'Canada/Pacific'), ('Canada/Saskatchewan', 'Canada/Saskatchewan'), ('Canada/Yukon', 'Canada/Yukon'), ('Chile/Continental', 'Chile/Continental'), ('Chile/EasterIsland', 'Chile/EasterIsland'), ('Cuba', 'Cuba'), ('EET', 'EET'), ('EST', 'EST'), ('EST5EDT', 'EST5EDT'), ('Egypt', 'Egypt'), ('Eire', 'Eire'), ('Etc/GMT', 'Etc/GMT'), ('Etc/GMT+0', 'Etc/GMT+0'), ('Etc/GMT+1', 'Etc/GMT+1'), ('Etc/GMT+10', 'Etc/GMT+10'), ('Etc/GMT+11', 'Etc/GMT+11'), ('Etc/GMT+12', 'Etc/GMT+12'), ('Etc/GMT+2', 'Etc/GMT+2'), ('Etc/GMT+3', 'Etc/GMT+3'), ('Etc/GMT+4', 'Etc/GMT+4'), ('Etc/GMT+5', 'Etc/GMT+5'), ('Etc/GMT+6', 'Etc/GMT+6'), ('Etc/GMT+7', 'Etc/GMT+7'), ('Etc/GMT+8', 'Etc/GMT+8'), ('Etc/GMT+9', 'Etc/GMT+9'), ('Etc/GMT-0', 'Etc/GMT-0'), ('Etc/GMT-1', 'Etc/GMT-1'), ('Etc/GMT-10', 'Etc/GMT-10'), ('Etc/GMT-11', 'Etc/GMT-11'), ('Etc/GMT-12', 'Etc/GMT-12'), ('Etc/GMT-13', 'Etc/GMT-13'), ('Etc/GMT-14', 'Etc/GMT-14'), ('Etc/GMT-2', 'Etc/GMT-2'), ('Etc/GMT-3', 'Etc/GMT-3'), ('Etc/GMT-4', 'Etc/GMT-4'), ('Etc/GMT-5', 'Etc/GMT-5'), ('Etc/GMT-6', 'Etc/GMT-6'), ('Etc/GMT-7', 'Etc/GMT-7'), ('Etc/GMT-8', 'Etc/GMT-8'), ('Etc/GMT-9', 'Etc/GMT-9'), ('Etc/GMT0', 'Etc/GMT0'), ('Etc/Greenwich', 'Etc/Greenwich'), ('Etc/UCT', 'Etc/UCT'), ('Etc/UTC', 'Etc/UTC'), ('Etc/Universal', 'Etc/Universal'), ('Etc/Zulu', 'Etc/Zulu'), ('Europe/Amsterdam', 'Europe/Amsterdam'), ('Europe/Andorra', 'Europe/Andorra'), ('Europe/Astrakhan', 'Europe/Astrakhan'), ('Europe/Athens', 'Europe/Athens'), ('Europe/Belfast', 'Europe/Belfast'), ('Europe/Belgrade', 'Europe/Belgrade'), ('Europe/Berlin', 'Europe/Berlin'), ('Europe/Bratislava', 'Europe/Bratislava'), ('Europe/Brussels', 'Europe/Brussels'), ('Europe/Bucharest', 'Europe/Bucharest'), ('Europe/Budapest', 'Europe/Budapest'), ('Europe/Busingen', 'Europe/Busingen'), ('Europe/Chisinau', 'Europe/Chisinau'), ('Europe/Copenhagen', 'Europe/Copenhagen'), ('Europe/Dublin', 'Europe/Dublin'), ('Europe/Gibraltar', 'Europe/Gibraltar'), ('Europe/Guernsey', 'Europe/Guernsey'), ('Europe/Helsinki', 'Europe/Helsinki'), ('Europe/Isle_of_Man', 'Europe/Isle_of_Man'), ('Europe/Istanbul', 'Europe/Istanbul'), ('Europe/Jersey', 'Europe/Jersey'), ('Europe/Kaliningrad', 'Europe/Kaliningrad'), ('Europe/Kiev', 'Europe/Kiev'), ('Europe/Kirov', 'Europe/Kirov'), ('Europe/Lisbon', 'Europe/Lisbon'), ('Europe/Ljubljana', 'Europe/Ljubljana'), ('Europe/London', 'Europe/London'), ('Europe/Luxembourg', 'Europe/Luxembourg'), ('Europe/Madrid', 'Europe/Madrid'), ('Europe/Malta', 'Europe/Malta'), ('Europe/Mariehamn', 'Europe/Mariehamn'), ('Europe/Minsk', 'Europe/Minsk'), ('Europe/Monaco', 'Europe/Monaco'), ('Europe/Moscow', 'Europe/Moscow'), ('Europe/Nicosia', 'Europe/Nicosia'), ('Europe/Oslo', 'Europe/Oslo'), ('Europe/Paris', 'Europe/Paris'), ('Europe/Podgorica', 'Europe/Podgorica'), ('Europe/Prague', 'Europe/Prague'), ('Europe/Riga', 'Europe/Riga'), ('Europe/Rome', 'Europe/Rome'), ('Europe/Samara', 'Europe/Samara'), ('Europe/San_Marino', 'Europe/San_Marino'), ('Europe/Sarajevo', 'Europe/Sarajevo'), ('Europe/Saratov', 'Europe/Saratov'), ('Europe/Simferopol', 'Europe/Simferopol'), ('Europe/Skopje', 'Europe/Skopje'), ('Europe/Sofia', 'Europe/Sofia'), ('Europe/Stockholm', 'Europe/Stockholm'), ('Europe/Tallinn', 'Europe/Tallinn'), ('Europe/Tirane', 'Europe/Tirane'), ('Europe/Tiraspol', 'Europe/Tiraspol'), ('Europe/Ulyanovsk', 'Europe/Ulyanovsk'), ('Europe/Uzhgorod', 'Europe/Uzhgorod'), ('Europe/Vaduz', 'Europe/Vaduz'), ('Europe/Vatican', 'Europe/Vatican'), ('Europe/Vienna', 'Europe/Vienna'), ('Europe/Vilnius', 'Europe/Vilnius'), ('Europe/Volgograd', 'Europe/Volgograd'), ('Europe/Warsaw', 'Europe/Warsaw'), ('Europe/Zagreb', 'Europe/Zagreb'), ('Europe/Zaporozhye', 'Europe/Zaporozhye'), ('Europe/Zurich', 'Europe/Zurich'), ('GB', 'GB'), ('GB-Eire', 'GB-Eire'), ('GMT', 'GMT'), ('GMT+0', 'GMT+0'), ('GMT-0', 'GMT-0'), ('GMT0', 'GMT0'), ('Greenwich', 'Greenwich'), ('HST', 'HST'), ('Hongkong', 'Hongkong'), ('Iceland', 'Iceland'), ('Indian/Antananarivo', 'Indian/Antananarivo'), ('Indian/Chagos', 'Indian/Chagos'), ('Indian/Christmas', 'Indian/Christmas'), ('Indian/Cocos', 'Indian/Cocos'), ('Indian/Comoro', 'Indian/Comoro'), ('Indian/Kerguelen', 'Indian/Kerguelen'), ('Indian/Mahe', 'Indian/Mahe'), ('Indian/Maldives', 'Indian/Maldives'), ('Indian/Mauritius', 'Indian/Mauritius'), ('Indian/Mayotte', 'Indian/Mayotte'), ('Indian/Reunion', 'Indian/Reunion'), ('Iran', 'Iran'), ('Israel', 'Israel'), ('Jamaica', 'Jamaica'), ('Japan', 'Japan'), ('Kwajalein', 'Kwajalein'), ('Libya', 'Libya'), ('MET', 'MET'), ('MST', 'MST'), ('MST7MDT', 'MST7MDT'), ('Mexico/BajaNorte', 'Mexico/BajaNorte'), ('Mexico/BajaSur', 'Mexico/BajaSur'), ('Mexico/General', 'Mexico/General'), ('NZ', 'NZ'), ('NZ-CHAT', 'NZ-CHAT'), ('Navajo', 'Navajo'), ('PRC', 'PRC'), ('PST8PDT', 'PST8PDT'), ('Pacific/Apia', 'Pacific/Apia'), ('Pacific/Auckland', 'Pacific/Auckland'), ('Pacific/Bougainville', 'Pacific/Bougainville'), ('Pacific/Chatham', 'Pacific/Chatham'), ('Pacific/Chuuk', 'Pacific/Chuuk'), ('Pacific/Easter', 'Pacific/Easter'), ('Pacific/Efate', 'Pacific/Efate'), ('Pacific/Enderbury', 'Pacific/Enderbury'), ('Pacific/Fakaofo', 'Pacific/Fakaofo'), ('Pacific/Fiji', 'Pacific/Fiji'), ('Pacific/Funafuti', 'Pacific/Funafuti'), ('Pacific/Galapagos', 'Pacific/Galapagos'), ('Pacific/Gambier', 'Pacific/Gambier'), ('Pacific/Guadalcanal', 'Pacific/Guadalcanal'), ('Pacific/Guam', 'Pacific/Guam'), ('Pacific/Honolulu', 'Pacific/Honolulu'), ('Pacific/Johnston', 'Pacific/Johnston'), ('Pacific/Kiritimati', 'Pacific/Kiritimati'), ('Pacific/Kosrae', 'Pacific/Kosrae'), ('Pacific/Kwajalein', 'Pacific/Kwajalein'), ('Pacific/Majuro', 'Pacific/Majuro'), ('Pacific/Marquesas', 'Pacific/Marquesas'), ('Pacific/Midway', 'Pacific/Midway'), ('Pacific/Nauru', 'Pacific/Nauru'), ('Pacific/Niue', 'Pacific/Niue'), ('Pacific/Norfolk', 'Pacific/Norfolk'), ('Pacific/Noumea', 'Pacific/Noumea'), ('Pacific/Pago_Pago', 'Pacific/Pago_Pago'), ('Pacific/Palau', 'Pacific/Palau'), ('Pacific/Pitcairn', 'Pacific/Pitcairn'), ('Pacific/Pohnpei', 'Pacific/Pohnpei'), ('Pacific/Ponape', 'Pacific/Ponape'), ('Pacific/Port_Moresby', 'Pacific/Port_Moresby'), ('Pacific/Rarotonga', 'Pacific/Rarotonga'), ('Pacific/Saipan', 'Pacific/Saipan'), ('Pacific/Samoa', 'Pacific/Samoa'), ('Pacific/Tahiti', 'Pacific/Tahiti'), ('Pacific/Tarawa', 'Pacific/Tarawa'), ('Pacific/Tongatapu', 'Pacific/Tongatapu'), ('Pacific/Truk', 'Pacific/Truk'), ('Pacific/Wake', 'Pacific/Wake'), ('Pacific/Wallis', 'Pacific/Wallis'), ('Pacific/Yap', 'Pacific/Yap'), ('Poland', 'Poland'), ('Portugal', 'Portugal'), ('ROC', 'ROC'), ('ROK', 'ROK'), ('Singapore', 'Singapore'), ('Turkey', 'Turkey'), ('UCT', 'UCT'), ('US/Alaska', 'US/Alaska'), ('US/Aleutian', 'US/Aleutian'), ('US/Arizona', 'US/Arizona'), ('US/Central', 'US/Central'), ('US/East-Indiana', 'US/East-Indiana'), ('US/Eastern', 'US/Eastern'), ('US/Hawaii', 'US/Hawaii'), ('US/Indiana-Starke', 'US/Indiana-Starke'), ('US/Michigan', 'US/Michigan'), ('US/Mountain', 'US/Mountain'), ('US/Pacific', 'US/Pacific'), ('US/Samoa', 'US/Samoa'), ('UTC', 'UTC'), ('Universal', 'Universal'), ('W-SU', 'W-SU'), ('WET', 'WET'), ('Zulu', 'Zulu')], default='UTC', max_length=50),
        ),
        migrations.AddField(
            model_name='test',
            name='version',
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['cwe'], name='dojo_findin_cwe_a8da22_idx'),
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('order', models.PositiveIntegerField(default=1, help_text='The render order')),
                ('optional', models.BooleanField(default=False, help_text="If selected, user doesn't have to answer this question")),
                ('text', models.TextField(default='', help_text='The question text')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_dojo.question_set+', to='contenttypes.contenttype')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='TextQuestion',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='dojo.question')),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('dojo.question',),
        ),
        migrations.CreateModel(
            name='Choice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('order', models.PositiveIntegerField(default=1)),
                ('label', models.TextField(default='')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
        ),
        migrations.CreateModel(
            name='TextAnswer',
            fields=[
                ('answer_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='dojo.answer')),
                ('answer', models.TextField(default='', help_text='The answer text')),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('dojo.answer',),
        ),
        migrations.CreateModel(
            name='ChoiceAnswer',
            fields=[
                ('answer_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='dojo.answer')),
                ('answer', models.ManyToManyField(help_text='The selected choices as the answer', to='dojo.Choice')),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('dojo.answer',),
        ),
        migrations.CreateModel(
            name='ChoiceQuestion',
            fields=[
                ('question_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='dojo.question')),
                ('multichoice', models.BooleanField(default=False, help_text='Select one or more')),
                ('choices', models.ManyToManyField(to='dojo.Choice')),
            ],
            options={
                'abstract': False,
                'base_manager_name': 'objects',
            },
            bases=('dojo.question',),
        ),
        migrations.CreateModel(
            name='Engagement_Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=200)),
                ('description', models.TextField(default='')),
                ('active', models.BooleanField(default=True)),
                ('questions', models.ManyToManyField(to='dojo.Question')),
            ],
            options={
                'verbose_name': 'Engagement Survey',
                'verbose_name_plural': 'Engagement Surveys',
                'ordering': ('-active', 'name'),
            },
        ),
        migrations.CreateModel(
            name='Answered_Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('completed', models.BooleanField(default=False)),
                ('answered_on', models.DateField(null=True)),
                ('engagement', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='engagement+', to='dojo.engagement')),
                ('responder', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='responder', to=settings.AUTH_USER_MODEL)),
                ('assignee', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='assignee', to=settings.AUTH_USER_MODEL)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement_survey')),
            ],
            options={
                'verbose_name': 'Answered Engagement Survey',
                'verbose_name_plural': 'Answered Engagement Surveys',
            },
        ),
        migrations.CreateModel(
            name='General_Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('num_responses', models.IntegerField(default=0)),
                ('generated', models.DateTimeField(auto_now_add=True, null=True)),
                ('expiration', models.DateTimeField()),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement_survey')),
            ],
            options={
                'verbose_name': 'General Engagement Survey',
                'verbose_name_plural': 'General Engagement Surveys',
            },
        ),
        migrations.AddField(
            model_name='answer',
            name='answered_survey',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.answered_survey'),
        ),
        migrations.AddField(
            model_name='answer',
            name='polymorphic_ctype',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_dojo.answer_set+', to='contenttypes.contenttype'),
        ),
        migrations.AddField(
            model_name='answer',
            name='question',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.question'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='name',
            field=models.CharField(default='Legacy acceptance', help_text='Descriptive name which in the future may also be used to group risk acceptances together across engagements and products', max_length=100),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='name',
            field=models.CharField(help_text='Descriptive name which in the future may also be used to group risk acceptances together across engagements and products', max_length=100),
        ),
        migrations.RenameField(
            model_name='risk_acceptance',
            old_name='reporter',
            new_name='owner',
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='owner',
            field=models.ForeignKey(help_text='Only the owner and staff users can edit the risk acceptance.', on_delete=django.db.models.deletion.CASCADE, to='dojo.dojo_user'),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='created',
            field=models.DateTimeField(auto_now_add=True),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='updated',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AlterField(
            model_name='finding',
            name='hash_code',
            field=models.CharField(blank=True, editable=False, max_length=64, null=True),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['hash_code'], name='dojo_findin_hash_co_09df6a_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['unique_id_from_tool'], name='dojo_findin_unique__f76d47_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['line'], name='dojo_findin_line_fea329_idx'),
        ),
        migrations.AlterField(
            model_name='product',
            name='prod_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='prod_type', to='dojo.product_type'),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='slack_channel',
            field=models.CharField(blank=True, default='', help_text='Optional. Needed if you want to send global notifications.', max_length=100),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='slack_username',
            field=models.CharField(blank=True, default='', help_text='Optional. Will take your bot name otherwise.', max_length=100),
        ),
        migrations.RenameField(
            model_name='endpoint',
            old_name='remediated',
            new_name='mitigated',
        ),
        migrations.CreateModel(
            name='Endpoint_Status',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(default=dojo.models.get_current_date)),
                ('last_modified', models.DateTimeField(default=dojo.models.get_current_datetime, editable=False, null=True)),
                ('mitigated', models.BooleanField(blank=True, default=False)),
                ('mitigated_time', models.DateTimeField(blank=True, editable=False, null=True)),
                ('false_positive', models.BooleanField(blank=True, default=False)),
                ('out_of_scope', models.BooleanField(blank=True, default=False)),
                ('risk_accepted', models.BooleanField(blank=True, default=False)),
                ('endpoint', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='status_endpoint', to='dojo.endpoint')),
                ('finding', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='status_finding', to='dojo.finding')),
                ('mitigated_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='endpoint',
            name='endpoint_status',
            field=models.ManyToManyField(blank=True, related_name='endpoint_endpoint_status', to='dojo.Endpoint_Status'),
        ),
        migrations.AddField(
            model_name='finding',
            name='endpoint_status',
            field=models.ManyToManyField(blank=True, related_name='finding_endpoint_status', to='dojo.Endpoint_Status'),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='jira_minimum_severity',
            field=models.CharField(blank=True, choices=[('Critical', 'Critical'), ('High', 'High'), ('Medium', 'Medium'), ('Low', 'Low'), ('Info', 'Info')], default='Low', max_length=20, null=True),
        ),
        migrations.AddField(
            model_name='jira_conf',
            name='global_jira_sla_notification',
            field=models.BooleanField(default=True, help_text='This setting can be overidden at the Product level', verbose_name='Globally send SLA notifications as comment?'),
        ),
        migrations.AddField(
            model_name='notifications',
            name='sla_breach',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Get notified of upcoming SLA breaches', max_length=24, verbose_name='SLA breach'),
        ),
        migrations.AddField(
            model_name='jira_pkey',
            name='product_jira_sla_notification',
            field=models.BooleanField(blank=True, default=False, verbose_name='Send SLA notifications as comment?'),
        ),
        migrations.AlterField(
            model_name='engagement',
            name='deduplication_on_engagement',
            field=models.BooleanField(default=False, help_text='If enabled deduplication will only mark a finding in this engagement as duplicate of another finding if both findings are in this engagement. If disabled, deduplication is on the product level.', verbose_name='Deduplication within this engagement only'),
        ),
        migrations.AlterField(
            model_name='regulation',
            name='category',
            field=models.CharField(choices=[('privacy', 'Privacy'), ('finance', 'Finance'), ('education', 'Education'), ('medical', 'Medical'), ('corporate', 'Corporate'), ('other', 'Other')], help_text='The subject of the regulation.', max_length=9),
        ),
        migrations.AlterField(
            model_name='regulation',
            name='name',
            field=models.CharField(help_text='The name of the regulation.', max_length=128, unique=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='cvssv3',
            field=models.TextField(max_length=117, null=True, validators=[django.core.validators.RegexValidator(message="CVSS must be entered in format: 'AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H'", regex='^AV:[NALP]|AC:[LH]|PR:[UNLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]')]),
        ),
        migrations.AddField(
            model_name='finding_template',
            name='cvssv3',
            field=models.TextField(max_length=117, null=True, validators=[django.core.validators.RegexValidator(message="CVSS must be entered in format: 'AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H'", regex='^AV:[NALP]|AC:[LH]|PR:[UNLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]')]),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AddField(
            model_name='engagement',
            name='notes',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.Notes'),
        ),
        migrations.AddField(
            model_name='dojometa',
            name='finding',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='finding_meta', to='dojo.finding'),
        ),
        migrations.AlterUniqueTogether(
            name='dojometa',
            unique_together={('product', 'name'), ('finding', 'name'), ('endpoint', 'name')},
        ),
        migrations.AlterField(
            model_name='notifications',
            name='jira_update',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('hipchat', 'hipchat'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='JIRA sync happens in the background, errors will be shown as notifications/alerts so make sure to subscribe', max_length=24, verbose_name='JIRA problems'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['component_name'], name='dojo_findin_compone_920323_idx'),
        ),
        migrations.RemoveField(
            model_name='system_settings',
            name='enable_hipchat_notifications',
        ),
        migrations.RemoveField(
            model_name='system_settings',
            name='hipchat_channel',
        ),
        migrations.RemoveField(
            model_name='system_settings',
            name='hipchat_site',
        ),
        migrations.RemoveField(
            model_name='system_settings',
            name='hipchat_token',
        ),
        migrations.RemoveField(
            model_name='usercontactinfo',
            name='hipchat_username',
        ),
        migrations.AddField(
            model_name='system_settings',
            name='enable_msteams_notifications',
            field=models.BooleanField(default=False, verbose_name='Enable Microsoft Teams notifications'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='msteams_url',
            field=models.CharField(blank=True, default='', help_text='The full URL of the incoming webhook', max_length=400),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='auto_close_engagement',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='code_review',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='engagement_added',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='jira_update',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='JIRA sync happens in the background, errors will be shown as notifications/alerts so make sure to subscribe', max_length=24, verbose_name='JIRA problems'),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='other',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='jira_update',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='JIRA sync happens in the background, errors will be shown as notifications/alerts so make sure to subscribe', max_length=24, verbose_name='JIRA problems'),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='product_added',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='report_created',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='review_requested',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='scan_added',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Triggered whenever an (re-)import has been done that created/updated/closed findings.', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='sla_breach',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Get notified of upcoming SLA breaches', max_length=24, verbose_name='SLA breach'),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='stale_engagement',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='test_added',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='upcoming_engagement',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='user_mentioned',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AlterField(
            model_name='finding',
            name='active',
            field=models.BooleanField(default=True, help_text='Denotes if this flaw is active or not.', verbose_name='Active'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='component_name',
            field=models.CharField(blank=True, help_text='Name of the affected component (library name, part of a system, ...).', max_length=200, null=True, verbose_name='Component name'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='component_version',
            field=models.CharField(blank=True, help_text='Version of the affected component.', max_length=100, null=True, verbose_name='Component version'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='created',
            field=models.DateTimeField(auto_now_add=True, help_text='The date the finding was created inside DefectDojo.', null=True, verbose_name='Created'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='cve',
            field=models.CharField(help_text='The Common Vulnerabilities and Exposures (CVE) associated with this flaw.', max_length=28, null=True, validators=[django.core.validators.RegexValidator(message="Vulnerability ID must be entered in the format: 'ABC-9999-9999'.", regex='^[A-Z]{1,10}(-\\d+)+$')], verbose_name='CVE'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='cvssv3',
            field=models.TextField(help_text='Common Vulnerability Scoring System version 3 (CVSSv3) score associated with this flaw.', max_length=117, null=True, validators=[django.core.validators.RegexValidator(message="CVSS must be entered in format: 'AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H'", regex='^AV:[NALP]|AC:[LH]|PR:[UNLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]')], verbose_name='CVSSv3'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='cwe',
            field=models.IntegerField(blank=True, default=0, help_text='The CWE number associated with this flaw.', null=True, verbose_name='CWE'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='date',
            field=models.DateField(default=dojo.models.get_current_date, help_text='The date the flaw was discovered.', verbose_name='Date'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='defect_review_requested_by',
            field=models.ForeignKey(blank=True, help_text='Documents who requested a defect review for this flaw.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='defect_review_requested_by', to='dojo.dojo_user', verbose_name='Defect Review Requested By'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='description',
            field=models.TextField(help_text='Longer more descriptive information about the flaw.', verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='duplicate',
            field=models.BooleanField(default=False, help_text='Denotes if this flaw is a duplicate of other flaws reported.', verbose_name='Duplicate'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='duplicate_finding',
            field=models.ForeignKey(blank=True, editable=False, help_text='Link to the original finding if this finding is a duplicate.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='original_finding', to='dojo.finding', verbose_name='Duplicate Finding'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='dynamic_finding',
            field=models.BooleanField(default=True, help_text='Flaw has been detected from a Dynamic Application Security Testing tool (DAST).', verbose_name='Dynamic finding (DAST)'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='endpoint_status',
            field=models.ManyToManyField(blank=True, help_text='The status of the endpoint associated with this flaw (Vulnerable, Mitigated, ...).', related_name='finding_endpoint_status', to='dojo.Endpoint_Status', verbose_name='Endpoint Status'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='endpoints',
            field=models.ManyToManyField(blank=True, help_text='The hosts within the product that are susceptible to this flaw.', to='dojo.Endpoint', verbose_name='Endpoints'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='false_p',
            field=models.BooleanField(default=False, help_text='Denotes if this flaw has been deemed a false positive by the tester.', verbose_name='False Positive'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='file_path',
            field=models.CharField(blank=True, help_text='Identified file(s) containing the flaw.', max_length=4000, null=True, verbose_name='File path'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='found_by',
            field=models.ManyToManyField(editable=False, help_text='The name of the scanner that identified the flaw.', to='dojo.Test_Type', verbose_name='Found by'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='hash_code',
            field=models.CharField(blank=True, editable=False, help_text='A hash over a configurable set of fields that is used for findings deduplication.', max_length=64, null=True, verbose_name='Hash Code'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='images',
            field=models.ManyToManyField(blank=True, help_text='Image(s) / Screenshot(s) related to the flaw.', to='dojo.FindingImage', verbose_name='Images'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='impact',
            field=models.TextField(help_text='Text describing the impact this flaw has on systems, products, enterprise, etc.', verbose_name='Impact'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='is_Mitigated',
            field=models.BooleanField(default=False, help_text='Denotes if this flaw has been fixed.', verbose_name='Is Mitigated'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='is_template',
            field=models.BooleanField(default=False, help_text='Denotes if this finding is a template and can be reused.', verbose_name='Is Template'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='jira_change',
            field=models.DateTimeField(help_text='The date the linked Jira issue was last modified.', null=True, verbose_name='Jira change'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='jira_creation',
            field=models.DateTimeField(help_text='The date a Jira issue was created from this finding.', null=True, verbose_name='Jira creation'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='last_reviewed',
            field=models.DateTimeField(editable=False, help_text="Provides the date the flaw was last 'touched' by a tester.", null=True, verbose_name='Last Reviewed'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='last_reviewed_by',
            field=models.ForeignKey(editable=False, help_text='Provides the person who last reviewed the flaw.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='last_reviewed_by', to=settings.AUTH_USER_MODEL, verbose_name='Last Reviewed By'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='line',
            field=models.IntegerField(blank=True, help_text='Source line number of the attack vector.', null=True, verbose_name='Line number'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='line_number',
            field=models.CharField(blank=True, editable=False, help_text='Deprecated will be removed, use line', max_length=200, null=True, verbose_name='Line Number'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='mitigated',
            field=models.DateTimeField(blank=True, editable=False, help_text='Denotes if this flaw has been fixed by storing the date it was fixed.', null=True, verbose_name='Mitigated'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='mitigated_by',
            field=models.ForeignKey(editable=False, help_text='Documents who has marked this flaw as fixed.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='mitigated_by', to=settings.AUTH_USER_MODEL, verbose_name='Mitigated By'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='mitigation',
            field=models.TextField(help_text='Text describing how to best fix the flaw.', verbose_name='Mitigation'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='nb_occurences',
            field=models.IntegerField(blank=True, help_text='Number of occurences in the source tool when several vulnerabilites were found and aggregated by the scanner.', null=True, verbose_name='Number of occurences'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='notes',
            field=models.ManyToManyField(blank=True, editable=False, help_text='Stores information pertinent to the flaw or the mitigation.', to='dojo.Notes', verbose_name='Notes'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='numerical_severity',
            field=models.CharField(help_text='The numerical representation of the severity (S0, S1, S2, S3, S4).', max_length=4, verbose_name='Numerical Severity'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='out_of_scope',
            field=models.BooleanField(default=False, help_text='Denotes if this flaw falls outside the scope of the test and/or engagement.', verbose_name='Out Of Scope'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='param',
            field=models.TextField(blank=True, editable=False, help_text='Parameter used to trigger the issue (DAST).', null=True, verbose_name='Parameter'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='payload',
            field=models.TextField(blank=True, editable=False, help_text='Payload used to attack the service / application and trigger the bug / problem.', null=True, verbose_name='Payload'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='references',
            field=models.TextField(blank=True, db_column='refs', help_text='The external documentation available for this flaw.', null=True, verbose_name='References'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='reporter',
            field=models.ForeignKey(default=1, editable=False, help_text='Documents who reported the flaw.', on_delete=django.db.models.deletion.CASCADE, related_name='reporter', to=settings.AUTH_USER_MODEL, verbose_name='Reporter'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='review_requested_by',
            field=models.ForeignKey(blank=True, help_text='Documents who requested a review for this finding.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='review_requested_by', to='dojo.dojo_user', verbose_name='Review Requested By'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='reviewers',
            field=models.ManyToManyField(blank=True, help_text='Documents who reviewed the flaw.', to=settings.AUTH_USER_MODEL, verbose_name='Reviewers'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='sast_sink_object',
            field=models.CharField(blank=True, help_text='Sink object (variable, function...) of the attack vector.', max_length=500, null=True, verbose_name='SAST Sink Object'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='sast_source_file_path',
            field=models.CharField(blank=True, help_text='Source file path of the attack vector.', max_length=4000, null=True, verbose_name='SAST Source File Path'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='sast_source_line',
            field=models.IntegerField(blank=True, help_text='Source line number of the attack vector.', null=True, verbose_name='SAST Source Line number'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='sast_source_object',
            field=models.CharField(blank=True, help_text='Source object (variable, function...) of the attack vector.', max_length=500, null=True, verbose_name='SAST Source Object'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='scanner_confidence',
            field=models.IntegerField(blank=True, default=None, editable=False, help_text='Confidence level of vulnerability which is supplied by the scanner.', null=True, verbose_name='Scanner confidence'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='severity',
            field=models.CharField(help_text='The severity level of this flaw (Critical, High, Medium, Low, Informational).', max_length=200, verbose_name='Severity'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='severity_justification',
            field=models.TextField(blank=True, help_text='Text describing why a certain severity was associated with this flaw.', null=True, verbose_name='Severity Justification'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='sonarqube_issue',
            field=models.ForeignKey(blank=True, help_text='The SonarQube issue associated with this finding.', null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.sonarqube_issue', verbose_name='SonarQube issue'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='sourcefile',
            field=models.TextField(blank=True, editable=False, help_text='Name of the source code file in which the flaw is located.', null=True, verbose_name='Source File'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='sourcefilepath',
            field=models.TextField(blank=True, editable=False, help_text='Filepath of the source code file in which the flaw is located.', null=True, verbose_name='Source File Path'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='static_finding',
            field=models.BooleanField(default=False, help_text='Flaw has been detected from a Static Application Security Testing tool (SAST).', verbose_name='Static finding (SAST)'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='steps_to_reproduce',
            field=models.TextField(blank=True, help_text='Text describing the steps that must be followed in order to reproduce the flaw / bug.', null=True, verbose_name='Steps to Reproduce'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='test',
            field=models.ForeignKey(editable=False, help_text='The test that is associated with this flaw.', on_delete=django.db.models.deletion.CASCADE, to='dojo.test', verbose_name='Test'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='thread_id',
            field=models.IntegerField(default=0, editable=False, verbose_name='Thread ID'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='title',
            field=models.CharField(help_text='A short description of the flaw.', max_length=511, verbose_name='Title'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='under_defect_review',
            field=models.BooleanField(default=False, help_text='Denotes if this finding is under defect review.', verbose_name='Under Defect Review'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='under_review',
            field=models.BooleanField(default=False, help_text='Denotes is this flaw is currently being reviewed.', verbose_name='Under Review'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='unique_id_from_tool',
            field=models.CharField(blank=True, help_text='Vulnerability technical id from the source tool. Allows to track unique vulnerabilities.', max_length=500, null=True, verbose_name='Unique ID from tool'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='url',
            field=models.TextField(blank=True, editable=False, help_text='External reference that provides more information about this flaw.', null=True, verbose_name='URL'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='verified',
            field=models.BooleanField(default=True, help_text='Denotes if this flaw has been manually verified by the tester.', verbose_name='Verified'),
        ),
        migrations.AddField(
            model_name='product_type',
            name='authorized_users',
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='false_positive_history',
            field=models.BooleanField(default=False, help_text='DefectDojo will automatically mark the finding as a false positive if the finding has been previously marked as a false positive. Not needed when using deduplication, advised to not combine these two.'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['duplicate'], name='dojo_findin_duplica_f60788_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['is_Mitigated'], name='dojo_findin_is_Miti_aaa533_idx'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='disable_jira_webhook_secret',
            field=models.BooleanField(default=False, help_text='Allows incoming requests without a secret (discouraged legacy behaviour)', verbose_name='Disable web hook secret'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='jira_webhook_secret',
            field=models.CharField(help_text='Secret needed in URL for incoming JIRA Webhook', max_length=64, null=True, verbose_name='JIRA Webhook URL'),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='enable_jira_web_hook',
            field=models.BooleanField(default=False, help_text='Please note: It is strongly recommended to use a secret below and / or IP whitelist the JIRA server using a proxy such as Nginx.', verbose_name='Enable JIRA web hook'),
        ),
        migrations.AddField(
            model_name='finding',
            name='vuln_id_from_tool',
            field=models.CharField(blank=True, help_text='Non-unique technical id from the source tool associated with the vulnerability type.', max_length=500, null=True, verbose_name='Vulnerability ID from tool'),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('jira_creation', 'jira_creation'), ('jira_change', 'jira_change'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.DeleteModel(
            name='JIRA_Clone',
        ),
        migrations.DeleteModel(
            name='JIRA_Details_Cache',
        ),
        migrations.RenameModel(
            old_name='JIRA_PKey',
            new_name='JIRA_Project',
        ),
        migrations.AddField(
            model_name='jira_issue',
            name='jira_change',
            field=models.DateTimeField(help_text='The date the linked Jira issue was last modified.', null=True, verbose_name='Jira last update'),
        ),
        migrations.AddField(
            model_name='jira_issue',
            name='jira_creation',
            field=models.DateTimeField(help_text='The date a Jira issue was created from this finding.', null=True, verbose_name='Jira creation'),
        ),
        migrations.RenameModel(
            old_name='JIRA_Conf',
            new_name='JIRA_Instance',
        ),
        migrations.RenameField(
            model_name='jira_project',
            old_name='conf',
            new_name='jira_instance',
        ),
        migrations.AddField(
            model_name='jira_issue',
            name='jira_project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='dojo.jira_project'),
        ),
        migrations.AddField(
            model_name='JIRA_Project',
            name='engagement',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.engagement'),
        ),
        migrations.AlterField(
            model_name='JIRA_Project',
            name='product',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.product'),
        ),
        migrations.AlterField(
            model_name='jira_project',
            name='jira_instance',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.jira_instance', verbose_name='JIRA Instance'),
        ),
        migrations.RemoveField(
            model_name='finding',
            name='jira_change',
        ),
        migrations.RemoveField(
            model_name='finding',
            name='jira_creation',
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AddField(
            model_name='app_analysis',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.AddField(
            model_name='finding',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.AddField(
            model_name='objects',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.AddField(
            model_name='test',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.AddField(
            model_name='product',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.AddField(
            model_name='finding_template',
            name='tags_from_django_tagging',
            field=models.TextField(blank=True, editable=False, help_text='Temporary archive with tags from the previous tagging library we used'),
        ),
        migrations.RenameModel(
            old_name='Objects',
            new_name='Objects_Product',
        ),
        migrations.CreateModel(
            name='Tagulous_Test_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Product_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Finding_Template_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Finding_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Engagement_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Endpoint_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_App_Analysis_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.CreateModel(
            name='Tagulous_Objects_Product_tags',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('slug', models.SlugField()),
                ('count', models.IntegerField(default=0, help_text='Internal counter of how many times this tag is in use')),
                ('protected', models.BooleanField(default=False, help_text='Will not be deleted when the count reaches 0')),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
                'unique_together': {('slug',)},
            },
            bases=(tagulous.models.models.BaseTagModel, models.Model),
        ),
        migrations.AddField(
            model_name='app_analysis',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Enter a comma-separated tag string', to='dojo.Tagulous_App_Analysis_tags'),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Add tags that help describe this endpoint. Choose from the list or add new tags. Press Enter key to add.', to='dojo.Tagulous_Endpoint_tags'),
        ),
        migrations.AddField(
            model_name='engagement',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Add tags that help describe this engagement. Choose from the list or add new tags. Press Enter key to add.', to='dojo.Tagulous_Engagement_tags'),
        ),
        migrations.AddField(
            model_name='finding',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Add tags that help describe this finding. Choose from the list or add new tags. Press Enter key to add.', to='dojo.Tagulous_Finding_tags'),
        ),
        migrations.AddField(
            model_name='finding_template',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Add tags that help describe this finding template. Choose from the list or add new tags. Press Enter key to add.', to='dojo.Tagulous_Finding_Template_tags'),
        ),
        migrations.AddField(
            model_name='objects_product',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Add tags that help describe this object. Choose from the list or add new tags. Press Enter key to add.', to='dojo.Tagulous_Objects_Product_tags'),
        ),
        migrations.AddField(
            model_name='product',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Add tags that help describe this product. Choose from the list or add new tags. Press Enter key to add.', to='dojo.Tagulous_Product_tags'),
        ),
        migrations.AddField(
            model_name='test',
            name='tags',
            field=tagulous.models.fields.TagField(_set_tag_meta=True, blank=True, force_lowercase=True, help_text='Add tags that help describe this test. Choose from the list or add new tags. Press Enter key to add.', to='dojo.Tagulous_Test_tags'),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='delete_dupulicates',
            field=models.BooleanField(default=False, help_text='Requires next setting: maximum number of duplicates to retain.'),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='max_dupes',
            field=models.IntegerField(blank=True, default=10, help_text='When enabled, if a single issue reaches the maximum number of duplicates, the oldest will be deleted. Duplicate will not be deleted when left empty. A value of 0 will remove all duplicates.', null=True, verbose_name='Max Duplicates'),
        ),
        migrations.CreateModel(
            name='FileUpload',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100, unique=True)),
                ('file', models.FileField(upload_to=dojo.models.UniqueUploadNameProvider('uploaded_files'))),
            ],
        ),
        migrations.AddField(
            model_name='engagement',
            name='files',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.FileUpload'),
        ),
        migrations.AddField(
            model_name='finding',
            name='files',
            field=models.ManyToManyField(blank=True, editable=False, help_text='Files(s) related to the flaw.', to='dojo.FileUpload', verbose_name='Files'),
        ),
        migrations.AddField(
            model_name='test',
            name='files',
            field=models.ManyToManyField(blank=True, editable=False, to='dojo.FileUpload'),
        ),
        migrations.AddField(
            model_name='finding',
            name='risk_accepted',
            field=models.BooleanField(default=False, help_text='Denotes if this finding has been marked as an accepted risk.', verbose_name='Risk Accepted'),
        ),
        migrations.RemoveField(
            model_name='engagement',
            name='risk_path',
        ),
        migrations.RemoveField(
            model_name='risk_acceptance',
            name='compensating_control',
        ),
        migrations.AddField(
            model_name='finding',
            name='sla_start_date',
            field=models.DateField(blank=True, help_text="(readonly)The date used as start date for SLA calculation. Set by expiring risk acceptances. Empty by default, causing a fallback to 'date'.", null=True, verbose_name='SLA Start Date'),
        ),
        migrations.AddField(
            model_name='jira_project',
            name='risk_acceptance_expiration_notification',
            field=models.BooleanField(blank=True, default=False, verbose_name='Send Risk Acceptance expiration notifications as comment?'),
        ),
        migrations.AddField(
            model_name='notifications',
            name='risk_acceptance_expiration',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Get notified of (upcoming) Risk Acceptance expiries', max_length=24, verbose_name='Risk Acceptance Expiration'),
        ),
        migrations.AddField(
            model_name='product',
            name='enable_full_risk_acceptance',
            field=models.BooleanField(default=True, help_text='Allows full risk acceptance using a risk acceptance form, expiration date, uploaded proof, etc.'),
        ),
        migrations.AddField(
            model_name='product',
            name='enable_simple_risk_acceptance',
            field=models.BooleanField(default=False, help_text='Allows simple risk acceptance by checking/unchecking a checkbox.'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='decision',
            field=models.CharField(choices=[('A', 'Accept (The risk is acknowledged, yet remains)'), ('V', 'Avoid (Do not engage with whatever creates the risk)'), ('M', 'Mitigate (The risk still exists, yet compensating controls make it less of a threat)'), ('F', 'Fix (The risk is eradicated)'), ('T', 'Transfer (The risk is transferred to a 3rd party)')], default='A', help_text='Risk treatment decision by risk owner', max_length=2),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='decision_details',
            field=models.TextField(blank=True, default=None, help_text='If a compensating control exists to mitigate the finding or reduce risk, then list the compensating control(s).', null=True),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='expiration_date_handled',
            field=models.DateTimeField(blank=True, default=None, help_text='(readonly) When the risk acceptance expiration was handled (manually or by the daily job).', null=True),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='expiration_date_warned',
            field=models.DateTimeField(blank=True, default=None, help_text='(readonly) Date at which notice about the risk acceptance expiration was sent.', null=True),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='reactivate_expired',
            field=models.BooleanField(default=True, help_text='Reactivate findings when risk acceptance expires?', verbose_name='Reactivate findings on expiration'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='recommendation',
            field=models.CharField(choices=[('A', 'Accept (The risk is acknowledged, yet remains)'), ('V', 'Avoid (Do not engage with whatever creates the risk)'), ('M', 'Mitigate (The risk still exists, yet compensating controls make it less of a threat)'), ('F', 'Fix (The risk is eradicated)'), ('T', 'Transfer (The risk is transferred to a 3rd party)')], default='F', help_text='Recommendation from the security team.', max_length=2, verbose_name='Security Recommendation'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='recommendation_details',
            field=models.TextField(blank=True, help_text='Explanation of security recommendation', null=True, verbose_name='Security Recommendation Details'),
        ),
        migrations.AddField(
            model_name='risk_acceptance',
            name='restart_sla_expired',
            field=models.BooleanField(default=False, help_text='When enabled, the SLA for findings is restarted when the risk acceptance expires.', verbose_name='Restart SLA on expiration'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='risk_acceptance_form_default_days',
            field=models.IntegerField(blank=True, default=180, help_text='Default expiry period for risk acceptance form.', null=True),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='risk_acceptance_notify_before_expiration',
            field=models.IntegerField(blank=True, default=10, help_text='Notify X days before risk acceptance expires. Leave empty to disable.', null=True, verbose_name='Risk acceptance expiration heads up days'),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='notifications',
            name='sla_breach',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', help_text='Get notified of (upcoming) SLA breaches', max_length=24, verbose_name='SLA breach'),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='accepted_by',
            field=models.CharField(blank=True, default=None, help_text='The person that accepts the risk, can be outside of DefectDojo.', max_length=200, null=True, verbose_name='Accepted By'),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='expiration_date',
            field=models.DateTimeField(blank=True, default=None, help_text='When the risk acceptance expires, the findings will be reactivated (unless disabled below).', null=True),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='owner',
            field=models.ForeignKey(help_text='User in DefectDojo owning this acceptance. Only the owner and staff users can edit the risk acceptance.', on_delete=django.db.models.deletion.CASCADE, to='dojo.dojo_user'),
        ),
        migrations.AlterField(
            model_name='risk_acceptance',
            name='path',
            field=models.FileField(blank=True, null=True, upload_to='risk/%Y/%m/%d', verbose_name='Proof'),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences')], max_length=200),
        ),
        migrations.AlterField(
            model_name='alerts',
            name='title',
            field=models.CharField(default='', max_length=250),
        ),
        migrations.AddField(
            model_name='product_type',
            name='description',
            field=models.CharField(max_length=4000, null=True),
        ),
        migrations.AddField(
            model_name='notifications',
            name='product_type_added',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'active', 'verified'], name='dojo_findin_test_id_bfc47c_idx'),
        ),
        migrations.AddIndex(
            model_name='endpoint',
            index=models.Index(fields=['product', 'mitigated'], name='dojo_endpoi_product_b80e9a_idx'),
        ),
        migrations.AddIndex(
            model_name='endpoint_status',
            index=models.Index(fields=['finding', 'mitigated'], name='dojo_endpoi_finding_0fa5ce_idx'),
        ),
        migrations.AddIndex(
            model_name='endpoint_status',
            index=models.Index(fields=['endpoint', 'mitigated'], name='dojo_endpoi_endpoin_d85400_idx'),
        ),
        migrations.AddIndex(
            model_name='engagement',
            index=models.Index(fields=['product', 'active'], name='dojo_engage_product_16b039_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'is_Mitigated'], name='dojo_findin_test_id_afee7e_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'duplicate'], name='dojo_findin_test_id_52d78d_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'out_of_scope'], name='dojo_findin_test_id_742a6f_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'false_p'], name='dojo_findin_test_id_188e8a_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'unique_id_from_tool', 'duplicate'], name='dojo_findin_test_id_269acb_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'hash_code', 'duplicate'], name='dojo_findin_test_id_e54563_idx'),
        ),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['test', 'component_name'], name='dojo_findin_test_id_396336_idx'),
        ),
        migrations.AddIndex(
            model_name='notifications',
            index=models.Index(fields=['user', 'product'], name='dojo_notifi_user_id_575989_idx'),
        ),
        migrations.AddIndex(
            model_name='test',
            index=models.Index(fields=['engagement', 'test_type'], name='dojo_test_engagem_bb6b41_idx'),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='column_widths',
            field=models.TextField(blank=True, max_length=1500),
        ),
        migrations.AlterField(
            model_name='system_settings',
            name='credentials',
            field=models.TextField(blank=True, max_length=3000),
        ),
        migrations.AddField(
            model_name='notifications',
            name='close_engagement',
            field=multiselectfield.db.fields.MultiSelectField(blank=True, choices=[('slack', 'slack'), ('msteams', 'msteams'), ('mail', 'mail'), ('alert', 'alert')], default='alert', max_length=24),
        ),
        migrations.CreateModel(
            name='Test_Import',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('import_settings', models.JSONField(null=True)),
                ('version', models.CharField(blank=True, max_length=100, null=True)),
                ('type', models.CharField(default='unknown', max_length=64)),
            ],
            options={
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='Test_Import_Finding_Action',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('action', models.CharField(blank=True, choices=[('N', 'created'), ('C', 'closed'), ('R', 'reactivated'), ('U', 'updated')], max_length=100, null=True)),
                ('finding', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.finding')),
                ('test_import', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.test_import')),
            ],
            options={
                'ordering': ('test_import', 'action', 'finding'),
                'unique_together': {('test_import', 'finding')},
            },
        ),
        migrations.AddField(
            model_name='test_import',
            name='findings_affected',
            field=models.ManyToManyField(through='dojo.Test_Import_Finding_Action', to='dojo.Finding'),
        ),
        migrations.AddField(
            model_name='test_import',
            name='test',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='dojo.test'),
        ),
        migrations.AddIndex(
            model_name='test_import',
            index=models.Index(fields=['created', 'test', 'type'], name='dojo_test_i_created_951f4e_idx'),
        ),
        migrations.CreateModel(
            name='Product_Type_Member',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.IntegerField(default=0)),
                ('product_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product_type')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Product_Member',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.IntegerField(default=0)),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.product')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='product',
            name='members',
            field=models.ManyToManyField(blank=True, related_name='product_members', through='dojo.Product_Member', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='product_type',
            name='members',
            field=models.ManyToManyField(blank=True, related_name='prod_type_members', through='dojo.Product_Type_Member', to=settings.AUTH_USER_MODEL),
        ),
        migrations.RenameField(
            model_name='system_settings',
            old_name='delete_dupulicates',
            new_name='delete_duplicates',
        ),
        migrations.AlterField(
            model_name='finding',
            name='cvssv3',
            field=models.TextField(help_text='Common Vulnerability Scoring System version 3 (CVSSv3) score associated with this flaw.', max_length=117, null=True, validators=[django.core.validators.RegexValidator(message="CVSS must be entered in format: 'AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H'", regex='^AV:[NALP]|AC:[LH]|PR:[UNLH]|UI:[NR]|S:[UC]|[CIA]:[NLH]')], verbose_name='CVSS v3'),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='disclaimer',
            field=models.TextField(blank=True, default='', help_text='Include this custom disclaimer on all notifications and generated reports', max_length=3000, verbose_name='Custom Disclaimer'),
        ),
        migrations.AddField(
            model_name='jira_instance',
            name='issue_template',
            field=models.CharField(blank=True, help_text='Choose the folder containing the Django templates used to render the JIRA issue description. These are stored in dojo/templates/issue-trackers. Leave empty to use the default jira_full templates.', max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='jira_project',
            name='issue_template',
            field=models.CharField(blank=True, help_text='Choose the folder containing the Django templates used to render the JIRA issue description. These are stored in dojo/templates/issue-trackers. Leave empty to use the default jira_full templates.', max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='last_status_update',
            field=models.DateTimeField(auto_now_add=True, help_text='Timestamp of latest status update (change in status related fields).', null=True, verbose_name='Last Status Update'),
        ),
        migrations.RemoveField(
            model_name='scan',
            name='scan_settings',
        ),
        migrations.RemoveField(
            model_name='scansettings',
            name='product',
        ),
        migrations.RemoveField(
            model_name='scansettings',
            name='user',
        ),
        migrations.RemoveField(
            model_name='va',
            name='result',
        ),
        migrations.RemoveField(
            model_name='va',
            name='user',
        ),
        migrations.DeleteModel(
            name='IPScan',
        ),
        migrations.DeleteModel(
            name='Scan',
        ),
        migrations.DeleteModel(
            name='ScanSettings',
        ),
        migrations.DeleteModel(
            name='VA',
        ),
        migrations.AddField(
            model_name='tool_configuration',
            name='extras',
            field=models.CharField(blank=True, help_text='Additional definitions that will be consumed by scanner', max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='finding',
            name='cvssv3_score',
            field=models.FloatField(blank=True, help_text='Numerical CVSSv3 score for the vulnerability. If the vector is given, the score is updated while saving the finding', null=True, verbose_name='CVSSv3 score'),
        ),
        migrations.AddField(
            model_name='finding',
            name='publish_date',
            field=models.DateTimeField(blank=True, help_text='Date when this vulnerability was made publicly available.', null=True, verbose_name='Publish date'),
        ),
        migrations.AlterField(
            model_name='child_rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('cvssv3_score', 'cvssv3_score'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences'), ('publish_date', 'publish_date')], max_length=200),
        ),
        migrations.AlterField(
            model_name='finding',
            name='impact',
            field=models.TextField(blank=True, help_text='Text describing the impact this flaw has on systems, products, enterprise, etc.', null=True, verbose_name='Impact'),
        ),
        migrations.AlterField(
            model_name='finding',
            name='mitigation',
            field=models.TextField(blank=True, help_text='Text describing how to best fix the flaw.', null=True, verbose_name='Mitigation'),
        ),
        migrations.AlterField(
            model_name='rule',
            name='applied_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('cvssv3_score', 'cvssv3_score'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences'), ('publish_date', 'publish_date')], max_length=200),
        ),
        migrations.AlterField(
            model_name='rule',
            name='match_field',
            field=models.CharField(choices=[('id', 'id'), ('title', 'title'), ('date', 'date'), ('sla_start_date', 'sla_start_date'), ('cwe', 'cwe'), ('cve', 'cve'), ('cvssv3', 'cvssv3'), ('cvssv3_score', 'cvssv3_score'), ('url', 'url'), ('severity', 'severity'), ('description', 'description'), ('mitigation', 'mitigation'), ('impact', 'impact'), ('steps_to_reproduce', 'steps_to_reproduce'), ('severity_justification', 'severity_justification'), ('references', 'references'), ('test', 'test'), ('is_template', 'is_template'), ('active', 'active'), ('verified', 'verified'), ('false_p', 'false_p'), ('duplicate', 'duplicate'), ('duplicate_finding', 'duplicate_finding'), ('out_of_scope', 'out_of_scope'), ('risk_accepted', 'risk_accepted'), ('under_review', 'under_review'), ('review_requested_by', 'review_requested_by'), ('under_defect_review', 'under_defect_review'), ('defect_review_requested_by', 'defect_review_requested_by'), ('is_Mitigated', 'is_Mitigated'), ('thread_id', 'thread_id'), ('mitigated', 'mitigated'), ('mitigated_by', 'mitigated_by'), ('reporter', 'reporter'), ('numerical_severity', 'numerical_severity'), ('last_reviewed', 'last_reviewed'), ('last_reviewed_by', 'last_reviewed_by'), ('line_number', 'line_number'), ('sourcefilepath', 'sourcefilepath'), ('sourcefile', 'sourcefile'), ('param', 'param'), ('payload', 'payload'), ('hash_code', 'hash_code'), ('line', 'line'), ('file_path', 'file_path'), ('component_name', 'component_name'), ('component_version', 'component_version'), ('static_finding', 'static_finding'), ('dynamic_finding', 'dynamic_finding'), ('created', 'created'), ('scanner_confidence', 'scanner_confidence'), ('sonarqube_issue', 'sonarqube_issue'), ('unique_id_from_tool', 'unique_id_from_tool'), ('vuln_id_from_tool', 'vuln_id_from_tool'), ('sast_source_object', 'sast_source_object'), ('sast_sink_object', 'sast_sink_object'), ('sast_source_line', 'sast_source_line'), ('sast_source_file_path', 'sast_source_file_path'), ('nb_occurences', 'nb_occurences'), ('publish_date', 'publish_date')], max_length=200),
        ),
        migrations.RenameField(
            model_name='jira_instance',
            old_name='issue_template',
            new_name='issue_template_dir',
        ),
        migrations.RenameField(
            model_name='jira_project',
            old_name='issue_template',
            new_name='issue_template_dir',
        ),
        migrations.CreateModel(
            name='Finding_Group',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('name', models.CharField(max_length=255)),
                ('creator', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.dojo_user')),
                ('findings', models.ManyToManyField(to='dojo.Finding')),
                ('test', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dojo.test')),
            ],
            options={
                'ordering': ['id'],
            },
        ),
        migrations.AddField(
            model_name='jira_issue',
            name='finding_group',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.finding_group'),
        ),
        migrations.AlterField(
            model_name='jira_issue',
            name='jira_project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='dojo.jira_project'),
        ),
        migrations.AlterField(
            model_name='jira_project',
            name='jira_instance',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='dojo.jira_instance', verbose_name='JIRA Instance'),
        ),
        migrations.AddField(
            model_name='test',
            name='branch_tag',
            field=models.CharField(blank=True, help_text='Tag or branch that was tested, a reimport may update this field.', max_length=150, null=True, verbose_name='Branch/Tag'),
        ),
        migrations.AddField(
            model_name='test',
            name='build_id',
            field=models.CharField(blank=True, help_text='Build ID that was tested, a reimport may update this field.', max_length=150, null=True, verbose_name='Build ID'),
        ),
        migrations.AddField(
            model_name='test',
            name='commit_hash',
            field=models.CharField(blank=True, help_text='Commit hash tested, a reimport may update this field.', max_length=150, null=True, verbose_name='Commit Hash'),
        ),
        migrations.AddField(
            model_name='test_import',
            name='branch_tag',
            field=models.CharField(blank=True, help_text='Tag or branch that was tested, a reimport may update this field.', max_length=150, null=True, verbose_name='Branch/Tag'),
        ),
        migrations.AddField(
            model_name='test_import',
            name='build_id',
            field=models.CharField(blank=True, help_text='Build ID that was tested, a reimport may update this field.', max_length=150, null=True, verbose_name='Build ID'),
        ),
        migrations.AddField(
            model_name='test_import',
            name='commit_hash',
            field=models.CharField(blank=True, help_text='Commit hash tested, a reimport may update this field.', max_length=150, null=True, verbose_name='Commit Hash'),
        ),
        migrations.AlterField(
            model_name='jira_issue',
            name='jira_project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='dojo.jira_project'),
        ),
        migrations.RunPython(log_me_0090),
        migrations.AddIndex(
            model_name='finding',
            index=models.Index(fields=['duplicate_finding', 'id'], name='dojo_findin_duplica_94e6c5_idx'),
        ),
    ]
