// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file aliases.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__ALIASES_HPP
#define FAST_DDS_GENERATED__ALIASES_HPP

#include <array>
#include <cstdint>
#include <map>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(ALIASES_SOURCE)
#define ALIASES_DllAPI __declspec( dllexport )
#else
#define ALIASES_DllAPI __declspec( dllimport )
#endif // ALIASES_SOURCE
#else
#define ALIASES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define ALIASES_DllAPI
#endif // _WIN32

typedef int16_t alias_int16;

typedef uint16_t alias_uint16;

typedef int32_t alias_int32;

typedef uint32_t alias_uint32;

typedef int64_t alias_int64;

typedef uint64_t alias_uint64;

typedef float alias_float32;

typedef double alias_float64;

typedef long double alias_float128;

typedef bool alias_bool;

typedef uint8_t alias_octet;

typedef char alias_char8;

typedef wchar_t alias_char16;

typedef std::string alias_string8;

typedef std::wstring alias_string16;

typedef InnerEnumHelper alias_enum;

typedef InnerBitMaskHelper alias_bitmask;

typedef InnerAliasHelper alias_alias;

typedef std::array<int16_t, 2> alias_array;

typedef std::array<std::array<int16_t, 2>, 2> alias_multiarray;

typedef std::vector<int16_t> alias_sequence;

typedef std::map<int16_t, int16_t> alias_map;

typedef InnerUnionHelper alias_union;

typedef InnerStructureHelper alias_structure;

typedef InnerBitsetHelper alias_bitset;

/*!
 * @brief This class represents the structure AliasInt16 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasInt16
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasInt16()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasInt16()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasInt16 that will be copied.
     */
    eProsima_user_DllExport AliasInt16(
            const AliasInt16& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasInt16 that will be copied.
     */
    eProsima_user_DllExport AliasInt16(
            AliasInt16&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasInt16 that will be copied.
     */
    eProsima_user_DllExport AliasInt16& operator =(
            const AliasInt16& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasInt16 that will be copied.
     */
    eProsima_user_DllExport AliasInt16& operator =(
            AliasInt16&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasInt16 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasInt16& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasInt16 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasInt16& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_int16 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_int16 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_int16& value()
    {
        return m_value;
    }



private:

    alias_int16 m_value{0};

};
/*!
 * @brief This class represents the structure AliasUint16 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasUint16
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasUint16()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasUint16()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasUint16 that will be copied.
     */
    eProsima_user_DllExport AliasUint16(
            const AliasUint16& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasUint16 that will be copied.
     */
    eProsima_user_DllExport AliasUint16(
            AliasUint16&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasUint16 that will be copied.
     */
    eProsima_user_DllExport AliasUint16& operator =(
            const AliasUint16& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasUint16 that will be copied.
     */
    eProsima_user_DllExport AliasUint16& operator =(
            AliasUint16&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUint16 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasUint16& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUint16 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasUint16& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_uint16 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_uint16 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_uint16& value()
    {
        return m_value;
    }



private:

    alias_uint16 m_value{0};

};
/*!
 * @brief This class represents the structure AliasInt32 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasInt32
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasInt32()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasInt32()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasInt32 that will be copied.
     */
    eProsima_user_DllExport AliasInt32(
            const AliasInt32& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasInt32 that will be copied.
     */
    eProsima_user_DllExport AliasInt32(
            AliasInt32&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasInt32 that will be copied.
     */
    eProsima_user_DllExport AliasInt32& operator =(
            const AliasInt32& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasInt32 that will be copied.
     */
    eProsima_user_DllExport AliasInt32& operator =(
            AliasInt32&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasInt32 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasInt32& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasInt32 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasInt32& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_int32 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_int32 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_int32& value()
    {
        return m_value;
    }



private:

    alias_int32 m_value{0};

};
/*!
 * @brief This class represents the structure AliasUInt32 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasUInt32
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasUInt32()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasUInt32()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasUInt32 that will be copied.
     */
    eProsima_user_DllExport AliasUInt32(
            const AliasUInt32& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasUInt32 that will be copied.
     */
    eProsima_user_DllExport AliasUInt32(
            AliasUInt32&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasUInt32 that will be copied.
     */
    eProsima_user_DllExport AliasUInt32& operator =(
            const AliasUInt32& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasUInt32 that will be copied.
     */
    eProsima_user_DllExport AliasUInt32& operator =(
            AliasUInt32&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUInt32 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasUInt32& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUInt32 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasUInt32& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_uint32 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_uint32 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_uint32& value()
    {
        return m_value;
    }



private:

    alias_uint32 m_value{0};

};
/*!
 * @brief This class represents the structure AliasInt64 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasInt64
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasInt64()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasInt64()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasInt64 that will be copied.
     */
    eProsima_user_DllExport AliasInt64(
            const AliasInt64& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasInt64 that will be copied.
     */
    eProsima_user_DllExport AliasInt64(
            AliasInt64&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasInt64 that will be copied.
     */
    eProsima_user_DllExport AliasInt64& operator =(
            const AliasInt64& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasInt64 that will be copied.
     */
    eProsima_user_DllExport AliasInt64& operator =(
            AliasInt64&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasInt64 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasInt64& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasInt64 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasInt64& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_int64 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_int64 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_int64& value()
    {
        return m_value;
    }



private:

    alias_int64 m_value{0};

};
/*!
 * @brief This class represents the structure AliasUInt64 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasUInt64
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasUInt64()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasUInt64()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasUInt64 that will be copied.
     */
    eProsima_user_DllExport AliasUInt64(
            const AliasUInt64& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasUInt64 that will be copied.
     */
    eProsima_user_DllExport AliasUInt64(
            AliasUInt64&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasUInt64 that will be copied.
     */
    eProsima_user_DllExport AliasUInt64& operator =(
            const AliasUInt64& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasUInt64 that will be copied.
     */
    eProsima_user_DllExport AliasUInt64& operator =(
            AliasUInt64&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUInt64 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasUInt64& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUInt64 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasUInt64& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_uint64 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_uint64 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_uint64& value()
    {
        return m_value;
    }



private:

    alias_uint64 m_value{0};

};
/*!
 * @brief This class represents the structure AliasFloat32 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasFloat32
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasFloat32()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasFloat32()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasFloat32 that will be copied.
     */
    eProsima_user_DllExport AliasFloat32(
            const AliasFloat32& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasFloat32 that will be copied.
     */
    eProsima_user_DllExport AliasFloat32(
            AliasFloat32&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasFloat32 that will be copied.
     */
    eProsima_user_DllExport AliasFloat32& operator =(
            const AliasFloat32& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasFloat32 that will be copied.
     */
    eProsima_user_DllExport AliasFloat32& operator =(
            AliasFloat32&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasFloat32 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasFloat32& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasFloat32 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasFloat32& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_float32 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_float32 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_float32& value()
    {
        return m_value;
    }



private:

    alias_float32 m_value{0.0};

};
/*!
 * @brief This class represents the structure AliasFloat64 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasFloat64
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasFloat64()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasFloat64()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasFloat64 that will be copied.
     */
    eProsima_user_DllExport AliasFloat64(
            const AliasFloat64& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasFloat64 that will be copied.
     */
    eProsima_user_DllExport AliasFloat64(
            AliasFloat64&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasFloat64 that will be copied.
     */
    eProsima_user_DllExport AliasFloat64& operator =(
            const AliasFloat64& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasFloat64 that will be copied.
     */
    eProsima_user_DllExport AliasFloat64& operator =(
            AliasFloat64&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasFloat64 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasFloat64& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasFloat64 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasFloat64& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_float64 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_float64 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_float64& value()
    {
        return m_value;
    }



private:

    alias_float64 m_value{0.0};

};
/*!
 * @brief This class represents the structure AliasFloat128 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasFloat128
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasFloat128()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasFloat128()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasFloat128 that will be copied.
     */
    eProsima_user_DllExport AliasFloat128(
            const AliasFloat128& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasFloat128 that will be copied.
     */
    eProsima_user_DllExport AliasFloat128(
            AliasFloat128&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasFloat128 that will be copied.
     */
    eProsima_user_DllExport AliasFloat128& operator =(
            const AliasFloat128& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasFloat128 that will be copied.
     */
    eProsima_user_DllExport AliasFloat128& operator =(
            AliasFloat128&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasFloat128 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasFloat128& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasFloat128 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasFloat128& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_float128 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_float128 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_float128& value()
    {
        return m_value;
    }



private:

    alias_float128 m_value{0.0};

};
/*!
 * @brief This class represents the structure AliasBool defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasBool
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasBool()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasBool()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasBool that will be copied.
     */
    eProsima_user_DllExport AliasBool(
            const AliasBool& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasBool that will be copied.
     */
    eProsima_user_DllExport AliasBool(
            AliasBool&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasBool that will be copied.
     */
    eProsima_user_DllExport AliasBool& operator =(
            const AliasBool& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasBool that will be copied.
     */
    eProsima_user_DllExport AliasBool& operator =(
            AliasBool&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasBool object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasBool& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasBool object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasBool& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_bool _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_bool value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_bool& value()
    {
        return m_value;
    }



private:

    alias_bool m_value{false};

};
/*!
 * @brief This class represents the structure AliasOctet defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasOctet that will be copied.
     */
    eProsima_user_DllExport AliasOctet(
            const AliasOctet& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasOctet that will be copied.
     */
    eProsima_user_DllExport AliasOctet(
            AliasOctet&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasOctet that will be copied.
     */
    eProsima_user_DllExport AliasOctet& operator =(
            const AliasOctet& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasOctet that will be copied.
     */
    eProsima_user_DllExport AliasOctet& operator =(
            AliasOctet&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasOctet& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_octet _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_octet value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_octet& value()
    {
        return m_value;
    }



private:

    alias_octet m_value{0};

};
/*!
 * @brief This class represents the structure AliasChar8 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasChar8
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasChar8()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasChar8()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasChar8 that will be copied.
     */
    eProsima_user_DllExport AliasChar8(
            const AliasChar8& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasChar8 that will be copied.
     */
    eProsima_user_DllExport AliasChar8(
            AliasChar8&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasChar8 that will be copied.
     */
    eProsima_user_DllExport AliasChar8& operator =(
            const AliasChar8& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasChar8 that will be copied.
     */
    eProsima_user_DllExport AliasChar8& operator =(
            AliasChar8&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasChar8 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasChar8& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasChar8 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasChar8& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_char8 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_char8 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_char8& value()
    {
        return m_value;
    }



private:

    alias_char8 m_value{0};

};
/*!
 * @brief This class represents the structure AliasChar16 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasChar16
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasChar16()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasChar16()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasChar16 that will be copied.
     */
    eProsima_user_DllExport AliasChar16(
            const AliasChar16& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasChar16 that will be copied.
     */
    eProsima_user_DllExport AliasChar16(
            AliasChar16&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasChar16 that will be copied.
     */
    eProsima_user_DllExport AliasChar16& operator =(
            const AliasChar16& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasChar16 that will be copied.
     */
    eProsima_user_DllExport AliasChar16& operator =(
            AliasChar16&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasChar16 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasChar16& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasChar16 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasChar16& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_char16 _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_char16 value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_char16& value()
    {
        return m_value;
    }



private:

    alias_char16 m_value{0};

};
/*!
 * @brief This class represents the structure AliasString8 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasString8
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasString8()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasString8()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasString8 that will be copied.
     */
    eProsima_user_DllExport AliasString8(
            const AliasString8& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasString8 that will be copied.
     */
    eProsima_user_DllExport AliasString8(
            AliasString8&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasString8 that will be copied.
     */
    eProsima_user_DllExport AliasString8& operator =(
            const AliasString8& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasString8 that will be copied.
     */
    eProsima_user_DllExport AliasString8& operator =(
            AliasString8&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasString8 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasString8& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasString8 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasString8& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_string8& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_string8&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_string8& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_string8& value()
    {
        return m_value;
    }



private:

    alias_string8 m_value;

};
/*!
 * @brief This class represents the structure AliasString16 defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasString16
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasString16()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasString16()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasString16 that will be copied.
     */
    eProsima_user_DllExport AliasString16(
            const AliasString16& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasString16 that will be copied.
     */
    eProsima_user_DllExport AliasString16(
            AliasString16&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasString16 that will be copied.
     */
    eProsima_user_DllExport AliasString16& operator =(
            const AliasString16& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasString16 that will be copied.
     */
    eProsima_user_DllExport AliasString16& operator =(
            AliasString16&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasString16 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasString16& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasString16 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasString16& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_string16& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_string16&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_string16& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_string16& value()
    {
        return m_value;
    }



private:

    alias_string16 m_value;

};
/*!
 * @brief This class represents the structure AliasEnum defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasEnum that will be copied.
     */
    eProsima_user_DllExport AliasEnum(
            const AliasEnum& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasEnum that will be copied.
     */
    eProsima_user_DllExport AliasEnum(
            AliasEnum&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasEnum that will be copied.
     */
    eProsima_user_DllExport AliasEnum& operator =(
            const AliasEnum& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasEnum that will be copied.
     */
    eProsima_user_DllExport AliasEnum& operator =(
            AliasEnum&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasEnum& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_enum _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_enum value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_enum& value()
    {
        return m_value;
    }



private:

    alias_enum m_value{InnerEnumHelper::ENUM_VALUE_1};

};
/*!
 * @brief This class represents the structure AliasBitmask defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasBitmask
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasBitmask()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasBitmask()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasBitmask that will be copied.
     */
    eProsima_user_DllExport AliasBitmask(
            const AliasBitmask& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasBitmask that will be copied.
     */
    eProsima_user_DllExport AliasBitmask(
            AliasBitmask&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasBitmask that will be copied.
     */
    eProsima_user_DllExport AliasBitmask& operator =(
            const AliasBitmask& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasBitmask that will be copied.
     */
    eProsima_user_DllExport AliasBitmask& operator =(
            AliasBitmask&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasBitmask object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasBitmask& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasBitmask object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasBitmask& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_bitmask& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_bitmask&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_bitmask& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_bitmask& value()
    {
        return m_value;
    }



private:

    alias_bitmask m_value{0};

};
/*!
 * @brief This class represents the structure AliasAlias defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasAlias that will be copied.
     */
    eProsima_user_DllExport AliasAlias(
            const AliasAlias& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasAlias that will be copied.
     */
    eProsima_user_DllExport AliasAlias(
            AliasAlias&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasAlias that will be copied.
     */
    eProsima_user_DllExport AliasAlias& operator =(
            const AliasAlias& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasAlias that will be copied.
     */
    eProsima_user_DllExport AliasAlias& operator =(
            AliasAlias&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasAlias& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            alias_alias _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport alias_alias value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_alias& value()
    {
        return m_value;
    }



private:

    alias_alias m_value{0};

};
/*!
 * @brief This class represents the structure AliasArray defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasArray
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasArray()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasArray()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasArray that will be copied.
     */
    eProsima_user_DllExport AliasArray(
            const AliasArray& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasArray that will be copied.
     */
    eProsima_user_DllExport AliasArray(
            AliasArray&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasArray that will be copied.
     */
    eProsima_user_DllExport AliasArray& operator =(
            const AliasArray& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasArray that will be copied.
     */
    eProsima_user_DllExport AliasArray& operator =(
            AliasArray&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasArray object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasArray& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasArray object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasArray& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_array& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_array&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_array& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_array& value()
    {
        return m_value;
    }



private:

    alias_array m_value{0};

};
/*!
 * @brief This class represents the structure AliasMultiArray defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasMultiArray
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasMultiArray()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasMultiArray()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasMultiArray that will be copied.
     */
    eProsima_user_DllExport AliasMultiArray(
            const AliasMultiArray& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasMultiArray that will be copied.
     */
    eProsima_user_DllExport AliasMultiArray(
            AliasMultiArray&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasMultiArray that will be copied.
     */
    eProsima_user_DllExport AliasMultiArray& operator =(
            const AliasMultiArray& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasMultiArray that will be copied.
     */
    eProsima_user_DllExport AliasMultiArray& operator =(
            AliasMultiArray&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasMultiArray object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasMultiArray& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasMultiArray object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasMultiArray& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_multiarray& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_multiarray&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_multiarray& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_multiarray& value()
    {
        return m_value;
    }



private:

    alias_multiarray m_value{ {{0}} };

};
/*!
 * @brief This class represents the structure AliasSequence defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasSequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasSequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasSequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasSequence that will be copied.
     */
    eProsima_user_DllExport AliasSequence(
            const AliasSequence& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasSequence that will be copied.
     */
    eProsima_user_DllExport AliasSequence(
            AliasSequence&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasSequence that will be copied.
     */
    eProsima_user_DllExport AliasSequence& operator =(
            const AliasSequence& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasSequence that will be copied.
     */
    eProsima_user_DllExport AliasSequence& operator =(
            AliasSequence&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasSequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasSequence& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasSequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasSequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_sequence& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_sequence&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_sequence& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_sequence& value()
    {
        return m_value;
    }



private:

    alias_sequence m_value;

};
/*!
 * @brief This class represents the structure AliasMap defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasMap that will be copied.
     */
    eProsima_user_DllExport AliasMap(
            const AliasMap& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasMap that will be copied.
     */
    eProsima_user_DllExport AliasMap(
            AliasMap&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasMap that will be copied.
     */
    eProsima_user_DllExport AliasMap& operator =(
            const AliasMap& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasMap that will be copied.
     */
    eProsima_user_DllExport AliasMap& operator =(
            AliasMap&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasMap& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_map& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_map&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_map& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_map& value()
    {
        return m_value;
    }



private:

    alias_map m_value;

};
/*!
 * @brief This class represents the structure AliasUnion defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasUnion()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasUnion that will be copied.
     */
    eProsima_user_DllExport AliasUnion(
            const AliasUnion& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasUnion that will be copied.
     */
    eProsima_user_DllExport AliasUnion(
            AliasUnion&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasUnion that will be copied.
     */
    eProsima_user_DllExport AliasUnion& operator =(
            const AliasUnion& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasUnion that will be copied.
     */
    eProsima_user_DllExport AliasUnion& operator =(
            AliasUnion&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasUnion& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_union& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_union&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_union& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_union& value()
    {
        return m_value;
    }



private:

    alias_union m_value;

};
/*!
 * @brief This class represents the structure AliasStruct defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasStruct that will be copied.
     */
    eProsima_user_DllExport AliasStruct(
            const AliasStruct& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasStruct that will be copied.
     */
    eProsima_user_DllExport AliasStruct(
            AliasStruct&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasStruct that will be copied.
     */
    eProsima_user_DllExport AliasStruct& operator =(
            const AliasStruct& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasStruct that will be copied.
     */
    eProsima_user_DllExport AliasStruct& operator =(
            AliasStruct&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasStruct& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_structure& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_structure&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_structure& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_structure& value()
    {
        return m_value;
    }



private:

    alias_structure m_value;

};
/*!
 * @brief This class represents the structure AliasBitset defined by the user in the IDL file.
 * @ingroup aliases
 */
class AliasBitset
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AliasBitset()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AliasBitset()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AliasBitset that will be copied.
     */
    eProsima_user_DllExport AliasBitset(
            const AliasBitset& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AliasBitset that will be copied.
     */
    eProsima_user_DllExport AliasBitset(
            AliasBitset&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AliasBitset that will be copied.
     */
    eProsima_user_DllExport AliasBitset& operator =(
            const AliasBitset& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AliasBitset that will be copied.
     */
    eProsima_user_DllExport AliasBitset& operator =(
            AliasBitset&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AliasBitset& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AliasBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AliasBitset& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const alias_bitset& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            alias_bitset&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const alias_bitset& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport alias_bitset& value()
    {
        return m_value;
    }



private:

    alias_bitset m_value;

};

#endif // _FAST_DDS_GENERATED_ALIASES_HPP_


