package tests

import (
	"crypto/tls"
)

var testCert = func() tls.Certificate {
	cert, err := tls.X509KeyPair([]byte(testCertPEM), []byte(testKeyPEM))
	if err != nil {
		panic(err)
	}

	return cert
}()

const testCertPEM = `-----BEGIN CERTIFICATE-----
MIIDADCCAeigAwIBAgIQbOhMBru7sP/1uK0nDjxwIzANBgkqhkiG9w0BAQsFADAA
MB4XDTIxMTIwNjIyMzMzM1oXDTQxMTIwMTIyMzMzM1owADCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBAMK6TANA5RHk8xNQRz6VSlKi4WJmgTutmb5zwvTO
L2PNKVQsk/KtQeQpvgbwe50jlMB8hd9ZEizZq/3JvYFcw1PwcJQ8eT2fBFS7kCxM
p/tBIBuS4/bvEG8vDOTKSSk5AeQl/xijPJQrm81LJXs0gxAfGNBFaaA9j2wMz8Yg
KVRwVVlI3PbsukU3TU0XHCwSInnFb+EpO2+IJevIlXb94QhxSDbmnwIU65gXHqkV
wo9ZXznN8gW9ZApNyNldK2LyblZ7Ws8WBlUv2p42tMMF0Kjx15awQCumaaSax61W
oDcFJq7vDj3BFtbq8FHk7DYYQZQoRap/dJUF/fYF+nNklekCAwEAAaN2MHQwDgYD
VR0PAQH/BAQDAgKkMBMGA1UdJQQMMAoGCCsGAQUFBwMBMA8GA1UdEwEB/wQFMAMB
Af8wHQYDVR0OBBYEFEHJiUtI88kTv52Yxk3QZCMeLXtEMB0GA1UdEQEB/wQTMBGC
CWxvY2FsaG9zdIcEfwAAATANBgkqhkiG9w0BAQsFAAOCAQEABZoAd9DO4cs1NoA7
9pbRd9rIgikluAWDGOeUxj9jHugWYPUb1NjIlza8DPAfrdVRoDcGNoXJytxcO4zK
SwaAsPvlpqFaweixAuf3Yk94SnA6cpsHbXHKtGaO6mcazKn0tmhqOm8Hvi2z1VcA
MDUZIgUqQWJy4u3gHJq2q4QE4488iLt0f9NuHDnIjydMl2cY/WcnjYU7fTtzYZAP
40Fz2wbecog4BlCtXngicah+60oqNIK6I9Cht+OuY3v6v/YXTpt0WQ6xSl8sKVTZ
5Vy/FJ+hBqmlRf11gGqJ6UC3kRnhnOwwqE/MaXQx/eExTU+H3uXgPko9eJlg+yQP
sd1PqA==
-----END CERTIFICATE-----
`

const testKeyPEM = `-----BEGIN PRIVATE KEY-----
MIIEpAIBAAKCAQEAwrpMA0DlEeTzE1BHPpVKUqLhYmaBO62ZvnPC9M4vY80pVCyT
8q1B5Cm+BvB7nSOUwHyF31kSLNmr/cm9gVzDU/BwlDx5PZ8EVLuQLEyn+0EgG5Lj
9u8Qby8M5MpJKTkB5CX/GKM8lCubzUslezSDEB8Y0EVpoD2PbAzPxiApVHBVWUjc
9uy6RTdNTRccLBIiecVv4Sk7b4gl68iVdv3hCHFINuafAhTrmBceqRXCj1lfOc3y
Bb1kCk3I2V0rYvJuVntazxYGVS/anja0wwXQqPHXlrBAK6ZppJrHrVagNwUmru8O
PcEW1urwUeTsNhhBlChFqn90lQX99gX6c2SV6QIDAQABAoIBAHdU93Qe9sIqjhPN
5HsjvfI6QuisbJIH5unhwx2GpWABwEwHLXtQVcrfEcbq5LX9shDrvpaK3SqDEnVq
himakVEFTdhp3tq2ck8Cym17ZI4C8Qw0zmLrSiT4rmwe0wriFpib+GI+1sbumoIK
hSOloJPmmqw3fW1njFbo2wNNfkZxpi4c0OSM1n1uCor8+aoedWJrWbG/Ml9PxbHx
NwAAYvUqcE9yrGIWIilSA12ylizvd8B1DaF7wAfo1MC4rpa/0hq4VKweQ8/r+QUt
CS1bPmn9Hh4naJ1UChSyYB5O0RLzOC6fzA/pbLoF88KziwSsnwg+G949EwX0JO7P
Q6gHzCkCgYEA8idOwDYZu7IH6rgRmaBsqz3plIoQ6uFeQRYNhTDUrKZ1/nFmTBc1
Zibvn8Z7KTZOCxLcVZ9oVDd6Gm3Na6uJrT/ui4TtzyS0n43zMmilHG3f43C5dAIk
xjB1iT5Q44w3YO3jc65J/EIyM1a/ASlPPnMO37E8J+s3NcyNKDBgN8cCgYEAzdzC
s5VNkDktoECNzHDZNuzqjhC7JhmauSkpueVnnVFCc/Gd+kk1ME/XeEIDU+KQLNLq
BmysEpENc+UvP4XAbp2NcDJc118XPT+5vD2qbecjSnJXsWYLUxvY7Ux35w6Yngf6
Nen02YRMIt/lg+OFYk2Ys+2AvRJmkjErtBdEpM8CgYBQjYTj6dtLleCOUyb/rN8Z
Y+IU2IziJZA+JIDg4qqMuF8eAkkeXMYVsjQaOWN1BSyXAHItRXbmNQI4Unh4LbsB
1/eZj+Gv+6zeOtFA3pC2UVKeDTyT+7aR+0LOId20pEszwk7ch4jzEm4yp9OoJj7H
Lm0vOn0hZlyaV+5JBTastwKBgQC7LcAm01lcCnFO5YNI4U7PnylCFTplUSCavS/A
ZDMLGqimjYmL2mavT9ll8ffenQFkkD3Tq5nlo9gsibWlN3MZ4M2Kt3AtL7wMp9W0
sAk3ttMizMapeVRQs+BRG5dmEqJ4Bl7eCKTl5mHnz9Z7TjOoh0+SQiAtSf7TbDwF
mqaChwKBgQDw86PVXgIwuLv7fAjEOu40+agNOIRaxs4c+ZyLIuC2wHx2Md4hKxKU
GkMYNJppiar000/ewbU8QomaKkavYc/MMrsNTsc9n1BYA88RaB3AwTiGbclzsbq2
kF81xUvDHBWjihVWWJJaL7wnWyKfaLcRtTp6p7bNuGvJ9mdUG/37kA==
-----END PRIVATE KEY-----
`
