package CParse::TypeName;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $specifiers = shift;
    my $declarator = shift;
    my $self = {declarator => $declarator,
                specifiers => $specifiers,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $str = join(' ', map {$_->dump_c} @{$self->{specifiers}});

    if (defined $self->{declarator})
      {
        $str .= " " . $self->{declarator}->dump_c;
      }

    return "$str";
  }

sub get_type
  {
    my $self = shift;

    my $namespace = shift;

    my @attributes;
    my @specifiers;

    foreach my $specifier (@{$self->{specifiers}})
      {
        if ($specifier->isa('CParse::AttributeList'))
          {
            push @attributes, $specifier->attributes;
          }
        else
          {
            push @specifiers, $specifier;
          }
      }

    return $self->{declarator}->get_decl_type($namespace, \@specifiers, \@attributes);
  }

1;
