---
title: "Introduction"
permalink: /docs/readme/intro/
excerpt: "A quick introduction to what Kismet is, isn't, and how it works"
docgroup: "readme"
---

## Kismet

Kismet is a monitoring tool for wireless - originally only supporting 802.11 Wi-Fi, with the right hardware Kismet can now capture Bluetooth advertisements, BTLE, nRF-based wireless mice and keyboards, weather stations, wireless thermometers, switches, smoke detectors, 802.15.4 / Zigbee, ADSB airplane transponders, AMR wireless power, water, and gas meters, and more.

## Passive monitoring

Kismet operates almost entirely passively, with a few exceptions (such as Bluetooth scanning mode) noted in the documentation for those capture types.

Kismet is *not* an attack tool (generally) - to test your Wi-Fi security check out tools like [Aircrack-NG](https://www.aircrack-ng.org) or the [Wi-Fi Pineapple](https://shop.hak5.org/).  

Kismet is largely focused on collecting, collating, and sorting wireless data.  The logs generated by Kismet can be fed into other tools (the pcap, handshakes, and other data) like hashcat, aircrack, and more.

## Device-oriented display

Kismet is different from [Wireshark](https://wireshark.org); Kismet primarily focuses on representing *devices* - access points, clients, bridged wired devices, sensors, Bluetooth entities, and so on, while Wireshark focuses on displaying a deep dive of specific packets and all the content.  

Kismet and Wireshark work best when used *together* - Kismet collects packets and logs them to standard formats (pcap and pcapng) or the kismetdb format which can be converted directly to pcap and pcapng, and collects location, changes over time, etc, while Wireshark can open the pcap logs and give extensive detailed information about specific packets.  Each tool is designed for a different job, but operate together.

## Wireless vs Wired monitoring

Wireless capture is often more difficult than wired capture, at several levels:

* Different physical characteristics

    When connecting to a wired network and capturing packets, you will always capture all packets available on that connection (assuming you have sufficient processing power and storage speed to log them, of course).  When capturing packets from a wireless network, things are very different; your receiver may not be in a position to even see the packets that the legitimate destination can receive fine, you may not be on the correct channel or part of the spectrum when the packets are sent, there may be localized interference, or you may be in the center of reflected signals that cancel each other out.

* Drivers

    To capture raw packets from a Wi-Fi device, a mode called "monitor mode" or "rfmon" is required - this is a non-standard mode which turns off packet filtering in the Wi-Fi card itself and passes raw data up to the operating system.  While most drivers in the Linux kernel support this, not all do.  Mobile chipsets (such as those found in Android phones or Raspberry Pi devices) typically do not have the code in the device firmware *at all* and either cannot be used, or require special driver hacks to re-enable it.  Other operating systems like Windows have nearly no monitor-mode capable public drivers, and MacOS can enter monitor mode for the internal Airport cards, but typically not on any other type of Wi-Fi.

    Other non-Wi-Fi protocols often have no radio support, or lack drivers.  Sometimes this is solved with special hardware and drivers, sometimes it can be solved with software defined radios.

* Many protocols

    Wi-Fi alone has at least 6 major revisions, each of which is largely invisible to hardware of the previous generation, combined with 3 major spectrum bands.  Each revision increases speed (decreasing effective signal) and complexity of the signal (MIMO, sub-channels, etc) which make capturing data harder.

    That's just Wi-Fi - add in Bluetooth, Zigbee, arbitrary RF protocols, and the amount of hardware and software needed to capture what is flying around in the air explodes.

