/*
 * Codepage definitions for libolecf
 *
 * Copyright (C) 2008-2018, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBOLECF_CODEPAGE_H )
#define _LIBOLECF_CODEPAGE_H

#include <libolecf/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBOLECF_CODEPAGES
{
	LIBOLECF_CODEPAGE_ASCII				= 20127,

	LIBOLECF_CODEPAGE_ISO_8859_1			= 28591,
	LIBOLECF_CODEPAGE_ISO_8859_2			= 28592,
	LIBOLECF_CODEPAGE_ISO_8859_3			= 28593,
	LIBOLECF_CODEPAGE_ISO_8859_4			= 28594,
	LIBOLECF_CODEPAGE_ISO_8859_5			= 28595,
	LIBOLECF_CODEPAGE_ISO_8859_6			= 28596,
	LIBOLECF_CODEPAGE_ISO_8859_7			= 28597,
	LIBOLECF_CODEPAGE_ISO_8859_8			= 28598,
	LIBOLECF_CODEPAGE_ISO_8859_9			= 28599,
	LIBOLECF_CODEPAGE_ISO_8859_10			= 28600,
	LIBOLECF_CODEPAGE_ISO_8859_11			= 28601,
	LIBOLECF_CODEPAGE_ISO_8859_13			= 28603,
	LIBOLECF_CODEPAGE_ISO_8859_14			= 28604,
	LIBOLECF_CODEPAGE_ISO_8859_15			= 28605,
	LIBOLECF_CODEPAGE_ISO_8859_16			= 28606,

	LIBOLECF_CODEPAGE_KOI8_R			= 20866,
	LIBOLECF_CODEPAGE_KOI8_U			= 21866,

	LIBOLECF_CODEPAGE_WINDOWS_874			= 874,
	LIBOLECF_CODEPAGE_WINDOWS_932			= 932,
	LIBOLECF_CODEPAGE_WINDOWS_936			= 936,
	LIBOLECF_CODEPAGE_WINDOWS_949			= 949,
	LIBOLECF_CODEPAGE_WINDOWS_950			= 950,
	LIBOLECF_CODEPAGE_WINDOWS_1250			= 1250,
	LIBOLECF_CODEPAGE_WINDOWS_1251			= 1251,
	LIBOLECF_CODEPAGE_WINDOWS_1252			= 1252,
	LIBOLECF_CODEPAGE_WINDOWS_1253			= 1253,
	LIBOLECF_CODEPAGE_WINDOWS_1254			= 1254,
	LIBOLECF_CODEPAGE_WINDOWS_1255			= 1255,
	LIBOLECF_CODEPAGE_WINDOWS_1256			= 1256,
	LIBOLECF_CODEPAGE_WINDOWS_1257			= 1257,
	LIBOLECF_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBOLECF_CODEPAGE_US_ASCII			LIBOLECF_CODEPAGE_ASCII

#define LIBOLECF_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBOLECF_CODEPAGE_ISO_8859_1
#define LIBOLECF_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBOLECF_CODEPAGE_ISO_8859_2
#define LIBOLECF_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBOLECF_CODEPAGE_ISO_8859_3
#define LIBOLECF_CODEPAGE_ISO_NORTH_EUROPEAN		LIBOLECF_CODEPAGE_ISO_8859_4
#define LIBOLECF_CODEPAGE_ISO_CYRILLIC			LIBOLECF_CODEPAGE_ISO_8859_5
#define LIBOLECF_CODEPAGE_ISO_ARABIC			LIBOLECF_CODEPAGE_ISO_8859_6
#define LIBOLECF_CODEPAGE_ISO_GREEK			LIBOLECF_CODEPAGE_ISO_8859_7
#define LIBOLECF_CODEPAGE_ISO_HEBREW			LIBOLECF_CODEPAGE_ISO_8859_8
#define LIBOLECF_CODEPAGE_ISO_TURKISH			LIBOLECF_CODEPAGE_ISO_8859_9
#define LIBOLECF_CODEPAGE_ISO_NORDIC			LIBOLECF_CODEPAGE_ISO_8859_10
#define LIBOLECF_CODEPAGE_ISO_THAI			LIBOLECF_CODEPAGE_ISO_8859_11
#define LIBOLECF_CODEPAGE_ISO_BALTIC			LIBOLECF_CODEPAGE_ISO_8859_13
#define LIBOLECF_CODEPAGE_ISO_CELTIC			LIBOLECF_CODEPAGE_ISO_8859_14

#define LIBOLECF_CODEPAGE_ISO_LATIN_1			LIBOLECF_CODEPAGE_ISO_8859_1
#define LIBOLECF_CODEPAGE_ISO_LATIN_2			LIBOLECF_CODEPAGE_ISO_8859_2
#define LIBOLECF_CODEPAGE_ISO_LATIN_3			LIBOLECF_CODEPAGE_ISO_8859_3
#define LIBOLECF_CODEPAGE_ISO_LATIN_4			LIBOLECF_CODEPAGE_ISO_8859_4
#define LIBOLECF_CODEPAGE_ISO_LATIN_5			LIBOLECF_CODEPAGE_ISO_8859_9
#define LIBOLECF_CODEPAGE_ISO_LATIN_6			LIBOLECF_CODEPAGE_ISO_8859_10
#define LIBOLECF_CODEPAGE_ISO_LATIN_7			LIBOLECF_CODEPAGE_ISO_8859_13
#define LIBOLECF_CODEPAGE_ISO_LATIN_8			LIBOLECF_CODEPAGE_ISO_8859_14
#define LIBOLECF_CODEPAGE_ISO_LATIN_9			LIBOLECF_CODEPAGE_ISO_8859_15
#define LIBOLECF_CODEPAGE_ISO_LATIN_10			LIBOLECF_CODEPAGE_ISO_8859_16

#define LIBOLECF_CODEPAGE_KOI8_RUSSIAN			LIBOLECF_CODEPAGE_KOI8_R
#define LIBOLECF_CODEPAGE_KOI8_UKRAINIAN		LIBOLECF_CODEPAGE_KOI8_U

#define LIBOLECF_CODEPAGE_WINDOWS_THAI			LIBOLECF_CODEPAGE_WINDOWS_874
#define LIBOLECF_CODEPAGE_WINDOWS_JAPANESE		LIBOLECF_CODEPAGE_WINDOWS_932
#define LIBOLECF_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBOLECF_CODEPAGE_WINDOWS_936
#define LIBOLECF_CODEPAGE_WINDOWS_KOREAN		LIBOLECF_CODEPAGE_WINDOWS_949
#define LIBOLECF_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBOLECF_CODEPAGE_WINDOWS_950
#define LIBOLECF_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBOLECF_CODEPAGE_WINDOWS_1250
#define LIBOLECF_CODEPAGE_WINDOWS_CYRILLIC		LIBOLECF_CODEPAGE_WINDOWS_1251
#define LIBOLECF_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBOLECF_CODEPAGE_WINDOWS_1252
#define LIBOLECF_CODEPAGE_WINDOWS_GREEK			LIBOLECF_CODEPAGE_WINDOWS_1253
#define LIBOLECF_CODEPAGE_WINDOWS_TURKISH		LIBOLECF_CODEPAGE_WINDOWS_1254
#define LIBOLECF_CODEPAGE_WINDOWS_HEBREW		LIBOLECF_CODEPAGE_WINDOWS_1255
#define LIBOLECF_CODEPAGE_WINDOWS_ARABIC		LIBOLECF_CODEPAGE_WINDOWS_1256
#define LIBOLECF_CODEPAGE_WINDOWS_BALTIC		LIBOLECF_CODEPAGE_WINDOWS_1257
#define LIBOLECF_CODEPAGE_WINDOWS_VIETNAMESE		LIBOLECF_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBOLECF_CODEPAGE_H ) */

