/* 
 * All content copyright Terracotta, Inc., unless otherwise indicated. All rights reserved. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not 
 * use this file except in compliance with the License. You may obtain a copy 
 * of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 *   
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations 
 * under the License.
 * 
 */
 package org.terracotta.quartz.tests;

import org.quartz.Scheduler;

public class SynchWriteClient extends ClientBase {

  public SynchWriteClient(String[] args) {
    super(args);
  }

  public static void main(String[] args) {
    new SynchWriteClient(args).run();
  }

  @Override
  protected boolean isSynchWrite() {
    return true;
  }

  @Override
  protected void test(Scheduler scheduler) throws Throwable {
    // does nothing really, test will inspect logging output
  }
}
