#ifndef UTILS_H
#define UTILS_H

@import Foundation;
#include <stdio.h>
#include <dlfcn.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/attr.h>
#include <mach/mach.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/mount.h>
#include <spawn.h>
#include <sys/sysctl.h>
#include <sys/types.h>          /* See NOTES */
#include <sys/socket.h>

#include <stdint.h>
#include <CoreFoundation/CoreFoundation.h>

typedef mach_port_t io_object_t;
typedef io_object_t io_iterator_t;
typedef io_object_t io_service_t;
typedef char * io_buf_ptr_t;
typedef uintptr_t addr_t;

void for_other_threads(void (^handler)(thread_act_t thread));
void set_nofile_limit();
int download(char *src, char *dest);
mach_port_t alloc_port();
kern_return_t kalloc_ool_ports(mach_port_t port, mach_port_t ool_port, size_t cnt);
kern_return_t kalloc_page_ool_ports(mach_port_t port);
kern_return_t kalloc_8_ool_ports(mach_port_t port, mach_port_t ool_port);
void discard_message(mach_port_t port);
void hexdump(void *ptr, size_t n);
int pipe_create(int fds[2]);
int pipe_alloc(int fds[2], void *buf, size_t size);
void pipes_close(int *pipes, size_t count);
int pipes_create(int *pipes, size_t count);
int pipes_alloc(int *pipes, size_t count, char *pipe_buf);

//#define DEBUG 1
#ifdef DEBUG
#define LOG(str, args...) do { NSLog(@str, ##args); } while(0)
#else
#define LOG(str, args...) do {} while(0)
#endif

#endif
