require 'lru_redux'

module Msf
  ###
  #
  # This module exposes methods for querying a remote LDAP service
  #
  ###
  module Exploit::Remote::LDAP
    module EntryCache
      class LDAPEntryCache < LruRedux::Cache
        def <<(entry)
          raise TypeError unless entry.is_a? Net::LDAP::Entry

          self[entry.dn] = entry
        end

        def get_by_dn(dn)
          self[dn]
        end

        def get_by_samaccountname(samaccountname)
          entry = @data.values.reverse_each.find { _1[:sAMAccountName]&.first == samaccountname }
          @data[entry.dn] = entry if entry # update it as recently used
          entry
        end

        def get_by_sid(sid)
          sid = Rex::Proto::MsDtyp::MsDtypSid.new(sid)

          entry = @data.values.reverse_each.find { _1[:objectSid]&.first == sid.to_binary_s  }
          @data[entry.dn] = entry if entry # update it as recently used
          entry
        end
      end

      def ldap_entry_cache
        @ldap_entry_cache ||= LDAPEntryCache.new(1000)
      end
    end
  end
end
