## Usage

```js
const Node = require('snapdragon-node');
// either pass on object with "type" and (optional) "val"
const node1 = new Node({type: 'star', val: '*'});
// or pass "val" (first) and "type" (second) as string
const node2 = new Node('*', 'star');
// both result in => Node { type: 'star', val: '*' }
```

## Snapdragon usage

With [snapdragon][] v0.9.0 and higher, it's recommended that you use `this.node()` to create a new `Node` inside parser handlers (instead of doing `new Node()`). 

### Snapdragon ^1.0.0

Example usage inside a [snapdragon][] parser handler function.

```js
const Node = require('{%= name %}');
const Token = require('snapdragon-token');

// create a new AST node
const node = new Node({ type: 'star', value: '*' });

// convert a Lexer Token into an AST Node
const token = new Token({ type: 'star', value: '*' });
const node = new Node(token);
```

## Node objects

AST Nodes are represented as `Node` objects that implement the following interface:

```js
interface Node {
  type: string;
  value: string | undefined
  nodes: array | undefined
}
```

- `type` **{string}** - A string representing the node variant type. This property is often used for classifying the purpose or nature of the node, so that parsers or compilers can determine what to do with it.
- `value` **{string|undefined}** (optional) - In general, value should only be a string when `node.nodes` is undefined. This is not reinforced, but is considered good practice. Use a different property name to store arbitrary strings on the node when `node.nodes` is an array.
- `nodes` **{array|undefined}** (optional) - array of child nodes

A number of useful methods and non-enumerable properties are also exposed for adding, finding and removing child nodes, etc. 

Continue reading the API documentation for more details.

## Node API
{%= apidocs("index.js") %}

### Non-enumerable properties

- `node.isNode` **{boolean}** - this value is set to `true` when a node is created. This can be useful in situationas as a fast alternative to using `instanceof Node` if you [need to determine](#nodeisnode) if a value is a `node` object. 
- `node.size` **{number}** - the number of child nodes that have been pushed or unshifted onto `node.nodes` using the node's API. This is useful for determining if nodes were added to `node.nodes` without using `node.push()` or `node.unshift()` (for example: `if (node.nodes && node.size !== node.nodes.length)`)
- `node.parent` **{object}** (instance of Node) 


## Release history

See [the changelog](changelog.md).
