# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.virtualenclaves import VirtualEnclavesMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-virtualenclaves
# USAGE
    python approvals_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = VirtualEnclavesMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.approval.begin_create_or_update(
        resource_uri="subscriptions/c64f6eca-bdc5-4bc2-88d6-f8f1dc23f86c/resourceGroups/TestMyRg/providers/Microsoft.Mission/enclaveconnections/TestMyEnclaveConnection",
        approval_name="TestApprovals",
        resource={
            "properties": {
                "approvers": [
                    {
                        "actionPerformed": "Approved",
                        "approverEntraId": "00000000-0000-0000-0000-000000000000",
                        "lastUpdatedAt": "2023-03-17T20:43:17.760Z",
                    }
                ],
                "createdAt": "2023-03-17T20:43:17.760Z",
                "grandparentResourceId": "/subscriptions/c64f6eca-bdc5-4bc2-88d6-f8f1dc23f86c/resourceGroups/testrg/providers/Microsoft.Mission/communities/TestMyCommunity",
                "parentResourceId": "/subscriptions/c64f6eca-bdc5-4bc2-88d6-f8f1dc23f86c/resourceGroups/TestMyRg/providers/microsoft.mission/virtualenclaves/TestMyEnclave",
                "requestMetadata": {
                    "approvalCallbackPayload": '{\n  "key1": "value1",\n  "key2": "value2"\n}',
                    "approvalCallbackRoute": "approvalCallback",
                    "approvalStatus": "Approved",
                    "resourceAction": "string",
                },
                "stateChangedAt": "2023-03-17T20:43:17.760Z",
                "ticketId": "string",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-05-01-preview/Approvals_CreateOrUpdate.json
if __name__ == "__main__":
    main()
