from _moderngl import parse_spv_inputs, ATTRIBUTE_LOOKUP_TABLE

def test_spirv_parsing():
    spv = bytes.fromhex('''
        03022307000001000b000d00350000000000000011000200010000000b00060001000000474c534c
        2e7374642e343530000000000e00030000000000010000000f000b0000000000040000006d61696e
        000000000d0000001200000021000000240000002c0000002f000000480005000b00000000000000
        0b00000000000000480005000b000000010000000b00000001000000480005000b00000002000000
        0b00000003000000480005000b000000030000000b00000004000000470003000b00000002000000
        47000400120000001e0000000000000047000400210000001e000000000000004700040024000000
        1e00000001000000470004002c0000001e00000001000000470004002f0000001e00000002000000
        13000200020000002100030003000000020000001600030006000000200000001700040007000000
        0600000004000000150004000800000020000000000000002b000400080000000900000001000000
        1c0004000a00000006000000090000001e0006000b00000007000000060000000a0000000a000000
        200004000c000000030000000b0000003b0004000c0000000d00000003000000150004000e000000
        20000000010000002b0004000e0000000f0000000000000017000400100000000600000003000000
        200004001100000001000000100000003b0004001100000012000000010000002b00040008000000
        1300000000000000200004001400000001000000060000002b000400080000001900000002000000
        200004001f00000003000000070000003b0004001f00000021000000030000001800040022000000
        0700000002000000200004002300000001000000220000003b000400230000002400000001000000
        20000400250000000100000007000000200004002b00000003000000060000003b0004002b000000
        2c000000030000003b0004002b0000002f0000000300000036000500020000000400000000000000
        03000000f80002000500000041000500140000001500000012000000130000003d00040006000000
        160000001500000041000500140000001700000012000000090000003d0004000600000018000000
        1700000041000500140000001a00000012000000190000003d000400060000001b0000001a000000
        50000700070000001e00000016000000180000001b0000001b000000410005001f00000020000000
        0d0000000f0000003e000300200000001e000000410005002500000026000000240000000f000000
        3d0004000700000027000000260000003e00030021000000270000003e0003002c0000001b000000
        8500050006000000340000001b0000001b0000003e0003002f00000034000000fd00010038000100
    ''')

    result = {
        location: ATTRIBUTE_LOOKUP_TABLE[info.gl_type]
        for location, info in parse_spv_inputs(0, spv).items()
    }

    must_be = [(0, ATTRIBUTE_LOOKUP_TABLE[0x8b51]), (1, ATTRIBUTE_LOOKUP_TABLE[0x8b66])]
    output = True
    for x in result.items():
        if x not in must_be:
            output = False
            break

    for x in must_be:
        if x not in result.items():
            output = False
            break

    assert output
