# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue
here on GitHub.

Please note we have a code of conduct, please follow it in all your interactions with the project.

## Pull Request Process
** All PRs must merge into the dev branch, and not into master**. The dev branch is the only one that can merge into master directly.

1. Ensure any install or build dependencies are removed before the end of the layer when doing a 
   build.
2. Make sure all corresponding test cases pass.
3. Update the README.md with details of changes to the interface, this includes new environment 
   variables, exposed ports, useful file locations and container parameters.
4. Version number will be increased only when merging dev into master, so that a version update may carry multiple PRs from various developers. The versioning scheme we use is [SemVer](http://semver.org/).
