% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmSQTLfit.R
\docType{class}
\name{dmSQTLfit-class}
\alias{dmSQTLfit-class}
\title{dmSQTLfit object}
\description{
dmSQTLfit extends the \code{\linkS4class{dmSQTLprecision}} class by adding 
the full model Dirichlet-multinomial (DM) likelihoods,
regression coefficients and feature proportion estimates needed for the 
transcript/exon usage QTL analysis. Full model is defined by the genotype of
a SNP associated with a gene. Estimation takes place for all the genes and 
all the SNPs/blocks assigned to the genes. Result of \code{\link{dmFit}}.
}
\section{Slots}{

\describe{
\item{\code{fit_full}}{List of \code{\linkS4class{MatrixList}} objects containing 
estimated feature ratios in each sample based on the full 
Dirichlet-multinomial (DM) model.}

\item{\code{lik_full}}{List of numeric vectors of the per gene DM full model 
likelihoods.}

\item{\code{coef_full}}{\code{\linkS4class{MatrixList}} with the regression 
coefficients based on the DM model.}
}}

\examples{
# --------------------------------------------------------------------------
# Create dmSQTLdata object
# --------------------------------------------------------------------------
# Use subsets of data defined in the GeuvadisTranscriptExpr package

library(GeuvadisTranscriptExpr)
\donttest{
geuv_counts <- GeuvadisTranscriptExpr::counts
geuv_genotypes <- GeuvadisTranscriptExpr::genotypes
geuv_gene_ranges <- GeuvadisTranscriptExpr::gene_ranges
geuv_snp_ranges <- GeuvadisTranscriptExpr::snp_ranges

colnames(geuv_counts)[c(1,2)] <- c("feature_id", "gene_id")
colnames(geuv_genotypes)[4] <- "snp_id"
geuv_samples <- data.frame(sample_id = colnames(geuv_counts)[-c(1,2)])

d <- dmSQTLdata(counts = geuv_counts, gene_ranges = geuv_gene_ranges,  
  genotypes = geuv_genotypes, snp_ranges = geuv_snp_ranges, 
  samples = geuv_samples, window = 5e3)

# --------------------------------------------------------------------------
# sQTL analysis - simple group comparison
# --------------------------------------------------------------------------

## Filtering
d <- dmFilter(d, min_samps_gene_expr = 70, min_samps_feature_expr = 5,
  minor_allele_freq = 5, min_gene_expr = 10, min_feature_expr = 10)
  
plotData(d)

## To make the analysis reproducible
set.seed(123)
## Calculate precision
d <- dmPrecision(d)

plotPrecision(d)

## Fit full model proportions
d <- dmFit(d)
}
}
\seealso{
\code{\linkS4class{dmSQTLdata}}, 
  \code{\linkS4class{dmSQTLprecision}}, \code{\linkS4class{dmSQTLtest}}
}
\author{
Malgorzata Nowicka
}
