% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitsort.R
\name{bitsort}
\alias{bitsort}
\title{Low-level sorting: bit sort}
\usage{
bitsort(x, na.last = NA, depth = 1)
}
\arguments{
\item{x}{an integer vector}

\item{na.last}{\code{NA} removes NAs, \code{FALSE} puts NAs at the beginning,
\code{TRUE} puts NAs at the end}

\item{depth}{an integer scalar giving the number of bit-passed before switching to
quicksort}
}
\value{
a sorted vector
}
\description{
In one pass over the vector \code{NA}s are handled according to parameter
\code{na.last} by \code{\link[=range_sortna]{range_sortna()}}, then, if the vector is unsorted,
bit sort is invoked.
}
\examples{
bitsort(c(2L, 0L, 1L, NA, 2L))
bitsort(c(2L, 0L, 1L, NA, 2L), na.last=TRUE)
bitsort(c(2L, 0L, 1L, NA, 2L), na.last=FALSE)
}
