% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_summarise_by}
\alias{ggally_summarise_by}
\alias{weighted_median_iqr}
\alias{weighted_mean_sd}
\title{Summarize a continuous variable by each value of a discrete variable}
\usage{
ggally_summarise_by(
  data,
  mapping,
  text_fn = weighted_median_iqr,
  text_fn_vertical = NULL,
  ...
)

weighted_median_iqr(x, weights = NULL)

weighted_mean_sd(x, weights = NULL)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{text_fn}{function that takes an x and weights and returns a text string}

\item{text_fn_vertical}{function that takes an x and weights and returns a text string, used when \code{x} is discrete and \code{y} is continuous. If not provided, will use \code{text_fn}, replacing spaces by carriage returns.}

\item{...}{other arguments passed to \code{\link[ggplot2]{geom_text}(...)}}

\item{x}{a numeric vector}

\item{weights}{an optional numeric vectors of weights. If \code{NULL}, equal weights of 1 will be taken into account.}
}
\description{
Display summary statistics of a continuous variable for each value of a discrete variable.
}
\details{
\code{weighted_median_iqr} computes weighted median and interquartile range.

\code{weighted_mean_sd} computes weighted mean and standard deviation.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

if (require(Hmisc)) {
  data(tips)
  p_(ggally_summarise_by(tips, mapping = aes(x = total_bill, y = day)))
  p_(ggally_summarise_by(tips, mapping = aes(x = day, y = total_bill)))

  # colour is kept only if equal to the discrete variable
  p_(ggally_summarise_by(tips, mapping = aes(x = total_bill, y = day, color = day)))
  p_(ggally_summarise_by(tips, mapping = aes(x = total_bill, y = day, color = sex)))
  p_(ggally_summarise_by(tips, mapping = aes(x = day, y = total_bill, color = day)))

  # custom text size
  p_(ggally_summarise_by(tips, mapping = aes(x = total_bill, y = day), size = 6))

  # change statistic to display
  p_(ggally_summarise_by(tips, mapping = aes(x = total_bill, y = day), text_fn = weighted_mean_sd))

  # custom stat function
  weighted_sum <- function(x, weights = NULL) {
    if (is.null(weights)) weights <- 1
    paste0("Total : ", round(sum(x * weights, na.rm = TRUE), digits = 1))
  }
  p_(ggally_summarise_by(tips, mapping = aes(x = total_bill, y = day), text_fn = weighted_sum))
}
}
\author{
Joseph Larmarange
}
\keyword{hplot}
