% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_key_hexagon.r
\name{draw_key_hexagon}
\alias{draw_key_hexagon}
\title{Draw a Hexagon}
\usage{
draw_key_hexagon(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A hexagonal \code{\link[grid]{polygonGrob}}.
}
\description{
The default legend key drawing function for \code{\link{stat_summaries_hex}}.
This function can be used as \code{key_glyph} parameter by any layer.
}
\examples{
library(ggplot2)
ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
  geom_hex(key_glyph = 'hexagon') +
  guides(fill = 'legend')

}
\seealso{
The legend key drawing functions built into ggplot:
\code{\link[ggplot2]{draw_key}}.
}
