% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop1.R
\name{drop1.lmerModLmerTest}
\alias{drop1.lmerModLmerTest}
\title{Drop Marginal Terms from Model}
\usage{
\method{drop1}{lmerModLmerTest}(
  object,
  scope,
  ddf = c("Satterthwaite", "Kenward-Roger", "lme4"),
  force_get_contrasts = FALSE,
  ...
)
}
\arguments{
\item{object}{an \code{\link{lmer}} model fit (of class
\code{"lmerModLmerTest"}.)}

\item{scope}{optional character vector naming terms to be dropped from the
model. Note that only marginal terms can be dropped. To see which terms are
marginal, use \code{drop.scope(terms(object))}.}

\item{ddf}{the method for computing the denominator degrees of freedom and
F-statistics. \code{ddf="Satterthwaite"} (default) uses Satterthwaite's method;
\code{ddf="Kenward-Roger"} uses Kenward-Roger's method.
\code{ddf = "lme4"} returns the \code{drop1} table for \code{merMod} objects
as defined in package \pkg{lme4}.}

\item{force_get_contrasts}{enforce computation of contrast matrices by a
method in which the design matrices for full and restricted models are
compared.}

\item{...}{currently not used.}
}
\value{
An anova-like table with F-tests of marginal terms.
}
\description{
Computes the F-test for all marginal terms, i.e. terms that can be dropped
from the model while respecting the hierarchy of terms in the model.
}
\details{
Simple marginal contrasts are used for all marginal terms unless the design
matrix is rank deficient. In that case (and if \code{force_get_contrasts} is
\code{TRUE}) the contrasts (i.e. restriction matrices on the design matrix
of the full model) are computed by comparison of the design matrices
for full and restricted models. The set of marginal terms considered for
dropping are computed using \code{drop.scope(terms(object))}.

Since all tests are based on tests of contrasts in the full model, no
models are being (re)fitted.
}
\examples{

# Basic usage:
fm <- lmer(angle ~ recipe + temp + (1|recipe:replicate), cake)
drop1(fm) # Using Satterthwaite degrees of freedom
if(requireNamespace("pbkrtest", quietly = TRUE))
  drop1(fm, ddf="Kenward-Roger") # Alternative DenDF and F-test method
drop1(fm, ddf="lme4", test="Chi") # Asymptotic Likelihood ratio tests

# Consider a rank-deficient design matrix:
fm <- lmer(angle ~ recipe + temp + temperature + (1|recipe:replicate), cake)
# Here temp accounts for the linear effect of temperature, and
# temperature is an (ordered) factor that accounts for the remaining
# variation between temperatures (4 df).
drop1(fm)
# While temperature is in the model, we cannot test the effect of dropping
# temp. After removing temperature we can test the effect of dropping temp:
drop1(lmer(angle ~ recipe + temp + (1|recipe:replicate), cake))

# Polynomials:
# Note that linear terms should usually not be dropped before squared terms.
# Therefore 'Days' should not be dropped before 'I(Days^2)' despite it being
# tested here:
fm <- lmer(Reaction ~ Days + I(Days^2) + (Days|Subject), sleepstudy)
drop1(fm)
# Using poly() provides a test of the whole polynomial structure - not a
# separate test for the highest order (squared) term:
fm <- lmer(Reaction ~ poly(Days, 2) + (Days|Subject), sleepstudy)
drop1(fm)

}
\seealso{
\code{\link{ranova}} for tests of marginal random terms.
}
\author{
Rune Haubo B. Christensen
}
