% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appenders.R
\name{appender_async}
\alias{appender_async}
\title{Delays executing the actual appender function to the future in a
background process to avoid blocking the main R session}
\usage{
appender_async(
  appender,
  namespace = "async_logger",
  init = function() log_info("Background process started")
)
}
\arguments{
\item{appender}{a \code{\link[=log_appender]{log_appender()}} function with a \code{generator}
attribute (TODO note not required, all fn will be passed if
not)}

\item{namespace}{\code{logger} namespace to use for logging messages on
starting up the background process}

\item{init}{optional function to run in the background process that
is useful to set up the environment required for logging, eg if
the \code{appender} function requires some extra packages to be
loaded or some environment variables to be set etc}
}
\value{
function taking \code{lines} argument
}
\description{
Delays executing the actual appender function to the future in a
background process to avoid blocking the main R session
}
\note{
This functionality depends on the \pkg{mirai} package.
}
\examples{
\dontrun{
appender_file_slow <- function(file) {
  force(file)
  function(lines) {
    Sys.sleep(1)
    cat(lines, sep = "\n", file = file, append = TRUE)
  }
}

## log what's happening in the background
log_threshold(TRACE, namespace = "async_logger")
log_appender(appender_console, namespace = "async_logger")

## start async appender
t <- tempfile()
log_info("Logging in the background to {t}")

## use async appender
log_appender(appender_async(appender_file_slow(file = t)))
log_info("Was this slow?")
system.time(for (i in 1:25) log_info(i))

readLines(t)
Sys.sleep(10)
readLines(t)

}
}
\seealso{
Other log_appenders: 
\code{\link{appender_console}()},
\code{\link{appender_file}()},
\code{\link{appender_kinesis}()},
\code{\link{appender_pushbullet}()},
\code{\link{appender_slack}()},
\code{\link{appender_stdout}()},
\code{\link{appender_syslog}()},
\code{\link{appender_tee}()},
\code{\link{appender_telegram}()}
}
\concept{log_appenders}
