% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{composite}
\alias{composite}
\alias{image_composite}
\alias{image_border}
\alias{image_frame}
\alias{image_shadow_mask}
\alias{image_shadow}
\alias{image_shade}
\title{Image Composite}
\usage{
image_composite(
  image,
  composite_image,
  operator = "atop",
  offset = "+0+0",
  gravity = "northwest",
  compose_args = ""
)

image_border(image, color = "lightgray", geometry = "10x10", operator = "copy")

image_frame(image, color = "lightgray", geometry = "25x25+6+6")

image_shadow_mask(image, geometry = "50x10+30+30")

image_shadow(
  image,
  color = "black",
  bg = "none",
  geometry = "50x10+30+30",
  operator = "copy",
  offset = "+20+20"
)

image_shade(image, azimuth = 30, elevation = 30, color = FALSE)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{composite_image}{composition image}

\item{operator}{string with a
\href{https://www.imagemagick.org/Magick++/Enumerations.html#CompositeOperator}{composite operator}
from \link[=compose_types]{compose_types()}}

\item{offset}{string with either a \link[=gravity_types]{gravity_type} or a \link{geometry_point}
to set position of top image.}

\item{gravity}{string with
\href{https://www.imagemagick.org/Magick++/Enumerations.html#GravityType}{gravity}
value from \link{gravity_types}.}

\item{compose_args}{additional arguments needed for some composite operations}

\item{color}{Set to true to shade the red, green, and blue components of the image.}

\item{geometry}{a \href{https://www.imagemagick.org/Magick++/Geometry.html}{geometry string}
to set height and width of the border, e.g. \code{"10x8"}. In addition \link{image_frame} allows
for adding shadow by setting an offset e.g. \code{"20x10+7+2"}.}

\item{bg}{background color}

\item{azimuth}{position of light source}

\item{elevation}{position of light source}
}
\description{
Similar to the ImageMagick \code{composite} utility: compose an image on top of another one using a
\href{https://www.imagemagick.org/Magick++/Enumerations.html#CompositeOperator}{CompositeOperator}.
}
\details{
The \code{image_composite} function is vectorized over both image arguments: if the first image has
\code{n} frames and the second \code{m} frames, the output image will contain \code{n} * \code{m} frames.

The \link{image_border} function creates a slightly larger solid color frame and then composes the
original frame on top. The \link{image_frame} function is similar but has an additional feature to
create a shadow effect on the border (which is really ugly).
}
\examples{
# Compose images using one of many operators
imlogo <- image_scale(image_read("logo:"), "x275")
rlogo <- image_read("https://jeroen.github.io/images/Rlogo-old.png")

# Standard is atop
image_composite(imlogo, rlogo)

# Same as 'blend 50' in the command line
image_composite(imlogo, rlogo, operator = "blend", compose_args="50")

# Offset can be geometry or gravity
image_composite(logo, rose, offset = "+100+100")
image_composite(logo, rose, gravity = "East")

# Add a border frame around the image
image_border(imlogo, "red", "10x10")
image_frame(imlogo)
image_shadow(imlogo)
image_shade(imlogo)
}
\seealso{
Other image: 
\code{\link{_index_}},
\code{\link{analysis}},
\code{\link{animation}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{defines}},
\code{\link{device}},
\code{\link{edges}},
\code{\link{editing}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{morphology}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{painting}},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
