% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merData.R
\name{findFormFuns}
\alias{findFormFuns}
\title{\code{findFormFuns} used by \link[merTools]{averageObs} to calculate proper
averages}
\usage{
findFormFuns(merMod, origData = NULL)
}
\arguments{
\item{merMod}{the merMod object from which to draw the average observation}

\item{origData}{(default=NULL) a data frame containing the original,
untransformed data used to call the model. This MUST be specified if
the original variables used in formula function calls are NOT present
as 'main effects'.}
}
\value{
a data frame with a single row for the average observation, but with full
factor levels. See details for more.
}
\description{
The purpose is to properly derive data for the average observation in the
data by being 'aware' of formulas that contain interactions and/or function
calls. For example, in the old behavior, if the formula contained a square
term specified as \code{I(x^2)}, we were returning the mean of \code{x(^2)} not the
square of mean(x).
}
