% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_rank.R
\name{window_rank}
\alias{window_rank}
\alias{cume_dist}
\alias{dense_rank}
\alias{min_rank}
\alias{ntile}
\alias{percent_rank}
\alias{row_number}
\title{Windowed Rank Functions}
\usage{
cume_dist(x)

dense_rank(x)

min_rank(x)

ntile(x = row_number(), n)

percent_rank(x)

row_number(x)
}
\arguments{
\item{x}{A vector of values to rank. Missing values are left as is. If you want to treat them as the smallest or
largest values, replace with \code{Inf} or \code{-Inf} before ranking.}

\item{n}{\code{integer(1)}. The number of groups to split up into.}
}
\description{
Six variations on ranking functions, mimicking the ranking functions described in SQL2003. They are currently
implemented using the built in \code{\link[=rank]{rank()}} function. All ranking functions map smallest inputs to smallest outputs. Use
\code{desc()} to reverse the direction.
}
\details{
\itemize{
\item \code{cume_dist()}: a cumulative distribution function. Proportion of all values less than or equal to the current rank.
\item \code{dense_rank()}: like \code{min_rank()}, but with no gaps between ranks
\item \code{min_rank()}: equivalent to \code{rank(ties.method = "min")}
\item \code{ntile()}: a rough rank, which breaks the input vector into \code{n} buckets. The size of the buckets may differ by up
to one, larger buckets have lower rank.
\item \code{percent_rank()}: a number between \code{0} and \code{1} computed by rescaling \code{min_rank} to \verb{[0, 1]}
\item \code{row_number()}: equivalent to \code{rank(ties.method = "first")}
}
}
\examples{
x <- c(5, 1, 3, 2, 2, NA)
row_number(x)
min_rank(x)
dense_rank(x)
percent_rank(x)
cume_dist(x)

ntile(x, 2)
ntile(1:8, 3)

# row_number can be used with single table verbs without specifying x
# (for data frames and databases that support windowing)
mutate(mtcars, row_number() == 1L)
mtcars \%>\% filter(between(row_number(), 1, 10))

}
