% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-last.R
\name{last_warnings}
\alias{last_warnings}
\alias{last_messages}
\title{Display last messages and warnings}
\usage{
last_warnings(n = NULL)

last_messages(n = NULL)
}
\arguments{
\item{n}{How many warnings or messages to display. Defaults to all.}
}
\description{
\code{last_warnings()} and \code{last_messages()} return a list of all
warnings and messages that occurred during the last R command.

\code{\link[=global_entrace]{global_entrace()}} must be active in order to log the messages and
warnings.

By default the warnings and messages are printed with a simplified
backtrace, like \code{\link[=last_error]{last_error()}}. Use \code{summary()} to print the
conditions with a full backtrace.
}
\section{Examples}{


Enable backtrace capture with \code{global_entrace()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{global_entrace()
}\if{html}{\out{</div>}}

Signal some warnings in nested functions. The warnings inform about
which function emitted a warning but they don't provide information
about the call stack:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{f <- function() \{ warning("foo"); g() \}
g <- function() \{ warning("bar", immediate. = TRUE); h() \}
h <- function() warning("baz")

f()
#> Warning in g() : bar
#> Warning messages:
#> 1: In f() : foo
#> 2: In h() : baz
}\if{html}{\out{</div>}}

Call \code{last_warnings()} to see backtraces for each of these warnings:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{last_warnings()
#> [[1]]
#> <warning/rlang_warning>
#> Warning in `f()`:
#> foo
#> Backtrace:
#>     x
#>  1. \\-global f()
#>
#> [[2]]
#> <warning/rlang_warning>
#> Warning in `g()`:
#> bar
#> Backtrace:
#>     x
#>  1. \\-global f()
#>  2.   \\-global g()
#>
#> [[3]]
#> <warning/rlang_warning>
#> Warning in `h()`:
#> baz
#> Backtrace:
#>     x
#>  1. \\-global f()
#>  2.   \\-global g()
#>  3.     \\-global h()
}\if{html}{\out{</div>}}

This works similarly with messages:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{f <- function() \{ inform("Hey!"); g() \}
g <- function() \{ inform("Hi!"); h() \}
h <- function() inform("Hello!")

f()
#> Hey!
#> Hi!
#> Hello!

rlang::last_messages()
#> [[1]]
#> <message/rlang_message>
#> Message:
#> Hey!
#> ---
#> Backtrace:
#>     x
#>  1. \\-global f()
#>
#> [[2]]
#> <message/rlang_message>
#> Message:
#> Hi!
#> ---
#> Backtrace:
#>     x
#>  1. \\-global f()
#>  2.   \\-global g()
#>
#> [[3]]
#> <message/rlang_message>
#> Message:
#> Hello!
#> ---
#> Backtrace:
#>     x
#>  1. \\-global f()
#>  2.   \\-global g()
#>  3.     \\-global h()
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=last_error]{last_error()}}
}
