RabbitMQ `3.9.27` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 24.2, and supports Erlang 25. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 support has reached its [end of support](https://www.rabbitmq.com/which-erlang.html).

Starting with this release, RabbitMQ requires Erlang 24.2 or later versions. Nodes **will fail to start** on older Erlang releases.

## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).

### Core Server

#### Enhancements

 * Free disk space monitor robustness improvements.

   Backported by @drencrom (Canonical).

   GitHub issue: [#5739](https://github.com/rabbitmq/rabbitmq-server/pull/5739)

 * `raft.adaptive_failure_detector.poll_interval` exposes [`aten`]()'s `poll_interval` setting to
   RabbitMQ users. Increasing it can reduce the probability of false positives in clusters where
   inter-node communication links are used at close to maximum capacity.
   The default is `5000` (5 seconds).

   GitHub issue: [#6632](https://github.com/rabbitmq/rabbitmq-server/pull/6632)

 * When both `disk_free_limit.relative` and `disk_free_limit.absolute`,
   or both `vm_memory_high_watermark.relative` and `vm_memory_high_watermark.absolute` are set,
   the absolute settings will now take precedence.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#4980](https://github.com/rabbitmq/rabbitmq-server/issues/4980)

#### Bug Fixes

 * Classic queues with [Single Active Consumer](https://www.rabbitmq.com/consumers.html#single-active-consumer) enabled could run into an exception.

   GitHub issue: [#6513](https://github.com/rabbitmq/rabbitmq-server/pull/6513)

 * When a [global parameter](https://www.rabbitmq.com/parameters.html#parameter-management) was cleared,
   nodes emitted an [internal event](https://www.rabbitmq.com/logging.html#internal-events) of the wrong type.

   GitHub issue: [#6540](https://github.com/rabbitmq/rabbitmq-server/pull/6540)


### CLI Tools

#### Enhancements

 * New key supported by `rabbitmqctl list_queues`: `effective_policy_definition` that returns
   merged definitions of regular and [operator policies](https://www.rabbitmq.com/parameters.html#operator-policies) effective for the queue.

   GitHub issue: [#6556](https://github.com/rabbitmq/rabbitmq-server/pull/6556)


### Management Plugin

#### Enhancements

 * New HTTP API endpoint, `GET /api/config/effective`, returns effective node configuration.
   This is an HTTP API counterpart of `rabbitmq-diagnostics environment`.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#6016](https://github.com/rabbitmq/rabbitmq-server/issues/6016)

## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.27.tar.xz`
instead of the source tarball produced by GitHub.
