// generated by Fast Light User Interface Designer (fluid) version 1.0109

#include "rakarrack.h"
#include "icono_rakarrack_128x128.xpm"
static Fl_Tiled_Image *back; 
static Fl_Color leds_color; 
static Fl_Color back_color; 
static Fl_Color fore_color; 
static Fl_Color label_color; 
static Fl_Widget *old; 
static float *spl; 
static float *spr; 
static int last_tecla; 
static int drag; 
static int sr; 
static int ns; 
static int at; 
static int nt; 
static int tta; 
static int Scope_ON; 
static int Analyzer_ON; 

Analyzer::Analyzer(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
}

void Analyzer::init(float *smpsl, float *smpsr, int PERIOD, int SAMPLERATE) {
  spl = smpsl;
spr = smpsr;
ns = PERIOD;
sr = SAMPLERATE;
}

void Analyzer::draw() {
  int ox=x(),oy=y(),lx=w(),ly=h();
int i,j;
int px,py,hy;
double y=0.0;
double t=0.0;
double nsp = 1.0 / (double) ns;
double dsr = (double) sr;
double udsr = 1.0 / dsr;
double acoeff= udsr/(0.005+udsr);
double image=0.0;
double oldimage =0.0;
double factor = (double) ns / 64.0;
char buf[4];
double xscale[] = {22.0,31.0,39.0,62.0,79.0,125.0,158.0,200.0,251.0,317.0,400.0,503.0,634.0,800.0,1000.0,1200.0,1500.0,2000.0,2500.0,3200.0,4000.0,5000.0,6000.0,8000.0,10000.0,12000.0,16000.0,20000.0};

memset(buf,0, sizeof(buf));


px = (lx-22) / 29;
hy = ly;

double scale = (double) ly ;


if (Analyzer_ON)
{

//Draw Response  
// draw_box(FL_FLAT_BOX,ox,oy,lx,ly,back_color);

fl_draw(buf, ox, oy, lx, ly, FL_ALIGN_CLIP ,back);

    
fl_color(leds_color);

for(i=0; i<28; i++)
{
      y = 0.0;
      double coeff = xscale[i]*udsr;

      for(j=0; j<ns; j++)
      {
                   
       t = cos(D_PI * (double) j * coeff);
       image = t * spl[j];
       oldimage = acoeff*image + ( 1.0 - acoeff) * oldimage;

       y += fabs(oldimage);
      }
       
      y = sqrt((double) i * y * nsp * factor); 
      // y=sqrt(y*nsp*factor);   
     
      if (y<0.0) y=0.0;
      if (y>1.0) y=1.0;     
                  
      py = lrint(y*scale); 
            
      
      fl_color(leds_color);
      fl_rectf(px+ox+px*i+4,oy+ly-py,px-2,py);

} 
 
 
}

else
{
draw_box(box(),ox,oy,lx,ly,back_color);
draw_label();
}
}

int Analyzer::handle(int event) {
  if ((event==FL_PUSH)||(event==FL_DRAG)||(event==FL_RELEASE)) {

switch(event)
{
case FL_RELEASE:

if(Analyzer_ON) 
{
Analyzer_ON=0; 
at=0;
tta=1;
}
return(1);
break;
}
}
return(0);
}

Scope::Scope(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
}

void Scope::init(float *smpsl, float *smpsr, int PERIOD) {
  spl = smpsl;
spr = smpsr;
ns = PERIOD;
}

void Scope::draw() {
  int ox=x(),oy=y(),lx=w(),ly=h();
int i;
int Xl,Xr,Yl,Yr;
int SW,SH;
int px,py,old_px,old_py,oldr_px,oldr_py;
int posx;
double pP = (double) ns; 
double value=0.0;

SW=lx/2-5;
SH=ly;

Xl=ox;
Yl=oy+ly/2;


Xr=ox+SW+5;
Yr=Yl;


double dSW = (double) SW;
double coeff = 1.0 / pP * dSW;



if (Scope_ON)
{

//Draw Curve Reponse  
 


back->draw(ox,oy);

fl_color(leds_color);


old_px = Xl;
old_py = Yl;
oldr_px = Xr;
oldr_py = Yr;

for(i=0; i<ns; i++)
{
  posx = (int) ((double) i * coeff);

  value=spr[i];
  if (value>1.0) value=1.0;
  if (value<-1.0) value=-1.0;
  

  px = Xl + posx;
  py = Yl + lrint(value * .5 * SH);
   
  // printf("%d %d %d\n",i,px,py);
   

if (i>0) fl_line(old_px, old_py,px,py);
  
  old_px=px; old_py=py;
  
  value=spl[i];
  if (value>1.0) value=1.0;
  if (value<-1.0) value=-1.0;



  px = Xr + posx;
  py = Yr + lrint(value * .5 * SH);
 
if (i>0) fl_line(oldr_px, oldr_py,px,py);

  oldr_px=px; oldr_py=py;
 
 
 }
 
}

else
{
draw_box(box(),ox,oy,lx,ly,back_color);
draw_label();
}
}

int Scope::handle(int event) {
  if ((event==FL_PUSH)||(event==FL_DRAG)||(event==FL_RELEASE)) {

switch(event)
{
case FL_RELEASE:

if(Scope_ON) 
{
Scope_ON=0; 
nt = 1;
}
return(1);
break;
}

}

return(0);
}

NewVum::NewVum(int x,int y, int w, int h, const char *label):Fl_Slider(x,y,w,h,label) {
}

void NewVum::draw_bg(int X, int Y, int W, int H) {
  fl_push_clip(X, Y, W, H);
//  draw_box(FL_THIN_DOWN_BOX,X,Y,W,H,back_color);
back->draw(X,Y);

  fl_pop_clip();

//Fl_Color black = active_r() ? FL_FOREGROUND_COLOR : FL_INACTIVE_COLOR;
}

void NewVum::draw_rest(int X, int Y, int W, int H) {
  int x = X;
int y = Y;
int h = H;
int w = W;
int S,S1,S2,S3;
int ko;
double val;


double fred=.239f;
double fora=.35f;
double fyel=.508f;


    val = 1.0-((value() + 48.0) *.015873016);
    if (val > 1.0) val = 1.0;
    else if (val < 0.0) val = 0.0;
  
  
   S = h - lrint(val*h+.5); 
  
   S1 = h - lrint(fred*(double)h+.5f);
   S2 = h - lrint(fora*(double)h+.5f); 
   S3 = h - lrint(fyel*(double)h+.5f);
 

    draw_bg(X, Y, W, H);
 
 ko=H+Y-S;

 if (val < fred)  
  {
  
   
  
  fl_color(fl_darker(FL_RED)); 
  fl_rectf(x+1,h+y-S,3,S-S1);
  fl_color(FL_RED); 
  fl_rectf(x+4,h+y-S,w-7,S-S1); 
  fl_color(fl_darker(FL_RED)); 
  fl_rectf(x+w-3,h+y-S,2,S-S1);
 
   S=S1;
  }   
  
 if (val < fora)  
  {
   
   
 
 
 fl_color(fl_darker((Fl_Color) 93)); 
  fl_rectf(x+1,h+y-S,3,S-S2);
  fl_color((Fl_Color)93); 
  fl_rectf(x+4,h+y-S,w-7,S-S2); 
 fl_color(fl_darker((Fl_Color)93)); 
  fl_rectf(x+w-3,h+y-S,2,S-S2);
 
   S=S2;
  }       

  if (val < fyel)  
  {
  
  
  
  fl_color(fl_darker(FL_YELLOW)); 
  fl_rectf(x+1,h+y-S,3,S-S3);
  fl_color(FL_YELLOW); 
  fl_rectf(x+4,h+y-S,w-7,S-S3); 
  fl_color(fl_darker(FL_YELLOW)); 
  fl_rectf(x+w-3,h+y-S,2,S-S3);
  
  
   S=S3;
  }   
   
  
  fl_color(fl_darker(FL_GREEN)); 
  fl_rectf(x+1,h+y-S,3,S);
  fl_color(FL_GREEN); 
  fl_rectf(x+4,h+y-S,w-7,S); 
  fl_color(fl_darker(FL_GREEN)); 
  fl_rectf(x+w-3,h+y-S,2,S);
  
 
if (val < 1.0)
 {
 fl_color(FL_BLACK);
   
 for(int i=H+Y-4;i>ko;i=i-4)   
  fl_line(x, i, x+w-1,i);
  
}
}

void NewVum::draw() {
  if (damage()&FL_DAMAGE_ALL) draw_box();


  draw_rest(x()+Fl::box_dx(box()),
       y()+Fl::box_dy(box()),
       w()-Fl::box_dw(box()),
       h()-Fl::box_dh(box()));
}

int NewVum::handle(int event) {
  switch(event)
{
case FL_SHOW:
             
             
case FL_HIDE:
             

case FL_RELEASE:

{
return 0;
}


case FL_DRAG: 
{
return 0;
}

case FL_SHORTCUT:
return 0;

default:
return 0;
}

return 1;
}

TunerLed::TunerLed(int x,int y, int w, int h, const char *label):Fl_Slider(x,y,w,h,label) {
}

void TunerLed::draw_bg(int X, int Y, int W, int H) {
  fl_push_clip(X, Y, W, H);
 // draw_box(FL_THIN_DOWN_BOX,X,Y,W,H,back_color);
 
 back->draw(X,Y);
  fl_pop_clip();

//Fl_Color black = active_r() ? FL_FOREGROUND_COLOR : FL_INACTIVE_COLOR;
}

void TunerLed::draw_rest(int X, int Y, int W, int H) {
  int x = X;
int y = Y;
int h = H;
int w = W;
double val;

   val = (float)(value()-minimum())/(maximum()-minimum());
   if (val > 1.0) val = 1.0;
   else if (val < 0.0) val = 0.0;
  
  
  int S = (int)((double)w*val);  
 
  
  draw_bg(X, Y, W, H);
 
   
   
  if ((val > .1) && (val < .9))
  {
  fl_color(fl_lighter(FL_RED)); 
  fl_rectf(x+S-3,y+2,7,h-4);
  
  
  }
}

void TunerLed::draw() {
  if (damage()&FL_DAMAGE_ALL) draw_box();


  draw_rest(x()+Fl::box_dx(box()),
       y()+Fl::box_dy(box()),
       w()-Fl::box_dw(box()),
       h()-Fl::box_dh(box()));
}

int TunerLed::handle(int event) {
  switch(event)
{
case FL_SHOW:
             
             
case FL_HIDE:
             

case FL_RELEASE:

{
return 0;
}


case FL_DRAG: 
{
return 0;
}

case FL_SHORTCUT:
return 0;

default:
return 0;
}

return 1;
}

SliderW::SliderW(int x,int y, int w, int h, const char *label):Fl_Value_Slider(x,y,w,h,label) {
}

int SliderW::handle(int event) {
  if (event == FL_PUSH && Fl::visible_focus()) {
    Fl::focus(this);
    redraw();
}  
  
  int sxx = x(), syy = y(), sww = w(), shh = h();
  
  if (horizontal()) {
    sxx += 35; sww -= 35;
  } else {
    syy += 25; shh -= 25;
 }
  
 
  
 return handle2(event,
                  sxx+Fl::box_dx(box()),
                  syy+Fl::box_dy(box()),
                  sww-Fl::box_dw(box()),
                  shh-Fl::box_dh(box()));
}

int SliderW::handle2(int event, int X, int Y, int W, int H) {
  int mul=1;
switch (event) {
  case FL_PUSH:
    if (!Fl::event_inside(X, Y, W, H)) return 0;
     handle_push();
  case FL_DRAG: {
    if(Fl::event_button()==3) return 1;
    double val;
    if (minimum() == maximum())
      val = 0.5;
    else {
      val = (value()-minimum())/(maximum()-minimum());
      if (val > 1.0) val = 1.0;
      else if (val < 0.0) val = 0.0;
    }

    int ww = (horizontal() ? W : H);
    int mx = (horizontal() ? Fl::event_x()-X : Fl::event_y()-Y);
    int S=0;
    static int offcenter;

   
      S = int(0*ww+.5); if (S >= ww) return 0;
      int T = (horizontal() ? H : W)/2+1;
      T += 4;
      if (S < T) S = T;
      if (event == FL_PUSH) {
       int xx = int(val*(ww-S)+.5);
      
        offcenter = mx-xx;
        if (offcenter < 0) offcenter = 0;
        else if (offcenter > S) offcenter = S;
        else return 1;
      }
    

    int xx = mx-offcenter;
    double v;
    char tryAgain = 1;
    while (tryAgain)
    {
      tryAgain = 0;
      if (xx < 0) {
        xx = 0;
        offcenter = mx; if (offcenter < 0) offcenter = 0;
      } else if (xx > (ww-S)) {
        xx = ww-S;
        offcenter = mx-xx; if (offcenter > S) offcenter = S;
      }
        v = round(xx*(maximum()-minimum())/(ww-S) + minimum());
        
        
        // make sure a click outside the sliderbar moves it:
      if (event == FL_PUSH && v == value()) {
        offcenter = S/2;
        event = FL_DRAG;
        tryAgain = 1;
      }
    }


   handle_drag(clamp(v));
    } return 1;
 
    case FL_MOUSEWHEEL :
  
      if (Fl::e_dy==0) return 0;
      handle_push();
      handle_drag(clamp(increment(value(),Fl::e_dy)));
      handle_release();
      return 1;
    
 
  case FL_RELEASE:
    
    handle_release();
    return 1;
  case FL_KEYBOARD :
       if (Fl::event_state(FL_SHIFT)) mul=10; else 
       if (Fl::event_state(FL_CTRL)) mul=100; else
       mul = 1;
        
      switch (Fl::event_key()) {
      case FL_Up:
        if (horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),-1*mul)));
        handle_release();
        return 1;
      case FL_Down:
        if (horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),1*mul)));
        handle_release();
        return 1;
      case FL_Left:
        if (!horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),-1*mul)));
        handle_release();
        return 1;
      case FL_Right:
        if (!horizontal()) return 0;
        handle_push();
        handle_drag(clamp(increment(value(),1*mul)));
        handle_release();
        return 1;
      default:
        return 0;
    }
    // break not required because of switch...
  case FL_FOCUS :
  case FL_UNFOCUS :
    if (Fl::visible_focus()) {
      redraw();
      return 1;
    } else return 0;
  case FL_ENTER :
  case FL_LEAVE :
    return 1;
  default:
    return 0;
  }
}

void SliderW::draw() {
  int X,Y,W,H;
int sxx = x(), syy = y(), sww = w(), shh = h();
int bxx = x(), byy = y(), bww = w(), bhh = h();
when(FL_WHEN_RELEASE_ALWAYS | FL_WHEN_CHANGED);
 
  if (horizontal()) {
    bww = 35; sxx += 35; sww -= 35;
  } else {
    syy += 25; bhh = 25; shh -= 25;
  }
 

//  if (damage()&FL_DAMAGE_ALL) draw_box(box(),sxx,syy,sww,shh,back_color);

                  X=sxx+Fl::box_dx(box());
                  Y=syy+Fl::box_dy(box());
                  W=sww-Fl::box_dw(box());
                  H=shh-Fl::box_dh(box());
 
 
 
 
  double val;
  if (minimum() == maximum())
    val = 0.5;
  else {
    val = (value()-minimum())/(maximum()-minimum());
    if (val > 1.0) val = 1.0;
    else if (val < 0.0) val = 0.0;
  }

 int ww = (horizontal() ? W : H);
  int xx, S;

    S = int(.25*ww+.5)+1;
    int T = (horizontal() ? H : W)/2+1;
    T += 12;
    
   
    xx = int(val*(ww-S)+.5);
  
  int xsl, ysl, wsl, hsl;
  if (horizontal()) {
    xsl = X+xx;
    wsl = S-4;
    ysl = Y;
    hsl = H-1;
  } else {
    ysl = Y+xx;
    hsl = S;
    xsl = X;
    wsl = W-1;
  }


  fl_push_clip(X, Y, W, H);
  back->draw(X,Y);
  fl_pop_clip();

  Fl_Color black = active_r() ? FL_FOREGROUND_COLOR : FL_INACTIVE_COLOR;
 
  if (type() == FL_VERT_NICE_SLIDER)
   {
    draw_box(FL_THIN_DOWN_BOX, X+W/2-2, Y, 4, H, black);
   } 
   else 
   if (type() == FL_HOR_NICE_SLIDER)
    {
     draw_box(FL_THIN_DOWN_BOX, X, Y+H/2-2, W-4, 4, black);
    }
 
 
 //Line to the knob --- I dont like 

/*
 
 if (type() == FL_VERT_NICE_SLIDER) {
   draw_box(FL_THIN_DOWN_BOX, X+W/2-2, ysl, 3,Y+H-ysl , fl_darker(leds_color));
  }
  else
  {
    draw_box(FL_THIN_DOWN_BOX, X, Y+H/2-2,xsl-X,3, fl_darker(leds_color));
  }  
  
*/  
  
  
  Fl_Color juan,pepe,luis;
  float vval=fabsf((float)val);
  
  juan = fl_color_average(fl_darker(fl_darker(leds_color)),fl_lighter(fl_lighter(leds_color)),vval);
  pepe = fl_color_average(fl_lighter(fl_lighter(leds_color)),fl_darker(fl_darker(leds_color)),vval);

 Fl_Boxtype box1 = slider();

  if (!box1) 
  {
  box1 = (Fl_Boxtype)(box()&-2);
  if (!box1) box1 = FL_UP_BOX;
  }
  
  if (type() == FL_VERT_NICE_SLIDER)
   {
     
    draw_box(box1, xsl, ysl, wsl, hsl, fore_color);
    int d = (hsl-6)/2;
   
    draw_box(FL_THIN_DOWN_BOX, xsl+2, ysl+d, wsl-4, hsl-2*d,juan);
   } 
  else 
   if (type() == FL_HOR_NICE_SLIDER)
    {
    draw_box(box1, xsl, ysl, wsl, hsl, fore_color);
    int d = (wsl-6)/2;
    draw_box(FL_THIN_DOWN_BOX, xsl+d, ysl+2, wsl-2*d, hsl-4,pepe);
    }
  
  
  labelcolor(label_color);
  draw_label(xsl, ysl, wsl, hsl);
  
  if (Fl::focus() == this) 
  {
  draw_focus(box1, xsl, ysl, wsl, hsl);
  luis = leds_color;
  }
  else luis = textcolor();
  
/*  if (( Fl::scheme_) && (strcmp(Fl::scheme_, "plastic")==0)) 
  {
  
  
   if (type() == FL_HOR_NICE_SLIDER)
     back->draw(bxx+2,byy);
     
   else
     back->draw(bxx,byy); 
  
   }
   else
    back->draw(bxx,byy);
*/    

  int datasize;
  
  if(labelsize()< 11) datasize = labelsize();
  else datasize = 11;

  char buf[128];
  format(buf);
  fl_font(textfont(), datasize);
  if (( Fl::scheme_) && (strcmp(Fl::scheme_, "plastic")==0)) 
  fl_color(active_r() ? leds_color: fl_inactive(textcolor()));
  else
  fl_color(active_r() ? luis: fl_inactive(textcolor()));
  fl_draw(buf, bxx, byy, bww, bhh, FL_ALIGN_CLIP ,back);
  fl_draw(buf, bxx, byy, bww, bhh, FL_ALIGN_CLIP);
}

void RKRGUI::cb_Principal_i(Fl_Double_Window*, void*) {
  is_modified();
save_stat(0);

Pexitprogram=1;
}
void RKRGUI::cb_Principal(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_Principal_i(o,v);
}

void RKRGUI::cb_Menu_New_i(Fl_Menu_*, void*) {
  S_new->do_callback();
}
void RKRGUI::cb_Menu_New(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Menu_New_i(o,v);
}

void RKRGUI::cb_Load_Preset_i(Fl_Menu_*, void*) {
  L_preset->do_callback();
}
void RKRGUI::cb_Load_Preset(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_Preset_i(o,v);
}

void RKRGUI::cb_Save_Preset_i(Fl_Menu_*, void*) {
  S_preset->do_callback();
}
void RKRGUI::cb_Save_Preset(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_Preset_i(o,v);
}

void RKRGUI::cb_Load_Bank_M_i(Fl_Menu_* o, void*) {
  Load_Bank->do_callback(o);
}
void RKRGUI::cb_Load_Bank_M(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_Bank_M_i(o,v);
}

void RKRGUI::cb_Save_Bank_M_i(Fl_Menu_* o, void*) {
  Save_Bank->do_callback(o);
}
void RKRGUI::cb_Save_Bank_M(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_Bank_M_i(o,v);
}

void RKRGUI::cb_Load_Skin_i(Fl_Menu_*, void*) {
  char *filename;
filename=fl_file_chooser("Load Skin:","(*.rkrs)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkrs");
int last = rkr->relfontsize;
rkr->loadskin(filename);
Put_Skin(last);
}
void RKRGUI::cb_Load_Skin(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_Skin_i(o,v);
}

void RKRGUI::cb_Save_Skin_i(Fl_Menu_*, void*) {
  char *filename;
#define EXT ".rkrs"
filename=fl_file_chooser("Save Skin:","(*"EXT")","",0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,EXT);
#undef EXT

rkr->slabel_color = (int) label_color;
rkr->sback_color = (int) back_color;
rkr->sfore_color = (int) fore_color;
rkr->sleds_color = (int) leds_color;
rkr->sh = (int) Principal->h();
rkr->sschema = scheme_ch->value();


rkr->saveskin(filename);
}
void RKRGUI::cb_Save_Skin(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_Skin_i(o,v);
}

void RKRGUI::cb_Load_MTable_i(Fl_Menu_*, void*) {
  char *filename;
filename=fl_file_chooser("Load MIDI Table:","(*.rmt)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rmt");
rkr->loadmiditable(filename);
Put_MidiTable();
}
void RKRGUI::cb_Load_MTable(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_MTable_i(o,v);
}

void RKRGUI::cb_Save_MTable_i(Fl_Menu_*, void*) {
  char *filename;
#define EXT ".rmt"
filename=fl_file_chooser("Save MIDI Table:","(*"EXT")","",0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,EXT);
#undef EXT
rkr->savemiditable(filename);
}
void RKRGUI::cb_Save_MTable(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_MTable_i(o,v);
}

void RKRGUI::cb_ConvertReverb_i(Fl_Menu_*, void*) {
  char *filename;
char name[64];
memset(name,0, sizeof(name));
sprintf(name,"%s %s",rkr->jackcliname, VERSION);

filename=fl_file_chooser("Convert Reverb IR File:","(*.wav)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".wav");
rkr->ConvertReverbFile(filename);
rkr->Message(1,name, "Please, now use Reverbtron to load the new '.rvb' file");
}
void RKRGUI::cb_ConvertReverb(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ConvertReverb_i(o,v);
}

void RKRGUI::cb_ImportPresets_i(Fl_Menu_*, void*) {
  char *filename;
filename=fl_file_chooser("Import Internal Presets:","(*)",NULL,0);
if (filename==NULL) return;
rkr->MergeIntPreset(filename);
Show_Next_Time();
}
void RKRGUI::cb_ImportPresets(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ImportPresets_i(o,v);
}

void RKRGUI::cb_salir_i(Fl_Menu_*, void*) {
  Principal->do_callback();
}
void RKRGUI::cb_salir(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_salir_i(o,v);
}

void RKRGUI::cb_Bank_Menu_i(Fl_Menu_*, void*) {
  B_preset->do_callback();
}
void RKRGUI::cb_Bank_Menu(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Bank_Menu_i(o,v);
}

void RKRGUI::cb_Ajustes_i(Fl_Menu_*, void*) {
  if(!Settings->visible())
{
MiraClientes();
MiraConfig();
Settings->show();
put_icon(Settings);
}
else
Settings->hide();
}
void RKRGUI::cb_Ajustes(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Ajustes_i(o,v);
}

void RKRGUI::cb_ML_Menu_i(Fl_Menu_*, void*) {
  if(!MIDILearn->visible())
{
rkr->comemouse=0;
PrepareML();
}
else
MIDILearn->hide();
}
void RKRGUI::cb_ML_Menu(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ML_Menu_i(o,v);
}

void RKRGUI::cb_ACI_Menu_i(Fl_Menu_*, void*) {
  if(!Trigger->visible())
{
Trigger->show();
rkr->ACI_Bypass = 1;
put_icon(Trigger);
rkr->old_a_sum = 0.0;
rkr->val_a_sum = 0.0;
}
else
{
Trigger->hide();
rkr->ACI_Bypass = 0;
};
}
void RKRGUI::cb_ACI_Menu(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ACI_Menu_i(o,v);
}

void RKRGUI::cb_Contenido_i(Fl_Menu_*, void*) {
  show_help();
}
void RKRGUI::cb_Contenido(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Contenido_i(o,v);
}

void RKRGUI::cb_Acerca_de_i(Fl_Menu_*, void*) {
  int x,y;

x = Principal->x()+((Principal->w()-420)/2);
y = Principal->y()+((Principal->h()-230)/2);

AboutWin->position(x,y);
AboutWin->show();
put_icon(AboutWin);
}
void RKRGUI::cb_Acerca_de(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Acerca_de_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_MenuP[] = {
 {"&File", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {"New", 0x6e,  (Fl_Callback*)RKRGUI::cb_Menu_New, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Load Preset", 0x6c,  (Fl_Callback*)RKRGUI::cb_Load_Preset, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Save Preset", 0x73,  (Fl_Callback*)RKRGUI::cb_Save_Preset, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Load &Bank", 0,  (Fl_Callback*)RKRGUI::cb_Load_Bank_M, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Save B&ank", 0,  (Fl_Callback*)RKRGUI::cb_Save_Bank_M, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Load S&kin", 0,  (Fl_Callback*)RKRGUI::cb_Load_Skin, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Save Sk&in", 0,  (Fl_Callback*)RKRGUI::cb_Save_Skin, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Load MIDI Table", 0,  (Fl_Callback*)RKRGUI::cb_Load_MTable, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Save MIDI Table", 0,  (Fl_Callback*)RKRGUI::cb_Save_MTable, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Convert Reverb IR File", 0,  (Fl_Callback*)RKRGUI::cb_ConvertReverb, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Import Internal Presets", 0,  (Fl_Callback*)RKRGUI::cb_ImportPresets, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Exit", 0x78,  (Fl_Callback*)RKRGUI::cb_salir, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {"&Bank", 0x62,  (Fl_Callback*)RKRGUI::cb_Bank_Menu, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Settings", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Preferences", 0x69,  (Fl_Callback*)RKRGUI::cb_Ajustes, 0, 128, FL_NORMAL_LABEL, 0, 14, 7},
 {"MIDI Learn", 0x65,  (Fl_Callback*)RKRGUI::cb_ML_Menu, 0, 128, FL_NORMAL_LABEL, 0, 14, 7},
 {"ACI", 0x61,  (Fl_Callback*)RKRGUI::cb_ACI_Menu, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"&Help", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {"Help Contents", 0xffbe,  (Fl_Callback*)RKRGUI::cb_Contenido, 0, 128, FL_NORMAL_LABEL, 0, 14, 7},
 {"About...", 0,  (Fl_Callback*)RKRGUI::cb_Acerca_de, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* RKRGUI::Archivo = RKRGUI::menu_MenuP + 0;
Fl_Menu_Item* RKRGUI::Menu_New = RKRGUI::menu_MenuP + 1;
Fl_Menu_Item* RKRGUI::Load_Preset = RKRGUI::menu_MenuP + 2;
Fl_Menu_Item* RKRGUI::Save_Preset = RKRGUI::menu_MenuP + 3;
Fl_Menu_Item* RKRGUI::Load_Bank_M = RKRGUI::menu_MenuP + 4;
Fl_Menu_Item* RKRGUI::Save_Bank_M = RKRGUI::menu_MenuP + 5;
Fl_Menu_Item* RKRGUI::Load_Skin = RKRGUI::menu_MenuP + 6;
Fl_Menu_Item* RKRGUI::Save_Skin = RKRGUI::menu_MenuP + 7;
Fl_Menu_Item* RKRGUI::Load_MTable = RKRGUI::menu_MenuP + 8;
Fl_Menu_Item* RKRGUI::Save_MTable = RKRGUI::menu_MenuP + 9;
Fl_Menu_Item* RKRGUI::ConvertReverb = RKRGUI::menu_MenuP + 10;
Fl_Menu_Item* RKRGUI::ImportPresets = RKRGUI::menu_MenuP + 11;
Fl_Menu_Item* RKRGUI::salir = RKRGUI::menu_MenuP + 12;
Fl_Menu_Item* RKRGUI::Bank_Menu = RKRGUI::menu_MenuP + 14;
Fl_Menu_Item* RKRGUI::Ajustes = RKRGUI::menu_MenuP + 16;
Fl_Menu_Item* RKRGUI::ML_Menu = RKRGUI::menu_MenuP + 17;
Fl_Menu_Item* RKRGUI::ACI_Menu = RKRGUI::menu_MenuP + 18;
Fl_Menu_Item* RKRGUI::Ayuda = RKRGUI::menu_MenuP + 20;
Fl_Menu_Item* RKRGUI::Contenido = RKRGUI::menu_MenuP + 21;
Fl_Menu_Item* RKRGUI::Acerca_de = RKRGUI::menu_MenuP + 22;

void RKRGUI::cb_MT_i(Fl_Box*, void*) {
  highlight();


if (rkr->Tuner_Bypass)
{

if(rkr->efx_Tuner->note_actual != rkr->note_old)
{
char notas[3];
sprintf(notas,"%-2s",rkr->efx_Tuner->notes[rkr->efx_Tuner->note_actual]);
WNote->copy_label(notas);
rkr->note_old=rkr->efx_Tuner->note_actual;
}

if(rkr->efx_Tuner->nfreq != rkr->nfreq_old)
{
char refreq[60];
sprintf(refreq,"%8.3f",rkr->efx_Tuner->nfreq);
WRfreq->copy_label(refreq);
rkr->nfreq_old=rkr->efx_Tuner->nfreq;
}

//if(rkr->efx_Tuner->afreq != rkr->afreq_old)
if(fabsf(rkr->efx_Tuner->afreq-rkr->afreq_old)>.2f)
{
char nofreq[60];
sprintf(nofreq,"%8.3f",rkr->efx_Tuner->afreq);
if (abs(rkr->efx_Tuner->cents)>5) WNfreq->labelcolor(FL_RED); else WNfreq->labelcolor(label_color);
WNfreq->copy_label(nofreq);
rkr->afreq_old=rkr->efx_Tuner->afreq;
}


if(rkr->efx_Tuner->cents != rkr->cents_old)
{
tuner_bar->value(rkr->efx_Tuner->cents);
rkr->cents_old=rkr->efx_Tuner->cents;
}

}



if (Principal->w() != rkr->resolution) adjustfont();


if(stecla==1)
{
 if(rkr->Selected_Preset<60) 
 {
 Preset_Counter->value(rkr->Selected_Preset+1);
 Preset_Counter->do_callback();
 }
 stecla=0;
}


if(stecla==2)
{
 if(rkr->Selected_Preset>1) 
 {
 Preset_Counter->value(rkr->Selected_Preset-1);
 Preset_Counter->do_callback();
 }
 
 
 stecla=0;
}

if(stecla==3)
{ 
 
 if(Nivel_Salida->value()>-50) 
 {
  Nivel_Salida->value(Nivel_Salida->value()-1);
  Nivel_Salida->do_callback();
  Nivel_Salida->redraw();
 } 
  
  
  
 stecla=0;
}   


if(stecla==4)
{ 
 
 if(Nivel_Salida->value()<50) 
 {
  Nivel_Salida->value(Nivel_Salida->value()+1);
  Nivel_Salida->do_callback();
  Nivel_Salida->redraw();
 } 
 stecla=0;
}   


if(stecla==5)
{
 update_looper();
 stecla=0;
} 



if (preset!=1000)
{

if(!rkr->midi_table)
{
 Preset_Counter->value(preset);
 Preset_Counter->do_callback();
}
else
{
 if(rkr->a_bank != rkr->M_table[preset].bank)
  {
    switch(rkr->M_table[preset].bank)
    
     {
       case 0:
       L_B1->do_callback();
       break;

       case 1:
       L_B2->do_callback();
       break;
     
       case 2:
       L_B3->do_callback();
       break;

       case 3:
       L_B4->do_callback();
       break;
     
     
     }   
   }
 Preset_Counter->value(rkr->M_table[preset].preset+1);
 Preset_Counter->do_callback();

}

 preset=1000;
}




ActMIDI();
if(rkr->ACI_Bypass) ActACI();

rkr->cpufp++;
if(rkr->cpufp==40)
{
char tmp[8];
memset(tmp,0, sizeof(tmp));
sprintf(tmp,"%5.2f%%",rkr->cpuload);
CPULOAD->copy_label(tmp);
rkr->cpufp=0;
}




if(rkr->numpc)
{
  if (rkr->numpi) P_IN_ST->show(); else P_IN_ST->hide();
  if (rkr->numpo) P_OUT_ST->show(); else P_OUT_ST->hide();
  if (rkr->numpa) P_AUX_ST->show(); else P_AUX_ST->hide();
  if (rkr->numpmi) P_MIN_ST->show(); else P_MIN_ST->hide();
  if (rkr->numpmo) P_MOUT_ST->show(); else P_MOUT_ST->hide();
  rkr->numpc = 0;
}    

if(error_num>0) rkr->Error_Handle(error_num);

if(rkr->Tap_Bypass)
{
   
  if((rkr->Tap_Display==1) && (rkr->Tap_Selection > 0))
   {
     T_DIS->value(rkr->Tap_TempoSet);
     UpdateTGUI();
     rkr->Tap_Display=0;
   }  

  if(rkr->Tap_Display==2)
   {
     rkr->Tap_Display=0;
     Tap_activar->value(0);
     Tap_activar->do_callback();
   }  

}



if (rkr->Bypass)
{ 
  if (rkr->val_il_sum != rkr->old_il_sum)
  {
  input_vul->value(rkr->val_il_sum);
  rkr->old_il_sum=rkr->val_il_sum;
  }
  
  if (rkr->val_ir_sum != rkr->old_ir_sum)
  {
  input_vur->value(rkr->val_ir_sum);
  rkr->old_ir_sum=rkr->val_ir_sum;
  }

  if (rkr->val_vl_sum != rkr->old_vl_sum)
  {
  output_vul->value(rkr->val_vl_sum);
  rkr->old_vl_sum=rkr->val_vl_sum;
  }

  if (rkr->val_vr_sum != rkr->old_vr_sum)
  {
  output_vur->value(rkr->val_vr_sum);
  rkr->old_vr_sum=rkr->val_vr_sum;
  }


if(rkr->efx_FLimiter->clipping)
{
CLIP_LED->color(FL_RED);
CLIP_LED->redraw();
}
else
{
CLIP_LED->color(fl_darker(FL_RED));
CLIP_LED->redraw();
}

if(rkr->efx_FLimiter->limit)
{
LMT_LED->color(leds_color);
LMT_LED->redraw();
}
else
{
LMT_LED->color(fl_darker(leds_color));
LMT_LED->redraw();
}

rkr->efx_FLimiter->clipping=0;
rkr->efx_FLimiter->limit=0;


if(rkr->checkforaux())
{
 if(vu_vu->value()!=rkr->efx_Vocoder->vulevel)
 vu_vu->value(rkr->efx_Vocoder->vulevel);
}

if (Scope_ON)Sco->redraw();

if (nt)
  { 
  nt = 0;
  Sco->hide();
  Tuner->show();
  Tuner->redraw();
 }  


if (Analyzer_ON)
{ 
 at++;
 if(at==3)
   { Analy->redraw();
     at=0; 
   }
}

if(tta)
{
 tta=0;
 Analy->hide();
 Etit->show();
 Etit->redraw();
}  



if(rkr->Looper_Bypass)
{
  if((rkr->efx_Looper->Pplay) && (!rkr->efx_Looper->Pstop))
   {
     if(looper_lqua != rkr->efx_Looper->looper_qua)
         
         {
           looper_lqua = rkr->efx_Looper->looper_qua;
           char tmp[16]; 
           memset(tmp,0,sizeof(tmp));
           sprintf(tmp,"%d/%d",rkr->efx_Looper->looper_bar,rkr->efx_Looper->looper_qua);
           L_TimePos->copy_label(tmp);
         }
   
   }
   
   
   
 }


}


if ((rkr->Metro_Bypass) && (MetroSound->value()==0))
{
  if ((!rkr->M_Metronome->markctr) && ((int) Metro_Led->color() != (int) fl_lighter(FL_RED)))
  
     {
       Metro_Led->color(fl_lighter(FL_RED));
       Metro_Led->redraw();
     }  
  
  if ((rkr->M_Metronome->markctr) && ( (int) Metro_Led->color() != (int) fl_darker(FL_RED)))   
     {  
     Metro_Led->color(fl_darker(FL_RED));
     Metro_Led->redraw();
     } 
}


if (rkr->MIDIConverter_Bypass)
{
  if ((rkr->efx_MIDIConverter->hay) && ( (int) Mled->color() != (int) fl_lighter(FL_RED)))
  
     {
       Mled->color(fl_lighter(FL_RED));
       Mled->redraw();
     }  
  
  if ((!rkr->efx_MIDIConverter->hay) && ( (int) Mled->color() != (int) fl_darker(FL_RED)))   
     {  
     Mled->color(fl_darker(FL_RED));
     Mled->redraw();
     } 
}


if (rkr->Harmonizer_Bypass)
{

    if((rkr->efx_Har->PSELECT)|| (rkr->efx_Har->PMIDI))
     {

    if (rkr->RC->cc) 
    {
    har_chordname->copy_label(rkr->RC->NombreAcorde);
    if(!rkr->StereoHarm_Bypass) rkr->RC->cc=0;  
    har_chordname->redraw(); 
    rkr->RC->Vamos(0,rkr->efx_Har->Pinterval-12);      
    }
     }

}

if (rkr->StereoHarm_Bypass)
{

    if((rkr->efx_StereoHarm->PSELECT)|| (rkr->efx_StereoHarm->PMIDI))
     {

    if (rkr->RC->cc) 
    {
    shar_chordname->copy_label(rkr->RC->NombreAcorde);
    rkr->RC->cc=0;  
    shar_chordname->redraw(); 
    rkr->RC->Vamos(1,rkr->efx_StereoHarm->Pintervall-12);      
    rkr->RC->Vamos(2,rkr->efx_StereoHarm->Pintervalr-12);      
    
    }
     }

}


if (rkr->RControl)
{ 
   rkr->CountWait++;
   if (rkr->CountWait==25)
      {
        GMM->color(leds_color);
        GMM->redraw();
       } 
        
   if (rkr->CountWait==50)
       {
         GMM->color(fore_color); 
         GMM->redraw();
         rkr->CountWait=0;
       } 
      

  if (rkr->ControlGet != 0)
    {
      rkr->RControl = 0;
      Disp_Control->value(rkr->ControlGet);
      Disp_Control->redraw();
      GMM->color(fore_color);
      GMM->redraw();
      if((rkr->comemouse) && (rkr->autoassign))
       {
        rkr->comemouse=0;
        Assign->do_callback();   
          
       }
      
      
    }   
};
}
void RKRGUI::cb_MT(Fl_Box* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_MT_i(o,v);
}

void RKRGUI::cb_TITTLE_L_i(Fl_Button*, void*) {
  if(rkr->Bypass)
{
Tuner->hide();
Sco->show();
Scope_ON=1;
Fl::focus(Open_Order);
};
}
void RKRGUI::cb_TITTLE_L(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_TITTLE_L_i(o,v);
}

void RKRGUI::cb_eq_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->EQ1_Bypass);
 return;
} 
rkr->EQ1_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_EQ1->cleanup();
findpos(0,(int)o->value(),o);
}
void RKRGUI::cb_eq_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_activar_i(o,v);
}

void RKRGUI::cb_eq_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12000))rkr->EQ1_setpreset((int)o->value());
eq_1->value(rkr->efx_EQ1->getpar(12)-64);
eq_2->value(rkr->efx_EQ1->getpar(17)-64);
eq_3->value(rkr->efx_EQ1->getpar(22)-64);
eq_4->value(rkr->efx_EQ1->getpar(27)-64);
eq_5->value(rkr->efx_EQ1->getpar(32)-64);
eq_6->value(rkr->efx_EQ1->getpar(37)-64);
eq_7->value(rkr->efx_EQ1->getpar(42)-64);
eq_8->value(rkr->efx_EQ1->getpar(47)-64);
eq_9->value(rkr->efx_EQ1->getpar(52)-64);
eq_10->value(rkr->efx_EQ1->getpar(57)-64);
eq_Gain->value(rkr->efx_EQ1->getpar(0)-64);
eq_Q->value(rkr->efx_EQ1->getpar(13)-64);
}
void RKRGUI::cb_eq_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_eq_preset[] = {
 {"Plain", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Pop", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Jazz", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_eq_Gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(130);
 return;
} 
rkr->efx_EQ1->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_eq_Gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_Gain_i(o,v);
}

void RKRGUI::cb_eq_Q_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(131);
 return;
} 
int i;
for(i=0;i<10;i++) rkr->efx_EQ1->changepar(i*5+13,(int)(o->value()+64));
}
void RKRGUI::cb_eq_Q(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_Q_i(o,v);
}

void RKRGUI::cb_eq_1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(132);
 return;
} 
rkr->efx_EQ1->changepar(12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_1_i(o,v);
}

void RKRGUI::cb_eq_2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(133);
 return;
} 
rkr->efx_EQ1->changepar(5+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_2_i(o,v);
}

void RKRGUI::cb_eq_3_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(134);
 return;
} 
rkr->efx_EQ1->changepar(10+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_3(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_3_i(o,v);
}

void RKRGUI::cb_eq_4_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(135);
 return;
} 
rkr->efx_EQ1->changepar(15+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_4(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_4_i(o,v);
}

void RKRGUI::cb_eq_5_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(136);
 return;
} 
rkr->efx_EQ1->changepar(20+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_5(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_5_i(o,v);
}

void RKRGUI::cb_eq_6_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(137);
 return;
} 
rkr->efx_EQ1->changepar(25+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_6(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_6_i(o,v);
}

void RKRGUI::cb_eq_7_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(138);
 return;
} 
rkr->efx_EQ1->changepar(30+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_7(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_7_i(o,v);
}

void RKRGUI::cb_eq_8_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(139);
 return;
} 
rkr->efx_EQ1->changepar(35+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_8(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_8_i(o,v);
}

void RKRGUI::cb_eq_9_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(140);
 return;
} 
rkr->efx_EQ1->changepar(40+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_9(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_9_i(o,v);
}

void RKRGUI::cb_eq_10_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(141);
 return;
} 
rkr->efx_EQ1->changepar(45+12,(int)(o->value()+64));
}
void RKRGUI::cb_eq_10(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eq_10_i(o,v);
}

void RKRGUI::cb_compress_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Compressor_Bypass);
 return;
}
rkr->Compressor_Bypass=(int)o->value();
rkr->efx_Compressor->cleanup();
findpos(1,(int)o->value(),o);
}
void RKRGUI::cb_compress_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_activar_i(o,v);
}

void RKRGUI::cb_compress_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12001))rkr->efx_Compressor->Compressor_Change_Preset(1,(int) o->value());
compress_threshold->value(rkr->efx_Compressor->getpar(1));
compress_Ratio->value(rkr->efx_Compressor->getpar(2));
compress_output->value(rkr->efx_Compressor->getpar(3));
compress_ATime->value(rkr->efx_Compressor->getpar(4));
compress_RTime->value(rkr->efx_Compressor->getpar(5));
Auto_Output->value(rkr->efx_Compressor->getpar(6));
compress_Knee->value(rkr->efx_Compressor->getpar(7));
Stereo->value(rkr->efx_Compressor->getpar(8));
Peak->value(rkr->efx_Compressor->getpar(9));
}
void RKRGUI::cb_compress_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_compress_preset[] = {
 {"2:1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"4:1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"8:1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_compress_ATime_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(142);
 return;
} 
rkr->efx_Compressor->Compressor_Change(4,(int)o->value());
}
void RKRGUI::cb_compress_ATime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_ATime_i(o,v);
}

void RKRGUI::cb_compress_RTime_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(143);
 return;
} 
rkr->efx_Compressor->Compressor_Change(5, (int) o->value());
}
void RKRGUI::cb_compress_RTime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_RTime_i(o,v);
}

void RKRGUI::cb_compress_Ratio_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(144);
 return;
} 
rkr->efx_Compressor->Compressor_Change(2, (int) o->value());
}
void RKRGUI::cb_compress_Ratio(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_Ratio_i(o,v);
}

void RKRGUI::cb_compress_Knee_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(145);
 return;
} 
rkr->efx_Compressor->Compressor_Change(7, (int) o->value());
}
void RKRGUI::cb_compress_Knee(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_Knee_i(o,v);
}

void RKRGUI::cb_compress_threshold_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(146);
 return;
} 
rkr->efx_Compressor->Compressor_Change(1, (int)o->value());
}
void RKRGUI::cb_compress_threshold(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_threshold_i(o,v);
}

void RKRGUI::cb_compress_output_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(147);
 return;
} 
rkr->efx_Compressor->Compressor_Change(3,(int)o->value());
}
void RKRGUI::cb_compress_output(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_compress_output_i(o,v);
}

void RKRGUI::cb_Auto_Output_i(Fl_Check_Button* o, void*) {
  rkr->efx_Compressor->Compressor_Change(6,(int)o->value());
if ((int) o->value() == 0) compress_output->do_callback();
}
void RKRGUI::cb_Auto_Output(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Auto_Output_i(o,v);
}

void RKRGUI::cb_Stereo_i(Fl_Check_Button* o, void*) {
  rkr->efx_Compressor->Compressor_Change(8,(int)o->value());
if ((int) o->value() == 0) compress_output->do_callback();
}
void RKRGUI::cb_Stereo(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Stereo_i(o,v);
}

void RKRGUI::cb_Peak_i(Fl_Check_Button* o, void*) {
  rkr->efx_Compressor->Compressor_Change(9,(int)o->value());
if ((int) o->value() == 0) compress_output->do_callback();
}
void RKRGUI::cb_Peak(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Peak_i(o,v);
}

void RKRGUI::cb_dist_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Distorsion_Bypass);
 return;
}
rkr->Distorsion_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Distorsion->cleanup();
findpos(2,(int)o->value(),o);
}
void RKRGUI::cb_dist_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_activar_i(o,v);
}

void RKRGUI::cb_dist_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12002)) rkr->efx_Distorsion->setpreset(0,(int)(o->value()+2));
dist_WD->value(rkr->efx_Distorsion->getpar(0)-64);
dist_pan->value(rkr->efx_Distorsion->getpar(1)-64);
dist_LRc->value(rkr->efx_Distorsion->getpar(2)-64);
dist_drive->value(rkr->efx_Distorsion->getpar(3));
dist_level->value(rkr->efx_Distorsion->getpar(4));
dist_tipo->value(rkr->efx_Distorsion->getpar(5));
dist_neg->value(rkr->efx_Distorsion->getpar(6));
dist_lpf->value(rkr->efx_Distorsion->getpar(7));
dist_hpf->value(rkr->efx_Distorsion->getpar(8));
dist_st->value(rkr->efx_Distorsion->getpar(9));
dist_pf->value(rkr->efx_Distorsion->getpar(10));
dist_oct->value(rkr->efx_Distorsion->getpar(12));
}
void RKRGUI::cb_dist_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_dist_preset[] = {
 {"Distorsion 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Distorsion 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Distorsion 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Guitar Amp", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_dist_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(30);
 return;
} 
rkr->efx_Distorsion->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_dist_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_WD_i(o,v);
}

void RKRGUI::cb_dist_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(95);
 return;
} 
rkr->efx_Distorsion->changepar(2,(int)(o->value()+64));
}
void RKRGUI::cb_dist_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_LRc_i(o,v);
}

void RKRGUI::cb_dist_drive_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(69);
 return;
} 
rkr->efx_Distorsion->changepar(3,(int)o->value());
}
void RKRGUI::cb_dist_drive(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_drive_i(o,v);
}

void RKRGUI::cb_dist_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(71);
 return;
} 
rkr->efx_Distorsion->changepar(4,(int)o->value());
}
void RKRGUI::cb_dist_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_level_i(o,v);
}

void RKRGUI::cb_dist_tipo_i(Fl_Choice* o, void*) {
  rkr->efx_Distorsion->changepar(5,(int)o->value());
}
void RKRGUI::cb_dist_tipo(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_tipo_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_dist_tipo[] = {
 {"Atan", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Asym1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Pow", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Sine", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Qnts", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Zigzg", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Lmt", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"LmtU", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"LmtL", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"ILmt", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Clip", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Asym2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Pow2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Sgm", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Crunch", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Hard Crunch", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dirty Octave+", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"M.Square", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"M.Saw", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Compress", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Overdrive", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Soft", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Super Soft", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Hard Compress", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Lmt-NoGain", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"FET", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"DynoFET", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Valve 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Valve 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Diode clipper", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_dist_neg_i(Fl_Check_Button* o, void*) {
  rkr->efx_Distorsion->changepar(6,(int)o->value());
}
void RKRGUI::cb_dist_neg(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_neg_i(o,v);
}

void RKRGUI::cb_dist_pf_i(Fl_Check_Button* o, void*) {
  rkr->efx_Distorsion->changepar(10,(int)o->value());
}
void RKRGUI::cb_dist_pf(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_pf_i(o,v);
}

void RKRGUI::cb_dist_st_i(Fl_Check_Button* o, void*) {
  rkr->efx_Distorsion->changepar(9,(int)o->value());
}
void RKRGUI::cb_dist_st(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_st_i(o,v);
}

void RKRGUI::cb_dist_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(48);
 return;
} 
rkr->efx_Distorsion->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_dist_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_pan_i(o,v);
}

void RKRGUI::cb_dist_oct_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(9);
 return;
} 
rkr->efx_Distorsion->changepar(12,(int)o->value());
}
void RKRGUI::cb_dist_oct(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_oct_i(o,v);
}

void RKRGUI::cb_dist_lpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(86);
 return;
} 
rkr->efx_Distorsion->changepar(7,(int)o->value());
}
void RKRGUI::cb_dist_lpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_lpf_i(o,v);
}

void RKRGUI::cb_dist_hpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(89);
 return;
} 
rkr->efx_Distorsion->changepar(8,(int)o->value());
}
void RKRGUI::cb_dist_hpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dist_hpf_i(o,v);
}

void RKRGUI::cb_ovrd_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Overdrive_Bypass);
 return;
}
rkr->Overdrive_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Overdrive->cleanup();
findpos(3,(int)o->value(),o);
}
void RKRGUI::cb_ovrd_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_activar_i(o,v);
}

void RKRGUI::cb_ovrd_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12003))rkr->efx_Overdrive->setpreset(1,(int) o->value());
ovrd_WD->value(rkr->efx_Overdrive->getpar(0)-64);
ovrd_pan->value(rkr->efx_Overdrive->getpar(1)-64);
ovrd_LRc->value(rkr->efx_Overdrive->getpar(2)-64);
ovrd_drive->value(rkr->efx_Overdrive->getpar(3));
ovrd_level->value(rkr->efx_Overdrive->getpar(4));
ovrd_tipo->value(rkr->efx_Overdrive->getpar(5));
ovrd_neg->value(rkr->efx_Overdrive->getpar(6));
ovrd_lpf->value(rkr->efx_Overdrive->getpar(7));
ovrd_hpf->value(rkr->efx_Overdrive->getpar(8));
ovrd_st->value(rkr->efx_Overdrive->getpar(9));
ovrd_pf->value(rkr->efx_Overdrive->getpar(10));
}
void RKRGUI::cb_ovrd_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_ovrd_preset[] = {
 {"Overdrive 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Overdrive 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_ovrd_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(29);
 return;
} 
rkr->efx_Overdrive->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_ovrd_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_WD_i(o,v);
}

void RKRGUI::cb_ovrd_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(94);
 return;
} 
rkr->efx_Overdrive->changepar(2,(int)(o->value()+64));
}
void RKRGUI::cb_ovrd_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_LRc_i(o,v);
}

void RKRGUI::cb_ovrd_drive_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(68);
 return;
} 
rkr->efx_Overdrive->changepar(3,(int)o->value());
}
void RKRGUI::cb_ovrd_drive(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_drive_i(o,v);
}

void RKRGUI::cb_ovrd_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(70);
 return;
} 
rkr->efx_Overdrive->changepar(4,(int)o->value());
}
void RKRGUI::cb_ovrd_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_level_i(o,v);
}

void RKRGUI::cb_ovrd_tipo_i(Fl_Choice* o, void*) {
  rkr->efx_Overdrive->changepar(5,(int)o->value());
}
void RKRGUI::cb_ovrd_tipo(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_tipo_i(o,v);
}

void RKRGUI::cb_ovrd_neg_i(Fl_Check_Button* o, void*) {
  rkr->efx_Overdrive->changepar(6,(int)o->value());
}
void RKRGUI::cb_ovrd_neg(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_neg_i(o,v);
}

void RKRGUI::cb_ovrd_st_i(Fl_Check_Button* o, void*) {
  rkr->efx_Overdrive->changepar(9,(int)o->value());
}
void RKRGUI::cb_ovrd_st(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_st_i(o,v);
}

void RKRGUI::cb_ovrd_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(47);
 return;
} 
rkr->efx_Overdrive->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_ovrd_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_pan_i(o,v);
}

void RKRGUI::cb_ovrd_pf_i(Fl_Check_Button* o, void*) {
  rkr->efx_Overdrive->changepar(10,(int)o->value());
}
void RKRGUI::cb_ovrd_pf(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_pf_i(o,v);
}

void RKRGUI::cb_ovrd_lpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(85);
 return;
} 
rkr->efx_Overdrive->changepar(7,(int)o->value());
}
void RKRGUI::cb_ovrd_lpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_lpf_i(o,v);
}

void RKRGUI::cb_ovrd_hpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(88);
 return;
} 
rkr->efx_Overdrive->changepar(8,(int)o->value());
}
void RKRGUI::cb_ovrd_hpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ovrd_hpf_i(o,v);
}

void RKRGUI::cb_echo_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Echo_Bypass);
 return;
}
rkr->Echo_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Echo->cleanup();
findpos(4,(int)o->value(),o);
}
void RKRGUI::cb_echo_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_activar_i(o,v);
}

void RKRGUI::cb_echo_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12004))rkr->efx_Echo->setpreset((int) o->value());
echo_WD->value(rkr->efx_Echo->getpar(0)-64);
echo_pan->value(rkr->efx_Echo->getpar(1)-64);
echo_delay->value(rkr->efx_Echo->getpar(2));
echo_LRdl->value(rkr->efx_Echo->getpar(3));
echo_LRc->value(rkr->efx_Echo->getpar(4)-64);
echo_fb->value(rkr->efx_Echo->getpar(5));
echo_damp->value(rkr->efx_Echo->getpar(6));
echo_RV->value(rkr->efx_Echo->getpar(7));
echo_direct->value(rkr->efx_Echo->getpar(8));
}
void RKRGUI::cb_echo_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_echo_preset[] = {
 {"Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Echo 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Simple Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Canyon", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Panning Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Panning Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Panning Echo 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Feedback Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_echo_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(59);
 return;
} 
rkr->efx_Echo->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_echo_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_WD_i(o,v);
}

void RKRGUI::cb_echo_RV_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(7,(int)o->value());
}
void RKRGUI::cb_echo_RV(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_RV_i(o,v);
}

void RKRGUI::cb_echo_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(46);
 return;
} 
rkr->efx_Echo->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_echo_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_pan_i(o,v);
}

void RKRGUI::cb_echo_delay_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(2,(int)o->value());
}
void RKRGUI::cb_echo_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_delay_i(o,v);
}

void RKRGUI::cb_echo_LRdl_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(3,(int)o->value());
}
void RKRGUI::cb_echo_LRdl(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_LRdl_i(o,v);
}

void RKRGUI::cb_echo_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(97);
 return;
} 
rkr->efx_Echo->changepar(4,(int)(o->value()+64));
}
void RKRGUI::cb_echo_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_LRc_i(o,v);
}

void RKRGUI::cb_echo_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(78);
 return;
} 
rkr->efx_Echo->changepar(5,(int)o->value());
}
void RKRGUI::cb_echo_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_fb_i(o,v);
}

void RKRGUI::cb_echo_direct_i(Fl_Check_Button* o, void*) {
  rkr->efx_Echo->changepar(8,(int)o->value());
}
void RKRGUI::cb_echo_direct(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_direct_i(o,v);
}

void RKRGUI::cb_echo_damp_i(SliderW* o, void*) {
  rkr->efx_Echo->changepar(6,(int)o->value());
}
void RKRGUI::cb_echo_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echo_damp_i(o,v);
}

void RKRGUI::cb_chorus_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Chorus_Bypass);
 return;
}
rkr->Chorus_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Chorus->cleanup();
findpos(5,(int)o->value(),o);
}
void RKRGUI::cb_chorus_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_activar_i(o,v);
}

void RKRGUI::cb_chorus_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12005))rkr->efx_Chorus->setpreset(0,(int) o->value());
chorus_WD->value(rkr->efx_Chorus->getpar(0)-64);
chorus_pan->value(rkr->efx_Chorus->getpar(1)-64);
chorus_freq->value(rkr->efx_Chorus->getpar(2));
chorus_rnd->value(rkr->efx_Chorus->getpar(3));
chorus_lfotype->value(rkr->efx_Chorus->getpar(4));
chorus_stdf->value(rkr->efx_Chorus->getpar(5));
chorus_dpth->value(rkr->efx_Chorus->getpar(6));
chorus_delay->value(rkr->efx_Chorus->getpar(7));
chorus_fb->value(rkr->efx_Chorus->getpar(8));
chorus_LR->value(rkr->efx_Chorus->getpar(9)-64);
chorus_subs->value(rkr->efx_Chorus->getpar(11));
}
void RKRGUI::cb_chorus_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_chorus_preset[] = {
 {"Chorus 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Chorus 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Chorus 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Celeste 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Celeste 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_chorus_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(52);
 return;
} 
rkr->efx_Chorus->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_chorus_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_WD_i(o,v);
}

void RKRGUI::cb_chorus_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(50);
 return;
} 
rkr->efx_Chorus->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_chorus_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_pan_i(o,v);
}

void RKRGUI::cb_chorus_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(72);
 return;
} 
rkr->efx_Chorus->changepar(2,(int)o->value());
}
void RKRGUI::cb_chorus_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_freq_i(o,v);
}

void RKRGUI::cb_chorus_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(105);
 return;
} 
rkr->efx_Chorus->changepar(3,(int)o->value());
}
void RKRGUI::cb_chorus_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_rnd_i(o,v);
}

void RKRGUI::cb_chorus_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Chorus->changepar(4,(int)o->value());
}
void RKRGUI::cb_chorus_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_lfotype_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_chorus_lfotype[] = {
 {"Sine", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Tri", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Ramp Up", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Ramp Down", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"ZigZag", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"M. Sqare", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"M.Saw", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"L. Fractal", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"L. Fractal XY", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"S/H Random", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_chorus_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_Chorus->changepar(11,(int)o->value());
}
void RKRGUI::cb_chorus_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_subs_i(o,v);
}

void RKRGUI::cb_chorus_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(99);
 return;
} 
rkr->efx_Chorus->changepar(5,(int)o->value());
}
void RKRGUI::cb_chorus_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_stdf_i(o,v);
}

void RKRGUI::cb_chorus_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(23);
 return;
} 
rkr->efx_Chorus->changepar(6,(int)o->value());
}
void RKRGUI::cb_chorus_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_dpth_i(o,v);
}

void RKRGUI::cb_chorus_delay_i(SliderW* o, void*) {
  rkr->efx_Chorus->changepar(7,(int)o->value());
}
void RKRGUI::cb_chorus_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_delay_i(o,v);
}

void RKRGUI::cb_chorus_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(79);
 return;
} 
rkr->efx_Chorus->changepar(8,(int)o->value());
}
void RKRGUI::cb_chorus_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_fb_i(o,v);
}

void RKRGUI::cb_chorus_LR_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(91);
 return;
} 
rkr->efx_Chorus->changepar(9,(int)(o->value()+64));
}
void RKRGUI::cb_chorus_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_chorus_LR_i(o,v);
}

void RKRGUI::cb_phaser_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Phaser_Bypass);
 return;
}
rkr->Phaser_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Phaser->cleanup();
findpos(6,(int)o->value(),o);
}
void RKRGUI::cb_phaser_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_activar_i(o,v);
}

void RKRGUI::cb_phaser_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12006))rkr->efx_Phaser->setpreset((int) o->value());
phaser_WD->value(rkr->efx_Phaser->getpar(0)-64);
phaser_pan->value(rkr->efx_Phaser->getpar(1)-64);
phaser_freq->value(rkr->efx_Phaser->getpar(2));
phaser_rnd->value(rkr->efx_Phaser->getpar(3));
phaser_lfotype->value(rkr->efx_Phaser->getpar(4));
phaser_stdf->value(rkr->efx_Phaser->getpar(5));
phaser_dpth->value(rkr->efx_Phaser->getpar(6));
phaser_stages->value(rkr->efx_Phaser->getpar(8));
phaser_fb->value(rkr->efx_Phaser->getpar(7));
phaser_stages->value(rkr->efx_Phaser->getpar(8));
phaser_LR->value(rkr->efx_Phaser->getpar(9)-64);
phaser_subs->value(rkr->efx_Phaser->getpar(10));
phaser_phase->value(rkr->efx_Phaser->getpar(11));
}
void RKRGUI::cb_phaser_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_phaser_preset[] = {
 {"Phaser 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 6", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_phaser_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(54);
 return;
} 
rkr->efx_Phaser->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_phaser_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_WD_i(o,v);
}

void RKRGUI::cb_phaser_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(60);
 return;
} 
rkr->efx_Phaser->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_phaser_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_pan_i(o,v);
}

void RKRGUI::cb_phaser_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(74);
 return;
} 
rkr->efx_Phaser->changepar(2,(int)o->value());
}
void RKRGUI::cb_phaser_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_freq_i(o,v);
}

void RKRGUI::cb_phaser_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(107);
 return;
} 
rkr->efx_Phaser->changepar(3,(int)o->value());
}
void RKRGUI::cb_phaser_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_rnd_i(o,v);
}

void RKRGUI::cb_phaser_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Phaser->changepar(4,(int)o->value());
}
void RKRGUI::cb_phaser_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_lfotype_i(o,v);
}

void RKRGUI::cb_phaser_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_Phaser->changepar(10,(int)o->value());
}
void RKRGUI::cb_phaser_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_subs_i(o,v);
}

void RKRGUI::cb_phaser_phase_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(114);
 return;
} 
rkr->efx_Phaser->changepar(11,(int)o->value());
}
void RKRGUI::cb_phaser_phase(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_phase_i(o,v);
}

void RKRGUI::cb_phaser_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(101);
 return;
} 
rkr->efx_Phaser->changepar(5,(int)o->value());
}
void RKRGUI::cb_phaser_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_stdf_i(o,v);
}

void RKRGUI::cb_phaser_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(21);
 return;
} 
rkr->efx_Phaser->changepar(6,(int)o->value());
}
void RKRGUI::cb_phaser_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_dpth_i(o,v);
}

void RKRGUI::cb_phaser_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(81);
 return;
} 
rkr->efx_Phaser->changepar(7,(int)o->value());
}
void RKRGUI::cb_phaser_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_fb_i(o,v);
}

void RKRGUI::cb_phaser_stages_i(Fl_Counter* o, void*) {
  rkr->efx_Phaser->changepar(8,(int)o->value());
}
void RKRGUI::cb_phaser_stages(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_stages_i(o,v);
}

void RKRGUI::cb_phaser_LR_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(93);
 return;
} 
rkr->efx_Phaser->changepar(9,(int)(o->value()+64));
}
void RKRGUI::cb_phaser_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_phaser_LR_i(o,v);
}

void RKRGUI::cb_flanger_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Flanger_Bypass);
 return;
}
rkr->Flanger_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Flanger->cleanup();
findpos(7,(int)o->value(),o);
}
void RKRGUI::cb_flanger_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_activar_i(o,v);
}

void RKRGUI::cb_flanger_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12007))rkr->efx_Flanger->setpreset(1,(int)(o->value()+5));
flanger_WD->value(rkr->efx_Flanger->getpar(0)-64);
flanger_pan->value(rkr->efx_Flanger->getpar(1)-64);
flanger_freq->value(rkr->efx_Flanger->getpar(2));
flanger_rnd->value(rkr->efx_Flanger->getpar(3));
flanger_lfotype->value(rkr->efx_Flanger->getpar(4));
flanger_stdf->value(rkr->efx_Flanger->getpar(5));
flanger_dpth->value(rkr->efx_Flanger->getpar(6));
flanger_delay->value(rkr->efx_Flanger->getpar(7));
flanger_fb->value(rkr->efx_Flanger->getpar(8));
flanger_LR->value(rkr->efx_Flanger->getpar(9)-64);
flanger_subs->value(rkr->efx_Flanger->getpar(11));
}
void RKRGUI::cb_flanger_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_flanger_preset[] = {
 {"Flange 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Flange 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Flange 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Flange 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Flange 5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_flanger_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(53);
 return;
} 
rkr->efx_Flanger->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_flanger_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_WD_i(o,v);
}

void RKRGUI::cb_flanger_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(51);
 return;
} 
rkr->efx_Flanger->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_flanger_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_pan_i(o,v);
}

void RKRGUI::cb_flanger_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(73);
 return;
} 
rkr->efx_Flanger->changepar(2,(int)o->value());
}
void RKRGUI::cb_flanger_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_freq_i(o,v);
}

void RKRGUI::cb_flanger_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(106);
 return;
} 
rkr->efx_Flanger->changepar(3,(int)o->value());
}
void RKRGUI::cb_flanger_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_rnd_i(o,v);
}

void RKRGUI::cb_flanger_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Flanger->changepar(4,(int)o->value());
}
void RKRGUI::cb_flanger_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_lfotype_i(o,v);
}

void RKRGUI::cb_flanger_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_Flanger->changepar(11,(int)o->value());
}
void RKRGUI::cb_flanger_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_subs_i(o,v);
}

void RKRGUI::cb_flanger_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(100);
 return;
} 
rkr->efx_Flanger->changepar(5,(int)o->value());
}
void RKRGUI::cb_flanger_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_stdf_i(o,v);
}

void RKRGUI::cb_flanger_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(22);
 return;
} 
rkr->efx_Flanger->changepar(6,(int)o->value());
}
void RKRGUI::cb_flanger_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_dpth_i(o,v);
}

void RKRGUI::cb_flanger_delay_i(SliderW* o, void*) {
  rkr->efx_Flanger->changepar(7,(int)o->value());
}
void RKRGUI::cb_flanger_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_delay_i(o,v);
}

void RKRGUI::cb_flanger_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(80);
 return;
} 
rkr->efx_Flanger->changepar(8,(int)o->value());
}
void RKRGUI::cb_flanger_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_fb_i(o,v);
}

void RKRGUI::cb_flanger_LR_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(92);
 return;
} 
rkr->efx_Flanger->changepar(9,(int)(o->value()+64));
}
void RKRGUI::cb_flanger_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_flanger_LR_i(o,v);
}

void RKRGUI::cb_reverb_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Reverb_Bypass);
 return;
}
rkr->Reverb_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Rev->cleanup();
findpos(8,(int)o->value(),o);
}
void RKRGUI::cb_reverb_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_activar_i(o,v);
}

void RKRGUI::cb_reverb_preset_i(Fl_Choice* o, void* v) {
  rkr->Reverb_Bypass=0;
long long ud= (long long) v;
if((ud==0)||(ud==12008))rkr->efx_Rev->setpreset((int) o->value());
reverb_WD->value(rkr->efx_Rev->getpar(0)-64);
reverb_pan->value(rkr->efx_Rev->getpar(1)-64);
reverb_time->value(rkr->efx_Rev->getpar(2));
reverb_ldel->value(rkr->efx_Rev->getpar(3));
reverb_ldelft->value(rkr->efx_Rev->getpar(4));
reverb_LPF->value(rkr->efx_Rev->getpar(7));
reverb_HPF->value(rkr->efx_Rev->getpar(8));
reverb_damp->value(rkr->efx_Rev->getpar(9));
reverb_RS->value(rkr->efx_Rev->getpar(11));
reverb_type->value(rkr->efx_Rev->getpar(10));
if((int)reverb_activar->value())rkr->Reverb_Bypass=1;
}
void RKRGUI::cb_reverb_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_reverb_preset[] = {
 {"Cathedral 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Cathedral 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Cathedral 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hall 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hall 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Room 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Room 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Basement", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Tunnel", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Echoed 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Echoed 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Very Long 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Very Long 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_reverb_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(57);
 return;
} 
rkr->efx_Rev->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_reverb_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_WD_i(o,v);
}

void RKRGUI::cb_reverb_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(63);
 return;
} 
rkr->efx_Rev->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_reverb_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_pan_i(o,v);
}

void RKRGUI::cb_reverb_time_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(2,(int)o->value());
}
void RKRGUI::cb_reverb_time(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_time_i(o,v);
}

void RKRGUI::cb_reverb_ldel_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(3,(int)o->value());
}
void RKRGUI::cb_reverb_ldel(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_ldel_i(o,v);
}

void RKRGUI::cb_reverb_ldelft_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(4,(int)o->value());
}
void RKRGUI::cb_reverb_ldelft(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_ldelft_i(o,v);
}

void RKRGUI::cb_reverb_type_i(Fl_Choice* o, void*) {
  rkr->efx_Rev->changepar(10,(int)o->value());
}
void RKRGUI::cb_reverb_type(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_type_i(o,v);
}

void RKRGUI::cb_Random_i(Fl_Menu_*, void*) {
  rkr->efx_Rev->changepar(10,1);
}
void RKRGUI::cb_Random(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Random_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_reverb_type[] = {
 {"Freeverb", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Random", 0,  (Fl_Callback*)RKRGUI::cb_Random, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_reverb_RS_i(SliderW* o, void*) {
  rkr->Reverb_Bypass=0;
rkr->efx_Rev->changepar(11,(int)o->value());
if((int)reverb_activar->value())rkr->Reverb_Bypass=1;
}
void RKRGUI::cb_reverb_RS(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_RS_i(o,v);
}

void RKRGUI::cb_reverb_LPF_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(87);
 return;
} 
rkr->efx_Rev->changepar(7,(int)o->value());
}
void RKRGUI::cb_reverb_LPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_LPF_i(o,v);
}

void RKRGUI::cb_reverb_HPF_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(90);
 return;
} 
rkr->efx_Rev->changepar(8,(int)o->value());
}
void RKRGUI::cb_reverb_HPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_HPF_i(o,v);
}

void RKRGUI::cb_reverb_damp_i(SliderW* o, void*) {
  rkr->efx_Rev->changepar(9,(int)o->value());
}
void RKRGUI::cb_reverb_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_reverb_damp_i(o,v);
}

void RKRGUI::cb_eqp_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->EQ2_Bypass);
 return;
}
rkr->EQ2_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_EQ2->cleanup();
findpos(9,(int)o->value(),o);
}
void RKRGUI::cb_eqp_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_activar_i(o,v);
}

void RKRGUI::cb_eqp_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12009)) rkr->EQ2_setpreset((int)o->value());
eqp_LF->value(rkr->efx_EQ2->getpar(11));
eqp_LFg->value(rkr->efx_EQ2->getpar(12)-64);
eqp_LQ->value(rkr->efx_EQ2->getpar(13)-64);
eqp_MF->value(rkr->efx_EQ2->getpar(16));
eqp_MFg->value(rkr->efx_EQ2->getpar(17)-64);
eqp_MQ->value(rkr->efx_EQ2->getpar(18)-64);
eqp_HF->value(rkr->efx_EQ2->getpar(21));
eqp_HFg->value(rkr->efx_EQ2->getpar(22)-64);
eqp_HQ->value(rkr->efx_EQ2->getpar(23)-64);
eqp_Gain->value(rkr->efx_EQ2->getpar(0)-64);
}
void RKRGUI::cb_eqp_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_eqp_preset[] = {
 {"Plain", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Pop", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Jazz", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_eqp_Gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(148);
 return;
} 
rkr->efx_EQ2->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_eqp_Gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_Gain_i(o,v);
}

void RKRGUI::cb_eqp_LF_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(149);
 return;
} 
rkr->efx_EQ2->changepar(11,(int)o->value());
}
void RKRGUI::cb_eqp_LF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_LF_i(o,v);
}

void RKRGUI::cb_eqp_LFg_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(150);
 return;
} 
rkr->efx_EQ2->changepar(12,(int)(o->value()+64));
}
void RKRGUI::cb_eqp_LFg(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_LFg_i(o,v);
}

void RKRGUI::cb_eqp_LQ_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(151);
 return;
} 
rkr->efx_EQ2->changepar(13,(int)(o->value()+64));
}
void RKRGUI::cb_eqp_LQ(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_LQ_i(o,v);
}

void RKRGUI::cb_eqp_MF_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(152);
 return;
} 
rkr->efx_EQ2->changepar(5+11,(int)o->value());
}
void RKRGUI::cb_eqp_MF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_MF_i(o,v);
}

void RKRGUI::cb_eqp_MFg_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(153);
 return;
} 
rkr->efx_EQ2->changepar(5+12,(int)(o->value()+64));
}
void RKRGUI::cb_eqp_MFg(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_MFg_i(o,v);
}

void RKRGUI::cb_eqp_MQ_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(154);
 return;
} 
rkr->efx_EQ2->changepar(5+13,(int)(o->value()+64));
}
void RKRGUI::cb_eqp_MQ(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_MQ_i(o,v);
}

void RKRGUI::cb_eqp_HF_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(155);
 return;
} 
rkr->efx_EQ2->changepar(10+11,(int)o->value());
}
void RKRGUI::cb_eqp_HF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_HF_i(o,v);
}

void RKRGUI::cb_eqp_HFg_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(156);
 return;
} 
rkr->efx_EQ2->changepar(10+12,(int)(o->value()+64));
}
void RKRGUI::cb_eqp_HFg(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_HFg_i(o,v);
}

void RKRGUI::cb_eqp_HQ_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(157);
 return;
} 
rkr->efx_EQ2->changepar(10+13,(int)(o->value()+64));
}
void RKRGUI::cb_eqp_HQ(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_eqp_HQ_i(o,v);
}

void RKRGUI::cb_WhaWha_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->WhaWha_Bypass);
 return;
}
rkr->WhaWha_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_WhaWha->cleanup();
findpos(10,(int)o->value(),o);
}
void RKRGUI::cb_WhaWha_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_activar_i(o,v);
}

void RKRGUI::cb_WhaWha_preset_i(Fl_Choice* o, void* v) {
  rkr->WhaWha_Bypass=0;
long long ud= (long long) v;
if((ud==0)||(ud==12010))rkr->efx_WhaWha->setpreset((int) o->value()); 
WhaWha_WD->value(rkr->efx_WhaWha->getpar(0)-64);
WhaWha_pan->value(rkr->efx_WhaWha->getpar(1)-64);
WhaWha_freq->value(rkr->efx_WhaWha->getpar(2));
WhaWha_rnd->value(rkr->efx_WhaWha->getpar(3));
WhaWha_lfotype->value(rkr->efx_WhaWha->getpar(4));
WhaWha_stdf->value(rkr->efx_WhaWha->getpar(5));
WhaWha_dpth->value(rkr->efx_WhaWha->getpar(6));
WhaWha_ampsns->value(rkr->efx_WhaWha->getpar(7));
WhaWha_ampsnsinv->value(rkr->efx_WhaWha->getpar(8));
WhaWha_smooth->value(rkr->efx_WhaWha->getpar(9));
if((int)WhaWha_activar->value()) rkr->WhaWha_Bypass=1;
}
void RKRGUI::cb_WhaWha_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_WhaWha_preset[] = {
 {"WahWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"AutoWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Sweep", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"VocalMorph1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"VocalMorph2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_WhaWha_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(28);
 return;
} 
rkr->efx_WhaWha->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_WhaWha_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_WD_i(o,v);
}

void RKRGUI::cb_WhaWha_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(66);
 return;
} 
rkr->efx_WhaWha->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_WhaWha_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_pan_i(o,v);
}

void RKRGUI::cb_WhaWha_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(75);
 return;
} 
rkr->efx_WhaWha->changepar(2,(int)o->value());
}
void RKRGUI::cb_WhaWha_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_freq_i(o,v);
}

void RKRGUI::cb_WhaWha_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(108);
 return;
} 
rkr->efx_WhaWha->changepar(3,(int)o->value());
}
void RKRGUI::cb_WhaWha_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_rnd_i(o,v);
}

void RKRGUI::cb_WhaWha_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_WhaWha->changepar(4,(int)o->value());
}
void RKRGUI::cb_WhaWha_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_lfotype_i(o,v);
}

void RKRGUI::cb_WhaWha_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(102);
 return;
} 
rkr->efx_WhaWha->changepar(5,(int)o->value());
}
void RKRGUI::cb_WhaWha_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_stdf_i(o,v);
}

void RKRGUI::cb_WhaWha_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(1);
 return;
} 
rkr->efx_WhaWha->changepar(6,(int)o->value());
}
void RKRGUI::cb_WhaWha_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_dpth_i(o,v);
}

void RKRGUI::cb_WhaWha_ampsns_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(111);
 return;
} 
rkr->efx_WhaWha->changepar(7,(int)o->value());
}
void RKRGUI::cb_WhaWha_ampsns(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_ampsns_i(o,v);
}

void RKRGUI::cb_WhaWha_ampsnsinv_i(Fl_Check_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(112);
 return;
} 
rkr->efx_WhaWha->changepar(8,(int)o->value());
}
void RKRGUI::cb_WhaWha_ampsnsinv(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_ampsnsinv_i(o,v);
}

void RKRGUI::cb_WhaWha_smooth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(113);
 return;
} 
rkr->efx_WhaWha->changepar(9,(int)o->value());
}
void RKRGUI::cb_WhaWha_smooth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WhaWha_smooth_i(o,v);
}

void RKRGUI::cb_Alienwah_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Alienwah_Bypass);
 return;
}
rkr->Alienwah_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Alienwah->cleanup();
findpos(11,(int)o->value(),o);
}
void RKRGUI::cb_Alienwah_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_activar_i(o,v);
}

void RKRGUI::cb_Alienwah_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12011))rkr->efx_Alienwah->setpreset((int) o->value());
Alienwah_WD->value(rkr->efx_Alienwah->getpar(0)-64);
Alienwah_pan->value(rkr->efx_Alienwah->getpar(1)-64);
Alienwah_freq->value(rkr->efx_Alienwah->getpar(2));
Alienwah_rnd->value(rkr->efx_Alienwah->getpar(3));
Alienwah_lfotype->value(rkr->efx_Alienwah->getpar(4));
Alienwah_stdf->value(rkr->efx_Alienwah->getpar(5));
Alienwah_dpth->value(rkr->efx_Alienwah->getpar(6));
Alienwah_fb->value(rkr->efx_Alienwah->getpar(7));
Alienwah_delay->value(rkr->efx_Alienwah->getpar(8));
Alienwah_LR->value(rkr->efx_Alienwah->getpar(9)-64);
Alienwah_phase->value(rkr->efx_Alienwah->getpar(10));
}
void RKRGUI::cb_Alienwah_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Alienwah_preset[] = {
 {"AlienWah1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"AlienWah2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"AlienWah3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"AlienWah4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Alienwah_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(55);
 return;
} 
rkr->efx_Alienwah->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_Alienwah_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_WD_i(o,v);
}

void RKRGUI::cb_Alienwah_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(61);
 return;
} 
rkr->efx_Alienwah->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_Alienwah_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_pan_i(o,v);
}

void RKRGUI::cb_Alienwah_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(76);
 return;
} 
rkr->efx_Alienwah->changepar(2,(int)o->value());
}
void RKRGUI::cb_Alienwah_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_freq_i(o,v);
}

void RKRGUI::cb_Alienwah_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(109);
 return;
} 
rkr->efx_Alienwah->changepar(3,(int)o->value());
}
void RKRGUI::cb_Alienwah_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_rnd_i(o,v);
}

void RKRGUI::cb_Alienwah_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Alienwah->changepar(4,(int)o->value());
}
void RKRGUI::cb_Alienwah_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_lfotype_i(o,v);
}

void RKRGUI::cb_Alienwah_phase_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(115);
 return;
} 
rkr->efx_Alienwah->changepar(10,(int)o->value());
}
void RKRGUI::cb_Alienwah_phase(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_phase_i(o,v);
}

void RKRGUI::cb_Alienwah_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(103);
 return;
} 
rkr->efx_Alienwah->changepar(5,(int)o->value());
}
void RKRGUI::cb_Alienwah_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_stdf_i(o,v);
}

void RKRGUI::cb_Alienwah_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(20);
 return;
} 
rkr->efx_Alienwah->changepar(6,(int)o->value());
}
void RKRGUI::cb_Alienwah_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_dpth_i(o,v);
}

void RKRGUI::cb_Alienwah_delay_i(SliderW* o, void*) {
  rkr->Alienwah_Bypass=0;
rkr->efx_Alienwah->changepar(8,(int)o->value());
if (Alienwah_activar->value()) rkr->Alienwah_Bypass=1;
}
void RKRGUI::cb_Alienwah_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_delay_i(o,v);
}

void RKRGUI::cb_Alienwah_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(82);
 return;
} 
rkr->efx_Alienwah->changepar(7,(int)o->value());
}
void RKRGUI::cb_Alienwah_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_fb_i(o,v);
}

void RKRGUI::cb_Alienwah_LR_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(96);
 return;
} 
rkr->efx_Alienwah->changepar(9,(int)(o->value()+64));
}
void RKRGUI::cb_Alienwah_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Alienwah_LR_i(o,v);
}

void RKRGUI::cb_Cabinet_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Cabinet_Bypass);
 return;
}
rkr->Cabinet_Bypass=(int)o->value();
findpos(12,(int)o->value(),o);
}
void RKRGUI::cb_Cabinet_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Cabinet_activar_i(o,v);
}

void RKRGUI::cb_Cabinet_preset_i(Fl_Choice* o, void*) {
  rkr->Cabinet_setpreset((int) o->value());
}
void RKRGUI::cb_Cabinet_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Cabinet_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Cabinet_preset[] = {
 {"Marshall-4-12", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Celestion G12M", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Jensen Alnico P12N", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Jensen Alnico P15N", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Delta Demon", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Celestion-EVH12", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Eminence Copperhead", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mesa Boogie", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Jazz-Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Vox-Bright", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Marshall-I", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Cabinet_output_i(SliderW* o, void*) {
  rkr->efx_Cabinet->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_Cabinet_output(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Cabinet_output_i(o,v);
}

void RKRGUI::cb_pan_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Pan_Bypass);
 return;
}
rkr->Pan_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Pan->cleanup();
findpos(13,(int)o->value(),o);
}
void RKRGUI::cb_pan_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_activar_i(o,v);
}

void RKRGUI::cb_pan_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12013))rkr->efx_Pan->setpreset((int) o->value());
pan_WD->value(rkr->efx_Pan->getpar(0)-64);
pan_pan->value(rkr->efx_Pan->getpar(1)-64);
pan_freq->value(rkr->efx_Pan->getpar(2));
pan_rnd->value(rkr->efx_Pan->getpar(3));
pan_lfotype->value(rkr->efx_Pan->getpar(4));
pan_stdf->value(rkr->efx_Pan->getpar(5));
pan_extra->value(rkr->efx_Pan->getpar(6));
pan_autopan->value(rkr->efx_Pan->getpar(7));
pan_extraon->value(rkr->efx_Pan->getpar(8));
}
void RKRGUI::cb_pan_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_pan_preset[] = {
 {"AutoPan", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Extra Stereo", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_pan_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(58);
 return;
} 
rkr->efx_Pan->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_pan_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_WD_i(o,v);
}

void RKRGUI::cb_pan_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(67);
 return;
} 
rkr->efx_Pan->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_pan_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_pan_i(o,v);
}

void RKRGUI::cb_pan_autopan_i(Fl_Check_Button* o, void*) {
  rkr->efx_Pan->changepar(7,(int)o->value());
}
void RKRGUI::cb_pan_autopan(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_autopan_i(o,v);
}

void RKRGUI::cb_pan_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(77);
 return;
} 
rkr->efx_Pan->changepar(2,(int)o->value());
}
void RKRGUI::cb_pan_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_freq_i(o,v);
}

void RKRGUI::cb_pan_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(110);
 return;
} 
rkr->efx_Pan->changepar(3,(int)o->value());
}
void RKRGUI::cb_pan_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_rnd_i(o,v);
}

void RKRGUI::cb_pan_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Pan->changepar(4,(int)o->value());
}
void RKRGUI::cb_pan_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_lfotype_i(o,v);
}

void RKRGUI::cb_pan_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(104);
 return;
} 
rkr->efx_Pan->changepar(5,(int)o->value());
}
void RKRGUI::cb_pan_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_stdf_i(o,v);
}

void RKRGUI::cb_pan_extraon_i(Fl_Check_Button* o, void*) {
  rkr->efx_Pan->changepar(8,(int)o->value());
}
void RKRGUI::cb_pan_extraon(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_extraon_i(o,v);
}

void RKRGUI::cb_pan_extra_i(SliderW* o, void*) {
  rkr->efx_Pan->changepar(6,(int)o->value());
}
void RKRGUI::cb_pan_extra(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_pan_extra_i(o,v);
}

void RKRGUI::cb_har_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Harmonizer_Bypass);
 return;
}
rkr->Harmonizer_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Har->cleanup();
rkr->efx_Har->changepar(3,rkr->efx_Har->getpar(3));
Chord(0);
findpos(14,(int)o->value(),o);
}
void RKRGUI::cb_har_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_activar_i(o,v);
}

void RKRGUI::cb_har_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12014))rkr->efx_Har->setpreset((int)o->value());
har_WD->value(rkr->efx_Har->getpar(0)-64);
har_pan->value(rkr->efx_Har->getpar(1)-64);
har_gan->value(rkr->efx_Har->getpar(2)-64);
har_int->value(rkr->efx_Har->getpar(3)-12);
har_SELECT->value(rkr->efx_Har->getpar(5));
har_note->value(rkr->efx_Har->getpar(6));
har_type->value(rkr->efx_Har->getpar(7));
har_freq1->value(rkr->efx_Har->getpar(4));
har_gan1->value(rkr->efx_Har->getpar(8)-64);
har_q1->value(rkr->efx_Har->getpar(9)-64);
har_MIDI->value(rkr->efx_Har->getpar(10));
if ((rkr->efx_Har->PMIDI) || (rkr->efx_Har->PSELECT)) Chord(0);
}
void RKRGUI::cb_har_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_har_preset[] = {
 {"Plain", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Octavator", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"3m Down", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_har_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(31);
 return;
} 
rkr->efx_Har->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_har_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_WD_i(o,v);
}

void RKRGUI::cb_har_int_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(27);
 return;
} 
rkr->Harmonizer_Bypass=0;
rkr->efx_Har->changepar(3,(int)(o->value()+12));
if((int)har_activar->value())rkr->Harmonizer_Bypass=1;
}
void RKRGUI::cb_har_int(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_int_i(o,v);
}

void RKRGUI::cb_har_gan_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(2,(int)(o->value()+64));
}
void RKRGUI::cb_har_gan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_gan_i(o,v);
}

void RKRGUI::cb_har_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(49);
 return;
} 
rkr->efx_Har->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_har_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_pan_i(o,v);
}

void RKRGUI::cb_har_freq1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(26);
 return;
} 
rkr->efx_Har->changepar(4,(int)o->value());
}
void RKRGUI::cb_har_freq1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_freq1_i(o,v);
}

void RKRGUI::cb_har_gan1_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(8,(int)(o->value()+64));
}
void RKRGUI::cb_har_gan1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_gan1_i(o,v);
}

void RKRGUI::cb_har_q1_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(9,(int)(o->value()+64));
}
void RKRGUI::cb_har_q1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_q1_i(o,v);
}

void RKRGUI::cb_har_MIDI_i(Fl_Check_Button* o, void*) {
  rkr->efx_Har->changepar(10,(int)o->value());
rkr->RC->cleanup();
if(!(int)o->value())rkr->efx_Har->changepar(3,rkr->efx_Har->getpar(3));
}
void RKRGUI::cb_har_MIDI(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_MIDI_i(o,v);
}

void RKRGUI::cb_har_SELECT_i(Fl_Check_Button* o, void*) {
  rkr->efx_Har->changepar(5,(int)o->value());
rkr->RC->cleanup();
if(!(int)o->value())rkr->efx_Har->changepar(3,rkr->efx_Har->getpar(3));
Chord(0);
}
void RKRGUI::cb_har_SELECT(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_SELECT_i(o,v);
}

void RKRGUI::cb_har_note_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(6,(unsigned char)o->value());
Chord(0);
}
void RKRGUI::cb_har_note(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_note_i(o,v);
}

void RKRGUI::cb_har_type_i(SliderW* o, void*) {
  rkr->efx_Har->changepar(7,(unsigned char)o->value());
Chord(0);
}
void RKRGUI::cb_har_type(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_har_type_i(o,v);
}

void RKRGUI::cb_musdelay_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->MusDelay_Bypass);
 return;
}
rkr->MusDelay_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_MusDelay->cleanup();
findpos(15,(int)o->value(),o);
}
void RKRGUI::cb_musdelay_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_activar_i(o,v);
}

void RKRGUI::cb_musdelay_preset_i(Fl_Choice* o, void* v) {
  rkr->MusDelay_Bypass=0;
long long ud= (long long) v;
if((ud==0)||(ud==12015))rkr->efx_MusDelay->setpreset(o->value());
musdelay_WD->value(rkr->efx_MusDelay->getpar(0)-64);
musdelay_tempo->value(rkr->efx_MusDelay->getpar(10));
musdelay_pan1->value(rkr->efx_MusDelay->getpar(1)-64);
musdelay_pan2->value(rkr->efx_MusDelay->getpar(7)-64);
musdelay_delay1->value(rkr->efx_MusDelay->getpar(2)-1);
musdelay_delay2->value(rkr->efx_MusDelay->getpar(8)-1);
musdelay_delay3->value(rkr->efx_MusDelay->getpar(3)-1);
musdelay_fb1->value(rkr->efx_MusDelay->getpar(5));
musdelay_fb2->value(rkr->efx_MusDelay->getpar(9));
musdelay_LRc->value(rkr->efx_MusDelay->getpar(4)-64);
musdelay_gain1->value(rkr->efx_MusDelay->getpar(11)-64);
musdelay_gain2->value(rkr->efx_MusDelay->getpar(12)-64);
musdelay_damp->value(rkr->efx_MusDelay->getpar(6));
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_musdelay_preset[] = {
 {"Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_musdelay_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(56);
 return;
} 
rkr->efx_MusDelay->changepar(0,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_WD_i(o,v);
}

void RKRGUI::cb_musdelay_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(98);
 return;
} 
rkr->efx_MusDelay->changepar(4,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_LRc_i(o,v);
}

void RKRGUI::cb_musdelay_pan1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(62);
 return;
} 
rkr->efx_MusDelay->changepar(1,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_pan1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_pan1_i(o,v);
}

void RKRGUI::cb_musdelay_pan2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(65);
 return;
} 
rkr->efx_MusDelay->changepar(7,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_pan2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_pan2_i(o,v);
}

void RKRGUI::cb_musdelay_delay1_i(Fl_Choice* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(2,o->value()+1);
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_delay1(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_delay1_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_musdelay_delay1[] = {
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/6", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_musdelay_delay3_i(Fl_Choice* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(3,o->value()+1);
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_delay3(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_delay3_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_musdelay_delay3[] = {
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/6", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"0", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_musdelay_delay2_i(Fl_Choice* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(8,o->value()+1);
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_delay2(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_delay2_i(o,v);
}

void RKRGUI::cb_musdelay_tempo_i(SliderW* o, void*) {
  rkr->MusDelay_Bypass=0;
rkr->efx_MusDelay->changepar(10,(int)o->value());
if((int)musdelay_activar->value())rkr->MusDelay_Bypass=1;
}
void RKRGUI::cb_musdelay_tempo(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_tempo_i(o,v);
}

void RKRGUI::cb_musdelay_gain1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(24);
 return;
} 
rkr->efx_MusDelay->changepar(11,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_gain1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_gain1_i(o,v);
}

void RKRGUI::cb_musdelay_gain2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(25);
 return;
} 
rkr->efx_MusDelay->changepar(12,(int)o->value()+64);
}
void RKRGUI::cb_musdelay_gain2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_gain2_i(o,v);
}

void RKRGUI::cb_musdelay_fb1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(83);
 return;
} 
rkr->efx_MusDelay->changepar(5,(int)o->value());
}
void RKRGUI::cb_musdelay_fb1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_fb1_i(o,v);
}

void RKRGUI::cb_musdelay_fb2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(84);
 return;
} 
rkr->efx_MusDelay->changepar(9,(int)o->value());
}
void RKRGUI::cb_musdelay_fb2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_fb2_i(o,v);
}

void RKRGUI::cb_musdelay_damp_i(SliderW* o, void*) {
  rkr->efx_MusDelay->changepar(6,(int)o->value());
}
void RKRGUI::cb_musdelay_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_musdelay_damp_i(o,v);
}

void RKRGUI::cb_gate_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Gate_Bypass);
 return;
}
rkr->Gate_Bypass=(int)o->value();
findpos(16,(int)o->value(),o);
}
void RKRGUI::cb_gate_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_activar_i(o,v);
}

void RKRGUI::cb_gate_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12016))rkr->efx_Gate->Gate_Change_Preset((int) o->value());
gate_ATime->value(rkr->efx_Gate->getpar(3));
gate_RTime->value(rkr->efx_Gate->getpar(4));
gate_range->value(rkr->efx_Gate->getpar(2));
gate_threshold->value(rkr->efx_Gate->getpar(1));
gate_hold->value(rkr->efx_Gate->getpar(7));
gate_HPF->value(rkr->efx_Gate->getpar(6));
gate_LPF->value(rkr->efx_Gate->getpar(5));
}
void RKRGUI::cb_gate_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_gate_preset[] = {
 {"0dB", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"-10dB", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"-20dB", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_gate_ATime_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(3,(int)o->value());
}
void RKRGUI::cb_gate_ATime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_ATime_i(o,v);
}

void RKRGUI::cb_gate_RTime_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(4, (int) o->value());
}
void RKRGUI::cb_gate_RTime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_RTime_i(o,v);
}

void RKRGUI::cb_gate_range_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(2, (int) o->value());
}
void RKRGUI::cb_gate_range(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_range_i(o,v);
}

void RKRGUI::cb_gate_threshold_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(1, (int)o->value());
}
void RKRGUI::cb_gate_threshold(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_threshold_i(o,v);
}

void RKRGUI::cb_gate_hold_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(7,(int)o->value());
}
void RKRGUI::cb_gate_hold(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_hold_i(o,v);
}

void RKRGUI::cb_gate_LPF_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(5, (int)o->value());
}
void RKRGUI::cb_gate_LPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_LPF_i(o,v);
}

void RKRGUI::cb_gate_HPF_i(SliderW* o, void*) {
  rkr->efx_Gate->Gate_Change(6, (int)o->value());
}
void RKRGUI::cb_gate_HPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_gate_HPF_i(o,v);
}

void RKRGUI::cb_newdist_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->NewDist_Bypass);
 return;
}
rkr->NewDist_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_NewDist->cleanup();
findpos(17,(int)o->value(),o);
}
void RKRGUI::cb_newdist_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_activar_i(o,v);
}

void RKRGUI::cb_newdist_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12017))rkr->efx_NewDist->setpreset((int) o->value());
newdist_WD->value(rkr->efx_NewDist->getpar(0)-64);
newdist_LRc->value(rkr->efx_NewDist->getpar(2)-64);
newdist_drive->value(rkr->efx_NewDist->getpar(3));
newdist_level->value(rkr->efx_NewDist->getpar(4));
newdist_tipo->value(rkr->efx_NewDist->getpar(5));
newdist_neg->value(rkr->efx_NewDist->getpar(6));
newdist_st->value(rkr->efx_NewDist->getpar(9));
newdist_oct->value(rkr->efx_NewDist->getpar(11));
newdist_pan->value(rkr->efx_NewDist->getpar(1)-64);
newdist_pf->value(rkr->efx_NewDist->getpar(10));
newdist_lpf->value(rkr->efx_NewDist->getpar(7));
newdist_hpf->value(rkr->efx_NewDist->getpar(8));
}
void RKRGUI::cb_newdist_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_newdist_preset[] = {
 {"New Dist 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"New Dist 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"New Dist 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_newdist_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(125);
 return;
} 
rkr->efx_NewDist->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_newdist_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_WD_i(o,v);
}

void RKRGUI::cb_newdist_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(127);
 return;
} 
rkr->efx_NewDist->changepar(2,(int)(o->value()+64));
}
void RKRGUI::cb_newdist_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_LRc_i(o,v);
}

void RKRGUI::cb_newdist_drive_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(2);
 return;
} 
rkr->efx_NewDist->changepar(3,(int)o->value());
}
void RKRGUI::cb_newdist_drive(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_drive_i(o,v);
}

void RKRGUI::cb_newdist_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(3);
 return;
} 
rkr->efx_NewDist->changepar(4,(int)o->value());
}
void RKRGUI::cb_newdist_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_level_i(o,v);
}

void RKRGUI::cb_newdist_tipo_i(Fl_Choice* o, void*) {
  rkr->efx_NewDist->changepar(5,(int)o->value());
}
void RKRGUI::cb_newdist_tipo(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_tipo_i(o,v);
}

void RKRGUI::cb_newdist_neg_i(Fl_Check_Button* o, void*) {
  rkr->efx_NewDist->changepar(6,(int)o->value());
}
void RKRGUI::cb_newdist_neg(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_neg_i(o,v);
}

void RKRGUI::cb_newdist_st_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(6);
 return;
} 
rkr->efx_NewDist->changepar(9,(int)o->value());
}
void RKRGUI::cb_newdist_st(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_st_i(o,v);
}

void RKRGUI::cb_newdist_oct_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(8);
 return;
} 
rkr->efx_NewDist->changepar(11,(int)o->value());
}
void RKRGUI::cb_newdist_oct(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_oct_i(o,v);
}

void RKRGUI::cb_newdist_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(126);
 return;
} 
rkr->efx_NewDist->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_newdist_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_pan_i(o,v);
}

void RKRGUI::cb_newdist_pf_i(Fl_Check_Button* o, void*) {
  rkr->efx_NewDist->changepar(10,(int)o->value());
}
void RKRGUI::cb_newdist_pf(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_pf_i(o,v);
}

void RKRGUI::cb_newdist_lpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(4);
 return;
} 
rkr->efx_NewDist->changepar(7,(int)o->value());
}
void RKRGUI::cb_newdist_lpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_lpf_i(o,v);
}

void RKRGUI::cb_newdist_hpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(5);
 return;
} 
rkr->efx_NewDist->changepar(8,(int)o->value());
}
void RKRGUI::cb_newdist_hpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_newdist_hpf_i(o,v);
}

void RKRGUI::cb_aphaser_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->APhaser_Bypass);
 return;
}
rkr->APhaser_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_APhaser->cleanup();
findpos(18,(int)o->value(),o);
}
void RKRGUI::cb_aphaser_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_activar_i(o,v);
}

void RKRGUI::cb_aphaser_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12018))rkr->efx_APhaser->setpreset((int) o->value());
aphaser_WD->value(rkr->efx_APhaser->getpar(0)-64);
aphaser_pan->value(rkr->efx_APhaser->getpar(1));
aphaser_freq->value(rkr->efx_APhaser->getpar(2));
aphaser_lfotype->value(rkr->efx_APhaser->getpar(4));
aphaser_stdf->value(rkr->efx_APhaser->getpar(5));
aphaser_dpth->value(rkr->efx_APhaser->getpar(6));
aphaser_stages->value(rkr->efx_APhaser->getpar(8));
aphaser_fb->value(rkr->efx_APhaser->getpar(7)-64);
aphaser_LR->value(rkr->efx_APhaser->getpar(9));
aphaser_subs->value(rkr->efx_APhaser->getpar(10));
aphaser_phase->value(rkr->efx_APhaser->getpar(11));
aphaser_hyper->value(rkr->efx_APhaser->getpar(12));
}
void RKRGUI::cb_aphaser_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_aphaser_preset[] = {
 {"Phaser 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser 6", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_aphaser_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(117);
 return;
} 
rkr->efx_APhaser->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_aphaser_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_WD_i(o,v);
}

void RKRGUI::cb_aphaser_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_APhaser->changepar(4,(int)o->value());
}
void RKRGUI::cb_aphaser_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_lfotype_i(o,v);
}

void RKRGUI::cb_aphaser_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(119);
 return;
} 
rkr->efx_APhaser->changepar(2,(int)o->value());
}
void RKRGUI::cb_aphaser_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_freq_i(o,v);
}

void RKRGUI::cb_aphaser_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(121);
 return;
} 
rkr->efx_APhaser->changepar(6,(int)o->value());
}
void RKRGUI::cb_aphaser_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_dpth_i(o,v);
}

void RKRGUI::cb_aphaser_phase_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(120);
 return;
} 
rkr->efx_APhaser->changepar(11,(int)o->value());
}
void RKRGUI::cb_aphaser_phase(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_phase_i(o,v);
}

void RKRGUI::cb_aphaser_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(122);
 return;
} 
rkr->efx_APhaser->changepar(7,(int)(o->value()+64));
}
void RKRGUI::cb_aphaser_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_fb_i(o,v);
}

void RKRGUI::cb_aphaser_LR_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(123);
 return;
} 
rkr->efx_APhaser->changepar(9,(int)o->value());
}
void RKRGUI::cb_aphaser_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_LR_i(o,v);
}

void RKRGUI::cb_aphaser_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(118);
 return;
} 
rkr->efx_APhaser->changepar(1,(int)o->value());
}
void RKRGUI::cb_aphaser_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_pan_i(o,v);
}

void RKRGUI::cb_aphaser_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(124);
 return;
} 
rkr->efx_APhaser->changepar(5,(int)o->value());
}
void RKRGUI::cb_aphaser_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_stdf_i(o,v);
}

void RKRGUI::cb_aphaser_stages_i(Fl_Counter* o, void*) {
  rkr->efx_APhaser->changepar(8,(int)o->value());
}
void RKRGUI::cb_aphaser_stages(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_stages_i(o,v);
}

void RKRGUI::cb_aphaser_hyper_i(Fl_Check_Button* o, void*) {
  rkr->efx_APhaser->changepar(12,(int)o->value());
}
void RKRGUI::cb_aphaser_hyper(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_hyper_i(o,v);
}

void RKRGUI::cb_aphaser_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_APhaser->changepar(10,(int)o->value());
}
void RKRGUI::cb_aphaser_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_aphaser_subs_i(o,v);
}

void RKRGUI::cb_valve_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Valve_Bypass);
 return;
}
rkr->Valve_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Valve->cleanup();
findpos(19,(int)o->value(),o);
}
void RKRGUI::cb_valve_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_activar_i(o,v);
}

void RKRGUI::cb_valve_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12019))rkr->efx_Valve->setpreset((int)o->value());
valve_WD->value(rkr->efx_Valve->getpar(0)-64);
valve_LRc->value(rkr->efx_Valve->getpar(2)-64);
valve_drive->value(rkr->efx_Valve->getpar(3));
valve_level->value(rkr->efx_Valve->getpar(4));
valve_neg->value(rkr->efx_Valve->getpar(5));
valve_st->value(rkr->efx_Valve->getpar(8));
valve_pan->value(rkr->efx_Valve->getpar(1)-64);
valve_pf->value(rkr->efx_Valve->getpar(9));
valve_lpf->value(rkr->efx_Valve->getpar(6));
valve_hpf->value(rkr->efx_Valve->getpar(7));
valve_Q->value(rkr->efx_Valve->getpar(10));
valve_ed->value(rkr->efx_Valve->getpar(11));
valve_Pre->value(rkr->efx_Valve->getpar(12));
}
void RKRGUI::cb_valve_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_valve_preset[] = {
 {"Valve 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Valve 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Valve 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_valve_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(169);
 return;
} 
rkr->efx_Valve->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_valve_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_WD_i(o,v);
}

void RKRGUI::cb_valve_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(170);
 return;
} 
rkr->efx_Valve->changepar(2,(int)(o->value()+64));
}
void RKRGUI::cb_valve_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_LRc_i(o,v);
}

void RKRGUI::cb_valve_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(171);
 return;
} 
rkr->efx_Valve->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_valve_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_pan_i(o,v);
}

void RKRGUI::cb_valve_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(172);
 return;
} 
rkr->efx_Valve->changepar(4,(int)o->value());
}
void RKRGUI::cb_valve_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_level_i(o,v);
}

void RKRGUI::cb_valve_drive_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(173);
 return;
} 
rkr->efx_Valve->changepar(3,(int)o->value());
}
void RKRGUI::cb_valve_drive(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_drive_i(o,v);
}

void RKRGUI::cb_valve_ed_i(Fl_Check_Button* o, void*) {
  rkr->efx_Valve->changepar(11,(int)o->value());
}
void RKRGUI::cb_valve_ed(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_ed_i(o,v);
}

void RKRGUI::cb_valve_Q_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(174);
 return;
} 
rkr->efx_Valve->changepar(10,(int)o->value());
}
void RKRGUI::cb_valve_Q(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_Q_i(o,v);
}

void RKRGUI::cb_valve_Pre_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(175);
 return;
} 
rkr->efx_Valve->changepar(12,(int)o->value());
}
void RKRGUI::cb_valve_Pre(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_Pre_i(o,v);
}

void RKRGUI::cb_valve_pf_i(Fl_Check_Button* o, void*) {
  rkr->efx_Valve->changepar(9,(int)o->value());
}
void RKRGUI::cb_valve_pf(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_pf_i(o,v);
}

void RKRGUI::cb_valve_st_i(Fl_Check_Button* o, void*) {
  rkr->efx_Valve->changepar(8,(int)o->value());
}
void RKRGUI::cb_valve_st(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_st_i(o,v);
}

void RKRGUI::cb_valve_neg_i(Fl_Check_Button* o, void*) {
  rkr->efx_Valve->changepar(5,(int)o->value());
}
void RKRGUI::cb_valve_neg(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_neg_i(o,v);
}

void RKRGUI::cb_valve_lpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(176);
 return;
} 
rkr->efx_Valve->changepar(6,(int)o->value());
}
void RKRGUI::cb_valve_lpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_lpf_i(o,v);
}

void RKRGUI::cb_valve_hpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(177);
 return;
} 
rkr->efx_Valve->changepar(7,(int)o->value());
}
void RKRGUI::cb_valve_hpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_valve_hpf_i(o,v);
}

void RKRGUI::cb_dflange_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->DFlange_Bypass);
 return;
}
rkr->DFlange_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_DFlange->cleanup();
findpos(20,(int)o->value(),o);
}
void RKRGUI::cb_dflange_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_activar_i(o,v);
}

void RKRGUI::cb_dflange_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12020))rkr->efx_DFlange->setpreset((int)o->value());
dflange_WD->value(rkr->efx_DFlange->getpar(0));
dflange_pan->value(rkr->efx_DFlange->getpar(1));
dflange_freq->value(rkr->efx_DFlange->getpar(10));
dflange_rnd->value(rkr->efx_DFlange->getpar(13));
dflange_lfotype->value(rkr->efx_DFlange->getpar(12));
dflange_stdf->value(rkr->efx_DFlange->getpar(11));
dflange_width->value(rkr->efx_DFlange->getpar(4));
dflange_depth->value(rkr->efx_DFlange->getpar(3));
dflange_fb->value(rkr->efx_DFlange->getpar(6));
dflange_LR->value(rkr->efx_DFlange->getpar(2));
dflange_subs->value(rkr->efx_DFlange->getpar(8));
dflange_tz->value(rkr->efx_DFlange->getpar(9));
dflange_offset->value(rkr->efx_DFlange->getpar(5));
dflange_lpf->value(rkr->efx_DFlange->getpar(7));
}
void RKRGUI::cb_dflange_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_dflange_preset[] = {
 {"Dual Flange 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Flange-Wah", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"FbFlange", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"SoftFlange", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Flanger", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Deep Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Bright Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_dflange_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(158);
 return;
} 
rkr->efx_DFlange->changepar(0,(int)(o->value()));
}
void RKRGUI::cb_dflange_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_WD_i(o,v);
}

void RKRGUI::cb_dflange_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(159);
 return;
} 
rkr->efx_DFlange->changepar(1,(int)o->value());
}
void RKRGUI::cb_dflange_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_pan_i(o,v);
}

void RKRGUI::cb_dflange_LR_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(160);
 return;
} 
rkr->efx_DFlange->changepar(2,(int)o->value());
}
void RKRGUI::cb_dflange_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_LR_i(o,v);
}

void RKRGUI::cb_dflange_depth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(161);
 return;
} 
rkr->efx_DFlange->changepar(3,(int)o->value());
}
void RKRGUI::cb_dflange_depth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_depth_i(o,v);
}

void RKRGUI::cb_dflange_width_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(162);
 return;
} 
rkr->efx_DFlange->changepar(4,(int)o->value());
}
void RKRGUI::cb_dflange_width(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_width_i(o,v);
}

void RKRGUI::cb_dflange_offset_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(163);
 return;
} 
rkr->efx_DFlange->changepar(5,(int)o->value());
}
void RKRGUI::cb_dflange_offset(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_offset_i(o,v);
}

void RKRGUI::cb_dflange_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(164);
 return;
} 
rkr->efx_DFlange->changepar(6,(int)o->value());
}
void RKRGUI::cb_dflange_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_fb_i(o,v);
}

void RKRGUI::cb_dflange_lpf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(165);
 return;
} 
rkr->efx_DFlange->changepar(7,(int)o->value());
}
void RKRGUI::cb_dflange_lpf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_lpf_i(o,v);
}

void RKRGUI::cb_dflange_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_DFlange->changepar(8,(int)o->value());
}
void RKRGUI::cb_dflange_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_subs_i(o,v);
}

void RKRGUI::cb_dflange_tz_i(Fl_Check_Button* o, void*) {
  rkr->efx_DFlange->changepar(9,(int)o->value());
}
void RKRGUI::cb_dflange_tz(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_tz_i(o,v);
}

void RKRGUI::cb_dflange_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(166);
 return;
} 
rkr->efx_DFlange->changepar(10,(int)o->value());
}
void RKRGUI::cb_dflange_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_freq_i(o,v);
}

void RKRGUI::cb_dflange_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(167);
 return;
} 
rkr->efx_DFlange->changepar(11,(int)o->value());
}
void RKRGUI::cb_dflange_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_stdf_i(o,v);
}

void RKRGUI::cb_dflange_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_DFlange->changepar(12,(int)o->value());
}
void RKRGUI::cb_dflange_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_lfotype_i(o,v);
}

void RKRGUI::cb_dflange_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(168);
 return;
} 
rkr->efx_DFlange->changepar(13,(int)o->value());
}
void RKRGUI::cb_dflange_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_dflange_rnd_i(o,v);
}

void RKRGUI::cb_ring_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Ring_Bypass);
 return;
}
rkr->Ring_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Ring->cleanup();
findpos(21,(int)o->value(),o);
}
void RKRGUI::cb_ring_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_activar_i(o,v);
}

void RKRGUI::cb_ring_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12021))rkr->efx_Ring->setpreset((int) o->value());
ring_WD->value(rkr->efx_Ring->getpar(0));
ring_LRc->value(rkr->efx_Ring->getpar(2));
ring_input->value(rkr->efx_Ring->getpar(11));
ring_level->value(rkr->efx_Ring->getpar(3));
ring_st->value(rkr->efx_Ring->getpar(6));
ring_depth->value(rkr->efx_Ring->getpar(4));
ring_freq->value(rkr->efx_Ring->getpar(5));
ring_sin->value(rkr->efx_Ring->getpar(7));
ring_tri->value(rkr->efx_Ring->getpar(8));
ring_saw->value(rkr->efx_Ring->getpar(9));
ring_squ->value(rkr->efx_Ring->getpar(10));
ring_pan->value(rkr->efx_Ring->getpar(1));
ring_afreq->value(rkr->efx_Ring->getpar(12));
}
void RKRGUI::cb_ring_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_ring_preset[] = {
 {"Saw_Sin", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"E string", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"A string", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Dissonance", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Fast Beat", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Ring Amp", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_ring_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(178);
 return;
} 
rkr->efx_Ring->changepar(0,(int)o->value());
}
void RKRGUI::cb_ring_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_WD_i(o,v);
}

void RKRGUI::cb_ring_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(179);
 return;
} 
rkr->efx_Ring->changepar(2,(int)o->value());
}
void RKRGUI::cb_ring_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_LRc_i(o,v);
}

void RKRGUI::cb_ring_input_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(180);
 return;
} 
rkr->efx_Ring->changepar(11,(int)o->value());
}
void RKRGUI::cb_ring_input(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_input_i(o,v);
}

void RKRGUI::cb_ring_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(181);
 return;
} 
rkr->efx_Ring->changepar(3,(int)o->value());
}
void RKRGUI::cb_ring_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_level_i(o,v);
}

void RKRGUI::cb_ring_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(182);
 return;
} 
rkr->efx_Ring->changepar(1,(int)o->value());
}
void RKRGUI::cb_ring_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_pan_i(o,v);
}

void RKRGUI::cb_ring_st_i(Fl_Check_Button* o, void*) {
  rkr->efx_Ring->changepar(6,(int)o->value());
}
void RKRGUI::cb_ring_st(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_st_i(o,v);
}

void RKRGUI::cb_ring_afreq_i(Fl_Check_Button* o, void*) {
  rkr->efx_Ring->changepar(12,(int)o->value());
}
void RKRGUI::cb_ring_afreq(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_afreq_i(o,v);
}

void RKRGUI::cb_ring_depth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(183);
 return;
} 
rkr->efx_Ring->changepar(4,(int)o->value());
}
void RKRGUI::cb_ring_depth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_depth_i(o,v);
}

void RKRGUI::cb_ring_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(184);
 return;
} 
rkr->efx_Ring->changepar(5,(int)o->value());
}
void RKRGUI::cb_ring_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_freq_i(o,v);
}

void RKRGUI::cb_ring_sin_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(185);
 return;
} 
rkr->efx_Ring->changepar(7,(int)o->value());
}
void RKRGUI::cb_ring_sin(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_sin_i(o,v);
}

void RKRGUI::cb_ring_tri_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(186);
 return;
} 
rkr->efx_Ring->changepar(8,(int)o->value());
}
void RKRGUI::cb_ring_tri(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_tri_i(o,v);
}

void RKRGUI::cb_ring_saw_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(187);
 return;
} 
rkr->efx_Ring->changepar(9,(int)o->value());
}
void RKRGUI::cb_ring_saw(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_saw_i(o,v);
}

void RKRGUI::cb_ring_squ_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(188);
 return;
} 
rkr->efx_Ring->changepar(10,(int)o->value());
}
void RKRGUI::cb_ring_squ(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ring_squ_i(o,v);
}

void RKRGUI::cb_exciter_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Exciter_Bypass);
 return;
}
rkr->Exciter_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Exciter->cleanup();
findpos(22,(int)o->value(),o);
}
void RKRGUI::cb_exciter_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_exciter_activar_i(o,v);
}

void RKRGUI::cb_exciter_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12022))rkr->efx_Exciter->setpreset((int) o->value());
ex_Gain->value(rkr->efx_Exciter->getpar(0));
ex_1->value(rkr->efx_Exciter->getpar(1));
ex_2->value(rkr->efx_Exciter->getpar(2));
ex_3->value(rkr->efx_Exciter->getpar(3));
ex_4->value(rkr->efx_Exciter->getpar(4));
ex_5->value(rkr->efx_Exciter->getpar(5));
ex_6->value(rkr->efx_Exciter->getpar(6));
ex_7->value(rkr->efx_Exciter->getpar(7));
ex_8->value(rkr->efx_Exciter->getpar(8));
ex_9->value(rkr->efx_Exciter->getpar(9));
ex_10->value(rkr->efx_Exciter->getpar(10));
ex_lfreq->value(rkr->efx_Exciter->getpar(11));
ex_hfreq->value(rkr->efx_Exciter->getpar(12));
}
void RKRGUI::cb_exciter_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_exciter_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_exciter_preset[] = {
 {"Plain", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Loudness", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Exciter 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Exciter 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Exciter 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_ex_Gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(189);
 return;
} 
rkr->efx_Exciter->changepar(0,(int)o->value());
}
void RKRGUI::cb_ex_Gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_Gain_i(o,v);
}

void RKRGUI::cb_ex_lfreq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(190);
 return;
} 
rkr->efx_Exciter->changepar(11,(int)o->value());
}
void RKRGUI::cb_ex_lfreq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_lfreq_i(o,v);
}

void RKRGUI::cb_ex_hfreq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(191);
 return;
} 
rkr->efx_Exciter->changepar(12,(int)o->value());
}
void RKRGUI::cb_ex_hfreq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_hfreq_i(o,v);
}

void RKRGUI::cb_ex_1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(192);
 return;
} 
rkr->efx_Exciter->changepar(1,(int)o->value());
}
void RKRGUI::cb_ex_1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_1_i(o,v);
}

void RKRGUI::cb_ex_2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(193);
 return;
} 
rkr->efx_Exciter->changepar(2,(int)o->value());
}
void RKRGUI::cb_ex_2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_2_i(o,v);
}

void RKRGUI::cb_ex_3_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(194);
 return;
} 
rkr->efx_Exciter->changepar(3,(int)o->value());
}
void RKRGUI::cb_ex_3(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_3_i(o,v);
}

void RKRGUI::cb_ex_4_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(195);
 return;
} 
rkr->efx_Exciter->changepar(4,(int)o->value());
}
void RKRGUI::cb_ex_4(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_4_i(o,v);
}

void RKRGUI::cb_ex_5_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(196);
 return;
} 
rkr->efx_Exciter->changepar(5,(int)o->value());
}
void RKRGUI::cb_ex_5(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_5_i(o,v);
}

void RKRGUI::cb_ex_6_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(197);
 return;
} 
rkr->efx_Exciter->changepar(6,(int)o->value());
}
void RKRGUI::cb_ex_6(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_6_i(o,v);
}

void RKRGUI::cb_ex_7_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(198);
 return;
} 
rkr->efx_Exciter->changepar(7,(int)o->value());
}
void RKRGUI::cb_ex_7(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_7_i(o,v);
}

void RKRGUI::cb_ex_8_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(199);
 return;
} 
rkr->efx_Exciter->changepar(8,(int)o->value());
}
void RKRGUI::cb_ex_8(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_8_i(o,v);
}

void RKRGUI::cb_ex_9_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(200);
 return;
} 
rkr->efx_Exciter->changepar(9,(int)o->value());
}
void RKRGUI::cb_ex_9(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_9_i(o,v);
}

void RKRGUI::cb_ex_10_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(201);
 return;
} 
rkr->efx_Exciter->changepar(10,(int)o->value());
}
void RKRGUI::cb_ex_10(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ex_10_i(o,v);
}

void RKRGUI::cb_mbdist_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->MBDist_Bypass);
 return;
}
rkr->MBDist_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_MBDist->cleanup();
findpos(23,(int)o->value(),o);
}
void RKRGUI::cb_mbdist_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_activar_i(o,v);
}

void RKRGUI::cb_mbdist_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12023))rkr->efx_MBDist->setpreset((int)o->value());
mbdist_WD->value(rkr->efx_MBDist->getpar(0)-64);
mbdist_LRc->value(rkr->efx_MBDist->getpar(2)-64);
mbdist_drive->value(rkr->efx_MBDist->getpar(3));
mbdist_level->value(rkr->efx_MBDist->getpar(4));
mbdist_tipoL->value(rkr->efx_MBDist->getpar(5));
mbdist_tipoM->value(rkr->efx_MBDist->getpar(6));
mbdist_tipoH->value(rkr->efx_MBDist->getpar(7));
mbdist_volL->value(rkr->efx_MBDist->getpar(8));
mbdist_volM->value(rkr->efx_MBDist->getpar(9));
mbdist_volH->value(rkr->efx_MBDist->getpar(10));
mbdist_neg->value(rkr->efx_MBDist->getpar(11));
mbdist_st->value(rkr->efx_MBDist->getpar(14));
mbdist_pan->value(rkr->efx_MBDist->getpar(1)-64);
mbdist_cross1->value(rkr->efx_MBDist->getpar(12));
mbdist_cross2->value(rkr->efx_MBDist->getpar(13));
}
void RKRGUI::cb_mbdist_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_mbdist_preset[] = {
 {"Saturation", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Distorsion 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Soft", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Modulated", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Crunch", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Distortion 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Distortion 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Distortion 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_mbdist_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(202);
 return;
} 
rkr->efx_MBDist->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_mbdist_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_WD_i(o,v);
}

void RKRGUI::cb_mbdist_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(203);
 return;
} 
rkr->efx_MBDist->changepar(2,(int)(o->value()+64));
}
void RKRGUI::cb_mbdist_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_LRc_i(o,v);
}

void RKRGUI::cb_mbdist_drive_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(204);
 return;
} 
rkr->efx_MBDist->changepar(3,(int)o->value());
}
void RKRGUI::cb_mbdist_drive(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_drive_i(o,v);
}

void RKRGUI::cb_mbdist_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(205);
 return;
} 
rkr->efx_MBDist->changepar(4,(int)o->value());
}
void RKRGUI::cb_mbdist_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_level_i(o,v);
}

void RKRGUI::cb_mbdist_volL_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(206);
 return;
} 
rkr->efx_MBDist->changepar(8,(int)o->value());
}
void RKRGUI::cb_mbdist_volL(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_volL_i(o,v);
}

void RKRGUI::cb_mbdist_volM_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(207);
 return;
} 
rkr->efx_MBDist->changepar(9,(int)o->value());
}
void RKRGUI::cb_mbdist_volM(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_volM_i(o,v);
}

void RKRGUI::cb_mbdist_volH_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(208);
 return;
} 
rkr->efx_MBDist->changepar(10,(int)o->value());
}
void RKRGUI::cb_mbdist_volH(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_volH_i(o,v);
}

void RKRGUI::cb_mbdist_cross1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(209);
 return;
} 
rkr->efx_MBDist->changepar(12,(int)o->value());
}
void RKRGUI::cb_mbdist_cross1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_cross1_i(o,v);
}

void RKRGUI::cb_mbdist_cross2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(210);
 return;
} 
rkr->efx_MBDist->changepar(13,(int)o->value());
}
void RKRGUI::cb_mbdist_cross2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_cross2_i(o,v);
}

void RKRGUI::cb_mbdist_tipoL_i(Fl_Choice* o, void*) {
  rkr->efx_MBDist->changepar(5,(int)o->value());
}
void RKRGUI::cb_mbdist_tipoL(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_tipoL_i(o,v);
}

void RKRGUI::cb_mbdist_tipoM_i(Fl_Choice* o, void*) {
  rkr->efx_MBDist->changepar(6,(int)o->value());
}
void RKRGUI::cb_mbdist_tipoM(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_tipoM_i(o,v);
}

void RKRGUI::cb_mbdist_tipoH_i(Fl_Choice* o, void*) {
  rkr->efx_MBDist->changepar(7,(int)o->value());
}
void RKRGUI::cb_mbdist_tipoH(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_tipoH_i(o,v);
}

void RKRGUI::cb_mbdist_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(211);
 return;
} 
rkr->efx_MBDist->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_mbdist_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_pan_i(o,v);
}

void RKRGUI::cb_mbdist_st_i(Fl_Check_Button* o, void*) {
  rkr->efx_MBDist->changepar(14,(int)o->value());
}
void RKRGUI::cb_mbdist_st(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_st_i(o,v);
}

void RKRGUI::cb_mbdist_neg_i(Fl_Check_Button* o, void*) {
  rkr->efx_MBDist->changepar(11,(int)o->value());
}
void RKRGUI::cb_mbdist_neg(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbdist_neg_i(o,v);
}

void RKRGUI::cb_arpie_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Arpie_Bypass);
 return;
}
rkr->Arpie_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Arpie->cleanup();
findpos(24,(int)o->value(),o);
}
void RKRGUI::cb_arpie_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_activar_i(o,v);
}

void RKRGUI::cb_arpie_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12024))rkr->efx_Arpie->setpreset((int) o->value());
arpie_WD->value(rkr->efx_Arpie->getpar(0)-64);
arpie_pan->value(rkr->efx_Arpie->getpar(1)-64);
arpie_delay->value(rkr->efx_Arpie->getpar(2));
arpie_LRdl->value(rkr->efx_Arpie->getpar(3));
arpie_LRc->value(rkr->efx_Arpie->getpar(4)-64);
arpie_fb->value(rkr->efx_Arpie->getpar(5));
arpie_damp->value(rkr->efx_Arpie->getpar(6));
arpie_arpe->value(rkr->efx_Arpie->getpar(7));
arpie_harm->value(rkr->efx_Arpie->getpar(8));
arpie_pattern->value(rkr->efx_Arpie->getpar(9));
arpie_subdiv->value(rkr->efx_Arpie->getpar(10));
}
void RKRGUI::cb_arpie_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_arpie_preset[] = {
 {"Arpie 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Arpie 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Arpie 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Simple Arpie", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Canyon", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Panning Arpie 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Panning Arpie 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Panning Arpie 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Feedback Arpie", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_arpie_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(212);
 return;
} 
rkr->efx_Arpie->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_arpie_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_WD_i(o,v);
}

void RKRGUI::cb_arpie_arpe_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(213);
 return;
} 
rkr->efx_Arpie->changepar(7,(int)o->value());
}
void RKRGUI::cb_arpie_arpe(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_arpe_i(o,v);
}

void RKRGUI::cb_arpie_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(214);
 return;
} 
rkr->efx_Arpie->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_arpie_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_pan_i(o,v);
}

void RKRGUI::cb_arpie_delay_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(215);
 return;
} 
rkr->efx_Arpie->changepar(2,(int)o->value());
}
void RKRGUI::cb_arpie_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_delay_i(o,v);
}

void RKRGUI::cb_arpie_subdiv_i(Fl_Choice* o, void*) {
  rkr->efx_Arpie->changepar(10,(int)o->value());
}
void RKRGUI::cb_arpie_subdiv(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_subdiv_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_arpie_subdiv[] = {
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1/6", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_arpie_LRdl_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(216);
 return;
} 
rkr->efx_Arpie->changepar(3,(int)o->value());
}
void RKRGUI::cb_arpie_LRdl(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_LRdl_i(o,v);
}

void RKRGUI::cb_arpie_LRc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(217);
 return;
} 
rkr->efx_Arpie->changepar(4,(int)(o->value()+64));
}
void RKRGUI::cb_arpie_LRc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_LRc_i(o,v);
}

void RKRGUI::cb_arpie_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(218);
 return;
} 
rkr->efx_Arpie->changepar(5,(int)o->value());
}
void RKRGUI::cb_arpie_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_fb_i(o,v);
}

void RKRGUI::cb_arpie_damp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(219);
 return;
} 
rkr->efx_Arpie->changepar(6,(int)o->value());
}
void RKRGUI::cb_arpie_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_damp_i(o,v);
}

void RKRGUI::cb_arpie_harm_i(Fl_Counter* o, void*) {
  rkr->efx_Arpie->changepar(8,(int)o->value());
}
void RKRGUI::cb_arpie_harm(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_harm_i(o,v);
}

void RKRGUI::cb_arpie_pattern_i(Fl_Choice* o, void*) {
  rkr->efx_Arpie->changepar(9,(int)o->value());
}
void RKRGUI::cb_arpie_pattern(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_arpie_pattern_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_arpie_pattern[] = {
 {"Ascending", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Descending", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"UpDown", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Stutter", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Interrupted Descent", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Double Descend ", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_expander_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Expander_Bypass);
 return;
}
rkr->Expander_Bypass=(int)o->value();
findpos(25,(int)o->value(),o);
}
void RKRGUI::cb_expander_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_activar_i(o,v);
}

void RKRGUI::cb_expander_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12025))rkr->efx_Expander->Expander_Change_Preset((int) o->value());
expander_ATime->value(rkr->efx_Expander->getpar(3));
expander_RTime->value(rkr->efx_Expander->getpar(4));
expander_shape->value(rkr->efx_Expander->getpar(2));
expander_threshold->value(rkr->efx_Expander->getpar(1));
expander_HPF->value(rkr->efx_Expander->getpar(6));
expander_LPF->value(rkr->efx_Expander->getpar(5));
expander_level->value(rkr->efx_Expander->getpar(7));
}
void RKRGUI::cb_expander_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_expander_preset[] = {
 {"Noise Gate", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Boost Gate", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Treble swell", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_expander_ATime_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(220);
 return;
} 
rkr->efx_Expander->Expander_Change(3,(int)o->value());
}
void RKRGUI::cb_expander_ATime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_ATime_i(o,v);
}

void RKRGUI::cb_expander_RTime_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(221);
 return;
} 
rkr->efx_Expander->Expander_Change(4,(int) o->value());
}
void RKRGUI::cb_expander_RTime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_RTime_i(o,v);
}

void RKRGUI::cb_expander_shape_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(222);
 return;
} 
rkr->efx_Expander->Expander_Change(2, (int) o->value());
}
void RKRGUI::cb_expander_shape(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_shape_i(o,v);
}

void RKRGUI::cb_expander_threshold_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(223);
 return;
} 
rkr->efx_Expander->Expander_Change(1, (int)o->value());
}
void RKRGUI::cb_expander_threshold(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_threshold_i(o,v);
}

void RKRGUI::cb_expander_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(224);
 return;
} 
rkr->efx_Expander->Expander_Change(7, (int) o->value());
}
void RKRGUI::cb_expander_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_level_i(o,v);
}

void RKRGUI::cb_expander_LPF_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(225);
 return;
} 
rkr->efx_Expander->Expander_Change(5, (int)o->value());
}
void RKRGUI::cb_expander_LPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_LPF_i(o,v);
}

void RKRGUI::cb_expander_HPF_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(226);
 return;
} 
rkr->efx_Expander->Expander_Change(6, (int)o->value());
}
void RKRGUI::cb_expander_HPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_expander_HPF_i(o,v);
}

void RKRGUI::cb_shuffle_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Shuffle_Bypass);
 return;
}
rkr->Shuffle_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Shuffle->cleanup();
findpos(26,(int)o->value(),o);
}
void RKRGUI::cb_shuffle_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_activar_i(o,v);
}

void RKRGUI::cb_shuffle_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12026))rkr->efx_Shuffle->setpreset((int)o->value());
shuffle_volL->value(rkr->efx_Shuffle->getpar(1));
shuffle_volML->value(rkr->efx_Shuffle->getpar(2));
shuffle_volMH->value(rkr->efx_Shuffle->getpar(2));
shuffle_volH->value(rkr->efx_Shuffle->getpar(4));
shuffle_cross1->value(rkr->efx_Shuffle->getpar(5));
shuffle_cross2->value(rkr->efx_Shuffle->getpar(6));
shuffle_cross3->value(rkr->efx_Shuffle->getpar(7));
shuffle_cross4->value(rkr->efx_Shuffle->getpar(8));
shuffle_Q->value(rkr->efx_Shuffle->getpar(9));
shuffle_WD->value(rkr->efx_Shuffle->getpar(0)-64);
shuffle_E->value(rkr->efx_Shuffle->getpar(10));
}
void RKRGUI::cb_shuffle_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_shuffle_preset[] = {
 {"Shuffle 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Shuffle 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Shuffle 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Remover", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_shuffle_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(227);
 return;
} 
rkr->efx_Shuffle->changepar(0,(int)o->value()+64);
}
void RKRGUI::cb_shuffle_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_WD_i(o,v);
}

void RKRGUI::cb_shuffle_cross1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(228);
 return;
} 
rkr->efx_Shuffle->changepar(5,(int)o->value());
}
void RKRGUI::cb_shuffle_cross1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_cross1_i(o,v);
}

void RKRGUI::cb_shuffle_volL_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(229);
 return;
} 
rkr->efx_Shuffle->changepar(1,(int)o->value());
}
void RKRGUI::cb_shuffle_volL(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_volL_i(o,v);
}

void RKRGUI::cb_shuffle_cross2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(230);
 return;
} 
rkr->efx_Shuffle->changepar(6,(int)o->value());
}
void RKRGUI::cb_shuffle_cross2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_cross2_i(o,v);
}

void RKRGUI::cb_shuffle_volML_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(231);
 return;
}
rkr->efx_Shuffle->changepar(2,(int)o->value());
}
void RKRGUI::cb_shuffle_volML(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_volML_i(o,v);
}

void RKRGUI::cb_shuffle_cross3_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(232);
 return;
}
rkr->efx_Shuffle->changepar(7,(int)o->value());
}
void RKRGUI::cb_shuffle_cross3(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_cross3_i(o,v);
}

void RKRGUI::cb_shuffle_volMH_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(233);
 return;
}
rkr->efx_Shuffle->changepar(3,(int)o->value());
}
void RKRGUI::cb_shuffle_volMH(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_volMH_i(o,v);
}

void RKRGUI::cb_shuffle_cross4_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(234);
 return;
}
rkr->efx_Shuffle->changepar(8,(int)o->value());
}
void RKRGUI::cb_shuffle_cross4(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_cross4_i(o,v);
}

void RKRGUI::cb_shuffle_volH_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(235);
 return;
}
rkr->efx_Shuffle->changepar(4,(int)o->value());
}
void RKRGUI::cb_shuffle_volH(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_volH_i(o,v);
}

void RKRGUI::cb_shuffle_Q_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(236);
 return;
}
rkr->efx_Shuffle->changepar(9,(int)o->value());
}
void RKRGUI::cb_shuffle_Q(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_Q_i(o,v);
}

void RKRGUI::cb_shuffle_E_i(Fl_Check_Button* o, void*) {
  rkr->efx_Shuffle->changepar(10,(int)o->value());
}
void RKRGUI::cb_shuffle_E(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shuffle_E_i(o,v);
}

void RKRGUI::cb_synthfilter_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Synthfilter_Bypass);
 return;
}
rkr->Synthfilter_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Synthfilter->cleanup();
findpos(27,(int)o->value(),o);
}
void RKRGUI::cb_synthfilter_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_activar_i(o,v);
}

void RKRGUI::cb_synthfilter_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12027))rkr->efx_Synthfilter->setpreset((int) o->value());
synthfilter_WD->value(rkr->efx_Synthfilter->getpar(0)-64);
synthfilter_Distort->value(rkr->efx_Synthfilter->getpar(1));
synthfilter_freq->value(rkr->efx_Synthfilter->getpar(2));
synthfilter_lfotype->value(rkr->efx_Synthfilter->getpar(4));
synthfilter_stdf->value(rkr->efx_Synthfilter->getpar(5));
synthfilter_width->value(rkr->efx_Synthfilter->getpar(6));
synthfilter_Lstages->value(rkr->efx_Synthfilter->getpar(8));
synthfilter_Hstages->value(rkr->efx_Synthfilter->getpar(9));
synthfilter_fb->value(rkr->efx_Synthfilter->getpar(7));
synthfilter_Offset->value(rkr->efx_Synthfilter->getpar(15));
synthfilter_subs->value(rkr->efx_Synthfilter->getpar(10));
synthfilter_dpth->value(rkr->efx_Synthfilter->getpar(11));
synthfilter_EnvSens->value(rkr->efx_Synthfilter->getpar(12));
synthfilter_ATime->value(rkr->efx_Synthfilter->getpar(13));
synthfilter_RTime->value(rkr->efx_Synthfilter->getpar(14));
}
void RKRGUI::cb_synthfilter_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_synthfilter_preset[] = {
 {"Low Pass", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"High Pass", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Band Pass", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Lead Synth", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Water", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Pan Filter", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Multi", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_synthfilter_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(237);
 return;
}
rkr->efx_Synthfilter->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_synthfilter_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_WD_i(o,v);
}

void RKRGUI::cb_synthfilter_Distort_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(238);
 return;
}
rkr->efx_Synthfilter->changepar(1,(int)o->value());
}
void RKRGUI::cb_synthfilter_Distort(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_Distort_i(o,v);
}

void RKRGUI::cb_synthfilter_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(239);
 return;
}
rkr->efx_Synthfilter->changepar(2,(int)o->value());
}
void RKRGUI::cb_synthfilter_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_freq_i(o,v);
}

void RKRGUI::cb_synthfilter_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Synthfilter->changepar(4,(int)o->value());
}
void RKRGUI::cb_synthfilter_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_lfotype_i(o,v);
}

void RKRGUI::cb_synthfilter_subs_i(Fl_Check_Button* o, void*) {
  rkr->efx_Synthfilter->changepar(10,(int)o->value());
}
void RKRGUI::cb_synthfilter_subs(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_subs_i(o,v);
}

void RKRGUI::cb_synthfilter_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(240);
 return;
}
rkr->efx_Synthfilter->changepar(5,(int)o->value());
}
void RKRGUI::cb_synthfilter_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_stdf_i(o,v);
}

void RKRGUI::cb_synthfilter_width_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(241);
 return;
}
rkr->efx_Synthfilter->changepar(6,(int)o->value());
}
void RKRGUI::cb_synthfilter_width(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_width_i(o,v);
}

void RKRGUI::cb_synthfilter_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(242);
 return;
}
rkr->efx_Synthfilter->changepar(7,(int)o->value());
}
void RKRGUI::cb_synthfilter_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_fb_i(o,v);
}

void RKRGUI::cb_synthfilter_Lstages_i(Fl_Counter* o, void*) {
  rkr->efx_Synthfilter->changepar(8,(int)o->value());
}
void RKRGUI::cb_synthfilter_Lstages(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_Lstages_i(o,v);
}

void RKRGUI::cb_synthfilter_Hstages_i(Fl_Counter* o, void*) {
  rkr->efx_Synthfilter->changepar(9,(int)o->value());
}
void RKRGUI::cb_synthfilter_Hstages(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_Hstages_i(o,v);
}

void RKRGUI::cb_synthfilter_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(243);
 return;
}
rkr->efx_Synthfilter->changepar(11,(int)o->value());
}
void RKRGUI::cb_synthfilter_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_dpth_i(o,v);
}

void RKRGUI::cb_synthfilter_EnvSens_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(244);
 return;
}
rkr->efx_Synthfilter->changepar(12,(int)(o->value()));
}
void RKRGUI::cb_synthfilter_EnvSens(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_EnvSens_i(o,v);
}

void RKRGUI::cb_synthfilter_ATime_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(245);
 return;
}
rkr->efx_Synthfilter->changepar(13,(int)o->value());
}
void RKRGUI::cb_synthfilter_ATime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_ATime_i(o,v);
}

void RKRGUI::cb_synthfilter_RTime_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(246);
 return;
}
rkr->efx_Synthfilter->changepar(14,(int)o->value());
}
void RKRGUI::cb_synthfilter_RTime(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_RTime_i(o,v);
}

void RKRGUI::cb_synthfilter_Offset_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(247);
 return;
}
rkr->efx_Synthfilter->changepar(15,(int)o->value());
}
void RKRGUI::cb_synthfilter_Offset(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_synthfilter_Offset_i(o,v);
}

void RKRGUI::cb_mbvvol_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->MBVvol_Bypass);
 return;
}
rkr->MBVvol_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_MBVvol->cleanup();
findpos(28,(int)o->value(),o);
}
void RKRGUI::cb_mbvvol_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_activar_i(o,v);
}

void RKRGUI::cb_mbvvol_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12028))rkr->efx_MBVvol->setpreset((int)o->value());
mbvvol_WD->value(rkr->efx_MBVvol->getpar(0)-64);
mbvvol_freq1->value(rkr->efx_MBVvol->getpar(1));
mbvvol_lfotype1->value(rkr->efx_MBVvol->getpar(2));
mbvvol_stdf1->value(rkr->efx_MBVvol->getpar(3));
mbvvol_freq2->value(rkr->efx_MBVvol->getpar(4));
mbvvol_lfotype2->value(rkr->efx_MBVvol->getpar(5));
mbvvol_stdf2->value(rkr->efx_MBVvol->getpar(6));
mbvvol_cross1->value(rkr->efx_MBVvol->getpar(7));
mbvvol_cross2->value(rkr->efx_MBVvol->getpar(8));
mbvvol_cross3->value(rkr->efx_MBVvol->getpar(9));
mbvvol_combi->value(rkr->efx_MBVvol->getpar(10));
}
void RKRGUI::cb_mbvvol_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_mbvvol_preset[] = {
 {"VaryVol 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"VaryVol 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"VaryVol 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_mbvvol_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(248);
 return;
}
rkr->efx_MBVvol->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_mbvvol_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_WD_i(o,v);
}

void RKRGUI::cb_mbvvol_freq1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(249);
 return;
}
rkr->efx_MBVvol->changepar(1,(int)o->value());
}
void RKRGUI::cb_mbvvol_freq1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_freq1_i(o,v);
}

void RKRGUI::cb_mbvvol_lfotype1_i(Fl_Choice* o, void*) {
  rkr->efx_MBVvol->changepar(2,(int)o->value());
}
void RKRGUI::cb_mbvvol_lfotype1(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_lfotype1_i(o,v);
}

void RKRGUI::cb_mbvvol_stdf1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(250);
 return;
}
rkr->efx_MBVvol->changepar(3,(int)o->value());
}
void RKRGUI::cb_mbvvol_stdf1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_stdf1_i(o,v);
}

void RKRGUI::cb_mbvvol_freq2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(251);
 return;
}
rkr->efx_MBVvol->changepar(4,(int)o->value());
}
void RKRGUI::cb_mbvvol_freq2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_freq2_i(o,v);
}

void RKRGUI::cb_mbvvol_lfotype2_i(Fl_Choice* o, void*) {
  rkr->efx_MBVvol->changepar(5,(int)o->value());
}
void RKRGUI::cb_mbvvol_lfotype2(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_lfotype2_i(o,v);
}

void RKRGUI::cb_mbvvol_stdf2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(252);
 return;
}
rkr->efx_MBVvol->changepar(6,(int)o->value());
}
void RKRGUI::cb_mbvvol_stdf2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_stdf2_i(o,v);
}

void RKRGUI::cb_mbvvol_cross1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(253);
 return;
}
rkr->efx_MBVvol->changepar(7,(int)o->value());
}
void RKRGUI::cb_mbvvol_cross1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_cross1_i(o,v);
}

void RKRGUI::cb_mbvvol_cross2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(254);
 return;
}
rkr->efx_MBVvol->changepar(8,(int)o->value());
}
void RKRGUI::cb_mbvvol_cross2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_cross2_i(o,v);
}

void RKRGUI::cb_mbvvol_cross3_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(255);
 return;
}
rkr->efx_MBVvol->changepar(9,(int)o->value());
}
void RKRGUI::cb_mbvvol_cross3(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_cross3_i(o,v);
}

void RKRGUI::cb_mbvvol_combi_i(Fl_Choice* o, void*) {
  rkr->efx_MBVvol->changepar(10,(int)o->value());
}
void RKRGUI::cb_mbvvol_combi(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_mbvvol_combi_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_mbvvol_combi[] = {
 {"1122", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1221", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1212", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"o11o", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"o12o", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x11x", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x12x", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1oo1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1oo2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1xx1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"1xx2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_convo_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Convol_Bypass);
 return;
}
rkr->Convol_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Convol->cleanup();
findpos(29,(int)o->value(),o);
}
void RKRGUI::cb_convo_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_activar_i(o,v);
}

void RKRGUI::cb_convo_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12029))rkr->efx_Convol->setpreset((int) o->value());
convo_pan->value(rkr->efx_Convol->getpar(1)-64);
convo_level->value(rkr->efx_Convol->getpar(7));
convo_WD->value(rkr->efx_Convol->getpar(0)-64);
convo_damp->value(rkr->efx_Convol->getpar(6));
convo_fnum->value(rkr->efx_Convol->getpar(8));
convo_length->value(rkr->efx_Convol->getpar(3));
convo_user->value(rkr->efx_Convol->getpar(4));
convo_user->do_callback();
convo_safe->value(rkr->efx_Convol->getpar(2));
convo_fb->value(rkr->efx_Convol->getpar(10));
}
void RKRGUI::cb_convo_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_convo_preset[] = {
 {"Marshall JCM200", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Fender Superchamp", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mesa Boogie", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mesa Boogie 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_convo_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(280);
 return;
}
rkr->efx_Convol->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_convo_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_WD_i(o,v);
}

void RKRGUI::cb_convo_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(281);
 return;
}
rkr->efx_Convol->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_convo_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_pan_i(o,v);
}

void RKRGUI::cb_convo_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(282);
 return;
}
rkr->efx_Convol->changepar(7,(int)o->value());
}
void RKRGUI::cb_convo_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_level_i(o,v);
}

void RKRGUI::cb_convo_damp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(283);
 return;
}
rkr->efx_Convol->changepar(6,(int)o->value());
}
void RKRGUI::cb_convo_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_damp_i(o,v);
}

void RKRGUI::cb_convo_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(284);
 return;
}
rkr->efx_Convol->changepar(10,(int)o->value());
}
void RKRGUI::cb_convo_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_fb_i(o,v);
}

void RKRGUI::cb_convo_length_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(285);
 return;
}
rkr->efx_Convol->changepar(3,(int)o->value());
}
void RKRGUI::cb_convo_length(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_length_i(o,v);
}

void RKRGUI::cb_convo_user_i(Fl_Check_Button* o, void*) {
  rkr->efx_Convol->changepar(4,(int)o->value());

if((int)o->value())B_wav->activate(); else B_wav->deactivate();
}
void RKRGUI::cb_convo_user(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_user_i(o,v);
}

void RKRGUI::cb_convo_safe_i(Fl_Check_Button* o, void*) {
  rkr->efx_Convol->changepar(2,(int)o->value());
}
void RKRGUI::cb_convo_safe(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_safe_i(o,v);
}

void RKRGUI::cb_B_wav_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Load Wav File:","(*.wav)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".wav");
strcpy(rkr->efx_Convol->Filename,filename);
rkr->efx_Convol->setfile(100);
}
void RKRGUI::cb_B_wav(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_B_wav_i(o,v);
}

void RKRGUI::cb_convo_fnum_i(Fl_Choice* o, void*) {
  rkr->efx_Convol->changepar(8,(int)o->value());
}
void RKRGUI::cb_convo_fnum(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_convo_fnum_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_convo_fnum[] = {
 {"Marshall JCM200", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Fender Superchamp", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mesa Boogie", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mesa Boogie 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Marshall Plexi", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Bassman", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"JCM2000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Ampeg", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Marshall2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_looper_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Looper_Bypass);
 return;
}
rkr->Looper_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Looper->cleanup();
findpos(30,(int)o->value(),o);
}
void RKRGUI::cb_looper_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_activar_i(o,v);
}

void RKRGUI::cb_looper_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12030))rkr->efx_Looper->setpreset((int) o->value());
looper_WD->value(rkr->efx_Looper->getpar(0)-64);
looper_play->value(rkr->efx_Looper->getpar(1));
looper_record->value(rkr->efx_Looper->getpar(3));
looper_rv->value(rkr->efx_Looper->getpar(5));
looper_ap->value(rkr->efx_Looper->getpar(9));
looper_level1->value(rkr->efx_Looper->getpar(6));
looper_level2->value(rkr->efx_Looper->getpar(10));

looper_t1->value(rkr->efx_Looper->getpar(7));
looper_t2->value(rkr->efx_Looper->getpar(8));
looper_r1->value(rkr->efx_Looper->getpar(11));
looper_r2->value(rkr->efx_Looper->getpar(12));
looper_lnk->value(rkr->efx_Looper->getpar(13));
looper_Tempo->value(rkr->efx_Looper->getpar(14));
looper_bar->value(rkr->efx_Looper->getpar(15));
looper_ms->value(rkr->efx_Looper->getpar(17));
}
void RKRGUI::cb_looper_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_looper_preset[] = {
 {"Looper", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Reverse", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_looper_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(267);
 return;
}
rkr->efx_Looper->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_looper_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_WD_i(o,v);
}

void RKRGUI::cb_looper_level1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(268);
 return;
}
rkr->efx_Looper->changepar(6,(int)o->value());
}
void RKRGUI::cb_looper_level1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_level1_i(o,v);
}

void RKRGUI::cb_looper_level2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(269);
 return;
}
rkr->efx_Looper->changepar(10,(int)o->value());
}
void RKRGUI::cb_looper_level2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_level2_i(o,v);
}

void RKRGUI::cb_looper_Tempo_i(SliderW* o, void*) {
  rkr->efx_Looper->changepar(14,(int)o->value());
}
void RKRGUI::cb_looper_Tempo(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_Tempo_i(o,v);
}

void RKRGUI::cb_looper_bar_i(Fl_Choice* o, void*) {
  rkr->efx_Looper->changepar(15,(int)o->value());
}
void RKRGUI::cb_looper_bar(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_bar_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_looper_bar[] = {
 {"2/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"3/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"4/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"5/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"6/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"7/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"9/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"11/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_looper_ms_i(Fl_Choice* o, void*) {
  rkr->efx_Looper->changepar(17,(int)o->value());
}
void RKRGUI::cb_looper_ms(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_ms_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_looper_ms[] = {
 {"N", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"H", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"L", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_looper_rv_i(Fl_Check_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(270);
 return;
}
rkr->efx_Looper->changepar(5,(int)o->value());
}
void RKRGUI::cb_looper_rv(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_rv_i(o,v);
}

void RKRGUI::cb_looper_ap_i(Fl_Check_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(271);
 return;
}
rkr->efx_Looper->changepar(9,(int)o->value());
}
void RKRGUI::cb_looper_ap(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_ap_i(o,v);
}

void RKRGUI::cb_looper_play_i(Fl_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(272);
 return;
}
rkr->efx_Looper->changepar(1,(int)o->value());
update_looper();
}
void RKRGUI::cb_looper_play(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_play_i(o,v);
}

void RKRGUI::cb_looper_stop_i(Fl_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(273);
 return;
}
rkr->efx_Looper->changepar(2,(int)o->value());
update_looper();
}
void RKRGUI::cb_looper_stop(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_stop_i(o,v);
}

void RKRGUI::cb_looper_record_i(Fl_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(274);
 return;
}
rkr->efx_Looper->changepar(3,(int)o->value());
update_looper();
}
void RKRGUI::cb_looper_record(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_record_i(o,v);
}

void RKRGUI::cb_looper_r1_i(Fl_Check_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(275);
 return;
}
rkr->efx_Looper->changepar(11,(int)o->value());
}
void RKRGUI::cb_looper_r1(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_r1_i(o,v);
}

void RKRGUI::cb_looper_r2_i(Fl_Check_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(276);
 return;
}
rkr->efx_Looper->changepar(12,(int)o->value());
}
void RKRGUI::cb_looper_r2(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_r2_i(o,v);
}

void RKRGUI::cb_looper_t1_i(Fl_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(277);
 return;
}
rkr->efx_Looper->changepar(7,(int)o->value());
update_looper();
}
void RKRGUI::cb_looper_t1(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_t1_i(o,v);
}

void RKRGUI::cb_looper_t2_i(Fl_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(278);
 return;
}
rkr->efx_Looper->changepar(8,(int)o->value());
update_looper();
}
void RKRGUI::cb_looper_t2(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_t2_i(o,v);
}

void RKRGUI::cb_looper_lnk_i(Fl_Check_Button* o, void*) {
  rkr->efx_Looper->changepar(13,(int)o->value());
}
void RKRGUI::cb_looper_lnk(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_lnk_i(o,v);
}

void RKRGUI::cb_looper_clear_i(Fl_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(279);
 return;
}
rkr->efx_Looper->changepar(4,(int)o->value());
update_looper();
}
void RKRGUI::cb_looper_clear(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_clear_i(o,v);
}

void RKRGUI::cb_looper_mt_i(Fl_Check_Button* o, void*) {
  rkr->efx_Looper->changepar(16,(int)o->value());
}
void RKRGUI::cb_looper_mt(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_looper_mt_i(o,v);
}

void RKRGUI::cb_ryanwah_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->RyanWah_Bypass);
 return;
}
rkr->RyanWah_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_RyanWah->cleanup();
findpos(31,(int)o->value(),o);
}
void RKRGUI::cb_ryanwah_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_activar_i(o,v);
}

void RKRGUI::cb_ryanwah_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12031))rkr->efx_RyanWah->setpreset((int) o->value());
ryanwah_WD->value(rkr->efx_RyanWah->getpar(0)-64);
ryanwah_qm->value(rkr->efx_RyanWah->getpar(17));
ryanwah_q->value(rkr->efx_RyanWah->getpar(1));
ryanwah_freq->value(rkr->efx_RyanWah->getpar(2));
ryanwah_lfotype->value(rkr->efx_RyanWah->getpar(4));
ryanwah_dpth->value(rkr->efx_RyanWah->getpar(6));
ryanwah_ampsns->value(rkr->efx_RyanWah->getpar(7));
ryanwah_ampsnsinv->value(rkr->efx_RyanWah->getpar(8));
ryanwah_smooth->value(rkr->efx_RyanWah->getpar(9));
ryanwah_lp->value(rkr->efx_RyanWah->getpar(10));
ryanwah_bp->value(rkr->efx_RyanWah->getpar(11));
ryanwah_hp->value(rkr->efx_RyanWah->getpar(12));
svfilter_stages->value(rkr->efx_RyanWah->getpar(13));
ryanwah_rng->value(rkr->efx_RyanWah->getpar(14));
o->value(rkr->efx_RyanWah->getpar(18));
o->redraw();
}
void RKRGUI::cb_ryanwah_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_ryanwah_preset[] = {
 {"WahWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mutron", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phase Wah", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Phaser", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Quack Quack", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_ryanwah_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(256);
 return;
}
rkr->efx_RyanWah->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_ryanwah_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_WD_i(o,v);
}

void RKRGUI::cb_ryanwah_lp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(257);
 return;
}
rkr->efx_RyanWah->changepar(10,(int)o->value());
}
void RKRGUI::cb_ryanwah_lp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_lp_i(o,v);
}

void RKRGUI::cb_ryanwah_qm_i(Fl_Check_Button* o, void*) {
  rkr->efx_RyanWah->changepar(17,(int)o->value());
}
void RKRGUI::cb_ryanwah_qm(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_qm_i(o,v);
}

void RKRGUI::cb_ryanwah_bp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(258);
 return;
}
rkr->efx_RyanWah->changepar(11,(int)o->value());
}
void RKRGUI::cb_ryanwah_bp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_bp_i(o,v);
}

void RKRGUI::cb_ryanwah_hp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(259);
 return;
}
rkr->efx_RyanWah->changepar(12,(int)o->value());
}
void RKRGUI::cb_ryanwah_hp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_hp_i(o,v);
}

void RKRGUI::cb_svfilter_stages_i(Fl_Counter* o, void*) {
  rkr->efx_RyanWah->changepar(13,(int)o->value());
}
void RKRGUI::cb_svfilter_stages(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_svfilter_stages_i(o,v);
}

void RKRGUI::cb_ryanwah_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_RyanWah->changepar(4,(int)o->value());
}
void RKRGUI::cb_ryanwah_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_lfotype_i(o,v);
}

void RKRGUI::cb_ryanwah_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(260);
 return;
}
rkr->efx_RyanWah->changepar(6,(int)o->value());
}
void RKRGUI::cb_ryanwah_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_dpth_i(o,v);
}

void RKRGUI::cb_ryanwah_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(261);
 return;
}
rkr->efx_RyanWah->changepar(2,(int)o->value());
}
void RKRGUI::cb_ryanwah_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_freq_i(o,v);
}

void RKRGUI::cb_ryanwah_q_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(262);
 return;
}
rkr->efx_RyanWah->changepar(1,(int)(o->value()));
}
void RKRGUI::cb_ryanwah_q(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_q_i(o,v);
}

void RKRGUI::cb_ryanwah_rng_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(263);
 return;
}
rkr->efx_RyanWah->changepar(14,(int)o->value());
}
void RKRGUI::cb_ryanwah_rng(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_rng_i(o,v);
}

void RKRGUI::cb_ryanwah_ampsnsinv_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(264);
 return;
}
rkr->efx_RyanWah->changepar(8,(int)o->value());
}
void RKRGUI::cb_ryanwah_ampsnsinv(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_ampsnsinv_i(o,v);
}

void RKRGUI::cb_ryanwah_ampsns_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(265);
 return;
}
rkr->efx_RyanWah->changepar(7,(int)o->value());
}
void RKRGUI::cb_ryanwah_ampsns(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_ampsns_i(o,v);
}

void RKRGUI::cb_ryanwah_smooth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(266);
 return;
}
rkr->efx_RyanWah->changepar(9,(int)o->value());
}
void RKRGUI::cb_ryanwah_smooth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ryanwah_smooth_i(o,v);
}

void RKRGUI::cb_rbecho_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->RBEcho_Bypass);
 return;
}
rkr->RBEcho_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_RBEcho->cleanup();
findpos(32,(int)o->value(),o);
}
void RKRGUI::cb_rbecho_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_activar_i(o,v);
}

void RKRGUI::cb_rbecho_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12032))rkr->efx_RBEcho->setpreset((int) o->value());
rbecho_WD->value(rkr->efx_RBEcho->getpar(0)-64);
rbecho_pan->value(rkr->efx_RBEcho->getpar(1)-64);
rbecho_delay->value(rkr->efx_RBEcho->getpar(2));
rbecho_LRdl->value(rkr->efx_RBEcho->getpar(3));
rbecho_angle->value(rkr->efx_RBEcho->getpar(4)-64);
rbecho_fb->value(rkr->efx_RBEcho->getpar(5));
rbecho_damp->value(rkr->efx_RBEcho->getpar(6));
rbecho_RV->value(rkr->efx_RBEcho->getpar(7));
rbecho_subdiv->value(rkr->efx_RBEcho->getpar(8));
rbecho_es->value(rkr->efx_RBEcho->getpar(9));
}
void RKRGUI::cb_rbecho_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_rbecho_preset[] = {
 {"Echo 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Echo 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Echo 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_rbecho_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(303);
 return;
}
rkr->efx_RBEcho->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_rbecho_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_WD_i(o,v);
}

void RKRGUI::cb_rbecho_RV_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(304);
 return;
}
rkr->efx_RBEcho->changepar(7,(int)o->value());
}
void RKRGUI::cb_rbecho_RV(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_RV_i(o,v);
}

void RKRGUI::cb_rbecho_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(305);
 return;
}
rkr->efx_RBEcho->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_rbecho_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_pan_i(o,v);
}

void RKRGUI::cb_rbecho_delay_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(306);
 return;
}
rkr->efx_RBEcho->changepar(2,(int)o->value());
}
void RKRGUI::cb_rbecho_delay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_delay_i(o,v);
}

void RKRGUI::cb_rbecho_LRdl_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(307);
 return;
}
rkr->efx_RBEcho->changepar(3,(int)o->value());
}
void RKRGUI::cb_rbecho_LRdl(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_LRdl_i(o,v);
}

void RKRGUI::cb_rbecho_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(308);
 return;
}
rkr->efx_RBEcho->changepar(5,(int)o->value());
}
void RKRGUI::cb_rbecho_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_fb_i(o,v);
}

void RKRGUI::cb_rbecho_subdiv_i(Fl_Choice* o, void*) {
  rkr->efx_RBEcho->changepar(8,(int)o->value());
}
void RKRGUI::cb_rbecho_subdiv(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_subdiv_i(o,v);
}

void RKRGUI::cb_rbecho_damp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(309);
 return;
}
rkr->efx_RBEcho->changepar(6,(int)o->value());
}
void RKRGUI::cb_rbecho_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_damp_i(o,v);
}

void RKRGUI::cb_rbecho_es_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(310);
 return;
}
rkr->efx_RBEcho->changepar(9,(int)o->value());
}
void RKRGUI::cb_rbecho_es(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_es_i(o,v);
}

void RKRGUI::cb_rbecho_angle_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(311);
 return;
}
rkr->efx_RBEcho->changepar(4,(int)(o->value()+64));
}
void RKRGUI::cb_rbecho_angle(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_rbecho_angle_i(o,v);
}

void RKRGUI::cb_coil_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->CoilCrafter_Bypass);
 return;
}
rkr->CoilCrafter_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_CoilCrafter->cleanup();
findpos(33,(int)o->value(),o);
}
void RKRGUI::cb_coil_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_activar_i(o,v);
}

void RKRGUI::cb_coil_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12033))rkr->efx_CoilCrafter->setpreset((int) o->value());
coil_WD->value(rkr->efx_CoilCrafter->getpar(0));
coil_tone->value(rkr->efx_CoilCrafter->getpar(7));
coil_origin->value(rkr->efx_CoilCrafter->getpar(1));
coil_destiny->value(rkr->efx_CoilCrafter->getpar(2));
coil_freq1->value(rkr->efx_CoilCrafter->getpar(3));
coil_q1->value(rkr->efx_CoilCrafter->getpar(4));
coil_freq2->value(rkr->efx_CoilCrafter->getpar(5));
coil_q2->value(rkr->efx_CoilCrafter->getpar(6));
coil_mode->value(rkr->efx_CoilCrafter->getpar(8));
}
void RKRGUI::cb_coil_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_coil_preset[] = {
 {"H to S", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"S to H", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_coil_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(286);
 return;
}
rkr->efx_CoilCrafter->changepar(0,(int)o->value());
}
void RKRGUI::cb_coil_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_WD_i(o,v);
}

void RKRGUI::cb_coil_tone_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(287);
 return;
}
rkr->efx_CoilCrafter->changepar(7,(int)o->value());
}
void RKRGUI::cb_coil_tone(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_tone_i(o,v);
}

void RKRGUI::cb_coil_origin_i(Fl_Choice* o, void*) {
  rkr->efx_CoilCrafter->changepar(1,(int)o->value());
coil_freq1->value(rkr->efx_CoilCrafter->getpar(3));
coil_q1->value(rkr->efx_CoilCrafter->getpar(4));
}
void RKRGUI::cb_coil_origin(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_origin_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_coil_origin[] = {
 {"Off", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Fender Strat (old)", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Fender Strat (new)", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Squire Strat", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Fender Hambucker", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Gibson P90", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Gibson Standard", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Gibson Mini", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Gibson Super L6S", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_coil_freq1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(288);
 return;
}
rkr->efx_CoilCrafter->changepar(3,(int)o->value());
}
void RKRGUI::cb_coil_freq1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_freq1_i(o,v);
}

void RKRGUI::cb_coil_q1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(289);
 return;
}
rkr->efx_CoilCrafter->changepar(4,(int)o->value());
}
void RKRGUI::cb_coil_q1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_q1_i(o,v);
}

void RKRGUI::cb_coil_destiny_i(Fl_Choice* o, void*) {
  rkr->efx_CoilCrafter->changepar(2,(int)o->value());
coil_freq2->value(rkr->efx_CoilCrafter->getpar(5));
coil_q2->value(rkr->efx_CoilCrafter->getpar(6));
}
void RKRGUI::cb_coil_destiny(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_destiny_i(o,v);
}

void RKRGUI::cb_coil_freq2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(290);
 return;
}
rkr->efx_CoilCrafter->changepar(5,(int)o->value());
}
void RKRGUI::cb_coil_freq2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_freq2_i(o,v);
}

void RKRGUI::cb_coil_q2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(291);
 return;
}
rkr->efx_CoilCrafter->changepar(6,(int)o->value());
}
void RKRGUI::cb_coil_q2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_q2_i(o,v);
}

void RKRGUI::cb_coil_mode_i(Fl_Check_Button* o, void*) {
  rkr->efx_CoilCrafter->changepar(8,(int)o->value());
}
void RKRGUI::cb_coil_mode(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_coil_mode_i(o,v);
}

void RKRGUI::cb_shelf_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->ShelfBoost_Bypass);
 return;
}
rkr->ShelfBoost_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_ShelfBoost->cleanup();
findpos(34,(int)o->value(),o);
}
void RKRGUI::cb_shelf_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shelf_activar_i(o,v);
}

void RKRGUI::cb_shelf_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12034))rkr->efx_ShelfBoost->setpreset((int) o->value());
shelf_gain->value(rkr->efx_ShelfBoost->getpar(0));
shelf_q1->value(rkr->efx_ShelfBoost->getpar(1));
shelf_freq1->value(rkr->efx_ShelfBoost->getpar(2));
shelf_mode->value(rkr->efx_ShelfBoost->getpar(3));
shelf_level->value(rkr->efx_ShelfBoost->getpar(4));
}
void RKRGUI::cb_shelf_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shelf_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_shelf_preset[] = {
 {"Trebble", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mid", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Distortion 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_shelf_gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(292);
 return;
}
rkr->efx_ShelfBoost->changepar(0,(int)o->value());
}
void RKRGUI::cb_shelf_gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shelf_gain_i(o,v);
}

void RKRGUI::cb_shelf_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(293);
 return;
}
rkr->efx_ShelfBoost->changepar(4,(int)o->value());
}
void RKRGUI::cb_shelf_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shelf_level_i(o,v);
}

void RKRGUI::cb_shelf_freq1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(294);
 return;
}
rkr->efx_ShelfBoost->changepar(2,(int)o->value());
}
void RKRGUI::cb_shelf_freq1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shelf_freq1_i(o,v);
}

void RKRGUI::cb_shelf_q1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(295);
 return;
}
rkr->efx_ShelfBoost->changepar(1,(int)o->value());
}
void RKRGUI::cb_shelf_q1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shelf_q1_i(o,v);
}

void RKRGUI::cb_shelf_mode_i(Fl_Check_Button* o, void*) {
  rkr->efx_ShelfBoost->changepar(3,(int)o->value());
}
void RKRGUI::cb_shelf_mode(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shelf_mode_i(o,v);
}

void RKRGUI::cb_vo_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Vocoder_Bypass);
 return;
}
rkr->Vocoder_Bypass=(int)o->value();
if((int) o->value()==0)
vu_vu->value(-48);
findpos(35,(int)o->value(),o);
}
void RKRGUI::cb_vo_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_activar_i(o,v);
}

void RKRGUI::cb_vo_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12035))rkr->efx_Vocoder->setpreset((int) o->value());
vo_WD->value(rkr->efx_Vocoder->getpar(0)-64);
vo_pan->value(rkr->efx_Vocoder->getpar(1)-64);
vo_mu->value(rkr->efx_Vocoder->getpar(2));
vo_q->value(rkr->efx_Vocoder->getpar(3));
vo_input->value(rkr->efx_Vocoder->getpar(4));
vo_ring->value(rkr->efx_Vocoder->getpar(6));
vo_level->value(rkr->efx_Vocoder->getpar(5));
}
void RKRGUI::cb_vo_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_vo_preset[] = {
 {"Vocoder 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Vocoder 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Vocoder 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Vocoder 4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_vo_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(296);
 return;
}
rkr->efx_Vocoder->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_vo_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_WD_i(o,v);
}

void RKRGUI::cb_vo_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(297);
 return;
}
rkr->efx_Vocoder->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_vo_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_pan_i(o,v);
}

void RKRGUI::cb_vo_input_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(298);
 return;
}
rkr->efx_Vocoder->changepar(4,(int)o->value());
}
void RKRGUI::cb_vo_input(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_input_i(o,v);
}

void RKRGUI::cb_vo_mu_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(299);
 return;
}
rkr->efx_Vocoder->changepar(2,(int)o->value());
}
void RKRGUI::cb_vo_mu(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_mu_i(o,v);
}

void RKRGUI::cb_vo_q_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(300);
 return;
}
rkr->efx_Vocoder->changepar(3,(int)o->value());
}
void RKRGUI::cb_vo_q(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_q_i(o,v);
}

void RKRGUI::cb_vo_ring_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(301);
 return;
}
rkr->efx_Vocoder->changepar(6,(int)o->value());
}
void RKRGUI::cb_vo_ring(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_ring_i(o,v);
}

void RKRGUI::cb_vo_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(302);
 return;
}
rkr->efx_Vocoder->changepar(5,(int)o->value());
}
void RKRGUI::cb_vo_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vo_level_i(o,v);
}

void RKRGUI::cb_sus_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Sustainer_Bypass);
 return;
}
rkr->Sustainer_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Sustainer->cleanup();
findpos(36,(int)o->value(),o);
}
void RKRGUI::cb_sus_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_sus_activar_i(o,v);
}

void RKRGUI::cb_sus_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12036))rkr->efx_Sustainer->setpreset((int) o->value());
sus_gain->value(rkr->efx_Sustainer->getpar(0));
sus_sus->value(rkr->efx_Sustainer->getpar(1));
}
void RKRGUI::cb_sus_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_sus_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_sus_preset[] = {
 {"Sustain 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Sustain 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Sustain 3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_sus_gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(312);
 return;
}
rkr->efx_Sustainer->changepar(0,(int)o->value());
}
void RKRGUI::cb_sus_gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_sus_gain_i(o,v);
}

void RKRGUI::cb_sus_sus_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(313);
 return;
}
rkr->efx_Sustainer->changepar(1,(int)o->value());
}
void RKRGUI::cb_sus_sus(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_sus_sus_i(o,v);
}

void RKRGUI::cb_seq_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Sequence_Bypass);
 return;
}
rkr->Sequence_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Sequence->cleanup();
findpos(37,(int)o->value(),o);
}
void RKRGUI::cb_seq_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_activar_i(o,v);
}

void RKRGUI::cb_seq_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12037))rkr->efx_Sequence->setpreset((int) o->value());
seq_WD->value(rkr->efx_Sequence->getpar(8)-64);
seq_q->value(rkr->efx_Sequence->getpar(10)-64);
seq_amp->value(rkr->efx_Sequence->getpar(11));
seq_tempo->value(rkr->efx_Sequence->getpar(9));
seq_stdf->value(rkr->efx_Sequence->getpar(12));
seq_1->value(rkr->efx_Sequence->getpar(0));
seq_2->value(rkr->efx_Sequence->getpar(1));
seq_3->value(rkr->efx_Sequence->getpar(2));
seq_4->value(rkr->efx_Sequence->getpar(3));
seq_5->value(rkr->efx_Sequence->getpar(4));
seq_6->value(rkr->efx_Sequence->getpar(5));
seq_7->value(rkr->efx_Sequence->getpar(6));
seq_8->value(rkr->efx_Sequence->getpar(7));
seq_mode->value(rkr->efx_Sequence->getpar(13));
seq_range->value(rkr->efx_Sequence->getpar(14));
}
void RKRGUI::cb_seq_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_seq_preset[] = {
 {"Jumpy", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Stair Step", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Mild", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Wah Wah", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Filter Pan", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Stepper", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Shifter", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Zeke Trem", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Boogie", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_seq_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(314);
 return;
}
rkr->efx_Sequence->changepar(8,(int)(o->value()+64));
}
void RKRGUI::cb_seq_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_WD_i(o,v);
}

void RKRGUI::cb_seq_1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(315);
 return;
}
rkr->efx_Sequence->changepar(0,(int)o->value());
}
void RKRGUI::cb_seq_1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_1_i(o,v);
}

void RKRGUI::cb_seq_2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(316);
 return;
}
rkr->efx_Sequence->changepar(1,(int)o->value());
}
void RKRGUI::cb_seq_2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_2_i(o,v);
}

void RKRGUI::cb_seq_3_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(317);
 return;
}
rkr->efx_Sequence->changepar(2,(int)o->value());
}
void RKRGUI::cb_seq_3(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_3_i(o,v);
}

void RKRGUI::cb_seq_4_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(318);
 return;
}
rkr->efx_Sequence->changepar(3,(int)o->value());
}
void RKRGUI::cb_seq_4(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_4_i(o,v);
}

void RKRGUI::cb_seq_5_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(319);
 return;
}
rkr->efx_Sequence->changepar(4,(int)o->value());
}
void RKRGUI::cb_seq_5(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_5_i(o,v);
}

void RKRGUI::cb_seq_6_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(320);
 return;
}
rkr->efx_Sequence->changepar(5,(int)o->value());
}
void RKRGUI::cb_seq_6(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_6_i(o,v);
}

void RKRGUI::cb_seq_7_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(321);
 return;
}
rkr->efx_Sequence->changepar(6,(int)o->value());
}
void RKRGUI::cb_seq_7(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_7_i(o,v);
}

void RKRGUI::cb_seq_8_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(322);
 return;
}
rkr->efx_Sequence->changepar(7,(int)o->value());
}
void RKRGUI::cb_seq_8(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_8_i(o,v);
}

void RKRGUI::cb_seq_tempo_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(323);
 return;
}
rkr->efx_Sequence->changepar(9,(int)o->value());
}
void RKRGUI::cb_seq_tempo(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_tempo_i(o,v);
}

void RKRGUI::cb_seq_q_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(324);
 return;
}
rkr->efx_Sequence->changepar(10,(int)o->value()+64);
}
void RKRGUI::cb_seq_q(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_q_i(o,v);
}

void RKRGUI::cb_seq_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(325);
 return;
}
rkr->efx_Sequence->changepar(12,(int)o->value());
}
void RKRGUI::cb_seq_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_stdf_i(o,v);
}

void RKRGUI::cb_seq_amp_i(Fl_Check_Button* o, void*) {
  rkr->efx_Sequence->changepar(11,(int)o->value());
}
void RKRGUI::cb_seq_amp(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_amp_i(o,v);
}

void RKRGUI::cb_seq_mode_i(Fl_Choice* o, void*) {
  rkr->efx_Sequence->changepar(13,(int)o->value());
}
void RKRGUI::cb_seq_mode(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_mode_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_seq_mode[] = {
 {"Lineal", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"UpDown", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Stepper", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Shifter", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Tremor", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Arpegiator", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_seq_range_i(Fl_Counter* o, void*) {
  rkr->efx_Sequence->changepar(14,(int)o->value());
}
void RKRGUI::cb_seq_range(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_seq_range_i(o,v);
}

void RKRGUI::cb_shifter_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Shifter_Bypass);
 return;
}
rkr->Shifter_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Shifter->cleanup();
findpos(38,(int)o->value(),o);
}
void RKRGUI::cb_shifter_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_activar_i(o,v);
}

void RKRGUI::cb_shifter_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12038))rkr->efx_Shifter->setpreset((int)o->value());
shifter_WD->value(rkr->efx_Shifter->getpar(0)-64);
shifter_pan->value(rkr->efx_Shifter->getpar(1)-64);
shifter_gain->value(rkr->efx_Shifter->getpar(2)-64);
shifter_int->value(rkr->efx_Shifter->getpar(6));
shifter_attack->value(rkr->efx_Shifter->getpar(3));
shifter_decay->value(rkr->efx_Shifter->getpar(4));
shifter_thre->value(rkr->efx_Shifter->getpar(5));
shifter_ud->value(rkr->efx_Shifter->getpar(7));
shifter_whammy->value(rkr->efx_Shifter->getpar(9));

shifter_mode->value(rkr->efx_Shifter->getpar(8));
}
void RKRGUI::cb_shifter_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_shifter_preset[] = {
 {"Fast", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Slow Up", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Slow Down", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Trig. Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_shifter_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(326);
 return;
}
rkr->efx_Shifter->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_shifter_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_WD_i(o,v);
}

void RKRGUI::cb_shifter_int_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(327);
 return;
}
rkr->Shifter_Bypass=0;
rkr->efx_Shifter->changepar(6,(int)o->value());
if((int)shifter_activar->value())rkr->Shifter_Bypass=1;
}
void RKRGUI::cb_shifter_int(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_int_i(o,v);
}

void RKRGUI::cb_shifter_gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(328);
 return;
}
rkr->efx_Shifter->changepar(2,(int)(o->value()+64));
}
void RKRGUI::cb_shifter_gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_gain_i(o,v);
}

void RKRGUI::cb_shifter_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(329);
 return;
}
rkr->efx_Shifter->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_shifter_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_pan_i(o,v);
}

void RKRGUI::cb_shifter_attack_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(330);
 return;
}
rkr->efx_Shifter->changepar(3,(int)o->value());
}
void RKRGUI::cb_shifter_attack(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_attack_i(o,v);
}

void RKRGUI::cb_shifter_decay_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(331);
 return;
}
rkr->efx_Shifter->changepar(4,(int)o->value());
}
void RKRGUI::cb_shifter_decay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_decay_i(o,v);
}

void RKRGUI::cb_shifter_thre_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(332);
 return;
}
rkr->efx_Shifter->changepar(5,(int)o->value());
}
void RKRGUI::cb_shifter_thre(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_thre_i(o,v);
}

void RKRGUI::cb_shifter_ud_i(Fl_Check_Button* o, void*) {
  rkr->efx_Shifter->changepar(7,(int)o->value());
}
void RKRGUI::cb_shifter_ud(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_ud_i(o,v);
}

void RKRGUI::cb_shifter_whammy_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(333);
 return;
}
rkr->efx_Shifter->changepar(9,(int)o->value());
}
void RKRGUI::cb_shifter_whammy(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_whammy_i(o,v);
}

void RKRGUI::cb_shifter_mode_i(Fl_Choice* o, void*) {
  rkr->efx_Shifter->changepar(8,(int)o->value());
}
void RKRGUI::cb_shifter_mode(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shifter_mode_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_shifter_mode[] = {
 {"Trigger", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Whammy", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_stomp_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->StompBox_Bypass);
 return;
}
rkr->StompBox_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_StompBox->cleanup();
findpos(39,(int)o->value(),o);
}
void RKRGUI::cb_stomp_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_activar_i(o,v);
}

void RKRGUI::cb_stomp_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12039))rkr->efx_StompBox->setpreset((int)o->value());
stomp_WD->value(rkr->efx_StompBox->getpar(0));
stomp_gain->value(rkr->efx_StompBox->getpar(4));
stomp_low->value(rkr->efx_StompBox->getpar(3));
stomp_mid->value(rkr->efx_StompBox->getpar(2));
stomp_high->value(rkr->efx_StompBox->getpar(1));

stomp_mode->value(rkr->efx_StompBox->getpar(5));
}
void RKRGUI::cb_stomp_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_stomp_preset[] = {
 {"Odie", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Grunger", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hard Dist.", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Ratula", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Classic Dist", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Morbid Impalement", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Sharp Metal", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Classic Fuzz", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_stomp_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(334);
 return;
}
rkr->efx_StompBox->changepar(0,(int)o->value());
}
void RKRGUI::cb_stomp_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_WD_i(o,v);
}

void RKRGUI::cb_stomp_gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(335);
 return;
}
rkr->efx_StompBox->changepar(4,(int)o->value());
}
void RKRGUI::cb_stomp_gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_gain_i(o,v);
}

void RKRGUI::cb_stomp_low_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(336);
 return;
}
rkr->efx_StompBox->changepar(3,(int)o->value());
}
void RKRGUI::cb_stomp_low(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_low_i(o,v);
}

void RKRGUI::cb_stomp_mid_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(337);
 return;
}
rkr->efx_StompBox->changepar(2,(int)o->value());
}
void RKRGUI::cb_stomp_mid(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_mid_i(o,v);
}

void RKRGUI::cb_stomp_high_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(338);
 return;
}
rkr->efx_StompBox->changepar(1,(int)o->value());
}
void RKRGUI::cb_stomp_high(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_high_i(o,v);
}

void RKRGUI::cb_stomp_mode_i(Fl_Choice* o, void*) {
  rkr->efx_StompBox->changepar(5,(int)o->value());
}
void RKRGUI::cb_stomp_mode(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_stomp_mode_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_stomp_mode[] = {
 {"Amp", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Grunge", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Rat", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Fat Cat", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dist+", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Death", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Mid Elves Own", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Fuzz", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_revtron_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Reverbtron_Bypass);
 return;
}
rkr->Reverbtron_Bypass=(int)o->value();
if((int) o->value()==0) rkr->efx_Reverbtron->cleanup();
findpos(40,(int)o->value(),o);
}
void RKRGUI::cb_revtron_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_activar_i(o,v);
}

void RKRGUI::cb_revtron_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12040))rkr->efx_Reverbtron->setpreset((int) o->value());
revtron_pan->value(rkr->efx_Reverbtron->getpar(11)-64);
revtron_level->value(rkr->efx_Reverbtron->getpar(7));
revtron_WD->value(rkr->efx_Reverbtron->getpar(0)-64);
revtron_damp->value(rkr->efx_Reverbtron->getpar(6));
revtron_fnum->value(rkr->efx_Reverbtron->getpar(8));
revtron_length->value(rkr->efx_Reverbtron->getpar(3));
revtron_strech->value(rkr->efx_Reverbtron->getpar(9));
revtron_safe->value(rkr->efx_Reverbtron->getpar(2));
revtron_user->value(rkr->efx_Reverbtron->getpar(4));
revtron_user->do_callback();
revtron_fb->value(rkr->efx_Reverbtron->getpar(10));
revtron_fade->value(rkr->efx_Reverbtron->getpar(1));
revtron_idelay->value(rkr->efx_Reverbtron->getpar(5));
revtron_LPF->value(rkr->efx_Reverbtron->getpar(14));
revtron_HPF->value(rkr->efx_Reverbtron->getpar(15));

revtron_es->value(rkr->efx_Reverbtron->getpar(12));
revtron_rv->value(rkr->efx_Reverbtron->getpar(13));
}
void RKRGUI::cb_revtron_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_revtron_preset[] = {
 {"Chamber", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Concrete Stairwell", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hall", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Med Hall", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Room", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hall", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Guitar", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Studio", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Cathedral", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_revtron_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(339);
 return;
}
rkr->efx_Reverbtron->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_revtron_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_WD_i(o,v);
}

void RKRGUI::cb_revtron_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(340);
 return;
}
rkr->efx_Reverbtron->changepar(11,(int)(o->value()+64));
}
void RKRGUI::cb_revtron_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_pan_i(o,v);
}

void RKRGUI::cb_revtron_level_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(341);
 return;
}
rkr->efx_Reverbtron->changepar(7,(int)o->value());
}
void RKRGUI::cb_revtron_level(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_level_i(o,v);
}

void RKRGUI::cb_revtron_damp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(342);
 return;
}
rkr->efx_Reverbtron->changepar(6,(int)o->value());
}
void RKRGUI::cb_revtron_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_damp_i(o,v);
}

void RKRGUI::cb_revtron_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(343);
 return;
}
rkr->efx_Reverbtron->changepar(10,(int)o->value());
}
void RKRGUI::cb_revtron_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_fb_i(o,v);
}

void RKRGUI::cb_revtron_length_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(344);
 return;
}
rkr->efx_Reverbtron->changepar(3,(int)o->value());
}
void RKRGUI::cb_revtron_length(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_length_i(o,v);
}

void RKRGUI::cb_revtron_strech_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(345);
 return;
}
rkr->efx_Reverbtron->changepar(9,(int)o->value());
}
void RKRGUI::cb_revtron_strech(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_strech_i(o,v);
}

void RKRGUI::cb_revtron_idelay_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(346);
 return;
}
rkr->efx_Reverbtron->changepar(5,(int)o->value());
}
void RKRGUI::cb_revtron_idelay(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_idelay_i(o,v);
}

void RKRGUI::cb_revtron_fade_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(347);
 return;
}
rkr->efx_Reverbtron->changepar(1,(int)o->value());
}
void RKRGUI::cb_revtron_fade(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_fade_i(o,v);
}

void RKRGUI::cb_revtron_HPF_i(SliderW* o, void*) {
  rkr->efx_Reverbtron->changepar(15,(int)o->value());
}
void RKRGUI::cb_revtron_HPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_HPF_i(o,v);
}

void RKRGUI::cb_revtron_LPF_i(SliderW* o, void*) {
  rkr->efx_Reverbtron->changepar(14,(int)o->value());
}
void RKRGUI::cb_revtron_LPF(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_LPF_i(o,v);
}

void RKRGUI::cb_revtron_rv_i(Fl_Check_Button* o, void*) {
  rkr->efx_Reverbtron->changepar(13,(int)o->value());
}
void RKRGUI::cb_revtron_rv(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_rv_i(o,v);
}

void RKRGUI::cb_revtron_es_i(Fl_Check_Button* o, void*) {
  rkr->efx_Reverbtron->changepar(12,(int)o->value());
}
void RKRGUI::cb_revtron_es(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_es_i(o,v);
}

void RKRGUI::cb_revtron_safe_i(Fl_Check_Button* o, void*) {
  rkr->efx_Reverbtron->changepar(2,(int)o->value());
}
void RKRGUI::cb_revtron_safe(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_safe_i(o,v);
}

void RKRGUI::cb_revtron_user_i(Fl_Check_Button* o, void*) {
  rkr->efx_Reverbtron->changepar(4,(int)o->value());

if((int)o->value())B_rvb->activate(); else B_rvb->deactivate();
}
void RKRGUI::cb_revtron_user(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_user_i(o,v);
}

void RKRGUI::cb_B_rvb_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Load rvb File:","(*.rvb)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rvb");
strcpy(rkr->efx_Reverbtron->Filename,filename);
rkr->efx_Reverbtron->setfile(100);
}
void RKRGUI::cb_B_rvb(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_B_rvb_i(o,v);
}

void RKRGUI::cb_revtron_fnum_i(Fl_Choice* o, void*) {
  rkr->efx_Reverbtron->changepar(8,(int)o->value());
}
void RKRGUI::cb_revtron_fnum(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_revtron_fnum_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_revtron_fnum[] = {
 {"Chamber", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Conc. Stair", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hall", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Med Hall", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Large Room", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Large Hall", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Guitar Ambience", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Studio", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Twilight", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Santa Lucia", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_echotron_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Echotron_Bypass);
 return;
}
rkr->Echotron_Bypass=(int)o->value();
if((int) o->value()==0) rkr->efx_Echotron->cleanup();
findpos(41,(int)o->value(),o);
}
void RKRGUI::cb_echotron_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_activar_i(o,v);
}

void RKRGUI::cb_echotron_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12041))rkr->efx_Echotron->setpreset((int) o->value());
echotron_pan->value(rkr->efx_Echotron->getpar(11)-64);
echotron_WD->value(rkr->efx_Echotron->getpar(0)-64);
echotron_damp->value(rkr->efx_Echotron->getpar(6));
echotron_fnum->value(rkr->efx_Echotron->getpar(8));
echotron_user->value(rkr->efx_Echotron->getpar(4));
echotron_user->do_callback();
echotron_fb->value(rkr->efx_Echotron->getpar(10));
echotron_tempo->value(rkr->efx_Echotron->getpar(5));
echotron_lfotype->value(rkr->efx_Echotron->getpar(14));
echotron_width->value(rkr->efx_Echotron->getpar(2));
echotron_deep->value(rkr->efx_Echotron->getpar(1)-64);
echotron_lrcross->value(rkr->efx_Echotron->getpar(7)-64);
echotron_stdf->value(rkr->efx_Echotron->getpar(9));
echotron_af->value(rkr->efx_Echotron->getpar(15));
echotron_mf->value(rkr->efx_Echotron->getpar(13));
echotron_md->value(rkr->efx_Echotron->getpar(12));
echotron_length->value(rkr->efx_Echotron->getpar(3));
echotron_length->maximum(rkr->efx_Echotron->getpar(3));
}
void RKRGUI::cb_echotron_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_echotron_preset[] = {
 {"Summer", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Ambience", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Arranjer", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Suction", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"SuctionFlange", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_echotron_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(348);
 return;
}
rkr->efx_Echotron->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_echotron_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_WD_i(o,v);
}

void RKRGUI::cb_echotron_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(349);
 return;
}
rkr->efx_Echotron->changepar(11,(int)(o->value()+64));
}
void RKRGUI::cb_echotron_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_pan_i(o,v);
}

void RKRGUI::cb_echotron_tempo_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(350);
 return;
}
rkr->efx_Echotron->changepar(5,(int)o->value());
}
void RKRGUI::cb_echotron_tempo(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_tempo_i(o,v);
}

void RKRGUI::cb_echotron_damp_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(351);
 return;
}
rkr->efx_Echotron->changepar(6,(int)o->value());
}
void RKRGUI::cb_echotron_damp(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_damp_i(o,v);
}

void RKRGUI::cb_echotron_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(352);
 return;
}
rkr->efx_Echotron->changepar(10,(int)o->value());
}
void RKRGUI::cb_echotron_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_fb_i(o,v);
}

void RKRGUI::cb_echotron_lrcross_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(353);
 return;
}
rkr->efx_Echotron->changepar(7,(int)(o->value()+64));
}
void RKRGUI::cb_echotron_lrcross(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_lrcross_i(o,v);
}

void RKRGUI::cb_echotron_width_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(354);
 return;
}
rkr->efx_Echotron->changepar(2,(int)o->value());
}
void RKRGUI::cb_echotron_width(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_width_i(o,v);
}

void RKRGUI::cb_echotron_deep_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(355);
 return;
}
rkr->efx_Echotron->changepar(1,((int)o->value()+64));
}
void RKRGUI::cb_echotron_deep(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_deep_i(o,v);
}

void RKRGUI::cb_echotron_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(356);
 return;
}
rkr->efx_Echotron->changepar(9,(int)o->value());
}
void RKRGUI::cb_echotron_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_stdf_i(o,v);
}

void RKRGUI::cb_echotron_af_i(Fl_Check_Button* o, void*) {
  rkr->efx_Echotron->changepar(15,(int)o->value());
}
void RKRGUI::cb_echotron_af(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_af_i(o,v);
}

void RKRGUI::cb_echotron_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Echotron->changepar(14,(int)o->value());
}
void RKRGUI::cb_echotron_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_lfotype_i(o,v);
}

void RKRGUI::cb_echotron_mf_i(Fl_Check_Button* o, void*) {
  rkr->efx_Echotron->changepar(13,(int)o->value());
}
void RKRGUI::cb_echotron_mf(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_mf_i(o,v);
}

void RKRGUI::cb_echotron_md_i(Fl_Check_Button* o, void*) {
  rkr->efx_Echotron->changepar(12,(int)o->value());
}
void RKRGUI::cb_echotron_md(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_md_i(o,v);
}

void RKRGUI::cb_echotron_user_i(Fl_Check_Button* o, void*) {
  rkr->efx_Echotron->changepar(4,(int)o->value());

if((int)o->value())B_ech->activate(); else B_ech->deactivate();
}
void RKRGUI::cb_echotron_user(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_user_i(o,v);
}

void RKRGUI::cb_B_ech_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Load dly File:","(*.dly)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".dly");
strcpy(rkr->efx_Echotron->Filename,filename);
rkr->efx_Echotron->setfile(100);
echotron_length->value(rkr->efx_Echotron->getpar(3));
echotron_length->maximum(rkr->efx_Echotron->getpar(3));
}
void RKRGUI::cb_B_ech(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_B_ech_i(o,v);
}

void RKRGUI::cb_echotron_length_i(Fl_Counter* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(357);
 return;
}
rkr->efx_Echotron->changepar(3,(int)o->value());
}
void RKRGUI::cb_echotron_length(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_length_i(o,v);
}

void RKRGUI::cb_echotron_fnum_i(Fl_Choice* o, void*) {
  rkr->efx_Echotron->changepar(8,(int)o->value());
echotron_length->value(rkr->efx_Echotron->getpar(3));
echotron_length->maximum(rkr->efx_Echotron->getpar(3));
}
void RKRGUI::cb_echotron_fnum(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_echotron_fnum_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_echotron_fnum[] = {
 {"SwingPong", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Short Delays", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Flange + Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Comb", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"EchoFlange", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Filtered Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Notch-Wah", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Multi-Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"PingPong", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"90-Shifter", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Basic LR Delay", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_shar_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->StereoHarm_Bypass);
 return;
}
rkr->StereoHarm_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_StereoHarm->cleanup();
rkr->efx_StereoHarm->changepar(3,rkr->efx_StereoHarm->getpar(3));
rkr->efx_StereoHarm->changepar(6,rkr->efx_StereoHarm->getpar(6));
Chord(1);
findpos(42,(int)o->value(),o);
}
void RKRGUI::cb_shar_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_activar_i(o,v);
}

void RKRGUI::cb_shar_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12042))rkr->efx_StereoHarm->setpreset((int)o->value());
shar_WD->value(rkr->efx_StereoHarm->getpar(0)-64);
shar_ganl->value(rkr->efx_StereoHarm->getpar(1)-64);
shar_intl->value(rkr->efx_StereoHarm->getpar(2)-12);
shar_chl->value(rkr->efx_StereoHarm->getpar(3));
shar_ganr->value(rkr->efx_StereoHarm->getpar(4)-64);
shar_intr->value(rkr->efx_StereoHarm->getpar(5)-12);
shar_chr->value(rkr->efx_StereoHarm->getpar(6));
shar_lrc->value(rkr->efx_StereoHarm->getpar(11)-64);
shar_SELECT->value(rkr->efx_StereoHarm->getpar(7));
shar_note->value(rkr->efx_StereoHarm->getpar(8));
shar_type->value(rkr->efx_StereoHarm->getpar(9));
shar_MIDI->value(rkr->efx_StereoHarm->getpar(10));
if ((rkr->efx_StereoHarm->PMIDI) || (rkr->efx_StereoHarm->PSELECT)) Chord(1);
}
void RKRGUI::cb_shar_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_shar_preset[] = {
 {"Plain", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Octavator", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hard Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_shar_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(358);
 return;
}
rkr->efx_StereoHarm->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_shar_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_WD_i(o,v);
}

void RKRGUI::cb_shar_intl_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(359);
 return;
}
rkr->StereoHarm_Bypass=0;
rkr->efx_StereoHarm->changepar(2,(int)(o->value()+12));
if((int)shar_activar->value())rkr->StereoHarm_Bypass=1;
}
void RKRGUI::cb_shar_intl(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_intl_i(o,v);
}

void RKRGUI::cb_shar_chl_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(360);
 return;
}
rkr->efx_StereoHarm->changepar(3,(int)o->value());
}
void RKRGUI::cb_shar_chl(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_chl_i(o,v);
}

void RKRGUI::cb_shar_ganl_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(361);
 return;
}
rkr->efx_StereoHarm->changepar(1,(int)(o->value()+64));
}
void RKRGUI::cb_shar_ganl(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_ganl_i(o,v);
}

void RKRGUI::cb_shar_intr_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(362);
 return;
}
rkr->StereoHarm_Bypass=0;
rkr->efx_StereoHarm->changepar(5,(int)(o->value()+12));
if((int)shar_activar->value())rkr->StereoHarm_Bypass=1;
}
void RKRGUI::cb_shar_intr(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_intr_i(o,v);
}

void RKRGUI::cb_shar_chr_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(363);
 return;
}
rkr->efx_StereoHarm->changepar(6,(int)o->value());
}
void RKRGUI::cb_shar_chr(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_chr_i(o,v);
}

void RKRGUI::cb_shar_ganr_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(364);
 return;
}
rkr->efx_StereoHarm->changepar(4,(int)(o->value()+64));
}
void RKRGUI::cb_shar_ganr(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_ganr_i(o,v);
}

void RKRGUI::cb_shar_lrc_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(365);
 return;
}
rkr->efx_StereoHarm->changepar(11,(int)(o->value()+64));
}
void RKRGUI::cb_shar_lrc(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_lrc_i(o,v);
}

void RKRGUI::cb_shar_MIDI_i(Fl_Check_Button* o, void*) {
  rkr->efx_StereoHarm->changepar(10,(int)o->value());
rkr->RC->cleanup();

if(!(int)o->value())
{
rkr->efx_StereoHarm->changepar(3,rkr->efx_StereoHarm->getpar(3));
rkr->efx_StereoHarm->changepar(6,rkr->efx_StereoHarm->getpar(6));
};
}
void RKRGUI::cb_shar_MIDI(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_MIDI_i(o,v);
}

void RKRGUI::cb_shar_SELECT_i(Fl_Check_Button* o, void*) {
  rkr->efx_StereoHarm->changepar(7,(int)o->value());
rkr->RC->cleanup();
Chord(1);

if(!(int)o->value())
{
rkr->efx_StereoHarm->changepar(3,rkr->efx_StereoHarm->getpar(3));
rkr->efx_StereoHarm->changepar(6,rkr->efx_StereoHarm->getpar(6));
};
}
void RKRGUI::cb_shar_SELECT(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_SELECT_i(o,v);
}

void RKRGUI::cb_shar_note_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(366);
 return;
}
rkr->efx_StereoHarm->changepar(8,(int)o->value());
Chord(1);
}
void RKRGUI::cb_shar_note(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_note_i(o,v);
}

void RKRGUI::cb_shar_type_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(367);
 return;
}
rkr->efx_StereoHarm->changepar(9,(int)o->value());
Chord(1);
}
void RKRGUI::cb_shar_type(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_shar_type_i(o,v);
}

void RKRGUI::cb_cband_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->CompBand_Bypass);
 return;
}
rkr->CompBand_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_CompBand->cleanup();
findpos(43,(int)o->value(),o);
}
void RKRGUI::cb_cband_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_activar_i(o,v);
}

void RKRGUI::cb_cband_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12043))rkr->efx_CompBand->setpreset((int)o->value());
cband_WD->value(rkr->efx_CompBand->getpar(0)-64);
cband_Lratio->value(rkr->efx_CompBand->getpar(1));
cband_MLratio->value(rkr->efx_CompBand->getpar(2));
cband_MHratio->value(rkr->efx_CompBand->getpar(3));
cband_Hratio->value(rkr->efx_CompBand->getpar(4));
cband_Lthres->value(rkr->efx_CompBand->getpar(5));
cband_MLthres->value(rkr->efx_CompBand->getpar(6));
cband_MHthres->value(rkr->efx_CompBand->getpar(7));
cband_Hthres->value(rkr->efx_CompBand->getpar(8));
cband_cross1->value(rkr->efx_CompBand->getpar(9));
cband_cross2->value(rkr->efx_CompBand->getpar(10));
cband_cross3->value(rkr->efx_CompBand->getpar(11));
cband_cross3->value(rkr->efx_CompBand->getpar(11));
cband_gain->value(rkr->efx_CompBand->getpar(12));
}
void RKRGUI::cb_cband_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_cband_preset[] = {
 {"Good Start", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Loudness", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Loudness 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_cband_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(368);
 return;
}
rkr->efx_CompBand->changepar(0,(int)(o->value()+64));
}
void RKRGUI::cb_cband_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_WD_i(o,v);
}

void RKRGUI::cb_cband_gain_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(369);
 return;
}
rkr->efx_CompBand->changepar(12,(int)o->value());
}
void RKRGUI::cb_cband_gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_gain_i(o,v);
}

void RKRGUI::cb_cband_Lratio_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(370);
 return;
}
rkr->efx_CompBand->changepar(1, (int) o->value());
}
void RKRGUI::cb_cband_Lratio(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_Lratio_i(o,v);
}

void RKRGUI::cb_cband_MLratio_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(371);
 return;
}
rkr->efx_CompBand->changepar(2, (int) o->value());
}
void RKRGUI::cb_cband_MLratio(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_MLratio_i(o,v);
}

void RKRGUI::cb_cband_MHratio_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(372);
 return;
}
rkr->efx_CompBand->changepar(3, (int) o->value());
}
void RKRGUI::cb_cband_MHratio(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_MHratio_i(o,v);
}

void RKRGUI::cb_cband_Hratio_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(373);
 return;
}
rkr->efx_CompBand->changepar(4, (int) o->value());
}
void RKRGUI::cb_cband_Hratio(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_Hratio_i(o,v);
}

void RKRGUI::cb_cband_Lthres_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(374);
 return;
}
rkr->efx_CompBand->changepar(5, (int)o->value());
}
void RKRGUI::cb_cband_Lthres(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_Lthres_i(o,v);
}

void RKRGUI::cb_cband_MLthres_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(375);
 return;
}
rkr->efx_CompBand->changepar(6, (int)o->value());
}
void RKRGUI::cb_cband_MLthres(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_MLthres_i(o,v);
}

void RKRGUI::cb_cband_MHthres_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(376);
 return;
}
rkr->efx_CompBand->changepar(7, (int)o->value());
}
void RKRGUI::cb_cband_MHthres(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_MHthres_i(o,v);
}

void RKRGUI::cb_cband_Hthres_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(377);
 return;
}
rkr->efx_CompBand->changepar(8, (int)o->value());
}
void RKRGUI::cb_cband_Hthres(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_Hthres_i(o,v);
}

void RKRGUI::cb_cband_cross1_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(378);
 return;
}
rkr->efx_CompBand->changepar(9,(int)o->value());
}
void RKRGUI::cb_cband_cross1(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_cross1_i(o,v);
}

void RKRGUI::cb_cband_cross2_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(379);
 return;
}
rkr->efx_CompBand->changepar(10,(int)o->value());
}
void RKRGUI::cb_cband_cross2(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_cross2_i(o,v);
}

void RKRGUI::cb_cband_cross3_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(380);
 return;
}
rkr->efx_CompBand->changepar(11,(int)o->value());
}
void RKRGUI::cb_cband_cross3(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_cband_cross3_i(o,v);
}

void RKRGUI::cb_otrem_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Opticaltrem_Bypass);
 return;
}
rkr->Opticaltrem_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Opticaltrem->cleanup();
findpos(44,(int)o->value(),o);
}
void RKRGUI::cb_otrem_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_activar_i(o,v);
}

void RKRGUI::cb_otrem_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12044))rkr->efx_Opticaltrem->setpreset((int)o->value());
otrem_dpth->value(rkr->efx_Opticaltrem->getpar(0));
otrem_freq->value(rkr->efx_Opticaltrem->getpar(1));
otrem_rnd->value(rkr->efx_Opticaltrem->getpar(2));
otrem_lfotype->value(rkr->efx_Opticaltrem->getpar(3));
otrem_stdf->value(rkr->efx_Opticaltrem->getpar(4));
otrem_pan->value(rkr->efx_Opticaltrem->getpar(5)-64);
}
void RKRGUI::cb_otrem_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_otrem_preset[] = {
 {"Fast", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Trem 2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hard Pan", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Soft Pan", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Ramp Down", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Hard Ramp", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_otrem_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(381);
 return;
}
rkr->efx_Opticaltrem->changepar(0,(int)o->value());
}
void RKRGUI::cb_otrem_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_dpth_i(o,v);
}

void RKRGUI::cb_otrem_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(382);
 return;
}
rkr->efx_Opticaltrem->changepar(1,(int)o->value());
}
void RKRGUI::cb_otrem_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_freq_i(o,v);
}

void RKRGUI::cb_otrem_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(383);
 return;
}
rkr->efx_Opticaltrem->changepar(2,(int)o->value());
}
void RKRGUI::cb_otrem_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_rnd_i(o,v);
}

void RKRGUI::cb_otrem_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Opticaltrem->changepar(3,(int)o->value());
}
void RKRGUI::cb_otrem_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_lfotype_i(o,v);
}

void RKRGUI::cb_otrem_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(384);
 return;
}
rkr->efx_Opticaltrem->changepar(4,(int)o->value());
}
void RKRGUI::cb_otrem_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_stdf_i(o,v);
}

void RKRGUI::cb_otrem_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(385);
 return;
}
rkr->efx_Opticaltrem->changepar(5,(int)(o->value()+64));
}
void RKRGUI::cb_otrem_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_otrem_pan_i(o,v);
}

void RKRGUI::cb_vibe_activar_i(Fl_Light_Button* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(116);
 o->value(rkr->Vibe_Bypass);
 return;
}
rkr->Vibe_Bypass=(int)o->value();
if((int) o->value()==0)
rkr->efx_Vibe->cleanup();
findpos(45,(int)o->value(),o);
}
void RKRGUI::cb_vibe_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_activar_i(o,v);
}

void RKRGUI::cb_vibe_preset_i(Fl_Choice* o, void* v) {
  long long ud= (long long) v;
if((ud==0)||(ud==12045))rkr->efx_Vibe->setpreset((int)o->value());
vibe_WD->value(rkr->efx_Vibe->getpar(6)-64);
vibe_width->value(rkr->efx_Vibe->getpar(0));
vibe_dpth->value(rkr->efx_Vibe->getpar(8));
vibe_freq->value(rkr->efx_Vibe->getpar(1));
vibe_rnd->value(rkr->efx_Vibe->getpar(2));
vibe_lfotype->value(rkr->efx_Vibe->getpar(3));
vibe_stdf->value(rkr->efx_Vibe->getpar(4));
vibe_pan->value(rkr->efx_Vibe->getpar(5)-64);
vibe_fb->value(rkr->efx_Vibe->getpar(7)-64);
vibe_LR->value(rkr->efx_Vibe->getpar(9)-64);
}
void RKRGUI::cb_vibe_preset(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_preset_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_vibe_preset[] = {
 {"Classic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Stereo Classic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Wide Vibe", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Classic Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Vibe Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Lush Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Sick Phaser", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Warble", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_vibe_WD_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(386);
 return;
}
rkr->efx_Vibe->changepar(6,(int)(o->value())+64);
}
void RKRGUI::cb_vibe_WD(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_WD_i(o,v);
}

void RKRGUI::cb_vibe_width_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(387);
 return;
}
rkr->efx_Vibe->changepar(0,(int)o->value());
}
void RKRGUI::cb_vibe_width(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_width_i(o,v);
}

void RKRGUI::cb_vibe_dpth_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(388);
 return;
}
rkr->efx_Vibe->changepar(8,(int)o->value());
}
void RKRGUI::cb_vibe_dpth(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_dpth_i(o,v);
}

void RKRGUI::cb_vibe_freq_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(389);
 return;
}
rkr->efx_Vibe->changepar(1,(int)o->value());
}
void RKRGUI::cb_vibe_freq(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_freq_i(o,v);
}

void RKRGUI::cb_vibe_rnd_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(390);
 return;
}
rkr->efx_Vibe->changepar(2,(int)o->value());
}
void RKRGUI::cb_vibe_rnd(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_rnd_i(o,v);
}

void RKRGUI::cb_vibe_lfotype_i(Fl_Choice* o, void*) {
  rkr->efx_Vibe->changepar(3,(int)o->value());
}
void RKRGUI::cb_vibe_lfotype(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_lfotype_i(o,v);
}

void RKRGUI::cb_vibe_stdf_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(391);
 return;
}
rkr->efx_Vibe->changepar(4,(int)o->value());
}
void RKRGUI::cb_vibe_stdf(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_stdf_i(o,v);
}

void RKRGUI::cb_vibe_fb_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(392);
 return;
}
rkr->efx_Vibe->changepar(7,(int)(o->value()+64));
}
void RKRGUI::cb_vibe_fb(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_fb_i(o,v);
}

void RKRGUI::cb_vibe_LR_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(393);
 return;
}
rkr->efx_Vibe->changepar(9,(int)(o->value()+64));
}
void RKRGUI::cb_vibe_LR(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_LR_i(o,v);
}

void RKRGUI::cb_vibe_pan_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(394);
 return;
}
rkr->efx_Vibe->changepar(5,(int)(o->value()+64));
}
void RKRGUI::cb_vibe_pan(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_vibe_pan_i(o,v);
}

void RKRGUI::cb_tuner_activar_i(Fl_Light_Button* o, void*) {
  rkr->Tuner_Bypass=(int)o->value();
tuner_bar->value(-32);
WNote->copy_label("");
WRfreq->copy_label("");
WNfreq->copy_label("");
ChangeActives();
TUNER_LABEL->redraw_label();
}
void RKRGUI::cb_tuner_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_tuner_activar_i(o,v);
}

void RKRGUI::cb_ActivarGeneral_i(Fl_Light_Button* o, void*) {
  rkr->Bypass=o->value();
rkr->val_il_sum=-50.0;
rkr->val_ir_sum=-50.0;

rkr->val_vl_sum=-50.0;
rkr->val_vr_sum=-50.0;

rkr->old_vl_sum=-50.0;
rkr->old_vr_sum=-50.0;

rkr->old_il_sum=-50.0;
rkr->old_ir_sum=-50.0;

input_vul->value(-50.0);
input_vur->value(-50.0);

output_vul->value(-50.0);
output_vur->value(-50.0);


ChangeActives();  
LABEL_IO->redraw_label();

if (!o->value())
   {
    rkr->OnCounter = 0;
    if (rkr->Tuner_Bypass)
        {
           tuner_activar->value(0);
           tuner_activar->do_callback();
        } 
    if (rkr->MIDIConverter_Bypass)  
        {
            nidi_activar->value(0);
            nidi_activar->do_callback();
        }
             
rkr->cleanup_efx();

};
}
void RKRGUI::cb_ActivarGeneral(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_ActivarGeneral_i(o,v);
}

void RKRGUI::cb_BostBut_i(Fl_Button* o, void*) {
  if(o->value()) rkr->booster = dB2rap(10);
else rkr->booster=1.0f;
}
void RKRGUI::cb_BostBut(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_BostBut_i(o,v);
}

void RKRGUI::cb_Balance_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(12);
 return;
} 
rkr->Fraction_Bypass=(float)(o->value()/100.0f);
}
void RKRGUI::cb_Balance(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Balance_i(o,v);
}

void RKRGUI::cb_Nivel_Entrada_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(14);
 return;
} 
rkr->Input_Gain=(float)((o->value()+50)/100.0);
rkr->calculavol(1);
}
void RKRGUI::cb_Nivel_Entrada(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Nivel_Entrada_i(o,v);
}

void RKRGUI::cb_Nivel_Salida_i(SliderW* o, void*) {
  if(Fl::event_button()==3)
{
 getMIDIControl(7);
 return;
} 

rkr->Master_Volume=(float)((o->value()+50)/100.0);
rkr->calculavol(2);
}
void RKRGUI::cb_Nivel_Salida(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Nivel_Salida_i(o,v);
}

void RKRGUI::cb_nidi_activar_i(Fl_Light_Button* o, void*) {
  if ((int)o->value()==0)
{ 
rkr->efx_MIDIConverter->panic();
  Mled->color(fl_darker(FL_RED));
  Mled->redraw();
}


rkr->MIDIConverter_Bypass=(int)o->value();
Midi_out_Counter->do_callback();

ChangeActives();
MIDI_LABEL->redraw_label();
}
void RKRGUI::cb_nidi_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_nidi_activar_i(o,v);
}

void RKRGUI::cb_MIDIOctave_i(Fl_Choice* o, void*) {
  switch((int)o->value())
{
  case 0:
  rkr->efx_MIDIConverter->Moctave=-2;
  break;
  
  case 1:
  rkr->efx_MIDIConverter->Moctave=-1;
  break;

  case 2:
  rkr->efx_MIDIConverter->Moctave=0;
  break;

  case 3:
  rkr->efx_MIDIConverter->Moctave=1;
  break;

  case 4:
  rkr->efx_MIDIConverter->Moctave=2;
  break;

};
}
void RKRGUI::cb_MIDIOctave(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_MIDIOctave_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_MIDIOctave[] = {
 {"-2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"-1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"0", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Midi_out_Counter_i(Fl_Counter* o, void*) {
  rkr->efx_MIDIConverter->setmidichannel((int)o->value()-1);
}
void RKRGUI::cb_Midi_out_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Midi_out_Counter_i(o,v);
}

void RKRGUI::cb_Trig_Adj_i(SliderW* o, void*) {
  rkr->efx_MIDIConverter->setTriggerAdjust((int)o->value());
}
void RKRGUI::cb_Trig_Adj(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Trig_Adj_i(o,v);
}

void RKRGUI::cb_Vel_Adj_i(SliderW* o, void*) {
  rkr->efx_MIDIConverter->setVelAdjust((int)o->value());
}
void RKRGUI::cb_Vel_Adj(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Vel_Adj_i(o,v);
}

void RKRGUI::cb_MIDI_LABEL_i(Fl_Box*, void*) {
  int ok;
char *filename;

#define EXT ".rkrb"
filename=fl_file_chooser("Save Bank File:","(*"EXT")",rkr->Bank_Saved,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,EXT);
#undef EXT
ok=rkr->savebank(filename);
if (ok)
{
strcpy(rkr->Bank_Saved,filename);
BankWin_Label(filename);
};
}
void RKRGUI::cb_MIDI_LABEL(Fl_Box* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_MIDI_LABEL_i(o,v);
}

void RKRGUI::cb_metro_activar_i(Fl_Light_Button* o, void*) {
  if ((int)o->value()==0)
{ 
  Metro_Led->color(fl_darker(FL_RED));
  Metro_Led->redraw();
}

rkr->M_Metronome->cleanup();
rkr->Metro_Bypass=(int)o->value();


ChangeActives();
Metro_Label->redraw_label();
}
void RKRGUI::cb_metro_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_metro_activar_i(o,v);
}

void RKRGUI::cb_MetroBar_i(Fl_Choice* o, void*) {
  rkr->M_Metro_Bar=(int)o->value();

switch(rkr->M_Metro_Bar)

   {
      case 0:
      rkr->M_Metronome->set_meter(2);
      break;                    
      case 1:
      rkr->M_Metronome->set_meter(3);
      break;                    
      case 2:
      rkr->M_Metronome->set_meter(4);
      break;                    
      case 3:
      rkr->M_Metronome->set_meter(5);
      break;                    
      case 4:
      rkr->M_Metronome->set_meter(6);
      break;                    
      case 5:
      rkr->M_Metronome->set_meter(7);
      break;                    
      case 6:
      rkr->M_Metronome->set_meter(9);
      break;                    
      case 7:
      rkr->M_Metronome->set_meter(11);
      break;                    

 };
}
void RKRGUI::cb_MetroBar(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_MetroBar_i(o,v);
}

void RKRGUI::cb_Metro_Volume_i(SliderW* o, void*) {
  rkr->M_Metro_Vol=2.0f*(float)o->value()/100.0f;
}
void RKRGUI::cb_Metro_Volume(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Metro_Volume_i(o,v);
}

void RKRGUI::cb_MetroSound_i(Fl_Choice* o, void*) {
  rkr->M_Metro_Sound=(int)o->value();

switch(rkr->M_Metro_Sound)

   {
      case 0:
      MetroBar->do_callback();
      break;                    
      case 1:
      rkr->M_Metronome->set_meter(1);
      break;                    
      case 2:
      rkr->M_Metronome->set_meter(0);
      break;                    
       

 };
}
void RKRGUI::cb_MetroSound(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_MetroSound_i(o,v);
}

void RKRGUI::cb_Metro_Tempo_i(SliderW* o, void*) {
  rkr->M_Metro_Tempo=(int)o->value();
rkr->M_Metronome->set_tempo(rkr->M_Metro_Tempo);
}
void RKRGUI::cb_Metro_Tempo(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Metro_Tempo_i(o,v);
}

void RKRGUI::cb_L_B1_i(Fl_Button*, void*) {
  is_modified();
char temp[128];           
  memset (temp, 0, sizeof (temp));
  sprintf (temp, "%s/Default.rkrb", DATADIR);
int ok=rkr->loadbank(temp);
if(ok) 
{
rkr->a_bank=0;
BankWin_Label(temp);
Put_Loaded_Bank();
unlight_preset(rkr->Selected_Preset);
};
}
void RKRGUI::cb_L_B1(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_L_B1_i(o,v);
}

void RKRGUI::cb_L_B2_i(Fl_Button*, void*) {
  is_modified();
char temp[128];           
  memset (temp, 0, sizeof (temp));
  sprintf (temp, "%s/Extra.rkrb", DATADIR);
 int ok=rkr->loadbank(temp);
if(ok) 
{
rkr->a_bank=1;
BankWin_Label(temp);
Put_Loaded_Bank();
unlight_preset(rkr->Selected_Preset);
};
}
void RKRGUI::cb_L_B2(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_L_B2_i(o,v);
}

void RKRGUI::cb_L_B3_i(Fl_Button*, void*) {
  is_modified();
char temp[128];           
  memset (temp, 0, sizeof (temp));
  sprintf (temp, "%s/Extra1.rkrb", DATADIR);
 int ok=rkr->loadbank(temp);
if(ok) 
{
rkr->a_bank=2;
BankWin_Label(temp);
Put_Loaded_Bank();
unlight_preset(rkr->Selected_Preset);
};
}
void RKRGUI::cb_L_B3(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_L_B3_i(o,v);
}

void RKRGUI::cb_L_B4_i(Fl_Button*, void*) {
  is_modified();
int ok=rkr->loadbank(rkr->BankFilename);
if(ok) 
{
rkr->a_bank=3;
BankWin_Label(rkr->BankFilename);
Put_Loaded_Bank();
unlight_preset(rkr->Selected_Preset);
};
}
void RKRGUI::cb_L_B4(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_L_B4_i(o,v);
}

void RKRGUI::cb_S_new_i(Fl_Button*, void*) {
  rkr->New();
DisAssigns();
FillML(0);
Prepare_Order();
Put_Loaded();
}
void RKRGUI::cb_S_new(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_S_new_i(o,v);
}

void RKRGUI::cb_L_preset_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Load Preset:","(*.rkr)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkr");
rkr->loadfile(filename);
Put_Loaded();
}
void RKRGUI::cb_L_preset(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_L_preset_i(o,v);
}

void RKRGUI::cb_S_preset_i(Fl_Button*, void*) {
  char *filename;
#define EXT ".rkr"
filename=fl_file_chooser("Save Preset:","(*"EXT")",rkr->Preset_Name,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,EXT);
#undef EXT
rkr->savefile(filename);
}
void RKRGUI::cb_S_preset(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_S_preset_i(o,v);
}

void RKRGUI::cb_Compare_i(Fl_Light_Button* o, void*) {
  if ((int) o->value())
{
rkr->Preset_to_Bank(0);
rkr->Bank_to_Preset((int)Preset_Counter->value());
Put_Loaded();
}

else
{
 rkr->Bank_to_Preset(0);
 Put_Loaded();
};
}
void RKRGUI::cb_Compare(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Compare_i(o,v);
}

void RKRGUI::cb_B_preset_i(Fl_Button*, void*) {
  if(!BankWindow->visible())
{
if(!made) make_window_banks();
BankWindow->show();
put_icon(BankWindow);
ScanDir();
}
else
BankWindow->hide();
}
void RKRGUI::cb_B_preset(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_B_preset_i(o,v);
}

void RKRGUI::cb_WPreset_Name_i(Fl_Input* o, void*) {
  strcpy(rkr->Preset_Name,o->value());
}
void RKRGUI::cb_WPreset_Name(Fl_Input* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_WPreset_Name_i(o,v);
}

void RKRGUI::cb_Preset_Counter_i(Fl_Counter* o, void*) {
  rkr->new_bank_loaded=0;
unlight_preset(rkr->Selected_Preset);
rkr->Bank_to_Preset((int) o->value());
light_preset((int)o->value());
rkr->Selected_Preset=(int)o->value();
rkr->OnCounter=0;
FillML(0);
Prepare_Order();
Put_Loaded();
if(rkr->Tap_Updated) UpdateTGUI();
}
void RKRGUI::cb_Preset_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Preset_Counter_i(o,v);
}

void RKRGUI::cb_RandomP_i(Fl_Button*, void*) {
  RandomPreset();
}
void RKRGUI::cb_RandomP(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_RandomP_i(o,v);
}

void RKRGUI::cb_Open_Order_i(Fl_Button*, void*) {
  if (!Order->visible())
{
Prepare_Order();
rkr->deachide=0;
Order_DeacHide->value(rkr->deachide);
Order->show();
put_icon(Order);
}
else
Order->hide();
}
void RKRGUI::cb_Open_Order(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Open_Order_i(o,v);
}

void RKRGUI::cb_Etit_i(Fl_Button* o, void*) {
  if(rkr->Bypass)
{
o->hide();
Analy->show();
Analyzer_ON=1;
};
}
void RKRGUI::cb_Etit(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Etit_i(o,v);
}

void RKRGUI::cb_HideUE_i(Fl_Button* o, void*) {
  if(rkr->deachide)
{
 rkr->deachide=0;
 o->label("Hide");
}
else
{
rkr->deachide=1;
 o->label("Show");
}
 
reordena();
}
void RKRGUI::cb_HideUE(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_HideUE_i(o,v);
}

void RKRGUI::cb_SwitchMod_i(Fl_Button*, void*) {
  if(rkr->sw_stat==0) 
{ 
  rkr->sw_stat = 1;
  Midi->hide();
  Metro->show();
}
else
 {
  rkr->sw_stat= 0;
  Metro->hide();
  Midi->show();
 };
}
void RKRGUI::cb_SwitchMod(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_SwitchMod_i(o,v);
}

void RKRGUI::cb_Tap_activar_i(Fl_Light_Button* o, void*) {
  rkr->Tap_Bypass = (int)o->value();
if(rkr->Tap_Bypass) rkr->TapTempo_Timeout(0);
ChangeActives();
TAP_LABEL->redraw_label();
}
void RKRGUI::cb_Tap_activar(Fl_Light_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Tap_activar_i(o,v);
}

void RKRGUI::cb_T_SEL_i(Fl_Choice* o, void*) {
  rkr->Tap_Selection=(int)o->value();
}
void RKRGUI::cb_T_SEL(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_T_SEL_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_T_SEL[] = {
 {"GUI", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"MIDI Note On", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Jack Transport", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"MTC", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_T_SET_i(Fl_Choice* o, void*) {
  rkr->Tap_SetValue=(int)o->value();
}
void RKRGUI::cb_T_SET(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_T_SET_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_T_SET[] = {
 {"Dl. 1 LFO 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1 LFO 1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1 LFO 1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1 LFO 1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1 LFO 1/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/2 LFO 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/2 LFO 1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/2 LFO 1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/2 LFO 1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/2 LFO 1/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/3 LFO 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/3 LFO 1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/3 LFO 1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/3 LFO 1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/3 LFO 1/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/4 LFO 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/4 LFO 1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/4 LFO 1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/4 LFO 1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/4 LFO 1/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/8 LFO 1", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/8 LFO 1/2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/8 LFO 1/3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/8 LFO 1/4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {"Dl. 1/8 LFO 1/8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 9, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_T_Apply_i(Fl_Button*, void*) {
  if((rkr->Tap_Bypass) && (rkr->Tap_TempoSet>0))
{
rkr->Update_tempo();
UpdateTGUI();
};
}
void RKRGUI::cb_T_Apply(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_T_Apply_i(o,v);
}

void RKRGUI::cb_T_BUT_i(Fl_Button*, void*) {
  if((rkr->Tap_Bypass) && ( rkr->Tap_Selection==0))
{
T_DIS->value(rkr->TapTempo());
UpdateTGUI();
};
}
void RKRGUI::cb_T_BUT(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_T_BUT_i(o,v);
}

void RKRGUI::cb_T_DIS_i(Fl_Value_Input* o, void*) {
  if(o->value()> 360) o->value(360);
if(o->value()< 20) o->value(20);
if(rkr->Tap_Bypass)
{
rkr->Tap_TempoSet=(int)o->value();
rkr->Update_tempo();
UpdateTGUI();
};
}
void RKRGUI::cb_T_DIS(Fl_Value_Input* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_T_DIS_i(o,v);
}

void RKRGUI::cb_BankWindow_i(Fl_Double_Window* o, void*) {
  o->hide();
save_stat(1);
}
void RKRGUI::cb_BankWindow(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_BankWindow_i(o,v);
}

void RKRGUI::cb_NewB_i(Fl_Menu_*, void*) {
  rkr->New_Bank();
Put_Loaded_Bank();
BankWindow->redraw();
}
void RKRGUI::cb_NewB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_NewB_i(o,v);
}

void RKRGUI::cb_Load_Bank_i(Fl_Menu_*, void*) {
  int ok;
char *filename;
is_modified();
filename=fl_file_chooser("Load Bank File:","(*.rkrb)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkrb");
ok=rkr->loadbank(filename);
if(ok) 
{
BankWin_Label(filename);
Put_Loaded_Bank();

};
}
void RKRGUI::cb_Load_Bank(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Load_Bank_i(o,v);
}

void RKRGUI::cb_Save_Bank_i(Fl_Menu_*, void*) {
  MIDI_LABEL->do_callback();
}
void RKRGUI::cb_Save_Bank(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Save_Bank_i(o,v);
}

void RKRGUI::cb_Convert_Old_Bank_i(Fl_Menu_*, void*) {
  char *filename;
char name[64];
memset(name,0, sizeof(name));
sprintf(name,"%s %s",rkr->jackcliname, VERSION);

filename=fl_file_chooser("Convert Old Bank File:","(*.rkrb)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkrb");

if(rkr->CheckOldBank(filename))
{
rkr->ConvertOldFile(filename);
rkr->Message(1,name, "Please, now try to load the new files");
}
else
rkr->Message(1, name, "This file has already the new format");
}
void RKRGUI::cb_Convert_Old_Bank(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Convert_Old_Bank_i(o,v);
}

void RKRGUI::cb_salirB_i(Fl_Menu_*, void*) {
  BankWindow->do_callback();
}
void RKRGUI::cb_salirB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_salirB_i(o,v);
}

void RKRGUI::cb_ContenidoB_i(Fl_Menu_*, void*) {
  show_help();
}
void RKRGUI::cb_ContenidoB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ContenidoB_i(o,v);
}

void RKRGUI::cb_Acerca_deB_i(Fl_Menu_*, void*) {
  int x,y;

x = BankWindow->x()+((BankWindow->w()-420)/2);
y = BankWindow->y()+((BankWindow->h()-230)/2);

AboutWin->position(x,y);
AboutWin->show();
put_icon(AboutWin);
}
void RKRGUI::cb_Acerca_deB(Fl_Menu_* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Acerca_deB_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_MenuB[] = {
 {"&File", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {"&New", 0,  (Fl_Callback*)RKRGUI::cb_NewB, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Load Bank", 0,  (Fl_Callback*)RKRGUI::cb_Load_Bank, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Save Bank", 0,  (Fl_Callback*)RKRGUI::cb_Save_Bank, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"Convert &Old Bank", 0,  (Fl_Callback*)RKRGUI::cb_Convert_Old_Bank, 0, 128, FL_NORMAL_LABEL, 0, 14, 0},
 {"&Close", 0,  (Fl_Callback*)RKRGUI::cb_salirB, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {"&Help", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 7},
 {"Help &Contents", 0xffbe,  (Fl_Callback*)RKRGUI::cb_ContenidoB, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {"&About...", 0,  (Fl_Callback*)RKRGUI::cb_Acerca_deB, 0, 0, FL_NORMAL_LABEL, 0, 14, 7},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* RKRGUI::ArchivoB = RKRGUI::menu_MenuB + 0;
Fl_Menu_Item* RKRGUI::NewB = RKRGUI::menu_MenuB + 1;
Fl_Menu_Item* RKRGUI::Load_Bank = RKRGUI::menu_MenuB + 2;
Fl_Menu_Item* RKRGUI::Save_Bank = RKRGUI::menu_MenuB + 3;
Fl_Menu_Item* RKRGUI::Convert_Old_Bank = RKRGUI::menu_MenuB + 4;
Fl_Menu_Item* RKRGUI::salirB = RKRGUI::menu_MenuB + 5;
Fl_Menu_Item* RKRGUI::AyudaB = RKRGUI::menu_MenuB + 7;
Fl_Menu_Item* RKRGUI::ContenidoB = RKRGUI::menu_MenuB + 8;
Fl_Menu_Item* RKRGUI::Acerca_deB = RKRGUI::menu_MenuB + 9;

void RKRGUI::cb_B_B1_i(Fl_Button*, void*) {
  L_B1->do_callback();
}
void RKRGUI::cb_B_B1(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_B_B1_i(o,v);
}

void RKRGUI::cb_B_B2_i(Fl_Button*, void*) {
  L_B2->do_callback();
}
void RKRGUI::cb_B_B2(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_B_B2_i(o,v);
}

void RKRGUI::cb_B_B3_i(Fl_Button*, void*) {
  L_B3->do_callback();
}
void RKRGUI::cb_B_B3(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_B_B3_i(o,v);
}

void RKRGUI::cb_B_B4_i(Fl_Button*, void*) {
  L_B4->do_callback();
}
void RKRGUI::cb_B_B4(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_B_B4_i(o,v);
}

void RKRGUI::cb_CH_UB_i(Fl_Choice* o, void*) {
  const char *chname;

const Fl_Menu_Item *p, *m;  
m = o->menu();
p=m->next((int)o->value());
chname=p->label();

is_modified();
char temp[128];           
  memset (temp, 0, sizeof (temp));
  sprintf (temp, "%s%s%s", rkr->UDirFilename,chname,".rkrb");

int ok=rkr->loadbank(temp);
if(ok) 
{
BankWin_Label(temp);
Put_Loaded_Bank();
unlight_preset(rkr->Selected_Preset);
};
}
void RKRGUI::cb_CH_UB(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_CH_UB_i(o,v);
}

void RKRGUI::cb_Order_i(Fl_Double_Window*, void*) {
  save_stat(2);
Order->hide();
}
void RKRGUI::cb_Order(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_Order_i(o,v);
}

void RKRGUI::cb_Pon_i(Fl_Button*, void*) {
  int i = Order_Bro->value();
int j = Avail_Bro->value();

if(!i) return;
if(!j) return;

Order_Bro->insert(i,Avail_Bro->text(j));

Avail_Bro->remove(j);
Order_Bro->remove(i+1);
Order_Bro->select(1);
rkr->new_order[i-1]=rkr->availables[j];
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Pon(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Pon_i(o,v);
}

void RKRGUI::cb_Sube_i(Fl_Button*, void*) {
  int x,x1;

int i = Order_Bro->value();

Order_Bro->move(i,i-1);

i--;

if (i>0) 
{
x=rkr->new_order[i];
x1=rkr->new_order[i-1];

rkr->new_order[i]=x1;
rkr->new_order[i-1]=x;
};
}
void RKRGUI::cb_Sube(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Sube_i(o,v);
}

void RKRGUI::cb_Baja_i(Fl_Button*, void*) {
  int x,x1;

int i = Order_Bro->value();

Order_Bro->move(i,i+1);

i--;

if (i<9)
{
x=rkr->new_order[i];
x1=rkr->new_order[i+1];

rkr->new_order[i]=x1;
rkr->new_order[i+1]=x;
};
}
void RKRGUI::cb_Baja(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Baja_i(o,v);
}

void RKRGUI::cb_Fil0_i(Fl_Button*, void*) {
  rkr->eff_filter=0;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil0(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil0_i(o,v);
}

void RKRGUI::cb_Fil1_i(Fl_Button*, void*) {
  rkr->eff_filter=1;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil1(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil1_i(o,v);
}

void RKRGUI::cb_Fil2_i(Fl_Button*, void*) {
  rkr->eff_filter=2;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil2(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil2_i(o,v);
}

void RKRGUI::cb_Fil4_i(Fl_Button*, void*) {
  rkr->eff_filter=4;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil4(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil4_i(o,v);
}

void RKRGUI::cb_Fil8_i(Fl_Button*, void*) {
  rkr->eff_filter=8;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil8(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil8_i(o,v);
}

void RKRGUI::cb_Fil16_i(Fl_Button*, void*) {
  rkr->eff_filter=16;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil16(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil16_i(o,v);
}

void RKRGUI::cb_Fil32_i(Fl_Button*, void*) {
  rkr->eff_filter=32;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil32(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil32_i(o,v);
}

void RKRGUI::cb_Fil64_i(Fl_Button*, void*) {
  rkr->eff_filter=64;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil64(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil64_i(o,v);
}

void RKRGUI::cb_Fil128_i(Fl_Button*, void*) {
  rkr->eff_filter=128;
Fill_Avail(rkr->eff_filter);
}
void RKRGUI::cb_Fil128(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_Fil128_i(o,v);
}

void RKRGUI::cb_Order_DeacHide_i(Fl_Check_Button* o, void*) {
  rkr->deachide=(int) o->value();
}
void RKRGUI::cb_Order_DeacHide(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Order_DeacHide_i(o,v);
}

void RKRGUI::cb_ok_order_i(Fl_Button*, void*) {
  int i;
for (i=0;i<10;i++) rkr->efx_order[i]=rkr->new_order[i];
reordena();
Order->do_callback();
}
void RKRGUI::cb_ok_order(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ok_order_i(o,v);
}

void RKRGUI::cb_Cancel_order_i(Fl_Button*, void*) {
  int i;
for (i=0;i<10;i++) rkr->efx_order[i]=rkr->saved_order[i];
Order->do_callback();
}
void RKRGUI::cb_Cancel_order(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Cancel_order_i(o,v);
}

void RKRGUI::cb_Settings_i(Fl_Double_Window*, void*) {
  save_stat(3);
Settings->hide();
}
void RKRGUI::cb_Settings(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_Settings_i(o,v);
}

void RKRGUI::cb_scheme_ch_i(Fl_Choice* o, void*) {
  switch ((int)o->value())

{

  case 0:

Fl::scheme("");
Fl::redraw();
break;

  case 1:

Fl::scheme("none");
Fl::redraw();
break;

  case 2:

Fl::scheme("gtk+");
Fl::redraw();
break;

  case 3:

Fl::scheme("plastic");
Fl::redraw();
break;

};
}
void RKRGUI::cb_scheme_ch(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_scheme_ch_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_scheme_ch[] = {
 {"X11", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"fltk", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"gtk+", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"plastic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Font_Bro_i(Fl_Browser* o, void*) {
  rkr->font = (int)o->value()-1;
chfsize(0);
}
void RKRGUI::cb_Font_Bro(Fl_Browser* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Font_Bro_i(o,v);
}

void RKRGUI::cb_FSless_i(Fl_Button*, void*) {
  rkr->relfontsize--;
chfsize(-1);
}
void RKRGUI::cb_FSless(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_FSless_i(o,v);
}

void RKRGUI::cb_FSplus_i(Fl_Button*, void*) {
  rkr->relfontsize++;
chfsize(1);
}
void RKRGUI::cb_FSplus(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_FSplus_i(o,v);
}

void RKRGUI::cb_FSReset_i(Fl_Button*, void*) {
  rkr->relfontsize=0;
chfsize(0);
}
void RKRGUI::cb_FSReset(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_FSReset_i(o,v);
}

void RKRGUI::cb_B_C_i(Fl_Button*, void*) {
  uchar r,g,b;

Fl::get_color(fore_color,r,g,b);
if (!fl_color_chooser("rakarrak buttons color:",r,g,b)) return;
fore_color=fl_rgb_color(r,g,b);
Buttons_Color_Change(fore_color);
}
void RKRGUI::cb_B_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_B_C_i(o,v);
}

void RKRGUI::cb_A_C_i(Fl_Button*, void*) {
  uchar r,g,b;
Fl::get_color(label_color,r,g,b);
if (!fl_color_chooser("rakarrack label color:",r,g,b)) return;
label_color=fl_rgb_color(r,g,b);
Label_Color_Change(label_color);
}
void RKRGUI::cb_A_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_A_C_i(o,v);
}

void RKRGUI::cb_L_C_i(Fl_Button*, void*) {
  uchar r,g,b;
Fl::get_color(leds_color,r,g,b);
if (!fl_color_chooser("rakarrack leds color:",r,g,b)) return;
leds_color=fl_rgb_color(r,g,b);
Leds_Color_Change(leds_color);
}
void RKRGUI::cb_L_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_L_C_i(o,v);
}

void RKRGUI::cb_K_C_i(Fl_Button*, void*) {
  uchar r,g,b;
Fl::get_color(back_color,r,g,b);
if (!fl_color_chooser("rakarrack back color:",r,g,b)) return;
back_color=fl_rgb_color(r,g,b);
Background_Color_Change(back_color);
}
void RKRGUI::cb_K_C(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_K_C_i(o,v);
}

void RKRGUI::cb_Enable_Back_i(Fl_Check_Button* o, void*) {
  rkr->EnableBackgroundImage=(int) o->value();
PutBackground();
}
void RKRGUI::cb_Enable_Back(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Enable_Back_i(o,v);
}

void RKRGUI::cb_BI_Browser_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Browse:","(*.png)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".png");
BackFiname->value(filename);
strcpy(rkr->BackgroundImage,filename);
PutBackground();
}
void RKRGUI::cb_BI_Browser(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_BI_Browser_i(o,v);
}

void RKRGUI::cb_Enable_DeacHide_i(Fl_Check_Button* o, void*) {
  rkr->deachide=(int) o->value();
}
void RKRGUI::cb_Enable_DeacHide(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Enable_DeacHide_i(o,v);
}

void RKRGUI::cb_INSTATE_i(Fl_Check_Button* o, void*) {
  rkr->init_state=(int) o->value();
}
void RKRGUI::cb_INSTATE(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_INSTATE_i(o,v);
}

void RKRGUI::cb_Filter_DC_i(Fl_Check_Button* o, void*) {
  rkr->DC_Offset=(int) o->value();
}
void RKRGUI::cb_Filter_DC(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Filter_DC_i(o,v);
}

void RKRGUI::cb_Pre_Serve_i(Fl_Check_Button* o, void*) {
  rkr->actuvol=(int) o->value();
}
void RKRGUI::cb_Pre_Serve(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Pre_Serve_i(o,v);
}

void RKRGUI::cb_Update_TAP_i(Fl_Check_Button* o, void*) {
  rkr->Tap_Updated = (int) o->value();
}
void RKRGUI::cb_Update_TAP(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Update_TAP_i(o,v);
}

void RKRGUI::cb_UPSAMPLE_C_i(Fl_Check_Button*, void*) {
  Show_Next_Time();
}
void RKRGUI::cb_UPSAMPLE_C(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_UPSAMPLE_C_i(o,v);
}

void RKRGUI::cb_Upr_Amo_i(Fl_Choice* o, void*) {
  rkr->UpAmo =(int) o->value();

Show_Next_Time();
}
void RKRGUI::cb_Upr_Amo(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Upr_Amo_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Upr_Amo[] = {
 {"x2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x3", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x5", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x6", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x7", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x9", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x10", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x11", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x12", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Upr_Qual_i(Fl_Choice* o, void*) {
  rkr->UpQual =(int) o->value();

Show_Next_Time();
}
void RKRGUI::cb_Upr_Qual(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Upr_Qual_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Upr_Qual[] = {
 {"Best", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Fastest", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Zero Order", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Linear", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Downr_Qual_i(Fl_Choice* o, void*) {
  rkr->DownQual =(int) o->value();

Show_Next_Time();
}
void RKRGUI::cb_Downr_Qual(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Downr_Qual_i(o,v);
}

void RKRGUI::cb_L_SIZE_i(Fl_Counter*, void*) {
  if(!rkr->m_displayed)
{
Show_Next_Time();
rkr->m_displayed=1;
};
}
void RKRGUI::cb_L_SIZE(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_L_SIZE_i(o,v);
}

void RKRGUI::cb_LM_Volume_i(Fl_Counter* o, void*) {
  rkr->Metro_Vol=(int)o->value();
rkr->efx_Looper->setmvol(rkr->Metro_Vol);
}
void RKRGUI::cb_LM_Volume(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_LM_Volume_i(o,v);
}

void RKRGUI::cb_Har_Qual_i(Fl_Choice* o, void*) {
  int i = (int) o->value();

switch(i)
{
     case 0:
       rkr->HarQual=4;
       break;
     case 1:
       rkr->HarQual=8;
       break;
     case 2:
       rkr->HarQual=16;	
	break;
     case 3:
       rkr->HarQual=32;	
	break;

		
}


Show_Next_Time();
}
void RKRGUI::cb_Har_Qual(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Har_Qual_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Har_Qual[] = {
 {"4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"16", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"32", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Ste_Qual_i(Fl_Choice* o, void*) {
  int i = (int) o->value();

switch(i)
{
     case 0:
       rkr->SteQual=4;
       break;
     case 1:
       rkr->SteQual=8;
       break;
     case 2:
       rkr->SteQual=16;	
	break;
     case 3:
       rkr->SteQual=32;	
	break;

		
}


Show_Next_Time();
}
void RKRGUI::cb_Ste_Qual(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Ste_Qual_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Ste_Qual[] = {
 {"4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"16", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"32", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Voc_Bands_i(Fl_Choice* o, void*) {
  switch((int)o->value())
{
  case 0:
  rkr->VocBands = 16;
  break;

  case 1:
  rkr->VocBands = 32;
  break;

  case 2:
  rkr->VocBands = 64;
  break;

  case 3:
  rkr->VocBands = 128;
  break;

  case 4:
  rkr->VocBands = 256;
  break;

}

Show_Next_Time();
}
void RKRGUI::cb_Voc_Bands(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Voc_Bands_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Voc_Bands[] = {
 {"16", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"32", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"64", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"128", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"256", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_FLPosition_i(Fl_Check_Button* o, void*) {
  rkr->flpos=(int)o->value();
}
void RKRGUI::cb_FLPosition(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_FLPosition_i(o,v);
}

void RKRGUI::cb_Calibration_i(Fl_Counter* o, void*) {
  aFreq=o->value();
rkr->update_freqs(aFreq);
}
void RKRGUI::cb_Calibration(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Calibration_i(o,v);
}

void RKRGUI::cb_RTrigger_i(Fl_Counter* o, void*) {
  rkr->rtrig = o->value();
rkr->RecNote->trigfact = o->value();
}
void RKRGUI::cb_RTrigger(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_RTrigger_i(o,v);
}

void RKRGUI::cb_RC_Opti_i(Fl_Choice* o, void*) {
  rkr->RCOpti =(int) o->value();

switch(rkr->RCOpti)
  {
  
  
    case 0:
    	rkr->RecNote->setlpf(5500);
    	rkr->RecNote->sethpf(80);
    	break;
    	

    case 1:
    	rkr->RecNote->setlpf(4500);
    	rkr->RecNote->sethpf(80);
    	break;
    	
    case 2:
    	rkr->RecNote->setlpf(3000);
    	rkr->RecNote->sethpf(300);
    	break;

};
}
void RKRGUI::cb_RC_Opti(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_RC_Opti_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_RC_Opti[] = {
 {"Normal", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Guitar", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"Voice", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Har_Downsample_i(Fl_Choice* o, void*) {
  rkr->Har_Down=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Har_Downsample(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Har_Downsample_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Har_Downsample[] = {
 {"Normal", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"96000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"48000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"44100", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"32000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"22050", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"16000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"12000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"8000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"4000", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Har_Down_Qua_i(Fl_Choice* o, void*) {
  rkr->Har_D_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Har_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Har_Down_Qua_i(o,v);
}

void RKRGUI::cb_Har_Up_Qua_i(Fl_Choice* o, void*) {
  rkr->Har_U_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Har_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Har_Up_Qua_i(o,v);
}

void RKRGUI::cb_Rev_Downsample_i(Fl_Choice* o, void*) {
  rkr->Rev_Down=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Rev_Downsample(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Rev_Downsample_i(o,v);
}

void RKRGUI::cb_Rev_Down_Qua_i(Fl_Choice* o, void*) {
  rkr->Rev_D_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Rev_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Rev_Down_Qua_i(o,v);
}

void RKRGUI::cb_Rev_Up_Qua_i(Fl_Choice* o, void*) {
  rkr->Rev_U_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Rev_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Rev_Up_Qua_i(o,v);
}

void RKRGUI::cb_Con_Downsample_i(Fl_Choice* o, void*) {
  rkr->Con_Down=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Con_Downsample(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Con_Downsample_i(o,v);
}

void RKRGUI::cb_Con_Down_Qua_i(Fl_Choice* o, void*) {
  rkr->Con_D_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Con_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Con_Down_Qua_i(o,v);
}

void RKRGUI::cb_Con_Up_Qua_i(Fl_Choice* o, void*) {
  rkr->Con_U_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Con_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Con_Up_Qua_i(o,v);
}

void RKRGUI::cb_Seq_Downsample_i(Fl_Choice* o, void*) {
  rkr->Seq_Down=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Seq_Downsample(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Seq_Downsample_i(o,v);
}

void RKRGUI::cb_Seq_Down_Qua_i(Fl_Choice* o, void*) {
  rkr->Seq_D_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Seq_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Seq_Down_Qua_i(o,v);
}

void RKRGUI::cb_Seq_Up_Qua_i(Fl_Choice* o, void*) {
  rkr->Seq_U_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Seq_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Seq_Up_Qua_i(o,v);
}

void RKRGUI::cb_Shi_Downsample_i(Fl_Choice* o, void*) {
  rkr->Shi_Down=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Shi_Downsample(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Shi_Downsample_i(o,v);
}

void RKRGUI::cb_Shi_Down_Qua_i(Fl_Choice* o, void*) {
  rkr->Shi_D_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Shi_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Shi_Down_Qua_i(o,v);
}

void RKRGUI::cb_Shi_Up_Qua_i(Fl_Choice* o, void*) {
  rkr->Shi_U_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Shi_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Shi_Up_Qua_i(o,v);
}

void RKRGUI::cb_Voc_Downsample_i(Fl_Choice* o, void*) {
  rkr->Voc_Down=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Voc_Downsample(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Voc_Downsample_i(o,v);
}

void RKRGUI::cb_Voc_Down_Qua_i(Fl_Choice* o, void*) {
  rkr->Voc_D_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Voc_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Voc_Down_Qua_i(o,v);
}

void RKRGUI::cb_Voc_Up_Qua_i(Fl_Choice* o, void*) {
  rkr->Voc_U_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Voc_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Voc_Up_Qua_i(o,v);
}

void RKRGUI::cb_Ste_Downsample_i(Fl_Choice* o, void*) {
  rkr->Ste_Down=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Ste_Downsample(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Ste_Downsample_i(o,v);
}

void RKRGUI::cb_Ste_Down_Qua_i(Fl_Choice* o, void*) {
  rkr->Ste_D_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Ste_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Ste_Down_Qua_i(o,v);
}

void RKRGUI::cb_Ste_Up_Qua_i(Fl_Choice* o, void*) {
  rkr->Ste_U_Q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Ste_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Ste_Up_Qua_i(o,v);
}

void RKRGUI::cb_Wave_Amo_i(Fl_Choice*, void*) {
  Show_Next_Time();
}
void RKRGUI::cb_Wave_Amo(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Wave_Amo_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_Wave_Amo[] = {
 {"Normal", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x2", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x4", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x8", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"x12", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_Wave_Down_Qua_i(Fl_Choice* o, void*) {
  Wave_down_q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Wave_Down_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Wave_Down_Qua_i(o,v);
}

void RKRGUI::cb_Wave_Up_Qua_i(Fl_Choice* o, void*) {
  Wave_up_q=(int)o->value();
Show_Next_Time();
}
void RKRGUI::cb_Wave_Up_Qua(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Wave_Up_Qua_i(o,v);
}

void RKRGUI::cb_D_A_Connect_i(Fl_Check_Button* o, void*) {
  rkr->aconnect_MI=(int) o->value();

if (rkr->aconnect_MI) BMidiIn->activate();
else BMidiIn->deactivate();
}
void RKRGUI::cb_D_A_Connect(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_D_A_Connect_i(o,v);
}

void RKRGUI::cb_BMidiIn_i(Fl_Browser* o, void*) {
  int valor;
valor = (int) o->value();
if(o->text(valor) != NULL)
strcpy(rkr->MID,o->text(valor));
else return;
o->select(valor,1);
rkr->Conecta();
}
void RKRGUI::cb_BMidiIn(Fl_Browser* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_BMidiIn_i(o,v);
}

void RKRGUI::cb_Midi_In_Counter_i(Fl_Counter* o, void*) {
  rkr->MidiCh=(int)o->value()-1;
}
void RKRGUI::cb_Midi_In_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Midi_In_Counter_i(o,v);
}

void RKRGUI::cb_Har_In_Counter_i(Fl_Counter* o, void*) {
  rkr->HarCh=(int)o->value()-1;
}
void RKRGUI::cb_Har_In_Counter(Fl_Counter* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Har_In_Counter_i(o,v);
}

void RKRGUI::cb_Mw0_i(Fl_Check_Button*, void*) {
  rkr->MIDIway=0;
ML_Menu->deactivate();
}
void RKRGUI::cb_Mw0(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Mw0_i(o,v);
}

void RKRGUI::cb_Mw1_i(Fl_Check_Button*, void*) {
  rkr->MIDIway=1;
ML_Menu->activate();
}
void RKRGUI::cb_Mw1(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Mw1_i(o,v);
}

void RKRGUI::cb_AAssign_i(Fl_Check_Button* o, void*) {
  rkr->autoassign=o->value();
}
void RKRGUI::cb_AAssign(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_AAssign_i(o,v);
}

void RKRGUI::cb_MTable_i(Fl_Check_Button* o, void*) {
  rkr->midi_table=o->value();
if(rkr->midi_table) scroll->activate(); else 
scroll->deactivate();
}
void RKRGUI::cb_MTable(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_MTable_i(o,v);
}

void RKRGUI::cb_D_J_Connect_i(Fl_Check_Button* o, void*) {
  rkr->aconnect_JA=(int) o->value();
if (rkr->aconnect_JA) JackCo->activate();
else JackCo->deactivate();
}
void RKRGUI::cb_D_J_Connect(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_D_J_Connect_i(o,v);
}

void RKRGUI::cb_D_IJ_Connect_i(Fl_Check_Button* o, void*) {
  rkr->aconnect_JIA=(int) o->value();
if (rkr->aconnect_JIA) JackIn->activate();
else JackIn->deactivate();
}
void RKRGUI::cb_D_IJ_Connect(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_D_IJ_Connect_i(o,v);
}

void RKRGUI::cb_Username_i(Fl_Input* o, void*) {
  rkr->UserRealName=(char*) o->value();
}
void RKRGUI::cb_Username(Fl_Input* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_Username_i(o,v);
}

void RKRGUI::cb_MES_DIS_i(Fl_Check_Button* o, void*) {
  rkr->mess_dis=(int) o->value();
}
void RKRGUI::cb_MES_DIS(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_MES_DIS_i(o,v);
}

void RKRGUI::cb_T_TIMEOUT_i(Fl_Check_Button* o, void*) {
  rkr->t_timeout=(int) o->value();
}
void RKRGUI::cb_T_TIMEOUT(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_T_TIMEOUT_i(o,v);
}

void RKRGUI::cb_ENA_TOOL_i(Fl_Check_Button* o, void*) {
  rkr->ena_tool=(int) o->value();
Fl_Tooltip::enable(rkr->ena_tool);
}
void RKRGUI::cb_ENA_TOOL(Fl_Check_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_ENA_TOOL_i(o,v);
}

void RKRGUI::cb_BF_Browser_i(Fl_Button*, void*) {
  char *filename;
filename=fl_file_chooser("Browse:","(*.rkrb)",NULL,0);
if (filename==NULL) return;
filename=fl_filename_setext(filename,".rkrb");
BFiname->value(filename);
strcpy(rkr->BankFilename,filename);
}
void RKRGUI::cb_BF_Browser(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_BF_Browser_i(o,v);
}

void RKRGUI::cb_UD_Browser_i(Fl_Button*, void*) {
  char *dir;
dir=fl_dir_chooser("Browse:",NULL,0);
if (dir==NULL) return;
Udir->value(dir);
strcpy(rkr->UDirFilename,dir);
ScanDir();
}
void RKRGUI::cb_UD_Browser(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->user_data()))->cb_UD_Browser_i(o,v);
}

void RKRGUI::cb_MIDILearn_i(Fl_Double_Window*, void*) {
  CancelRec->do_callback();
save_stat(5);
MIDILearn->hide();
}
void RKRGUI::cb_MIDILearn(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_MIDILearn_i(o,v);
}

void RKRGUI::cb_Epar_i(Fl_Browser*, void*) {
  DisAssigns();
}
void RKRGUI::cb_Epar(Fl_Browser* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Epar_i(o,v);
}

void RKRGUI::cb_GMM_i(Fl_Button*, void*) {
  rkr->ControlGet=0;
rkr->CountWait=0;
rkr->RControl=1;
}
void RKRGUI::cb_GMM(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_GMM_i(o,v);
}

void RKRGUI::cb_CopyF_i(Fl_Button*, void*) {
  memcpy(rkr->XUserMIDI,rkr->Bank[TPresets->value()].XUserMIDI,sizeof(rkr->XUserMIDI));

DisAssigns();
}
void RKRGUI::cb_CopyF(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_CopyF_i(o,v);
}

void RKRGUI::cb_CopyT_i(Fl_Button*, void*) {
  memcpy(rkr->Bank[TPresets->value()].XUserMIDI,rkr->XUserMIDI, sizeof(rkr->XUserMIDI));
}
void RKRGUI::cb_CopyT(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_CopyT_i(o,v);
}

void RKRGUI::cb_ClearA_i(Fl_Button*, void*) {
  int i, j,k;
int the_one;

if (rkr->ML_filter==0)
 the_one = rkr->efx_params[(int)Epar->value()-1].Ato;
 else
 the_one = rkr->ML_clist[(int)Epar->value()-1];


for(i=0; i<128; i++)
  {
    for(j=0;j<20;j++)
      {
         if (rkr->XUserMIDI[i][j] == the_one)
           {
             for(k=j+1;k<20;k++) rkr->XUserMIDI[i][k-1]=rkr->XUserMIDI[i][k];
             rkr->XUserMIDI[i][19]=0;             
           }
       
       }  
   }
   
DisAssigns();
}
void RKRGUI::cb_ClearA(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ClearA_i(o,v);
}

void RKRGUI::cb_ClearP_i(Fl_Button*, void*) {
  memset(rkr->XUserMIDI, 0, sizeof(rkr->XUserMIDI));
DisAssigns();
}
void RKRGUI::cb_ClearP(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_ClearP_i(o,v);
}

void RKRGUI::cb_Assign_i(Fl_Button*, void*) {
  int i;

int the_one;

if (rkr->ML_filter==0)
 the_one = rkr->efx_params[(int)Epar->value()-1].Ato;
 else
 the_one = rkr->ML_clist[(int)Epar->value()-1];


for(i=0;i<20;i++)

 {
    if(rkr->XUserMIDI[(int)Disp_Control->value()][i] == the_one) return;

    if(rkr->XUserMIDI[(int)Disp_Control->value()][i] ==0)
       {
         rkr->XUserMIDI[(int)Disp_Control->value()][i]=the_one;
         break;
        }
 }
 
 
DisAssigns();
}
void RKRGUI::cb_Assign(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Assign_i(o,v);
}

void RKRGUI::cb_AssignA_i(Fl_Button*, void*) {
  int i,j;
int the_one;

if (rkr->ML_filter==0)
 the_one = rkr->efx_params[(int)Epar->value()-1].Ato;
 else
 the_one = rkr->ML_clist[(int)Epar->value()-1];


for(j=1;j<61;j++)

{
for(i=0;i<20;i++)

 {
    if(rkr->Bank[j].XUserMIDI[(int)Disp_Control->value()][i] == the_one) break;

    if(rkr->Bank[j].XUserMIDI[(int)Disp_Control->value()][i] ==0)
       {
         rkr->Bank[j].XUserMIDI[(int)Disp_Control->value()][i]=the_one;
         break;
        }
 }
 
} 

Assign->do_callback();
}
void RKRGUI::cb_AssignA(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_AssignA_i(o,v);
}

void RKRGUI::cb_CancelRec_i(Fl_Button*, void*) {
  rkr->RControl = 0;
GMM->color(fore_color);
GMM->redraw();
}
void RKRGUI::cb_CancelRec(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_CancelRec_i(o,v);
}

void RKRGUI::cb_Disp_Control_i(Fl_Value_Input* o, void*) {
  if(o->value()> 127) o->value(127);
if(o->value()< 1) o->value(1);
}
void RKRGUI::cb_Disp_Control(Fl_Value_Input* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_Disp_Control_i(o,v);
}

void RKRGUI::cb_CopyTAll_i(Fl_Button*, void*) {
  int i;
for(i=1;i<61;i++) memcpy(rkr->Bank[i].XUserMIDI,rkr->XUserMIDI, sizeof(rkr->XUserMIDI));
}
void RKRGUI::cb_CopyTAll(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_CopyTAll_i(o,v);
}

void RKRGUI::cb_CloseML_i(Fl_Button*, void*) {
  MIDILearn->do_callback();
}
void RKRGUI::cb_CloseML(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_CloseML_i(o,v);
}

void RKRGUI::cb_M_fil_all_i(Fl_Button*, void*) {
  rkr->ML_filter=0;
FillML(0);
}
void RKRGUI::cb_M_fil_all(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_M_fil_all_i(o,v);
}

void RKRGUI::cb_M_fil_current_i(Fl_Button*, void*) {
  rkr->ML_filter=1;
FillML(0);
}
void RKRGUI::cb_M_fil_current(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->cb_M_fil_current_i(o,v);
}

void RKRGUI::cb_AboutWin_i(Fl_Double_Window*, void*) {
  AboutWin->hide();
}
void RKRGUI::cb_AboutWin(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_AboutWin_i(o,v);
}

void RKRGUI::cb_LICENSE_i(Fl_Button*, void*) {
  show_lic();
}
void RKRGUI::cb_LICENSE(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_LICENSE_i(o,v);
}

void RKRGUI::cb_OK_i(Fl_Button*, void*) {
  AboutWin->hide();
}
void RKRGUI::cb_OK(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_OK_i(o,v);
}

void RKRGUI::cb_Trigger_i(Fl_Double_Window*, void*) {
  rkr->ACI_Bypass=0;
Trigger->hide();
save_stat(6);
}
void RKRGUI::cb_Trigger(Fl_Double_Window* o, void* v) {
  ((RKRGUI*)(o->user_data()))->cb_Trigger_i(o,v);
}

void RKRGUI::cb_aux_source_i(Fl_Choice* o, void*) {
  rkr->Aux_Source = (int) o->value();
}
void RKRGUI::cb_aux_source(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_aux_source_i(o,v);
}

Fl_Menu_Item RKRGUI::menu_aux_source[] = {
 {"Aux", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"L", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {"R", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void RKRGUI::cb_aux_gain_i(SliderW* o, void*) {
  rkr->Aux_Gain = (int)o->value();
}
void RKRGUI::cb_aux_gain(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_aux_gain_i(o,v);
}

void RKRGUI::cb_aux_thres_i(SliderW* o, void*) {
  rkr->Aux_Threshold = (int) o->value();
}
void RKRGUI::cb_aux_thres(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_aux_thres_i(o,v);
}

void RKRGUI::cb_aux_midi_i(Fl_Value_Input* o, void*) {
  if(o->value()> 127) o->value(127);
if(o->value()< 1) o->value(1);
rkr->Aux_MIDI = (int)o->value();
}
void RKRGUI::cb_aux_midi(Fl_Value_Input* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_aux_midi_i(o,v);
}

void RKRGUI::cb_aux_min_i(SliderW* o, void*) {
  rkr->Aux_Minimum = (int) o->value();
}
void RKRGUI::cb_aux_min(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_aux_min_i(o,v);
}

void RKRGUI::cb_aux_max_i(SliderW* o, void*) {
  rkr->Aux_Maximum = (int) o->value();
}
void RKRGUI::cb_aux_max(SliderW* o, void* v) {
  ((RKRGUI*)(o->parent()->user_data()))->cb_aux_max_i(o,v);
}

Fl_Double_Window* RKRGUI::make_window() {
  { Principal = new Fl_Double_Window(800, 600);
    Principal->box(FL_DOWN_BOX);
    Principal->color(FL_FOREGROUND_COLOR);
    Principal->callback((Fl_Callback*)cb_Principal, (void*)(this));
    { fondo = new Fl_Box(1, 1, 800, 600);
      fondo->align(96|FL_ALIGN_INSIDE);
    } // Fl_Box* fondo
    { MenuP = new Fl_Menu_Bar(2, 2, 518, 18);
      MenuP->box(FL_NO_BOX);
      MenuP->color((Fl_Color)178);
      MenuP->selection_color(FL_BACKGROUND2_COLOR);
      MenuP->labelcolor(FL_BACKGROUND2_COLOR);
      MenuP->textcolor(7);
      MenuP->align(96|FL_ALIGN_INSIDE);
      MenuP->menu(menu_MenuP);
    } // Fl_Menu_Bar* MenuP
    { MT = new Fl_Box(579, 128, 20, 22);
      MT->labelsize(18);
      MT->callback((Fl_Callback*)cb_MT);
    } // Fl_Box* MT
    { TITTLE_L = new Fl_Button(521, 2, 276, 21);
      TITTLE_L->type(1);
      TITTLE_L->box(FL_NO_BOX);
      TITTLE_L->labeltype(FL_EMBOSSED_LABEL);
      TITTLE_L->labelfont(1);
      TITTLE_L->labelsize(40);
      TITTLE_L->callback((Fl_Callback*)cb_TITTLE_L);
      TITTLE_L->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
    } // Fl_Button* TITTLE_L
    { LMT_LED = new Fl_Box(504, 8, 8, 8, "Lmt");
      LMT_LED->box(FL_DOWN_BOX);
      LMT_LED->color((Fl_Color)2);
      LMT_LED->labelsize(10);
      LMT_LED->labelcolor(FL_BACKGROUND2_COLOR);
      LMT_LED->align(FL_ALIGN_LEFT);
    } // Fl_Box* LMT_LED
    { CLIP_LED = new Fl_Box(541, 8, 8, 8, "Clip");
      CLIP_LED->box(FL_DOWN_BOX);
      CLIP_LED->color((Fl_Color)1);
      CLIP_LED->labelsize(10);
      CLIP_LED->labelcolor(FL_BACKGROUND2_COLOR);
      CLIP_LED->align(FL_ALIGN_LEFT);
    } // Fl_Box* CLIP_LED
    { UPS_LED = new Fl_Box(608, 8, 8, 8, "Resample");
      UPS_LED->box(FL_DOWN_BOX);
      UPS_LED->color((Fl_Color)2);
      UPS_LED->labelsize(10);
      UPS_LED->labelcolor(FL_BACKGROUND2_COLOR);
      UPS_LED->align(FL_ALIGN_LEFT);
    } // Fl_Box* UPS_LED
    { P_MIN_ST = new Fl_Box(620, 3, 29, 20, "Midi In");
      P_MIN_ST->labelfont(1);
      P_MIN_ST->labelsize(8);
      P_MIN_ST->labelcolor(FL_BACKGROUND2_COLOR);
      P_MIN_ST->user_data((void*)(5));
      P_MIN_ST->align(FL_ALIGN_WRAP);
    } // Fl_Box* P_MIN_ST
    { P_MOUT_ST = new Fl_Box(648, 3, 29, 20, "Midi Out");
      P_MOUT_ST->labelfont(1);
      P_MOUT_ST->labelsize(8);
      P_MOUT_ST->labelcolor(FL_BACKGROUND2_COLOR);
      P_MOUT_ST->user_data((void*)(5));
      P_MOUT_ST->align(FL_ALIGN_WRAP);
      P_MOUT_ST->hide();
    } // Fl_Box* P_MOUT_ST
    { P_AUX_ST = new Fl_Box(676, 5, 32, 17, "Aux");
      P_AUX_ST->labelfont(1);
      P_AUX_ST->labelsize(10);
      P_AUX_ST->labelcolor(FL_BACKGROUND2_COLOR);
      P_AUX_ST->user_data((void*)(5));
      P_AUX_ST->hide();
    } // Fl_Box* P_AUX_ST
    { P_IN_ST = new Fl_Box(698, 5, 32, 17, "In");
      P_IN_ST->labelfont(1);
      P_IN_ST->labelsize(10);
      P_IN_ST->labelcolor(FL_BACKGROUND2_COLOR);
      P_IN_ST->user_data((void*)(5));
      P_IN_ST->hide();
    } // Fl_Box* P_IN_ST
    { P_OUT_ST = new Fl_Box(719, 5, 32, 17, "Out");
      P_OUT_ST->labelfont(1);
      P_OUT_ST->labelsize(10);
      P_OUT_ST->labelcolor(FL_BACKGROUND2_COLOR);
      P_OUT_ST->user_data((void*)(5));
      P_OUT_ST->hide();
    } // Fl_Box* P_OUT_ST
    { CPULOAD = new Fl_Box(750, 5, 45, 17);
      CPULOAD->labelsize(10);
      CPULOAD->labelcolor(FL_BACKGROUND2_COLOR);
      CPULOAD->user_data((void*)(5));
    } // Fl_Box* CPULOAD
    { Sco = new Scope(545, 19, 226, 65, "Rakarrack");
      Sco->box(FL_NO_BOX);
      Sco->color(FL_BACKGROUND_COLOR);
      Sco->selection_color(FL_BACKGROUND_COLOR);
      Sco->labeltype(FL_EMBOSSED_LABEL);
      Sco->labelfont(1);
      Sco->labelsize(40);
      Sco->labelcolor(FL_BACKGROUND2_COLOR);
      Sco->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
      Sco->when(FL_WHEN_RELEASE);
      Sco->hide();
    } // Scope* Sco
    { E1 = new Fl_Box(2, 212, 1, 1);
      E1->labelsize(18);
      E1->hide();
      E1->deactivate();
    } // Fl_Box* E1
    { E2 = new Fl_Box(162, 212, 1, 1);
      E2->labelsize(18);
      E2->hide();
      E2->deactivate();
    } // Fl_Box* E2
    { E3 = new Fl_Box(322, 212, 1, 1);
      E3->labelsize(18);
      E3->hide();
      E3->deactivate();
    } // Fl_Box* E3
    { E4 = new Fl_Box(482, 212, 1, 1);
      E4->labelsize(18);
      E4->hide();
      E4->deactivate();
    } // Fl_Box* E4
    { E5 = new Fl_Box(642, 212, 1, 1);
      E5->labelsize(18);
      E5->hide();
      E5->deactivate();
    } // Fl_Box* E5
    { E6 = new Fl_Box(2, 413, 1, 1);
      E6->labelsize(18);
      E6->hide();
      E6->deactivate();
    } // Fl_Box* E6
    { E7 = new Fl_Box(162, 413, 1, 1);
      E7->labelsize(18);
      E7->hide();
      E7->deactivate();
    } // Fl_Box* E7
    { E8 = new Fl_Box(322, 413, 1, 1);
      E8->labelsize(18);
      E8->hide();
      E8->deactivate();
    } // Fl_Box* E8
    { E9 = new Fl_Box(483, 413, 1, 1);
      E9->labelsize(18);
      E9->hide();
      E9->deactivate();
    } // Fl_Box* E9
    { E10 = new Fl_Box(642, 413, 1, 1);
      E10->labelsize(18);
      E10->hide();
      E10->deactivate();
    } // Fl_Box* E10
    { L1 = new Fl_Box(2, 195, 158, 17, "label");
      L1->labelfont(1);
      L1->labelcolor(FL_BACKGROUND2_COLOR);
      L1->user_data((void*)(770));
      L1->align(FL_ALIGN_CLIP);
    } // Fl_Box* L1
    { L2 = new Fl_Box(162, 195, 158, 17, "label");
      L2->labelfont(1);
      L2->labelcolor(FL_BACKGROUND2_COLOR);
      L2->user_data((void*)(771));
      L2->align(FL_ALIGN_CLIP);
    } // Fl_Box* L2
    { L3 = new Fl_Box(322, 195, 158, 17, "label");
      L3->labelfont(1);
      L3->labelcolor(FL_BACKGROUND2_COLOR);
      L3->user_data((void*)(772));
    } // Fl_Box* L3
    { L4 = new Fl_Box(482, 195, 158, 17, "label");
      L4->labelfont(1);
      L4->labelcolor(FL_BACKGROUND2_COLOR);
      L4->user_data((void*)(773));
    } // Fl_Box* L4
    { L5 = new Fl_Box(642, 195, 157, 17, "label");
      L5->labelfont(1);
      L5->labelcolor(FL_BACKGROUND2_COLOR);
      L5->user_data((void*)(774));
    } // Fl_Box* L5
    { L6 = new Fl_Box(1, 396, 158, 17, "label");
      L6->labelfont(1);
      L6->labelcolor(FL_BACKGROUND2_COLOR);
      L6->user_data((void*)(775));
    } // Fl_Box* L6
    { L7 = new Fl_Box(162, 396, 158, 17, "label");
      L7->labelfont(1);
      L7->labelcolor(FL_BACKGROUND2_COLOR);
      L7->user_data((void*)(776));
    } // Fl_Box* L7
    { L8 = new Fl_Box(322, 396, 158, 17, "label");
      L8->labelfont(1);
      L8->labelcolor(FL_BACKGROUND2_COLOR);
      L8->user_data((void*)(777));
    } // Fl_Box* L8
    { L9 = new Fl_Box(482, 396, 158, 17, "label");
      L9->labelfont(1);
      L9->labelcolor(FL_BACKGROUND2_COLOR);
      L9->user_data((void*)(778));
    } // Fl_Box* L9
    { L10 = new Fl_Box(642, 396, 154, 17, "label");
      L10->labelfont(1);
      L10->labelcolor(FL_BACKGROUND2_COLOR);
      L10->user_data((void*)(779));
    } // Fl_Box* L10
    { EQ = new Fl_Group(2, 212, 158, 184);
      EQ->box(FL_UP_BOX);
      EQ->color(FL_FOREGROUND_COLOR);
      EQ->selection_color(FL_FOREGROUND_COLOR);
      EQ->labelfont(1);
      EQ->user_data((void*)(1));
      EQ->align(96|FL_ALIGN_INSIDE);
      { eq_activar = new Fl_Light_Button(7, 216, 34, 18, "On");
        eq_activar->shortcut(0x31);
        eq_activar->color((Fl_Color)62);
        eq_activar->selection_color((Fl_Color)1);
        eq_activar->labelsize(10);
        eq_activar->callback((Fl_Callback*)cb_eq_activar, (void*)(2));
        eq_activar->align(68|FL_ALIGN_INSIDE);
        eq_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* eq_activar
      { eq_preset = new Fl_Choice(79, 216, 76, 18, "Preset");
        eq_preset->down_box(FL_BORDER_BOX);
        eq_preset->selection_color(FL_FOREGROUND_COLOR);
        eq_preset->labelsize(10);
        eq_preset->labelcolor(FL_BACKGROUND2_COLOR);
        eq_preset->textsize(10);
        eq_preset->textcolor(7);
        eq_preset->callback((Fl_Callback*)cb_eq_preset, (void*)(12000));
        eq_preset->when(FL_WHEN_RELEASE_ALWAYS);
        eq_preset->menu(menu_eq_preset);
      } // Fl_Choice* eq_preset
      { eq_Gain = new SliderW(51, 238, 100, 10, "Gain");
        eq_Gain->type(5);
        eq_Gain->box(FL_FLAT_BOX);
        eq_Gain->color((Fl_Color)178);
        eq_Gain->selection_color((Fl_Color)62);
        eq_Gain->labeltype(FL_NORMAL_LABEL);
        eq_Gain->labelfont(0);
        eq_Gain->labelsize(10);
        eq_Gain->labelcolor(FL_BACKGROUND2_COLOR);
        eq_Gain->minimum(-64);
        eq_Gain->maximum(63);
        eq_Gain->step(1);
        eq_Gain->textcolor(7);
        eq_Gain->callback((Fl_Callback*)cb_eq_Gain);
        eq_Gain->align(FL_ALIGN_LEFT);
        eq_Gain->when(FL_WHEN_CHANGED);
      } // SliderW* eq_Gain
      { eq_Q = new SliderW(51, 251, 100, 10, "Q");
        eq_Q->type(5);
        eq_Q->box(FL_FLAT_BOX);
        eq_Q->color((Fl_Color)178);
        eq_Q->selection_color((Fl_Color)62);
        eq_Q->labeltype(FL_NORMAL_LABEL);
        eq_Q->labelfont(0);
        eq_Q->labelsize(10);
        eq_Q->labelcolor(FL_BACKGROUND2_COLOR);
        eq_Q->minimum(-64);
        eq_Q->maximum(63);
        eq_Q->step(1);
        eq_Q->textcolor(7);
        eq_Q->callback((Fl_Callback*)cb_eq_Q);
        eq_Q->align(FL_ALIGN_LEFT);
        eq_Q->when(FL_WHEN_CHANGED);
      } // SliderW* eq_Q
      { eq_1 = new SliderW(51, 270, 100, 10, "31 Hz");
        eq_1->type(5);
        eq_1->box(FL_FLAT_BOX);
        eq_1->color((Fl_Color)178);
        eq_1->selection_color((Fl_Color)62);
        eq_1->labeltype(FL_NORMAL_LABEL);
        eq_1->labelfont(0);
        eq_1->labelsize(10);
        eq_1->labelcolor(FL_BACKGROUND2_COLOR);
        eq_1->minimum(-64);
        eq_1->maximum(63);
        eq_1->step(1);
        eq_1->textcolor(7);
        eq_1->callback((Fl_Callback*)cb_eq_1);
        eq_1->align(FL_ALIGN_LEFT);
        eq_1->when(FL_WHEN_CHANGED);
      } // SliderW* eq_1
      { eq_2 = new SliderW(51, 282, 100, 10, "63 Hz");
        eq_2->type(5);
        eq_2->box(FL_FLAT_BOX);
        eq_2->color((Fl_Color)178);
        eq_2->selection_color((Fl_Color)62);
        eq_2->labeltype(FL_NORMAL_LABEL);
        eq_2->labelfont(0);
        eq_2->labelsize(10);
        eq_2->labelcolor(FL_BACKGROUND2_COLOR);
        eq_2->minimum(-64);
        eq_2->maximum(63);
        eq_2->step(1);
        eq_2->textcolor(7);
        eq_2->callback((Fl_Callback*)cb_eq_2);
        eq_2->align(FL_ALIGN_LEFT);
        eq_2->when(FL_WHEN_CHANGED);
      } // SliderW* eq_2
      { eq_3 = new SliderW(51, 294, 100, 10, "125 Hz");
        eq_3->type(5);
        eq_3->box(FL_FLAT_BOX);
        eq_3->color((Fl_Color)178);
        eq_3->selection_color((Fl_Color)62);
        eq_3->labeltype(FL_NORMAL_LABEL);
        eq_3->labelfont(0);
        eq_3->labelsize(10);
        eq_3->labelcolor(FL_BACKGROUND2_COLOR);
        eq_3->minimum(-64);
        eq_3->maximum(63);
        eq_3->step(1);
        eq_3->textcolor(7);
        eq_3->callback((Fl_Callback*)cb_eq_3);
        eq_3->align(FL_ALIGN_LEFT);
        eq_3->when(FL_WHEN_CHANGED);
      } // SliderW* eq_3
      { eq_4 = new SliderW(51, 307, 100, 10, "250 Hz");
        eq_4->type(5);
        eq_4->box(FL_FLAT_BOX);
        eq_4->color((Fl_Color)178);
        eq_4->selection_color((Fl_Color)62);
        eq_4->labeltype(FL_NORMAL_LABEL);
        eq_4->labelfont(0);
        eq_4->labelsize(10);
        eq_4->labelcolor(FL_BACKGROUND2_COLOR);
        eq_4->minimum(-64);
        eq_4->maximum(63);
        eq_4->step(1);
        eq_4->textcolor(7);
        eq_4->callback((Fl_Callback*)cb_eq_4);
        eq_4->align(FL_ALIGN_LEFT);
        eq_4->when(FL_WHEN_CHANGED);
      } // SliderW* eq_4
      { eq_5 = new SliderW(51, 319, 100, 10, "500 Hz");
        eq_5->type(5);
        eq_5->box(FL_FLAT_BOX);
        eq_5->color((Fl_Color)178);
        eq_5->selection_color((Fl_Color)62);
        eq_5->labeltype(FL_NORMAL_LABEL);
        eq_5->labelfont(0);
        eq_5->labelsize(10);
        eq_5->labelcolor(FL_BACKGROUND2_COLOR);
        eq_5->minimum(-64);
        eq_5->maximum(63);
        eq_5->step(1);
        eq_5->textcolor(7);
        eq_5->callback((Fl_Callback*)cb_eq_5);
        eq_5->align(FL_ALIGN_LEFT);
        eq_5->when(FL_WHEN_CHANGED);
      } // SliderW* eq_5
      { eq_6 = new SliderW(51, 331, 100, 10, "1 Khz");
        eq_6->type(5);
        eq_6->box(FL_FLAT_BOX);
        eq_6->color((Fl_Color)178);
        eq_6->selection_color((Fl_Color)62);
        eq_6->labeltype(FL_NORMAL_LABEL);
        eq_6->labelfont(0);
        eq_6->labelsize(10);
        eq_6->labelcolor(FL_BACKGROUND2_COLOR);
        eq_6->minimum(-64);
        eq_6->maximum(63);
        eq_6->step(1);
        eq_6->textcolor(7);
        eq_6->callback((Fl_Callback*)cb_eq_6);
        eq_6->align(FL_ALIGN_LEFT);
        eq_6->when(FL_WHEN_CHANGED);
      } // SliderW* eq_6
      { eq_7 = new SliderW(51, 344, 100, 10, "2 Khz");
        eq_7->type(5);
        eq_7->box(FL_FLAT_BOX);
        eq_7->color((Fl_Color)178);
        eq_7->selection_color((Fl_Color)62);
        eq_7->labeltype(FL_NORMAL_LABEL);
        eq_7->labelfont(0);
        eq_7->labelsize(10);
        eq_7->labelcolor(FL_BACKGROUND2_COLOR);
        eq_7->minimum(-64);
        eq_7->maximum(63);
        eq_7->step(1);
        eq_7->textcolor(7);
        eq_7->callback((Fl_Callback*)cb_eq_7);
        eq_7->align(FL_ALIGN_LEFT);
        eq_7->when(FL_WHEN_CHANGED);
      } // SliderW* eq_7
      { eq_8 = new SliderW(51, 356, 100, 10, "4 Khz");
        eq_8->type(5);
        eq_8->box(FL_FLAT_BOX);
        eq_8->color((Fl_Color)178);
        eq_8->selection_color((Fl_Color)62);
        eq_8->labeltype(FL_NORMAL_LABEL);
        eq_8->labelfont(0);
        eq_8->labelsize(10);
        eq_8->labelcolor(FL_BACKGROUND2_COLOR);
        eq_8->minimum(-64);
        eq_8->maximum(63);
        eq_8->step(1);
        eq_8->textcolor(7);
        eq_8->callback((Fl_Callback*)cb_eq_8);
        eq_8->align(FL_ALIGN_LEFT);
        eq_8->when(FL_WHEN_CHANGED);
      } // SliderW* eq_8
      { eq_9 = new SliderW(51, 368, 100, 10, "8 Khz");
        eq_9->type(5);
        eq_9->box(FL_FLAT_BOX);
        eq_9->color((Fl_Color)178);
        eq_9->selection_color((Fl_Color)62);
        eq_9->labeltype(FL_NORMAL_LABEL);
        eq_9->labelfont(0);
        eq_9->labelsize(10);
        eq_9->labelcolor(FL_BACKGROUND2_COLOR);
        eq_9->minimum(-64);
        eq_9->maximum(63);
        eq_9->step(1);
        eq_9->textcolor(7);
        eq_9->callback((Fl_Callback*)cb_eq_9);
        eq_9->align(FL_ALIGN_LEFT);
        eq_9->when(FL_WHEN_CHANGED);
      } // SliderW* eq_9
      { eq_10 = new SliderW(51, 381, 100, 10, "16 Khz");
        eq_10->type(5);
        eq_10->box(FL_FLAT_BOX);
        eq_10->color((Fl_Color)178);
        eq_10->selection_color((Fl_Color)62);
        eq_10->labeltype(FL_NORMAL_LABEL);
        eq_10->labelfont(0);
        eq_10->labelsize(10);
        eq_10->labelcolor(FL_BACKGROUND2_COLOR);
        eq_10->minimum(-64);
        eq_10->maximum(63);
        eq_10->step(1);
        eq_10->textcolor(7);
        eq_10->callback((Fl_Callback*)cb_eq_10);
        eq_10->align(FL_ALIGN_LEFT);
        eq_10->when(FL_WHEN_CHANGED);
      } // SliderW* eq_10
      EQ->end();
    } // Fl_Group* EQ
    { COMPRESS = new Fl_Group(161, 212, 158, 184);
      COMPRESS->box(FL_UP_BOX);
      COMPRESS->color(FL_FOREGROUND_COLOR);
      COMPRESS->selection_color(FL_FOREGROUND_COLOR);
      COMPRESS->labelfont(1);
      COMPRESS->user_data((void*)(1));
      COMPRESS->align(96|FL_ALIGN_INSIDE);
      { compress_activar = new Fl_Light_Button(166, 216, 34, 18, "On");
        compress_activar->shortcut(0x32);
        compress_activar->color((Fl_Color)62);
        compress_activar->selection_color((Fl_Color)1);
        compress_activar->labelsize(10);
        compress_activar->callback((Fl_Callback*)cb_compress_activar, (void*)(2));
        compress_activar->align(68|FL_ALIGN_INSIDE);
        compress_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* compress_activar
      { compress_preset = new Fl_Choice(238, 216, 76, 18, "Preset");
        compress_preset->down_box(FL_BORDER_BOX);
        compress_preset->selection_color(FL_FOREGROUND_COLOR);
        compress_preset->labelsize(10);
        compress_preset->labelcolor(FL_BACKGROUND2_COLOR);
        compress_preset->textsize(10);
        compress_preset->textcolor(7);
        compress_preset->callback((Fl_Callback*)cb_compress_preset, (void*)(12001));
        compress_preset->when(FL_WHEN_RELEASE_ALWAYS);
        compress_preset->menu(menu_compress_preset);
      } // Fl_Choice* compress_preset
      { compress_ATime = new SliderW(212, 251, 100, 10, "A. Time");
        compress_ATime->type(5);
        compress_ATime->box(FL_FLAT_BOX);
        compress_ATime->color((Fl_Color)178);
        compress_ATime->selection_color((Fl_Color)62);
        compress_ATime->labeltype(FL_NORMAL_LABEL);
        compress_ATime->labelfont(0);
        compress_ATime->labelsize(10);
        compress_ATime->labelcolor(FL_BACKGROUND2_COLOR);
        compress_ATime->minimum(10);
        compress_ATime->maximum(250);
        compress_ATime->step(1);
        compress_ATime->value(2);
        compress_ATime->textcolor(7);
        compress_ATime->callback((Fl_Callback*)cb_compress_ATime);
        compress_ATime->align(FL_ALIGN_LEFT);
        compress_ATime->when(FL_WHEN_CHANGED);
      } // SliderW* compress_ATime
      { compress_RTime = new SliderW(211, 271, 100, 10, "R. Time");
        compress_RTime->type(5);
        compress_RTime->box(FL_FLAT_BOX);
        compress_RTime->color((Fl_Color)178);
        compress_RTime->selection_color((Fl_Color)62);
        compress_RTime->labeltype(FL_NORMAL_LABEL);
        compress_RTime->labelfont(0);
        compress_RTime->labelsize(10);
        compress_RTime->labelcolor(FL_BACKGROUND2_COLOR);
        compress_RTime->minimum(10);
        compress_RTime->maximum(500);
        compress_RTime->step(1);
        compress_RTime->value(120);
        compress_RTime->textcolor(7);
        compress_RTime->callback((Fl_Callback*)cb_compress_RTime);
        compress_RTime->align(FL_ALIGN_LEFT);
        compress_RTime->when(FL_WHEN_CHANGED);
      } // SliderW* compress_RTime
      { compress_Ratio = new SliderW(211, 291, 100, 10, "Ratio");
        compress_Ratio->type(5);
        compress_Ratio->box(FL_FLAT_BOX);
        compress_Ratio->color((Fl_Color)178);
        compress_Ratio->selection_color((Fl_Color)62);
        compress_Ratio->labeltype(FL_NORMAL_LABEL);
        compress_Ratio->labelfont(0);
        compress_Ratio->labelsize(10);
        compress_Ratio->labelcolor(FL_BACKGROUND2_COLOR);
        compress_Ratio->minimum(2);
        compress_Ratio->maximum(42);
        compress_Ratio->step(1);
        compress_Ratio->value(2);
        compress_Ratio->textcolor(7);
        compress_Ratio->callback((Fl_Callback*)cb_compress_Ratio);
        compress_Ratio->align(FL_ALIGN_LEFT);
        compress_Ratio->when(FL_WHEN_CHANGED);
      } // SliderW* compress_Ratio
      { compress_Knee = new SliderW(210, 311, 100, 10, "Knee");
        compress_Knee->type(5);
        compress_Knee->box(FL_FLAT_BOX);
        compress_Knee->color((Fl_Color)178);
        compress_Knee->selection_color((Fl_Color)62);
        compress_Knee->labeltype(FL_NORMAL_LABEL);
        compress_Knee->labelfont(0);
        compress_Knee->labelsize(10);
        compress_Knee->labelcolor(FL_BACKGROUND2_COLOR);
        compress_Knee->maximum(100);
        compress_Knee->step(1);
        compress_Knee->value(3);
        compress_Knee->textcolor(7);
        compress_Knee->callback((Fl_Callback*)cb_compress_Knee);
        compress_Knee->align(FL_ALIGN_LEFT);
        compress_Knee->when(FL_WHEN_CHANGED);
      } // SliderW* compress_Knee
      { compress_threshold = new SliderW(211, 331, 100, 10, "Thrhold");
        compress_threshold->type(5);
        compress_threshold->box(FL_FLAT_BOX);
        compress_threshold->color((Fl_Color)178);
        compress_threshold->selection_color((Fl_Color)62);
        compress_threshold->labeltype(FL_NORMAL_LABEL);
        compress_threshold->labelfont(0);
        compress_threshold->labelsize(10);
        compress_threshold->labelcolor(FL_BACKGROUND2_COLOR);
        compress_threshold->minimum(-60);
        compress_threshold->maximum(-3);
        compress_threshold->step(1);
        compress_threshold->value(-3);
        compress_threshold->textcolor(7);
        compress_threshold->callback((Fl_Callback*)cb_compress_threshold);
        compress_threshold->align(FL_ALIGN_LEFT);
        compress_threshold->when(FL_WHEN_CHANGED);
      } // SliderW* compress_threshold
      { compress_output = new SliderW(211, 351, 100, 10, "Output");
        compress_output->type(5);
        compress_output->box(FL_FLAT_BOX);
        compress_output->color((Fl_Color)178);
        compress_output->selection_color((Fl_Color)62);
        compress_output->labeltype(FL_NORMAL_LABEL);
        compress_output->labelfont(0);
        compress_output->labelsize(10);
        compress_output->labelcolor(FL_BACKGROUND2_COLOR);
        compress_output->minimum(-40);
        compress_output->maximum(0);
        compress_output->step(1);
        compress_output->textcolor(7);
        compress_output->callback((Fl_Callback*)cb_compress_output);
        compress_output->align(FL_ALIGN_LEFT);
        compress_output->when(FL_WHEN_CHANGED);
      } // SliderW* compress_output
      { Auto_Output = new Fl_Check_Button(180, 378, 15, 15, "Auto Output");
        Auto_Output->down_box(FL_BORDER_BOX);
        Auto_Output->labelsize(10);
        Auto_Output->labelcolor(FL_BACKGROUND2_COLOR);
        Auto_Output->callback((Fl_Callback*)cb_Auto_Output, (void*)(2));
      } // Fl_Check_Button* Auto_Output
      { Stereo = new Fl_Check_Button(265, 378, 15, 15, "Stereo");
        Stereo->tooltip("Level detect Left and Right separately.  Unchecked compresses according to L/\
R average.");
        Stereo->down_box(FL_BORDER_BOX);
        Stereo->labelsize(10);
        Stereo->labelcolor(FL_BACKGROUND2_COLOR);
        Stereo->callback((Fl_Callback*)cb_Stereo, (void*)(2));
      } // Fl_Check_Button* Stereo
      { Peak = new Fl_Check_Button(180, 365, 15, 15, "Peak");
        Peak->tooltip("Peak Mode Compression");
        Peak->down_box(FL_BORDER_BOX);
        Peak->labelsize(10);
        Peak->labelcolor(FL_BACKGROUND2_COLOR);
        Peak->callback((Fl_Callback*)cb_Peak, (void*)(2));
      } // Fl_Check_Button* Peak
      COMPRESS->end();
    } // Fl_Group* COMPRESS
    { DIST = new Fl_Group(321, 212, 158, 184);
      DIST->box(FL_UP_BOX);
      DIST->color(FL_FOREGROUND_COLOR);
      DIST->selection_color(FL_FOREGROUND_COLOR);
      DIST->labelfont(1);
      DIST->user_data((void*)(1));
      DIST->align(96|FL_ALIGN_INSIDE);
      { dist_activar = new Fl_Light_Button(326, 216, 34, 18, "On");
        dist_activar->shortcut(0x33);
        dist_activar->color((Fl_Color)62);
        dist_activar->selection_color((Fl_Color)1);
        dist_activar->labelsize(10);
        dist_activar->callback((Fl_Callback*)cb_dist_activar, (void*)(2));
        dist_activar->align(68|FL_ALIGN_INSIDE);
        dist_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* dist_activar
      { dist_preset = new Fl_Choice(398, 216, 76, 18, "Preset");
        dist_preset->down_box(FL_BORDER_BOX);
        dist_preset->selection_color(FL_FOREGROUND_COLOR);
        dist_preset->labelsize(10);
        dist_preset->labelcolor(FL_BACKGROUND2_COLOR);
        dist_preset->textsize(10);
        dist_preset->textcolor(7);
        dist_preset->callback((Fl_Callback*)cb_dist_preset, (void*)(12002));
        dist_preset->when(FL_WHEN_RELEASE_ALWAYS);
        dist_preset->menu(menu_dist_preset);
      } // Fl_Choice* dist_preset
      { dist_WD = new SliderW(373, 247, 100, 10, "Wet/Dry");
        dist_WD->type(5);
        dist_WD->box(FL_FLAT_BOX);
        dist_WD->color((Fl_Color)178);
        dist_WD->selection_color((Fl_Color)62);
        dist_WD->labeltype(FL_NORMAL_LABEL);
        dist_WD->labelfont(0);
        dist_WD->labelsize(10);
        dist_WD->labelcolor(FL_BACKGROUND2_COLOR);
        dist_WD->minimum(-64);
        dist_WD->maximum(63);
        dist_WD->step(1);
        dist_WD->textcolor(7);
        dist_WD->callback((Fl_Callback*)cb_dist_WD);
        dist_WD->align(FL_ALIGN_LEFT);
        dist_WD->when(FL_WHEN_CHANGED);
      } // SliderW* dist_WD
      { dist_LRc = new SliderW(373, 260, 100, 10, "L/R.Cr");
        dist_LRc->type(5);
        dist_LRc->box(FL_FLAT_BOX);
        dist_LRc->color((Fl_Color)178);
        dist_LRc->selection_color((Fl_Color)62);
        dist_LRc->labeltype(FL_NORMAL_LABEL);
        dist_LRc->labelfont(0);
        dist_LRc->labelsize(10);
        dist_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        dist_LRc->minimum(-64);
        dist_LRc->maximum(63);
        dist_LRc->step(1);
        dist_LRc->textcolor(7);
        dist_LRc->callback((Fl_Callback*)cb_dist_LRc);
        dist_LRc->align(FL_ALIGN_LEFT);
        dist_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* dist_LRc
      { dist_drive = new SliderW(373, 273, 100, 10, "Drive");
        dist_drive->type(5);
        dist_drive->box(FL_FLAT_BOX);
        dist_drive->color((Fl_Color)178);
        dist_drive->selection_color((Fl_Color)62);
        dist_drive->labeltype(FL_NORMAL_LABEL);
        dist_drive->labelfont(0);
        dist_drive->labelsize(10);
        dist_drive->labelcolor(FL_BACKGROUND2_COLOR);
        dist_drive->maximum(127);
        dist_drive->step(1);
        dist_drive->textcolor(7);
        dist_drive->callback((Fl_Callback*)cb_dist_drive);
        dist_drive->align(FL_ALIGN_LEFT);
        dist_drive->when(FL_WHEN_CHANGED);
      } // SliderW* dist_drive
      { dist_level = new SliderW(373, 287, 100, 10, "Level");
        dist_level->type(5);
        dist_level->box(FL_FLAT_BOX);
        dist_level->color((Fl_Color)178);
        dist_level->selection_color((Fl_Color)62);
        dist_level->labeltype(FL_NORMAL_LABEL);
        dist_level->labelfont(0);
        dist_level->labelsize(10);
        dist_level->labelcolor(FL_BACKGROUND2_COLOR);
        dist_level->maximum(127);
        dist_level->step(1);
        dist_level->textcolor(7);
        dist_level->callback((Fl_Callback*)cb_dist_level);
        dist_level->align(FL_ALIGN_LEFT);
        dist_level->when(FL_WHEN_CHANGED);
      } // SliderW* dist_level
      { dist_tipo = new Fl_Choice(355, 303, 70, 16, "Type");
        dist_tipo->down_box(FL_BORDER_BOX);
        dist_tipo->selection_color(FL_FOREGROUND_COLOR);
        dist_tipo->labelsize(10);
        dist_tipo->labelcolor(FL_BACKGROUND2_COLOR);
        dist_tipo->textsize(10);
        dist_tipo->textcolor(7);
        dist_tipo->callback((Fl_Callback*)cb_dist_tipo, (void*)(12));
        dist_tipo->menu(menu_dist_tipo);
      } // Fl_Choice* dist_tipo
      { dist_neg = new Fl_Check_Button(431, 304, 15, 15, "Neg.");
        dist_neg->down_box(FL_BORDER_BOX);
        dist_neg->labelsize(10);
        dist_neg->labelcolor(FL_BACKGROUND2_COLOR);
        dist_neg->callback((Fl_Callback*)cb_dist_neg, (void*)(2));
      } // Fl_Check_Button* dist_neg
      { dist_pf = new Fl_Check_Button(330, 320, 15, 15, "Pre Filter");
        dist_pf->down_box(FL_BORDER_BOX);
        dist_pf->labelsize(10);
        dist_pf->labelcolor(FL_BACKGROUND2_COLOR);
        dist_pf->callback((Fl_Callback*)cb_dist_pf, (void*)(2));
      } // Fl_Check_Button* dist_pf
      { dist_st = new Fl_Check_Button(395, 320, 15, 15, "Stereo");
        dist_st->down_box(FL_BORDER_BOX);
        dist_st->labelsize(10);
        dist_st->labelcolor(FL_BACKGROUND2_COLOR);
        dist_st->callback((Fl_Callback*)cb_dist_st, (void*)(2));
      } // Fl_Check_Button* dist_st
      { dist_pan = new SliderW(373, 337, 100, 10, "Pan");
        dist_pan->type(5);
        dist_pan->box(FL_FLAT_BOX);
        dist_pan->color((Fl_Color)178);
        dist_pan->selection_color((Fl_Color)62);
        dist_pan->labeltype(FL_NORMAL_LABEL);
        dist_pan->labelfont(0);
        dist_pan->labelsize(10);
        dist_pan->labelcolor(FL_BACKGROUND2_COLOR);
        dist_pan->minimum(-64);
        dist_pan->maximum(63);
        dist_pan->step(1);
        dist_pan->textcolor(7);
        dist_pan->callback((Fl_Callback*)cb_dist_pan);
        dist_pan->align(FL_ALIGN_LEFT);
        dist_pan->when(FL_WHEN_CHANGED);
      } // SliderW* dist_pan
      { dist_oct = new SliderW(373, 357, 100, 10, "Sub Octv");
        dist_oct->type(5);
        dist_oct->box(FL_FLAT_BOX);
        dist_oct->color((Fl_Color)178);
        dist_oct->selection_color((Fl_Color)62);
        dist_oct->labeltype(FL_NORMAL_LABEL);
        dist_oct->labelfont(0);
        dist_oct->labelsize(10);
        dist_oct->labelcolor(FL_BACKGROUND2_COLOR);
        dist_oct->maximum(127);
        dist_oct->step(1);
        dist_oct->textcolor(7);
        dist_oct->callback((Fl_Callback*)cb_dist_oct);
        dist_oct->align(FL_ALIGN_LEFT);
        dist_oct->when(FL_WHEN_CHANGED);
      } // SliderW* dist_oct
      { dist_lpf = new SliderW(373, 369, 100, 10, "LPF");
        dist_lpf->type(5);
        dist_lpf->box(FL_FLAT_BOX);
        dist_lpf->color((Fl_Color)178);
        dist_lpf->selection_color((Fl_Color)62);
        dist_lpf->labeltype(FL_NORMAL_LABEL);
        dist_lpf->labelfont(0);
        dist_lpf->labelsize(10);
        dist_lpf->labelcolor(FL_BACKGROUND2_COLOR);
        dist_lpf->minimum(20);
        dist_lpf->maximum(26000);
        dist_lpf->step(1);
        dist_lpf->value(20000);
        dist_lpf->textcolor(7);
        dist_lpf->callback((Fl_Callback*)cb_dist_lpf);
        dist_lpf->align(FL_ALIGN_LEFT);
        dist_lpf->when(FL_WHEN_CHANGED);
      } // SliderW* dist_lpf
      { dist_hpf = new SliderW(373, 381, 100, 10, "HPF");
        dist_hpf->type(5);
        dist_hpf->box(FL_FLAT_BOX);
        dist_hpf->color((Fl_Color)178);
        dist_hpf->selection_color((Fl_Color)62);
        dist_hpf->labeltype(FL_NORMAL_LABEL);
        dist_hpf->labelfont(0);
        dist_hpf->labelsize(10);
        dist_hpf->labelcolor(FL_BACKGROUND2_COLOR);
        dist_hpf->minimum(20);
        dist_hpf->maximum(20000);
        dist_hpf->step(1);
        dist_hpf->value(20);
        dist_hpf->textcolor(7);
        dist_hpf->callback((Fl_Callback*)cb_dist_hpf);
        dist_hpf->align(FL_ALIGN_LEFT);
        dist_hpf->when(FL_WHEN_CHANGED);
      } // SliderW* dist_hpf
      DIST->end();
    } // Fl_Group* DIST
    { OVRD = new Fl_Group(480, 212, 158, 184);
      OVRD->box(FL_UP_BOX);
      OVRD->color(FL_FOREGROUND_COLOR);
      OVRD->selection_color(FL_FOREGROUND_COLOR);
      OVRD->labelfont(1);
      OVRD->user_data((void*)(1));
      OVRD->align(96|FL_ALIGN_INSIDE);
      { ovrd_activar = new Fl_Light_Button(485, 216, 34, 18, "On");
        ovrd_activar->shortcut(0x34);
        ovrd_activar->color((Fl_Color)62);
        ovrd_activar->selection_color((Fl_Color)1);
        ovrd_activar->labelsize(10);
        ovrd_activar->callback((Fl_Callback*)cb_ovrd_activar, (void*)(2));
        ovrd_activar->align(68|FL_ALIGN_INSIDE);
        ovrd_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* ovrd_activar
      { ovrd_preset = new Fl_Choice(557, 216, 76, 18, "Preset");
        ovrd_preset->down_box(FL_BORDER_BOX);
        ovrd_preset->selection_color(FL_FOREGROUND_COLOR);
        ovrd_preset->labelsize(10);
        ovrd_preset->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_preset->textsize(10);
        ovrd_preset->textcolor(7);
        ovrd_preset->callback((Fl_Callback*)cb_ovrd_preset, (void*)(12003));
        ovrd_preset->when(FL_WHEN_RELEASE_ALWAYS);
        ovrd_preset->menu(menu_ovrd_preset);
      } // Fl_Choice* ovrd_preset
      { ovrd_WD = new SliderW(531, 247, 100, 10, "Wet/Dry");
        ovrd_WD->type(5);
        ovrd_WD->box(FL_FLAT_BOX);
        ovrd_WD->color((Fl_Color)178);
        ovrd_WD->selection_color((Fl_Color)62);
        ovrd_WD->labeltype(FL_NORMAL_LABEL);
        ovrd_WD->labelfont(0);
        ovrd_WD->labelsize(10);
        ovrd_WD->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_WD->minimum(-64);
        ovrd_WD->maximum(63);
        ovrd_WD->step(1);
        ovrd_WD->textcolor(7);
        ovrd_WD->callback((Fl_Callback*)cb_ovrd_WD);
        ovrd_WD->align(FL_ALIGN_LEFT);
        ovrd_WD->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_WD
      { ovrd_LRc = new SliderW(531, 260, 100, 10, "L/R Cr.");
        ovrd_LRc->type(5);
        ovrd_LRc->box(FL_FLAT_BOX);
        ovrd_LRc->color((Fl_Color)178);
        ovrd_LRc->selection_color((Fl_Color)62);
        ovrd_LRc->labeltype(FL_NORMAL_LABEL);
        ovrd_LRc->labelfont(0);
        ovrd_LRc->labelsize(10);
        ovrd_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_LRc->minimum(-64);
        ovrd_LRc->maximum(63);
        ovrd_LRc->step(1);
        ovrd_LRc->textcolor(7);
        ovrd_LRc->callback((Fl_Callback*)cb_ovrd_LRc);
        ovrd_LRc->align(FL_ALIGN_LEFT);
        ovrd_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_LRc
      { ovrd_drive = new SliderW(531, 273, 100, 10, "Drive");
        ovrd_drive->type(5);
        ovrd_drive->box(FL_FLAT_BOX);
        ovrd_drive->color((Fl_Color)178);
        ovrd_drive->selection_color((Fl_Color)62);
        ovrd_drive->labeltype(FL_NORMAL_LABEL);
        ovrd_drive->labelfont(0);
        ovrd_drive->labelsize(10);
        ovrd_drive->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_drive->maximum(127);
        ovrd_drive->step(1);
        ovrd_drive->textcolor(7);
        ovrd_drive->callback((Fl_Callback*)cb_ovrd_drive);
        ovrd_drive->align(FL_ALIGN_LEFT);
        ovrd_drive->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_drive
      { ovrd_level = new SliderW(531, 287, 100, 10, "Level");
        ovrd_level->type(5);
        ovrd_level->box(FL_FLAT_BOX);
        ovrd_level->color((Fl_Color)178);
        ovrd_level->selection_color((Fl_Color)62);
        ovrd_level->labeltype(FL_NORMAL_LABEL);
        ovrd_level->labelfont(0);
        ovrd_level->labelsize(10);
        ovrd_level->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_level->maximum(127);
        ovrd_level->step(1);
        ovrd_level->textcolor(7);
        ovrd_level->callback((Fl_Callback*)cb_ovrd_level);
        ovrd_level->align(FL_ALIGN_LEFT);
        ovrd_level->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_level
      { Fl_Choice* o = ovrd_tipo = new Fl_Choice(513, 303, 72, 16, "Type");
        ovrd_tipo->down_box(FL_BORDER_BOX);
        ovrd_tipo->selection_color(FL_FOREGROUND_COLOR);
        ovrd_tipo->labelsize(10);
        ovrd_tipo->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_tipo->textsize(10);
        ovrd_tipo->textcolor(7);
        ovrd_tipo->callback((Fl_Callback*)cb_ovrd_tipo);
        o->menu(menu_dist_tipo);
      } // Fl_Choice* ovrd_tipo
      { ovrd_neg = new Fl_Check_Button(589, 304, 15, 15, "Neg.");
        ovrd_neg->down_box(FL_BORDER_BOX);
        ovrd_neg->labelsize(10);
        ovrd_neg->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_neg->callback((Fl_Callback*)cb_ovrd_neg, (void*)(2));
      } // Fl_Check_Button* ovrd_neg
      { ovrd_st = new Fl_Check_Button(521, 322, 15, 15, "Stereo");
        ovrd_st->down_box(FL_BORDER_BOX);
        ovrd_st->labelsize(10);
        ovrd_st->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_st->callback((Fl_Callback*)cb_ovrd_st, (void*)(2));
      } // Fl_Check_Button* ovrd_st
      { ovrd_pan = new SliderW(531, 337, 100, 10, "Pan");
        ovrd_pan->type(5);
        ovrd_pan->box(FL_FLAT_BOX);
        ovrd_pan->color((Fl_Color)178);
        ovrd_pan->selection_color((Fl_Color)62);
        ovrd_pan->labeltype(FL_NORMAL_LABEL);
        ovrd_pan->labelfont(0);
        ovrd_pan->labelsize(10);
        ovrd_pan->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_pan->minimum(-64);
        ovrd_pan->maximum(63);
        ovrd_pan->step(1);
        ovrd_pan->textcolor(7);
        ovrd_pan->callback((Fl_Callback*)cb_ovrd_pan);
        ovrd_pan->align(FL_ALIGN_LEFT);
        ovrd_pan->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_pan
      { ovrd_pf = new Fl_Check_Button(521, 350, 15, 15, "Pre Filter");
        ovrd_pf->down_box(FL_BORDER_BOX);
        ovrd_pf->labelsize(10);
        ovrd_pf->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_pf->callback((Fl_Callback*)cb_ovrd_pf, (void*)(2));
      } // Fl_Check_Button* ovrd_pf
      { ovrd_lpf = new SliderW(531, 369, 100, 10, "LPF");
        ovrd_lpf->type(5);
        ovrd_lpf->box(FL_FLAT_BOX);
        ovrd_lpf->color((Fl_Color)178);
        ovrd_lpf->selection_color((Fl_Color)62);
        ovrd_lpf->labeltype(FL_NORMAL_LABEL);
        ovrd_lpf->labelfont(0);
        ovrd_lpf->labelsize(10);
        ovrd_lpf->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_lpf->minimum(20);
        ovrd_lpf->maximum(26000);
        ovrd_lpf->step(1);
        ovrd_lpf->value(20000);
        ovrd_lpf->textcolor(7);
        ovrd_lpf->callback((Fl_Callback*)cb_ovrd_lpf);
        ovrd_lpf->align(FL_ALIGN_LEFT);
        ovrd_lpf->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_lpf
      { ovrd_hpf = new SliderW(531, 381, 100, 10, "HPF");
        ovrd_hpf->type(5);
        ovrd_hpf->box(FL_FLAT_BOX);
        ovrd_hpf->color((Fl_Color)178);
        ovrd_hpf->selection_color((Fl_Color)62);
        ovrd_hpf->labeltype(FL_NORMAL_LABEL);
        ovrd_hpf->labelfont(0);
        ovrd_hpf->labelsize(10);
        ovrd_hpf->labelcolor(FL_BACKGROUND2_COLOR);
        ovrd_hpf->minimum(20);
        ovrd_hpf->maximum(20000);
        ovrd_hpf->step(1);
        ovrd_hpf->value(20);
        ovrd_hpf->textcolor(7);
        ovrd_hpf->callback((Fl_Callback*)cb_ovrd_hpf);
        ovrd_hpf->align(FL_ALIGN_LEFT);
        ovrd_hpf->when(FL_WHEN_CHANGED);
      } // SliderW* ovrd_hpf
      OVRD->end();
    } // Fl_Group* OVRD
    { ECHO = new Fl_Group(639, 212, 158, 184);
      ECHO->box(FL_UP_BOX);
      ECHO->color(FL_FOREGROUND_COLOR);
      ECHO->selection_color(FL_FOREGROUND_COLOR);
      ECHO->labelfont(1);
      ECHO->user_data((void*)(1));
      ECHO->align(96|FL_ALIGN_INSIDE);
      { echo_activar = new Fl_Light_Button(644, 216, 34, 18, "On");
        echo_activar->shortcut(0x35);
        echo_activar->color((Fl_Color)62);
        echo_activar->selection_color((Fl_Color)1);
        echo_activar->labelsize(10);
        echo_activar->callback((Fl_Callback*)cb_echo_activar, (void*)(2));
        echo_activar->align(68|FL_ALIGN_INSIDE);
        echo_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* echo_activar
      { echo_preset = new Fl_Choice(716, 216, 76, 18, "Preset");
        echo_preset->down_box(FL_BORDER_BOX);
        echo_preset->selection_color(FL_FOREGROUND_COLOR);
        echo_preset->labelsize(10);
        echo_preset->labelcolor(FL_BACKGROUND2_COLOR);
        echo_preset->textsize(10);
        echo_preset->textcolor(7);
        echo_preset->callback((Fl_Callback*)cb_echo_preset, (void*)(12004));
        echo_preset->when(FL_WHEN_RELEASE_ALWAYS);
        echo_preset->menu(menu_echo_preset);
      } // Fl_Choice* echo_preset
      { echo_WD = new SliderW(690, 247, 100, 10, "Wet/Dry");
        echo_WD->type(5);
        echo_WD->box(FL_FLAT_BOX);
        echo_WD->color((Fl_Color)178);
        echo_WD->selection_color((Fl_Color)62);
        echo_WD->labeltype(FL_NORMAL_LABEL);
        echo_WD->labelfont(0);
        echo_WD->labelsize(10);
        echo_WD->labelcolor(FL_BACKGROUND2_COLOR);
        echo_WD->minimum(-64);
        echo_WD->maximum(63);
        echo_WD->step(1);
        echo_WD->textcolor(7);
        echo_WD->callback((Fl_Callback*)cb_echo_WD);
        echo_WD->align(FL_ALIGN_LEFT);
        echo_WD->when(FL_WHEN_CHANGED);
      } // SliderW* echo_WD
      { echo_RV = new SliderW(690, 270, 100, 10, "Reverse");
        echo_RV->type(5);
        echo_RV->box(FL_FLAT_BOX);
        echo_RV->color((Fl_Color)178);
        echo_RV->selection_color((Fl_Color)62);
        echo_RV->labeltype(FL_NORMAL_LABEL);
        echo_RV->labelfont(0);
        echo_RV->labelsize(10);
        echo_RV->labelcolor(FL_BACKGROUND2_COLOR);
        echo_RV->maximum(127);
        echo_RV->step(1);
        echo_RV->textcolor(7);
        echo_RV->callback((Fl_Callback*)cb_echo_RV);
        echo_RV->align(FL_ALIGN_LEFT);
        echo_RV->when(FL_WHEN_CHANGED);
      } // SliderW* echo_RV
      { echo_pan = new SliderW(690, 285, 100, 10, "Pan");
        echo_pan->type(5);
        echo_pan->box(FL_FLAT_BOX);
        echo_pan->color((Fl_Color)178);
        echo_pan->selection_color((Fl_Color)62);
        echo_pan->labeltype(FL_NORMAL_LABEL);
        echo_pan->labelfont(0);
        echo_pan->labelsize(10);
        echo_pan->labelcolor(FL_BACKGROUND2_COLOR);
        echo_pan->minimum(-64);
        echo_pan->maximum(63);
        echo_pan->step(1);
        echo_pan->textcolor(7);
        echo_pan->callback((Fl_Callback*)cb_echo_pan);
        echo_pan->align(FL_ALIGN_LEFT);
        echo_pan->when(FL_WHEN_CHANGED);
      } // SliderW* echo_pan
      { echo_delay = new SliderW(690, 300, 100, 10, "Delay");
        echo_delay->type(5);
        echo_delay->box(FL_FLAT_BOX);
        echo_delay->color((Fl_Color)178);
        echo_delay->selection_color((Fl_Color)62);
        echo_delay->labeltype(FL_NORMAL_LABEL);
        echo_delay->labelfont(0);
        echo_delay->labelsize(10);
        echo_delay->labelcolor(FL_BACKGROUND2_COLOR);
        echo_delay->minimum(20);
        echo_delay->maximum(2000);
        echo_delay->step(1);
        echo_delay->value(20);
        echo_delay->textcolor(7);
        echo_delay->callback((Fl_Callback*)cb_echo_delay);
        echo_delay->align(FL_ALIGN_LEFT);
        echo_delay->when(FL_WHEN_RELEASE);
      } // SliderW* echo_delay
      { echo_LRdl = new SliderW(690, 315, 100, 10, "LRdl.");
        echo_LRdl->type(5);
        echo_LRdl->box(FL_FLAT_BOX);
        echo_LRdl->color((Fl_Color)178);
        echo_LRdl->selection_color((Fl_Color)62);
        echo_LRdl->labeltype(FL_NORMAL_LABEL);
        echo_LRdl->labelfont(0);
        echo_LRdl->labelsize(10);
        echo_LRdl->labelcolor(FL_BACKGROUND2_COLOR);
        echo_LRdl->maximum(127);
        echo_LRdl->step(1);
        echo_LRdl->textcolor(7);
        echo_LRdl->callback((Fl_Callback*)cb_echo_LRdl);
        echo_LRdl->align(FL_ALIGN_LEFT);
        echo_LRdl->when(FL_WHEN_RELEASE);
      } // SliderW* echo_LRdl
      { echo_LRc = new SliderW(690, 330, 100, 10, "L/R.Cr");
        echo_LRc->type(5);
        echo_LRc->box(FL_FLAT_BOX);
        echo_LRc->color((Fl_Color)178);
        echo_LRc->selection_color((Fl_Color)62);
        echo_LRc->labeltype(FL_NORMAL_LABEL);
        echo_LRc->labelfont(0);
        echo_LRc->labelsize(10);
        echo_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        echo_LRc->minimum(-64);
        echo_LRc->maximum(63);
        echo_LRc->step(1);
        echo_LRc->textcolor(7);
        echo_LRc->callback((Fl_Callback*)cb_echo_LRc);
        echo_LRc->align(FL_ALIGN_LEFT);
        echo_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* echo_LRc
      { echo_fb = new SliderW(690, 345, 100, 10, "Fb.");
        echo_fb->type(5);
        echo_fb->box(FL_FLAT_BOX);
        echo_fb->color((Fl_Color)178);
        echo_fb->selection_color((Fl_Color)62);
        echo_fb->labeltype(FL_NORMAL_LABEL);
        echo_fb->labelfont(0);
        echo_fb->labelsize(10);
        echo_fb->labelcolor(FL_BACKGROUND2_COLOR);
        echo_fb->maximum(127);
        echo_fb->step(1);
        echo_fb->textcolor(7);
        echo_fb->callback((Fl_Callback*)cb_echo_fb);
        echo_fb->align(FL_ALIGN_LEFT);
        echo_fb->when(FL_WHEN_CHANGED);
      } // SliderW* echo_fb
      { echo_direct = new Fl_Check_Button(690, 360, 15, 15, "Direct");
        echo_direct->down_box(FL_BORDER_BOX);
        echo_direct->labelsize(10);
        echo_direct->labelcolor(FL_BACKGROUND2_COLOR);
        echo_direct->callback((Fl_Callback*)cb_echo_direct, (void*)(2));
      } // Fl_Check_Button* echo_direct
      { echo_damp = new SliderW(690, 379, 100, 10, "Damp");
        echo_damp->type(5);
        echo_damp->box(FL_FLAT_BOX);
        echo_damp->color((Fl_Color)178);
        echo_damp->selection_color((Fl_Color)62);
        echo_damp->labeltype(FL_NORMAL_LABEL);
        echo_damp->labelfont(0);
        echo_damp->labelsize(10);
        echo_damp->labelcolor(FL_BACKGROUND2_COLOR);
        echo_damp->maximum(127);
        echo_damp->step(1);
        echo_damp->textcolor(7);
        echo_damp->callback((Fl_Callback*)cb_echo_damp);
        echo_damp->align(FL_ALIGN_LEFT);
        echo_damp->when(FL_WHEN_CHANGED);
      } // SliderW* echo_damp
      ECHO->end();
    } // Fl_Group* ECHO
    { CHORUS = new Fl_Group(2, 413, 158, 184);
      CHORUS->box(FL_UP_BOX);
      CHORUS->color(FL_FOREGROUND_COLOR);
      CHORUS->selection_color(FL_FOREGROUND_COLOR);
      CHORUS->labelfont(1);
      CHORUS->user_data((void*)(1));
      CHORUS->align(96|FL_ALIGN_INSIDE);
      { chorus_activar = new Fl_Light_Button(7, 417, 34, 18, "On");
        chorus_activar->shortcut(0x36);
        chorus_activar->color((Fl_Color)62);
        chorus_activar->selection_color((Fl_Color)1);
        chorus_activar->labelsize(10);
        chorus_activar->callback((Fl_Callback*)cb_chorus_activar, (void*)(2));
        chorus_activar->align(68|FL_ALIGN_INSIDE);
        chorus_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* chorus_activar
      { chorus_preset = new Fl_Choice(79, 417, 76, 18, "Preset");
        chorus_preset->down_box(FL_BORDER_BOX);
        chorus_preset->selection_color(FL_FOREGROUND_COLOR);
        chorus_preset->labelsize(10);
        chorus_preset->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_preset->textsize(10);
        chorus_preset->textcolor(7);
        chorus_preset->callback((Fl_Callback*)cb_chorus_preset, (void*)(12005));
        chorus_preset->when(FL_WHEN_RELEASE_ALWAYS);
        chorus_preset->menu(menu_chorus_preset);
      } // Fl_Choice* chorus_preset
      { chorus_WD = new SliderW(51, 442, 100, 10, "Wet/Dry");
        chorus_WD->type(5);
        chorus_WD->box(FL_FLAT_BOX);
        chorus_WD->color((Fl_Color)178);
        chorus_WD->selection_color((Fl_Color)62);
        chorus_WD->labeltype(FL_NORMAL_LABEL);
        chorus_WD->labelfont(0);
        chorus_WD->labelsize(10);
        chorus_WD->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_WD->minimum(-64);
        chorus_WD->maximum(63);
        chorus_WD->step(1);
        chorus_WD->textcolor(7);
        chorus_WD->callback((Fl_Callback*)cb_chorus_WD);
        chorus_WD->align(FL_ALIGN_LEFT);
        chorus_WD->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_WD
      { chorus_pan = new SliderW(51, 454, 100, 10, "Pan");
        chorus_pan->type(5);
        chorus_pan->box(FL_FLAT_BOX);
        chorus_pan->color((Fl_Color)178);
        chorus_pan->selection_color((Fl_Color)62);
        chorus_pan->labeltype(FL_NORMAL_LABEL);
        chorus_pan->labelfont(0);
        chorus_pan->labelsize(10);
        chorus_pan->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_pan->minimum(-64);
        chorus_pan->maximum(63);
        chorus_pan->step(1);
        chorus_pan->textcolor(7);
        chorus_pan->callback((Fl_Callback*)cb_chorus_pan);
        chorus_pan->align(FL_ALIGN_LEFT);
        chorus_pan->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_pan
      { chorus_freq = new SliderW(51, 466, 100, 10, "Tempo");
        chorus_freq->type(5);
        chorus_freq->box(FL_FLAT_BOX);
        chorus_freq->color((Fl_Color)178);
        chorus_freq->selection_color((Fl_Color)62);
        chorus_freq->labeltype(FL_NORMAL_LABEL);
        chorus_freq->labelfont(0);
        chorus_freq->labelsize(10);
        chorus_freq->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_freq->minimum(1);
        chorus_freq->maximum(600);
        chorus_freq->step(1);
        chorus_freq->textcolor(7);
        chorus_freq->callback((Fl_Callback*)cb_chorus_freq);
        chorus_freq->align(FL_ALIGN_LEFT);
        chorus_freq->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_freq
      { chorus_rnd = new SliderW(51, 478, 100, 10, "Rnd");
        chorus_rnd->type(5);
        chorus_rnd->box(FL_FLAT_BOX);
        chorus_rnd->color((Fl_Color)178);
        chorus_rnd->selection_color((Fl_Color)62);
        chorus_rnd->labeltype(FL_NORMAL_LABEL);
        chorus_rnd->labelfont(0);
        chorus_rnd->labelsize(10);
        chorus_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_rnd->maximum(127);
        chorus_rnd->step(1);
        chorus_rnd->textcolor(7);
        chorus_rnd->callback((Fl_Callback*)cb_chorus_rnd);
        chorus_rnd->align(FL_ALIGN_LEFT);
        chorus_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_rnd
      { chorus_lfotype = new Fl_Choice(63, 490, 72, 16, "LFO Type");
        chorus_lfotype->down_box(FL_BORDER_BOX);
        chorus_lfotype->selection_color(FL_FOREGROUND_COLOR);
        chorus_lfotype->labelsize(10);
        chorus_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_lfotype->textsize(10);
        chorus_lfotype->textcolor(7);
        chorus_lfotype->callback((Fl_Callback*)cb_chorus_lfotype, (void*)(12));
        chorus_lfotype->menu(menu_chorus_lfotype);
      } // Fl_Choice* chorus_lfotype
      { chorus_subs = new Fl_Check_Button(37, 507, 15, 15, "Subtract");
        chorus_subs->down_box(FL_BORDER_BOX);
        chorus_subs->labelsize(10);
        chorus_subs->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_subs->callback((Fl_Callback*)cb_chorus_subs, (void*)(2));
      } // Fl_Check_Button* chorus_subs
      { chorus_stdf = new SliderW(51, 528, 100, 10, "St.df");
        chorus_stdf->type(5);
        chorus_stdf->box(FL_FLAT_BOX);
        chorus_stdf->color((Fl_Color)178);
        chorus_stdf->selection_color((Fl_Color)62);
        chorus_stdf->labeltype(FL_NORMAL_LABEL);
        chorus_stdf->labelfont(0);
        chorus_stdf->labelsize(10);
        chorus_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_stdf->maximum(127);
        chorus_stdf->step(1);
        chorus_stdf->textcolor(7);
        chorus_stdf->callback((Fl_Callback*)cb_chorus_stdf);
        chorus_stdf->align(FL_ALIGN_LEFT);
        chorus_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_stdf
      { chorus_dpth = new SliderW(51, 541, 100, 10, "Depth");
        chorus_dpth->type(5);
        chorus_dpth->box(FL_FLAT_BOX);
        chorus_dpth->color((Fl_Color)178);
        chorus_dpth->selection_color((Fl_Color)62);
        chorus_dpth->labeltype(FL_NORMAL_LABEL);
        chorus_dpth->labelfont(0);
        chorus_dpth->labelsize(10);
        chorus_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_dpth->maximum(127);
        chorus_dpth->step(1);
        chorus_dpth->textcolor(7);
        chorus_dpth->callback((Fl_Callback*)cb_chorus_dpth);
        chorus_dpth->align(FL_ALIGN_LEFT);
        chorus_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_dpth
      { chorus_delay = new SliderW(51, 554, 100, 10, "Delay");
        chorus_delay->type(5);
        chorus_delay->box(FL_FLAT_BOX);
        chorus_delay->color((Fl_Color)178);
        chorus_delay->selection_color((Fl_Color)62);
        chorus_delay->labeltype(FL_NORMAL_LABEL);
        chorus_delay->labelfont(0);
        chorus_delay->labelsize(10);
        chorus_delay->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_delay->maximum(127);
        chorus_delay->step(1);
        chorus_delay->textcolor(7);
        chorus_delay->callback((Fl_Callback*)cb_chorus_delay);
        chorus_delay->align(FL_ALIGN_LEFT);
        chorus_delay->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_delay
      { chorus_fb = new SliderW(51, 567, 100, 10, "Fb");
        chorus_fb->type(5);
        chorus_fb->box(FL_FLAT_BOX);
        chorus_fb->color((Fl_Color)178);
        chorus_fb->selection_color((Fl_Color)62);
        chorus_fb->labeltype(FL_NORMAL_LABEL);
        chorus_fb->labelfont(0);
        chorus_fb->labelsize(10);
        chorus_fb->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_fb->maximum(127);
        chorus_fb->step(1);
        chorus_fb->textcolor(7);
        chorus_fb->callback((Fl_Callback*)cb_chorus_fb);
        chorus_fb->align(FL_ALIGN_LEFT);
        chorus_fb->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_fb
      { chorus_LR = new SliderW(51, 581, 100, 10, "L/R.Cr");
        chorus_LR->type(5);
        chorus_LR->box(FL_FLAT_BOX);
        chorus_LR->color((Fl_Color)178);
        chorus_LR->selection_color((Fl_Color)62);
        chorus_LR->labeltype(FL_NORMAL_LABEL);
        chorus_LR->labelfont(0);
        chorus_LR->labelsize(10);
        chorus_LR->labelcolor(FL_BACKGROUND2_COLOR);
        chorus_LR->minimum(-64);
        chorus_LR->maximum(63);
        chorus_LR->step(1);
        chorus_LR->textcolor(7);
        chorus_LR->callback((Fl_Callback*)cb_chorus_LR);
        chorus_LR->align(FL_ALIGN_LEFT);
        chorus_LR->when(FL_WHEN_CHANGED);
      } // SliderW* chorus_LR
      CHORUS->end();
    } // Fl_Group* CHORUS
    { PHASER = new Fl_Group(161, 413, 158, 184);
      PHASER->box(FL_UP_BOX);
      PHASER->color(FL_FOREGROUND_COLOR);
      PHASER->selection_color(FL_FOREGROUND_COLOR);
      PHASER->labelfont(1);
      PHASER->user_data((void*)(1));
      PHASER->align(96|FL_ALIGN_INSIDE);
      { phaser_activar = new Fl_Light_Button(166, 417, 34, 18, "On");
        phaser_activar->shortcut(0x37);
        phaser_activar->color((Fl_Color)62);
        phaser_activar->selection_color((Fl_Color)1);
        phaser_activar->labelsize(10);
        phaser_activar->callback((Fl_Callback*)cb_phaser_activar, (void*)(2));
        phaser_activar->align(68|FL_ALIGN_INSIDE);
        phaser_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* phaser_activar
      { phaser_preset = new Fl_Choice(238, 417, 76, 18, "Preset");
        phaser_preset->down_box(FL_BORDER_BOX);
        phaser_preset->selection_color(FL_FOREGROUND_COLOR);
        phaser_preset->labelsize(10);
        phaser_preset->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_preset->textsize(10);
        phaser_preset->textcolor(7);
        phaser_preset->callback((Fl_Callback*)cb_phaser_preset, (void*)(12006));
        phaser_preset->when(FL_WHEN_RELEASE_ALWAYS);
        phaser_preset->menu(menu_phaser_preset);
      } // Fl_Choice* phaser_preset
      { phaser_WD = new SliderW(210, 442, 100, 10, "Wet/Dry");
        phaser_WD->type(5);
        phaser_WD->box(FL_FLAT_BOX);
        phaser_WD->color((Fl_Color)178);
        phaser_WD->selection_color((Fl_Color)62);
        phaser_WD->labeltype(FL_NORMAL_LABEL);
        phaser_WD->labelfont(0);
        phaser_WD->labelsize(10);
        phaser_WD->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_WD->minimum(-64);
        phaser_WD->maximum(63);
        phaser_WD->step(1);
        phaser_WD->textcolor(7);
        phaser_WD->callback((Fl_Callback*)cb_phaser_WD);
        phaser_WD->align(FL_ALIGN_LEFT);
        phaser_WD->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_WD
      { phaser_pan = new SliderW(210, 454, 100, 10, "Pan");
        phaser_pan->type(5);
        phaser_pan->box(FL_FLAT_BOX);
        phaser_pan->color((Fl_Color)178);
        phaser_pan->selection_color((Fl_Color)62);
        phaser_pan->labeltype(FL_NORMAL_LABEL);
        phaser_pan->labelfont(0);
        phaser_pan->labelsize(10);
        phaser_pan->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_pan->minimum(-64);
        phaser_pan->maximum(63);
        phaser_pan->step(1);
        phaser_pan->value(64);
        phaser_pan->textcolor(7);
        phaser_pan->callback((Fl_Callback*)cb_phaser_pan);
        phaser_pan->align(FL_ALIGN_LEFT);
        phaser_pan->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_pan
      { phaser_freq = new SliderW(210, 466, 100, 10, "Tempo");
        phaser_freq->type(5);
        phaser_freq->box(FL_FLAT_BOX);
        phaser_freq->color((Fl_Color)178);
        phaser_freq->selection_color((Fl_Color)62);
        phaser_freq->labeltype(FL_NORMAL_LABEL);
        phaser_freq->labelfont(0);
        phaser_freq->labelsize(10);
        phaser_freq->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_freq->minimum(1);
        phaser_freq->maximum(600);
        phaser_freq->step(1);
        phaser_freq->textcolor(7);
        phaser_freq->callback((Fl_Callback*)cb_phaser_freq);
        phaser_freq->align(FL_ALIGN_LEFT);
        phaser_freq->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_freq
      { phaser_rnd = new SliderW(210, 478, 100, 10, "Rnd");
        phaser_rnd->type(5);
        phaser_rnd->box(FL_FLAT_BOX);
        phaser_rnd->color((Fl_Color)178);
        phaser_rnd->selection_color((Fl_Color)62);
        phaser_rnd->labeltype(FL_NORMAL_LABEL);
        phaser_rnd->labelfont(0);
        phaser_rnd->labelsize(10);
        phaser_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_rnd->maximum(127);
        phaser_rnd->step(1);
        phaser_rnd->textcolor(7);
        phaser_rnd->callback((Fl_Callback*)cb_phaser_rnd);
        phaser_rnd->align(FL_ALIGN_LEFT);
        phaser_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_rnd
      { Fl_Choice* o = phaser_lfotype = new Fl_Choice(221, 490, 72, 16, "LFO Type");
        phaser_lfotype->down_box(FL_BORDER_BOX);
        phaser_lfotype->selection_color(FL_FOREGROUND_COLOR);
        phaser_lfotype->labelsize(10);
        phaser_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_lfotype->textsize(10);
        phaser_lfotype->textcolor(7);
        phaser_lfotype->callback((Fl_Callback*)cb_phaser_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* phaser_lfotype
      { phaser_subs = new Fl_Check_Button(201, 507, 15, 15, "Subtract");
        phaser_subs->down_box(FL_BORDER_BOX);
        phaser_subs->labelsize(10);
        phaser_subs->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_subs->callback((Fl_Callback*)cb_phaser_subs, (void*)(2));
      } // Fl_Check_Button* phaser_subs
      { phaser_phase = new SliderW(210, 523, 100, 10, "Phase");
        phaser_phase->type(5);
        phaser_phase->box(FL_FLAT_BOX);
        phaser_phase->color((Fl_Color)178);
        phaser_phase->selection_color((Fl_Color)62);
        phaser_phase->labeltype(FL_NORMAL_LABEL);
        phaser_phase->labelfont(0);
        phaser_phase->labelsize(10);
        phaser_phase->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_phase->maximum(127);
        phaser_phase->step(1);
        phaser_phase->textcolor(7);
        phaser_phase->callback((Fl_Callback*)cb_phaser_phase);
        phaser_phase->align(FL_ALIGN_LEFT);
        phaser_phase->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_phase
      { phaser_stdf = new SliderW(210, 534, 100, 10, "St.df");
        phaser_stdf->type(5);
        phaser_stdf->box(FL_FLAT_BOX);
        phaser_stdf->color((Fl_Color)178);
        phaser_stdf->selection_color((Fl_Color)62);
        phaser_stdf->labeltype(FL_NORMAL_LABEL);
        phaser_stdf->labelfont(0);
        phaser_stdf->labelsize(10);
        phaser_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_stdf->maximum(127);
        phaser_stdf->step(1);
        phaser_stdf->textcolor(7);
        phaser_stdf->callback((Fl_Callback*)cb_phaser_stdf);
        phaser_stdf->align(FL_ALIGN_LEFT);
        phaser_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_stdf
      { phaser_dpth = new SliderW(210, 545, 100, 10, "Depth");
        phaser_dpth->type(5);
        phaser_dpth->box(FL_FLAT_BOX);
        phaser_dpth->color((Fl_Color)178);
        phaser_dpth->selection_color((Fl_Color)62);
        phaser_dpth->labeltype(FL_NORMAL_LABEL);
        phaser_dpth->labelfont(0);
        phaser_dpth->labelsize(10);
        phaser_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_dpth->maximum(127);
        phaser_dpth->step(1);
        phaser_dpth->textcolor(7);
        phaser_dpth->callback((Fl_Callback*)cb_phaser_dpth);
        phaser_dpth->align(FL_ALIGN_LEFT);
        phaser_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_dpth
      { phaser_fb = new SliderW(210, 557, 100, 10, "Fb");
        phaser_fb->type(5);
        phaser_fb->box(FL_FLAT_BOX);
        phaser_fb->color((Fl_Color)178);
        phaser_fb->selection_color((Fl_Color)62);
        phaser_fb->labeltype(FL_NORMAL_LABEL);
        phaser_fb->labelfont(0);
        phaser_fb->labelsize(10);
        phaser_fb->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_fb->maximum(127);
        phaser_fb->step(1);
        phaser_fb->textcolor(7);
        phaser_fb->callback((Fl_Callback*)cb_phaser_fb);
        phaser_fb->align(FL_ALIGN_LEFT);
        phaser_fb->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_fb
      { phaser_stages = new Fl_Counter(233, 569, 52, 12, "Stages");
        phaser_stages->type(1);
        phaser_stages->box(FL_THIN_UP_BOX);
        phaser_stages->labelsize(10);
        phaser_stages->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_stages->minimum(1);
        phaser_stages->maximum(12);
        phaser_stages->step(1);
        phaser_stages->value(1);
        phaser_stages->textsize(9);
        phaser_stages->callback((Fl_Callback*)cb_phaser_stages);
        phaser_stages->align(FL_ALIGN_LEFT);
      } // Fl_Counter* phaser_stages
      { phaser_LR = new SliderW(210, 584, 100, 10, "L/R.Cr");
        phaser_LR->type(5);
        phaser_LR->box(FL_FLAT_BOX);
        phaser_LR->color((Fl_Color)178);
        phaser_LR->selection_color((Fl_Color)62);
        phaser_LR->labeltype(FL_NORMAL_LABEL);
        phaser_LR->labelfont(0);
        phaser_LR->labelsize(10);
        phaser_LR->labelcolor(FL_BACKGROUND2_COLOR);
        phaser_LR->minimum(-64);
        phaser_LR->maximum(63);
        phaser_LR->step(1);
        phaser_LR->textcolor(7);
        phaser_LR->callback((Fl_Callback*)cb_phaser_LR);
        phaser_LR->align(FL_ALIGN_LEFT);
        phaser_LR->when(FL_WHEN_CHANGED);
      } // SliderW* phaser_LR
      PHASER->end();
    } // Fl_Group* PHASER
    { FLANGER = new Fl_Group(321, 413, 158, 184);
      FLANGER->box(FL_UP_BOX);
      FLANGER->color(FL_FOREGROUND_COLOR);
      FLANGER->selection_color(FL_FOREGROUND_COLOR);
      FLANGER->labelfont(1);
      FLANGER->user_data((void*)(1));
      FLANGER->align(96|FL_ALIGN_INSIDE);
      { flanger_activar = new Fl_Light_Button(326, 417, 34, 18, "On");
        flanger_activar->shortcut(0x38);
        flanger_activar->color((Fl_Color)62);
        flanger_activar->selection_color((Fl_Color)1);
        flanger_activar->labelsize(10);
        flanger_activar->callback((Fl_Callback*)cb_flanger_activar, (void*)(2));
        flanger_activar->align(68|FL_ALIGN_INSIDE);
        flanger_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* flanger_activar
      { flanger_preset = new Fl_Choice(398, 417, 76, 18, "Preset");
        flanger_preset->down_box(FL_BORDER_BOX);
        flanger_preset->selection_color(FL_FOREGROUND_COLOR);
        flanger_preset->labelsize(10);
        flanger_preset->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_preset->textsize(10);
        flanger_preset->textcolor(7);
        flanger_preset->callback((Fl_Callback*)cb_flanger_preset, (void*)(12007));
        flanger_preset->when(FL_WHEN_RELEASE_ALWAYS);
        flanger_preset->menu(menu_flanger_preset);
      } // Fl_Choice* flanger_preset
      { flanger_WD = new SliderW(373, 442, 100, 10, "Wet/Dry");
        flanger_WD->type(5);
        flanger_WD->box(FL_FLAT_BOX);
        flanger_WD->color((Fl_Color)178);
        flanger_WD->selection_color((Fl_Color)62);
        flanger_WD->labeltype(FL_NORMAL_LABEL);
        flanger_WD->labelfont(0);
        flanger_WD->labelsize(10);
        flanger_WD->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_WD->minimum(-64);
        flanger_WD->maximum(63);
        flanger_WD->step(1);
        flanger_WD->textcolor(7);
        flanger_WD->callback((Fl_Callback*)cb_flanger_WD);
        flanger_WD->align(FL_ALIGN_LEFT);
        flanger_WD->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_WD
      { flanger_pan = new SliderW(373, 454, 100, 10, "Pan");
        flanger_pan->type(5);
        flanger_pan->box(FL_FLAT_BOX);
        flanger_pan->color((Fl_Color)178);
        flanger_pan->selection_color((Fl_Color)62);
        flanger_pan->labeltype(FL_NORMAL_LABEL);
        flanger_pan->labelfont(0);
        flanger_pan->labelsize(10);
        flanger_pan->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_pan->minimum(-64);
        flanger_pan->maximum(63);
        flanger_pan->step(1);
        flanger_pan->textcolor(7);
        flanger_pan->callback((Fl_Callback*)cb_flanger_pan);
        flanger_pan->align(FL_ALIGN_LEFT);
        flanger_pan->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_pan
      { flanger_freq = new SliderW(373, 466, 100, 10, "Tempo");
        flanger_freq->type(5);
        flanger_freq->box(FL_FLAT_BOX);
        flanger_freq->color((Fl_Color)178);
        flanger_freq->selection_color((Fl_Color)62);
        flanger_freq->labeltype(FL_NORMAL_LABEL);
        flanger_freq->labelfont(0);
        flanger_freq->labelsize(10);
        flanger_freq->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_freq->minimum(1);
        flanger_freq->maximum(600);
        flanger_freq->step(1);
        flanger_freq->textcolor(7);
        flanger_freq->callback((Fl_Callback*)cb_flanger_freq);
        flanger_freq->align(FL_ALIGN_LEFT);
        flanger_freq->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_freq
      { flanger_rnd = new SliderW(373, 478, 100, 10, "Rnd");
        flanger_rnd->type(5);
        flanger_rnd->box(FL_FLAT_BOX);
        flanger_rnd->color((Fl_Color)178);
        flanger_rnd->selection_color((Fl_Color)62);
        flanger_rnd->labeltype(FL_NORMAL_LABEL);
        flanger_rnd->labelfont(0);
        flanger_rnd->labelsize(10);
        flanger_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_rnd->maximum(127);
        flanger_rnd->step(1);
        flanger_rnd->textcolor(7);
        flanger_rnd->callback((Fl_Callback*)cb_flanger_rnd);
        flanger_rnd->align(FL_ALIGN_LEFT);
        flanger_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_rnd
      { Fl_Choice* o = flanger_lfotype = new Fl_Choice(384, 490, 72, 16, "LFO Type");
        flanger_lfotype->down_box(FL_BORDER_BOX);
        flanger_lfotype->selection_color(FL_FOREGROUND_COLOR);
        flanger_lfotype->labelsize(10);
        flanger_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_lfotype->textsize(10);
        flanger_lfotype->textcolor(7);
        flanger_lfotype->callback((Fl_Callback*)cb_flanger_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* flanger_lfotype
      { flanger_subs = new Fl_Check_Button(363, 507, 15, 15, "Subtract");
        flanger_subs->down_box(FL_BORDER_BOX);
        flanger_subs->labelsize(10);
        flanger_subs->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_subs->callback((Fl_Callback*)cb_flanger_subs, (void*)(2));
      } // Fl_Check_Button* flanger_subs
      { flanger_stdf = new SliderW(373, 528, 100, 10, "St.df");
        flanger_stdf->type(5);
        flanger_stdf->box(FL_FLAT_BOX);
        flanger_stdf->color((Fl_Color)178);
        flanger_stdf->selection_color((Fl_Color)62);
        flanger_stdf->labeltype(FL_NORMAL_LABEL);
        flanger_stdf->labelfont(0);
        flanger_stdf->labelsize(10);
        flanger_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_stdf->maximum(127);
        flanger_stdf->step(1);
        flanger_stdf->textcolor(7);
        flanger_stdf->callback((Fl_Callback*)cb_flanger_stdf);
        flanger_stdf->align(FL_ALIGN_LEFT);
        flanger_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_stdf
      { flanger_dpth = new SliderW(373, 541, 100, 10, "Depth");
        flanger_dpth->type(5);
        flanger_dpth->box(FL_FLAT_BOX);
        flanger_dpth->color((Fl_Color)178);
        flanger_dpth->selection_color((Fl_Color)62);
        flanger_dpth->labeltype(FL_NORMAL_LABEL);
        flanger_dpth->labelfont(0);
        flanger_dpth->labelsize(10);
        flanger_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_dpth->maximum(127);
        flanger_dpth->step(1);
        flanger_dpth->textcolor(7);
        flanger_dpth->callback((Fl_Callback*)cb_flanger_dpth);
        flanger_dpth->align(FL_ALIGN_LEFT);
        flanger_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_dpth
      { flanger_delay = new SliderW(373, 554, 100, 10, "Delay");
        flanger_delay->type(5);
        flanger_delay->box(FL_FLAT_BOX);
        flanger_delay->color((Fl_Color)178);
        flanger_delay->selection_color((Fl_Color)62);
        flanger_delay->labeltype(FL_NORMAL_LABEL);
        flanger_delay->labelfont(0);
        flanger_delay->labelsize(10);
        flanger_delay->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_delay->maximum(127);
        flanger_delay->step(1);
        flanger_delay->textcolor(7);
        flanger_delay->callback((Fl_Callback*)cb_flanger_delay);
        flanger_delay->align(FL_ALIGN_LEFT);
        flanger_delay->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_delay
      { flanger_fb = new SliderW(373, 567, 100, 10, "Fb");
        flanger_fb->type(5);
        flanger_fb->box(FL_FLAT_BOX);
        flanger_fb->color((Fl_Color)178);
        flanger_fb->selection_color((Fl_Color)62);
        flanger_fb->labeltype(FL_NORMAL_LABEL);
        flanger_fb->labelfont(0);
        flanger_fb->labelsize(10);
        flanger_fb->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_fb->maximum(127);
        flanger_fb->step(1);
        flanger_fb->textcolor(7);
        flanger_fb->callback((Fl_Callback*)cb_flanger_fb);
        flanger_fb->align(FL_ALIGN_LEFT);
        flanger_fb->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_fb
      { flanger_LR = new SliderW(373, 581, 100, 10, "L/R.Cr");
        flanger_LR->type(5);
        flanger_LR->box(FL_FLAT_BOX);
        flanger_LR->color((Fl_Color)178);
        flanger_LR->selection_color((Fl_Color)62);
        flanger_LR->labeltype(FL_NORMAL_LABEL);
        flanger_LR->labelfont(0);
        flanger_LR->labelsize(10);
        flanger_LR->labelcolor(FL_BACKGROUND2_COLOR);
        flanger_LR->minimum(-64);
        flanger_LR->maximum(63);
        flanger_LR->step(1);
        flanger_LR->textcolor(7);
        flanger_LR->callback((Fl_Callback*)cb_flanger_LR);
        flanger_LR->align(FL_ALIGN_LEFT);
        flanger_LR->when(FL_WHEN_CHANGED);
      } // SliderW* flanger_LR
      FLANGER->end();
    } // Fl_Group* FLANGER
    { REVERB = new Fl_Group(480, 413, 158, 184);
      REVERB->box(FL_UP_BOX);
      REVERB->color(FL_FOREGROUND_COLOR);
      REVERB->selection_color(FL_FOREGROUND_COLOR);
      REVERB->labelfont(1);
      REVERB->user_data((void*)(1));
      REVERB->align(96|FL_ALIGN_INSIDE);
      { reverb_activar = new Fl_Light_Button(485, 417, 34, 18, "On");
        reverb_activar->shortcut(0x39);
        reverb_activar->color((Fl_Color)62);
        reverb_activar->selection_color((Fl_Color)1);
        reverb_activar->labelsize(10);
        reverb_activar->callback((Fl_Callback*)cb_reverb_activar, (void*)(2));
        reverb_activar->align(68|FL_ALIGN_INSIDE);
        reverb_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* reverb_activar
      { reverb_preset = new Fl_Choice(557, 417, 76, 18, "Preset");
        reverb_preset->down_box(FL_BORDER_BOX);
        reverb_preset->selection_color(FL_FOREGROUND_COLOR);
        reverb_preset->labelsize(10);
        reverb_preset->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_preset->textsize(10);
        reverb_preset->textcolor(7);
        reverb_preset->callback((Fl_Callback*)cb_reverb_preset, (void*)(12008));
        reverb_preset->when(FL_WHEN_RELEASE_ALWAYS);
        reverb_preset->menu(menu_reverb_preset);
      } // Fl_Choice* reverb_preset
      { reverb_WD = new SliderW(531, 440, 100, 10, "Wet/Dry");
        reverb_WD->type(5);
        reverb_WD->box(FL_FLAT_BOX);
        reverb_WD->color((Fl_Color)178);
        reverb_WD->selection_color((Fl_Color)62);
        reverb_WD->labeltype(FL_NORMAL_LABEL);
        reverb_WD->labelfont(0);
        reverb_WD->labelsize(10);
        reverb_WD->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_WD->minimum(-64);
        reverb_WD->maximum(63);
        reverb_WD->step(1);
        reverb_WD->textcolor(7);
        reverb_WD->callback((Fl_Callback*)cb_reverb_WD);
        reverb_WD->align(FL_ALIGN_LEFT);
        reverb_WD->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_WD
      { reverb_pan = new SliderW(531, 452, 100, 10, "Pan");
        reverb_pan->type(5);
        reverb_pan->box(FL_FLAT_BOX);
        reverb_pan->color((Fl_Color)178);
        reverb_pan->selection_color((Fl_Color)62);
        reverb_pan->labeltype(FL_NORMAL_LABEL);
        reverb_pan->labelfont(0);
        reverb_pan->labelsize(10);
        reverb_pan->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_pan->minimum(-64);
        reverb_pan->maximum(63);
        reverb_pan->step(1);
        reverb_pan->textcolor(7);
        reverb_pan->callback((Fl_Callback*)cb_reverb_pan);
        reverb_pan->align(FL_ALIGN_LEFT);
        reverb_pan->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_pan
      { reverb_time = new SliderW(531, 465, 100, 10, "Time");
        reverb_time->type(5);
        reverb_time->box(FL_FLAT_BOX);
        reverb_time->color((Fl_Color)178);
        reverb_time->selection_color((Fl_Color)62);
        reverb_time->labeltype(FL_NORMAL_LABEL);
        reverb_time->labelfont(0);
        reverb_time->labelsize(10);
        reverb_time->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_time->maximum(127);
        reverb_time->step(1);
        reverb_time->textcolor(7);
        reverb_time->callback((Fl_Callback*)cb_reverb_time);
        reverb_time->align(FL_ALIGN_LEFT);
        reverb_time->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_time
      { reverb_ldel = new SliderW(531, 477, 100, 10, "I.Del");
        reverb_ldel->type(5);
        reverb_ldel->box(FL_FLAT_BOX);
        reverb_ldel->color((Fl_Color)178);
        reverb_ldel->selection_color((Fl_Color)62);
        reverb_ldel->labeltype(FL_NORMAL_LABEL);
        reverb_ldel->labelfont(0);
        reverb_ldel->labelsize(10);
        reverb_ldel->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_ldel->maximum(127);
        reverb_ldel->step(1);
        reverb_ldel->textcolor(7);
        reverb_ldel->callback((Fl_Callback*)cb_reverb_ldel);
        reverb_ldel->align(FL_ALIGN_LEFT);
        reverb_ldel->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_ldel
      { reverb_ldelft = new SliderW(531, 490, 100, 10, "Del.E/R");
        reverb_ldelft->type(5);
        reverb_ldelft->box(FL_FLAT_BOX);
        reverb_ldelft->color((Fl_Color)178);
        reverb_ldelft->selection_color((Fl_Color)62);
        reverb_ldelft->labeltype(FL_NORMAL_LABEL);
        reverb_ldelft->labelfont(0);
        reverb_ldelft->labelsize(10);
        reverb_ldelft->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_ldelft->maximum(127);
        reverb_ldelft->step(1);
        reverb_ldelft->textcolor(7);
        reverb_ldelft->callback((Fl_Callback*)cb_reverb_ldelft);
        reverb_ldelft->align(FL_ALIGN_LEFT);
        reverb_ldelft->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_ldelft
      { reverb_type = new Fl_Choice(542, 505, 72, 16, "Type");
        reverb_type->down_box(FL_BORDER_BOX);
        reverb_type->selection_color(FL_FOREGROUND_COLOR);
        reverb_type->labelsize(10);
        reverb_type->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_type->textsize(10);
        reverb_type->textcolor(7);
        reverb_type->callback((Fl_Callback*)cb_reverb_type, (void*)(12));
        reverb_type->menu(menu_reverb_type);
      } // Fl_Choice* reverb_type
      { reverb_RS = new SliderW(531, 529, 100, 10, "R.Size");
        reverb_RS->type(5);
        reverb_RS->box(FL_FLAT_BOX);
        reverb_RS->color((Fl_Color)178);
        reverb_RS->selection_color((Fl_Color)62);
        reverb_RS->labeltype(FL_NORMAL_LABEL);
        reverb_RS->labelfont(0);
        reverb_RS->labelsize(10);
        reverb_RS->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_RS->minimum(1);
        reverb_RS->maximum(127);
        reverb_RS->step(1);
        reverb_RS->value(1);
        reverb_RS->textcolor(7);
        reverb_RS->callback((Fl_Callback*)cb_reverb_RS);
        reverb_RS->align(FL_ALIGN_LEFT);
        reverb_RS->when(FL_WHEN_RELEASE);
      } // SliderW* reverb_RS
      { reverb_LPF = new SliderW(531, 544, 100, 10, "LPF");
        reverb_LPF->type(5);
        reverb_LPF->box(FL_FLAT_BOX);
        reverb_LPF->color((Fl_Color)178);
        reverb_LPF->selection_color((Fl_Color)62);
        reverb_LPF->labeltype(FL_NORMAL_LABEL);
        reverb_LPF->labelfont(0);
        reverb_LPF->labelsize(10);
        reverb_LPF->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_LPF->minimum(20);
        reverb_LPF->maximum(26000);
        reverb_LPF->step(1);
        reverb_LPF->value(20000);
        reverb_LPF->textcolor(7);
        reverb_LPF->callback((Fl_Callback*)cb_reverb_LPF);
        reverb_LPF->align(FL_ALIGN_LEFT);
        reverb_LPF->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_LPF
      { reverb_HPF = new SliderW(531, 560, 100, 10, "HPF");
        reverb_HPF->type(5);
        reverb_HPF->box(FL_FLAT_BOX);
        reverb_HPF->color((Fl_Color)178);
        reverb_HPF->selection_color((Fl_Color)62);
        reverb_HPF->labeltype(FL_NORMAL_LABEL);
        reverb_HPF->labelfont(0);
        reverb_HPF->labelsize(10);
        reverb_HPF->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_HPF->minimum(20);
        reverb_HPF->maximum(20000);
        reverb_HPF->step(1);
        reverb_HPF->value(20);
        reverb_HPF->textcolor(7);
        reverb_HPF->callback((Fl_Callback*)cb_reverb_HPF);
        reverb_HPF->align(FL_ALIGN_LEFT);
        reverb_HPF->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_HPF
      { reverb_damp = new SliderW(531, 576, 100, 10, "Damp");
        reverb_damp->type(5);
        reverb_damp->box(FL_FLAT_BOX);
        reverb_damp->color((Fl_Color)178);
        reverb_damp->selection_color((Fl_Color)62);
        reverb_damp->labeltype(FL_NORMAL_LABEL);
        reverb_damp->labelfont(0);
        reverb_damp->labelsize(10);
        reverb_damp->labelcolor(FL_BACKGROUND2_COLOR);
        reverb_damp->minimum(64);
        reverb_damp->maximum(127);
        reverb_damp->step(1);
        reverb_damp->value(64);
        reverb_damp->textcolor(7);
        reverb_damp->callback((Fl_Callback*)cb_reverb_damp);
        reverb_damp->align(FL_ALIGN_LEFT);
        reverb_damp->when(FL_WHEN_CHANGED);
      } // SliderW* reverb_damp
      REVERB->end();
    } // Fl_Group* REVERB
    { PEQ = new Fl_Group(639, 413, 158, 184);
      PEQ->box(FL_UP_BOX);
      PEQ->color(FL_FOREGROUND_COLOR);
      PEQ->selection_color(FL_FOREGROUND_COLOR);
      PEQ->labelfont(1);
      PEQ->user_data((void*)(1));
      PEQ->align(96|FL_ALIGN_INSIDE);
      { eqp_activar = new Fl_Light_Button(644, 417, 34, 18, "On");
        eqp_activar->shortcut(0x30);
        eqp_activar->color((Fl_Color)62);
        eqp_activar->selection_color((Fl_Color)1);
        eqp_activar->labelsize(10);
        eqp_activar->callback((Fl_Callback*)cb_eqp_activar, (void*)(2));
        eqp_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* eqp_activar
      { eqp_preset = new Fl_Choice(716, 417, 76, 18, "Preset");
        eqp_preset->down_box(FL_BORDER_BOX);
        eqp_preset->selection_color(FL_FOREGROUND_COLOR);
        eqp_preset->labelsize(10);
        eqp_preset->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_preset->textsize(10);
        eqp_preset->textcolor(7);
        eqp_preset->callback((Fl_Callback*)cb_eqp_preset, (void*)(12009));
        eqp_preset->when(FL_WHEN_RELEASE_ALWAYS);
        eqp_preset->menu(menu_eqp_preset);
      } // Fl_Choice* eqp_preset
      { eqp_Gain = new SliderW(689, 439, 100, 10, "Gain");
        eqp_Gain->type(5);
        eqp_Gain->box(FL_FLAT_BOX);
        eqp_Gain->color((Fl_Color)178);
        eqp_Gain->selection_color((Fl_Color)62);
        eqp_Gain->labeltype(FL_NORMAL_LABEL);
        eqp_Gain->labelfont(0);
        eqp_Gain->labelsize(10);
        eqp_Gain->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_Gain->minimum(-64);
        eqp_Gain->maximum(63);
        eqp_Gain->step(1);
        eqp_Gain->textcolor(7);
        eqp_Gain->callback((Fl_Callback*)cb_eqp_Gain);
        eqp_Gain->align(FL_ALIGN_LEFT);
        eqp_Gain->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_Gain
      { eqp_LF = new SliderW(689, 463, 100, 10, "Low F.");
        eqp_LF->type(5);
        eqp_LF->box(FL_FLAT_BOX);
        eqp_LF->color((Fl_Color)178);
        eqp_LF->selection_color((Fl_Color)62);
        eqp_LF->labeltype(FL_NORMAL_LABEL);
        eqp_LF->labelfont(0);
        eqp_LF->labelsize(10);
        eqp_LF->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_LF->minimum(20);
        eqp_LF->maximum(1000);
        eqp_LF->step(1);
        eqp_LF->value(400);
        eqp_LF->textcolor(7);
        eqp_LF->callback((Fl_Callback*)cb_eqp_LF);
        eqp_LF->align(FL_ALIGN_LEFT);
        eqp_LF->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_LF
      { eqp_LFg = new SliderW(689, 476, 100, 10, "Low G.");
        eqp_LFg->type(5);
        eqp_LFg->box(FL_FLAT_BOX);
        eqp_LFg->color((Fl_Color)178);
        eqp_LFg->selection_color((Fl_Color)62);
        eqp_LFg->labeltype(FL_NORMAL_LABEL);
        eqp_LFg->labelfont(0);
        eqp_LFg->labelsize(10);
        eqp_LFg->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_LFg->minimum(-64);
        eqp_LFg->maximum(63);
        eqp_LFg->step(1);
        eqp_LFg->textcolor(7);
        eqp_LFg->callback((Fl_Callback*)cb_eqp_LFg);
        eqp_LFg->align(FL_ALIGN_LEFT);
        eqp_LFg->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_LFg
      { eqp_LQ = new SliderW(689, 489, 100, 10, "Q");
        eqp_LQ->type(5);
        eqp_LQ->box(FL_FLAT_BOX);
        eqp_LQ->color((Fl_Color)178);
        eqp_LQ->selection_color((Fl_Color)62);
        eqp_LQ->labeltype(FL_NORMAL_LABEL);
        eqp_LQ->labelfont(0);
        eqp_LQ->labelsize(10);
        eqp_LQ->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_LQ->minimum(-64);
        eqp_LQ->maximum(63);
        eqp_LQ->step(1);
        eqp_LQ->textcolor(7);
        eqp_LQ->callback((Fl_Callback*)cb_eqp_LQ);
        eqp_LQ->align(FL_ALIGN_LEFT);
        eqp_LQ->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_LQ
      { eqp_MF = new SliderW(689, 511, 100, 10, "Mid F.");
        eqp_MF->type(5);
        eqp_MF->box(FL_FLAT_BOX);
        eqp_MF->color((Fl_Color)178);
        eqp_MF->selection_color((Fl_Color)62);
        eqp_MF->labeltype(FL_NORMAL_LABEL);
        eqp_MF->labelfont(0);
        eqp_MF->labelsize(10);
        eqp_MF->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_MF->minimum(800);
        eqp_MF->maximum(8000);
        eqp_MF->step(1);
        eqp_MF->value(2000);
        eqp_MF->textcolor(7);
        eqp_MF->callback((Fl_Callback*)cb_eqp_MF);
        eqp_MF->align(FL_ALIGN_LEFT);
        eqp_MF->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_MF
      { eqp_MFg = new SliderW(689, 523, 100, 10, "Mid G.");
        eqp_MFg->type(5);
        eqp_MFg->box(FL_FLAT_BOX);
        eqp_MFg->color((Fl_Color)178);
        eqp_MFg->selection_color((Fl_Color)62);
        eqp_MFg->labeltype(FL_NORMAL_LABEL);
        eqp_MFg->labelfont(0);
        eqp_MFg->labelsize(10);
        eqp_MFg->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_MFg->minimum(-64);
        eqp_MFg->maximum(63);
        eqp_MFg->step(1);
        eqp_MFg->textcolor(7);
        eqp_MFg->callback((Fl_Callback*)cb_eqp_MFg);
        eqp_MFg->align(FL_ALIGN_LEFT);
        eqp_MFg->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_MFg
      { eqp_MQ = new SliderW(689, 535, 100, 10, "Q");
        eqp_MQ->type(5);
        eqp_MQ->box(FL_FLAT_BOX);
        eqp_MQ->color((Fl_Color)178);
        eqp_MQ->selection_color((Fl_Color)62);
        eqp_MQ->labeltype(FL_NORMAL_LABEL);
        eqp_MQ->labelfont(0);
        eqp_MQ->labelsize(10);
        eqp_MQ->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_MQ->minimum(-64);
        eqp_MQ->maximum(63);
        eqp_MQ->step(1);
        eqp_MQ->textcolor(7);
        eqp_MQ->callback((Fl_Callback*)cb_eqp_MQ);
        eqp_MQ->align(FL_ALIGN_LEFT);
        eqp_MQ->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_MQ
      { eqp_HF = new SliderW(689, 557, 100, 10, "High F.");
        eqp_HF->type(5);
        eqp_HF->box(FL_FLAT_BOX);
        eqp_HF->color((Fl_Color)178);
        eqp_HF->selection_color((Fl_Color)62);
        eqp_HF->labeltype(FL_NORMAL_LABEL);
        eqp_HF->labelfont(0);
        eqp_HF->labelsize(10);
        eqp_HF->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_HF->minimum(6000);
        eqp_HF->maximum(26000);
        eqp_HF->step(1);
        eqp_HF->value(8000);
        eqp_HF->textcolor(7);
        eqp_HF->callback((Fl_Callback*)cb_eqp_HF);
        eqp_HF->align(FL_ALIGN_LEFT);
        eqp_HF->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_HF
      { eqp_HFg = new SliderW(689, 569, 100, 10, "High G.");
        eqp_HFg->type(5);
        eqp_HFg->box(FL_FLAT_BOX);
        eqp_HFg->color((Fl_Color)178);
        eqp_HFg->selection_color((Fl_Color)62);
        eqp_HFg->labeltype(FL_NORMAL_LABEL);
        eqp_HFg->labelfont(0);
        eqp_HFg->labelsize(10);
        eqp_HFg->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_HFg->minimum(-64);
        eqp_HFg->maximum(63);
        eqp_HFg->step(1);
        eqp_HFg->textcolor(7);
        eqp_HFg->callback((Fl_Callback*)cb_eqp_HFg);
        eqp_HFg->align(FL_ALIGN_LEFT);
        eqp_HFg->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_HFg
      { eqp_HQ = new SliderW(689, 581, 100, 10, "Q");
        eqp_HQ->type(5);
        eqp_HQ->box(FL_FLAT_BOX);
        eqp_HQ->color((Fl_Color)178);
        eqp_HQ->selection_color((Fl_Color)62);
        eqp_HQ->labeltype(FL_NORMAL_LABEL);
        eqp_HQ->labelfont(0);
        eqp_HQ->labelsize(10);
        eqp_HQ->labelcolor(FL_BACKGROUND2_COLOR);
        eqp_HQ->minimum(-64);
        eqp_HQ->maximum(63);
        eqp_HQ->step(1);
        eqp_HQ->textcolor(7);
        eqp_HQ->callback((Fl_Callback*)cb_eqp_HQ);
        eqp_HQ->align(FL_ALIGN_LEFT);
        eqp_HQ->when(FL_WHEN_CHANGED);
      } // SliderW* eqp_HQ
      PEQ->end();
    } // Fl_Group* PEQ
    { WHAWHA = new Fl_Group(320, 211, 158, 184);
      WHAWHA->box(FL_UP_BOX);
      WHAWHA->color(FL_FOREGROUND_COLOR);
      WHAWHA->selection_color(FL_FOREGROUND_COLOR);
      WHAWHA->labelfont(1);
      WHAWHA->user_data((void*)(1));
      WHAWHA->align(96|FL_ALIGN_INSIDE);
      WHAWHA->hide();
      { WhaWha_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        WhaWha_activar->shortcut(0x36);
        WhaWha_activar->color((Fl_Color)62);
        WhaWha_activar->selection_color((Fl_Color)1);
        WhaWha_activar->labelsize(10);
        WhaWha_activar->callback((Fl_Callback*)cb_WhaWha_activar, (void*)(2));
        WhaWha_activar->align(68|FL_ALIGN_INSIDE);
        WhaWha_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* WhaWha_activar
      { WhaWha_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        WhaWha_preset->down_box(FL_BORDER_BOX);
        WhaWha_preset->selection_color(FL_FOREGROUND_COLOR);
        WhaWha_preset->labelsize(10);
        WhaWha_preset->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_preset->textsize(10);
        WhaWha_preset->textcolor(7);
        WhaWha_preset->callback((Fl_Callback*)cb_WhaWha_preset, (void*)(12010));
        WhaWha_preset->when(FL_WHEN_RELEASE_ALWAYS);
        WhaWha_preset->menu(menu_WhaWha_preset);
      } // Fl_Choice* WhaWha_preset
      { WhaWha_WD = new SliderW(369, 240, 100, 10, "Wet/Dry");
        WhaWha_WD->type(5);
        WhaWha_WD->box(FL_FLAT_BOX);
        WhaWha_WD->color((Fl_Color)178);
        WhaWha_WD->selection_color((Fl_Color)62);
        WhaWha_WD->labeltype(FL_NORMAL_LABEL);
        WhaWha_WD->labelfont(0);
        WhaWha_WD->labelsize(10);
        WhaWha_WD->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_WD->minimum(-64);
        WhaWha_WD->maximum(63);
        WhaWha_WD->step(1);
        WhaWha_WD->textcolor(7);
        WhaWha_WD->callback((Fl_Callback*)cb_WhaWha_WD);
        WhaWha_WD->align(FL_ALIGN_LEFT);
        WhaWha_WD->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_WD
      { WhaWha_pan = new SliderW(369, 252, 100, 10, "Pan");
        WhaWha_pan->type(5);
        WhaWha_pan->box(FL_FLAT_BOX);
        WhaWha_pan->color((Fl_Color)178);
        WhaWha_pan->selection_color((Fl_Color)62);
        WhaWha_pan->labeltype(FL_NORMAL_LABEL);
        WhaWha_pan->labelfont(0);
        WhaWha_pan->labelsize(10);
        WhaWha_pan->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_pan->minimum(-64);
        WhaWha_pan->maximum(63);
        WhaWha_pan->step(1);
        WhaWha_pan->textcolor(7);
        WhaWha_pan->callback((Fl_Callback*)cb_WhaWha_pan);
        WhaWha_pan->align(FL_ALIGN_LEFT);
        WhaWha_pan->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_pan
      { WhaWha_freq = new SliderW(369, 264, 100, 10, "Tempo");
        WhaWha_freq->type(5);
        WhaWha_freq->box(FL_FLAT_BOX);
        WhaWha_freq->color((Fl_Color)178);
        WhaWha_freq->selection_color((Fl_Color)62);
        WhaWha_freq->labeltype(FL_NORMAL_LABEL);
        WhaWha_freq->labelfont(0);
        WhaWha_freq->labelsize(10);
        WhaWha_freq->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_freq->minimum(1);
        WhaWha_freq->maximum(600);
        WhaWha_freq->step(1);
        WhaWha_freq->textcolor(7);
        WhaWha_freq->callback((Fl_Callback*)cb_WhaWha_freq);
        WhaWha_freq->align(FL_ALIGN_LEFT);
        WhaWha_freq->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_freq
      { WhaWha_rnd = new SliderW(369, 276, 100, 10, "Rnd");
        WhaWha_rnd->type(5);
        WhaWha_rnd->box(FL_FLAT_BOX);
        WhaWha_rnd->color((Fl_Color)178);
        WhaWha_rnd->selection_color((Fl_Color)62);
        WhaWha_rnd->labeltype(FL_NORMAL_LABEL);
        WhaWha_rnd->labelfont(0);
        WhaWha_rnd->labelsize(10);
        WhaWha_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_rnd->maximum(127);
        WhaWha_rnd->step(1);
        WhaWha_rnd->textcolor(7);
        WhaWha_rnd->callback((Fl_Callback*)cb_WhaWha_rnd);
        WhaWha_rnd->align(FL_ALIGN_LEFT);
        WhaWha_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_rnd
      { Fl_Choice* o = WhaWha_lfotype = new Fl_Choice(381, 290, 72, 16, "LFO Type");
        WhaWha_lfotype->down_box(FL_BORDER_BOX);
        WhaWha_lfotype->selection_color(FL_FOREGROUND_COLOR);
        WhaWha_lfotype->labelsize(10);
        WhaWha_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_lfotype->textsize(10);
        WhaWha_lfotype->textcolor(7);
        WhaWha_lfotype->callback((Fl_Callback*)cb_WhaWha_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* WhaWha_lfotype
      { WhaWha_stdf = new SliderW(369, 316, 100, 10, "St.df");
        WhaWha_stdf->type(5);
        WhaWha_stdf->box(FL_FLAT_BOX);
        WhaWha_stdf->color((Fl_Color)178);
        WhaWha_stdf->selection_color((Fl_Color)62);
        WhaWha_stdf->labeltype(FL_NORMAL_LABEL);
        WhaWha_stdf->labelfont(0);
        WhaWha_stdf->labelsize(10);
        WhaWha_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_stdf->maximum(127);
        WhaWha_stdf->step(1);
        WhaWha_stdf->textcolor(7);
        WhaWha_stdf->callback((Fl_Callback*)cb_WhaWha_stdf);
        WhaWha_stdf->align(FL_ALIGN_LEFT);
        WhaWha_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_stdf
      { WhaWha_dpth = new SliderW(369, 328, 100, 10, "Depth");
        WhaWha_dpth->type(5);
        WhaWha_dpth->box(FL_FLAT_BOX);
        WhaWha_dpth->color((Fl_Color)178);
        WhaWha_dpth->selection_color((Fl_Color)62);
        WhaWha_dpth->labeltype(FL_NORMAL_LABEL);
        WhaWha_dpth->labelfont(0);
        WhaWha_dpth->labelsize(10);
        WhaWha_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_dpth->maximum(127);
        WhaWha_dpth->step(1);
        WhaWha_dpth->textcolor(7);
        WhaWha_dpth->callback((Fl_Callback*)cb_WhaWha_dpth);
        WhaWha_dpth->align(FL_ALIGN_LEFT);
        WhaWha_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_dpth
      { WhaWha_ampsns = new SliderW(369, 340, 100, 10, "Amp.S.");
        WhaWha_ampsns->type(5);
        WhaWha_ampsns->box(FL_FLAT_BOX);
        WhaWha_ampsns->color((Fl_Color)178);
        WhaWha_ampsns->selection_color((Fl_Color)62);
        WhaWha_ampsns->labeltype(FL_NORMAL_LABEL);
        WhaWha_ampsns->labelfont(0);
        WhaWha_ampsns->labelsize(10);
        WhaWha_ampsns->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_ampsns->maximum(127);
        WhaWha_ampsns->step(1);
        WhaWha_ampsns->textcolor(7);
        WhaWha_ampsns->callback((Fl_Callback*)cb_WhaWha_ampsns);
        WhaWha_ampsns->align(FL_ALIGN_LEFT);
        WhaWha_ampsns->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_ampsns
      { WhaWha_ampsnsinv = new Fl_Check_Button(375, 358, 15, 15, "Amp.S Inv");
        WhaWha_ampsnsinv->down_box(FL_BORDER_BOX);
        WhaWha_ampsnsinv->labelsize(10);
        WhaWha_ampsnsinv->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_ampsnsinv->callback((Fl_Callback*)cb_WhaWha_ampsnsinv, (void*)(2));
      } // Fl_Check_Button* WhaWha_ampsnsinv
      { WhaWha_smooth = new SliderW(369, 376, 100, 10, "Smooth");
        WhaWha_smooth->type(5);
        WhaWha_smooth->box(FL_FLAT_BOX);
        WhaWha_smooth->color((Fl_Color)178);
        WhaWha_smooth->selection_color((Fl_Color)62);
        WhaWha_smooth->labeltype(FL_NORMAL_LABEL);
        WhaWha_smooth->labelfont(0);
        WhaWha_smooth->labelsize(10);
        WhaWha_smooth->labelcolor(FL_BACKGROUND2_COLOR);
        WhaWha_smooth->maximum(127);
        WhaWha_smooth->step(1);
        WhaWha_smooth->textcolor(7);
        WhaWha_smooth->callback((Fl_Callback*)cb_WhaWha_smooth);
        WhaWha_smooth->align(FL_ALIGN_LEFT);
        WhaWha_smooth->when(FL_WHEN_CHANGED);
      } // SliderW* WhaWha_smooth
      WHAWHA->end();
    } // Fl_Group* WHAWHA
    { ALIENWAH = new Fl_Group(356, 23, 158, 184);
      ALIENWAH->box(FL_UP_BOX);
      ALIENWAH->color(FL_FOREGROUND_COLOR);
      ALIENWAH->selection_color(FL_FOREGROUND_COLOR);
      ALIENWAH->labelfont(1);
      ALIENWAH->user_data((void*)(1));
      ALIENWAH->align(96|FL_ALIGN_INSIDE);
      ALIENWAH->hide();
      { Alienwah_activar = new Fl_Light_Button(360, 27, 34, 18, "On");
        Alienwah_activar->shortcut(0x36);
        Alienwah_activar->color((Fl_Color)62);
        Alienwah_activar->selection_color((Fl_Color)1);
        Alienwah_activar->labelsize(10);
        Alienwah_activar->callback((Fl_Callback*)cb_Alienwah_activar, (void*)(2));
        Alienwah_activar->align(68|FL_ALIGN_INSIDE);
        Alienwah_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* Alienwah_activar
      { Alienwah_preset = new Fl_Choice(432, 27, 76, 18, "Preset");
        Alienwah_preset->down_box(FL_BORDER_BOX);
        Alienwah_preset->selection_color(FL_FOREGROUND_COLOR);
        Alienwah_preset->labelsize(10);
        Alienwah_preset->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_preset->textsize(10);
        Alienwah_preset->textcolor(7);
        Alienwah_preset->callback((Fl_Callback*)cb_Alienwah_preset, (void*)(12011));
        Alienwah_preset->when(FL_WHEN_RELEASE_ALWAYS);
        Alienwah_preset->menu(menu_Alienwah_preset);
      } // Fl_Choice* Alienwah_preset
      { Alienwah_WD = new SliderW(404, 52, 100, 10, "Wet/Dry");
        Alienwah_WD->type(5);
        Alienwah_WD->box(FL_FLAT_BOX);
        Alienwah_WD->color((Fl_Color)178);
        Alienwah_WD->selection_color((Fl_Color)62);
        Alienwah_WD->labeltype(FL_NORMAL_LABEL);
        Alienwah_WD->labelfont(0);
        Alienwah_WD->labelsize(10);
        Alienwah_WD->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_WD->minimum(-64);
        Alienwah_WD->maximum(63);
        Alienwah_WD->step(1);
        Alienwah_WD->textcolor(7);
        Alienwah_WD->callback((Fl_Callback*)cb_Alienwah_WD);
        Alienwah_WD->align(FL_ALIGN_LEFT);
        Alienwah_WD->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_WD
      { Alienwah_pan = new SliderW(404, 64, 100, 10, "Pan");
        Alienwah_pan->type(5);
        Alienwah_pan->box(FL_FLAT_BOX);
        Alienwah_pan->color((Fl_Color)178);
        Alienwah_pan->selection_color((Fl_Color)62);
        Alienwah_pan->labeltype(FL_NORMAL_LABEL);
        Alienwah_pan->labelfont(0);
        Alienwah_pan->labelsize(10);
        Alienwah_pan->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_pan->minimum(-64);
        Alienwah_pan->maximum(63);
        Alienwah_pan->step(1);
        Alienwah_pan->textcolor(7);
        Alienwah_pan->callback((Fl_Callback*)cb_Alienwah_pan);
        Alienwah_pan->align(FL_ALIGN_LEFT);
        Alienwah_pan->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_pan
      { Alienwah_freq = new SliderW(404, 76, 100, 10, "Tempo");
        Alienwah_freq->type(5);
        Alienwah_freq->box(FL_FLAT_BOX);
        Alienwah_freq->color((Fl_Color)178);
        Alienwah_freq->selection_color((Fl_Color)62);
        Alienwah_freq->labeltype(FL_NORMAL_LABEL);
        Alienwah_freq->labelfont(0);
        Alienwah_freq->labelsize(10);
        Alienwah_freq->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_freq->minimum(1);
        Alienwah_freq->maximum(600);
        Alienwah_freq->step(1);
        Alienwah_freq->textcolor(7);
        Alienwah_freq->callback((Fl_Callback*)cb_Alienwah_freq);
        Alienwah_freq->align(FL_ALIGN_LEFT);
        Alienwah_freq->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_freq
      { Alienwah_rnd = new SliderW(404, 88, 100, 10, "Rnd");
        Alienwah_rnd->type(5);
        Alienwah_rnd->box(FL_FLAT_BOX);
        Alienwah_rnd->color((Fl_Color)178);
        Alienwah_rnd->selection_color((Fl_Color)62);
        Alienwah_rnd->labeltype(FL_NORMAL_LABEL);
        Alienwah_rnd->labelfont(0);
        Alienwah_rnd->labelsize(10);
        Alienwah_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_rnd->maximum(127);
        Alienwah_rnd->step(1);
        Alienwah_rnd->textcolor(7);
        Alienwah_rnd->callback((Fl_Callback*)cb_Alienwah_rnd);
        Alienwah_rnd->align(FL_ALIGN_LEFT);
        Alienwah_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_rnd
      { Fl_Choice* o = Alienwah_lfotype = new Fl_Choice(416, 102, 72, 16, "LFO Type");
        Alienwah_lfotype->down_box(FL_BORDER_BOX);
        Alienwah_lfotype->selection_color(FL_FOREGROUND_COLOR);
        Alienwah_lfotype->labelsize(10);
        Alienwah_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_lfotype->textsize(10);
        Alienwah_lfotype->textcolor(7);
        Alienwah_lfotype->callback((Fl_Callback*)cb_Alienwah_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* Alienwah_lfotype
      { Alienwah_phase = new SliderW(404, 128, 100, 10, "Phase");
        Alienwah_phase->type(5);
        Alienwah_phase->box(FL_FLAT_BOX);
        Alienwah_phase->color((Fl_Color)178);
        Alienwah_phase->selection_color((Fl_Color)62);
        Alienwah_phase->labeltype(FL_NORMAL_LABEL);
        Alienwah_phase->labelfont(0);
        Alienwah_phase->labelsize(10);
        Alienwah_phase->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_phase->maximum(127);
        Alienwah_phase->step(1);
        Alienwah_phase->textcolor(7);
        Alienwah_phase->callback((Fl_Callback*)cb_Alienwah_phase);
        Alienwah_phase->align(FL_ALIGN_LEFT);
        Alienwah_phase->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_phase
      { Alienwah_stdf = new SliderW(404, 140, 100, 10, "St.df");
        Alienwah_stdf->type(5);
        Alienwah_stdf->box(FL_FLAT_BOX);
        Alienwah_stdf->color((Fl_Color)178);
        Alienwah_stdf->selection_color((Fl_Color)62);
        Alienwah_stdf->labeltype(FL_NORMAL_LABEL);
        Alienwah_stdf->labelfont(0);
        Alienwah_stdf->labelsize(10);
        Alienwah_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_stdf->maximum(127);
        Alienwah_stdf->step(1);
        Alienwah_stdf->textcolor(7);
        Alienwah_stdf->callback((Fl_Callback*)cb_Alienwah_stdf);
        Alienwah_stdf->align(FL_ALIGN_LEFT);
        Alienwah_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_stdf
      { Alienwah_dpth = new SliderW(404, 152, 100, 10, "Depth");
        Alienwah_dpth->type(5);
        Alienwah_dpth->box(FL_FLAT_BOX);
        Alienwah_dpth->color((Fl_Color)178);
        Alienwah_dpth->selection_color((Fl_Color)62);
        Alienwah_dpth->labeltype(FL_NORMAL_LABEL);
        Alienwah_dpth->labelfont(0);
        Alienwah_dpth->labelsize(10);
        Alienwah_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_dpth->maximum(127);
        Alienwah_dpth->step(1);
        Alienwah_dpth->textcolor(7);
        Alienwah_dpth->callback((Fl_Callback*)cb_Alienwah_dpth);
        Alienwah_dpth->align(FL_ALIGN_LEFT);
        Alienwah_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_dpth
      { Alienwah_delay = new SliderW(404, 164, 100, 10, "Delay");
        Alienwah_delay->type(5);
        Alienwah_delay->box(FL_FLAT_BOX);
        Alienwah_delay->color((Fl_Color)178);
        Alienwah_delay->selection_color((Fl_Color)62);
        Alienwah_delay->labeltype(FL_NORMAL_LABEL);
        Alienwah_delay->labelfont(0);
        Alienwah_delay->labelsize(10);
        Alienwah_delay->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_delay->maximum(127);
        Alienwah_delay->step(1);
        Alienwah_delay->textcolor(7);
        Alienwah_delay->callback((Fl_Callback*)cb_Alienwah_delay);
        Alienwah_delay->align(FL_ALIGN_LEFT);
        Alienwah_delay->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_delay
      { Alienwah_fb = new SliderW(404, 176, 100, 10, "Fb");
        Alienwah_fb->type(5);
        Alienwah_fb->box(FL_FLAT_BOX);
        Alienwah_fb->color((Fl_Color)178);
        Alienwah_fb->selection_color((Fl_Color)62);
        Alienwah_fb->labeltype(FL_NORMAL_LABEL);
        Alienwah_fb->labelfont(0);
        Alienwah_fb->labelsize(10);
        Alienwah_fb->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_fb->maximum(127);
        Alienwah_fb->step(1);
        Alienwah_fb->textcolor(7);
        Alienwah_fb->callback((Fl_Callback*)cb_Alienwah_fb);
        Alienwah_fb->align(FL_ALIGN_LEFT);
        Alienwah_fb->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_fb
      { Alienwah_LR = new SliderW(404, 189, 100, 10, "L/R.Cr");
        Alienwah_LR->type(5);
        Alienwah_LR->box(FL_FLAT_BOX);
        Alienwah_LR->color((Fl_Color)178);
        Alienwah_LR->selection_color((Fl_Color)62);
        Alienwah_LR->labeltype(FL_NORMAL_LABEL);
        Alienwah_LR->labelfont(0);
        Alienwah_LR->labelsize(10);
        Alienwah_LR->labelcolor(FL_BACKGROUND2_COLOR);
        Alienwah_LR->minimum(-64);
        Alienwah_LR->maximum(63);
        Alienwah_LR->step(1);
        Alienwah_LR->textcolor(7);
        Alienwah_LR->callback((Fl_Callback*)cb_Alienwah_LR);
        Alienwah_LR->align(FL_ALIGN_LEFT);
        Alienwah_LR->when(FL_WHEN_CHANGED);
      } // SliderW* Alienwah_LR
      ALIENWAH->end();
    } // Fl_Group* ALIENWAH
    { CABINET = new Fl_Group(35, 44, 158, 184);
      CABINET->box(FL_UP_BOX);
      CABINET->color(FL_FOREGROUND_COLOR);
      CABINET->selection_color(FL_FOREGROUND_COLOR);
      CABINET->labelfont(1);
      CABINET->user_data((void*)(1));
      CABINET->align(96|FL_ALIGN_INSIDE);
      CABINET->hide();
      { Cabinet_activar = new Fl_Light_Button(40, 48, 34, 18, "On");
        Cabinet_activar->shortcut(0x32);
        Cabinet_activar->color((Fl_Color)62);
        Cabinet_activar->selection_color((Fl_Color)1);
        Cabinet_activar->labelsize(10);
        Cabinet_activar->callback((Fl_Callback*)cb_Cabinet_activar, (void*)(2));
        Cabinet_activar->align(68|FL_ALIGN_INSIDE);
        Cabinet_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* Cabinet_activar
      { Cabinet_preset = new Fl_Choice(80, 89, 106, 18, "Preset");
        Cabinet_preset->down_box(FL_BORDER_BOX);
        Cabinet_preset->selection_color(FL_FOREGROUND_COLOR);
        Cabinet_preset->labelsize(10);
        Cabinet_preset->labelcolor(FL_BACKGROUND2_COLOR);
        Cabinet_preset->textsize(10);
        Cabinet_preset->textcolor(7);
        Cabinet_preset->callback((Fl_Callback*)cb_Cabinet_preset, (void*)(12012));
        Cabinet_preset->when(FL_WHEN_RELEASE_ALWAYS);
        Cabinet_preset->menu(menu_Cabinet_preset);
      } // Fl_Choice* Cabinet_preset
      { Cabinet_output = new SliderW(83, 136, 100, 10, "Gain");
        Cabinet_output->type(5);
        Cabinet_output->box(FL_FLAT_BOX);
        Cabinet_output->color((Fl_Color)178);
        Cabinet_output->selection_color((Fl_Color)62);
        Cabinet_output->labeltype(FL_NORMAL_LABEL);
        Cabinet_output->labelfont(0);
        Cabinet_output->labelsize(10);
        Cabinet_output->labelcolor(FL_BACKGROUND2_COLOR);
        Cabinet_output->minimum(-64);
        Cabinet_output->maximum(63);
        Cabinet_output->step(1);
        Cabinet_output->textcolor(7);
        Cabinet_output->callback((Fl_Callback*)cb_Cabinet_output);
        Cabinet_output->align(FL_ALIGN_LEFT);
        Cabinet_output->when(FL_WHEN_CHANGED);
      } // SliderW* Cabinet_output
      CABINET->end();
    } // Fl_Group* CABINET
    { PAN = new Fl_Group(3, 212, 158, 184);
      PAN->box(FL_UP_BOX);
      PAN->color(FL_FOREGROUND_COLOR);
      PAN->selection_color(FL_FOREGROUND_COLOR);
      PAN->labelfont(1);
      PAN->user_data((void*)(1));
      PAN->align(96|FL_ALIGN_INSIDE);
      PAN->hide();
      { pan_activar = new Fl_Light_Button(8, 216, 34, 18, "On");
        pan_activar->shortcut(0x36);
        pan_activar->color((Fl_Color)62);
        pan_activar->selection_color((Fl_Color)1);
        pan_activar->labelsize(10);
        pan_activar->callback((Fl_Callback*)cb_pan_activar, (void*)(2));
        pan_activar->align(68|FL_ALIGN_INSIDE);
        pan_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* pan_activar
      { pan_preset = new Fl_Choice(80, 216, 76, 18, "Preset");
        pan_preset->down_box(FL_BORDER_BOX);
        pan_preset->selection_color(FL_FOREGROUND_COLOR);
        pan_preset->labelsize(10);
        pan_preset->labelcolor(FL_BACKGROUND2_COLOR);
        pan_preset->textsize(10);
        pan_preset->textcolor(7);
        pan_preset->callback((Fl_Callback*)cb_pan_preset, (void*)(12013));
        pan_preset->when(FL_WHEN_RELEASE_ALWAYS);
        pan_preset->menu(menu_pan_preset);
      } // Fl_Choice* pan_preset
      { pan_WD = new SliderW(52, 241, 100, 10, "Wet/Dry");
        pan_WD->type(5);
        pan_WD->box(FL_FLAT_BOX);
        pan_WD->color((Fl_Color)178);
        pan_WD->selection_color((Fl_Color)62);
        pan_WD->labeltype(FL_NORMAL_LABEL);
        pan_WD->labelfont(0);
        pan_WD->labelsize(10);
        pan_WD->labelcolor(FL_BACKGROUND2_COLOR);
        pan_WD->minimum(-64);
        pan_WD->maximum(63);
        pan_WD->step(1);
        pan_WD->textcolor(7);
        pan_WD->callback((Fl_Callback*)cb_pan_WD);
        pan_WD->align(FL_ALIGN_LEFT);
        pan_WD->when(FL_WHEN_CHANGED);
      } // SliderW* pan_WD
      { pan_pan = new SliderW(52, 256, 100, 10, "Pan");
        pan_pan->type(5);
        pan_pan->box(FL_FLAT_BOX);
        pan_pan->color((Fl_Color)178);
        pan_pan->selection_color((Fl_Color)62);
        pan_pan->labeltype(FL_NORMAL_LABEL);
        pan_pan->labelfont(0);
        pan_pan->labelsize(10);
        pan_pan->labelcolor(FL_BACKGROUND2_COLOR);
        pan_pan->minimum(-64);
        pan_pan->maximum(63);
        pan_pan->step(1);
        pan_pan->textcolor(7);
        pan_pan->callback((Fl_Callback*)cb_pan_pan);
        pan_pan->align(FL_ALIGN_LEFT);
        pan_pan->when(FL_WHEN_CHANGED);
      } // SliderW* pan_pan
      { pan_autopan = new Fl_Check_Button(38, 268, 15, 15, "AutoPan");
        pan_autopan->down_box(FL_BORDER_BOX);
        pan_autopan->labelsize(10);
        pan_autopan->labelcolor(FL_BACKGROUND2_COLOR);
        pan_autopan->callback((Fl_Callback*)cb_pan_autopan, (void*)(2));
      } // Fl_Check_Button* pan_autopan
      { pan_freq = new SliderW(52, 285, 100, 10, "Tempo");
        pan_freq->type(5);
        pan_freq->box(FL_FLAT_BOX);
        pan_freq->color((Fl_Color)178);
        pan_freq->selection_color((Fl_Color)62);
        pan_freq->labeltype(FL_NORMAL_LABEL);
        pan_freq->labelfont(0);
        pan_freq->labelsize(10);
        pan_freq->labelcolor(FL_BACKGROUND2_COLOR);
        pan_freq->minimum(1);
        pan_freq->maximum(600);
        pan_freq->step(1);
        pan_freq->textcolor(7);
        pan_freq->callback((Fl_Callback*)cb_pan_freq);
        pan_freq->align(FL_ALIGN_LEFT);
        pan_freq->when(FL_WHEN_CHANGED);
      } // SliderW* pan_freq
      { pan_rnd = new SliderW(52, 297, 100, 10, "Rnd");
        pan_rnd->type(5);
        pan_rnd->box(FL_FLAT_BOX);
        pan_rnd->color((Fl_Color)178);
        pan_rnd->selection_color((Fl_Color)62);
        pan_rnd->labeltype(FL_NORMAL_LABEL);
        pan_rnd->labelfont(0);
        pan_rnd->labelsize(10);
        pan_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        pan_rnd->maximum(127);
        pan_rnd->step(1);
        pan_rnd->textcolor(7);
        pan_rnd->callback((Fl_Callback*)cb_pan_rnd);
        pan_rnd->align(FL_ALIGN_LEFT);
        pan_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* pan_rnd
      { Fl_Choice* o = pan_lfotype = new Fl_Choice(64, 315, 72, 16, "LFO Type");
        pan_lfotype->down_box(FL_BORDER_BOX);
        pan_lfotype->selection_color(FL_FOREGROUND_COLOR);
        pan_lfotype->labelsize(10);
        pan_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        pan_lfotype->textsize(10);
        pan_lfotype->textcolor(7);
        pan_lfotype->callback((Fl_Callback*)cb_pan_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* pan_lfotype
      { pan_stdf = new SliderW(52, 336, 100, 10, "St.df");
        pan_stdf->type(5);
        pan_stdf->box(FL_FLAT_BOX);
        pan_stdf->color((Fl_Color)178);
        pan_stdf->selection_color((Fl_Color)62);
        pan_stdf->labeltype(FL_NORMAL_LABEL);
        pan_stdf->labelfont(0);
        pan_stdf->labelsize(10);
        pan_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        pan_stdf->maximum(127);
        pan_stdf->step(1);
        pan_stdf->textcolor(7);
        pan_stdf->callback((Fl_Callback*)cb_pan_stdf);
        pan_stdf->align(FL_ALIGN_LEFT);
        pan_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* pan_stdf
      { pan_extraon = new Fl_Check_Button(38, 352, 15, 15, "Extra Stereo");
        pan_extraon->down_box(FL_BORDER_BOX);
        pan_extraon->labelsize(10);
        pan_extraon->labelcolor(FL_BACKGROUND2_COLOR);
        pan_extraon->callback((Fl_Callback*)cb_pan_extraon, (void*)(2));
      } // Fl_Check_Button* pan_extraon
      { pan_extra = new SliderW(52, 373, 100, 10, "E.S.");
        pan_extra->type(5);
        pan_extra->box(FL_FLAT_BOX);
        pan_extra->color((Fl_Color)178);
        pan_extra->selection_color((Fl_Color)62);
        pan_extra->labeltype(FL_NORMAL_LABEL);
        pan_extra->labelfont(0);
        pan_extra->labelsize(10);
        pan_extra->labelcolor(FL_BACKGROUND2_COLOR);
        pan_extra->maximum(127);
        pan_extra->step(1);
        pan_extra->textcolor(7);
        pan_extra->callback((Fl_Callback*)cb_pan_extra);
        pan_extra->align(FL_ALIGN_LEFT);
        pan_extra->when(FL_WHEN_CHANGED);
      } // SliderW* pan_extra
      PAN->end();
    } // Fl_Group* PAN
    { HAR = new Fl_Group(321, 211, 158, 184);
      HAR->box(FL_UP_BOX);
      HAR->color(FL_FOREGROUND_COLOR);
      HAR->selection_color(FL_FOREGROUND_COLOR);
      HAR->labelfont(1);
      HAR->user_data((void*)(1));
      HAR->align(96|FL_ALIGN_INSIDE);
      HAR->hide();
      { har_activar = new Fl_Light_Button(326, 215, 34, 18, "On");
        har_activar->shortcut(0x30);
        har_activar->color((Fl_Color)62);
        har_activar->selection_color((Fl_Color)1);
        har_activar->labelsize(10);
        har_activar->callback((Fl_Callback*)cb_har_activar, (void*)(2));
        har_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* har_activar
      { har_preset = new Fl_Choice(398, 215, 76, 18, "Preset");
        har_preset->down_box(FL_BORDER_BOX);
        har_preset->selection_color(FL_FOREGROUND_COLOR);
        har_preset->labelsize(10);
        har_preset->labelcolor(FL_BACKGROUND2_COLOR);
        har_preset->textsize(10);
        har_preset->textcolor(7);
        har_preset->callback((Fl_Callback*)cb_har_preset, (void*)(12014));
        har_preset->when(FL_WHEN_RELEASE_ALWAYS);
        har_preset->menu(menu_har_preset);
      } // Fl_Choice* har_preset
      { har_WD = new SliderW(371, 241, 100, 10, "Wet/Dry");
        har_WD->type(5);
        har_WD->box(FL_FLAT_BOX);
        har_WD->color((Fl_Color)178);
        har_WD->selection_color((Fl_Color)62);
        har_WD->labeltype(FL_NORMAL_LABEL);
        har_WD->labelfont(0);
        har_WD->labelsize(10);
        har_WD->labelcolor(FL_BACKGROUND2_COLOR);
        har_WD->minimum(-64);
        har_WD->maximum(63);
        har_WD->step(1);
        har_WD->textcolor(7);
        har_WD->callback((Fl_Callback*)cb_har_WD);
        har_WD->align(FL_ALIGN_LEFT);
        har_WD->when(FL_WHEN_CHANGED);
      } // SliderW* har_WD
      { har_int = new SliderW(371, 254, 100, 10, "Int.");
        har_int->type(5);
        har_int->box(FL_FLAT_BOX);
        har_int->color((Fl_Color)178);
        har_int->selection_color((Fl_Color)62);
        har_int->labeltype(FL_NORMAL_LABEL);
        har_int->labelfont(0);
        har_int->labelsize(10);
        har_int->labelcolor(FL_BACKGROUND2_COLOR);
        har_int->minimum(-12);
        har_int->maximum(12);
        har_int->step(1);
        har_int->textcolor(7);
        har_int->callback((Fl_Callback*)cb_har_int);
        har_int->align(FL_ALIGN_LEFT);
        har_int->when(FL_WHEN_CHANGED);
      } // SliderW* har_int
      { har_gan = new SliderW(371, 269, 100, 10, "Gain");
        har_gan->type(5);
        har_gan->box(FL_FLAT_BOX);
        har_gan->color((Fl_Color)178);
        har_gan->selection_color((Fl_Color)62);
        har_gan->labeltype(FL_NORMAL_LABEL);
        har_gan->labelfont(0);
        har_gan->labelsize(10);
        har_gan->labelcolor(FL_BACKGROUND2_COLOR);
        har_gan->minimum(-64);
        har_gan->maximum(63);
        har_gan->step(1);
        har_gan->textcolor(7);
        har_gan->callback((Fl_Callback*)cb_har_gan);
        har_gan->align(FL_ALIGN_LEFT);
        har_gan->when(FL_WHEN_CHANGED);
      } // SliderW* har_gan
      { har_pan = new SliderW(371, 282, 100, 10, "Pan");
        har_pan->type(5);
        har_pan->box(FL_FLAT_BOX);
        har_pan->color((Fl_Color)178);
        har_pan->selection_color((Fl_Color)62);
        har_pan->labeltype(FL_NORMAL_LABEL);
        har_pan->labelfont(0);
        har_pan->labelsize(10);
        har_pan->labelcolor(FL_BACKGROUND2_COLOR);
        har_pan->minimum(-64);
        har_pan->maximum(63);
        har_pan->step(1);
        har_pan->textcolor(7);
        har_pan->callback((Fl_Callback*)cb_har_pan);
        har_pan->align(FL_ALIGN_LEFT);
        har_pan->when(FL_WHEN_CHANGED);
      } // SliderW* har_pan
      { har_freq1 = new SliderW(372, 299, 100, 10, "Freq");
        har_freq1->type(5);
        har_freq1->box(FL_FLAT_BOX);
        har_freq1->color((Fl_Color)178);
        har_freq1->selection_color((Fl_Color)62);
        har_freq1->labeltype(FL_NORMAL_LABEL);
        har_freq1->labelfont(0);
        har_freq1->labelsize(10);
        har_freq1->labelcolor(FL_BACKGROUND2_COLOR);
        har_freq1->minimum(20);
        har_freq1->maximum(26000);
        har_freq1->step(1);
        har_freq1->value(2000);
        har_freq1->textcolor(7);
        har_freq1->callback((Fl_Callback*)cb_har_freq1);
        har_freq1->align(FL_ALIGN_LEFT);
        har_freq1->when(FL_WHEN_CHANGED);
      } // SliderW* har_freq1
      { har_gan1 = new SliderW(371, 311, 100, 10, "Gain");
        har_gan1->type(5);
        har_gan1->box(FL_FLAT_BOX);
        har_gan1->color((Fl_Color)178);
        har_gan1->selection_color((Fl_Color)62);
        har_gan1->labeltype(FL_NORMAL_LABEL);
        har_gan1->labelfont(0);
        har_gan1->labelsize(10);
        har_gan1->labelcolor(FL_BACKGROUND2_COLOR);
        har_gan1->minimum(-64);
        har_gan1->maximum(63);
        har_gan1->step(1);
        har_gan1->textcolor(7);
        har_gan1->callback((Fl_Callback*)cb_har_gan1);
        har_gan1->align(FL_ALIGN_LEFT);
        har_gan1->when(FL_WHEN_CHANGED);
      } // SliderW* har_gan1
      { har_q1 = new SliderW(371, 323, 100, 10, "Q");
        har_q1->type(5);
        har_q1->box(FL_FLAT_BOX);
        har_q1->color((Fl_Color)178);
        har_q1->selection_color((Fl_Color)62);
        har_q1->labeltype(FL_NORMAL_LABEL);
        har_q1->labelfont(0);
        har_q1->labelsize(10);
        har_q1->labelcolor(FL_BACKGROUND2_COLOR);
        har_q1->minimum(-64);
        har_q1->maximum(63);
        har_q1->step(1);
        har_q1->textcolor(7);
        har_q1->callback((Fl_Callback*)cb_har_q1);
        har_q1->align(FL_ALIGN_LEFT);
        har_q1->when(FL_WHEN_CHANGED);
      } // SliderW* har_q1
      { har_MIDI = new Fl_Check_Button(330, 335, 15, 15, "MIDI");
        har_MIDI->down_box(FL_BORDER_BOX);
        har_MIDI->labelsize(10);
        har_MIDI->labelcolor(FL_BACKGROUND2_COLOR);
        har_MIDI->callback((Fl_Callback*)cb_har_MIDI, (void*)(2));
        har_MIDI->align(FL_ALIGN_RIGHT);
      } // Fl_Check_Button* har_MIDI
      { har_SELECT = new Fl_Check_Button(330, 353, 15, 15, "SEL");
        har_SELECT->down_box(FL_BORDER_BOX);
        har_SELECT->labelsize(10);
        har_SELECT->labelcolor(FL_BACKGROUND2_COLOR);
        har_SELECT->callback((Fl_Callback*)cb_har_SELECT, (void*)(2));
        har_SELECT->align(FL_ALIGN_RIGHT);
      } // Fl_Check_Button* har_SELECT
      { har_chordname = new Fl_Box(377, 337, 98, 27);
        har_chordname->labelsize(12);
        har_chordname->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* har_chordname
      { har_note = new SliderW(371, 369, 100, 10, "Note");
        har_note->type(5);
        har_note->box(FL_FLAT_BOX);
        har_note->color((Fl_Color)178);
        har_note->selection_color((Fl_Color)62);
        har_note->labeltype(FL_NORMAL_LABEL);
        har_note->labelfont(0);
        har_note->labelsize(10);
        har_note->labelcolor(FL_BACKGROUND2_COLOR);
        har_note->maximum(23);
        har_note->step(1);
        har_note->textcolor(7);
        har_note->callback((Fl_Callback*)cb_har_note);
        har_note->align(FL_ALIGN_LEFT);
        har_note->when(FL_WHEN_CHANGED);
      } // SliderW* har_note
      { har_type = new SliderW(371, 381, 100, 10, "Chord");
        har_type->type(5);
        har_type->box(FL_FLAT_BOX);
        har_type->color((Fl_Color)178);
        har_type->selection_color((Fl_Color)62);
        har_type->labeltype(FL_NORMAL_LABEL);
        har_type->labelfont(0);
        har_type->labelsize(10);
        har_type->labelcolor(FL_BACKGROUND2_COLOR);
        har_type->maximum(33);
        har_type->step(1);
        har_type->textcolor(7);
        har_type->callback((Fl_Callback*)cb_har_type);
        har_type->align(FL_ALIGN_LEFT);
        har_type->when(FL_WHEN_CHANGED);
      } // SliderW* har_type
      HAR->end();
    } // Fl_Group* HAR
    { MUSDELAY = new Fl_Group(479, 211, 158, 184);
      MUSDELAY->box(FL_UP_BOX);
      MUSDELAY->color(FL_FOREGROUND_COLOR);
      MUSDELAY->selection_color(FL_FOREGROUND_COLOR);
      MUSDELAY->labelfont(1);
      MUSDELAY->user_data((void*)(1));
      MUSDELAY->align(96|FL_ALIGN_INSIDE);
      MUSDELAY->hide();
      { musdelay_activar = new Fl_Light_Button(484, 215, 34, 18, "On");
        musdelay_activar->shortcut(0x35);
        musdelay_activar->color((Fl_Color)62);
        musdelay_activar->selection_color((Fl_Color)1);
        musdelay_activar->labelsize(10);
        musdelay_activar->callback((Fl_Callback*)cb_musdelay_activar, (void*)(2));
        musdelay_activar->align(68|FL_ALIGN_INSIDE);
        musdelay_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* musdelay_activar
      { musdelay_preset = new Fl_Choice(556, 215, 76, 18, "Preset");
        musdelay_preset->down_box(FL_BORDER_BOX);
        musdelay_preset->selection_color(FL_FOREGROUND_COLOR);
        musdelay_preset->labelsize(10);
        musdelay_preset->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_preset->textsize(10);
        musdelay_preset->textcolor(7);
        musdelay_preset->callback((Fl_Callback*)cb_musdelay_preset, (void*)(12015));
        musdelay_preset->when(FL_WHEN_RELEASE_ALWAYS);
        musdelay_preset->menu(menu_musdelay_preset);
      } // Fl_Choice* musdelay_preset
      { musdelay_WD = new SliderW(532, 237, 100, 10, "Wet/Dry");
        musdelay_WD->type(5);
        musdelay_WD->box(FL_FLAT_BOX);
        musdelay_WD->color((Fl_Color)178);
        musdelay_WD->selection_color((Fl_Color)62);
        musdelay_WD->labeltype(FL_NORMAL_LABEL);
        musdelay_WD->labelfont(0);
        musdelay_WD->labelsize(10);
        musdelay_WD->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_WD->minimum(-64);
        musdelay_WD->maximum(63);
        musdelay_WD->step(1);
        musdelay_WD->textcolor(7);
        musdelay_WD->callback((Fl_Callback*)cb_musdelay_WD);
        musdelay_WD->align(FL_ALIGN_LEFT);
        musdelay_WD->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_WD
      { musdelay_LRc = new SliderW(532, 249, 100, 10, "L/R.Cr");
        musdelay_LRc->type(5);
        musdelay_LRc->box(FL_FLAT_BOX);
        musdelay_LRc->color((Fl_Color)178);
        musdelay_LRc->selection_color((Fl_Color)62);
        musdelay_LRc->labeltype(FL_NORMAL_LABEL);
        musdelay_LRc->labelfont(0);
        musdelay_LRc->labelsize(10);
        musdelay_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_LRc->minimum(-64);
        musdelay_LRc->maximum(63);
        musdelay_LRc->step(1);
        musdelay_LRc->textcolor(7);
        musdelay_LRc->callback((Fl_Callback*)cb_musdelay_LRc);
        musdelay_LRc->align(FL_ALIGN_LEFT);
        musdelay_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_LRc
      { musdelay_pan1 = new SliderW(532, 261, 100, 10, "Pan1");
        musdelay_pan1->type(5);
        musdelay_pan1->box(FL_FLAT_BOX);
        musdelay_pan1->color((Fl_Color)178);
        musdelay_pan1->selection_color((Fl_Color)62);
        musdelay_pan1->labeltype(FL_NORMAL_LABEL);
        musdelay_pan1->labelfont(0);
        musdelay_pan1->labelsize(10);
        musdelay_pan1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_pan1->minimum(-64);
        musdelay_pan1->maximum(63);
        musdelay_pan1->step(1);
        musdelay_pan1->textcolor(7);
        musdelay_pan1->callback((Fl_Callback*)cb_musdelay_pan1);
        musdelay_pan1->align(FL_ALIGN_LEFT);
        musdelay_pan1->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_pan1
      { musdelay_pan2 = new SliderW(532, 273, 100, 10, "Pan2");
        musdelay_pan2->type(5);
        musdelay_pan2->box(FL_FLAT_BOX);
        musdelay_pan2->color((Fl_Color)178);
        musdelay_pan2->selection_color((Fl_Color)62);
        musdelay_pan2->labeltype(FL_NORMAL_LABEL);
        musdelay_pan2->labelfont(0);
        musdelay_pan2->labelsize(10);
        musdelay_pan2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_pan2->minimum(-64);
        musdelay_pan2->maximum(63);
        musdelay_pan2->step(1);
        musdelay_pan2->textcolor(7);
        musdelay_pan2->callback((Fl_Callback*)cb_musdelay_pan2);
        musdelay_pan2->align(FL_ALIGN_LEFT);
        musdelay_pan2->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_pan2
      { musdelay_delay1 = new Fl_Choice(489, 293, 38, 14);
        musdelay_delay1->down_box(FL_BORDER_BOX);
        musdelay_delay1->labelsize(10);
        musdelay_delay1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_delay1->textsize(10);
        musdelay_delay1->textcolor(7);
        musdelay_delay1->callback((Fl_Callback*)cb_musdelay_delay1, (void*)(12));
        musdelay_delay1->menu(menu_musdelay_delay1);
      } // Fl_Choice* musdelay_delay1
      { musdelay_delay3 = new Fl_Choice(541, 293, 38, 14);
        musdelay_delay3->down_box(FL_BORDER_BOX);
        musdelay_delay3->labelsize(10);
        musdelay_delay3->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_delay3->textsize(10);
        musdelay_delay3->textcolor(7);
        musdelay_delay3->callback((Fl_Callback*)cb_musdelay_delay3, (void*)(12));
        musdelay_delay3->menu(menu_musdelay_delay3);
      } // Fl_Choice* musdelay_delay3
      { Fl_Choice* o = musdelay_delay2 = new Fl_Choice(593, 293, 38, 14);
        musdelay_delay2->down_box(FL_BORDER_BOX);
        musdelay_delay2->labelsize(10);
        musdelay_delay2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_delay2->textsize(10);
        musdelay_delay2->textcolor(7);
        musdelay_delay2->callback((Fl_Callback*)cb_musdelay_delay2);
        o->menu(menu_musdelay_delay1);
      } // Fl_Choice* musdelay_delay2
      { musdelay_tempo = new SliderW(532, 314, 100, 10, "Tempo");
        musdelay_tempo->type(5);
        musdelay_tempo->box(FL_FLAT_BOX);
        musdelay_tempo->color((Fl_Color)178);
        musdelay_tempo->selection_color((Fl_Color)62);
        musdelay_tempo->labeltype(FL_NORMAL_LABEL);
        musdelay_tempo->labelfont(0);
        musdelay_tempo->labelsize(10);
        musdelay_tempo->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_tempo->minimum(10);
        musdelay_tempo->maximum(480);
        musdelay_tempo->step(1);
        musdelay_tempo->textcolor(7);
        musdelay_tempo->callback((Fl_Callback*)cb_musdelay_tempo);
        musdelay_tempo->align(FL_ALIGN_LEFT);
        musdelay_tempo->when(FL_WHEN_RELEASE);
      } // SliderW* musdelay_tempo
      { musdelay_gain1 = new SliderW(532, 333, 100, 10, "Gain1");
        musdelay_gain1->type(5);
        musdelay_gain1->box(FL_FLAT_BOX);
        musdelay_gain1->color((Fl_Color)178);
        musdelay_gain1->selection_color((Fl_Color)62);
        musdelay_gain1->labeltype(FL_NORMAL_LABEL);
        musdelay_gain1->labelfont(0);
        musdelay_gain1->labelsize(10);
        musdelay_gain1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_gain1->minimum(-64);
        musdelay_gain1->maximum(63);
        musdelay_gain1->step(1);
        musdelay_gain1->textcolor(7);
        musdelay_gain1->callback((Fl_Callback*)cb_musdelay_gain1);
        musdelay_gain1->align(FL_ALIGN_LEFT);
        musdelay_gain1->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_gain1
      { musdelay_gain2 = new SliderW(532, 345, 100, 10, "Gain2");
        musdelay_gain2->type(5);
        musdelay_gain2->box(FL_FLAT_BOX);
        musdelay_gain2->color((Fl_Color)178);
        musdelay_gain2->selection_color((Fl_Color)62);
        musdelay_gain2->labeltype(FL_NORMAL_LABEL);
        musdelay_gain2->labelfont(0);
        musdelay_gain2->labelsize(10);
        musdelay_gain2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_gain2->minimum(-64);
        musdelay_gain2->maximum(63);
        musdelay_gain2->step(1);
        musdelay_gain2->textcolor(7);
        musdelay_gain2->callback((Fl_Callback*)cb_musdelay_gain2);
        musdelay_gain2->align(FL_ALIGN_LEFT);
        musdelay_gain2->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_gain2
      { musdelay_fb1 = new SliderW(532, 357, 100, 10, "Fb1.");
        musdelay_fb1->type(5);
        musdelay_fb1->box(FL_FLAT_BOX);
        musdelay_fb1->color((Fl_Color)178);
        musdelay_fb1->selection_color((Fl_Color)62);
        musdelay_fb1->labeltype(FL_NORMAL_LABEL);
        musdelay_fb1->labelfont(0);
        musdelay_fb1->labelsize(10);
        musdelay_fb1->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_fb1->maximum(127);
        musdelay_fb1->step(1);
        musdelay_fb1->textcolor(7);
        musdelay_fb1->callback((Fl_Callback*)cb_musdelay_fb1);
        musdelay_fb1->align(FL_ALIGN_LEFT);
        musdelay_fb1->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_fb1
      { musdelay_fb2 = new SliderW(532, 369, 100, 10, "Fb2.");
        musdelay_fb2->type(5);
        musdelay_fb2->box(FL_FLAT_BOX);
        musdelay_fb2->color((Fl_Color)178);
        musdelay_fb2->selection_color((Fl_Color)62);
        musdelay_fb2->labeltype(FL_NORMAL_LABEL);
        musdelay_fb2->labelfont(0);
        musdelay_fb2->labelsize(10);
        musdelay_fb2->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_fb2->maximum(127);
        musdelay_fb2->step(1);
        musdelay_fb2->textcolor(7);
        musdelay_fb2->callback((Fl_Callback*)cb_musdelay_fb2);
        musdelay_fb2->align(FL_ALIGN_LEFT);
        musdelay_fb2->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_fb2
      { musdelay_damp = new SliderW(532, 381, 100, 10, "Damp");
        musdelay_damp->type(5);
        musdelay_damp->box(FL_FLAT_BOX);
        musdelay_damp->color((Fl_Color)178);
        musdelay_damp->selection_color((Fl_Color)62);
        musdelay_damp->labeltype(FL_NORMAL_LABEL);
        musdelay_damp->labelfont(0);
        musdelay_damp->labelsize(10);
        musdelay_damp->labelcolor(FL_BACKGROUND2_COLOR);
        musdelay_damp->maximum(127);
        musdelay_damp->step(1);
        musdelay_damp->textcolor(7);
        musdelay_damp->callback((Fl_Callback*)cb_musdelay_damp);
        musdelay_damp->align(FL_ALIGN_LEFT);
        musdelay_damp->when(FL_WHEN_CHANGED);
      } // SliderW* musdelay_damp
      MUSDELAY->end();
    } // Fl_Group* MUSDELAY
    { GATE = new Fl_Group(321, 413, 158, 184);
      GATE->box(FL_UP_BOX);
      GATE->color(FL_FOREGROUND_COLOR);
      GATE->selection_color(FL_FOREGROUND_COLOR);
      GATE->labelfont(1);
      GATE->user_data((void*)(1));
      GATE->align(96|FL_ALIGN_INSIDE);
      GATE->hide();
      { gate_activar = new Fl_Light_Button(326, 417, 34, 18, "On");
        gate_activar->shortcut(0x32);
        gate_activar->color((Fl_Color)62);
        gate_activar->selection_color((Fl_Color)1);
        gate_activar->labelsize(10);
        gate_activar->callback((Fl_Callback*)cb_gate_activar, (void*)(2));
        gate_activar->align(68|FL_ALIGN_INSIDE);
        gate_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* gate_activar
      { gate_preset = new Fl_Choice(398, 417, 76, 18, "Preset");
        gate_preset->down_box(FL_BORDER_BOX);
        gate_preset->selection_color(FL_FOREGROUND_COLOR);
        gate_preset->labelsize(10);
        gate_preset->labelcolor(FL_BACKGROUND2_COLOR);
        gate_preset->textsize(10);
        gate_preset->textcolor(7);
        gate_preset->callback((Fl_Callback*)cb_gate_preset, (void*)(12016));
        gate_preset->when(FL_WHEN_RELEASE_ALWAYS);
        gate_preset->menu(menu_gate_preset);
      } // Fl_Choice* gate_preset
      { gate_ATime = new SliderW(372, 452, 100, 10, "A. Time");
        gate_ATime->type(5);
        gate_ATime->box(FL_FLAT_BOX);
        gate_ATime->color((Fl_Color)178);
        gate_ATime->selection_color((Fl_Color)62);
        gate_ATime->labeltype(FL_NORMAL_LABEL);
        gate_ATime->labelfont(0);
        gate_ATime->labelsize(10);
        gate_ATime->labelcolor(FL_BACKGROUND2_COLOR);
        gate_ATime->minimum(1);
        gate_ATime->maximum(250);
        gate_ATime->step(1);
        gate_ATime->value(1);
        gate_ATime->textcolor(7);
        gate_ATime->callback((Fl_Callback*)cb_gate_ATime);
        gate_ATime->align(FL_ALIGN_LEFT);
        gate_ATime->when(FL_WHEN_CHANGED);
      } // SliderW* gate_ATime
      { gate_RTime = new SliderW(371, 474, 100, 10, "R. Time");
        gate_RTime->type(5);
        gate_RTime->box(FL_FLAT_BOX);
        gate_RTime->color((Fl_Color)178);
        gate_RTime->selection_color((Fl_Color)62);
        gate_RTime->labeltype(FL_NORMAL_LABEL);
        gate_RTime->labelfont(0);
        gate_RTime->labelsize(10);
        gate_RTime->labelcolor(FL_BACKGROUND2_COLOR);
        gate_RTime->minimum(2);
        gate_RTime->maximum(250);
        gate_RTime->step(1);
        gate_RTime->value(120);
        gate_RTime->textcolor(7);
        gate_RTime->callback((Fl_Callback*)cb_gate_RTime);
        gate_RTime->align(FL_ALIGN_LEFT);
        gate_RTime->when(FL_WHEN_CHANGED);
      } // SliderW* gate_RTime
      { gate_range = new SliderW(371, 496, 100, 10, "Range");
        gate_range->type(5);
        gate_range->box(FL_FLAT_BOX);
        gate_range->color((Fl_Color)178);
        gate_range->selection_color((Fl_Color)62);
        gate_range->labeltype(FL_NORMAL_LABEL);
        gate_range->labelfont(0);
        gate_range->labelsize(10);
        gate_range->labelcolor(FL_BACKGROUND2_COLOR);
        gate_range->minimum(-90);
        gate_range->maximum(0);
        gate_range->step(1);
        gate_range->textcolor(7);
        gate_range->callback((Fl_Callback*)cb_gate_range);
        gate_range->align(FL_ALIGN_LEFT);
        gate_range->when(FL_WHEN_CHANGED);
      } // SliderW* gate_range
      { gate_threshold = new SliderW(371, 518, 100, 10, "Thrhold");
        gate_threshold->type(5);
        gate_threshold->box(FL_FLAT_BOX);
        gate_threshold->color((Fl_Color)178);
        gate_threshold->selection_color((Fl_Color)62);
        gate_threshold->labeltype(FL_NORMAL_LABEL);
        gate_threshold->labelfont(0);
        gate_threshold->labelsize(10);
        gate_threshold->labelcolor(FL_BACKGROUND2_COLOR);
        gate_threshold->minimum(-70);
        gate_threshold->maximum(20);
        gate_threshold->step(1);
        gate_threshold->textcolor(7);
        gate_threshold->callback((Fl_Callback*)cb_gate_threshold);
        gate_threshold->align(FL_ALIGN_LEFT);
        gate_threshold->when(FL_WHEN_CHANGED);
      } // SliderW* gate_threshold
      { gate_hold = new SliderW(371, 540, 100, 10, "Hold");
        gate_hold->type(5);
        gate_hold->box(FL_FLAT_BOX);
        gate_hold->color((Fl_Color)178);
        gate_hold->selection_color((Fl_Color)62);
        gate_hold->labeltype(FL_NORMAL_LABEL);
        gate_hold->labelfont(0);
        gate_hold->labelsize(10);
        gate_hold->labelcolor(FL_BACKGROUND2_COLOR);
        gate_hold->minimum(2);
        gate_hold->maximum(500);
        gate_hold->step(1);
        gate_hold->textcolor(7);
        gate_hold->callback((Fl_Callback*)cb_gate_hold);
        gate_hold->align(FL_ALIGN_LEFT);
        gate_hold->when(FL_WHEN_CHANGED);
      } // SliderW* gate_hold
      { gate_LPF = new SliderW(371, 559, 100, 10, "LPF");
        gate_LPF->type(5);
        gate_LPF->box(FL_FLAT_BOX);
        gate_LPF->color((Fl_Color)178);
        gate_LPF->selection_color((Fl_Color)62);
        gate_LPF->labeltype(FL_NORMAL_LABEL);
        gate_LPF->labelfont(0);
        gate_LPF->labelsize(10);
        gate_LPF->labelcolor(FL_BACKGROUND2_COLOR);
        gate_LPF->minimum(20);
        gate_LPF->maximum(26000);
        gate_LPF->step(1);
        gate_LPF->value(20000);
        gate_LPF->textcolor(7);
        gate_LPF->callback((Fl_Callback*)cb_gate_LPF);
        gate_LPF->align(FL_ALIGN_LEFT);
        gate_LPF->when(FL_WHEN_CHANGED);
      } // SliderW* gate_LPF
      { gate_HPF = new SliderW(371, 575, 100, 10, "HPF");
        gate_HPF->type(5);
        gate_HPF->box(FL_FLAT_BOX);
        gate_HPF->color((Fl_Color)178);
        gate_HPF->selection_color((Fl_Color)62);
        gate_HPF->labeltype(FL_NORMAL_LABEL);
        gate_HPF->labelfont(0);
        gate_HPF->labelsize(10);
        gate_HPF->labelcolor(FL_BACKGROUND2_COLOR);
        gate_HPF->minimum(20);
        gate_HPF->maximum(20000);
        gate_HPF->step(1);
        gate_HPF->value(20);
        gate_HPF->textcolor(7);
        gate_HPF->callback((Fl_Callback*)cb_gate_HPF);
        gate_HPF->align(FL_ALIGN_LEFT);
        gate_HPF->when(FL_WHEN_CHANGED);
      } // SliderW* gate_HPF
      GATE->end();
    } // Fl_Group* GATE
    { NEWDIST = new Fl_Group(320, 211, 158, 184);
      NEWDIST->box(FL_UP_BOX);
      NEWDIST->color(FL_FOREGROUND_COLOR);
      NEWDIST->selection_color(FL_FOREGROUND_COLOR);
      NEWDIST->labelfont(1);
      NEWDIST->user_data((void*)(1));
      NEWDIST->align(96|FL_ALIGN_INSIDE);
      NEWDIST->hide();
      { newdist_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        newdist_activar->shortcut(0x33);
        newdist_activar->color((Fl_Color)62);
        newdist_activar->selection_color((Fl_Color)1);
        newdist_activar->labelsize(10);
        newdist_activar->callback((Fl_Callback*)cb_newdist_activar, (void*)(2));
        newdist_activar->align(68|FL_ALIGN_INSIDE);
        newdist_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* newdist_activar
      { newdist_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        newdist_preset->down_box(FL_BORDER_BOX);
        newdist_preset->selection_color(FL_FOREGROUND_COLOR);
        newdist_preset->labelsize(10);
        newdist_preset->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_preset->textsize(10);
        newdist_preset->textcolor(7);
        newdist_preset->callback((Fl_Callback*)cb_newdist_preset, (void*)(12017));
        newdist_preset->when(FL_WHEN_RELEASE_ALWAYS);
        newdist_preset->menu(menu_newdist_preset);
      } // Fl_Choice* newdist_preset
      { newdist_WD = new SliderW(372, 239, 100, 10, "Wet/Dry");
        newdist_WD->type(5);
        newdist_WD->box(FL_FLAT_BOX);
        newdist_WD->color((Fl_Color)178);
        newdist_WD->selection_color((Fl_Color)62);
        newdist_WD->labeltype(FL_NORMAL_LABEL);
        newdist_WD->labelfont(0);
        newdist_WD->labelsize(10);
        newdist_WD->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_WD->minimum(-64);
        newdist_WD->maximum(63);
        newdist_WD->step(1);
        newdist_WD->textcolor(7);
        newdist_WD->callback((Fl_Callback*)cb_newdist_WD);
        newdist_WD->align(FL_ALIGN_LEFT);
        newdist_WD->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_WD
      { newdist_LRc = new SliderW(372, 253, 100, 10, "L/R.Cr");
        newdist_LRc->type(5);
        newdist_LRc->box(FL_FLAT_BOX);
        newdist_LRc->color((Fl_Color)178);
        newdist_LRc->selection_color((Fl_Color)62);
        newdist_LRc->labeltype(FL_NORMAL_LABEL);
        newdist_LRc->labelfont(0);
        newdist_LRc->labelsize(10);
        newdist_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_LRc->minimum(-64);
        newdist_LRc->maximum(63);
        newdist_LRc->step(1);
        newdist_LRc->textcolor(7);
        newdist_LRc->callback((Fl_Callback*)cb_newdist_LRc);
        newdist_LRc->align(FL_ALIGN_LEFT);
        newdist_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_LRc
      { newdist_drive = new SliderW(372, 267, 100, 10, "Drive");
        newdist_drive->type(5);
        newdist_drive->box(FL_FLAT_BOX);
        newdist_drive->color((Fl_Color)178);
        newdist_drive->selection_color((Fl_Color)62);
        newdist_drive->labeltype(FL_NORMAL_LABEL);
        newdist_drive->labelfont(0);
        newdist_drive->labelsize(10);
        newdist_drive->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_drive->minimum(1);
        newdist_drive->maximum(127);
        newdist_drive->step(1);
        newdist_drive->value(1);
        newdist_drive->textcolor(7);
        newdist_drive->callback((Fl_Callback*)cb_newdist_drive);
        newdist_drive->align(FL_ALIGN_LEFT);
        newdist_drive->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_drive
      { newdist_level = new SliderW(372, 281, 100, 10, "Level");
        newdist_level->type(5);
        newdist_level->box(FL_FLAT_BOX);
        newdist_level->color((Fl_Color)178);
        newdist_level->selection_color((Fl_Color)62);
        newdist_level->labeltype(FL_NORMAL_LABEL);
        newdist_level->labelfont(0);
        newdist_level->labelsize(10);
        newdist_level->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_level->maximum(127);
        newdist_level->step(1);
        newdist_level->textcolor(7);
        newdist_level->callback((Fl_Callback*)cb_newdist_level);
        newdist_level->align(FL_ALIGN_LEFT);
        newdist_level->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_level
      { Fl_Choice* o = newdist_tipo = new Fl_Choice(354, 295, 70, 16, "Type");
        newdist_tipo->down_box(FL_BORDER_BOX);
        newdist_tipo->selection_color(FL_FOREGROUND_COLOR);
        newdist_tipo->labelsize(10);
        newdist_tipo->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_tipo->textsize(10);
        newdist_tipo->textcolor(7);
        newdist_tipo->callback((Fl_Callback*)cb_newdist_tipo);
        o->menu(menu_dist_tipo);
      } // Fl_Choice* newdist_tipo
      { newdist_neg = new Fl_Check_Button(430, 295, 15, 15, "Neg.");
        newdist_neg->down_box(FL_BORDER_BOX);
        newdist_neg->labelsize(10);
        newdist_neg->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_neg->callback((Fl_Callback*)cb_newdist_neg, (void*)(2));
      } // Fl_Check_Button* newdist_neg
      { newdist_st = new SliderW(372, 317, 100, 10, "Color");
        newdist_st->type(5);
        newdist_st->box(FL_FLAT_BOX);
        newdist_st->color((Fl_Color)178);
        newdist_st->selection_color((Fl_Color)62);
        newdist_st->labeltype(FL_NORMAL_LABEL);
        newdist_st->labelfont(0);
        newdist_st->labelsize(10);
        newdist_st->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_st->maximum(127);
        newdist_st->step(1);
        newdist_st->textcolor(7);
        newdist_st->callback((Fl_Callback*)cb_newdist_st);
        newdist_st->align(FL_ALIGN_LEFT);
        newdist_st->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_st
      { newdist_oct = new SliderW(372, 331, 100, 10, "Sub Octv");
        newdist_oct->type(5);
        newdist_oct->box(FL_FLAT_BOX);
        newdist_oct->color((Fl_Color)178);
        newdist_oct->selection_color((Fl_Color)62);
        newdist_oct->labeltype(FL_NORMAL_LABEL);
        newdist_oct->labelfont(0);
        newdist_oct->labelsize(10);
        newdist_oct->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_oct->maximum(127);
        newdist_oct->step(1);
        newdist_oct->textcolor(7);
        newdist_oct->callback((Fl_Callback*)cb_newdist_oct);
        newdist_oct->align(FL_ALIGN_LEFT);
        newdist_oct->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_oct
      { newdist_pan = new SliderW(372, 345, 100, 10, "Pan");
        newdist_pan->type(5);
        newdist_pan->box(FL_FLAT_BOX);
        newdist_pan->color((Fl_Color)178);
        newdist_pan->selection_color((Fl_Color)62);
        newdist_pan->labeltype(FL_NORMAL_LABEL);
        newdist_pan->labelfont(0);
        newdist_pan->labelsize(10);
        newdist_pan->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_pan->minimum(-64);
        newdist_pan->maximum(63);
        newdist_pan->step(1);
        newdist_pan->textcolor(7);
        newdist_pan->callback((Fl_Callback*)cb_newdist_pan);
        newdist_pan->align(FL_ALIGN_LEFT);
        newdist_pan->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_pan
      { newdist_pf = new Fl_Check_Button(370, 355, 15, 15, "Pre Filter");
        newdist_pf->down_box(FL_BORDER_BOX);
        newdist_pf->labelsize(10);
        newdist_pf->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_pf->callback((Fl_Callback*)cb_newdist_pf, (void*)(2));
      } // Fl_Check_Button* newdist_pf
      { newdist_lpf = new SliderW(372, 370, 100, 10, "LPF");
        newdist_lpf->type(5);
        newdist_lpf->box(FL_FLAT_BOX);
        newdist_lpf->color((Fl_Color)178);
        newdist_lpf->selection_color((Fl_Color)62);
        newdist_lpf->labeltype(FL_NORMAL_LABEL);
        newdist_lpf->labelfont(0);
        newdist_lpf->labelsize(10);
        newdist_lpf->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_lpf->minimum(20);
        newdist_lpf->maximum(26000);
        newdist_lpf->step(1);
        newdist_lpf->value(20000);
        newdist_lpf->textcolor(7);
        newdist_lpf->callback((Fl_Callback*)cb_newdist_lpf);
        newdist_lpf->align(FL_ALIGN_LEFT);
        newdist_lpf->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_lpf
      { newdist_hpf = new SliderW(372, 382, 100, 10, "HPF");
        newdist_hpf->type(5);
        newdist_hpf->box(FL_FLAT_BOX);
        newdist_hpf->color((Fl_Color)178);
        newdist_hpf->selection_color((Fl_Color)62);
        newdist_hpf->labeltype(FL_NORMAL_LABEL);
        newdist_hpf->labelfont(0);
        newdist_hpf->labelsize(10);
        newdist_hpf->labelcolor(FL_BACKGROUND2_COLOR);
        newdist_hpf->minimum(20);
        newdist_hpf->maximum(20000);
        newdist_hpf->step(1);
        newdist_hpf->value(20);
        newdist_hpf->textcolor(7);
        newdist_hpf->callback((Fl_Callback*)cb_newdist_hpf);
        newdist_hpf->align(FL_ALIGN_LEFT);
        newdist_hpf->when(FL_WHEN_CHANGED);
      } // SliderW* newdist_hpf
      NEWDIST->end();
    } // Fl_Group* NEWDIST
    { APHASER = new Fl_Group(320, 216, 158, 184);
      APHASER->box(FL_UP_BOX);
      APHASER->color(FL_FOREGROUND_COLOR);
      APHASER->selection_color(FL_FOREGROUND_COLOR);
      APHASER->labelfont(1);
      APHASER->user_data((void*)(1));
      APHASER->align(96|FL_ALIGN_INSIDE);
      APHASER->hide();
      { aphaser_activar = new Fl_Light_Button(325, 220, 34, 18, "On");
        aphaser_activar->shortcut(0x37);
        aphaser_activar->color((Fl_Color)62);
        aphaser_activar->selection_color((Fl_Color)1);
        aphaser_activar->labelsize(10);
        aphaser_activar->callback((Fl_Callback*)cb_aphaser_activar, (void*)(2));
        aphaser_activar->align(68|FL_ALIGN_INSIDE);
        aphaser_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* aphaser_activar
      { aphaser_preset = new Fl_Choice(397, 220, 76, 18, "Preset");
        aphaser_preset->down_box(FL_BORDER_BOX);
        aphaser_preset->selection_color(FL_FOREGROUND_COLOR);
        aphaser_preset->labelsize(10);
        aphaser_preset->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_preset->textsize(10);
        aphaser_preset->textcolor(7);
        aphaser_preset->callback((Fl_Callback*)cb_aphaser_preset, (void*)(12018));
        aphaser_preset->when(FL_WHEN_RELEASE_ALWAYS);
        aphaser_preset->menu(menu_aphaser_preset);
      } // Fl_Choice* aphaser_preset
      { aphaser_WD = new SliderW(369, 243, 100, 10, "Wet/Dry");
        aphaser_WD->type(5);
        aphaser_WD->box(FL_FLAT_BOX);
        aphaser_WD->color((Fl_Color)178);
        aphaser_WD->selection_color((Fl_Color)62);
        aphaser_WD->labeltype(FL_NORMAL_LABEL);
        aphaser_WD->labelfont(0);
        aphaser_WD->labelsize(10);
        aphaser_WD->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_WD->minimum(-64);
        aphaser_WD->maximum(63);
        aphaser_WD->step(1);
        aphaser_WD->textcolor(7);
        aphaser_WD->callback((Fl_Callback*)cb_aphaser_WD);
        aphaser_WD->align(FL_ALIGN_LEFT);
        aphaser_WD->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_WD
      { Fl_Choice* o = aphaser_lfotype = new Fl_Choice(395, 257, 72, 16, "LFO Type");
        aphaser_lfotype->down_box(FL_BORDER_BOX);
        aphaser_lfotype->selection_color(FL_FOREGROUND_COLOR);
        aphaser_lfotype->labelsize(10);
        aphaser_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_lfotype->textsize(10);
        aphaser_lfotype->textcolor(7);
        aphaser_lfotype->callback((Fl_Callback*)cb_aphaser_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* aphaser_lfotype
      { aphaser_freq = new SliderW(368, 278, 100, 10, "Tempo");
        aphaser_freq->type(5);
        aphaser_freq->box(FL_FLAT_BOX);
        aphaser_freq->color((Fl_Color)178);
        aphaser_freq->selection_color((Fl_Color)62);
        aphaser_freq->labeltype(FL_NORMAL_LABEL);
        aphaser_freq->labelfont(0);
        aphaser_freq->labelsize(10);
        aphaser_freq->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_freq->minimum(1);
        aphaser_freq->maximum(600);
        aphaser_freq->step(1);
        aphaser_freq->textcolor(7);
        aphaser_freq->callback((Fl_Callback*)cb_aphaser_freq);
        aphaser_freq->align(FL_ALIGN_LEFT);
        aphaser_freq->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_freq
      { aphaser_dpth = new SliderW(368, 302, 100, 10, "Width");
        aphaser_dpth->type(5);
        aphaser_dpth->box(FL_FLAT_BOX);
        aphaser_dpth->color((Fl_Color)178);
        aphaser_dpth->selection_color((Fl_Color)62);
        aphaser_dpth->labeltype(FL_NORMAL_LABEL);
        aphaser_dpth->labelfont(0);
        aphaser_dpth->labelsize(10);
        aphaser_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_dpth->maximum(127);
        aphaser_dpth->step(1);
        aphaser_dpth->textcolor(7);
        aphaser_dpth->callback((Fl_Callback*)cb_aphaser_dpth);
        aphaser_dpth->align(FL_ALIGN_LEFT);
        aphaser_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_dpth
      { aphaser_phase = new SliderW(369, 290, 100, 10, "Depth");
        aphaser_phase->type(5);
        aphaser_phase->box(FL_FLAT_BOX);
        aphaser_phase->color((Fl_Color)178);
        aphaser_phase->selection_color((Fl_Color)62);
        aphaser_phase->labeltype(FL_NORMAL_LABEL);
        aphaser_phase->labelfont(0);
        aphaser_phase->labelsize(10);
        aphaser_phase->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_phase->maximum(127);
        aphaser_phase->step(1);
        aphaser_phase->textcolor(7);
        aphaser_phase->callback((Fl_Callback*)cb_aphaser_phase);
        aphaser_phase->align(FL_ALIGN_LEFT);
        aphaser_phase->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_phase
      { aphaser_fb = new SliderW(368, 314, 100, 10, "Fb");
        aphaser_fb->type(5);
        aphaser_fb->box(FL_FLAT_BOX);
        aphaser_fb->color((Fl_Color)178);
        aphaser_fb->selection_color((Fl_Color)62);
        aphaser_fb->labeltype(FL_NORMAL_LABEL);
        aphaser_fb->labelfont(0);
        aphaser_fb->labelsize(10);
        aphaser_fb->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_fb->minimum(-64);
        aphaser_fb->maximum(64);
        aphaser_fb->step(1);
        aphaser_fb->textcolor(7);
        aphaser_fb->callback((Fl_Callback*)cb_aphaser_fb);
        aphaser_fb->align(FL_ALIGN_LEFT);
        aphaser_fb->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_fb
      { aphaser_LR = new SliderW(368, 327, 100, 10, "Mismatch");
        aphaser_LR->type(5);
        aphaser_LR->box(FL_FLAT_BOX);
        aphaser_LR->color((Fl_Color)178);
        aphaser_LR->selection_color((Fl_Color)62);
        aphaser_LR->labeltype(FL_NORMAL_LABEL);
        aphaser_LR->labelfont(0);
        aphaser_LR->labelsize(7);
        aphaser_LR->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_LR->maximum(100);
        aphaser_LR->step(1);
        aphaser_LR->textcolor(7);
        aphaser_LR->callback((Fl_Callback*)cb_aphaser_LR);
        aphaser_LR->align(FL_ALIGN_LEFT);
        aphaser_LR->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_LR
      { aphaser_pan = new SliderW(368, 338, 100, 10, "Distort");
        aphaser_pan->type(5);
        aphaser_pan->box(FL_FLAT_BOX);
        aphaser_pan->color((Fl_Color)178);
        aphaser_pan->selection_color((Fl_Color)62);
        aphaser_pan->labeltype(FL_NORMAL_LABEL);
        aphaser_pan->labelfont(0);
        aphaser_pan->labelsize(10);
        aphaser_pan->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_pan->maximum(100);
        aphaser_pan->step(1);
        aphaser_pan->textcolor(7);
        aphaser_pan->callback((Fl_Callback*)cb_aphaser_pan);
        aphaser_pan->align(FL_ALIGN_LEFT);
        aphaser_pan->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_pan
      { aphaser_stdf = new SliderW(369, 350, 100, 10, "St.df");
        aphaser_stdf->type(5);
        aphaser_stdf->box(FL_FLAT_BOX);
        aphaser_stdf->color((Fl_Color)178);
        aphaser_stdf->selection_color((Fl_Color)62);
        aphaser_stdf->labeltype(FL_NORMAL_LABEL);
        aphaser_stdf->labelfont(0);
        aphaser_stdf->labelsize(10);
        aphaser_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_stdf->maximum(127);
        aphaser_stdf->step(1);
        aphaser_stdf->textcolor(7);
        aphaser_stdf->callback((Fl_Callback*)cb_aphaser_stdf);
        aphaser_stdf->align(FL_ALIGN_LEFT);
        aphaser_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* aphaser_stdf
      { aphaser_stages = new Fl_Counter(400, 367, 52, 12, "Stages");
        aphaser_stages->type(1);
        aphaser_stages->box(FL_THIN_UP_BOX);
        aphaser_stages->labelsize(10);
        aphaser_stages->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_stages->minimum(1);
        aphaser_stages->maximum(12);
        aphaser_stages->step(1);
        aphaser_stages->value(1);
        aphaser_stages->textsize(9);
        aphaser_stages->callback((Fl_Callback*)cb_aphaser_stages);
        aphaser_stages->align(FL_ALIGN_LEFT);
      } // Fl_Counter* aphaser_stages
      { aphaser_hyper = new Fl_Check_Button(395, 381, 15, 15, "Hyper");
        aphaser_hyper->down_box(FL_BORDER_BOX);
        aphaser_hyper->labelsize(10);
        aphaser_hyper->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_hyper->callback((Fl_Callback*)cb_aphaser_hyper, (void*)(2));
      } // Fl_Check_Button* aphaser_hyper
      { aphaser_subs = new Fl_Check_Button(330, 381, 15, 15, "Subtract");
        aphaser_subs->down_box(FL_BORDER_BOX);
        aphaser_subs->labelsize(10);
        aphaser_subs->labelcolor(FL_BACKGROUND2_COLOR);
        aphaser_subs->callback((Fl_Callback*)cb_aphaser_subs, (void*)(2));
      } // Fl_Check_Button* aphaser_subs
      APHASER->end();
    } // Fl_Group* APHASER
    { VALVE = new Fl_Group(320, 211, 158, 184);
      VALVE->box(FL_UP_BOX);
      VALVE->color(FL_FOREGROUND_COLOR);
      VALVE->selection_color(FL_FOREGROUND_COLOR);
      VALVE->labelfont(1);
      VALVE->user_data((void*)(1));
      VALVE->align(96|FL_ALIGN_INSIDE);
      VALVE->hide();
      { valve_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        valve_activar->shortcut(0x33);
        valve_activar->color((Fl_Color)62);
        valve_activar->selection_color((Fl_Color)1);
        valve_activar->labelsize(10);
        valve_activar->callback((Fl_Callback*)cb_valve_activar, (void*)(2));
        valve_activar->align(68|FL_ALIGN_INSIDE);
        valve_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* valve_activar
      { valve_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        valve_preset->down_box(FL_BORDER_BOX);
        valve_preset->selection_color(FL_FOREGROUND_COLOR);
        valve_preset->labelsize(10);
        valve_preset->labelcolor(FL_BACKGROUND2_COLOR);
        valve_preset->textsize(10);
        valve_preset->textcolor(7);
        valve_preset->callback((Fl_Callback*)cb_valve_preset, (void*)(12019));
        valve_preset->when(FL_WHEN_RELEASE_ALWAYS);
        valve_preset->menu(menu_valve_preset);
      } // Fl_Choice* valve_preset
      { valve_WD = new SliderW(373, 242, 100, 10, "Wet/Dry");
        valve_WD->type(5);
        valve_WD->box(FL_FLAT_BOX);
        valve_WD->color((Fl_Color)178);
        valve_WD->selection_color((Fl_Color)62);
        valve_WD->labeltype(FL_NORMAL_LABEL);
        valve_WD->labelfont(0);
        valve_WD->labelsize(10);
        valve_WD->labelcolor(FL_BACKGROUND2_COLOR);
        valve_WD->minimum(-64);
        valve_WD->maximum(63);
        valve_WD->step(1);
        valve_WD->textcolor(7);
        valve_WD->callback((Fl_Callback*)cb_valve_WD);
        valve_WD->align(FL_ALIGN_LEFT);
        valve_WD->when(FL_WHEN_CHANGED);
      } // SliderW* valve_WD
      { valve_LRc = new SliderW(373, 255, 100, 10, "L/R.Cr");
        valve_LRc->type(5);
        valve_LRc->box(FL_FLAT_BOX);
        valve_LRc->color((Fl_Color)178);
        valve_LRc->selection_color((Fl_Color)62);
        valve_LRc->labeltype(FL_NORMAL_LABEL);
        valve_LRc->labelfont(0);
        valve_LRc->labelsize(10);
        valve_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        valve_LRc->minimum(-64);
        valve_LRc->maximum(63);
        valve_LRc->step(1);
        valve_LRc->textcolor(7);
        valve_LRc->callback((Fl_Callback*)cb_valve_LRc);
        valve_LRc->align(FL_ALIGN_LEFT);
        valve_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* valve_LRc
      { valve_pan = new SliderW(373, 268, 100, 10, "Pan");
        valve_pan->type(5);
        valve_pan->box(FL_FLAT_BOX);
        valve_pan->color((Fl_Color)178);
        valve_pan->selection_color((Fl_Color)62);
        valve_pan->labeltype(FL_NORMAL_LABEL);
        valve_pan->labelfont(0);
        valve_pan->labelsize(10);
        valve_pan->labelcolor(FL_BACKGROUND2_COLOR);
        valve_pan->minimum(-64);
        valve_pan->maximum(63);
        valve_pan->step(1);
        valve_pan->textcolor(7);
        valve_pan->callback((Fl_Callback*)cb_valve_pan);
        valve_pan->align(FL_ALIGN_LEFT);
        valve_pan->when(FL_WHEN_CHANGED);
      } // SliderW* valve_pan
      { valve_level = new SliderW(373, 282, 100, 10, "Level");
        valve_level->type(5);
        valve_level->box(FL_FLAT_BOX);
        valve_level->color((Fl_Color)178);
        valve_level->selection_color((Fl_Color)62);
        valve_level->labeltype(FL_NORMAL_LABEL);
        valve_level->labelfont(0);
        valve_level->labelsize(10);
        valve_level->labelcolor(FL_BACKGROUND2_COLOR);
        valve_level->maximum(127);
        valve_level->step(1);
        valve_level->textcolor(7);
        valve_level->callback((Fl_Callback*)cb_valve_level);
        valve_level->align(FL_ALIGN_LEFT);
        valve_level->when(FL_WHEN_CHANGED);
      } // SliderW* valve_level
      { valve_drive = new SliderW(373, 295, 100, 10, "Drive");
        valve_drive->type(5);
        valve_drive->box(FL_FLAT_BOX);
        valve_drive->color((Fl_Color)178);
        valve_drive->selection_color((Fl_Color)62);
        valve_drive->labeltype(FL_NORMAL_LABEL);
        valve_drive->labelfont(0);
        valve_drive->labelsize(10);
        valve_drive->labelcolor(FL_BACKGROUND2_COLOR);
        valve_drive->maximum(127);
        valve_drive->step(1);
        valve_drive->textcolor(7);
        valve_drive->callback((Fl_Callback*)cb_valve_drive);
        valve_drive->align(FL_ALIGN_LEFT);
        valve_drive->when(FL_WHEN_CHANGED);
      } // SliderW* valve_drive
      { valve_ed = new Fl_Check_Button(335, 307, 15, 15, "Extra Dist.");
        valve_ed->down_box(FL_BORDER_BOX);
        valve_ed->labelsize(10);
        valve_ed->labelcolor(FL_BACKGROUND2_COLOR);
        valve_ed->callback((Fl_Callback*)cb_valve_ed, (void*)(2));
      } // Fl_Check_Button* valve_ed
      { valve_Q = new SliderW(373, 323, 100, 10, "Dist.");
        valve_Q->type(5);
        valve_Q->box(FL_FLAT_BOX);
        valve_Q->color((Fl_Color)178);
        valve_Q->selection_color((Fl_Color)62);
        valve_Q->labeltype(FL_NORMAL_LABEL);
        valve_Q->labelfont(0);
        valve_Q->labelsize(10);
        valve_Q->labelcolor(FL_BACKGROUND2_COLOR);
        valve_Q->maximum(127);
        valve_Q->step(1);
        valve_Q->textcolor(7);
        valve_Q->callback((Fl_Callback*)cb_valve_Q);
        valve_Q->align(FL_ALIGN_LEFT);
        valve_Q->when(FL_WHEN_CHANGED);
      } // SliderW* valve_Q
      { valve_Pre = new SliderW(373, 338, 100, 10, "Presence");
        valve_Pre->type(5);
        valve_Pre->box(FL_FLAT_BOX);
        valve_Pre->color((Fl_Color)178);
        valve_Pre->selection_color((Fl_Color)62);
        valve_Pre->labeltype(FL_NORMAL_LABEL);
        valve_Pre->labelfont(0);
        valve_Pre->labelsize(10);
        valve_Pre->labelcolor(FL_BACKGROUND2_COLOR);
        valve_Pre->maximum(100);
        valve_Pre->step(1);
        valve_Pre->textcolor(7);
        valve_Pre->callback((Fl_Callback*)cb_valve_Pre);
        valve_Pre->align(FL_ALIGN_LEFT);
        valve_Pre->when(FL_WHEN_CHANGED);
      } // SliderW* valve_Pre
      { valve_pf = new Fl_Check_Button(325, 350, 15, 15, "Pre Filter");
        valve_pf->down_box(FL_BORDER_BOX);
        valve_pf->labelsize(10);
        valve_pf->labelcolor(FL_BACKGROUND2_COLOR);
        valve_pf->callback((Fl_Callback*)cb_valve_pf, (void*)(2));
      } // Fl_Check_Button* valve_pf
      { valve_st = new Fl_Check_Button(385, 350, 15, 15, "Stereo");
        valve_st->down_box(FL_BORDER_BOX);
        valve_st->labelsize(10);
        valve_st->labelcolor(FL_BACKGROUND2_COLOR);
        valve_st->callback((Fl_Callback*)cb_valve_st, (void*)(2));
      } // Fl_Check_Button* valve_st
      { valve_neg = new Fl_Check_Button(434, 350, 15, 15, "Neg.");
        valve_neg->down_box(FL_BORDER_BOX);
        valve_neg->labelsize(10);
        valve_neg->labelcolor(FL_BACKGROUND2_COLOR);
        valve_neg->callback((Fl_Callback*)cb_valve_neg, (void*)(2));
      } // Fl_Check_Button* valve_neg
      { valve_lpf = new SliderW(373, 367, 100, 10, "LPF");
        valve_lpf->type(5);
        valve_lpf->box(FL_FLAT_BOX);
        valve_lpf->color((Fl_Color)178);
        valve_lpf->selection_color((Fl_Color)62);
        valve_lpf->labeltype(FL_NORMAL_LABEL);
        valve_lpf->labelfont(0);
        valve_lpf->labelsize(10);
        valve_lpf->labelcolor(FL_BACKGROUND2_COLOR);
        valve_lpf->minimum(20);
        valve_lpf->maximum(26000);
        valve_lpf->step(1);
        valve_lpf->value(20000);
        valve_lpf->textcolor(7);
        valve_lpf->callback((Fl_Callback*)cb_valve_lpf);
        valve_lpf->align(FL_ALIGN_LEFT);
        valve_lpf->when(FL_WHEN_CHANGED);
      } // SliderW* valve_lpf
      { valve_hpf = new SliderW(373, 380, 100, 10, "HPF");
        valve_hpf->type(5);
        valve_hpf->box(FL_FLAT_BOX);
        valve_hpf->color((Fl_Color)178);
        valve_hpf->selection_color((Fl_Color)62);
        valve_hpf->labeltype(FL_NORMAL_LABEL);
        valve_hpf->labelfont(0);
        valve_hpf->labelsize(10);
        valve_hpf->labelcolor(FL_BACKGROUND2_COLOR);
        valve_hpf->minimum(20);
        valve_hpf->maximum(20000);
        valve_hpf->step(1);
        valve_hpf->value(20);
        valve_hpf->textcolor(7);
        valve_hpf->callback((Fl_Callback*)cb_valve_hpf);
        valve_hpf->align(FL_ALIGN_LEFT);
        valve_hpf->when(FL_WHEN_CHANGED);
      } // SliderW* valve_hpf
      VALVE->end();
    } // Fl_Group* VALVE
    { DFLANGE = new Fl_Group(320, 211, 158, 184);
      DFLANGE->box(FL_UP_BOX);
      DFLANGE->color(FL_FOREGROUND_COLOR);
      DFLANGE->selection_color(FL_FOREGROUND_COLOR);
      DFLANGE->labelfont(1);
      DFLANGE->user_data((void*)(1));
      DFLANGE->align(96|FL_ALIGN_INSIDE);
      DFLANGE->hide();
      { dflange_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        dflange_activar->shortcut(0x38);
        dflange_activar->color((Fl_Color)62);
        dflange_activar->selection_color((Fl_Color)1);
        dflange_activar->labelsize(10);
        dflange_activar->callback((Fl_Callback*)cb_dflange_activar, (void*)(2));
        dflange_activar->align(68|FL_ALIGN_INSIDE);
        dflange_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* dflange_activar
      { dflange_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        dflange_preset->down_box(FL_BORDER_BOX);
        dflange_preset->selection_color(FL_FOREGROUND_COLOR);
        dflange_preset->labelsize(10);
        dflange_preset->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_preset->textsize(10);
        dflange_preset->textcolor(7);
        dflange_preset->callback((Fl_Callback*)cb_dflange_preset, (void*)(12020));
        dflange_preset->when(FL_WHEN_RELEASE_ALWAYS);
        dflange_preset->menu(menu_dflange_preset);
      } // Fl_Choice* dflange_preset
      { dflange_WD = new SliderW(372, 235, 100, 10, "Wet/Dry");
        dflange_WD->type(5);
        dflange_WD->box(FL_FLAT_BOX);
        dflange_WD->color((Fl_Color)178);
        dflange_WD->selection_color((Fl_Color)62);
        dflange_WD->labeltype(FL_NORMAL_LABEL);
        dflange_WD->labelfont(0);
        dflange_WD->labelsize(10);
        dflange_WD->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_WD->minimum(-64);
        dflange_WD->maximum(64);
        dflange_WD->step(1);
        dflange_WD->textcolor(7);
        dflange_WD->callback((Fl_Callback*)cb_dflange_WD);
        dflange_WD->align(FL_ALIGN_LEFT);
        dflange_WD->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_WD
      { dflange_pan = new SliderW(372, 246, 100, 10, "Pan");
        dflange_pan->type(5);
        dflange_pan->box(FL_FLAT_BOX);
        dflange_pan->color((Fl_Color)178);
        dflange_pan->selection_color((Fl_Color)62);
        dflange_pan->labeltype(FL_NORMAL_LABEL);
        dflange_pan->labelfont(0);
        dflange_pan->labelsize(10);
        dflange_pan->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_pan->minimum(-64);
        dflange_pan->maximum(64);
        dflange_pan->step(1);
        dflange_pan->textcolor(7);
        dflange_pan->callback((Fl_Callback*)cb_dflange_pan);
        dflange_pan->align(FL_ALIGN_LEFT);
        dflange_pan->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_pan
      { dflange_LR = new SliderW(372, 257, 100, 10, "L/R.Cr");
        dflange_LR->type(5);
        dflange_LR->box(FL_FLAT_BOX);
        dflange_LR->color((Fl_Color)178);
        dflange_LR->selection_color((Fl_Color)62);
        dflange_LR->labeltype(FL_NORMAL_LABEL);
        dflange_LR->labelfont(0);
        dflange_LR->labelsize(10);
        dflange_LR->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_LR->maximum(127);
        dflange_LR->step(1);
        dflange_LR->textcolor(7);
        dflange_LR->callback((Fl_Callback*)cb_dflange_LR);
        dflange_LR->align(FL_ALIGN_LEFT);
        dflange_LR->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_LR
      { dflange_depth = new SliderW(372, 268, 100, 10, "Depth");
        dflange_depth->type(5);
        dflange_depth->box(FL_FLAT_BOX);
        dflange_depth->color((Fl_Color)178);
        dflange_depth->selection_color((Fl_Color)62);
        dflange_depth->labeltype(FL_NORMAL_LABEL);
        dflange_depth->labelfont(0);
        dflange_depth->labelsize(10);
        dflange_depth->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_depth->minimum(20);
        dflange_depth->maximum(500);
        dflange_depth->step(1);
        dflange_depth->value(20);
        dflange_depth->textcolor(7);
        dflange_depth->callback((Fl_Callback*)cb_dflange_depth);
        dflange_depth->align(FL_ALIGN_LEFT);
        dflange_depth->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_depth
      { dflange_width = new SliderW(372, 280, 100, 10, "Width");
        dflange_width->type(5);
        dflange_width->box(FL_FLAT_BOX);
        dflange_width->color((Fl_Color)178);
        dflange_width->selection_color((Fl_Color)62);
        dflange_width->labeltype(FL_NORMAL_LABEL);
        dflange_width->labelfont(0);
        dflange_width->labelsize(10);
        dflange_width->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_width->maximum(3000);
        dflange_width->step(1);
        dflange_width->textcolor(7);
        dflange_width->callback((Fl_Callback*)cb_dflange_width);
        dflange_width->align(FL_ALIGN_LEFT);
        dflange_width->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_width
      { dflange_offset = new SliderW(372, 291, 100, 10, "Offset");
        dflange_offset->type(5);
        dflange_offset->box(FL_FLAT_BOX);
        dflange_offset->color((Fl_Color)178);
        dflange_offset->selection_color((Fl_Color)62);
        dflange_offset->labeltype(FL_NORMAL_LABEL);
        dflange_offset->labelfont(0);
        dflange_offset->labelsize(10);
        dflange_offset->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_offset->maximum(100);
        dflange_offset->step(1);
        dflange_offset->textcolor(7);
        dflange_offset->callback((Fl_Callback*)cb_dflange_offset);
        dflange_offset->align(FL_ALIGN_LEFT);
        dflange_offset->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_offset
      { dflange_fb = new SliderW(372, 302, 100, 10, "Fb");
        dflange_fb->type(5);
        dflange_fb->box(FL_FLAT_BOX);
        dflange_fb->color((Fl_Color)178);
        dflange_fb->selection_color((Fl_Color)62);
        dflange_fb->labeltype(FL_NORMAL_LABEL);
        dflange_fb->labelfont(0);
        dflange_fb->labelsize(10);
        dflange_fb->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_fb->minimum(-64);
        dflange_fb->maximum(64);
        dflange_fb->step(1);
        dflange_fb->textcolor(7);
        dflange_fb->callback((Fl_Callback*)cb_dflange_fb);
        dflange_fb->align(FL_ALIGN_LEFT);
        dflange_fb->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_fb
      { dflange_lpf = new SliderW(372, 313, 100, 10, "LPF");
        dflange_lpf->type(5);
        dflange_lpf->box(FL_FLAT_BOX);
        dflange_lpf->color((Fl_Color)178);
        dflange_lpf->selection_color((Fl_Color)62);
        dflange_lpf->labeltype(FL_NORMAL_LABEL);
        dflange_lpf->labelfont(0);
        dflange_lpf->labelsize(10);
        dflange_lpf->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_lpf->minimum(20);
        dflange_lpf->maximum(20000);
        dflange_lpf->step(1);
        dflange_lpf->value(20);
        dflange_lpf->textcolor(7);
        dflange_lpf->callback((Fl_Callback*)cb_dflange_lpf);
        dflange_lpf->align(FL_ALIGN_LEFT);
        dflange_lpf->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_lpf
      { dflange_subs = new Fl_Check_Button(332, 324, 15, 15, "Subtract");
        dflange_subs->down_box(FL_BORDER_BOX);
        dflange_subs->labelsize(10);
        dflange_subs->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_subs->callback((Fl_Callback*)cb_dflange_subs, (void*)(2));
      } // Fl_Check_Button* dflange_subs
      { dflange_tz = new Fl_Check_Button(395, 324, 15, 15, "Th. zero");
        dflange_tz->down_box(FL_BORDER_BOX);
        dflange_tz->labelsize(10);
        dflange_tz->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_tz->callback((Fl_Callback*)cb_dflange_tz, (void*)(2));
      } // Fl_Check_Button* dflange_tz
      { dflange_freq = new SliderW(372, 339, 100, 10, "Tempo");
        dflange_freq->type(5);
        dflange_freq->box(FL_FLAT_BOX);
        dflange_freq->color((Fl_Color)178);
        dflange_freq->selection_color((Fl_Color)62);
        dflange_freq->labeltype(FL_NORMAL_LABEL);
        dflange_freq->labelfont(0);
        dflange_freq->labelsize(10);
        dflange_freq->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_freq->minimum(1);
        dflange_freq->maximum(600);
        dflange_freq->step(1);
        dflange_freq->value(100);
        dflange_freq->textcolor(7);
        dflange_freq->callback((Fl_Callback*)cb_dflange_freq);
        dflange_freq->align(FL_ALIGN_LEFT);
        dflange_freq->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_freq
      { dflange_stdf = new SliderW(372, 351, 100, 10, "St.df");
        dflange_stdf->type(5);
        dflange_stdf->box(FL_FLAT_BOX);
        dflange_stdf->color((Fl_Color)178);
        dflange_stdf->selection_color((Fl_Color)62);
        dflange_stdf->labeltype(FL_NORMAL_LABEL);
        dflange_stdf->labelfont(0);
        dflange_stdf->labelsize(10);
        dflange_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_stdf->maximum(127);
        dflange_stdf->step(1);
        dflange_stdf->textcolor(7);
        dflange_stdf->callback((Fl_Callback*)cb_dflange_stdf);
        dflange_stdf->align(FL_ALIGN_LEFT);
        dflange_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_stdf
      { Fl_Choice* o = dflange_lfotype = new Fl_Choice(383, 364, 72, 15, "LFO Type");
        dflange_lfotype->down_box(FL_BORDER_BOX);
        dflange_lfotype->selection_color(FL_FOREGROUND_COLOR);
        dflange_lfotype->labelsize(10);
        dflange_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_lfotype->textsize(10);
        dflange_lfotype->textcolor(7);
        dflange_lfotype->callback((Fl_Callback*)cb_dflange_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* dflange_lfotype
      { dflange_rnd = new SliderW(372, 381, 100, 10, "Rnd");
        dflange_rnd->type(5);
        dflange_rnd->box(FL_FLAT_BOX);
        dflange_rnd->color((Fl_Color)178);
        dflange_rnd->selection_color((Fl_Color)62);
        dflange_rnd->labeltype(FL_NORMAL_LABEL);
        dflange_rnd->labelfont(0);
        dflange_rnd->labelsize(10);
        dflange_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        dflange_rnd->maximum(127);
        dflange_rnd->step(1);
        dflange_rnd->textcolor(7);
        dflange_rnd->callback((Fl_Callback*)cb_dflange_rnd);
        dflange_rnd->align(FL_ALIGN_LEFT);
        dflange_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* dflange_rnd
      DFLANGE->end();
    } // Fl_Group* DFLANGE
    { RING = new Fl_Group(320, 211, 158, 184);
      RING->box(FL_UP_BOX);
      RING->color(FL_FOREGROUND_COLOR);
      RING->selection_color(FL_FOREGROUND_COLOR);
      RING->labelfont(1);
      RING->user_data((void*)(1));
      RING->align(96|FL_ALIGN_INSIDE);
      RING->hide();
      { ring_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        ring_activar->shortcut(0x34);
        ring_activar->color((Fl_Color)62);
        ring_activar->selection_color((Fl_Color)1);
        ring_activar->labelsize(10);
        ring_activar->callback((Fl_Callback*)cb_ring_activar, (void*)(2));
        ring_activar->align(68|FL_ALIGN_INSIDE);
        ring_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* ring_activar
      { ring_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        ring_preset->down_box(FL_BORDER_BOX);
        ring_preset->selection_color(FL_FOREGROUND_COLOR);
        ring_preset->labelsize(10);
        ring_preset->labelcolor(FL_BACKGROUND2_COLOR);
        ring_preset->textsize(10);
        ring_preset->textcolor(7);
        ring_preset->callback((Fl_Callback*)cb_ring_preset, (void*)(12021));
        ring_preset->when(FL_WHEN_RELEASE_ALWAYS);
        ring_preset->menu(menu_ring_preset);
      } // Fl_Choice* ring_preset
      { ring_WD = new SliderW(371, 240, 100, 10, "Wet/Dry");
        ring_WD->type(5);
        ring_WD->box(FL_FLAT_BOX);
        ring_WD->color((Fl_Color)178);
        ring_WD->selection_color((Fl_Color)62);
        ring_WD->labeltype(FL_NORMAL_LABEL);
        ring_WD->labelfont(0);
        ring_WD->labelsize(10);
        ring_WD->labelcolor(FL_BACKGROUND2_COLOR);
        ring_WD->minimum(-64);
        ring_WD->maximum(64);
        ring_WD->step(1);
        ring_WD->textcolor(7);
        ring_WD->callback((Fl_Callback*)cb_ring_WD);
        ring_WD->align(FL_ALIGN_LEFT);
        ring_WD->when(FL_WHEN_CHANGED);
      } // SliderW* ring_WD
      { ring_LRc = new SliderW(371, 253, 100, 10, "L/R Cr.");
        ring_LRc->type(5);
        ring_LRc->box(FL_FLAT_BOX);
        ring_LRc->color((Fl_Color)178);
        ring_LRc->selection_color((Fl_Color)62);
        ring_LRc->labeltype(FL_NORMAL_LABEL);
        ring_LRc->labelfont(0);
        ring_LRc->labelsize(10);
        ring_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        ring_LRc->minimum(-64);
        ring_LRc->maximum(64);
        ring_LRc->step(1);
        ring_LRc->textcolor(7);
        ring_LRc->callback((Fl_Callback*)cb_ring_LRc);
        ring_LRc->align(FL_ALIGN_LEFT);
        ring_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* ring_LRc
      { ring_input = new SliderW(371, 266, 100, 10, "Input");
        ring_input->type(5);
        ring_input->box(FL_FLAT_BOX);
        ring_input->color((Fl_Color)178);
        ring_input->selection_color((Fl_Color)62);
        ring_input->labeltype(FL_NORMAL_LABEL);
        ring_input->labelfont(0);
        ring_input->labelsize(10);
        ring_input->labelcolor(FL_BACKGROUND2_COLOR);
        ring_input->minimum(1);
        ring_input->maximum(127);
        ring_input->step(1);
        ring_input->value(1);
        ring_input->textcolor(7);
        ring_input->callback((Fl_Callback*)cb_ring_input);
        ring_input->align(FL_ALIGN_LEFT);
        ring_input->when(FL_WHEN_CHANGED);
      } // SliderW* ring_input
      { ring_level = new SliderW(371, 279, 100, 10, "Level");
        ring_level->type(5);
        ring_level->box(FL_FLAT_BOX);
        ring_level->color((Fl_Color)178);
        ring_level->selection_color((Fl_Color)62);
        ring_level->labeltype(FL_NORMAL_LABEL);
        ring_level->labelfont(0);
        ring_level->labelsize(10);
        ring_level->labelcolor(FL_BACKGROUND2_COLOR);
        ring_level->maximum(127);
        ring_level->step(1);
        ring_level->textcolor(7);
        ring_level->callback((Fl_Callback*)cb_ring_level);
        ring_level->align(FL_ALIGN_LEFT);
        ring_level->when(FL_WHEN_CHANGED);
      } // SliderW* ring_level
      { ring_pan = new SliderW(371, 292, 100, 10, "Pan");
        ring_pan->type(5);
        ring_pan->box(FL_FLAT_BOX);
        ring_pan->color((Fl_Color)178);
        ring_pan->selection_color((Fl_Color)62);
        ring_pan->labeltype(FL_NORMAL_LABEL);
        ring_pan->labelfont(0);
        ring_pan->labelsize(10);
        ring_pan->labelcolor(FL_BACKGROUND2_COLOR);
        ring_pan->minimum(-64);
        ring_pan->maximum(64);
        ring_pan->step(1);
        ring_pan->textcolor(7);
        ring_pan->callback((Fl_Callback*)cb_ring_pan);
        ring_pan->align(FL_ALIGN_LEFT);
        ring_pan->when(FL_WHEN_CHANGED);
      } // SliderW* ring_pan
      { ring_st = new Fl_Check_Button(348, 303, 15, 15, "Stereo");
        ring_st->down_box(FL_BORDER_BOX);
        ring_st->labelsize(10);
        ring_st->labelcolor(FL_BACKGROUND2_COLOR);
        ring_st->callback((Fl_Callback*)cb_ring_st, (void*)(2));
      } // Fl_Check_Button* ring_st
      { ring_afreq = new Fl_Check_Button(400, 303, 15, 15, "Auto Freq");
        ring_afreq->down_box(FL_BORDER_BOX);
        ring_afreq->labelsize(10);
        ring_afreq->labelcolor(FL_BACKGROUND2_COLOR);
        ring_afreq->callback((Fl_Callback*)cb_ring_afreq, (void*)(2));
      } // Fl_Check_Button* ring_afreq
      { ring_depth = new SliderW(371, 317, 100, 10, "Depth");
        ring_depth->type(5);
        ring_depth->box(FL_FLAT_BOX);
        ring_depth->color((Fl_Color)178);
        ring_depth->selection_color((Fl_Color)62);
        ring_depth->labeltype(FL_NORMAL_LABEL);
        ring_depth->labelfont(0);
        ring_depth->labelsize(10);
        ring_depth->labelcolor(FL_BACKGROUND2_COLOR);
        ring_depth->maximum(100);
        ring_depth->step(1);
        ring_depth->textcolor(7);
        ring_depth->callback((Fl_Callback*)cb_ring_depth);
        ring_depth->align(FL_ALIGN_LEFT);
        ring_depth->when(FL_WHEN_CHANGED);
      } // SliderW* ring_depth
      { ring_freq = new SliderW(371, 329, 100, 10, "Freq");
        ring_freq->type(5);
        ring_freq->box(FL_FLAT_BOX);
        ring_freq->color((Fl_Color)178);
        ring_freq->selection_color((Fl_Color)62);
        ring_freq->labeltype(FL_NORMAL_LABEL);
        ring_freq->labelfont(0);
        ring_freq->labelsize(10);
        ring_freq->labelcolor(FL_BACKGROUND2_COLOR);
        ring_freq->minimum(1);
        ring_freq->maximum(20000);
        ring_freq->step(10);
        ring_freq->textcolor(7);
        ring_freq->callback((Fl_Callback*)cb_ring_freq);
        ring_freq->align(FL_ALIGN_LEFT);
        ring_freq->when(FL_WHEN_CHANGED);
      } // SliderW* ring_freq
      { ring_sin = new SliderW(371, 341, 100, 10, "Sin");
        ring_sin->type(5);
        ring_sin->box(FL_FLAT_BOX);
        ring_sin->color((Fl_Color)178);
        ring_sin->selection_color((Fl_Color)62);
        ring_sin->labeltype(FL_NORMAL_LABEL);
        ring_sin->labelfont(0);
        ring_sin->labelsize(10);
        ring_sin->labelcolor(FL_BACKGROUND2_COLOR);
        ring_sin->maximum(100);
        ring_sin->step(1);
        ring_sin->textcolor(7);
        ring_sin->callback((Fl_Callback*)cb_ring_sin);
        ring_sin->align(FL_ALIGN_LEFT);
        ring_sin->when(FL_WHEN_CHANGED);
      } // SliderW* ring_sin
      { ring_tri = new SliderW(371, 353, 100, 10, "Tri");
        ring_tri->type(5);
        ring_tri->box(FL_FLAT_BOX);
        ring_tri->color((Fl_Color)178);
        ring_tri->selection_color((Fl_Color)62);
        ring_tri->labeltype(FL_NORMAL_LABEL);
        ring_tri->labelfont(0);
        ring_tri->labelsize(10);
        ring_tri->labelcolor(FL_BACKGROUND2_COLOR);
        ring_tri->maximum(100);
        ring_tri->step(1);
        ring_tri->textcolor(7);
        ring_tri->callback((Fl_Callback*)cb_ring_tri);
        ring_tri->align(FL_ALIGN_LEFT);
        ring_tri->when(FL_WHEN_CHANGED);
      } // SliderW* ring_tri
      { ring_saw = new SliderW(371, 365, 100, 10, "Saw");
        ring_saw->type(5);
        ring_saw->box(FL_FLAT_BOX);
        ring_saw->color((Fl_Color)178);
        ring_saw->selection_color((Fl_Color)62);
        ring_saw->labeltype(FL_NORMAL_LABEL);
        ring_saw->labelfont(0);
        ring_saw->labelsize(10);
        ring_saw->labelcolor(FL_BACKGROUND2_COLOR);
        ring_saw->maximum(100);
        ring_saw->step(1);
        ring_saw->textcolor(7);
        ring_saw->callback((Fl_Callback*)cb_ring_saw);
        ring_saw->align(FL_ALIGN_LEFT);
        ring_saw->when(FL_WHEN_CHANGED);
      } // SliderW* ring_saw
      { ring_squ = new SliderW(371, 378, 100, 10, "Squ");
        ring_squ->type(5);
        ring_squ->box(FL_FLAT_BOX);
        ring_squ->color((Fl_Color)178);
        ring_squ->selection_color((Fl_Color)62);
        ring_squ->labeltype(FL_NORMAL_LABEL);
        ring_squ->labelfont(0);
        ring_squ->labelsize(10);
        ring_squ->labelcolor(FL_BACKGROUND2_COLOR);
        ring_squ->maximum(100);
        ring_squ->step(1);
        ring_squ->textcolor(7);
        ring_squ->callback((Fl_Callback*)cb_ring_squ);
        ring_squ->align(FL_ALIGN_LEFT);
        ring_squ->when(FL_WHEN_CHANGED);
      } // SliderW* ring_squ
      RING->end();
    } // Fl_Group* RING
    { EXCITER = new Fl_Group(320, 211, 158, 184);
      EXCITER->box(FL_UP_BOX);
      EXCITER->color(FL_FOREGROUND_COLOR);
      EXCITER->selection_color(FL_FOREGROUND_COLOR);
      EXCITER->labelfont(1);
      EXCITER->user_data((void*)(1));
      EXCITER->align(96|FL_ALIGN_INSIDE);
      EXCITER->hide();
      { exciter_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        exciter_activar->shortcut(0x31);
        exciter_activar->color((Fl_Color)62);
        exciter_activar->selection_color((Fl_Color)1);
        exciter_activar->labelsize(10);
        exciter_activar->callback((Fl_Callback*)cb_exciter_activar, (void*)(2));
        exciter_activar->align(68|FL_ALIGN_INSIDE);
        exciter_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* exciter_activar
      { exciter_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        exciter_preset->down_box(FL_BORDER_BOX);
        exciter_preset->selection_color(FL_FOREGROUND_COLOR);
        exciter_preset->labelsize(10);
        exciter_preset->labelcolor(FL_BACKGROUND2_COLOR);
        exciter_preset->textsize(10);
        exciter_preset->textcolor(7);
        exciter_preset->callback((Fl_Callback*)cb_exciter_preset, (void*)(12022));
        exciter_preset->when(FL_WHEN_RELEASE_ALWAYS);
        exciter_preset->menu(menu_exciter_preset);
      } // Fl_Choice* exciter_preset
      { ex_Gain = new SliderW(369, 236, 100, 10, "Gain");
        ex_Gain->type(5);
        ex_Gain->box(FL_FLAT_BOX);
        ex_Gain->color((Fl_Color)178);
        ex_Gain->selection_color((Fl_Color)62);
        ex_Gain->labeltype(FL_NORMAL_LABEL);
        ex_Gain->labelfont(0);
        ex_Gain->labelsize(10);
        ex_Gain->labelcolor(FL_BACKGROUND2_COLOR);
        ex_Gain->maximum(127);
        ex_Gain->step(1);
        ex_Gain->textcolor(7);
        ex_Gain->callback((Fl_Callback*)cb_ex_Gain);
        ex_Gain->align(FL_ALIGN_LEFT);
        ex_Gain->when(FL_WHEN_CHANGED);
      } // SliderW* ex_Gain
      { ex_lfreq = new SliderW(369, 248, 100, 10, "LPF");
        ex_lfreq->type(5);
        ex_lfreq->box(FL_FLAT_BOX);
        ex_lfreq->color((Fl_Color)178);
        ex_lfreq->selection_color((Fl_Color)62);
        ex_lfreq->labeltype(FL_NORMAL_LABEL);
        ex_lfreq->labelfont(0);
        ex_lfreq->labelsize(10);
        ex_lfreq->labelcolor(FL_BACKGROUND2_COLOR);
        ex_lfreq->minimum(20);
        ex_lfreq->maximum(26000);
        ex_lfreq->step(1);
        ex_lfreq->value(20000);
        ex_lfreq->textcolor(7);
        ex_lfreq->callback((Fl_Callback*)cb_ex_lfreq);
        ex_lfreq->align(FL_ALIGN_LEFT);
        ex_lfreq->when(FL_WHEN_CHANGED);
      } // SliderW* ex_lfreq
      { ex_hfreq = new SliderW(369, 260, 100, 10, "HPF");
        ex_hfreq->type(5);
        ex_hfreq->box(FL_FLAT_BOX);
        ex_hfreq->color((Fl_Color)178);
        ex_hfreq->selection_color((Fl_Color)62);
        ex_hfreq->labeltype(FL_NORMAL_LABEL);
        ex_hfreq->labelfont(0);
        ex_hfreq->labelsize(10);
        ex_hfreq->labelcolor(FL_BACKGROUND2_COLOR);
        ex_hfreq->minimum(20);
        ex_hfreq->maximum(20000);
        ex_hfreq->step(1);
        ex_hfreq->value(20);
        ex_hfreq->textcolor(7);
        ex_hfreq->callback((Fl_Callback*)cb_ex_hfreq);
        ex_hfreq->align(FL_ALIGN_LEFT);
        ex_hfreq->when(FL_WHEN_CHANGED);
      } // SliderW* ex_hfreq
      { ex_1 = new SliderW(369, 272, 100, 10, "Har 1");
        ex_1->type(5);
        ex_1->box(FL_FLAT_BOX);
        ex_1->color((Fl_Color)178);
        ex_1->selection_color((Fl_Color)62);
        ex_1->labeltype(FL_NORMAL_LABEL);
        ex_1->labelfont(0);
        ex_1->labelsize(10);
        ex_1->labelcolor(FL_BACKGROUND2_COLOR);
        ex_1->minimum(-64);
        ex_1->maximum(64);
        ex_1->step(1);
        ex_1->textcolor(7);
        ex_1->callback((Fl_Callback*)cb_ex_1);
        ex_1->align(FL_ALIGN_LEFT);
        ex_1->when(FL_WHEN_CHANGED);
      } // SliderW* ex_1
      { ex_2 = new SliderW(369, 284, 100, 10, "Har 2");
        ex_2->type(5);
        ex_2->box(FL_FLAT_BOX);
        ex_2->color((Fl_Color)178);
        ex_2->selection_color((Fl_Color)62);
        ex_2->labeltype(FL_NORMAL_LABEL);
        ex_2->labelfont(0);
        ex_2->labelsize(10);
        ex_2->labelcolor(FL_BACKGROUND2_COLOR);
        ex_2->minimum(-64);
        ex_2->maximum(64);
        ex_2->step(1);
        ex_2->textcolor(7);
        ex_2->callback((Fl_Callback*)cb_ex_2);
        ex_2->align(FL_ALIGN_LEFT);
        ex_2->when(FL_WHEN_CHANGED);
      } // SliderW* ex_2
      { ex_3 = new SliderW(369, 296, 100, 10, "Har 3");
        ex_3->type(5);
        ex_3->box(FL_FLAT_BOX);
        ex_3->color((Fl_Color)178);
        ex_3->selection_color((Fl_Color)62);
        ex_3->labeltype(FL_NORMAL_LABEL);
        ex_3->labelfont(0);
        ex_3->labelsize(10);
        ex_3->labelcolor(FL_BACKGROUND2_COLOR);
        ex_3->minimum(-64);
        ex_3->maximum(64);
        ex_3->step(1);
        ex_3->textcolor(7);
        ex_3->callback((Fl_Callback*)cb_ex_3);
        ex_3->align(FL_ALIGN_LEFT);
        ex_3->when(FL_WHEN_CHANGED);
      } // SliderW* ex_3
      { ex_4 = new SliderW(369, 308, 100, 10, "Har 4");
        ex_4->type(5);
        ex_4->box(FL_FLAT_BOX);
        ex_4->color((Fl_Color)178);
        ex_4->selection_color((Fl_Color)62);
        ex_4->labeltype(FL_NORMAL_LABEL);
        ex_4->labelfont(0);
        ex_4->labelsize(10);
        ex_4->labelcolor(FL_BACKGROUND2_COLOR);
        ex_4->minimum(-64);
        ex_4->maximum(64);
        ex_4->step(1);
        ex_4->textcolor(7);
        ex_4->callback((Fl_Callback*)cb_ex_4);
        ex_4->align(FL_ALIGN_LEFT);
        ex_4->when(FL_WHEN_CHANGED);
      } // SliderW* ex_4
      { ex_5 = new SliderW(369, 320, 100, 10, "Har 5");
        ex_5->type(5);
        ex_5->box(FL_FLAT_BOX);
        ex_5->color((Fl_Color)178);
        ex_5->selection_color((Fl_Color)62);
        ex_5->labeltype(FL_NORMAL_LABEL);
        ex_5->labelfont(0);
        ex_5->labelsize(10);
        ex_5->labelcolor(FL_BACKGROUND2_COLOR);
        ex_5->minimum(-64);
        ex_5->maximum(64);
        ex_5->step(1);
        ex_5->textcolor(7);
        ex_5->callback((Fl_Callback*)cb_ex_5);
        ex_5->align(FL_ALIGN_LEFT);
        ex_5->when(FL_WHEN_CHANGED);
      } // SliderW* ex_5
      { ex_6 = new SliderW(369, 332, 100, 10, "Har 6");
        ex_6->type(5);
        ex_6->box(FL_FLAT_BOX);
        ex_6->color((Fl_Color)178);
        ex_6->selection_color((Fl_Color)62);
        ex_6->labeltype(FL_NORMAL_LABEL);
        ex_6->labelfont(0);
        ex_6->labelsize(10);
        ex_6->labelcolor(FL_BACKGROUND2_COLOR);
        ex_6->minimum(-64);
        ex_6->maximum(64);
        ex_6->step(1);
        ex_6->textcolor(7);
        ex_6->callback((Fl_Callback*)cb_ex_6);
        ex_6->align(FL_ALIGN_LEFT);
        ex_6->when(FL_WHEN_CHANGED);
      } // SliderW* ex_6
      { ex_7 = new SliderW(369, 345, 100, 10, "Har 7");
        ex_7->type(5);
        ex_7->box(FL_FLAT_BOX);
        ex_7->color((Fl_Color)178);
        ex_7->selection_color((Fl_Color)62);
        ex_7->labeltype(FL_NORMAL_LABEL);
        ex_7->labelfont(0);
        ex_7->labelsize(10);
        ex_7->labelcolor(FL_BACKGROUND2_COLOR);
        ex_7->minimum(-64);
        ex_7->maximum(64);
        ex_7->step(1);
        ex_7->textcolor(7);
        ex_7->callback((Fl_Callback*)cb_ex_7);
        ex_7->align(FL_ALIGN_LEFT);
        ex_7->when(FL_WHEN_CHANGED);
      } // SliderW* ex_7
      { ex_8 = new SliderW(369, 357, 100, 10, "Har 8");
        ex_8->type(5);
        ex_8->box(FL_FLAT_BOX);
        ex_8->color((Fl_Color)178);
        ex_8->selection_color((Fl_Color)62);
        ex_8->labeltype(FL_NORMAL_LABEL);
        ex_8->labelfont(0);
        ex_8->labelsize(10);
        ex_8->labelcolor(FL_BACKGROUND2_COLOR);
        ex_8->minimum(-64);
        ex_8->maximum(64);
        ex_8->step(1);
        ex_8->textcolor(7);
        ex_8->callback((Fl_Callback*)cb_ex_8);
        ex_8->align(FL_ALIGN_LEFT);
        ex_8->when(FL_WHEN_CHANGED);
      } // SliderW* ex_8
      { ex_9 = new SliderW(369, 369, 100, 10, "Har 9");
        ex_9->type(5);
        ex_9->box(FL_FLAT_BOX);
        ex_9->color((Fl_Color)178);
        ex_9->selection_color((Fl_Color)62);
        ex_9->labeltype(FL_NORMAL_LABEL);
        ex_9->labelfont(0);
        ex_9->labelsize(10);
        ex_9->labelcolor(FL_BACKGROUND2_COLOR);
        ex_9->minimum(-64);
        ex_9->maximum(64);
        ex_9->step(1);
        ex_9->textcolor(7);
        ex_9->callback((Fl_Callback*)cb_ex_9);
        ex_9->align(FL_ALIGN_LEFT);
        ex_9->when(FL_WHEN_CHANGED);
      } // SliderW* ex_9
      { ex_10 = new SliderW(369, 380, 100, 10, "Har 10");
        ex_10->type(5);
        ex_10->box(FL_FLAT_BOX);
        ex_10->color((Fl_Color)178);
        ex_10->selection_color((Fl_Color)62);
        ex_10->labeltype(FL_NORMAL_LABEL);
        ex_10->labelfont(0);
        ex_10->labelsize(10);
        ex_10->labelcolor(FL_BACKGROUND2_COLOR);
        ex_10->minimum(-64);
        ex_10->maximum(64);
        ex_10->step(1);
        ex_10->textcolor(7);
        ex_10->callback((Fl_Callback*)cb_ex_10);
        ex_10->align(FL_ALIGN_LEFT);
        ex_10->when(FL_WHEN_CHANGED);
      } // SliderW* ex_10
      EXCITER->end();
    } // Fl_Group* EXCITER
    { MBDIST = new Fl_Group(320, 211, 158, 184);
      MBDIST->box(FL_UP_BOX);
      MBDIST->color(FL_FOREGROUND_COLOR);
      MBDIST->selection_color(FL_FOREGROUND_COLOR);
      MBDIST->labelfont(1);
      MBDIST->user_data((void*)(1));
      MBDIST->align(96|FL_ALIGN_INSIDE);
      MBDIST->hide();
      { mbdist_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        mbdist_activar->shortcut(0x33);
        mbdist_activar->color((Fl_Color)62);
        mbdist_activar->selection_color((Fl_Color)1);
        mbdist_activar->labelsize(10);
        mbdist_activar->callback((Fl_Callback*)cb_mbdist_activar, (void*)(2));
        mbdist_activar->align(68|FL_ALIGN_INSIDE);
        mbdist_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* mbdist_activar
      { mbdist_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        mbdist_preset->down_box(FL_BORDER_BOX);
        mbdist_preset->selection_color(FL_FOREGROUND_COLOR);
        mbdist_preset->labelsize(10);
        mbdist_preset->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_preset->textsize(10);
        mbdist_preset->textcolor(7);
        mbdist_preset->callback((Fl_Callback*)cb_mbdist_preset, (void*)(12023));
        mbdist_preset->when(FL_WHEN_RELEASE_ALWAYS);
        mbdist_preset->menu(menu_mbdist_preset);
      } // Fl_Choice* mbdist_preset
      { mbdist_WD = new SliderW(372, 237, 100, 10, "Wet/Dry");
        mbdist_WD->type(5);
        mbdist_WD->box(FL_FLAT_BOX);
        mbdist_WD->color((Fl_Color)178);
        mbdist_WD->selection_color((Fl_Color)62);
        mbdist_WD->labeltype(FL_NORMAL_LABEL);
        mbdist_WD->labelfont(0);
        mbdist_WD->labelsize(10);
        mbdist_WD->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_WD->minimum(-64);
        mbdist_WD->maximum(64);
        mbdist_WD->step(1);
        mbdist_WD->textcolor(7);
        mbdist_WD->callback((Fl_Callback*)cb_mbdist_WD);
        mbdist_WD->align(FL_ALIGN_LEFT);
        mbdist_WD->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_WD
      { mbdist_LRc = new SliderW(372, 249, 100, 10, "L/R.Cr");
        mbdist_LRc->type(5);
        mbdist_LRc->box(FL_FLAT_BOX);
        mbdist_LRc->color((Fl_Color)178);
        mbdist_LRc->selection_color((Fl_Color)62);
        mbdist_LRc->labeltype(FL_NORMAL_LABEL);
        mbdist_LRc->labelfont(0);
        mbdist_LRc->labelsize(10);
        mbdist_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_LRc->minimum(-64);
        mbdist_LRc->maximum(64);
        mbdist_LRc->step(1);
        mbdist_LRc->textcolor(7);
        mbdist_LRc->callback((Fl_Callback*)cb_mbdist_LRc);
        mbdist_LRc->align(FL_ALIGN_LEFT);
        mbdist_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_LRc
      { mbdist_drive = new SliderW(372, 261, 100, 10, "Drive");
        mbdist_drive->type(5);
        mbdist_drive->box(FL_FLAT_BOX);
        mbdist_drive->color((Fl_Color)178);
        mbdist_drive->selection_color((Fl_Color)62);
        mbdist_drive->labeltype(FL_NORMAL_LABEL);
        mbdist_drive->labelfont(0);
        mbdist_drive->labelsize(10);
        mbdist_drive->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_drive->maximum(127);
        mbdist_drive->step(1);
        mbdist_drive->textcolor(7);
        mbdist_drive->callback((Fl_Callback*)cb_mbdist_drive);
        mbdist_drive->align(FL_ALIGN_LEFT);
        mbdist_drive->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_drive
      { mbdist_level = new SliderW(372, 273, 100, 10, "Level");
        mbdist_level->type(5);
        mbdist_level->box(FL_FLAT_BOX);
        mbdist_level->color((Fl_Color)178);
        mbdist_level->selection_color((Fl_Color)62);
        mbdist_level->labeltype(FL_NORMAL_LABEL);
        mbdist_level->labelfont(0);
        mbdist_level->labelsize(10);
        mbdist_level->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_level->maximum(127);
        mbdist_level->step(1);
        mbdist_level->textcolor(7);
        mbdist_level->callback((Fl_Callback*)cb_mbdist_level);
        mbdist_level->align(FL_ALIGN_LEFT);
        mbdist_level->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_level
      { mbdist_volL = new SliderW(372, 287, 100, 10, "L.Gain");
        mbdist_volL->type(5);
        mbdist_volL->box(FL_FLAT_BOX);
        mbdist_volL->color((Fl_Color)178);
        mbdist_volL->selection_color((Fl_Color)62);
        mbdist_volL->labeltype(FL_NORMAL_LABEL);
        mbdist_volL->labelfont(0);
        mbdist_volL->labelsize(10);
        mbdist_volL->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_volL->maximum(100);
        mbdist_volL->step(1);
        mbdist_volL->textcolor(7);
        mbdist_volL->callback((Fl_Callback*)cb_mbdist_volL);
        mbdist_volL->align(FL_ALIGN_LEFT);
        mbdist_volL->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_volL
      { mbdist_volM = new SliderW(372, 300, 100, 10, "M.Gain");
        mbdist_volM->type(5);
        mbdist_volM->box(FL_FLAT_BOX);
        mbdist_volM->color((Fl_Color)178);
        mbdist_volM->selection_color((Fl_Color)62);
        mbdist_volM->labeltype(FL_NORMAL_LABEL);
        mbdist_volM->labelfont(0);
        mbdist_volM->labelsize(10);
        mbdist_volM->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_volM->maximum(100);
        mbdist_volM->step(1);
        mbdist_volM->textcolor(7);
        mbdist_volM->callback((Fl_Callback*)cb_mbdist_volM);
        mbdist_volM->align(FL_ALIGN_LEFT);
        mbdist_volM->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_volM
      { mbdist_volH = new SliderW(372, 313, 100, 10, "H. Gain");
        mbdist_volH->type(5);
        mbdist_volH->box(FL_FLAT_BOX);
        mbdist_volH->color((Fl_Color)178);
        mbdist_volH->selection_color((Fl_Color)62);
        mbdist_volH->labeltype(FL_NORMAL_LABEL);
        mbdist_volH->labelfont(0);
        mbdist_volH->labelsize(10);
        mbdist_volH->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_volH->maximum(100);
        mbdist_volH->step(1);
        mbdist_volH->textcolor(7);
        mbdist_volH->callback((Fl_Callback*)cb_mbdist_volH);
        mbdist_volH->align(FL_ALIGN_LEFT);
        mbdist_volH->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_volH
      { mbdist_cross1 = new SliderW(372, 326, 100, 10, "Cross1");
        mbdist_cross1->type(5);
        mbdist_cross1->box(FL_FLAT_BOX);
        mbdist_cross1->color((Fl_Color)178);
        mbdist_cross1->selection_color((Fl_Color)62);
        mbdist_cross1->labeltype(FL_NORMAL_LABEL);
        mbdist_cross1->labelfont(0);
        mbdist_cross1->labelsize(10);
        mbdist_cross1->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_cross1->minimum(20);
        mbdist_cross1->maximum(1000);
        mbdist_cross1->step(1);
        mbdist_cross1->textcolor(7);
        mbdist_cross1->callback((Fl_Callback*)cb_mbdist_cross1);
        mbdist_cross1->align(FL_ALIGN_LEFT);
        mbdist_cross1->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_cross1
      { mbdist_cross2 = new SliderW(372, 338, 100, 10, "Cross2");
        mbdist_cross2->type(5);
        mbdist_cross2->box(FL_FLAT_BOX);
        mbdist_cross2->color((Fl_Color)178);
        mbdist_cross2->selection_color((Fl_Color)62);
        mbdist_cross2->labeltype(FL_NORMAL_LABEL);
        mbdist_cross2->labelfont(0);
        mbdist_cross2->labelsize(10);
        mbdist_cross2->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_cross2->minimum(800);
        mbdist_cross2->maximum(12000);
        mbdist_cross2->step(1);
        mbdist_cross2->textcolor(7);
        mbdist_cross2->callback((Fl_Callback*)cb_mbdist_cross2);
        mbdist_cross2->align(FL_ALIGN_LEFT);
        mbdist_cross2->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_cross2
      { Fl_Choice* o = mbdist_tipoL = new Fl_Choice(323, 350, 50, 16);
        mbdist_tipoL->down_box(FL_BORDER_BOX);
        mbdist_tipoL->selection_color(FL_FOREGROUND_COLOR);
        mbdist_tipoL->labelsize(10);
        mbdist_tipoL->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_tipoL->textsize(10);
        mbdist_tipoL->textcolor(7);
        mbdist_tipoL->callback((Fl_Callback*)cb_mbdist_tipoL);
        o->menu(menu_dist_tipo);
      } // Fl_Choice* mbdist_tipoL
      { Fl_Choice* o = mbdist_tipoM = new Fl_Choice(374, 350, 50, 16);
        mbdist_tipoM->down_box(FL_BORDER_BOX);
        mbdist_tipoM->selection_color(FL_FOREGROUND_COLOR);
        mbdist_tipoM->labelsize(10);
        mbdist_tipoM->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_tipoM->textsize(10);
        mbdist_tipoM->textcolor(7);
        mbdist_tipoM->callback((Fl_Callback*)cb_mbdist_tipoM);
        o->menu(menu_dist_tipo);
      } // Fl_Choice* mbdist_tipoM
      { Fl_Choice* o = mbdist_tipoH = new Fl_Choice(425, 350, 50, 16);
        mbdist_tipoH->down_box(FL_BORDER_BOX);
        mbdist_tipoH->selection_color(FL_FOREGROUND_COLOR);
        mbdist_tipoH->labelsize(10);
        mbdist_tipoH->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_tipoH->textsize(10);
        mbdist_tipoH->textcolor(7);
        mbdist_tipoH->callback((Fl_Callback*)cb_mbdist_tipoH);
        o->menu(menu_dist_tipo);
      } // Fl_Choice* mbdist_tipoH
      { mbdist_pan = new SliderW(372, 369, 100, 10, "Pan");
        mbdist_pan->type(5);
        mbdist_pan->box(FL_FLAT_BOX);
        mbdist_pan->color((Fl_Color)178);
        mbdist_pan->selection_color((Fl_Color)62);
        mbdist_pan->labeltype(FL_NORMAL_LABEL);
        mbdist_pan->labelfont(0);
        mbdist_pan->labelsize(10);
        mbdist_pan->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_pan->minimum(-64);
        mbdist_pan->maximum(64);
        mbdist_pan->step(1);
        mbdist_pan->textcolor(7);
        mbdist_pan->callback((Fl_Callback*)cb_mbdist_pan);
        mbdist_pan->align(FL_ALIGN_LEFT);
        mbdist_pan->when(FL_WHEN_CHANGED);
      } // SliderW* mbdist_pan
      { mbdist_st = new Fl_Check_Button(352, 379, 15, 15, "Stereo");
        mbdist_st->down_box(FL_BORDER_BOX);
        mbdist_st->labelsize(10);
        mbdist_st->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_st->callback((Fl_Callback*)cb_mbdist_st, (void*)(2));
      } // Fl_Check_Button* mbdist_st
      { mbdist_neg = new Fl_Check_Button(421, 378, 15, 15, "Neg.");
        mbdist_neg->down_box(FL_BORDER_BOX);
        mbdist_neg->labelsize(10);
        mbdist_neg->labelcolor(FL_BACKGROUND2_COLOR);
        mbdist_neg->callback((Fl_Callback*)cb_mbdist_neg, (void*)(2));
      } // Fl_Check_Button* mbdist_neg
      MBDIST->end();
    } // Fl_Group* MBDIST
    { ARPIE = new Fl_Group(320, 211, 158, 184);
      ARPIE->box(FL_UP_BOX);
      ARPIE->color(FL_FOREGROUND_COLOR);
      ARPIE->selection_color(FL_FOREGROUND_COLOR);
      ARPIE->labelfont(1);
      ARPIE->user_data((void*)(1));
      ARPIE->align(96|FL_ALIGN_INSIDE);
      ARPIE->hide();
      { arpie_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        arpie_activar->shortcut(0x35);
        arpie_activar->color((Fl_Color)62);
        arpie_activar->selection_color((Fl_Color)1);
        arpie_activar->labelsize(10);
        arpie_activar->callback((Fl_Callback*)cb_arpie_activar, (void*)(2));
        arpie_activar->align(68|FL_ALIGN_INSIDE);
        arpie_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* arpie_activar
      { arpie_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        arpie_preset->down_box(FL_BORDER_BOX);
        arpie_preset->selection_color(FL_FOREGROUND_COLOR);
        arpie_preset->labelsize(10);
        arpie_preset->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_preset->textsize(10);
        arpie_preset->textcolor(7);
        arpie_preset->callback((Fl_Callback*)cb_arpie_preset, (void*)(12024));
        arpie_preset->when(FL_WHEN_RELEASE_ALWAYS);
        arpie_preset->menu(menu_arpie_preset);
      } // Fl_Choice* arpie_preset
      { arpie_WD = new SliderW(371, 239, 100, 10, "Wet/Dry");
        arpie_WD->type(5);
        arpie_WD->box(FL_FLAT_BOX);
        arpie_WD->color((Fl_Color)178);
        arpie_WD->selection_color((Fl_Color)62);
        arpie_WD->labeltype(FL_NORMAL_LABEL);
        arpie_WD->labelfont(0);
        arpie_WD->labelsize(10);
        arpie_WD->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_WD->minimum(-64);
        arpie_WD->maximum(63);
        arpie_WD->step(1);
        arpie_WD->textcolor(7);
        arpie_WD->callback((Fl_Callback*)cb_arpie_WD);
        arpie_WD->align(FL_ALIGN_LEFT);
        arpie_WD->when(FL_WHEN_CHANGED);
      } // SliderW* arpie_WD
      { arpie_arpe = new SliderW(371, 253, 100, 10, "Arpe\'s");
        arpie_arpe->type(5);
        arpie_arpe->box(FL_FLAT_BOX);
        arpie_arpe->color((Fl_Color)178);
        arpie_arpe->selection_color((Fl_Color)62);
        arpie_arpe->labeltype(FL_NORMAL_LABEL);
        arpie_arpe->labelfont(0);
        arpie_arpe->labelsize(10);
        arpie_arpe->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_arpe->maximum(127);
        arpie_arpe->step(1);
        arpie_arpe->textcolor(7);
        arpie_arpe->callback((Fl_Callback*)cb_arpie_arpe);
        arpie_arpe->align(FL_ALIGN_LEFT);
        arpie_arpe->when(FL_WHEN_CHANGED);
      } // SliderW* arpie_arpe
      { arpie_pan = new SliderW(371, 267, 100, 10, "Pan");
        arpie_pan->type(5);
        arpie_pan->box(FL_FLAT_BOX);
        arpie_pan->color((Fl_Color)178);
        arpie_pan->selection_color((Fl_Color)62);
        arpie_pan->labeltype(FL_NORMAL_LABEL);
        arpie_pan->labelfont(0);
        arpie_pan->labelsize(10);
        arpie_pan->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_pan->minimum(-64);
        arpie_pan->maximum(63);
        arpie_pan->step(1);
        arpie_pan->textcolor(7);
        arpie_pan->callback((Fl_Callback*)cb_arpie_pan);
        arpie_pan->align(FL_ALIGN_LEFT);
        arpie_pan->when(FL_WHEN_CHANGED);
      } // SliderW* arpie_pan
      { arpie_delay = new SliderW(371, 281, 100, 10, "Tempo");
        arpie_delay->type(5);
        arpie_delay->box(FL_FLAT_BOX);
        arpie_delay->color((Fl_Color)178);
        arpie_delay->selection_color((Fl_Color)62);
        arpie_delay->labeltype(FL_NORMAL_LABEL);
        arpie_delay->labelfont(0);
        arpie_delay->labelsize(10);
        arpie_delay->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_delay->minimum(1);
        arpie_delay->maximum(600);
        arpie_delay->step(1);
        arpie_delay->value(1);
        arpie_delay->textcolor(7);
        arpie_delay->callback((Fl_Callback*)cb_arpie_delay);
        arpie_delay->align(FL_ALIGN_LEFT);
        arpie_delay->when(FL_WHEN_RELEASE);
      } // SliderW* arpie_delay
      { arpie_subdiv = new Fl_Choice(398, 293, 76, 18, "SubDivision");
        arpie_subdiv->down_box(FL_BORDER_BOX);
        arpie_subdiv->selection_color(FL_FOREGROUND_COLOR);
        arpie_subdiv->labelsize(10);
        arpie_subdiv->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_subdiv->textsize(10);
        arpie_subdiv->textcolor(7);
        arpie_subdiv->callback((Fl_Callback*)cb_arpie_subdiv, (void*)(12));
        arpie_subdiv->when(FL_WHEN_RELEASE_ALWAYS);
        arpie_subdiv->menu(menu_arpie_subdiv);
      } // Fl_Choice* arpie_subdiv
      { arpie_LRdl = new SliderW(371, 314, 100, 10, "LRdl.");
        arpie_LRdl->type(5);
        arpie_LRdl->box(FL_FLAT_BOX);
        arpie_LRdl->color((Fl_Color)178);
        arpie_LRdl->selection_color((Fl_Color)62);
        arpie_LRdl->labeltype(FL_NORMAL_LABEL);
        arpie_LRdl->labelfont(0);
        arpie_LRdl->labelsize(10);
        arpie_LRdl->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_LRdl->maximum(127);
        arpie_LRdl->step(1);
        arpie_LRdl->textcolor(7);
        arpie_LRdl->callback((Fl_Callback*)cb_arpie_LRdl);
        arpie_LRdl->align(FL_ALIGN_LEFT);
        arpie_LRdl->when(FL_WHEN_RELEASE);
      } // SliderW* arpie_LRdl
      { arpie_LRc = new SliderW(371, 329, 100, 10, "L/R.Cr");
        arpie_LRc->type(5);
        arpie_LRc->box(FL_FLAT_BOX);
        arpie_LRc->color((Fl_Color)178);
        arpie_LRc->selection_color((Fl_Color)62);
        arpie_LRc->labeltype(FL_NORMAL_LABEL);
        arpie_LRc->labelfont(0);
        arpie_LRc->labelsize(10);
        arpie_LRc->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_LRc->minimum(-64);
        arpie_LRc->maximum(63);
        arpie_LRc->step(1);
        arpie_LRc->textcolor(7);
        arpie_LRc->callback((Fl_Callback*)cb_arpie_LRc);
        arpie_LRc->align(FL_ALIGN_LEFT);
        arpie_LRc->when(FL_WHEN_CHANGED);
      } // SliderW* arpie_LRc
      { arpie_fb = new SliderW(371, 344, 100, 10, "Fb.");
        arpie_fb->type(5);
        arpie_fb->box(FL_FLAT_BOX);
        arpie_fb->color((Fl_Color)178);
        arpie_fb->selection_color((Fl_Color)62);
        arpie_fb->labeltype(FL_NORMAL_LABEL);
        arpie_fb->labelfont(0);
        arpie_fb->labelsize(10);
        arpie_fb->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_fb->maximum(127);
        arpie_fb->step(1);
        arpie_fb->textcolor(7);
        arpie_fb->callback((Fl_Callback*)cb_arpie_fb);
        arpie_fb->align(FL_ALIGN_LEFT);
        arpie_fb->when(FL_WHEN_CHANGED);
      } // SliderW* arpie_fb
      { arpie_damp = new SliderW(371, 378, 100, 10, "Damp");
        arpie_damp->type(5);
        arpie_damp->box(FL_FLAT_BOX);
        arpie_damp->color((Fl_Color)178);
        arpie_damp->selection_color((Fl_Color)62);
        arpie_damp->labeltype(FL_NORMAL_LABEL);
        arpie_damp->labelfont(0);
        arpie_damp->labelsize(10);
        arpie_damp->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_damp->maximum(127);
        arpie_damp->step(1);
        arpie_damp->textcolor(7);
        arpie_damp->callback((Fl_Callback*)cb_arpie_damp);
        arpie_damp->align(FL_ALIGN_LEFT);
        arpie_damp->when(FL_WHEN_CHANGED);
      } // SliderW* arpie_damp
      { arpie_harm = new Fl_Counter(340, 361, 52, 12, "H");
        arpie_harm->tooltip("Number of steps in the pattern");
        arpie_harm->type(1);
        arpie_harm->box(FL_THIN_UP_BOX);
        arpie_harm->labelsize(10);
        arpie_harm->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_harm->minimum(1);
        arpie_harm->maximum(8);
        arpie_harm->step(1);
        arpie_harm->value(1);
        arpie_harm->textsize(9);
        arpie_harm->callback((Fl_Callback*)cb_arpie_harm);
        arpie_harm->align(FL_ALIGN_LEFT);
      } // Fl_Counter* arpie_harm
      { arpie_pattern = new Fl_Choice(397, 358, 76, 18);
        arpie_pattern->down_box(FL_BORDER_BOX);
        arpie_pattern->selection_color(FL_FOREGROUND_COLOR);
        arpie_pattern->labelsize(10);
        arpie_pattern->labelcolor(FL_BACKGROUND2_COLOR);
        arpie_pattern->textsize(10);
        arpie_pattern->textcolor(7);
        arpie_pattern->callback((Fl_Callback*)cb_arpie_pattern, (void*)(12));
        arpie_pattern->when(FL_WHEN_RELEASE_ALWAYS);
        arpie_pattern->menu(menu_arpie_pattern);
      } // Fl_Choice* arpie_pattern
      ARPIE->end();
    } // Fl_Group* ARPIE
    { EXPANDER = new Fl_Group(320, 211, 158, 184);
      EXPANDER->box(FL_UP_BOX);
      EXPANDER->color(FL_FOREGROUND_COLOR);
      EXPANDER->selection_color(FL_FOREGROUND_COLOR);
      EXPANDER->labelfont(1);
      EXPANDER->user_data((void*)(1));
      EXPANDER->align(96|FL_ALIGN_INSIDE);
      EXPANDER->hide();
      { expander_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        expander_activar->shortcut(0x32);
        expander_activar->color((Fl_Color)62);
        expander_activar->selection_color((Fl_Color)1);
        expander_activar->labelsize(10);
        expander_activar->callback((Fl_Callback*)cb_expander_activar, (void*)(2));
        expander_activar->align(68|FL_ALIGN_INSIDE);
        expander_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* expander_activar
      { expander_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        expander_preset->down_box(FL_BORDER_BOX);
        expander_preset->selection_color(FL_FOREGROUND_COLOR);
        expander_preset->labelsize(10);
        expander_preset->labelcolor(FL_BACKGROUND2_COLOR);
        expander_preset->textsize(10);
        expander_preset->textcolor(7);
        expander_preset->callback((Fl_Callback*)cb_expander_preset, (void*)(12025));
        expander_preset->when(FL_WHEN_RELEASE_ALWAYS);
        expander_preset->menu(menu_expander_preset);
      } // Fl_Choice* expander_preset
      { expander_ATime = new SliderW(371, 250, 100, 10, "A. Time");
        expander_ATime->type(5);
        expander_ATime->box(FL_FLAT_BOX);
        expander_ATime->color((Fl_Color)178);
        expander_ATime->selection_color((Fl_Color)62);
        expander_ATime->labeltype(FL_NORMAL_LABEL);
        expander_ATime->labelfont(0);
        expander_ATime->labelsize(10);
        expander_ATime->labelcolor(FL_BACKGROUND2_COLOR);
        expander_ATime->minimum(10);
        expander_ATime->maximum(2000);
        expander_ATime->step(1);
        expander_ATime->value(10);
        expander_ATime->textcolor(7);
        expander_ATime->callback((Fl_Callback*)cb_expander_ATime);
        expander_ATime->align(FL_ALIGN_LEFT);
        expander_ATime->when(FL_WHEN_CHANGED);
      } // SliderW* expander_ATime
      { expander_RTime = new SliderW(370, 272, 100, 10, "R. Time");
        expander_RTime->type(5);
        expander_RTime->box(FL_FLAT_BOX);
        expander_RTime->color((Fl_Color)178);
        expander_RTime->selection_color((Fl_Color)62);
        expander_RTime->labeltype(FL_NORMAL_LABEL);
        expander_RTime->labelfont(0);
        expander_RTime->labelsize(10);
        expander_RTime->labelcolor(FL_BACKGROUND2_COLOR);
        expander_RTime->minimum(10);
        expander_RTime->maximum(500);
        expander_RTime->step(1);
        expander_RTime->value(500);
        expander_RTime->textcolor(7);
        expander_RTime->callback((Fl_Callback*)cb_expander_RTime);
        expander_RTime->align(FL_ALIGN_LEFT);
        expander_RTime->when(FL_WHEN_CHANGED);
      } // SliderW* expander_RTime
      { expander_shape = new SliderW(370, 294, 100, 10, "Shape");
        expander_shape->type(5);
        expander_shape->box(FL_FLAT_BOX);
        expander_shape->color((Fl_Color)178);
        expander_shape->selection_color((Fl_Color)62);
        expander_shape->labeltype(FL_NORMAL_LABEL);
        expander_shape->labelfont(0);
        expander_shape->labelsize(10);
        expander_shape->labelcolor(FL_BACKGROUND2_COLOR);
        expander_shape->minimum(1);
        expander_shape->maximum(50);
        expander_shape->step(1);
        expander_shape->value(1);
        expander_shape->textcolor(7);
        expander_shape->callback((Fl_Callback*)cb_expander_shape);
        expander_shape->align(FL_ALIGN_LEFT);
        expander_shape->when(FL_WHEN_CHANGED);
      } // SliderW* expander_shape
      { expander_threshold = new SliderW(370, 316, 100, 10, "Thrhold");
        expander_threshold->type(5);
        expander_threshold->box(FL_FLAT_BOX);
        expander_threshold->color((Fl_Color)178);
        expander_threshold->selection_color((Fl_Color)62);
        expander_threshold->labeltype(FL_NORMAL_LABEL);
        expander_threshold->labelfont(0);
        expander_threshold->labelsize(10);
        expander_threshold->labelcolor(FL_BACKGROUND2_COLOR);
        expander_threshold->minimum(-80);
        expander_threshold->maximum(0);
        expander_threshold->step(1);
        expander_threshold->textcolor(7);
        expander_threshold->callback((Fl_Callback*)cb_expander_threshold);
        expander_threshold->align(FL_ALIGN_LEFT);
        expander_threshold->when(FL_WHEN_CHANGED);
      } // SliderW* expander_threshold
      { expander_level = new SliderW(370, 336, 100, 10, "Level");
        expander_level->type(5);
        expander_level->box(FL_FLAT_BOX);
        expander_level->color((Fl_Color)178);
        expander_level->selection_color((Fl_Color)62);
        expander_level->labeltype(FL_NORMAL_LABEL);
        expander_level->labelfont(0);
        expander_level->labelsize(10);
        expander_level->labelcolor(FL_BACKGROUND2_COLOR);
        expander_level->minimum(1);
        expander_level->maximum(127);
        expander_level->step(1);
        expander_level->value(1);
        expander_level->textcolor(7);
        expander_level->callback((Fl_Callback*)cb_expander_level);
        expander_level->align(FL_ALIGN_LEFT);
        expander_level->when(FL_WHEN_CHANGED);
      } // SliderW* expander_level
      { expander_LPF = new SliderW(370, 357, 100, 10, "LPF");
        expander_LPF->type(5);
        expander_LPF->box(FL_FLAT_BOX);
        expander_LPF->color((Fl_Color)178);
        expander_LPF->selection_color((Fl_Color)62);
        expander_LPF->labeltype(FL_NORMAL_LABEL);
        expander_LPF->labelfont(0);
        expander_LPF->labelsize(10);
        expander_LPF->labelcolor(FL_BACKGROUND2_COLOR);
        expander_LPF->minimum(20);
        expander_LPF->maximum(26000);
        expander_LPF->step(1);
        expander_LPF->value(20000);
        expander_LPF->textcolor(7);
        expander_LPF->callback((Fl_Callback*)cb_expander_LPF);
        expander_LPF->align(FL_ALIGN_LEFT);
        expander_LPF->when(FL_WHEN_CHANGED);
      } // SliderW* expander_LPF
      { expander_HPF = new SliderW(370, 373, 100, 10, "HPF");
        expander_HPF->type(5);
        expander_HPF->box(FL_FLAT_BOX);
        expander_HPF->color((Fl_Color)178);
        expander_HPF->selection_color((Fl_Color)62);
        expander_HPF->labeltype(FL_NORMAL_LABEL);
        expander_HPF->labelfont(0);
        expander_HPF->labelsize(10);
        expander_HPF->labelcolor(FL_BACKGROUND2_COLOR);
        expander_HPF->minimum(20);
        expander_HPF->maximum(20000);
        expander_HPF->step(1);
        expander_HPF->value(20);
        expander_HPF->textcolor(7);
        expander_HPF->callback((Fl_Callback*)cb_expander_HPF);
        expander_HPF->align(FL_ALIGN_LEFT);
        expander_HPF->when(FL_WHEN_CHANGED);
      } // SliderW* expander_HPF
      EXPANDER->end();
    } // Fl_Group* EXPANDER
    { SHUFFLE = new Fl_Group(320, 211, 158, 184, "High Freq");
      SHUFFLE->box(FL_UP_BOX);
      SHUFFLE->color(FL_FOREGROUND_COLOR);
      SHUFFLE->selection_color(FL_FOREGROUND_COLOR);
      SHUFFLE->labelfont(1);
      SHUFFLE->user_data((void*)(1));
      SHUFFLE->align(96|FL_ALIGN_INSIDE);
      SHUFFLE->hide();
      { shuffle_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        shuffle_activar->shortcut(0x33);
        shuffle_activar->color((Fl_Color)62);
        shuffle_activar->selection_color((Fl_Color)1);
        shuffle_activar->labelsize(10);
        shuffle_activar->callback((Fl_Callback*)cb_shuffle_activar, (void*)(2));
        shuffle_activar->align(68|FL_ALIGN_INSIDE);
        shuffle_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* shuffle_activar
      { shuffle_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        shuffle_preset->down_box(FL_BORDER_BOX);
        shuffle_preset->selection_color(FL_FOREGROUND_COLOR);
        shuffle_preset->labelsize(10);
        shuffle_preset->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_preset->textsize(10);
        shuffle_preset->textcolor(7);
        shuffle_preset->callback((Fl_Callback*)cb_shuffle_preset, (void*)(12026));
        shuffle_preset->when(FL_WHEN_RELEASE_ALWAYS);
        shuffle_preset->menu(menu_shuffle_preset);
      } // Fl_Choice* shuffle_preset
      { shuffle_WD = new SliderW(375, 242, 100, 10, "Wet/Dry");
        shuffle_WD->type(5);
        shuffle_WD->box(FL_FLAT_BOX);
        shuffle_WD->color((Fl_Color)178);
        shuffle_WD->selection_color((Fl_Color)62);
        shuffle_WD->labeltype(FL_NORMAL_LABEL);
        shuffle_WD->labelfont(0);
        shuffle_WD->labelsize(10);
        shuffle_WD->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_WD->minimum(-64);
        shuffle_WD->maximum(64);
        shuffle_WD->step(1);
        shuffle_WD->textcolor(7);
        shuffle_WD->callback((Fl_Callback*)cb_shuffle_WD);
        shuffle_WD->align(FL_ALIGN_LEFT);
        shuffle_WD->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_WD
      { shuffle_cross1 = new SliderW(375, 260, 100, 10, "Low Freq");
        shuffle_cross1->type(5);
        shuffle_cross1->box(FL_FLAT_BOX);
        shuffle_cross1->color((Fl_Color)178);
        shuffle_cross1->selection_color((Fl_Color)62);
        shuffle_cross1->labeltype(FL_NORMAL_LABEL);
        shuffle_cross1->labelfont(0);
        shuffle_cross1->labelsize(10);
        shuffle_cross1->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_cross1->minimum(20);
        shuffle_cross1->maximum(1000);
        shuffle_cross1->step(1);
        shuffle_cross1->textcolor(7);
        shuffle_cross1->callback((Fl_Callback*)cb_shuffle_cross1);
        shuffle_cross1->align(FL_ALIGN_LEFT);
        shuffle_cross1->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_cross1
      { shuffle_volL = new SliderW(375, 275, 100, 10, "Low Gain");
        shuffle_volL->type(5);
        shuffle_volL->box(FL_FLAT_BOX);
        shuffle_volL->color((Fl_Color)178);
        shuffle_volL->selection_color((Fl_Color)62);
        shuffle_volL->labeltype(FL_NORMAL_LABEL);
        shuffle_volL->labelfont(0);
        shuffle_volL->labelsize(10);
        shuffle_volL->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_volL->minimum(-64);
        shuffle_volL->maximum(64);
        shuffle_volL->step(1);
        shuffle_volL->textcolor(7);
        shuffle_volL->callback((Fl_Callback*)cb_shuffle_volL);
        shuffle_volL->align(FL_ALIGN_LEFT);
        shuffle_volL->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_volL
      { shuffle_cross2 = new SliderW(375, 290, 100, 10, "M.L. Freq");
        shuffle_cross2->type(5);
        shuffle_cross2->box(FL_FLAT_BOX);
        shuffle_cross2->color((Fl_Color)178);
        shuffle_cross2->selection_color((Fl_Color)62);
        shuffle_cross2->labeltype(FL_NORMAL_LABEL);
        shuffle_cross2->labelfont(0);
        shuffle_cross2->labelsize(10);
        shuffle_cross2->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_cross2->minimum(400);
        shuffle_cross2->maximum(4000);
        shuffle_cross2->step(1);
        shuffle_cross2->textcolor(7);
        shuffle_cross2->callback((Fl_Callback*)cb_shuffle_cross2);
        shuffle_cross2->align(FL_ALIGN_LEFT);
        shuffle_cross2->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_cross2
      { shuffle_volML = new SliderW(375, 305, 100, 10, "M.L Gain");
        shuffle_volML->type(5);
        shuffle_volML->box(FL_FLAT_BOX);
        shuffle_volML->color((Fl_Color)178);
        shuffle_volML->selection_color((Fl_Color)62);
        shuffle_volML->labeltype(FL_NORMAL_LABEL);
        shuffle_volML->labelfont(0);
        shuffle_volML->labelsize(10);
        shuffle_volML->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_volML->minimum(-64);
        shuffle_volML->maximum(64);
        shuffle_volML->step(1);
        shuffle_volML->textcolor(7);
        shuffle_volML->callback((Fl_Callback*)cb_shuffle_volML);
        shuffle_volML->align(FL_ALIGN_LEFT);
        shuffle_volML->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_volML
      { shuffle_cross3 = new SliderW(375, 320, 100, 10, "M.H. Freq");
        shuffle_cross3->type(5);
        shuffle_cross3->box(FL_FLAT_BOX);
        shuffle_cross3->color((Fl_Color)178);
        shuffle_cross3->selection_color((Fl_Color)62);
        shuffle_cross3->labeltype(FL_NORMAL_LABEL);
        shuffle_cross3->labelfont(0);
        shuffle_cross3->labelsize(10);
        shuffle_cross3->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_cross3->minimum(1200);
        shuffle_cross3->maximum(8000);
        shuffle_cross3->step(1);
        shuffle_cross3->textcolor(7);
        shuffle_cross3->callback((Fl_Callback*)cb_shuffle_cross3);
        shuffle_cross3->align(FL_ALIGN_LEFT);
        shuffle_cross3->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_cross3
      { shuffle_volMH = new SliderW(375, 335, 100, 10, "M.L Gain");
        shuffle_volMH->type(5);
        shuffle_volMH->box(FL_FLAT_BOX);
        shuffle_volMH->color((Fl_Color)178);
        shuffle_volMH->selection_color((Fl_Color)62);
        shuffle_volMH->labeltype(FL_NORMAL_LABEL);
        shuffle_volMH->labelfont(0);
        shuffle_volMH->labelsize(10);
        shuffle_volMH->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_volMH->minimum(-64);
        shuffle_volMH->maximum(64);
        shuffle_volMH->step(1);
        shuffle_volMH->textcolor(7);
        shuffle_volMH->callback((Fl_Callback*)cb_shuffle_volMH);
        shuffle_volMH->align(FL_ALIGN_LEFT);
        shuffle_volMH->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_volMH
      { shuffle_cross4 = new SliderW(375, 350, 100, 10, "High Freq");
        shuffle_cross4->type(5);
        shuffle_cross4->box(FL_FLAT_BOX);
        shuffle_cross4->color((Fl_Color)178);
        shuffle_cross4->selection_color((Fl_Color)62);
        shuffle_cross4->labeltype(FL_NORMAL_LABEL);
        shuffle_cross4->labelfont(0);
        shuffle_cross4->labelsize(10);
        shuffle_cross4->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_cross4->minimum(6000);
        shuffle_cross4->maximum(26000);
        shuffle_cross4->step(1);
        shuffle_cross4->textcolor(7);
        shuffle_cross4->callback((Fl_Callback*)cb_shuffle_cross4);
        shuffle_cross4->align(FL_ALIGN_LEFT);
        shuffle_cross4->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_cross4
      { shuffle_volH = new SliderW(375, 365, 100, 10, "High Gain");
        shuffle_volH->type(5);
        shuffle_volH->box(FL_FLAT_BOX);
        shuffle_volH->color((Fl_Color)178);
        shuffle_volH->selection_color((Fl_Color)62);
        shuffle_volH->labeltype(FL_NORMAL_LABEL);
        shuffle_volH->labelfont(0);
        shuffle_volH->labelsize(10);
        shuffle_volH->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_volH->minimum(-64);
        shuffle_volH->maximum(64);
        shuffle_volH->step(1);
        shuffle_volH->textcolor(7);
        shuffle_volH->callback((Fl_Callback*)cb_shuffle_volH);
        shuffle_volH->align(FL_ALIGN_LEFT);
        shuffle_volH->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_volH
      { shuffle_Q = new SliderW(375, 380, 100, 10, "Q");
        shuffle_Q->type(5);
        shuffle_Q->box(FL_FLAT_BOX);
        shuffle_Q->color((Fl_Color)178);
        shuffle_Q->selection_color((Fl_Color)62);
        shuffle_Q->labeltype(FL_NORMAL_LABEL);
        shuffle_Q->labelfont(0);
        shuffle_Q->labelsize(10);
        shuffle_Q->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_Q->minimum(-64);
        shuffle_Q->maximum(64);
        shuffle_Q->step(1);
        shuffle_Q->textcolor(7);
        shuffle_Q->callback((Fl_Callback*)cb_shuffle_Q);
        shuffle_Q->align(FL_ALIGN_LEFT);
        shuffle_Q->when(FL_WHEN_CHANGED);
      } // SliderW* shuffle_Q
      { shuffle_E = new Fl_Check_Button(322, 378, 15, 15, "Rev");
        shuffle_E->down_box(FL_BORDER_BOX);
        shuffle_E->labelsize(10);
        shuffle_E->labelcolor(FL_BACKGROUND2_COLOR);
        shuffle_E->callback((Fl_Callback*)cb_shuffle_E, (void*)(2));
      } // Fl_Check_Button* shuffle_E
      SHUFFLE->end();
    } // Fl_Group* SHUFFLE
    { SYNTHFILTER = new Fl_Group(320, 211, 158, 184);
      SYNTHFILTER->box(FL_UP_BOX);
      SYNTHFILTER->color(FL_FOREGROUND_COLOR);
      SYNTHFILTER->selection_color(FL_FOREGROUND_COLOR);
      SYNTHFILTER->labelfont(1);
      SYNTHFILTER->user_data((void*)(1));
      SYNTHFILTER->align(96|FL_ALIGN_INSIDE);
      SYNTHFILTER->hide();
      { synthfilter_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        synthfilter_activar->shortcut(0x37);
        synthfilter_activar->color((Fl_Color)62);
        synthfilter_activar->selection_color((Fl_Color)1);
        synthfilter_activar->labelsize(10);
        synthfilter_activar->callback((Fl_Callback*)cb_synthfilter_activar, (void*)(2));
        synthfilter_activar->align(68|FL_ALIGN_INSIDE);
        synthfilter_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* synthfilter_activar
      { synthfilter_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        synthfilter_preset->down_box(FL_BORDER_BOX);
        synthfilter_preset->selection_color(FL_FOREGROUND_COLOR);
        synthfilter_preset->labelsize(10);
        synthfilter_preset->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_preset->textsize(10);
        synthfilter_preset->textcolor(7);
        synthfilter_preset->callback((Fl_Callback*)cb_synthfilter_preset, (void*)(12027));
        synthfilter_preset->when(FL_WHEN_RELEASE_ALWAYS);
        synthfilter_preset->menu(menu_synthfilter_preset);
      } // Fl_Choice* synthfilter_preset
      { synthfilter_WD = new SliderW(369, 236, 100, 10, "Wet/Dry");
        synthfilter_WD->type(5);
        synthfilter_WD->box(FL_FLAT_BOX);
        synthfilter_WD->color((Fl_Color)178);
        synthfilter_WD->selection_color((Fl_Color)62);
        synthfilter_WD->labeltype(FL_NORMAL_LABEL);
        synthfilter_WD->labelfont(0);
        synthfilter_WD->labelsize(10);
        synthfilter_WD->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_WD->minimum(-64);
        synthfilter_WD->maximum(63);
        synthfilter_WD->step(1);
        synthfilter_WD->textcolor(7);
        synthfilter_WD->callback((Fl_Callback*)cb_synthfilter_WD);
        synthfilter_WD->align(FL_ALIGN_LEFT);
        synthfilter_WD->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_WD
      { synthfilter_Distort = new SliderW(369, 248, 100, 10, "Distort");
        synthfilter_Distort->type(5);
        synthfilter_Distort->box(FL_FLAT_BOX);
        synthfilter_Distort->color((Fl_Color)178);
        synthfilter_Distort->selection_color((Fl_Color)62);
        synthfilter_Distort->labeltype(FL_NORMAL_LABEL);
        synthfilter_Distort->labelfont(0);
        synthfilter_Distort->labelsize(10);
        synthfilter_Distort->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_Distort->maximum(127);
        synthfilter_Distort->step(1);
        synthfilter_Distort->textcolor(7);
        synthfilter_Distort->callback((Fl_Callback*)cb_synthfilter_Distort);
        synthfilter_Distort->align(FL_ALIGN_LEFT);
        synthfilter_Distort->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_Distort
      { synthfilter_freq = new SliderW(369, 260, 100, 10, "Tempo");
        synthfilter_freq->type(5);
        synthfilter_freq->box(FL_FLAT_BOX);
        synthfilter_freq->color((Fl_Color)178);
        synthfilter_freq->selection_color((Fl_Color)62);
        synthfilter_freq->labeltype(FL_NORMAL_LABEL);
        synthfilter_freq->labelfont(0);
        synthfilter_freq->labelsize(10);
        synthfilter_freq->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_freq->minimum(1);
        synthfilter_freq->maximum(600);
        synthfilter_freq->step(1);
        synthfilter_freq->textcolor(7);
        synthfilter_freq->callback((Fl_Callback*)cb_synthfilter_freq);
        synthfilter_freq->align(FL_ALIGN_LEFT);
        synthfilter_freq->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_freq
      { Fl_Choice* o = synthfilter_lfotype = new Fl_Choice(374, 271, 52, 13, "LFO Type");
        synthfilter_lfotype->down_box(FL_BORDER_BOX);
        synthfilter_lfotype->selection_color(FL_FOREGROUND_COLOR);
        synthfilter_lfotype->labelsize(10);
        synthfilter_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_lfotype->textsize(10);
        synthfilter_lfotype->textcolor(7);
        synthfilter_lfotype->callback((Fl_Callback*)cb_synthfilter_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* synthfilter_lfotype
      { synthfilter_subs = new Fl_Check_Button(429, 270, 15, 15, "Subtr.");
        synthfilter_subs->down_box(FL_BORDER_BOX);
        synthfilter_subs->labelsize(10);
        synthfilter_subs->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_subs->callback((Fl_Callback*)cb_synthfilter_subs, (void*)(2));
      } // Fl_Check_Button* synthfilter_subs
      { synthfilter_stdf = new SliderW(369, 286, 100, 10, "St.df");
        synthfilter_stdf->type(5);
        synthfilter_stdf->box(FL_FLAT_BOX);
        synthfilter_stdf->color((Fl_Color)178);
        synthfilter_stdf->selection_color((Fl_Color)62);
        synthfilter_stdf->labeltype(FL_NORMAL_LABEL);
        synthfilter_stdf->labelfont(0);
        synthfilter_stdf->labelsize(10);
        synthfilter_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_stdf->maximum(127);
        synthfilter_stdf->step(1);
        synthfilter_stdf->textcolor(7);
        synthfilter_stdf->callback((Fl_Callback*)cb_synthfilter_stdf);
        synthfilter_stdf->align(FL_ALIGN_LEFT);
        synthfilter_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_stdf
      { synthfilter_width = new SliderW(369, 298, 100, 10, "Width");
        synthfilter_width->type(5);
        synthfilter_width->box(FL_FLAT_BOX);
        synthfilter_width->color((Fl_Color)178);
        synthfilter_width->selection_color((Fl_Color)62);
        synthfilter_width->labeltype(FL_NORMAL_LABEL);
        synthfilter_width->labelfont(0);
        synthfilter_width->labelsize(10);
        synthfilter_width->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_width->maximum(127);
        synthfilter_width->step(1);
        synthfilter_width->textcolor(7);
        synthfilter_width->callback((Fl_Callback*)cb_synthfilter_width);
        synthfilter_width->align(FL_ALIGN_LEFT);
        synthfilter_width->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_width
      { synthfilter_fb = new SliderW(369, 310, 100, 10, "Fb");
        synthfilter_fb->type(5);
        synthfilter_fb->box(FL_FLAT_BOX);
        synthfilter_fb->color((Fl_Color)178);
        synthfilter_fb->selection_color((Fl_Color)62);
        synthfilter_fb->labeltype(FL_NORMAL_LABEL);
        synthfilter_fb->labelfont(0);
        synthfilter_fb->labelsize(10);
        synthfilter_fb->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_fb->minimum(-64);
        synthfilter_fb->maximum(64);
        synthfilter_fb->step(1);
        synthfilter_fb->textcolor(7);
        synthfilter_fb->callback((Fl_Callback*)cb_synthfilter_fb);
        synthfilter_fb->align(FL_ALIGN_LEFT);
        synthfilter_fb->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_fb
      { synthfilter_Lstages = new Fl_Counter(368, 322, 28, 11, "LPF Stg.");
        synthfilter_Lstages->type(1);
        synthfilter_Lstages->box(FL_THIN_UP_BOX);
        synthfilter_Lstages->labelsize(10);
        synthfilter_Lstages->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_Lstages->minimum(0);
        synthfilter_Lstages->maximum(12);
        synthfilter_Lstages->step(1);
        synthfilter_Lstages->value(1);
        synthfilter_Lstages->textsize(9);
        synthfilter_Lstages->callback((Fl_Callback*)cb_synthfilter_Lstages);
        synthfilter_Lstages->align(FL_ALIGN_LEFT);
      } // Fl_Counter* synthfilter_Lstages
      { synthfilter_Hstages = new Fl_Counter(445, 322, 28, 11, "HPF Stg.");
        synthfilter_Hstages->type(1);
        synthfilter_Hstages->box(FL_THIN_UP_BOX);
        synthfilter_Hstages->labelsize(10);
        synthfilter_Hstages->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_Hstages->minimum(0);
        synthfilter_Hstages->maximum(12);
        synthfilter_Hstages->step(1);
        synthfilter_Hstages->value(1);
        synthfilter_Hstages->textsize(9);
        synthfilter_Hstages->callback((Fl_Callback*)cb_synthfilter_Hstages);
        synthfilter_Hstages->align(FL_ALIGN_LEFT);
      } // Fl_Counter* synthfilter_Hstages
      { synthfilter_dpth = new SliderW(369, 335, 100, 10, "Depth");
        synthfilter_dpth->type(5);
        synthfilter_dpth->box(FL_FLAT_BOX);
        synthfilter_dpth->color((Fl_Color)178);
        synthfilter_dpth->selection_color((Fl_Color)62);
        synthfilter_dpth->labeltype(FL_NORMAL_LABEL);
        synthfilter_dpth->labelfont(0);
        synthfilter_dpth->labelsize(10);
        synthfilter_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_dpth->maximum(127);
        synthfilter_dpth->step(1);
        synthfilter_dpth->textcolor(7);
        synthfilter_dpth->callback((Fl_Callback*)cb_synthfilter_dpth);
        synthfilter_dpth->align(FL_ALIGN_LEFT);
        synthfilter_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_dpth
      { synthfilter_EnvSens = new SliderW(369, 347, 100, 10, "E.Sens");
        synthfilter_EnvSens->type(5);
        synthfilter_EnvSens->box(FL_FLAT_BOX);
        synthfilter_EnvSens->color((Fl_Color)178);
        synthfilter_EnvSens->selection_color((Fl_Color)62);
        synthfilter_EnvSens->labeltype(FL_NORMAL_LABEL);
        synthfilter_EnvSens->labelfont(0);
        synthfilter_EnvSens->labelsize(10);
        synthfilter_EnvSens->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_EnvSens->minimum(-64);
        synthfilter_EnvSens->maximum(64);
        synthfilter_EnvSens->step(1);
        synthfilter_EnvSens->textcolor(7);
        synthfilter_EnvSens->callback((Fl_Callback*)cb_synthfilter_EnvSens);
        synthfilter_EnvSens->align(FL_ALIGN_LEFT);
        synthfilter_EnvSens->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_EnvSens
      { synthfilter_ATime = new SliderW(369, 359, 100, 10, "A.Time");
        synthfilter_ATime->type(5);
        synthfilter_ATime->box(FL_FLAT_BOX);
        synthfilter_ATime->color((Fl_Color)178);
        synthfilter_ATime->selection_color((Fl_Color)62);
        synthfilter_ATime->labeltype(FL_NORMAL_LABEL);
        synthfilter_ATime->labelfont(0);
        synthfilter_ATime->labelsize(10);
        synthfilter_ATime->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_ATime->minimum(5);
        synthfilter_ATime->maximum(1000);
        synthfilter_ATime->step(1);
        synthfilter_ATime->value(5);
        synthfilter_ATime->textcolor(7);
        synthfilter_ATime->callback((Fl_Callback*)cb_synthfilter_ATime);
        synthfilter_ATime->align(FL_ALIGN_LEFT);
        synthfilter_ATime->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_ATime
      { synthfilter_RTime = new SliderW(369, 371, 100, 10, "R.Time");
        synthfilter_RTime->type(5);
        synthfilter_RTime->box(FL_FLAT_BOX);
        synthfilter_RTime->color((Fl_Color)178);
        synthfilter_RTime->selection_color((Fl_Color)62);
        synthfilter_RTime->labeltype(FL_NORMAL_LABEL);
        synthfilter_RTime->labelfont(0);
        synthfilter_RTime->labelsize(10);
        synthfilter_RTime->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_RTime->minimum(5);
        synthfilter_RTime->maximum(500);
        synthfilter_RTime->step(1);
        synthfilter_RTime->value(5);
        synthfilter_RTime->textcolor(7);
        synthfilter_RTime->callback((Fl_Callback*)cb_synthfilter_RTime);
        synthfilter_RTime->align(FL_ALIGN_LEFT);
        synthfilter_RTime->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_RTime
      { synthfilter_Offset = new SliderW(369, 383, 100, 10, "Offset");
        synthfilter_Offset->type(5);
        synthfilter_Offset->box(FL_FLAT_BOX);
        synthfilter_Offset->color((Fl_Color)178);
        synthfilter_Offset->selection_color((Fl_Color)62);
        synthfilter_Offset->labeltype(FL_NORMAL_LABEL);
        synthfilter_Offset->labelfont(0);
        synthfilter_Offset->labelsize(10);
        synthfilter_Offset->labelcolor(FL_BACKGROUND2_COLOR);
        synthfilter_Offset->maximum(127);
        synthfilter_Offset->step(1);
        synthfilter_Offset->textcolor(7);
        synthfilter_Offset->callback((Fl_Callback*)cb_synthfilter_Offset);
        synthfilter_Offset->align(FL_ALIGN_LEFT);
        synthfilter_Offset->when(FL_WHEN_CHANGED);
      } // SliderW* synthfilter_Offset
      SYNTHFILTER->end();
    } // Fl_Group* SYNTHFILTER
    { MBVVOL = new Fl_Group(320, 211, 158, 184);
      MBVVOL->box(FL_UP_BOX);
      MBVVOL->color(FL_FOREGROUND_COLOR);
      MBVVOL->selection_color(FL_FOREGROUND_COLOR);
      MBVVOL->labelfont(1);
      MBVVOL->user_data((void*)(1));
      MBVVOL->align(96|FL_ALIGN_INSIDE);
      MBVVOL->hide();
      { mbvvol_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        mbvvol_activar->shortcut(0x38);
        mbvvol_activar->color((Fl_Color)62);
        mbvvol_activar->selection_color((Fl_Color)1);
        mbvvol_activar->labelsize(10);
        mbvvol_activar->callback((Fl_Callback*)cb_mbvvol_activar, (void*)(2));
        mbvvol_activar->align(68|FL_ALIGN_INSIDE);
        mbvvol_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* mbvvol_activar
      { mbvvol_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        mbvvol_preset->down_box(FL_BORDER_BOX);
        mbvvol_preset->selection_color(FL_FOREGROUND_COLOR);
        mbvvol_preset->labelsize(10);
        mbvvol_preset->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_preset->textsize(10);
        mbvvol_preset->textcolor(7);
        mbvvol_preset->callback((Fl_Callback*)cb_mbvvol_preset, (void*)(12028));
        mbvvol_preset->when(FL_WHEN_RELEASE_ALWAYS);
        mbvvol_preset->menu(menu_mbvvol_preset);
      } // Fl_Choice* mbvvol_preset
      { mbvvol_WD = new SliderW(372, 238, 100, 10, "Wet/Dry");
        mbvvol_WD->type(5);
        mbvvol_WD->box(FL_FLAT_BOX);
        mbvvol_WD->color((Fl_Color)178);
        mbvvol_WD->selection_color((Fl_Color)62);
        mbvvol_WD->labeltype(FL_NORMAL_LABEL);
        mbvvol_WD->labelfont(0);
        mbvvol_WD->labelsize(10);
        mbvvol_WD->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_WD->minimum(-64);
        mbvvol_WD->maximum(63);
        mbvvol_WD->step(1);
        mbvvol_WD->textcolor(7);
        mbvvol_WD->callback((Fl_Callback*)cb_mbvvol_WD);
        mbvvol_WD->align(FL_ALIGN_LEFT);
        mbvvol_WD->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_WD
      { mbvvol_freq1 = new SliderW(372, 250, 100, 10, "Tempo 1");
        mbvvol_freq1->type(5);
        mbvvol_freq1->box(FL_FLAT_BOX);
        mbvvol_freq1->color((Fl_Color)178);
        mbvvol_freq1->selection_color((Fl_Color)62);
        mbvvol_freq1->labeltype(FL_NORMAL_LABEL);
        mbvvol_freq1->labelfont(0);
        mbvvol_freq1->labelsize(10);
        mbvvol_freq1->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_freq1->minimum(1);
        mbvvol_freq1->maximum(600);
        mbvvol_freq1->step(1);
        mbvvol_freq1->textcolor(7);
        mbvvol_freq1->callback((Fl_Callback*)cb_mbvvol_freq1);
        mbvvol_freq1->align(FL_ALIGN_LEFT);
        mbvvol_freq1->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_freq1
      { Fl_Choice* o = mbvvol_lfotype1 = new Fl_Choice(383, 263, 72, 16, "LFO 1 Type");
        mbvvol_lfotype1->down_box(FL_BORDER_BOX);
        mbvvol_lfotype1->selection_color(FL_FOREGROUND_COLOR);
        mbvvol_lfotype1->labelsize(10);
        mbvvol_lfotype1->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_lfotype1->textsize(10);
        mbvvol_lfotype1->textcolor(7);
        mbvvol_lfotype1->callback((Fl_Callback*)cb_mbvvol_lfotype1);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* mbvvol_lfotype1
      { mbvvol_stdf1 = new SliderW(372, 282, 100, 10, "St.df 1");
        mbvvol_stdf1->type(5);
        mbvvol_stdf1->box(FL_FLAT_BOX);
        mbvvol_stdf1->color((Fl_Color)178);
        mbvvol_stdf1->selection_color((Fl_Color)62);
        mbvvol_stdf1->labeltype(FL_NORMAL_LABEL);
        mbvvol_stdf1->labelfont(0);
        mbvvol_stdf1->labelsize(10);
        mbvvol_stdf1->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_stdf1->maximum(127);
        mbvvol_stdf1->step(1);
        mbvvol_stdf1->textcolor(7);
        mbvvol_stdf1->callback((Fl_Callback*)cb_mbvvol_stdf1);
        mbvvol_stdf1->align(FL_ALIGN_LEFT);
        mbvvol_stdf1->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_stdf1
      { mbvvol_freq2 = new SliderW(372, 294, 100, 10, "Tempo 2");
        mbvvol_freq2->type(5);
        mbvvol_freq2->box(FL_FLAT_BOX);
        mbvvol_freq2->color((Fl_Color)178);
        mbvvol_freq2->selection_color((Fl_Color)62);
        mbvvol_freq2->labeltype(FL_NORMAL_LABEL);
        mbvvol_freq2->labelfont(0);
        mbvvol_freq2->labelsize(10);
        mbvvol_freq2->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_freq2->minimum(1);
        mbvvol_freq2->maximum(600);
        mbvvol_freq2->step(1);
        mbvvol_freq2->textcolor(7);
        mbvvol_freq2->callback((Fl_Callback*)cb_mbvvol_freq2);
        mbvvol_freq2->align(FL_ALIGN_LEFT);
        mbvvol_freq2->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_freq2
      { Fl_Choice* o = mbvvol_lfotype2 = new Fl_Choice(383, 307, 72, 16, "LFO 2 Type");
        mbvvol_lfotype2->down_box(FL_BORDER_BOX);
        mbvvol_lfotype2->selection_color(FL_FOREGROUND_COLOR);
        mbvvol_lfotype2->labelsize(10);
        mbvvol_lfotype2->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_lfotype2->textsize(10);
        mbvvol_lfotype2->textcolor(7);
        mbvvol_lfotype2->callback((Fl_Callback*)cb_mbvvol_lfotype2);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* mbvvol_lfotype2
      { mbvvol_stdf2 = new SliderW(372, 326, 100, 10, "St.df 2");
        mbvvol_stdf2->type(5);
        mbvvol_stdf2->box(FL_FLAT_BOX);
        mbvvol_stdf2->color((Fl_Color)178);
        mbvvol_stdf2->selection_color((Fl_Color)62);
        mbvvol_stdf2->labeltype(FL_NORMAL_LABEL);
        mbvvol_stdf2->labelfont(0);
        mbvvol_stdf2->labelsize(10);
        mbvvol_stdf2->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_stdf2->maximum(127);
        mbvvol_stdf2->step(1);
        mbvvol_stdf2->textcolor(7);
        mbvvol_stdf2->callback((Fl_Callback*)cb_mbvvol_stdf2);
        mbvvol_stdf2->align(FL_ALIGN_LEFT);
        mbvvol_stdf2->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_stdf2
      { mbvvol_cross1 = new SliderW(372, 338, 100, 10, "Cross1");
        mbvvol_cross1->type(5);
        mbvvol_cross1->box(FL_FLAT_BOX);
        mbvvol_cross1->color((Fl_Color)178);
        mbvvol_cross1->selection_color((Fl_Color)62);
        mbvvol_cross1->labeltype(FL_NORMAL_LABEL);
        mbvvol_cross1->labelfont(0);
        mbvvol_cross1->labelsize(10);
        mbvvol_cross1->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_cross1->minimum(20);
        mbvvol_cross1->maximum(1000);
        mbvvol_cross1->step(1);
        mbvvol_cross1->textcolor(7);
        mbvvol_cross1->callback((Fl_Callback*)cb_mbvvol_cross1);
        mbvvol_cross1->align(FL_ALIGN_LEFT);
        mbvvol_cross1->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_cross1
      { mbvvol_cross2 = new SliderW(372, 350, 100, 10, "Cross2");
        mbvvol_cross2->type(5);
        mbvvol_cross2->box(FL_FLAT_BOX);
        mbvvol_cross2->color((Fl_Color)178);
        mbvvol_cross2->selection_color((Fl_Color)62);
        mbvvol_cross2->labeltype(FL_NORMAL_LABEL);
        mbvvol_cross2->labelfont(0);
        mbvvol_cross2->labelsize(10);
        mbvvol_cross2->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_cross2->minimum(1000);
        mbvvol_cross2->maximum(8000);
        mbvvol_cross2->step(1);
        mbvvol_cross2->textcolor(7);
        mbvvol_cross2->callback((Fl_Callback*)cb_mbvvol_cross2);
        mbvvol_cross2->align(FL_ALIGN_LEFT);
        mbvvol_cross2->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_cross2
      { mbvvol_cross3 = new SliderW(372, 362, 100, 10, "Cross3");
        mbvvol_cross3->type(5);
        mbvvol_cross3->box(FL_FLAT_BOX);
        mbvvol_cross3->color((Fl_Color)178);
        mbvvol_cross3->selection_color((Fl_Color)62);
        mbvvol_cross3->labeltype(FL_NORMAL_LABEL);
        mbvvol_cross3->labelfont(0);
        mbvvol_cross3->labelsize(10);
        mbvvol_cross3->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_cross3->minimum(2000);
        mbvvol_cross3->maximum(26000);
        mbvvol_cross3->step(1);
        mbvvol_cross3->textcolor(7);
        mbvvol_cross3->callback((Fl_Callback*)cb_mbvvol_cross3);
        mbvvol_cross3->align(FL_ALIGN_LEFT);
        mbvvol_cross3->when(FL_WHEN_CHANGED);
      } // SliderW* mbvvol_cross3
      { mbvvol_combi = new Fl_Choice(383, 374, 72, 16, "Combi");
        mbvvol_combi->down_box(FL_BORDER_BOX);
        mbvvol_combi->selection_color(FL_FOREGROUND_COLOR);
        mbvvol_combi->labelsize(10);
        mbvvol_combi->labelcolor(FL_BACKGROUND2_COLOR);
        mbvvol_combi->textsize(10);
        mbvvol_combi->textcolor(7);
        mbvvol_combi->callback((Fl_Callback*)cb_mbvvol_combi, (void*)(12));
        mbvvol_combi->menu(menu_mbvvol_combi);
      } // Fl_Choice* mbvvol_combi
      MBVVOL->end();
    } // Fl_Group* MBVVOL
    { CONVOLOTRON = new Fl_Group(320, 210, 158, 184);
      CONVOLOTRON->box(FL_UP_BOX);
      CONVOLOTRON->color(FL_FOREGROUND_COLOR);
      CONVOLOTRON->selection_color(FL_FOREGROUND_COLOR);
      CONVOLOTRON->labelfont(1);
      CONVOLOTRON->user_data((void*)(1));
      CONVOLOTRON->align(96|FL_ALIGN_INSIDE);
      CONVOLOTRON->hide();
      { convo_activar = new Fl_Light_Button(326, 214, 34, 18, "On");
        convo_activar->shortcut(0x35);
        convo_activar->color((Fl_Color)62);
        convo_activar->selection_color((Fl_Color)1);
        convo_activar->labelsize(10);
        convo_activar->callback((Fl_Callback*)cb_convo_activar, (void*)(2));
        convo_activar->align(68|FL_ALIGN_INSIDE);
        convo_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* convo_activar
      { convo_preset = new Fl_Choice(399, 214, 76, 18, "Preset");
        convo_preset->down_box(FL_BORDER_BOX);
        convo_preset->selection_color(FL_FOREGROUND_COLOR);
        convo_preset->labelsize(10);
        convo_preset->labelcolor(FL_BACKGROUND2_COLOR);
        convo_preset->textsize(10);
        convo_preset->textcolor(7);
        convo_preset->callback((Fl_Callback*)cb_convo_preset, (void*)(12029));
        convo_preset->when(FL_WHEN_RELEASE_ALWAYS);
        convo_preset->menu(menu_convo_preset);
      } // Fl_Choice* convo_preset
      { convo_WD = new SliderW(372, 240, 100, 10, "Wet/Dry");
        convo_WD->type(5);
        convo_WD->box(FL_FLAT_BOX);
        convo_WD->color((Fl_Color)178);
        convo_WD->selection_color((Fl_Color)62);
        convo_WD->labeltype(FL_NORMAL_LABEL);
        convo_WD->labelfont(0);
        convo_WD->labelsize(10);
        convo_WD->labelcolor(FL_BACKGROUND2_COLOR);
        convo_WD->minimum(-64);
        convo_WD->maximum(64);
        convo_WD->step(1);
        convo_WD->textcolor(7);
        convo_WD->callback((Fl_Callback*)cb_convo_WD);
        convo_WD->align(FL_ALIGN_LEFT);
        convo_WD->when(FL_WHEN_CHANGED);
      } // SliderW* convo_WD
      { convo_pan = new SliderW(372, 256, 100, 10, "Pan");
        convo_pan->type(5);
        convo_pan->box(FL_FLAT_BOX);
        convo_pan->color((Fl_Color)178);
        convo_pan->selection_color((Fl_Color)62);
        convo_pan->labeltype(FL_NORMAL_LABEL);
        convo_pan->labelfont(0);
        convo_pan->labelsize(10);
        convo_pan->labelcolor(FL_BACKGROUND2_COLOR);
        convo_pan->minimum(-64);
        convo_pan->maximum(63);
        convo_pan->step(1);
        convo_pan->textcolor(7);
        convo_pan->callback((Fl_Callback*)cb_convo_pan);
        convo_pan->align(FL_ALIGN_LEFT);
        convo_pan->when(FL_WHEN_CHANGED);
      } // SliderW* convo_pan
      { convo_level = new SliderW(372, 272, 100, 10, "Level");
        convo_level->type(5);
        convo_level->box(FL_FLAT_BOX);
        convo_level->color((Fl_Color)178);
        convo_level->selection_color((Fl_Color)62);
        convo_level->labeltype(FL_NORMAL_LABEL);
        convo_level->labelfont(0);
        convo_level->labelsize(10);
        convo_level->labelcolor(FL_BACKGROUND2_COLOR);
        convo_level->maximum(127);
        convo_level->step(1);
        convo_level->textcolor(7);
        convo_level->callback((Fl_Callback*)cb_convo_level);
        convo_level->align(FL_ALIGN_LEFT);
        convo_level->when(FL_WHEN_CHANGED);
      } // SliderW* convo_level
      { convo_damp = new SliderW(372, 288, 100, 10, "Damp");
        convo_damp->type(5);
        convo_damp->box(FL_FLAT_BOX);
        convo_damp->color((Fl_Color)178);
        convo_damp->selection_color((Fl_Color)62);
        convo_damp->labeltype(FL_NORMAL_LABEL);
        convo_damp->labelfont(0);
        convo_damp->labelsize(10);
        convo_damp->labelcolor(FL_BACKGROUND2_COLOR);
        convo_damp->maximum(127);
        convo_damp->step(1);
        convo_damp->textcolor(7);
        convo_damp->callback((Fl_Callback*)cb_convo_damp);
        convo_damp->align(FL_ALIGN_LEFT);
        convo_damp->when(FL_WHEN_CHANGED);
      } // SliderW* convo_damp
      { convo_fb = new SliderW(372, 304, 100, 10, "Fb");
        convo_fb->type(5);
        convo_fb->box(FL_FLAT_BOX);
        convo_fb->color((Fl_Color)178);
        convo_fb->selection_color((Fl_Color)62);
        convo_fb->labeltype(FL_NORMAL_LABEL);
        convo_fb->labelfont(0);
        convo_fb->labelsize(10);
        convo_fb->labelcolor(FL_BACKGROUND2_COLOR);
        convo_fb->minimum(-64);
        convo_fb->maximum(64);
        convo_fb->step(1);
        convo_fb->textcolor(7);
        convo_fb->callback((Fl_Callback*)cb_convo_fb);
        convo_fb->align(FL_ALIGN_LEFT);
        convo_fb->when(FL_WHEN_CHANGED);
      } // SliderW* convo_fb
      { convo_length = new SliderW(372, 320, 100, 10, "Length");
        convo_length->type(5);
        convo_length->box(FL_FLAT_BOX);
        convo_length->color((Fl_Color)178);
        convo_length->selection_color((Fl_Color)62);
        convo_length->labeltype(FL_NORMAL_LABEL);
        convo_length->labelfont(0);
        convo_length->labelsize(10);
        convo_length->labelcolor(FL_BACKGROUND2_COLOR);
        convo_length->minimum(5);
        convo_length->maximum(250);
        convo_length->step(1);
        convo_length->value(100);
        convo_length->textcolor(7);
        convo_length->callback((Fl_Callback*)cb_convo_length);
        convo_length->align(FL_ALIGN_LEFT);
        convo_length->when(FL_WHEN_RELEASE);
      } // SliderW* convo_length
      { convo_user = new Fl_Check_Button(430, 336, 15, 15, "User");
        convo_user->down_box(FL_BORDER_BOX);
        convo_user->labelsize(10);
        convo_user->labelcolor(FL_BACKGROUND2_COLOR);
        convo_user->callback((Fl_Callback*)cb_convo_user, (void*)(2));
      } // Fl_Check_Button* convo_user
      { convo_safe = new Fl_Check_Button(339, 351, 15, 15, "Safe Mode");
        convo_safe->down_box(FL_BORDER_BOX);
        convo_safe->labelsize(10);
        convo_safe->labelcolor(FL_BACKGROUND2_COLOR);
        convo_safe->callback((Fl_Callback*)cb_convo_safe, (void*)(2));
      } // Fl_Check_Button* convo_safe
      { B_wav = new Fl_Button(426, 353, 46, 12, "Browse");
        B_wav->labelsize(10);
        B_wav->callback((Fl_Callback*)cb_B_wav, (void*)(2));
        B_wav->deactivate();
      } // Fl_Button* B_wav
      { convo_fnum = new Fl_Choice(371, 369, 101, 16, "Preset");
        convo_fnum->down_box(FL_BORDER_BOX);
        convo_fnum->selection_color(FL_FOREGROUND_COLOR);
        convo_fnum->labelsize(10);
        convo_fnum->labelcolor(FL_BACKGROUND2_COLOR);
        convo_fnum->textsize(10);
        convo_fnum->textcolor(7);
        convo_fnum->callback((Fl_Callback*)cb_convo_fnum, (void*)(12));
        convo_fnum->menu(menu_convo_fnum);
      } // Fl_Choice* convo_fnum
      CONVOLOTRON->end();
    } // Fl_Group* CONVOLOTRON
    { LOOPER = new Fl_Group(321, 211, 158, 184);
      LOOPER->box(FL_UP_BOX);
      LOOPER->color(FL_FOREGROUND_COLOR);
      LOOPER->selection_color(FL_FOREGROUND_COLOR);
      LOOPER->labelfont(1);
      LOOPER->user_data((void*)(1));
      LOOPER->align(96|FL_ALIGN_INSIDE);
      LOOPER->hide();
      { looper_activar = new Fl_Light_Button(326, 215, 34, 18, "On");
        looper_activar->shortcut(0x35);
        looper_activar->color((Fl_Color)62);
        looper_activar->selection_color((Fl_Color)1);
        looper_activar->labelsize(10);
        looper_activar->callback((Fl_Callback*)cb_looper_activar, (void*)(2));
        looper_activar->align(68|FL_ALIGN_INSIDE);
        looper_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* looper_activar
      { looper_preset = new Fl_Choice(398, 215, 76, 18, "Preset");
        looper_preset->down_box(FL_BORDER_BOX);
        looper_preset->selection_color(FL_FOREGROUND_COLOR);
        looper_preset->labelsize(10);
        looper_preset->labelcolor(FL_BACKGROUND2_COLOR);
        looper_preset->textsize(10);
        looper_preset->textcolor(7);
        looper_preset->callback((Fl_Callback*)cb_looper_preset, (void*)(12030));
        looper_preset->when(FL_WHEN_RELEASE_ALWAYS);
        looper_preset->menu(menu_looper_preset);
      } // Fl_Choice* looper_preset
      { looper_WD = new SliderW(372, 236, 100, 10, "Wet/Dry");
        looper_WD->type(5);
        looper_WD->box(FL_FLAT_BOX);
        looper_WD->color((Fl_Color)178);
        looper_WD->selection_color((Fl_Color)62);
        looper_WD->labeltype(FL_NORMAL_LABEL);
        looper_WD->labelfont(0);
        looper_WD->labelsize(10);
        looper_WD->labelcolor(FL_BACKGROUND2_COLOR);
        looper_WD->minimum(-64);
        looper_WD->maximum(63);
        looper_WD->step(1);
        looper_WD->textcolor(7);
        looper_WD->callback((Fl_Callback*)cb_looper_WD);
        looper_WD->align(FL_ALIGN_LEFT);
        looper_WD->when(FL_WHEN_CHANGED);
      } // SliderW* looper_WD
      { looper_level1 = new SliderW(372, 248, 100, 10, "Level 1");
        looper_level1->type(5);
        looper_level1->box(FL_FLAT_BOX);
        looper_level1->color((Fl_Color)178);
        looper_level1->selection_color((Fl_Color)62);
        looper_level1->labeltype(FL_NORMAL_LABEL);
        looper_level1->labelfont(0);
        looper_level1->labelsize(10);
        looper_level1->labelcolor(FL_BACKGROUND2_COLOR);
        looper_level1->maximum(127);
        looper_level1->step(1);
        looper_level1->textcolor(7);
        looper_level1->callback((Fl_Callback*)cb_looper_level1);
        looper_level1->align(FL_ALIGN_LEFT);
        looper_level1->when(FL_WHEN_RELEASE);
      } // SliderW* looper_level1
      { looper_level2 = new SliderW(372, 260, 100, 10, "Level 2");
        looper_level2->type(5);
        looper_level2->box(FL_FLAT_BOX);
        looper_level2->color((Fl_Color)178);
        looper_level2->selection_color((Fl_Color)62);
        looper_level2->labeltype(FL_NORMAL_LABEL);
        looper_level2->labelfont(0);
        looper_level2->labelsize(10);
        looper_level2->labelcolor(FL_BACKGROUND2_COLOR);
        looper_level2->maximum(127);
        looper_level2->step(1);
        looper_level2->textcolor(7);
        looper_level2->callback((Fl_Callback*)cb_looper_level2);
        looper_level2->align(FL_ALIGN_LEFT);
        looper_level2->when(FL_WHEN_RELEASE);
      } // SliderW* looper_level2
      { looper_Tempo = new SliderW(372, 272, 100, 10, "Tempo");
        looper_Tempo->type(5);
        looper_Tempo->box(FL_FLAT_BOX);
        looper_Tempo->color((Fl_Color)178);
        looper_Tempo->selection_color((Fl_Color)62);
        looper_Tempo->labeltype(FL_NORMAL_LABEL);
        looper_Tempo->labelfont(0);
        looper_Tempo->labelsize(10);
        looper_Tempo->labelcolor(FL_BACKGROUND2_COLOR);
        looper_Tempo->minimum(20);
        looper_Tempo->maximum(380);
        looper_Tempo->step(1);
        looper_Tempo->value(100);
        looper_Tempo->textcolor(7);
        looper_Tempo->callback((Fl_Callback*)cb_looper_Tempo);
        looper_Tempo->align(FL_ALIGN_LEFT);
        looper_Tempo->when(FL_WHEN_RELEASE);
      } // SliderW* looper_Tempo
      { looper_bar = new Fl_Choice(378, 284, 40, 15, "Time Sig.");
        looper_bar->down_box(FL_BORDER_BOX);
        looper_bar->selection_color(FL_FOREGROUND_COLOR);
        looper_bar->labelsize(10);
        looper_bar->labelcolor(FL_BACKGROUND2_COLOR);
        looper_bar->textsize(10);
        looper_bar->textcolor(7);
        looper_bar->callback((Fl_Callback*)cb_looper_bar);
        looper_bar->when(FL_WHEN_RELEASE_ALWAYS);
        looper_bar->menu(menu_looper_bar);
      } // Fl_Choice* looper_bar
      { looper_ms = new Fl_Choice(442, 284, 29, 15, "MS");
        looper_ms->down_box(FL_BORDER_BOX);
        looper_ms->selection_color(FL_FOREGROUND_COLOR);
        looper_ms->labelsize(10);
        looper_ms->labelcolor(FL_BACKGROUND2_COLOR);
        looper_ms->textsize(10);
        looper_ms->textcolor(7);
        looper_ms->callback((Fl_Callback*)cb_looper_ms);
        looper_ms->when(FL_WHEN_RELEASE_ALWAYS);
        looper_ms->menu(menu_looper_ms);
      } // Fl_Choice* looper_ms
      { looper_rv = new Fl_Check_Button(329, 300, 15, 15, "Reverse");
        looper_rv->down_box(FL_BORDER_BOX);
        looper_rv->labelsize(10);
        looper_rv->labelcolor(FL_BACKGROUND2_COLOR);
        looper_rv->callback((Fl_Callback*)cb_looper_rv, (void*)(2));
      } // Fl_Check_Button* looper_rv
      { looper_ap = new Fl_Check_Button(399, 300, 15, 15, "Auto Play");
        looper_ap->down_box(FL_BORDER_BOX);
        looper_ap->labelsize(10);
        looper_ap->labelcolor(FL_BACKGROUND2_COLOR);
        looper_ap->callback((Fl_Callback*)cb_looper_ap, (void*)(2));
      } // Fl_Check_Button* looper_ap
      { Box_Play = new Fl_Box(325, 314, 52, 14, "Play/Stop");
        Box_Play->labelsize(10);
        Box_Play->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* Box_Play
      { Box_P = new Fl_Box(379, 314, 44, 14, "Pause");
        Box_P->labelsize(10);
        Box_P->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* Box_P
      { Fl_Box* o = new Fl_Box(430, 314, 44, 14, "Record");
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* o
      { looper_play = new Fl_Button(329, 328, 44, 22, "@|>");
        looper_play->type(1);
        looper_play->shortcut(0xffc2);
        looper_play->callback((Fl_Callback*)cb_looper_play, (void*)(2));
      } // Fl_Button* looper_play
      { looper_stop = new Fl_Button(380, 328, 44, 22, "@||");
        looper_stop->type(1);
        looper_stop->shortcut(0xffc3);
        looper_stop->callback((Fl_Callback*)cb_looper_stop, (void*)(2));
      } // Fl_Button* looper_stop
      { looper_record = new Fl_Button(430, 328, 44, 22, "@circle");
        looper_record->type(1);
        looper_record->labelcolor((Fl_Color)1);
        looper_record->callback((Fl_Callback*)cb_looper_record, (void*)(2));
      } // Fl_Button* looper_record
      { Fl_Box* o = new Fl_Box(392, 360, 39, 14, "Track");
        o->labelsize(10);
        o->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* o
      { looper_r1 = new Fl_Check_Button(329, 364, 15, 15, "R1");
        looper_r1->down_box(FL_BORDER_BOX);
        looper_r1->labelsize(10);
        looper_r1->labelcolor(FL_BACKGROUND2_COLOR);
        looper_r1->callback((Fl_Callback*)cb_looper_r1, (void*)(2));
        looper_r1->align(FL_ALIGN_TOP);
      } // Fl_Check_Button* looper_r1
      { looper_r2 = new Fl_Check_Button(348, 364, 15, 15, "R2");
        looper_r2->down_box(FL_BORDER_BOX);
        looper_r2->labelsize(10);
        looper_r2->labelcolor(FL_BACKGROUND2_COLOR);
        looper_r2->callback((Fl_Callback*)cb_looper_r2, (void*)(2));
        looper_r2->align(FL_ALIGN_TOP);
      } // Fl_Check_Button* looper_r2
      { looper_t1 = new Fl_Button(432, 358, 18, 18, "1");
        looper_t1->type(1);
        looper_t1->labelsize(10);
        looper_t1->callback((Fl_Callback*)cb_looper_t1, (void*)(2));
        looper_t1->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Button* looper_t1
      { looper_t2 = new Fl_Button(455, 358, 18, 18, "2");
        looper_t2->type(1);
        looper_t2->labelsize(10);
        looper_t2->callback((Fl_Callback*)cb_looper_t2, (void*)(2));
        looper_t2->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Button* looper_t2
      { looper_lnk = new Fl_Check_Button(348, 378, 15, 15, "Lnk");
        looper_lnk->down_box(FL_BORDER_BOX);
        looper_lnk->labelsize(10);
        looper_lnk->labelcolor(FL_BACKGROUND2_COLOR);
        looper_lnk->callback((Fl_Callback*)cb_looper_lnk, (void*)(2));
        looper_lnk->align(FL_ALIGN_LEFT);
      } // Fl_Check_Button* looper_lnk
      { looper_clear = new Fl_Button(367, 376, 43, 14, "Clear");
        looper_clear->labelsize(10);
        looper_clear->callback((Fl_Callback*)cb_looper_clear, (void*)(2));
      } // Fl_Button* looper_clear
      { looper_mt = new Fl_Check_Button(414, 378, 15, 15, "M");
        looper_mt->down_box(FL_BORDER_BOX);
        looper_mt->labelsize(10);
        looper_mt->labelcolor(FL_BACKGROUND2_COLOR);
        looper_mt->callback((Fl_Callback*)cb_looper_mt, (void*)(2));
      } // Fl_Check_Button* looper_mt
      { L_TimePos = new Fl_Box(442, 377, 35, 14);
        L_TimePos->box(FL_DOWN_BOX);
        L_TimePos->align(68|FL_ALIGN_INSIDE);
      } // Fl_Box* L_TimePos
      LOOPER->end();
    } // Fl_Group* LOOPER
    { RYANWAH = new Fl_Group(318, 209, 158, 184);
      RYANWAH->box(FL_UP_BOX);
      RYANWAH->color(FL_FOREGROUND_COLOR);
      RYANWAH->selection_color(FL_FOREGROUND_COLOR);
      RYANWAH->labelfont(1);
      RYANWAH->user_data((void*)(1));
      RYANWAH->align(96|FL_ALIGN_INSIDE);
      RYANWAH->hide();
      { ryanwah_activar = new Fl_Light_Button(323, 213, 34, 18, "On");
        ryanwah_activar->shortcut(0x36);
        ryanwah_activar->color((Fl_Color)62);
        ryanwah_activar->selection_color((Fl_Color)1);
        ryanwah_activar->labelsize(10);
        ryanwah_activar->callback((Fl_Callback*)cb_ryanwah_activar, (void*)(2));
        ryanwah_activar->align(68|FL_ALIGN_INSIDE);
        ryanwah_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* ryanwah_activar
      { ryanwah_preset = new Fl_Choice(395, 213, 76, 18, "Preset");
        ryanwah_preset->down_box(FL_BORDER_BOX);
        ryanwah_preset->selection_color(FL_FOREGROUND_COLOR);
        ryanwah_preset->labelsize(10);
        ryanwah_preset->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_preset->textsize(10);
        ryanwah_preset->textcolor(7);
        ryanwah_preset->callback((Fl_Callback*)cb_ryanwah_preset, (void*)(12031));
        ryanwah_preset->when(FL_WHEN_RELEASE_ALWAYS);
        ryanwah_preset->menu(menu_ryanwah_preset);
      } // Fl_Choice* ryanwah_preset
      { ryanwah_WD = new SliderW(367, 238, 100, 10, "Wet/Dry");
        ryanwah_WD->type(5);
        ryanwah_WD->box(FL_FLAT_BOX);
        ryanwah_WD->color((Fl_Color)178);
        ryanwah_WD->selection_color((Fl_Color)62);
        ryanwah_WD->labeltype(FL_NORMAL_LABEL);
        ryanwah_WD->labelfont(0);
        ryanwah_WD->labelsize(10);
        ryanwah_WD->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_WD->minimum(-64);
        ryanwah_WD->maximum(63);
        ryanwah_WD->step(1);
        ryanwah_WD->textcolor(7);
        ryanwah_WD->callback((Fl_Callback*)cb_ryanwah_WD);
        ryanwah_WD->align(FL_ALIGN_LEFT);
        ryanwah_WD->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_WD
      { ryanwah_lp = new SliderW(367, 252, 100, 10, "LP");
        ryanwah_lp->type(5);
        ryanwah_lp->box(FL_FLAT_BOX);
        ryanwah_lp->color((Fl_Color)178);
        ryanwah_lp->selection_color((Fl_Color)62);
        ryanwah_lp->labeltype(FL_NORMAL_LABEL);
        ryanwah_lp->labelfont(0);
        ryanwah_lp->labelsize(10);
        ryanwah_lp->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_lp->minimum(-64);
        ryanwah_lp->maximum(64);
        ryanwah_lp->step(1);
        ryanwah_lp->textcolor(7);
        ryanwah_lp->callback((Fl_Callback*)cb_ryanwah_lp);
        ryanwah_lp->align(FL_ALIGN_LEFT);
        ryanwah_lp->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_lp
      { ryanwah_qm = new Fl_Check_Button(327, 269, 15, 15, "Mode");
        ryanwah_qm->down_box(FL_BORDER_BOX);
        ryanwah_qm->labelsize(10);
        ryanwah_qm->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_qm->callback((Fl_Callback*)cb_ryanwah_qm, (void*)(2));
        ryanwah_qm->align(FL_ALIGN_TOP);
      } // Fl_Check_Button* ryanwah_qm
      { ryanwah_bp = new SliderW(367, 263, 100, 10, "BP");
        ryanwah_bp->type(5);
        ryanwah_bp->box(FL_FLAT_BOX);
        ryanwah_bp->color((Fl_Color)178);
        ryanwah_bp->selection_color((Fl_Color)62);
        ryanwah_bp->labeltype(FL_NORMAL_LABEL);
        ryanwah_bp->labelfont(0);
        ryanwah_bp->labelsize(10);
        ryanwah_bp->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_bp->minimum(-64);
        ryanwah_bp->maximum(64);
        ryanwah_bp->step(1);
        ryanwah_bp->textcolor(7);
        ryanwah_bp->callback((Fl_Callback*)cb_ryanwah_bp);
        ryanwah_bp->align(FL_ALIGN_LEFT);
        ryanwah_bp->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_bp
      { ryanwah_hp = new SliderW(367, 274, 100, 10, "HP");
        ryanwah_hp->type(5);
        ryanwah_hp->box(FL_FLAT_BOX);
        ryanwah_hp->color((Fl_Color)178);
        ryanwah_hp->selection_color((Fl_Color)62);
        ryanwah_hp->labeltype(FL_NORMAL_LABEL);
        ryanwah_hp->labelfont(0);
        ryanwah_hp->labelsize(10);
        ryanwah_hp->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_hp->minimum(-64);
        ryanwah_hp->maximum(64);
        ryanwah_hp->step(1);
        ryanwah_hp->textcolor(7);
        ryanwah_hp->callback((Fl_Callback*)cb_ryanwah_hp);
        ryanwah_hp->align(FL_ALIGN_LEFT);
        ryanwah_hp->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_hp
      { svfilter_stages = new Fl_Counter(344, 291, 27, 12, "Stg");
        svfilter_stages->type(1);
        svfilter_stages->box(FL_THIN_UP_BOX);
        svfilter_stages->labelsize(10);
        svfilter_stages->labelcolor(FL_BACKGROUND2_COLOR);
        svfilter_stages->minimum(1);
        svfilter_stages->maximum(12);
        svfilter_stages->step(1);
        svfilter_stages->value(1);
        svfilter_stages->textsize(9);
        svfilter_stages->callback((Fl_Callback*)cb_svfilter_stages);
        svfilter_stages->align(FL_ALIGN_LEFT);
      } // Fl_Counter* svfilter_stages
      { Fl_Choice* o = ryanwah_lfotype = new Fl_Choice(397, 290, 72, 16, "LFO");
        ryanwah_lfotype->down_box(FL_BORDER_BOX);
        ryanwah_lfotype->selection_color(FL_FOREGROUND_COLOR);
        ryanwah_lfotype->labelsize(10);
        ryanwah_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_lfotype->textsize(10);
        ryanwah_lfotype->textcolor(7);
        ryanwah_lfotype->callback((Fl_Callback*)cb_ryanwah_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* ryanwah_lfotype
      { ryanwah_dpth = new SliderW(367, 310, 100, 10, "Width");
        ryanwah_dpth->type(5);
        ryanwah_dpth->box(FL_FLAT_BOX);
        ryanwah_dpth->color((Fl_Color)178);
        ryanwah_dpth->selection_color((Fl_Color)62);
        ryanwah_dpth->labeltype(FL_NORMAL_LABEL);
        ryanwah_dpth->labelfont(0);
        ryanwah_dpth->labelsize(10);
        ryanwah_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_dpth->maximum(127);
        ryanwah_dpth->step(1);
        ryanwah_dpth->textcolor(7);
        ryanwah_dpth->callback((Fl_Callback*)cb_ryanwah_dpth);
        ryanwah_dpth->align(FL_ALIGN_LEFT);
        ryanwah_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_dpth
      { ryanwah_freq = new SliderW(367, 322, 100, 10, "Tempo");
        ryanwah_freq->type(5);
        ryanwah_freq->box(FL_FLAT_BOX);
        ryanwah_freq->color((Fl_Color)178);
        ryanwah_freq->selection_color((Fl_Color)62);
        ryanwah_freq->labeltype(FL_NORMAL_LABEL);
        ryanwah_freq->labelfont(0);
        ryanwah_freq->labelsize(10);
        ryanwah_freq->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_freq->minimum(1);
        ryanwah_freq->maximum(600);
        ryanwah_freq->step(1);
        ryanwah_freq->textcolor(7);
        ryanwah_freq->callback((Fl_Callback*)cb_ryanwah_freq);
        ryanwah_freq->align(FL_ALIGN_LEFT);
        ryanwah_freq->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_freq
      { ryanwah_q = new SliderW(367, 334, 100, 10, "Res.");
        ryanwah_q->type(5);
        ryanwah_q->box(FL_FLAT_BOX);
        ryanwah_q->color((Fl_Color)178);
        ryanwah_q->selection_color((Fl_Color)62);
        ryanwah_q->labeltype(FL_NORMAL_LABEL);
        ryanwah_q->labelfont(0);
        ryanwah_q->labelsize(10);
        ryanwah_q->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_q->minimum(1);
        ryanwah_q->maximum(127);
        ryanwah_q->step(1);
        ryanwah_q->textcolor(7);
        ryanwah_q->callback((Fl_Callback*)cb_ryanwah_q);
        ryanwah_q->align(FL_ALIGN_LEFT);
        ryanwah_q->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_q
      { ryanwah_rng = new SliderW(367, 345, 100, 10, "Range");
        ryanwah_rng->type(5);
        ryanwah_rng->box(FL_FLAT_BOX);
        ryanwah_rng->color((Fl_Color)178);
        ryanwah_rng->selection_color((Fl_Color)62);
        ryanwah_rng->labeltype(FL_NORMAL_LABEL);
        ryanwah_rng->labelfont(0);
        ryanwah_rng->labelsize(10);
        ryanwah_rng->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_rng->minimum(10);
        ryanwah_rng->maximum(6000);
        ryanwah_rng->step(1);
        ryanwah_rng->textcolor(7);
        ryanwah_rng->callback((Fl_Callback*)cb_ryanwah_rng);
        ryanwah_rng->align(FL_ALIGN_LEFT);
        ryanwah_rng->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_rng
      { ryanwah_ampsnsinv = new SliderW(367, 356, 100, 10, "Wah");
        ryanwah_ampsnsinv->type(5);
        ryanwah_ampsnsinv->box(FL_FLAT_BOX);
        ryanwah_ampsnsinv->color((Fl_Color)178);
        ryanwah_ampsnsinv->selection_color((Fl_Color)62);
        ryanwah_ampsnsinv->labeltype(FL_NORMAL_LABEL);
        ryanwah_ampsnsinv->labelfont(0);
        ryanwah_ampsnsinv->labelsize(10);
        ryanwah_ampsnsinv->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_ampsnsinv->maximum(127);
        ryanwah_ampsnsinv->step(1);
        ryanwah_ampsnsinv->textcolor(7);
        ryanwah_ampsnsinv->callback((Fl_Callback*)cb_ryanwah_ampsnsinv);
        ryanwah_ampsnsinv->align(FL_ALIGN_LEFT);
        ryanwah_ampsnsinv->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_ampsnsinv
      { ryanwah_ampsns = new SliderW(367, 367, 100, 10, "E. Sens");
        ryanwah_ampsns->type(5);
        ryanwah_ampsns->box(FL_FLAT_BOX);
        ryanwah_ampsns->color((Fl_Color)178);
        ryanwah_ampsns->selection_color((Fl_Color)62);
        ryanwah_ampsns->labeltype(FL_NORMAL_LABEL);
        ryanwah_ampsns->labelfont(0);
        ryanwah_ampsns->labelsize(10);
        ryanwah_ampsns->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_ampsns->minimum(-64);
        ryanwah_ampsns->maximum(64);
        ryanwah_ampsns->step(1);
        ryanwah_ampsns->textcolor(7);
        ryanwah_ampsns->callback((Fl_Callback*)cb_ryanwah_ampsns);
        ryanwah_ampsns->align(FL_ALIGN_LEFT);
        ryanwah_ampsns->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_ampsns
      { ryanwah_smooth = new SliderW(367, 378, 100, 10, "Smooth");
        ryanwah_smooth->type(5);
        ryanwah_smooth->box(FL_FLAT_BOX);
        ryanwah_smooth->color((Fl_Color)178);
        ryanwah_smooth->selection_color((Fl_Color)62);
        ryanwah_smooth->labeltype(FL_NORMAL_LABEL);
        ryanwah_smooth->labelfont(0);
        ryanwah_smooth->labelsize(10);
        ryanwah_smooth->labelcolor(FL_BACKGROUND2_COLOR);
        ryanwah_smooth->maximum(127);
        ryanwah_smooth->step(1);
        ryanwah_smooth->textcolor(7);
        ryanwah_smooth->callback((Fl_Callback*)cb_ryanwah_smooth);
        ryanwah_smooth->align(FL_ALIGN_LEFT);
        ryanwah_smooth->when(FL_WHEN_CHANGED);
      } // SliderW* ryanwah_smooth
      RYANWAH->end();
    } // Fl_Group* RYANWAH
    { RBECHO = new Fl_Group(320, 211, 161, 184);
      RBECHO->box(FL_UP_BOX);
      RBECHO->color(FL_FOREGROUND_COLOR);
      RBECHO->selection_color(FL_FOREGROUND_COLOR);
      RBECHO->labelfont(1);
      RBECHO->user_data((void*)(1));
      RBECHO->align(96|FL_ALIGN_INSIDE);
      RBECHO->hide();
      { rbecho_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        rbecho_activar->shortcut(0x35);
        rbecho_activar->color((Fl_Color)62);
        rbecho_activar->selection_color((Fl_Color)1);
        rbecho_activar->labelsize(10);
        rbecho_activar->callback((Fl_Callback*)cb_rbecho_activar, (void*)(2));
        rbecho_activar->align(68|FL_ALIGN_INSIDE);
        rbecho_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* rbecho_activar
      { rbecho_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        rbecho_preset->down_box(FL_BORDER_BOX);
        rbecho_preset->selection_color(FL_FOREGROUND_COLOR);
        rbecho_preset->labelsize(10);
        rbecho_preset->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_preset->textsize(10);
        rbecho_preset->textcolor(7);
        rbecho_preset->callback((Fl_Callback*)cb_rbecho_preset, (void*)(12032));
        rbecho_preset->when(FL_WHEN_RELEASE_ALWAYS);
        rbecho_preset->menu(menu_rbecho_preset);
      } // Fl_Choice* rbecho_preset
      { rbecho_WD = new SliderW(371, 238, 100, 10, "Wet/Dry");
        rbecho_WD->type(5);
        rbecho_WD->box(FL_FLAT_BOX);
        rbecho_WD->color((Fl_Color)178);
        rbecho_WD->selection_color((Fl_Color)62);
        rbecho_WD->labeltype(FL_NORMAL_LABEL);
        rbecho_WD->labelfont(0);
        rbecho_WD->labelsize(10);
        rbecho_WD->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_WD->minimum(-64);
        rbecho_WD->maximum(63);
        rbecho_WD->step(1);
        rbecho_WD->textcolor(7);
        rbecho_WD->callback((Fl_Callback*)cb_rbecho_WD);
        rbecho_WD->align(FL_ALIGN_LEFT);
        rbecho_WD->when(FL_WHEN_CHANGED);
      } // SliderW* rbecho_WD
      { rbecho_RV = new SliderW(371, 252, 100, 10, "Reverse");
        rbecho_RV->type(5);
        rbecho_RV->box(FL_FLAT_BOX);
        rbecho_RV->color((Fl_Color)178);
        rbecho_RV->selection_color((Fl_Color)62);
        rbecho_RV->labeltype(FL_NORMAL_LABEL);
        rbecho_RV->labelfont(0);
        rbecho_RV->labelsize(10);
        rbecho_RV->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_RV->maximum(127);
        rbecho_RV->step(1);
        rbecho_RV->textcolor(7);
        rbecho_RV->callback((Fl_Callback*)cb_rbecho_RV);
        rbecho_RV->align(FL_ALIGN_LEFT);
        rbecho_RV->when(FL_WHEN_CHANGED);
      } // SliderW* rbecho_RV
      { rbecho_pan = new SliderW(371, 266, 100, 10, "Pan");
        rbecho_pan->type(5);
        rbecho_pan->box(FL_FLAT_BOX);
        rbecho_pan->color((Fl_Color)178);
        rbecho_pan->selection_color((Fl_Color)62);
        rbecho_pan->labeltype(FL_NORMAL_LABEL);
        rbecho_pan->labelfont(0);
        rbecho_pan->labelsize(10);
        rbecho_pan->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_pan->minimum(-64);
        rbecho_pan->maximum(63);
        rbecho_pan->step(1);
        rbecho_pan->textcolor(7);
        rbecho_pan->callback((Fl_Callback*)cb_rbecho_pan);
        rbecho_pan->align(FL_ALIGN_LEFT);
        rbecho_pan->when(FL_WHEN_CHANGED);
      } // SliderW* rbecho_pan
      { rbecho_delay = new SliderW(371, 280, 100, 10, "Tempo");
        rbecho_delay->type(5);
        rbecho_delay->box(FL_FLAT_BOX);
        rbecho_delay->color((Fl_Color)178);
        rbecho_delay->selection_color((Fl_Color)62);
        rbecho_delay->labeltype(FL_NORMAL_LABEL);
        rbecho_delay->labelfont(0);
        rbecho_delay->labelsize(10);
        rbecho_delay->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_delay->minimum(1);
        rbecho_delay->maximum(600);
        rbecho_delay->step(1);
        rbecho_delay->value(20);
        rbecho_delay->textcolor(7);
        rbecho_delay->callback((Fl_Callback*)cb_rbecho_delay);
        rbecho_delay->align(FL_ALIGN_LEFT);
        rbecho_delay->when(FL_WHEN_RELEASE);
      } // SliderW* rbecho_delay
      { rbecho_LRdl = new SliderW(371, 294, 100, 10, "LRdl.");
        rbecho_LRdl->type(5);
        rbecho_LRdl->box(FL_FLAT_BOX);
        rbecho_LRdl->color((Fl_Color)178);
        rbecho_LRdl->selection_color((Fl_Color)62);
        rbecho_LRdl->labeltype(FL_NORMAL_LABEL);
        rbecho_LRdl->labelfont(0);
        rbecho_LRdl->labelsize(10);
        rbecho_LRdl->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_LRdl->maximum(127);
        rbecho_LRdl->step(1);
        rbecho_LRdl->textcolor(7);
        rbecho_LRdl->callback((Fl_Callback*)cb_rbecho_LRdl);
        rbecho_LRdl->align(FL_ALIGN_LEFT);
        rbecho_LRdl->when(FL_WHEN_RELEASE);
      } // SliderW* rbecho_LRdl
      { rbecho_fb = new SliderW(371, 308, 100, 10, "Fb.");
        rbecho_fb->type(5);
        rbecho_fb->box(FL_FLAT_BOX);
        rbecho_fb->color((Fl_Color)178);
        rbecho_fb->selection_color((Fl_Color)62);
        rbecho_fb->labeltype(FL_NORMAL_LABEL);
        rbecho_fb->labelfont(0);
        rbecho_fb->labelsize(10);
        rbecho_fb->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_fb->maximum(127);
        rbecho_fb->step(1);
        rbecho_fb->textcolor(7);
        rbecho_fb->callback((Fl_Callback*)cb_rbecho_fb);
        rbecho_fb->align(FL_ALIGN_LEFT);
        rbecho_fb->when(FL_WHEN_CHANGED);
      } // SliderW* rbecho_fb
      { Fl_Choice* o = rbecho_subdiv = new Fl_Choice(397, 322, 76, 18, "SubDivision");
        rbecho_subdiv->down_box(FL_BORDER_BOX);
        rbecho_subdiv->selection_color(FL_FOREGROUND_COLOR);
        rbecho_subdiv->labelsize(10);
        rbecho_subdiv->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_subdiv->textsize(10);
        rbecho_subdiv->textcolor(7);
        rbecho_subdiv->callback((Fl_Callback*)cb_rbecho_subdiv);
        rbecho_subdiv->when(FL_WHEN_RELEASE_ALWAYS);
        o->menu(menu_arpie_subdiv);
      } // Fl_Choice* rbecho_subdiv
      { rbecho_damp = new SliderW(371, 345, 100, 10, "Damp");
        rbecho_damp->type(5);
        rbecho_damp->box(FL_FLAT_BOX);
        rbecho_damp->color((Fl_Color)178);
        rbecho_damp->selection_color((Fl_Color)62);
        rbecho_damp->labeltype(FL_NORMAL_LABEL);
        rbecho_damp->labelfont(0);
        rbecho_damp->labelsize(10);
        rbecho_damp->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_damp->maximum(127);
        rbecho_damp->step(1);
        rbecho_damp->textcolor(7);
        rbecho_damp->callback((Fl_Callback*)cb_rbecho_damp);
        rbecho_damp->align(FL_ALIGN_LEFT);
        rbecho_damp->when(FL_WHEN_CHANGED);
      } // SliderW* rbecho_damp
      { rbecho_es = new SliderW(371, 359, 100, 10, "E.S.");
        rbecho_es->type(5);
        rbecho_es->box(FL_FLAT_BOX);
        rbecho_es->color((Fl_Color)178);
        rbecho_es->selection_color((Fl_Color)62);
        rbecho_es->labeltype(FL_NORMAL_LABEL);
        rbecho_es->labelfont(0);
        rbecho_es->labelsize(10);
        rbecho_es->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_es->maximum(127);
        rbecho_es->step(1);
        rbecho_es->textcolor(7);
        rbecho_es->callback((Fl_Callback*)cb_rbecho_es);
        rbecho_es->align(FL_ALIGN_LEFT);
        rbecho_es->when(FL_WHEN_CHANGED);
      } // SliderW* rbecho_es
      { rbecho_angle = new SliderW(371, 373, 100, 10, "Angle");
        rbecho_angle->type(5);
        rbecho_angle->box(FL_FLAT_BOX);
        rbecho_angle->color((Fl_Color)178);
        rbecho_angle->selection_color((Fl_Color)62);
        rbecho_angle->labeltype(FL_NORMAL_LABEL);
        rbecho_angle->labelfont(0);
        rbecho_angle->labelsize(10);
        rbecho_angle->labelcolor(FL_BACKGROUND2_COLOR);
        rbecho_angle->minimum(-64);
        rbecho_angle->maximum(64);
        rbecho_angle->step(1);
        rbecho_angle->textcolor(7);
        rbecho_angle->callback((Fl_Callback*)cb_rbecho_angle);
        rbecho_angle->align(FL_ALIGN_LEFT);
        rbecho_angle->when(FL_WHEN_CHANGED);
      } // SliderW* rbecho_angle
      RBECHO->end();
    } // Fl_Group* RBECHO
    { COILCRAFTER = new Fl_Group(320, 211, 158, 184);
      COILCRAFTER->box(FL_UP_BOX);
      COILCRAFTER->color(FL_FOREGROUND_COLOR);
      COILCRAFTER->selection_color(FL_FOREGROUND_COLOR);
      COILCRAFTER->labelfont(1);
      COILCRAFTER->user_data((void*)(1));
      COILCRAFTER->align(96|FL_ALIGN_INSIDE);
      COILCRAFTER->hide();
      { coil_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        coil_activar->shortcut(0x31);
        coil_activar->color((Fl_Color)62);
        coil_activar->selection_color((Fl_Color)1);
        coil_activar->labelsize(10);
        coil_activar->callback((Fl_Callback*)cb_coil_activar, (void*)(2));
        coil_activar->align(68|FL_ALIGN_INSIDE);
        coil_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* coil_activar
      { coil_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        coil_preset->down_box(FL_BORDER_BOX);
        coil_preset->selection_color(FL_FOREGROUND_COLOR);
        coil_preset->labelsize(10);
        coil_preset->labelcolor(FL_BACKGROUND2_COLOR);
        coil_preset->textsize(10);
        coil_preset->textcolor(7);
        coil_preset->callback((Fl_Callback*)cb_coil_preset, (void*)(12033));
        coil_preset->when(FL_WHEN_RELEASE_ALWAYS);
        coil_preset->menu(menu_coil_preset);
      } // Fl_Choice* coil_preset
      { coil_WD = new SliderW(369, 236, 100, 10, "Gain");
        coil_WD->type(5);
        coil_WD->box(FL_FLAT_BOX);
        coil_WD->color((Fl_Color)178);
        coil_WD->selection_color((Fl_Color)62);
        coil_WD->labeltype(FL_NORMAL_LABEL);
        coil_WD->labelfont(0);
        coil_WD->labelsize(10);
        coil_WD->labelcolor(FL_BACKGROUND2_COLOR);
        coil_WD->maximum(127);
        coil_WD->step(1);
        coil_WD->value(127);
        coil_WD->textcolor(7);
        coil_WD->callback((Fl_Callback*)cb_coil_WD);
        coil_WD->align(FL_ALIGN_LEFT);
        coil_WD->when(FL_WHEN_CHANGED);
      } // SliderW* coil_WD
      { coil_tone = new SliderW(369, 252, 100, 10, "Tone");
        coil_tone->type(5);
        coil_tone->box(FL_FLAT_BOX);
        coil_tone->color((Fl_Color)178);
        coil_tone->selection_color((Fl_Color)62);
        coil_tone->labeltype(FL_NORMAL_LABEL);
        coil_tone->labelfont(0);
        coil_tone->labelsize(10);
        coil_tone->labelcolor(FL_BACKGROUND2_COLOR);
        coil_tone->minimum(20);
        coil_tone->maximum(4400);
        coil_tone->step(1);
        coil_tone->value(20);
        coil_tone->textcolor(7);
        coil_tone->callback((Fl_Callback*)cb_coil_tone);
        coil_tone->align(FL_ALIGN_LEFT);
        coil_tone->when(FL_WHEN_CHANGED);
      } // SliderW* coil_tone
      { coil_origin = new Fl_Choice(368, 266, 90, 18, "Origin");
        coil_origin->down_box(FL_BORDER_BOX);
        coil_origin->selection_color(FL_FOREGROUND_COLOR);
        coil_origin->labelsize(10);
        coil_origin->labelcolor(FL_BACKGROUND2_COLOR);
        coil_origin->textsize(10);
        coil_origin->textcolor(7);
        coil_origin->callback((Fl_Callback*)cb_coil_origin, (void*)(12));
        coil_origin->when(FL_WHEN_RELEASE_ALWAYS);
        coil_origin->menu(menu_coil_origin);
      } // Fl_Choice* coil_origin
      { coil_freq1 = new SliderW(369, 290, 100, 10, "Freq1");
        coil_freq1->type(5);
        coil_freq1->box(FL_FLAT_BOX);
        coil_freq1->color((Fl_Color)178);
        coil_freq1->selection_color((Fl_Color)62);
        coil_freq1->labeltype(FL_NORMAL_LABEL);
        coil_freq1->labelfont(0);
        coil_freq1->labelsize(10);
        coil_freq1->labelcolor(FL_BACKGROUND2_COLOR);
        coil_freq1->minimum(2600);
        coil_freq1->maximum(4500);
        coil_freq1->step(1);
        coil_freq1->value(3200);
        coil_freq1->textcolor(7);
        coil_freq1->callback((Fl_Callback*)cb_coil_freq1);
        coil_freq1->align(FL_ALIGN_LEFT);
        coil_freq1->when(FL_WHEN_CHANGED);
      } // SliderW* coil_freq1
      { coil_q1 = new SliderW(369, 305, 100, 10, "Q1");
        coil_q1->type(5);
        coil_q1->box(FL_FLAT_BOX);
        coil_q1->color((Fl_Color)178);
        coil_q1->selection_color((Fl_Color)62);
        coil_q1->labeltype(FL_NORMAL_LABEL);
        coil_q1->labelfont(0);
        coil_q1->labelsize(10);
        coil_q1->labelcolor(FL_BACKGROUND2_COLOR);
        coil_q1->minimum(10);
        coil_q1->maximum(65);
        coil_q1->step(1);
        coil_q1->textcolor(7);
        coil_q1->callback((Fl_Callback*)cb_coil_q1);
        coil_q1->align(FL_ALIGN_LEFT);
        coil_q1->when(FL_WHEN_CHANGED);
      } // SliderW* coil_q1
      { Fl_Choice* o = coil_destiny = new Fl_Choice(368, 318, 90, 18, "Destiny");
        coil_destiny->down_box(FL_BORDER_BOX);
        coil_destiny->selection_color(FL_FOREGROUND_COLOR);
        coil_destiny->labelsize(10);
        coil_destiny->labelcolor(FL_BACKGROUND2_COLOR);
        coil_destiny->textsize(10);
        coil_destiny->textcolor(7);
        coil_destiny->callback((Fl_Callback*)cb_coil_destiny);
        coil_destiny->when(FL_WHEN_RELEASE_ALWAYS);
        o->menu(menu_coil_origin);
      } // Fl_Choice* coil_destiny
      { coil_freq2 = new SliderW(369, 343, 100, 10, "Freq2");
        coil_freq2->type(5);
        coil_freq2->box(FL_FLAT_BOX);
        coil_freq2->color((Fl_Color)178);
        coil_freq2->selection_color((Fl_Color)62);
        coil_freq2->labeltype(FL_NORMAL_LABEL);
        coil_freq2->labelfont(0);
        coil_freq2->labelsize(10);
        coil_freq2->labelcolor(FL_BACKGROUND2_COLOR);
        coil_freq2->minimum(2600);
        coil_freq2->maximum(4500);
        coil_freq2->step(1);
        coil_freq2->value(3200);
        coil_freq2->textcolor(7);
        coil_freq2->callback((Fl_Callback*)cb_coil_freq2);
        coil_freq2->align(FL_ALIGN_LEFT);
        coil_freq2->when(FL_WHEN_CHANGED);
      } // SliderW* coil_freq2
      { coil_q2 = new SliderW(370, 358, 100, 10, "Q2");
        coil_q2->type(5);
        coil_q2->box(FL_FLAT_BOX);
        coil_q2->color((Fl_Color)178);
        coil_q2->selection_color((Fl_Color)62);
        coil_q2->labeltype(FL_NORMAL_LABEL);
        coil_q2->labelfont(0);
        coil_q2->labelsize(10);
        coil_q2->labelcolor(FL_BACKGROUND2_COLOR);
        coil_q2->minimum(10);
        coil_q2->maximum(65);
        coil_q2->step(1);
        coil_q2->value(20);
        coil_q2->textcolor(7);
        coil_q2->callback((Fl_Callback*)cb_coil_q2);
        coil_q2->align(FL_ALIGN_LEFT);
        coil_q2->when(FL_WHEN_CHANGED);
      } // SliderW* coil_q2
      { coil_mode = new Fl_Check_Button(333, 372, 15, 15, "Pos.");
        coil_mode->down_box(FL_BORDER_BOX);
        coil_mode->labelsize(10);
        coil_mode->labelcolor(FL_BACKGROUND2_COLOR);
        coil_mode->callback((Fl_Callback*)cb_coil_mode, (void*)(2));
      } // Fl_Check_Button* coil_mode
      COILCRAFTER->end();
    } // Fl_Group* COILCRAFTER
    { SHELFBOOST = new Fl_Group(320, 211, 158, 184);
      SHELFBOOST->box(FL_UP_BOX);
      SHELFBOOST->color(FL_FOREGROUND_COLOR);
      SHELFBOOST->selection_color(FL_FOREGROUND_COLOR);
      SHELFBOOST->labelfont(1);
      SHELFBOOST->user_data((void*)(1));
      SHELFBOOST->align(96|FL_ALIGN_INSIDE);
      SHELFBOOST->hide();
      { shelf_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        shelf_activar->shortcut(0x31);
        shelf_activar->color((Fl_Color)62);
        shelf_activar->selection_color((Fl_Color)1);
        shelf_activar->labelsize(10);
        shelf_activar->callback((Fl_Callback*)cb_shelf_activar, (void*)(2));
        shelf_activar->align(68|FL_ALIGN_INSIDE);
        shelf_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* shelf_activar
      { shelf_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        shelf_preset->down_box(FL_BORDER_BOX);
        shelf_preset->selection_color(FL_FOREGROUND_COLOR);
        shelf_preset->labelsize(10);
        shelf_preset->labelcolor(FL_BACKGROUND2_COLOR);
        shelf_preset->textsize(10);
        shelf_preset->textcolor(7);
        shelf_preset->callback((Fl_Callback*)cb_shelf_preset, (void*)(12034));
        shelf_preset->when(FL_WHEN_RELEASE_ALWAYS);
        shelf_preset->menu(menu_shelf_preset);
      } // Fl_Choice* shelf_preset
      { shelf_gain = new SliderW(369, 237, 100, 10, "Gain");
        shelf_gain->type(5);
        shelf_gain->box(FL_FLAT_BOX);
        shelf_gain->color((Fl_Color)178);
        shelf_gain->selection_color((Fl_Color)62);
        shelf_gain->labeltype(FL_NORMAL_LABEL);
        shelf_gain->labelfont(0);
        shelf_gain->labelsize(10);
        shelf_gain->labelcolor(FL_BACKGROUND2_COLOR);
        shelf_gain->maximum(127);
        shelf_gain->step(1);
        shelf_gain->textcolor(7);
        shelf_gain->callback((Fl_Callback*)cb_shelf_gain);
        shelf_gain->align(FL_ALIGN_LEFT);
        shelf_gain->when(FL_WHEN_CHANGED);
      } // SliderW* shelf_gain
      { shelf_level = new SliderW(369, 297, 100, 10, "Level");
        shelf_level->type(5);
        shelf_level->box(FL_FLAT_BOX);
        shelf_level->color((Fl_Color)178);
        shelf_level->selection_color((Fl_Color)62);
        shelf_level->labeltype(FL_NORMAL_LABEL);
        shelf_level->labelfont(0);
        shelf_level->labelsize(10);
        shelf_level->labelcolor(FL_BACKGROUND2_COLOR);
        shelf_level->minimum(1);
        shelf_level->maximum(127);
        shelf_level->step(1);
        shelf_level->value(32);
        shelf_level->textcolor(7);
        shelf_level->callback((Fl_Callback*)cb_shelf_level);
        shelf_level->align(FL_ALIGN_LEFT);
        shelf_level->when(FL_WHEN_CHANGED);
      } // SliderW* shelf_level
      { shelf_freq1 = new SliderW(369, 317, 100, 10, "Tone");
        shelf_freq1->type(5);
        shelf_freq1->box(FL_FLAT_BOX);
        shelf_freq1->color((Fl_Color)178);
        shelf_freq1->selection_color((Fl_Color)62);
        shelf_freq1->labeltype(FL_NORMAL_LABEL);
        shelf_freq1->labelfont(0);
        shelf_freq1->labelsize(10);
        shelf_freq1->labelcolor(FL_BACKGROUND2_COLOR);
        shelf_freq1->minimum(220);
        shelf_freq1->maximum(16000);
        shelf_freq1->step(1);
        shelf_freq1->value(1000);
        shelf_freq1->textcolor(7);
        shelf_freq1->callback((Fl_Callback*)cb_shelf_freq1);
        shelf_freq1->align(FL_ALIGN_LEFT);
        shelf_freq1->when(FL_WHEN_CHANGED);
      } // SliderW* shelf_freq1
      { shelf_q1 = new SliderW(369, 337, 100, 10, "Pres.");
        shelf_q1->type(5);
        shelf_q1->box(FL_FLAT_BOX);
        shelf_q1->color((Fl_Color)178);
        shelf_q1->selection_color((Fl_Color)62);
        shelf_q1->labeltype(FL_NORMAL_LABEL);
        shelf_q1->labelfont(0);
        shelf_q1->labelsize(10);
        shelf_q1->labelcolor(FL_BACKGROUND2_COLOR);
        shelf_q1->minimum(-64);
        shelf_q1->maximum(64);
        shelf_q1->step(1);
        shelf_q1->textcolor(7);
        shelf_q1->callback((Fl_Callback*)cb_shelf_q1);
        shelf_q1->align(FL_ALIGN_LEFT);
        shelf_q1->when(FL_WHEN_CHANGED);
      } // SliderW* shelf_q1
      { shelf_mode = new Fl_Check_Button(333, 372, 15, 15, "Stereo");
        shelf_mode->down_box(FL_BORDER_BOX);
        shelf_mode->labelsize(10);
        shelf_mode->labelcolor(FL_BACKGROUND2_COLOR);
        shelf_mode->callback((Fl_Callback*)cb_shelf_mode, (void*)(2));
      } // Fl_Check_Button* shelf_mode
      SHELFBOOST->end();
    } // Fl_Group* SHELFBOOST
    { VOCODER = new Fl_Group(320, 210, 158, 184);
      VOCODER->box(FL_UP_BOX);
      VOCODER->color(FL_FOREGROUND_COLOR);
      VOCODER->selection_color(FL_FOREGROUND_COLOR);
      VOCODER->labelfont(1);
      VOCODER->user_data((void*)(1));
      VOCODER->align(96|FL_ALIGN_INSIDE);
      VOCODER->hide();
      { vo_activar = new Fl_Light_Button(326, 214, 34, 18, "On");
        vo_activar->shortcut(0x35);
        vo_activar->color((Fl_Color)62);
        vo_activar->selection_color((Fl_Color)1);
        vo_activar->labelsize(10);
        vo_activar->callback((Fl_Callback*)cb_vo_activar, (void*)(2));
        vo_activar->align(68|FL_ALIGN_INSIDE);
        vo_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* vo_activar
      { vo_preset = new Fl_Choice(399, 214, 76, 18, "Preset");
        vo_preset->down_box(FL_BORDER_BOX);
        vo_preset->selection_color(FL_FOREGROUND_COLOR);
        vo_preset->labelsize(10);
        vo_preset->labelcolor(FL_BACKGROUND2_COLOR);
        vo_preset->textsize(10);
        vo_preset->textcolor(7);
        vo_preset->callback((Fl_Callback*)cb_vo_preset, (void*)(12035));
        vo_preset->when(FL_WHEN_RELEASE_ALWAYS);
        vo_preset->menu(menu_vo_preset);
      } // Fl_Choice* vo_preset
      { vo_WD = new SliderW(372, 240, 100, 10, "Wet/Dry");
        vo_WD->type(5);
        vo_WD->box(FL_FLAT_BOX);
        vo_WD->color((Fl_Color)178);
        vo_WD->selection_color((Fl_Color)62);
        vo_WD->labeltype(FL_NORMAL_LABEL);
        vo_WD->labelfont(0);
        vo_WD->labelsize(10);
        vo_WD->labelcolor(FL_BACKGROUND2_COLOR);
        vo_WD->minimum(-64);
        vo_WD->maximum(64);
        vo_WD->step(1);
        vo_WD->textcolor(7);
        vo_WD->callback((Fl_Callback*)cb_vo_WD);
        vo_WD->align(FL_ALIGN_LEFT);
        vo_WD->when(FL_WHEN_CHANGED);
      } // SliderW* vo_WD
      { vo_pan = new SliderW(372, 260, 100, 10, "Pan");
        vo_pan->type(5);
        vo_pan->box(FL_FLAT_BOX);
        vo_pan->color((Fl_Color)178);
        vo_pan->selection_color((Fl_Color)62);
        vo_pan->labeltype(FL_NORMAL_LABEL);
        vo_pan->labelfont(0);
        vo_pan->labelsize(10);
        vo_pan->labelcolor(FL_BACKGROUND2_COLOR);
        vo_pan->minimum(-64);
        vo_pan->maximum(64);
        vo_pan->step(1);
        vo_pan->textcolor(7);
        vo_pan->callback((Fl_Callback*)cb_vo_pan);
        vo_pan->align(FL_ALIGN_LEFT);
        vo_pan->when(FL_WHEN_CHANGED);
      } // SliderW* vo_pan
      { vo_input = new SliderW(372, 280, 100, 10, "Input");
        vo_input->type(5);
        vo_input->box(FL_FLAT_BOX);
        vo_input->color((Fl_Color)178);
        vo_input->selection_color((Fl_Color)62);
        vo_input->labeltype(FL_NORMAL_LABEL);
        vo_input->labelfont(0);
        vo_input->labelsize(10);
        vo_input->labelcolor(FL_BACKGROUND2_COLOR);
        vo_input->maximum(127);
        vo_input->step(1);
        vo_input->textcolor(7);
        vo_input->callback((Fl_Callback*)cb_vo_input);
        vo_input->align(FL_ALIGN_LEFT);
        vo_input->when(FL_WHEN_CHANGED);
      } // SliderW* vo_input
      { vo_mu = new SliderW(372, 300, 100, 10, "Muf.");
        vo_mu->type(5);
        vo_mu->box(FL_FLAT_BOX);
        vo_mu->color((Fl_Color)178);
        vo_mu->selection_color((Fl_Color)62);
        vo_mu->labeltype(FL_NORMAL_LABEL);
        vo_mu->labelfont(0);
        vo_mu->labelsize(10);
        vo_mu->labelcolor(FL_BACKGROUND2_COLOR);
        vo_mu->minimum(1);
        vo_mu->maximum(127);
        vo_mu->step(1);
        vo_mu->value(1);
        vo_mu->textcolor(7);
        vo_mu->callback((Fl_Callback*)cb_vo_mu);
        vo_mu->align(FL_ALIGN_LEFT);
        vo_mu->when(FL_WHEN_CHANGED);
      } // SliderW* vo_mu
      { vo_q = new SliderW(372, 320, 100, 10, "Q");
        vo_q->type(5);
        vo_q->box(FL_FLAT_BOX);
        vo_q->color((Fl_Color)178);
        vo_q->selection_color((Fl_Color)62);
        vo_q->labeltype(FL_NORMAL_LABEL);
        vo_q->labelfont(0);
        vo_q->labelsize(10);
        vo_q->labelcolor(FL_BACKGROUND2_COLOR);
        vo_q->minimum(40);
        vo_q->maximum(170);
        vo_q->step(1);
        vo_q->value(120);
        vo_q->textcolor(7);
        vo_q->callback((Fl_Callback*)cb_vo_q);
        vo_q->align(FL_ALIGN_LEFT);
        vo_q->when(FL_WHEN_CHANGED);
      } // SliderW* vo_q
      { vo_ring = new SliderW(372, 340, 100, 10, "Ring");
        vo_ring->type(5);
        vo_ring->box(FL_FLAT_BOX);
        vo_ring->color((Fl_Color)178);
        vo_ring->selection_color((Fl_Color)62);
        vo_ring->labeltype(FL_NORMAL_LABEL);
        vo_ring->labelfont(0);
        vo_ring->labelsize(10);
        vo_ring->labelcolor(FL_BACKGROUND2_COLOR);
        vo_ring->maximum(127);
        vo_ring->step(1);
        vo_ring->textcolor(7);
        vo_ring->callback((Fl_Callback*)cb_vo_ring);
        vo_ring->align(FL_ALIGN_LEFT);
        vo_ring->when(FL_WHEN_CHANGED);
      } // SliderW* vo_ring
      { vo_level = new SliderW(372, 360, 100, 10, "Level");
        vo_level->type(5);
        vo_level->box(FL_FLAT_BOX);
        vo_level->color((Fl_Color)178);
        vo_level->selection_color((Fl_Color)62);
        vo_level->labeltype(FL_NORMAL_LABEL);
        vo_level->labelfont(0);
        vo_level->labelsize(10);
        vo_level->labelcolor(FL_BACKGROUND2_COLOR);
        vo_level->maximum(127);
        vo_level->step(1);
        vo_level->textcolor(7);
        vo_level->callback((Fl_Callback*)cb_vo_level);
        vo_level->align(FL_ALIGN_LEFT);
        vo_level->when(FL_WHEN_CHANGED);
      } // SliderW* vo_level
      { vu_vu = new NewVum(327, 265, 11, 122);
        vu_vu->type(2);
        vu_vu->box(FL_NO_BOX);
        vu_vu->color((Fl_Color)178);
        vu_vu->selection_color((Fl_Color)90);
        vu_vu->labeltype(FL_NORMAL_LABEL);
        vu_vu->labelfont(0);
        vu_vu->labelsize(14);
        vu_vu->labelcolor(FL_FOREGROUND_COLOR);
        vu_vu->minimum(15);
        vu_vu->maximum(-48);
        vu_vu->step(1);
        vu_vu->value(-48);
        vu_vu->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        vu_vu->when(FL_WHEN_NEVER);
      } // NewVum* vu_vu
      VOCODER->end();
    } // Fl_Group* VOCODER
    { SUSTAINER = new Fl_Group(320, 211, 158, 184);
      SUSTAINER->box(FL_UP_BOX);
      SUSTAINER->color(FL_FOREGROUND_COLOR);
      SUSTAINER->selection_color(FL_FOREGROUND_COLOR);
      SUSTAINER->labelfont(1);
      SUSTAINER->user_data((void*)(1));
      SUSTAINER->align(96|FL_ALIGN_INSIDE);
      SUSTAINER->hide();
      { sus_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        sus_activar->shortcut(0x31);
        sus_activar->color((Fl_Color)62);
        sus_activar->selection_color((Fl_Color)1);
        sus_activar->labelsize(10);
        sus_activar->callback((Fl_Callback*)cb_sus_activar, (void*)(2));
        sus_activar->align(68|FL_ALIGN_INSIDE);
        sus_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* sus_activar
      { sus_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        sus_preset->down_box(FL_BORDER_BOX);
        sus_preset->selection_color(FL_FOREGROUND_COLOR);
        sus_preset->labelsize(10);
        sus_preset->labelcolor(FL_BACKGROUND2_COLOR);
        sus_preset->textsize(10);
        sus_preset->textcolor(7);
        sus_preset->callback((Fl_Callback*)cb_sus_preset, (void*)(12036));
        sus_preset->when(FL_WHEN_RELEASE_ALWAYS);
        sus_preset->menu(menu_sus_preset);
      } // Fl_Choice* sus_preset
      { sus_gain = new SliderW(369, 273, 100, 10, "Gain");
        sus_gain->type(5);
        sus_gain->box(FL_FLAT_BOX);
        sus_gain->color((Fl_Color)178);
        sus_gain->selection_color((Fl_Color)62);
        sus_gain->labeltype(FL_NORMAL_LABEL);
        sus_gain->labelfont(0);
        sus_gain->labelsize(10);
        sus_gain->labelcolor(FL_BACKGROUND2_COLOR);
        sus_gain->maximum(127);
        sus_gain->step(1);
        sus_gain->textcolor(7);
        sus_gain->callback((Fl_Callback*)cb_sus_gain);
        sus_gain->align(FL_ALIGN_LEFT);
        sus_gain->when(FL_WHEN_CHANGED);
      } // SliderW* sus_gain
      { sus_sus = new SliderW(369, 297, 100, 10, "Sustain");
        sus_sus->type(5);
        sus_sus->box(FL_FLAT_BOX);
        sus_sus->color((Fl_Color)178);
        sus_sus->selection_color((Fl_Color)62);
        sus_sus->labeltype(FL_NORMAL_LABEL);
        sus_sus->labelfont(0);
        sus_sus->labelsize(10);
        sus_sus->labelcolor(FL_BACKGROUND2_COLOR);
        sus_sus->minimum(1);
        sus_sus->maximum(127);
        sus_sus->step(1);
        sus_sus->value(32);
        sus_sus->textcolor(7);
        sus_sus->callback((Fl_Callback*)cb_sus_sus);
        sus_sus->align(FL_ALIGN_LEFT);
        sus_sus->when(FL_WHEN_CHANGED);
      } // SliderW* sus_sus
      SUSTAINER->end();
    } // Fl_Group* SUSTAINER
    { SEQUENCE = new Fl_Group(320, 211, 158, 184);
      SEQUENCE->box(FL_UP_BOX);
      SEQUENCE->color(FL_FOREGROUND_COLOR);
      SEQUENCE->selection_color(FL_FOREGROUND_COLOR);
      SEQUENCE->labelfont(1);
      SEQUENCE->user_data((void*)(1));
      SEQUENCE->align(96|FL_ALIGN_INSIDE);
      SEQUENCE->hide();
      { seq_activar = new Fl_Light_Button(325, 215, 34, 16, "On");
        seq_activar->shortcut(0x36);
        seq_activar->color((Fl_Color)62);
        seq_activar->selection_color((Fl_Color)1);
        seq_activar->labelsize(10);
        seq_activar->callback((Fl_Callback*)cb_seq_activar, (void*)(2));
        seq_activar->align(68|FL_ALIGN_INSIDE);
        seq_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* seq_activar
      { seq_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        seq_preset->down_box(FL_BORDER_BOX);
        seq_preset->selection_color(FL_FOREGROUND_COLOR);
        seq_preset->labelsize(10);
        seq_preset->labelcolor(FL_BACKGROUND2_COLOR);
        seq_preset->textsize(10);
        seq_preset->textcolor(7);
        seq_preset->callback((Fl_Callback*)cb_seq_preset, (void*)(12037));
        seq_preset->when(FL_WHEN_RELEASE_ALWAYS);
        seq_preset->menu(menu_seq_preset);
      } // Fl_Choice* seq_preset
      { seq_WD = new SliderW(369, 236, 100, 10, "Wet/Dry");
        seq_WD->type(5);
        seq_WD->box(FL_FLAT_BOX);
        seq_WD->color((Fl_Color)178);
        seq_WD->selection_color((Fl_Color)62);
        seq_WD->labeltype(FL_NORMAL_LABEL);
        seq_WD->labelfont(0);
        seq_WD->labelsize(10);
        seq_WD->labelcolor(FL_BACKGROUND2_COLOR);
        seq_WD->minimum(-64);
        seq_WD->maximum(64);
        seq_WD->step(1);
        seq_WD->textcolor(7);
        seq_WD->callback((Fl_Callback*)cb_seq_WD);
        seq_WD->align(FL_ALIGN_LEFT);
        seq_WD->when(FL_WHEN_CHANGED);
      } // SliderW* seq_WD
      { seq_1 = new SliderW(369, 248, 100, 10, "1");
        seq_1->type(5);
        seq_1->box(FL_FLAT_BOX);
        seq_1->color((Fl_Color)178);
        seq_1->selection_color((Fl_Color)62);
        seq_1->labeltype(FL_NORMAL_LABEL);
        seq_1->labelfont(0);
        seq_1->labelsize(10);
        seq_1->labelcolor(FL_BACKGROUND2_COLOR);
        seq_1->maximum(127);
        seq_1->step(1);
        seq_1->textcolor(7);
        seq_1->callback((Fl_Callback*)cb_seq_1);
        seq_1->align(FL_ALIGN_LEFT);
        seq_1->when(FL_WHEN_CHANGED);
      } // SliderW* seq_1
      { seq_2 = new SliderW(369, 260, 100, 10, "2");
        seq_2->type(5);
        seq_2->box(FL_FLAT_BOX);
        seq_2->color((Fl_Color)178);
        seq_2->selection_color((Fl_Color)62);
        seq_2->labeltype(FL_NORMAL_LABEL);
        seq_2->labelfont(0);
        seq_2->labelsize(10);
        seq_2->labelcolor(FL_BACKGROUND2_COLOR);
        seq_2->maximum(127);
        seq_2->step(1);
        seq_2->textcolor(7);
        seq_2->callback((Fl_Callback*)cb_seq_2);
        seq_2->align(FL_ALIGN_LEFT);
        seq_2->when(FL_WHEN_CHANGED);
      } // SliderW* seq_2
      { seq_3 = new SliderW(369, 272, 100, 10, "3");
        seq_3->type(5);
        seq_3->box(FL_FLAT_BOX);
        seq_3->color((Fl_Color)178);
        seq_3->selection_color((Fl_Color)62);
        seq_3->labeltype(FL_NORMAL_LABEL);
        seq_3->labelfont(0);
        seq_3->labelsize(10);
        seq_3->labelcolor(FL_BACKGROUND2_COLOR);
        seq_3->maximum(127);
        seq_3->step(1);
        seq_3->textcolor(7);
        seq_3->callback((Fl_Callback*)cb_seq_3);
        seq_3->align(FL_ALIGN_LEFT);
        seq_3->when(FL_WHEN_CHANGED);
      } // SliderW* seq_3
      { seq_4 = new SliderW(369, 284, 100, 10, "4");
        seq_4->type(5);
        seq_4->box(FL_FLAT_BOX);
        seq_4->color((Fl_Color)178);
        seq_4->selection_color((Fl_Color)62);
        seq_4->labeltype(FL_NORMAL_LABEL);
        seq_4->labelfont(0);
        seq_4->labelsize(10);
        seq_4->labelcolor(FL_BACKGROUND2_COLOR);
        seq_4->maximum(127);
        seq_4->step(1);
        seq_4->textcolor(7);
        seq_4->callback((Fl_Callback*)cb_seq_4);
        seq_4->align(FL_ALIGN_LEFT);
        seq_4->when(FL_WHEN_CHANGED);
      } // SliderW* seq_4
      { seq_5 = new SliderW(370, 296, 100, 10, "5");
        seq_5->type(5);
        seq_5->box(FL_FLAT_BOX);
        seq_5->color((Fl_Color)178);
        seq_5->selection_color((Fl_Color)62);
        seq_5->labeltype(FL_NORMAL_LABEL);
        seq_5->labelfont(0);
        seq_5->labelsize(10);
        seq_5->labelcolor(FL_BACKGROUND2_COLOR);
        seq_5->maximum(127);
        seq_5->step(1);
        seq_5->textcolor(7);
        seq_5->callback((Fl_Callback*)cb_seq_5);
        seq_5->align(FL_ALIGN_LEFT);
        seq_5->when(FL_WHEN_CHANGED);
      } // SliderW* seq_5
      { seq_6 = new SliderW(370, 308, 100, 10, "6");
        seq_6->type(5);
        seq_6->box(FL_FLAT_BOX);
        seq_6->color((Fl_Color)178);
        seq_6->selection_color((Fl_Color)62);
        seq_6->labeltype(FL_NORMAL_LABEL);
        seq_6->labelfont(0);
        seq_6->labelsize(10);
        seq_6->labelcolor(FL_BACKGROUND2_COLOR);
        seq_6->maximum(127);
        seq_6->step(1);
        seq_6->textcolor(7);
        seq_6->callback((Fl_Callback*)cb_seq_6);
        seq_6->align(FL_ALIGN_LEFT);
        seq_6->when(FL_WHEN_CHANGED);
      } // SliderW* seq_6
      { seq_7 = new SliderW(370, 320, 100, 10, "7");
        seq_7->type(5);
        seq_7->box(FL_FLAT_BOX);
        seq_7->color((Fl_Color)178);
        seq_7->selection_color((Fl_Color)62);
        seq_7->labeltype(FL_NORMAL_LABEL);
        seq_7->labelfont(0);
        seq_7->labelsize(10);
        seq_7->labelcolor(FL_BACKGROUND2_COLOR);
        seq_7->maximum(127);
        seq_7->step(1);
        seq_7->textcolor(7);
        seq_7->callback((Fl_Callback*)cb_seq_7);
        seq_7->align(FL_ALIGN_LEFT);
        seq_7->when(FL_WHEN_CHANGED);
      } // SliderW* seq_7
      { seq_8 = new SliderW(370, 332, 100, 10, "8");
        seq_8->type(5);
        seq_8->box(FL_FLAT_BOX);
        seq_8->color((Fl_Color)178);
        seq_8->selection_color((Fl_Color)62);
        seq_8->labeltype(FL_NORMAL_LABEL);
        seq_8->labelfont(0);
        seq_8->labelsize(10);
        seq_8->labelcolor(FL_BACKGROUND2_COLOR);
        seq_8->maximum(127);
        seq_8->step(1);
        seq_8->textcolor(7);
        seq_8->callback((Fl_Callback*)cb_seq_8);
        seq_8->align(FL_ALIGN_LEFT);
        seq_8->when(FL_WHEN_CHANGED);
      } // SliderW* seq_8
      { seq_tempo = new SliderW(369, 344, 100, 10, "Tempo");
        seq_tempo->type(5);
        seq_tempo->box(FL_FLAT_BOX);
        seq_tempo->color((Fl_Color)178);
        seq_tempo->selection_color((Fl_Color)62);
        seq_tempo->labeltype(FL_NORMAL_LABEL);
        seq_tempo->labelfont(0);
        seq_tempo->labelsize(10);
        seq_tempo->labelcolor(FL_BACKGROUND2_COLOR);
        seq_tempo->minimum(1);
        seq_tempo->maximum(600);
        seq_tempo->step(1);
        seq_tempo->textcolor(7);
        seq_tempo->callback((Fl_Callback*)cb_seq_tempo);
        seq_tempo->align(FL_ALIGN_LEFT);
        seq_tempo->when(FL_WHEN_CHANGED);
      } // SliderW* seq_tempo
      { seq_q = new SliderW(369, 356, 100, 10, "Q");
        seq_q->type(5);
        seq_q->box(FL_FLAT_BOX);
        seq_q->color((Fl_Color)178);
        seq_q->selection_color((Fl_Color)62);
        seq_q->labeltype(FL_NORMAL_LABEL);
        seq_q->labelfont(0);
        seq_q->labelsize(10);
        seq_q->labelcolor(FL_BACKGROUND2_COLOR);
        seq_q->minimum(-64);
        seq_q->maximum(64);
        seq_q->step(1);
        seq_q->textcolor(7);
        seq_q->callback((Fl_Callback*)cb_seq_q);
        seq_q->align(FL_ALIGN_LEFT);
        seq_q->when(FL_WHEN_CHANGED);
      } // SliderW* seq_q
      { seq_stdf = new SliderW(369, 368, 100, 10, "St.df");
        seq_stdf->type(5);
        seq_stdf->box(FL_FLAT_BOX);
        seq_stdf->color((Fl_Color)178);
        seq_stdf->selection_color((Fl_Color)62);
        seq_stdf->labeltype(FL_NORMAL_LABEL);
        seq_stdf->labelfont(0);
        seq_stdf->labelsize(10);
        seq_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        seq_stdf->maximum(7);
        seq_stdf->step(1);
        seq_stdf->textcolor(7);
        seq_stdf->callback((Fl_Callback*)cb_seq_stdf);
        seq_stdf->align(FL_ALIGN_LEFT);
        seq_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* seq_stdf
      { seq_amp = new Fl_Check_Button(433, 380, 15, 14, "Amp.");
        seq_amp->down_box(FL_BORDER_BOX);
        seq_amp->labelsize(10);
        seq_amp->labelcolor(FL_BACKGROUND2_COLOR);
        seq_amp->callback((Fl_Callback*)cb_seq_amp, (void*)(2));
      } // Fl_Check_Button* seq_amp
      { seq_mode = new Fl_Choice(353, 380, 78, 13, "Mode");
        seq_mode->down_box(FL_BORDER_BOX);
        seq_mode->labelsize(9);
        seq_mode->labelcolor(FL_BACKGROUND2_COLOR);
        seq_mode->textsize(9);
        seq_mode->textcolor(7);
        seq_mode->callback((Fl_Callback*)cb_seq_mode, (void*)(12));
        seq_mode->menu(menu_seq_mode);
      } // Fl_Choice* seq_mode
      { seq_range = new Fl_Counter(325, 284, 33, 13, "Range");
        seq_range->type(1);
        seq_range->labelsize(10);
        seq_range->labelcolor(FL_BACKGROUND2_COLOR);
        seq_range->minimum(1);
        seq_range->maximum(8);
        seq_range->step(1);
        seq_range->value(1);
        seq_range->textsize(9);
        seq_range->callback((Fl_Callback*)cb_seq_range);
      } // Fl_Counter* seq_range
      SEQUENCE->end();
    } // Fl_Group* SEQUENCE
    { SHIFTER = new Fl_Group(320, 211, 158, 184);
      SHIFTER->box(FL_UP_BOX);
      SHIFTER->color(FL_FOREGROUND_COLOR);
      SHIFTER->selection_color(FL_FOREGROUND_COLOR);
      SHIFTER->labelfont(1);
      SHIFTER->user_data((void*)(1));
      SHIFTER->align(96|FL_ALIGN_INSIDE);
      SHIFTER->hide();
      { shifter_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        shifter_activar->shortcut(0x30);
        shifter_activar->color((Fl_Color)62);
        shifter_activar->selection_color((Fl_Color)1);
        shifter_activar->labelsize(10);
        shifter_activar->callback((Fl_Callback*)cb_shifter_activar, (void*)(2));
        shifter_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* shifter_activar
      { shifter_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        shifter_preset->down_box(FL_BORDER_BOX);
        shifter_preset->selection_color(FL_FOREGROUND_COLOR);
        shifter_preset->labelsize(10);
        shifter_preset->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_preset->textsize(10);
        shifter_preset->textcolor(7);
        shifter_preset->callback((Fl_Callback*)cb_shifter_preset, (void*)(12038));
        shifter_preset->when(FL_WHEN_RELEASE_ALWAYS);
        shifter_preset->menu(menu_shifter_preset);
      } // Fl_Choice* shifter_preset
      { shifter_WD = new SliderW(370, 241, 100, 10, "Wet/Dry");
        shifter_WD->type(5);
        shifter_WD->box(FL_FLAT_BOX);
        shifter_WD->color((Fl_Color)178);
        shifter_WD->selection_color((Fl_Color)62);
        shifter_WD->labeltype(FL_NORMAL_LABEL);
        shifter_WD->labelfont(0);
        shifter_WD->labelsize(10);
        shifter_WD->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_WD->minimum(-64);
        shifter_WD->maximum(63);
        shifter_WD->step(1);
        shifter_WD->textcolor(7);
        shifter_WD->callback((Fl_Callback*)cb_shifter_WD);
        shifter_WD->align(FL_ALIGN_LEFT);
        shifter_WD->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_WD
      { shifter_int = new SliderW(370, 254, 100, 10, "Int.");
        shifter_int->type(5);
        shifter_int->box(FL_FLAT_BOX);
        shifter_int->color((Fl_Color)178);
        shifter_int->selection_color((Fl_Color)62);
        shifter_int->labeltype(FL_NORMAL_LABEL);
        shifter_int->labelfont(0);
        shifter_int->labelsize(10);
        shifter_int->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_int->maximum(12);
        shifter_int->step(1);
        shifter_int->textcolor(7);
        shifter_int->callback((Fl_Callback*)cb_shifter_int);
        shifter_int->align(FL_ALIGN_LEFT);
        shifter_int->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_int
      { shifter_gain = new SliderW(370, 269, 100, 10, "Gain");
        shifter_gain->type(5);
        shifter_gain->box(FL_FLAT_BOX);
        shifter_gain->color((Fl_Color)178);
        shifter_gain->selection_color((Fl_Color)62);
        shifter_gain->labeltype(FL_NORMAL_LABEL);
        shifter_gain->labelfont(0);
        shifter_gain->labelsize(10);
        shifter_gain->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_gain->minimum(-64);
        shifter_gain->maximum(63);
        shifter_gain->step(1);
        shifter_gain->textcolor(7);
        shifter_gain->callback((Fl_Callback*)cb_shifter_gain);
        shifter_gain->align(FL_ALIGN_LEFT);
        shifter_gain->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_gain
      { shifter_pan = new SliderW(370, 282, 100, 10, "Pan");
        shifter_pan->type(5);
        shifter_pan->box(FL_FLAT_BOX);
        shifter_pan->color((Fl_Color)178);
        shifter_pan->selection_color((Fl_Color)62);
        shifter_pan->labeltype(FL_NORMAL_LABEL);
        shifter_pan->labelfont(0);
        shifter_pan->labelsize(10);
        shifter_pan->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_pan->minimum(-64);
        shifter_pan->maximum(63);
        shifter_pan->step(1);
        shifter_pan->textcolor(7);
        shifter_pan->callback((Fl_Callback*)cb_shifter_pan);
        shifter_pan->align(FL_ALIGN_LEFT);
        shifter_pan->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_pan
      { shifter_attack = new SliderW(371, 299, 100, 10, "Attack");
        shifter_attack->type(5);
        shifter_attack->box(FL_FLAT_BOX);
        shifter_attack->color((Fl_Color)178);
        shifter_attack->selection_color((Fl_Color)62);
        shifter_attack->labeltype(FL_NORMAL_LABEL);
        shifter_attack->labelfont(0);
        shifter_attack->labelsize(10);
        shifter_attack->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_attack->minimum(1);
        shifter_attack->maximum(2000);
        shifter_attack->step(1);
        shifter_attack->value(100);
        shifter_attack->textcolor(7);
        shifter_attack->callback((Fl_Callback*)cb_shifter_attack);
        shifter_attack->align(FL_ALIGN_LEFT);
        shifter_attack->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_attack
      { shifter_decay = new SliderW(370, 312, 100, 10, "Decay");
        shifter_decay->type(5);
        shifter_decay->box(FL_FLAT_BOX);
        shifter_decay->color((Fl_Color)178);
        shifter_decay->selection_color((Fl_Color)62);
        shifter_decay->labeltype(FL_NORMAL_LABEL);
        shifter_decay->labelfont(0);
        shifter_decay->labelsize(10);
        shifter_decay->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_decay->minimum(1);
        shifter_decay->maximum(2000);
        shifter_decay->step(1);
        shifter_decay->value(100);
        shifter_decay->textcolor(7);
        shifter_decay->callback((Fl_Callback*)cb_shifter_decay);
        shifter_decay->align(FL_ALIGN_LEFT);
        shifter_decay->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_decay
      { shifter_thre = new SliderW(370, 325, 100, 10, "Thrshold");
        shifter_thre->type(5);
        shifter_thre->box(FL_FLAT_BOX);
        shifter_thre->color((Fl_Color)178);
        shifter_thre->selection_color((Fl_Color)62);
        shifter_thre->labeltype(FL_NORMAL_LABEL);
        shifter_thre->labelfont(0);
        shifter_thre->labelsize(10);
        shifter_thre->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_thre->minimum(-70);
        shifter_thre->maximum(20);
        shifter_thre->step(1);
        shifter_thre->value(20);
        shifter_thre->textcolor(7);
        shifter_thre->callback((Fl_Callback*)cb_shifter_thre);
        shifter_thre->align(FL_ALIGN_LEFT);
        shifter_thre->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_thre
      { shifter_ud = new Fl_Check_Button(371, 339, 15, 14, "Down");
        shifter_ud->down_box(FL_BORDER_BOX);
        shifter_ud->labelsize(10);
        shifter_ud->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_ud->callback((Fl_Callback*)cb_shifter_ud, (void*)(2));
      } // Fl_Check_Button* shifter_ud
      { shifter_whammy = new SliderW(370, 356, 100, 10, "Whamy");
        shifter_whammy->type(5);
        shifter_whammy->box(FL_FLAT_BOX);
        shifter_whammy->color((Fl_Color)178);
        shifter_whammy->selection_color((Fl_Color)62);
        shifter_whammy->labeltype(FL_NORMAL_LABEL);
        shifter_whammy->labelfont(0);
        shifter_whammy->labelsize(10);
        shifter_whammy->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_whammy->maximum(127);
        shifter_whammy->step(1);
        shifter_whammy->textcolor(7);
        shifter_whammy->callback((Fl_Callback*)cb_shifter_whammy);
        shifter_whammy->align(FL_ALIGN_LEFT);
        shifter_whammy->when(FL_WHEN_CHANGED);
      } // SliderW* shifter_whammy
      { shifter_mode = new Fl_Choice(363, 376, 78, 13, "Mode");
        shifter_mode->down_box(FL_BORDER_BOX);
        shifter_mode->labelsize(9);
        shifter_mode->labelcolor(FL_BACKGROUND2_COLOR);
        shifter_mode->textsize(9);
        shifter_mode->textcolor(7);
        shifter_mode->callback((Fl_Callback*)cb_shifter_mode, (void*)(12));
        shifter_mode->menu(menu_shifter_mode);
      } // Fl_Choice* shifter_mode
      SHIFTER->end();
    } // Fl_Group* SHIFTER
    { STOMPBOX = new Fl_Group(320, 211, 158, 184);
      STOMPBOX->box(FL_UP_BOX);
      STOMPBOX->color(FL_FOREGROUND_COLOR);
      STOMPBOX->selection_color(FL_FOREGROUND_COLOR);
      STOMPBOX->labelfont(1);
      STOMPBOX->user_data((void*)(1));
      STOMPBOX->align(96|FL_ALIGN_INSIDE);
      STOMPBOX->hide();
      { stomp_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        stomp_activar->shortcut(0x30);
        stomp_activar->color((Fl_Color)62);
        stomp_activar->selection_color((Fl_Color)1);
        stomp_activar->labelsize(10);
        stomp_activar->callback((Fl_Callback*)cb_stomp_activar, (void*)(2));
        stomp_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* stomp_activar
      { stomp_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        stomp_preset->down_box(FL_BORDER_BOX);
        stomp_preset->selection_color(FL_FOREGROUND_COLOR);
        stomp_preset->labelsize(10);
        stomp_preset->labelcolor(FL_BACKGROUND2_COLOR);
        stomp_preset->textsize(10);
        stomp_preset->textcolor(7);
        stomp_preset->callback((Fl_Callback*)cb_stomp_preset, (void*)(12039));
        stomp_preset->when(FL_WHEN_RELEASE_ALWAYS);
        stomp_preset->menu(menu_stomp_preset);
      } // Fl_Choice* stomp_preset
      { stomp_WD = new SliderW(370, 241, 100, 10, "Level");
        stomp_WD->type(5);
        stomp_WD->box(FL_FLAT_BOX);
        stomp_WD->color((Fl_Color)178);
        stomp_WD->selection_color((Fl_Color)62);
        stomp_WD->labeltype(FL_NORMAL_LABEL);
        stomp_WD->labelfont(0);
        stomp_WD->labelsize(10);
        stomp_WD->labelcolor(FL_BACKGROUND2_COLOR);
        stomp_WD->maximum(127);
        stomp_WD->step(1);
        stomp_WD->textcolor(7);
        stomp_WD->callback((Fl_Callback*)cb_stomp_WD);
        stomp_WD->align(FL_ALIGN_LEFT);
        stomp_WD->when(FL_WHEN_CHANGED);
      } // SliderW* stomp_WD
      { stomp_gain = new SliderW(370, 269, 100, 10, "Gain");
        stomp_gain->type(5);
        stomp_gain->box(FL_FLAT_BOX);
        stomp_gain->color((Fl_Color)178);
        stomp_gain->selection_color((Fl_Color)62);
        stomp_gain->labeltype(FL_NORMAL_LABEL);
        stomp_gain->labelfont(0);
        stomp_gain->labelsize(10);
        stomp_gain->labelcolor(FL_BACKGROUND2_COLOR);
        stomp_gain->maximum(127);
        stomp_gain->step(1);
        stomp_gain->textcolor(7);
        stomp_gain->callback((Fl_Callback*)cb_stomp_gain);
        stomp_gain->align(FL_ALIGN_LEFT);
        stomp_gain->when(FL_WHEN_CHANGED);
      } // SliderW* stomp_gain
      { stomp_low = new SliderW(370, 286, 100, 10, "Low");
        stomp_low->type(5);
        stomp_low->box(FL_FLAT_BOX);
        stomp_low->color((Fl_Color)178);
        stomp_low->selection_color((Fl_Color)62);
        stomp_low->labeltype(FL_NORMAL_LABEL);
        stomp_low->labelfont(0);
        stomp_low->labelsize(10);
        stomp_low->labelcolor(FL_BACKGROUND2_COLOR);
        stomp_low->minimum(-64);
        stomp_low->maximum(64);
        stomp_low->step(1);
        stomp_low->textcolor(7);
        stomp_low->callback((Fl_Callback*)cb_stomp_low);
        stomp_low->align(FL_ALIGN_LEFT);
        stomp_low->when(FL_WHEN_CHANGED);
      } // SliderW* stomp_low
      { stomp_mid = new SliderW(370, 303, 100, 10, "Mid");
        stomp_mid->type(5);
        stomp_mid->box(FL_FLAT_BOX);
        stomp_mid->color((Fl_Color)178);
        stomp_mid->selection_color((Fl_Color)62);
        stomp_mid->labeltype(FL_NORMAL_LABEL);
        stomp_mid->labelfont(0);
        stomp_mid->labelsize(10);
        stomp_mid->labelcolor(FL_BACKGROUND2_COLOR);
        stomp_mid->minimum(-64);
        stomp_mid->maximum(64);
        stomp_mid->step(1);
        stomp_mid->textcolor(7);
        stomp_mid->callback((Fl_Callback*)cb_stomp_mid);
        stomp_mid->align(36);
        stomp_mid->when(FL_WHEN_CHANGED);
      } // SliderW* stomp_mid
      { stomp_high = new SliderW(370, 320, 100, 10, "High");
        stomp_high->type(5);
        stomp_high->box(FL_FLAT_BOX);
        stomp_high->color((Fl_Color)178);
        stomp_high->selection_color((Fl_Color)62);
        stomp_high->labeltype(FL_NORMAL_LABEL);
        stomp_high->labelfont(0);
        stomp_high->labelsize(10);
        stomp_high->labelcolor(FL_BACKGROUND2_COLOR);
        stomp_high->minimum(-64);
        stomp_high->maximum(64);
        stomp_high->step(1);
        stomp_high->textcolor(7);
        stomp_high->callback((Fl_Callback*)cb_stomp_high);
        stomp_high->align(FL_ALIGN_LEFT);
        stomp_high->when(FL_WHEN_CHANGED);
      } // SliderW* stomp_high
      { stomp_mode = new Fl_Choice(363, 376, 78, 13, "Mode");
        stomp_mode->down_box(FL_BORDER_BOX);
        stomp_mode->labelsize(9);
        stomp_mode->labelcolor(FL_BACKGROUND2_COLOR);
        stomp_mode->textsize(9);
        stomp_mode->textcolor(7);
        stomp_mode->callback((Fl_Callback*)cb_stomp_mode, (void*)(12));
        stomp_mode->menu(menu_stomp_mode);
      } // Fl_Choice* stomp_mode
      STOMPBOX->end();
    } // Fl_Group* STOMPBOX
    { REVERBTRON = new Fl_Group(320, 210, 158, 184);
      REVERBTRON->box(FL_UP_BOX);
      REVERBTRON->color(FL_FOREGROUND_COLOR);
      REVERBTRON->selection_color(FL_FOREGROUND_COLOR);
      REVERBTRON->labelfont(1);
      REVERBTRON->user_data((void*)(1));
      REVERBTRON->align(96|FL_ALIGN_INSIDE);
      REVERBTRON->hide();
      { revtron_activar = new Fl_Light_Button(326, 214, 34, 18, "On");
        revtron_activar->shortcut(0x35);
        revtron_activar->color((Fl_Color)62);
        revtron_activar->selection_color((Fl_Color)1);
        revtron_activar->labelsize(10);
        revtron_activar->callback((Fl_Callback*)cb_revtron_activar, (void*)(2));
        revtron_activar->align(68|FL_ALIGN_INSIDE);
        revtron_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* revtron_activar
      { revtron_preset = new Fl_Choice(399, 214, 76, 18, "Preset");
        revtron_preset->down_box(FL_BORDER_BOX);
        revtron_preset->selection_color(FL_FOREGROUND_COLOR);
        revtron_preset->labelsize(10);
        revtron_preset->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_preset->textsize(10);
        revtron_preset->textcolor(7);
        revtron_preset->callback((Fl_Callback*)cb_revtron_preset, (void*)(12040));
        revtron_preset->when(FL_WHEN_RELEASE_ALWAYS);
        revtron_preset->menu(menu_revtron_preset);
      } // Fl_Choice* revtron_preset
      { revtron_WD = new SliderW(372, 235, 100, 10, "Wet/Dry");
        revtron_WD->type(5);
        revtron_WD->box(FL_FLAT_BOX);
        revtron_WD->color((Fl_Color)178);
        revtron_WD->selection_color((Fl_Color)62);
        revtron_WD->labeltype(FL_NORMAL_LABEL);
        revtron_WD->labelfont(0);
        revtron_WD->labelsize(10);
        revtron_WD->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_WD->minimum(-64);
        revtron_WD->maximum(64);
        revtron_WD->step(1);
        revtron_WD->textcolor(7);
        revtron_WD->callback((Fl_Callback*)cb_revtron_WD);
        revtron_WD->align(FL_ALIGN_LEFT);
        revtron_WD->when(FL_WHEN_CHANGED);
      } // SliderW* revtron_WD
      { revtron_pan = new SliderW(372, 247, 100, 10, "Pan");
        revtron_pan->type(5);
        revtron_pan->box(FL_FLAT_BOX);
        revtron_pan->color((Fl_Color)178);
        revtron_pan->selection_color((Fl_Color)62);
        revtron_pan->labeltype(FL_NORMAL_LABEL);
        revtron_pan->labelfont(0);
        revtron_pan->labelsize(10);
        revtron_pan->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_pan->minimum(-64);
        revtron_pan->maximum(63);
        revtron_pan->step(1);
        revtron_pan->textcolor(7);
        revtron_pan->callback((Fl_Callback*)cb_revtron_pan);
        revtron_pan->align(FL_ALIGN_LEFT);
        revtron_pan->when(FL_WHEN_CHANGED);
      } // SliderW* revtron_pan
      { revtron_level = new SliderW(372, 259, 100, 10, "Level");
        revtron_level->type(5);
        revtron_level->box(FL_FLAT_BOX);
        revtron_level->color((Fl_Color)178);
        revtron_level->selection_color((Fl_Color)62);
        revtron_level->labeltype(FL_NORMAL_LABEL);
        revtron_level->labelfont(0);
        revtron_level->labelsize(10);
        revtron_level->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_level->maximum(127);
        revtron_level->step(1);
        revtron_level->textcolor(7);
        revtron_level->callback((Fl_Callback*)cb_revtron_level);
        revtron_level->align(FL_ALIGN_LEFT);
        revtron_level->when(FL_WHEN_CHANGED);
      } // SliderW* revtron_level
      { revtron_damp = new SliderW(372, 271, 100, 10, "Damp");
        revtron_damp->type(5);
        revtron_damp->box(FL_FLAT_BOX);
        revtron_damp->color((Fl_Color)178);
        revtron_damp->selection_color((Fl_Color)62);
        revtron_damp->labeltype(FL_NORMAL_LABEL);
        revtron_damp->labelfont(0);
        revtron_damp->labelsize(10);
        revtron_damp->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_damp->maximum(127);
        revtron_damp->step(1);
        revtron_damp->textcolor(7);
        revtron_damp->callback((Fl_Callback*)cb_revtron_damp);
        revtron_damp->align(FL_ALIGN_LEFT);
        revtron_damp->when(FL_WHEN_CHANGED);
      } // SliderW* revtron_damp
      { revtron_fb = new SliderW(372, 283, 100, 10, "Fb");
        revtron_fb->type(5);
        revtron_fb->box(FL_FLAT_BOX);
        revtron_fb->color((Fl_Color)178);
        revtron_fb->selection_color((Fl_Color)62);
        revtron_fb->labeltype(FL_NORMAL_LABEL);
        revtron_fb->labelfont(0);
        revtron_fb->labelsize(10);
        revtron_fb->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_fb->minimum(-64);
        revtron_fb->maximum(64);
        revtron_fb->step(1);
        revtron_fb->textcolor(7);
        revtron_fb->callback((Fl_Callback*)cb_revtron_fb);
        revtron_fb->align(FL_ALIGN_LEFT);
        revtron_fb->when(FL_WHEN_CHANGED);
      } // SliderW* revtron_fb
      { revtron_length = new SliderW(372, 295, 100, 10, "Length");
        revtron_length->type(5);
        revtron_length->box(FL_FLAT_BOX);
        revtron_length->color((Fl_Color)178);
        revtron_length->selection_color((Fl_Color)62);
        revtron_length->labeltype(FL_NORMAL_LABEL);
        revtron_length->labelfont(0);
        revtron_length->labelsize(10);
        revtron_length->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_length->minimum(20);
        revtron_length->maximum(1500);
        revtron_length->step(1);
        revtron_length->value(100);
        revtron_length->textcolor(7);
        revtron_length->callback((Fl_Callback*)cb_revtron_length);
        revtron_length->align(FL_ALIGN_LEFT);
        revtron_length->when(FL_WHEN_RELEASE);
      } // SliderW* revtron_length
      { revtron_strech = new SliderW(372, 307, 100, 10, "Stretch");
        revtron_strech->type(5);
        revtron_strech->box(FL_FLAT_BOX);
        revtron_strech->color((Fl_Color)178);
        revtron_strech->selection_color((Fl_Color)62);
        revtron_strech->labeltype(FL_NORMAL_LABEL);
        revtron_strech->labelfont(0);
        revtron_strech->labelsize(10);
        revtron_strech->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_strech->minimum(-64);
        revtron_strech->maximum(64);
        revtron_strech->step(1);
        revtron_strech->textcolor(7);
        revtron_strech->callback((Fl_Callback*)cb_revtron_strech);
        revtron_strech->align(FL_ALIGN_LEFT);
        revtron_strech->when(FL_WHEN_RELEASE);
      } // SliderW* revtron_strech
      { revtron_idelay = new SliderW(372, 319, 100, 10, "I.Del");
        revtron_idelay->type(5);
        revtron_idelay->box(FL_FLAT_BOX);
        revtron_idelay->color((Fl_Color)178);
        revtron_idelay->selection_color((Fl_Color)62);
        revtron_idelay->labeltype(FL_NORMAL_LABEL);
        revtron_idelay->labelfont(0);
        revtron_idelay->labelsize(10);
        revtron_idelay->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_idelay->maximum(500);
        revtron_idelay->step(1);
        revtron_idelay->textcolor(7);
        revtron_idelay->callback((Fl_Callback*)cb_revtron_idelay);
        revtron_idelay->align(FL_ALIGN_LEFT);
        revtron_idelay->when(FL_WHEN_RELEASE);
      } // SliderW* revtron_idelay
      { revtron_fade = new SliderW(372, 331, 100, 10, "Fade");
        revtron_fade->type(5);
        revtron_fade->box(FL_FLAT_BOX);
        revtron_fade->color((Fl_Color)178);
        revtron_fade->selection_color((Fl_Color)62);
        revtron_fade->labeltype(FL_NORMAL_LABEL);
        revtron_fade->labelfont(0);
        revtron_fade->labelsize(10);
        revtron_fade->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_fade->maximum(127);
        revtron_fade->step(1);
        revtron_fade->textcolor(7);
        revtron_fade->callback((Fl_Callback*)cb_revtron_fade);
        revtron_fade->align(FL_ALIGN_LEFT);
        revtron_fade->when(FL_WHEN_RELEASE);
      } // SliderW* revtron_fade
      { revtron_HPF = new SliderW(373, 343, 100, 10, "Diffusion");
        revtron_HPF->type(5);
        revtron_HPF->box(FL_FLAT_BOX);
        revtron_HPF->color((Fl_Color)178);
        revtron_HPF->selection_color((Fl_Color)62);
        revtron_HPF->labeltype(FL_NORMAL_LABEL);
        revtron_HPF->labelfont(0);
        revtron_HPF->labelsize(10);
        revtron_HPF->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_HPF->maximum(127);
        revtron_HPF->step(1);
        revtron_HPF->value(26000);
        revtron_HPF->textcolor(7);
        revtron_HPF->callback((Fl_Callback*)cb_revtron_HPF);
        revtron_HPF->align(FL_ALIGN_LEFT);
        revtron_HPF->when(FL_WHEN_RELEASE);
      } // SliderW* revtron_HPF
      { revtron_LPF = new SliderW(372, 355, 100, 10, "LPF");
        revtron_LPF->type(5);
        revtron_LPF->box(FL_FLAT_BOX);
        revtron_LPF->color((Fl_Color)178);
        revtron_LPF->selection_color((Fl_Color)62);
        revtron_LPF->labeltype(FL_NORMAL_LABEL);
        revtron_LPF->labelfont(0);
        revtron_LPF->labelsize(10);
        revtron_LPF->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_LPF->minimum(20);
        revtron_LPF->maximum(26000);
        revtron_LPF->step(1);
        revtron_LPF->value(20);
        revtron_LPF->textcolor(7);
        revtron_LPF->callback((Fl_Callback*)cb_revtron_LPF);
        revtron_LPF->align(FL_ALIGN_LEFT);
        revtron_LPF->when(FL_WHEN_RELEASE);
      } // SliderW* revtron_LPF
      { revtron_rv = new Fl_Check_Button(322, 361, 15, 15, "Sh");
        revtron_rv->down_box(FL_BORDER_BOX);
        revtron_rv->labelsize(10);
        revtron_rv->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_rv->callback((Fl_Callback*)cb_revtron_rv, (void*)(2));
      } // Fl_Check_Button* revtron_rv
      { revtron_es = new Fl_Check_Button(322, 374, 15, 15, "ES");
        revtron_es->down_box(FL_BORDER_BOX);
        revtron_es->labelsize(10);
        revtron_es->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_es->callback((Fl_Callback*)cb_revtron_es, (void*)(2));
      } // Fl_Check_Button* revtron_es
      { revtron_safe = new Fl_Check_Button(350, 364, 15, 15, "Safe");
        revtron_safe->down_box(FL_BORDER_BOX);
        revtron_safe->labelsize(10);
        revtron_safe->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_safe->callback((Fl_Callback*)cb_revtron_safe, (void*)(2));
      } // Fl_Check_Button* revtron_safe
      { revtron_user = new Fl_Check_Button(387, 364, 15, 15, "User");
        revtron_user->down_box(FL_BORDER_BOX);
        revtron_user->labelsize(10);
        revtron_user->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_user->callback((Fl_Callback*)cb_revtron_user, (void*)(2));
      } // Fl_Check_Button* revtron_user
      { B_rvb = new Fl_Button(426, 366, 46, 10, "Browse");
        B_rvb->labelsize(10);
        B_rvb->callback((Fl_Callback*)cb_B_rvb, (void*)(2));
        B_rvb->deactivate();
      } // Fl_Button* B_rvb
      { revtron_fnum = new Fl_Choice(371, 378, 101, 14, "File");
        revtron_fnum->down_box(FL_BORDER_BOX);
        revtron_fnum->selection_color(FL_FOREGROUND_COLOR);
        revtron_fnum->labelsize(10);
        revtron_fnum->labelcolor(FL_BACKGROUND2_COLOR);
        revtron_fnum->textsize(10);
        revtron_fnum->textcolor(7);
        revtron_fnum->callback((Fl_Callback*)cb_revtron_fnum, (void*)(12));
        revtron_fnum->menu(menu_revtron_fnum);
      } // Fl_Choice* revtron_fnum
      REVERBTRON->end();
    } // Fl_Group* REVERBTRON
    { ECHOTRON = new Fl_Group(320, 211, 158, 184);
      ECHOTRON->box(FL_UP_BOX);
      ECHOTRON->color(FL_FOREGROUND_COLOR);
      ECHOTRON->selection_color(FL_FOREGROUND_COLOR);
      ECHOTRON->labelfont(1);
      ECHOTRON->user_data((void*)(1));
      ECHOTRON->align(96|FL_ALIGN_INSIDE);
      ECHOTRON->hide();
      { echotron_activar = new Fl_Light_Button(326, 215, 34, 18, "On");
        echotron_activar->shortcut(0x35);
        echotron_activar->color((Fl_Color)62);
        echotron_activar->selection_color((Fl_Color)1);
        echotron_activar->labelsize(10);
        echotron_activar->callback((Fl_Callback*)cb_echotron_activar, (void*)(2));
        echotron_activar->align(68|FL_ALIGN_INSIDE);
        echotron_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* echotron_activar
      { echotron_preset = new Fl_Choice(399, 215, 76, 18, "Preset");
        echotron_preset->down_box(FL_BORDER_BOX);
        echotron_preset->selection_color(FL_FOREGROUND_COLOR);
        echotron_preset->labelsize(10);
        echotron_preset->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_preset->textsize(10);
        echotron_preset->textcolor(7);
        echotron_preset->callback((Fl_Callback*)cb_echotron_preset, (void*)(12041));
        echotron_preset->when(FL_WHEN_RELEASE_ALWAYS);
        echotron_preset->menu(menu_echotron_preset);
      } // Fl_Choice* echotron_preset
      { echotron_WD = new SliderW(372, 236, 100, 10, "Wet/Dry");
        echotron_WD->type(5);
        echotron_WD->box(FL_FLAT_BOX);
        echotron_WD->color((Fl_Color)178);
        echotron_WD->selection_color((Fl_Color)62);
        echotron_WD->labeltype(FL_NORMAL_LABEL);
        echotron_WD->labelfont(0);
        echotron_WD->labelsize(10);
        echotron_WD->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_WD->minimum(-64);
        echotron_WD->maximum(64);
        echotron_WD->step(1);
        echotron_WD->textcolor(7);
        echotron_WD->callback((Fl_Callback*)cb_echotron_WD);
        echotron_WD->align(FL_ALIGN_LEFT);
        echotron_WD->when(FL_WHEN_CHANGED);
      } // SliderW* echotron_WD
      { echotron_pan = new SliderW(372, 248, 100, 10, "Pan");
        echotron_pan->type(5);
        echotron_pan->box(FL_FLAT_BOX);
        echotron_pan->color((Fl_Color)178);
        echotron_pan->selection_color((Fl_Color)62);
        echotron_pan->labeltype(FL_NORMAL_LABEL);
        echotron_pan->labelfont(0);
        echotron_pan->labelsize(10);
        echotron_pan->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_pan->minimum(-64);
        echotron_pan->maximum(63);
        echotron_pan->step(1);
        echotron_pan->textcolor(7);
        echotron_pan->callback((Fl_Callback*)cb_echotron_pan);
        echotron_pan->align(FL_ALIGN_LEFT);
        echotron_pan->when(FL_WHEN_CHANGED);
      } // SliderW* echotron_pan
      { echotron_tempo = new SliderW(372, 260, 100, 10, "Tempo");
        echotron_tempo->type(5);
        echotron_tempo->box(FL_FLAT_BOX);
        echotron_tempo->color((Fl_Color)178);
        echotron_tempo->selection_color((Fl_Color)62);
        echotron_tempo->labeltype(FL_NORMAL_LABEL);
        echotron_tempo->labelfont(0);
        echotron_tempo->labelsize(10);
        echotron_tempo->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_tempo->minimum(1);
        echotron_tempo->maximum(600);
        echotron_tempo->step(1);
        echotron_tempo->value(60);
        echotron_tempo->textcolor(7);
        echotron_tempo->callback((Fl_Callback*)cb_echotron_tempo);
        echotron_tempo->align(FL_ALIGN_LEFT);
        echotron_tempo->when(FL_WHEN_RELEASE);
      } // SliderW* echotron_tempo
      { echotron_damp = new SliderW(372, 272, 100, 10, "Damp");
        echotron_damp->type(5);
        echotron_damp->box(FL_FLAT_BOX);
        echotron_damp->color((Fl_Color)178);
        echotron_damp->selection_color((Fl_Color)62);
        echotron_damp->labeltype(FL_NORMAL_LABEL);
        echotron_damp->labelfont(0);
        echotron_damp->labelsize(10);
        echotron_damp->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_damp->maximum(127);
        echotron_damp->step(1);
        echotron_damp->textcolor(7);
        echotron_damp->callback((Fl_Callback*)cb_echotron_damp);
        echotron_damp->align(FL_ALIGN_LEFT);
        echotron_damp->when(FL_WHEN_CHANGED);
      } // SliderW* echotron_damp
      { echotron_fb = new SliderW(372, 284, 100, 10, "Fb");
        echotron_fb->type(5);
        echotron_fb->box(FL_FLAT_BOX);
        echotron_fb->color((Fl_Color)178);
        echotron_fb->selection_color((Fl_Color)62);
        echotron_fb->labeltype(FL_NORMAL_LABEL);
        echotron_fb->labelfont(0);
        echotron_fb->labelsize(10);
        echotron_fb->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_fb->minimum(-64);
        echotron_fb->maximum(64);
        echotron_fb->step(1);
        echotron_fb->textcolor(7);
        echotron_fb->callback((Fl_Callback*)cb_echotron_fb);
        echotron_fb->align(FL_ALIGN_LEFT);
        echotron_fb->when(FL_WHEN_CHANGED);
      } // SliderW* echotron_fb
      { echotron_lrcross = new SliderW(372, 296, 100, 10, "L/R.Cr");
        echotron_lrcross->type(5);
        echotron_lrcross->box(FL_FLAT_BOX);
        echotron_lrcross->color((Fl_Color)178);
        echotron_lrcross->selection_color((Fl_Color)62);
        echotron_lrcross->labeltype(FL_NORMAL_LABEL);
        echotron_lrcross->labelfont(0);
        echotron_lrcross->labelsize(10);
        echotron_lrcross->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_lrcross->minimum(-64);
        echotron_lrcross->maximum(64);
        echotron_lrcross->step(1);
        echotron_lrcross->textcolor(7);
        echotron_lrcross->callback((Fl_Callback*)cb_echotron_lrcross);
        echotron_lrcross->align(FL_ALIGN_LEFT);
        echotron_lrcross->when(FL_WHEN_CHANGED);
      } // SliderW* echotron_lrcross
      { echotron_width = new SliderW(372, 308, 100, 10, "Width");
        echotron_width->type(5);
        echotron_width->box(FL_FLAT_BOX);
        echotron_width->color((Fl_Color)178);
        echotron_width->selection_color((Fl_Color)62);
        echotron_width->labeltype(FL_NORMAL_LABEL);
        echotron_width->labelfont(0);
        echotron_width->labelsize(10);
        echotron_width->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_width->maximum(127);
        echotron_width->step(1);
        echotron_width->textcolor(7);
        echotron_width->callback((Fl_Callback*)cb_echotron_width);
        echotron_width->align(FL_ALIGN_LEFT);
        echotron_width->when(FL_WHEN_RELEASE);
      } // SliderW* echotron_width
      { echotron_deep = new SliderW(372, 320, 100, 10, "Depth");
        echotron_deep->type(5);
        echotron_deep->box(FL_FLAT_BOX);
        echotron_deep->color((Fl_Color)178);
        echotron_deep->selection_color((Fl_Color)62);
        echotron_deep->labeltype(FL_NORMAL_LABEL);
        echotron_deep->labelfont(0);
        echotron_deep->labelsize(10);
        echotron_deep->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_deep->minimum(-64);
        echotron_deep->maximum(64);
        echotron_deep->step(1);
        echotron_deep->textcolor(7);
        echotron_deep->callback((Fl_Callback*)cb_echotron_deep);
        echotron_deep->align(FL_ALIGN_LEFT);
        echotron_deep->when(FL_WHEN_RELEASE);
      } // SliderW* echotron_deep
      { echotron_stdf = new SliderW(372, 332, 100, 10, "St.df");
        echotron_stdf->type(5);
        echotron_stdf->box(FL_FLAT_BOX);
        echotron_stdf->color((Fl_Color)178);
        echotron_stdf->selection_color((Fl_Color)62);
        echotron_stdf->labeltype(FL_NORMAL_LABEL);
        echotron_stdf->labelfont(0);
        echotron_stdf->labelsize(10);
        echotron_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_stdf->maximum(127);
        echotron_stdf->step(1);
        echotron_stdf->textcolor(7);
        echotron_stdf->callback((Fl_Callback*)cb_echotron_stdf);
        echotron_stdf->align(FL_ALIGN_LEFT);
        echotron_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* echotron_stdf
      { echotron_af = new Fl_Check_Button(322, 347, 15, 15, "AF");
        echotron_af->down_box(FL_BORDER_BOX);
        echotron_af->labelsize(10);
        echotron_af->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_af->callback((Fl_Callback*)cb_echotron_af, (void*)(2));
      } // Fl_Check_Button* echotron_af
      { Fl_Choice* o = echotron_lfotype = new Fl_Choice(408, 346, 64, 16, "LFO Type");
        echotron_lfotype->down_box(FL_BORDER_BOX);
        echotron_lfotype->selection_color(FL_FOREGROUND_COLOR);
        echotron_lfotype->labelsize(10);
        echotron_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_lfotype->textsize(10);
        echotron_lfotype->textcolor(7);
        echotron_lfotype->callback((Fl_Callback*)cb_echotron_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* echotron_lfotype
      { echotron_mf = new Fl_Check_Button(322, 362, 15, 15, "MF");
        echotron_mf->down_box(FL_BORDER_BOX);
        echotron_mf->labelsize(10);
        echotron_mf->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_mf->callback((Fl_Callback*)cb_echotron_mf, (void*)(2));
      } // Fl_Check_Button* echotron_mf
      { echotron_md = new Fl_Check_Button(353, 362, 15, 15, "MD");
        echotron_md->down_box(FL_BORDER_BOX);
        echotron_md->labelsize(10);
        echotron_md->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_md->callback((Fl_Callback*)cb_echotron_md, (void*)(2));
      } // Fl_Check_Button* echotron_md
      { echotron_user = new Fl_Check_Button(387, 365, 15, 15, "User");
        echotron_user->down_box(FL_BORDER_BOX);
        echotron_user->labelsize(10);
        echotron_user->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_user->callback((Fl_Callback*)cb_echotron_user, (void*)(2));
      } // Fl_Check_Button* echotron_user
      { B_ech = new Fl_Button(426, 367, 46, 10, "Browse");
        B_ech->labelsize(10);
        B_ech->callback((Fl_Callback*)cb_B_ech, (void*)(2));
        B_ech->deactivate();
      } // Fl_Button* B_ech
      { echotron_length = new Fl_Counter(336, 378, 48, 12, "#");
        echotron_length->type(1);
        echotron_length->labelsize(10);
        echotron_length->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_length->minimum(1);
        echotron_length->maximum(127);
        echotron_length->step(1);
        echotron_length->value(1);
        echotron_length->textsize(9);
        echotron_length->callback((Fl_Callback*)cb_echotron_length);
        echotron_length->align(FL_ALIGN_LEFT);
        echotron_length->when(FL_WHEN_RELEASE);
      } // Fl_Counter* echotron_length
      { echotron_fnum = new Fl_Choice(408, 379, 64, 14, "File");
        echotron_fnum->down_box(FL_BORDER_BOX);
        echotron_fnum->selection_color(FL_FOREGROUND_COLOR);
        echotron_fnum->labelsize(10);
        echotron_fnum->labelcolor(FL_BACKGROUND2_COLOR);
        echotron_fnum->textsize(10);
        echotron_fnum->textcolor(7);
        echotron_fnum->callback((Fl_Callback*)cb_echotron_fnum, (void*)(12));
        echotron_fnum->menu(menu_echotron_fnum);
      } // Fl_Choice* echotron_fnum
      ECHOTRON->end();
    } // Fl_Group* ECHOTRON
    { SHAR = new Fl_Group(320, 211, 158, 184);
      SHAR->box(FL_UP_BOX);
      SHAR->color(FL_FOREGROUND_COLOR);
      SHAR->selection_color(FL_FOREGROUND_COLOR);
      SHAR->labelfont(1);
      SHAR->user_data((void*)(1));
      SHAR->align(96|FL_ALIGN_INSIDE);
      SHAR->hide();
      { shar_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        shar_activar->shortcut(0x30);
        shar_activar->color((Fl_Color)62);
        shar_activar->selection_color((Fl_Color)1);
        shar_activar->labelsize(10);
        shar_activar->callback((Fl_Callback*)cb_shar_activar, (void*)(2));
        shar_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* shar_activar
      { shar_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        shar_preset->down_box(FL_BORDER_BOX);
        shar_preset->selection_color(FL_FOREGROUND_COLOR);
        shar_preset->labelsize(10);
        shar_preset->labelcolor(FL_BACKGROUND2_COLOR);
        shar_preset->textsize(10);
        shar_preset->textcolor(7);
        shar_preset->callback((Fl_Callback*)cb_shar_preset, (void*)(12042));
        shar_preset->when(FL_WHEN_RELEASE_ALWAYS);
        shar_preset->menu(menu_shar_preset);
      } // Fl_Choice* shar_preset
      { shar_WD = new SliderW(370, 237, 100, 10, "Wet/Dry");
        shar_WD->type(5);
        shar_WD->box(FL_FLAT_BOX);
        shar_WD->color((Fl_Color)178);
        shar_WD->selection_color((Fl_Color)62);
        shar_WD->labeltype(FL_NORMAL_LABEL);
        shar_WD->labelfont(0);
        shar_WD->labelsize(10);
        shar_WD->labelcolor(FL_BACKGROUND2_COLOR);
        shar_WD->minimum(-64);
        shar_WD->maximum(63);
        shar_WD->step(1);
        shar_WD->textcolor(7);
        shar_WD->callback((Fl_Callback*)cb_shar_WD);
        shar_WD->align(FL_ALIGN_LEFT);
        shar_WD->when(FL_WHEN_CHANGED);
      } // SliderW* shar_WD
      { shar_intl = new SliderW(370, 250, 100, 10, "Int L");
        shar_intl->type(5);
        shar_intl->box(FL_FLAT_BOX);
        shar_intl->color((Fl_Color)178);
        shar_intl->selection_color((Fl_Color)62);
        shar_intl->labeltype(FL_NORMAL_LABEL);
        shar_intl->labelfont(0);
        shar_intl->labelsize(10);
        shar_intl->labelcolor(FL_BACKGROUND2_COLOR);
        shar_intl->minimum(-12);
        shar_intl->maximum(12);
        shar_intl->step(1);
        shar_intl->textcolor(7);
        shar_intl->callback((Fl_Callback*)cb_shar_intl);
        shar_intl->align(FL_ALIGN_LEFT);
        shar_intl->when(FL_WHEN_CHANGED);
      } // SliderW* shar_intl
      { shar_chl = new SliderW(370, 263, 100, 10, "Chrm L");
        shar_chl->type(5);
        shar_chl->box(FL_FLAT_BOX);
        shar_chl->color((Fl_Color)178);
        shar_chl->selection_color((Fl_Color)62);
        shar_chl->labeltype(FL_NORMAL_LABEL);
        shar_chl->labelfont(0);
        shar_chl->labelsize(10);
        shar_chl->labelcolor(FL_BACKGROUND2_COLOR);
        shar_chl->minimum(-2000);
        shar_chl->maximum(2000);
        shar_chl->step(1);
        shar_chl->textcolor(7);
        shar_chl->callback((Fl_Callback*)cb_shar_chl);
        shar_chl->align(FL_ALIGN_LEFT);
        shar_chl->when(FL_WHEN_CHANGED);
      } // SliderW* shar_chl
      { shar_ganl = new SliderW(370, 276, 100, 10, "Gain L");
        shar_ganl->type(5);
        shar_ganl->box(FL_FLAT_BOX);
        shar_ganl->color((Fl_Color)178);
        shar_ganl->selection_color((Fl_Color)62);
        shar_ganl->labeltype(FL_NORMAL_LABEL);
        shar_ganl->labelfont(0);
        shar_ganl->labelsize(10);
        shar_ganl->labelcolor(FL_BACKGROUND2_COLOR);
        shar_ganl->minimum(-64);
        shar_ganl->maximum(64);
        shar_ganl->step(1);
        shar_ganl->textcolor(7);
        shar_ganl->callback((Fl_Callback*)cb_shar_ganl);
        shar_ganl->align(FL_ALIGN_LEFT);
        shar_ganl->when(FL_WHEN_CHANGED);
      } // SliderW* shar_ganl
      { shar_intr = new SliderW(370, 289, 100, 10, "Int R");
        shar_intr->type(5);
        shar_intr->box(FL_FLAT_BOX);
        shar_intr->color((Fl_Color)178);
        shar_intr->selection_color((Fl_Color)62);
        shar_intr->labeltype(FL_NORMAL_LABEL);
        shar_intr->labelfont(0);
        shar_intr->labelsize(10);
        shar_intr->labelcolor(FL_BACKGROUND2_COLOR);
        shar_intr->minimum(-12);
        shar_intr->maximum(12);
        shar_intr->step(1);
        shar_intr->textcolor(7);
        shar_intr->callback((Fl_Callback*)cb_shar_intr);
        shar_intr->align(FL_ALIGN_LEFT);
        shar_intr->when(FL_WHEN_CHANGED);
      } // SliderW* shar_intr
      { shar_chr = new SliderW(370, 302, 100, 10, "Chrm R");
        shar_chr->type(5);
        shar_chr->box(FL_FLAT_BOX);
        shar_chr->color((Fl_Color)178);
        shar_chr->selection_color((Fl_Color)62);
        shar_chr->labeltype(FL_NORMAL_LABEL);
        shar_chr->labelfont(0);
        shar_chr->labelsize(10);
        shar_chr->labelcolor(FL_BACKGROUND2_COLOR);
        shar_chr->minimum(-2000);
        shar_chr->maximum(2000);
        shar_chr->step(1);
        shar_chr->textcolor(7);
        shar_chr->callback((Fl_Callback*)cb_shar_chr);
        shar_chr->align(FL_ALIGN_LEFT);
        shar_chr->when(FL_WHEN_CHANGED);
      } // SliderW* shar_chr
      { shar_ganr = new SliderW(370, 315, 100, 10, "Gain R");
        shar_ganr->type(5);
        shar_ganr->box(FL_FLAT_BOX);
        shar_ganr->color((Fl_Color)178);
        shar_ganr->selection_color((Fl_Color)62);
        shar_ganr->labeltype(FL_NORMAL_LABEL);
        shar_ganr->labelfont(0);
        shar_ganr->labelsize(10);
        shar_ganr->labelcolor(FL_BACKGROUND2_COLOR);
        shar_ganr->minimum(-64);
        shar_ganr->maximum(64);
        shar_ganr->step(1);
        shar_ganr->textcolor(7);
        shar_ganr->callback((Fl_Callback*)cb_shar_ganr);
        shar_ganr->align(FL_ALIGN_LEFT);
        shar_ganr->when(FL_WHEN_CHANGED);
      } // SliderW* shar_ganr
      { shar_lrc = new SliderW(370, 328, 100, 10, "L/R.Cr");
        shar_lrc->type(5);
        shar_lrc->box(FL_FLAT_BOX);
        shar_lrc->color((Fl_Color)178);
        shar_lrc->selection_color((Fl_Color)62);
        shar_lrc->labeltype(FL_NORMAL_LABEL);
        shar_lrc->labelfont(0);
        shar_lrc->labelsize(10);
        shar_lrc->labelcolor(FL_BACKGROUND2_COLOR);
        shar_lrc->minimum(-64);
        shar_lrc->maximum(64);
        shar_lrc->step(1);
        shar_lrc->textcolor(7);
        shar_lrc->callback((Fl_Callback*)cb_shar_lrc);
        shar_lrc->align(FL_ALIGN_LEFT);
        shar_lrc->when(FL_WHEN_CHANGED);
      } // SliderW* shar_lrc
      { shar_MIDI = new Fl_Check_Button(329, 340, 15, 15, "MIDI");
        shar_MIDI->down_box(FL_BORDER_BOX);
        shar_MIDI->labelsize(10);
        shar_MIDI->labelcolor(FL_BACKGROUND2_COLOR);
        shar_MIDI->callback((Fl_Callback*)cb_shar_MIDI, (void*)(2));
        shar_MIDI->align(FL_ALIGN_RIGHT);
      } // Fl_Check_Button* shar_MIDI
      { shar_SELECT = new Fl_Check_Button(329, 353, 15, 15, "SEL");
        shar_SELECT->down_box(FL_BORDER_BOX);
        shar_SELECT->labelsize(10);
        shar_SELECT->labelcolor(FL_BACKGROUND2_COLOR);
        shar_SELECT->callback((Fl_Callback*)cb_shar_SELECT, (void*)(2));
        shar_SELECT->align(FL_ALIGN_RIGHT);
      } // Fl_Check_Button* shar_SELECT
      { shar_chordname = new Fl_Box(376, 343, 98, 21);
        shar_chordname->labelsize(12);
        shar_chordname->labelcolor(FL_BACKGROUND2_COLOR);
      } // Fl_Box* shar_chordname
      { shar_note = new SliderW(370, 369, 100, 10, "Note");
        shar_note->type(5);
        shar_note->box(FL_FLAT_BOX);
        shar_note->color((Fl_Color)178);
        shar_note->selection_color((Fl_Color)62);
        shar_note->labeltype(FL_NORMAL_LABEL);
        shar_note->labelfont(0);
        shar_note->labelsize(10);
        shar_note->labelcolor(FL_BACKGROUND2_COLOR);
        shar_note->maximum(23);
        shar_note->step(1);
        shar_note->textcolor(7);
        shar_note->callback((Fl_Callback*)cb_shar_note);
        shar_note->align(FL_ALIGN_LEFT);
        shar_note->when(FL_WHEN_CHANGED);
      } // SliderW* shar_note
      { shar_type = new SliderW(370, 381, 100, 10, "Chord");
        shar_type->type(5);
        shar_type->box(FL_FLAT_BOX);
        shar_type->color((Fl_Color)178);
        shar_type->selection_color((Fl_Color)62);
        shar_type->labeltype(FL_NORMAL_LABEL);
        shar_type->labelfont(0);
        shar_type->labelsize(10);
        shar_type->labelcolor(FL_BACKGROUND2_COLOR);
        shar_type->maximum(33);
        shar_type->step(1);
        shar_type->textcolor(7);
        shar_type->callback((Fl_Callback*)cb_shar_type);
        shar_type->align(FL_ALIGN_LEFT);
        shar_type->when(FL_WHEN_CHANGED);
      } // SliderW* shar_type
      SHAR->end();
    } // Fl_Group* SHAR
    { COMPBAND = new Fl_Group(320, 211, 158, 184);
      COMPBAND->box(FL_UP_BOX);
      COMPBAND->color(FL_FOREGROUND_COLOR);
      COMPBAND->selection_color(FL_FOREGROUND_COLOR);
      COMPBAND->labelfont(1);
      COMPBAND->user_data((void*)(1));
      COMPBAND->align(96|FL_ALIGN_INSIDE);
      { cband_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        cband_activar->shortcut(0x38);
        cband_activar->color((Fl_Color)62);
        cband_activar->selection_color((Fl_Color)1);
        cband_activar->labelsize(10);
        cband_activar->callback((Fl_Callback*)cb_cband_activar, (void*)(2));
        cband_activar->align(68|FL_ALIGN_INSIDE);
        cband_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* cband_activar
      { cband_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        cband_preset->down_box(FL_BORDER_BOX);
        cband_preset->selection_color(FL_FOREGROUND_COLOR);
        cband_preset->labelsize(10);
        cband_preset->labelcolor(FL_BACKGROUND2_COLOR);
        cband_preset->textsize(10);
        cband_preset->textcolor(7);
        cband_preset->callback((Fl_Callback*)cb_cband_preset, (void*)(12043));
        cband_preset->when(FL_WHEN_RELEASE_ALWAYS);
        cband_preset->menu(menu_cband_preset);
      } // Fl_Choice* cband_preset
      { cband_WD = new SliderW(372, 238, 100, 10, "Wet/Dry");
        cband_WD->type(5);
        cband_WD->box(FL_FLAT_BOX);
        cband_WD->color((Fl_Color)178);
        cband_WD->selection_color((Fl_Color)62);
        cband_WD->labeltype(FL_NORMAL_LABEL);
        cband_WD->labelfont(0);
        cband_WD->labelsize(10);
        cband_WD->labelcolor(FL_BACKGROUND2_COLOR);
        cband_WD->minimum(-64);
        cband_WD->maximum(64);
        cband_WD->step(1);
        cband_WD->textcolor(7);
        cband_WD->callback((Fl_Callback*)cb_cband_WD);
        cband_WD->align(FL_ALIGN_LEFT);
        cband_WD->when(FL_WHEN_CHANGED);
      } // SliderW* cband_WD
      { cband_gain = new SliderW(372, 250, 100, 10, "Gain");
        cband_gain->type(5);
        cband_gain->box(FL_FLAT_BOX);
        cband_gain->color((Fl_Color)178);
        cband_gain->selection_color((Fl_Color)62);
        cband_gain->labeltype(FL_NORMAL_LABEL);
        cband_gain->labelfont(0);
        cband_gain->labelsize(10);
        cband_gain->labelcolor(FL_BACKGROUND2_COLOR);
        cband_gain->maximum(127);
        cband_gain->step(1);
        cband_gain->textcolor(7);
        cband_gain->callback((Fl_Callback*)cb_cband_gain);
        cband_gain->align(FL_ALIGN_LEFT);
        cband_gain->when(FL_WHEN_CHANGED);
      } // SliderW* cband_gain
      { cband_Lratio = new SliderW(372, 262, 100, 10, "L Ratio");
        cband_Lratio->type(5);
        cband_Lratio->box(FL_FLAT_BOX);
        cband_Lratio->color((Fl_Color)178);
        cband_Lratio->selection_color((Fl_Color)62);
        cband_Lratio->labeltype(FL_NORMAL_LABEL);
        cband_Lratio->labelfont(0);
        cband_Lratio->labelsize(10);
        cband_Lratio->labelcolor(FL_BACKGROUND2_COLOR);
        cband_Lratio->minimum(2);
        cband_Lratio->maximum(42);
        cband_Lratio->step(1);
        cband_Lratio->value(2);
        cband_Lratio->textcolor(7);
        cband_Lratio->callback((Fl_Callback*)cb_cband_Lratio);
        cband_Lratio->align(FL_ALIGN_LEFT);
        cband_Lratio->when(FL_WHEN_CHANGED);
      } // SliderW* cband_Lratio
      { cband_MLratio = new SliderW(372, 274, 100, 10, "ML Ratio");
        cband_MLratio->type(5);
        cband_MLratio->box(FL_FLAT_BOX);
        cband_MLratio->color((Fl_Color)178);
        cband_MLratio->selection_color((Fl_Color)62);
        cband_MLratio->labeltype(FL_NORMAL_LABEL);
        cband_MLratio->labelfont(0);
        cband_MLratio->labelsize(10);
        cband_MLratio->labelcolor(FL_BACKGROUND2_COLOR);
        cband_MLratio->minimum(2);
        cband_MLratio->maximum(42);
        cband_MLratio->step(1);
        cband_MLratio->value(2);
        cband_MLratio->textcolor(7);
        cband_MLratio->callback((Fl_Callback*)cb_cband_MLratio);
        cband_MLratio->align(FL_ALIGN_LEFT);
        cband_MLratio->when(FL_WHEN_CHANGED);
      } // SliderW* cband_MLratio
      { cband_MHratio = new SliderW(372, 286, 100, 10, "MH Ratio");
        cband_MHratio->type(5);
        cband_MHratio->box(FL_FLAT_BOX);
        cband_MHratio->color((Fl_Color)178);
        cband_MHratio->selection_color((Fl_Color)62);
        cband_MHratio->labeltype(FL_NORMAL_LABEL);
        cband_MHratio->labelfont(0);
        cband_MHratio->labelsize(10);
        cband_MHratio->labelcolor(FL_BACKGROUND2_COLOR);
        cband_MHratio->minimum(2);
        cband_MHratio->maximum(42);
        cband_MHratio->step(1);
        cband_MHratio->value(2);
        cband_MHratio->textcolor(7);
        cband_MHratio->callback((Fl_Callback*)cb_cband_MHratio);
        cband_MHratio->align(FL_ALIGN_LEFT);
        cband_MHratio->when(FL_WHEN_CHANGED);
      } // SliderW* cband_MHratio
      { cband_Hratio = new SliderW(372, 298, 100, 10, "H Ratio");
        cband_Hratio->type(5);
        cband_Hratio->box(FL_FLAT_BOX);
        cband_Hratio->color((Fl_Color)178);
        cband_Hratio->selection_color((Fl_Color)62);
        cband_Hratio->labeltype(FL_NORMAL_LABEL);
        cband_Hratio->labelfont(0);
        cband_Hratio->labelsize(10);
        cband_Hratio->labelcolor(FL_BACKGROUND2_COLOR);
        cband_Hratio->minimum(2);
        cband_Hratio->maximum(42);
        cband_Hratio->step(1);
        cband_Hratio->value(2);
        cband_Hratio->textcolor(7);
        cband_Hratio->callback((Fl_Callback*)cb_cband_Hratio);
        cband_Hratio->align(FL_ALIGN_LEFT);
        cband_Hratio->when(FL_WHEN_CHANGED);
      } // SliderW* cband_Hratio
      { cband_Lthres = new SliderW(372, 310, 100, 10, "L Thres");
        cband_Lthres->type(5);
        cband_Lthres->box(FL_FLAT_BOX);
        cband_Lthres->color((Fl_Color)178);
        cband_Lthres->selection_color((Fl_Color)62);
        cband_Lthres->labeltype(FL_NORMAL_LABEL);
        cband_Lthres->labelfont(0);
        cband_Lthres->labelsize(10);
        cband_Lthres->labelcolor(FL_BACKGROUND2_COLOR);
        cband_Lthres->minimum(-70);
        cband_Lthres->maximum(24);
        cband_Lthres->step(1);
        cband_Lthres->textcolor(7);
        cband_Lthres->callback((Fl_Callback*)cb_cband_Lthres);
        cband_Lthres->align(FL_ALIGN_LEFT);
        cband_Lthres->when(FL_WHEN_CHANGED);
      } // SliderW* cband_Lthres
      { cband_MLthres = new SliderW(372, 322, 100, 10, "ML Thres");
        cband_MLthres->type(5);
        cband_MLthres->box(FL_FLAT_BOX);
        cband_MLthres->color((Fl_Color)178);
        cband_MLthres->selection_color((Fl_Color)62);
        cband_MLthres->labeltype(FL_NORMAL_LABEL);
        cband_MLthres->labelfont(0);
        cband_MLthres->labelsize(10);
        cband_MLthres->labelcolor(FL_BACKGROUND2_COLOR);
        cband_MLthres->minimum(-70);
        cband_MLthres->maximum(24);
        cband_MLthres->step(1);
        cband_MLthres->textcolor(7);
        cband_MLthres->callback((Fl_Callback*)cb_cband_MLthres);
        cband_MLthres->align(FL_ALIGN_LEFT);
        cband_MLthres->when(FL_WHEN_CHANGED);
      } // SliderW* cband_MLthres
      { cband_MHthres = new SliderW(372, 334, 100, 10, "MH Thres");
        cband_MHthres->type(5);
        cband_MHthres->box(FL_FLAT_BOX);
        cband_MHthres->color((Fl_Color)178);
        cband_MHthres->selection_color((Fl_Color)62);
        cband_MHthres->labeltype(FL_NORMAL_LABEL);
        cband_MHthres->labelfont(0);
        cband_MHthres->labelsize(10);
        cband_MHthres->labelcolor(FL_BACKGROUND2_COLOR);
        cband_MHthres->minimum(-70);
        cband_MHthres->maximum(24);
        cband_MHthres->step(1);
        cband_MHthres->textcolor(7);
        cband_MHthres->callback((Fl_Callback*)cb_cband_MHthres);
        cband_MHthres->align(FL_ALIGN_LEFT);
        cband_MHthres->when(FL_WHEN_CHANGED);
      } // SliderW* cband_MHthres
      { cband_Hthres = new SliderW(372, 346, 100, 10, "H Thres");
        cband_Hthres->type(5);
        cband_Hthres->box(FL_FLAT_BOX);
        cband_Hthres->color((Fl_Color)178);
        cband_Hthres->selection_color((Fl_Color)62);
        cband_Hthres->labeltype(FL_NORMAL_LABEL);
        cband_Hthres->labelfont(0);
        cband_Hthres->labelsize(10);
        cband_Hthres->labelcolor(FL_BACKGROUND2_COLOR);
        cband_Hthres->minimum(-70);
        cband_Hthres->maximum(24);
        cband_Hthres->step(1);
        cband_Hthres->textcolor(7);
        cband_Hthres->callback((Fl_Callback*)cb_cband_Hthres);
        cband_Hthres->align(FL_ALIGN_LEFT);
        cband_Hthres->when(FL_WHEN_CHANGED);
      } // SliderW* cband_Hthres
      { cband_cross1 = new SliderW(372, 358, 100, 10, "Cross1");
        cband_cross1->type(5);
        cband_cross1->box(FL_FLAT_BOX);
        cband_cross1->color((Fl_Color)178);
        cband_cross1->selection_color((Fl_Color)62);
        cband_cross1->labeltype(FL_NORMAL_LABEL);
        cband_cross1->labelfont(0);
        cband_cross1->labelsize(10);
        cband_cross1->labelcolor(FL_BACKGROUND2_COLOR);
        cband_cross1->minimum(20);
        cband_cross1->maximum(1000);
        cband_cross1->step(1);
        cband_cross1->textcolor(7);
        cband_cross1->callback((Fl_Callback*)cb_cband_cross1);
        cband_cross1->align(FL_ALIGN_LEFT);
        cband_cross1->when(FL_WHEN_CHANGED);
      } // SliderW* cband_cross1
      { cband_cross2 = new SliderW(372, 370, 100, 10, "Cross2");
        cband_cross2->type(5);
        cband_cross2->box(FL_FLAT_BOX);
        cband_cross2->color((Fl_Color)178);
        cband_cross2->selection_color((Fl_Color)62);
        cband_cross2->labeltype(FL_NORMAL_LABEL);
        cband_cross2->labelfont(0);
        cband_cross2->labelsize(10);
        cband_cross2->labelcolor(FL_BACKGROUND2_COLOR);
        cband_cross2->minimum(1000);
        cband_cross2->maximum(8000);
        cband_cross2->step(1);
        cband_cross2->textcolor(7);
        cband_cross2->callback((Fl_Callback*)cb_cband_cross2);
        cband_cross2->align(FL_ALIGN_LEFT);
        cband_cross2->when(FL_WHEN_CHANGED);
      } // SliderW* cband_cross2
      { cband_cross3 = new SliderW(372, 382, 100, 10, "Cross3");
        cband_cross3->type(5);
        cband_cross3->box(FL_FLAT_BOX);
        cband_cross3->color((Fl_Color)178);
        cband_cross3->selection_color((Fl_Color)62);
        cband_cross3->labeltype(FL_NORMAL_LABEL);
        cband_cross3->labelfont(0);
        cband_cross3->labelsize(10);
        cband_cross3->labelcolor(FL_BACKGROUND2_COLOR);
        cband_cross3->minimum(2000);
        cband_cross3->maximum(26000);
        cband_cross3->step(1);
        cband_cross3->textcolor(7);
        cband_cross3->callback((Fl_Callback*)cb_cband_cross3);
        cband_cross3->align(FL_ALIGN_LEFT);
        cband_cross3->when(FL_WHEN_CHANGED);
      } // SliderW* cband_cross3
      COMPBAND->end();
    } // Fl_Group* COMPBAND
    { OTREM = new Fl_Group(320, 211, 158, 184);
      OTREM->box(FL_UP_BOX);
      OTREM->color(FL_FOREGROUND_COLOR);
      OTREM->selection_color(FL_FOREGROUND_COLOR);
      OTREM->labelfont(1);
      OTREM->user_data((void*)(1));
      OTREM->align(96|FL_ALIGN_INSIDE);
      OTREM->hide();
      { otrem_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        otrem_activar->shortcut(0x38);
        otrem_activar->color((Fl_Color)62);
        otrem_activar->selection_color((Fl_Color)1);
        otrem_activar->labelsize(10);
        otrem_activar->callback((Fl_Callback*)cb_otrem_activar, (void*)(2));
        otrem_activar->align(68|FL_ALIGN_INSIDE);
        otrem_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* otrem_activar
      { otrem_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        otrem_preset->down_box(FL_BORDER_BOX);
        otrem_preset->selection_color(FL_FOREGROUND_COLOR);
        otrem_preset->labelsize(10);
        otrem_preset->labelcolor(FL_BACKGROUND2_COLOR);
        otrem_preset->textsize(10);
        otrem_preset->textcolor(7);
        otrem_preset->callback((Fl_Callback*)cb_otrem_preset, (void*)(12044));
        otrem_preset->when(FL_WHEN_RELEASE_ALWAYS);
        otrem_preset->menu(menu_otrem_preset);
      } // Fl_Choice* otrem_preset
      { otrem_dpth = new SliderW(372, 244, 100, 10, "Depth");
        otrem_dpth->type(5);
        otrem_dpth->box(FL_FLAT_BOX);
        otrem_dpth->color((Fl_Color)178);
        otrem_dpth->selection_color((Fl_Color)62);
        otrem_dpth->labeltype(FL_NORMAL_LABEL);
        otrem_dpth->labelfont(0);
        otrem_dpth->labelsize(10);
        otrem_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        otrem_dpth->maximum(127);
        otrem_dpth->step(1);
        otrem_dpth->textcolor(7);
        otrem_dpth->callback((Fl_Callback*)cb_otrem_dpth);
        otrem_dpth->align(FL_ALIGN_LEFT);
        otrem_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* otrem_dpth
      { otrem_freq = new SliderW(372, 264, 100, 10, "Tempo");
        otrem_freq->type(5);
        otrem_freq->box(FL_FLAT_BOX);
        otrem_freq->color((Fl_Color)178);
        otrem_freq->selection_color((Fl_Color)62);
        otrem_freq->labeltype(FL_NORMAL_LABEL);
        otrem_freq->labelfont(0);
        otrem_freq->labelsize(10);
        otrem_freq->labelcolor(FL_BACKGROUND2_COLOR);
        otrem_freq->minimum(1);
        otrem_freq->maximum(600);
        otrem_freq->step(1);
        otrem_freq->textcolor(7);
        otrem_freq->callback((Fl_Callback*)cb_otrem_freq);
        otrem_freq->align(FL_ALIGN_LEFT);
        otrem_freq->when(FL_WHEN_CHANGED);
      } // SliderW* otrem_freq
      { otrem_rnd = new SliderW(372, 284, 100, 10, "Rnd");
        otrem_rnd->type(5);
        otrem_rnd->box(FL_FLAT_BOX);
        otrem_rnd->color((Fl_Color)178);
        otrem_rnd->selection_color((Fl_Color)62);
        otrem_rnd->labeltype(FL_NORMAL_LABEL);
        otrem_rnd->labelfont(0);
        otrem_rnd->labelsize(10);
        otrem_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        otrem_rnd->maximum(127);
        otrem_rnd->step(1);
        otrem_rnd->textcolor(7);
        otrem_rnd->callback((Fl_Callback*)cb_otrem_rnd);
        otrem_rnd->align(FL_ALIGN_LEFT);
        otrem_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* otrem_rnd
      { Fl_Choice* o = otrem_lfotype = new Fl_Choice(383, 311, 72, 16, "LFO Type");
        otrem_lfotype->down_box(FL_BORDER_BOX);
        otrem_lfotype->selection_color(FL_FOREGROUND_COLOR);
        otrem_lfotype->labelsize(10);
        otrem_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        otrem_lfotype->textsize(10);
        otrem_lfotype->textcolor(7);
        otrem_lfotype->callback((Fl_Callback*)cb_otrem_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* otrem_lfotype
      { otrem_stdf = new SliderW(372, 338, 100, 10, "St.df");
        otrem_stdf->type(5);
        otrem_stdf->box(FL_FLAT_BOX);
        otrem_stdf->color((Fl_Color)178);
        otrem_stdf->selection_color((Fl_Color)62);
        otrem_stdf->labeltype(FL_NORMAL_LABEL);
        otrem_stdf->labelfont(0);
        otrem_stdf->labelsize(10);
        otrem_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        otrem_stdf->maximum(127);
        otrem_stdf->step(1);
        otrem_stdf->textcolor(7);
        otrem_stdf->callback((Fl_Callback*)cb_otrem_stdf);
        otrem_stdf->align(FL_ALIGN_LEFT);
        otrem_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* otrem_stdf
      { otrem_pan = new SliderW(372, 358, 100, 10, "Pan");
        otrem_pan->type(5);
        otrem_pan->box(FL_FLAT_BOX);
        otrem_pan->color((Fl_Color)178);
        otrem_pan->selection_color((Fl_Color)62);
        otrem_pan->labeltype(FL_NORMAL_LABEL);
        otrem_pan->labelfont(0);
        otrem_pan->labelsize(10);
        otrem_pan->labelcolor(FL_BACKGROUND2_COLOR);
        otrem_pan->minimum(-64);
        otrem_pan->maximum(63);
        otrem_pan->step(1);
        otrem_pan->textcolor(7);
        otrem_pan->callback((Fl_Callback*)cb_otrem_pan);
        otrem_pan->align(FL_ALIGN_LEFT);
        otrem_pan->when(FL_WHEN_CHANGED);
      } // SliderW* otrem_pan
      OTREM->end();
    } // Fl_Group* OTREM
    { VIBE = new Fl_Group(320, 211, 158, 184);
      VIBE->box(FL_UP_BOX);
      VIBE->color(FL_FOREGROUND_COLOR);
      VIBE->selection_color(FL_FOREGROUND_COLOR);
      VIBE->labelfont(1);
      VIBE->user_data((void*)(1));
      VIBE->align(96|FL_ALIGN_INSIDE);
      VIBE->hide();
      { vibe_activar = new Fl_Light_Button(325, 215, 34, 18, "On");
        vibe_activar->shortcut(0x38);
        vibe_activar->color((Fl_Color)62);
        vibe_activar->selection_color((Fl_Color)1);
        vibe_activar->labelsize(10);
        vibe_activar->callback((Fl_Callback*)cb_vibe_activar, (void*)(2));
        vibe_activar->align(68|FL_ALIGN_INSIDE);
        vibe_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* vibe_activar
      { vibe_preset = new Fl_Choice(397, 215, 76, 18, "Preset");
        vibe_preset->down_box(FL_BORDER_BOX);
        vibe_preset->selection_color(FL_FOREGROUND_COLOR);
        vibe_preset->labelsize(10);
        vibe_preset->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_preset->textsize(10);
        vibe_preset->textcolor(7);
        vibe_preset->callback((Fl_Callback*)cb_vibe_preset, (void*)(12045));
        vibe_preset->when(FL_WHEN_RELEASE_ALWAYS);
        vibe_preset->menu(menu_vibe_preset);
      } // Fl_Choice* vibe_preset
      { vibe_WD = new SliderW(372, 240, 100, 10, "Wet/Dry");
        vibe_WD->type(5);
        vibe_WD->box(FL_FLAT_BOX);
        vibe_WD->color((Fl_Color)178);
        vibe_WD->selection_color((Fl_Color)62);
        vibe_WD->labeltype(FL_NORMAL_LABEL);
        vibe_WD->labelfont(0);
        vibe_WD->labelsize(10);
        vibe_WD->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_WD->minimum(-64);
        vibe_WD->maximum(64);
        vibe_WD->step(1);
        vibe_WD->textcolor(7);
        vibe_WD->callback((Fl_Callback*)cb_vibe_WD);
        vibe_WD->align(FL_ALIGN_LEFT);
        vibe_WD->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_WD
      { vibe_width = new SliderW(372, 254, 100, 10, "Width");
        vibe_width->type(5);
        vibe_width->box(FL_FLAT_BOX);
        vibe_width->color((Fl_Color)178);
        vibe_width->selection_color((Fl_Color)62);
        vibe_width->labeltype(FL_NORMAL_LABEL);
        vibe_width->labelfont(0);
        vibe_width->labelsize(10);
        vibe_width->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_width->maximum(127);
        vibe_width->step(1);
        vibe_width->textcolor(7);
        vibe_width->callback((Fl_Callback*)cb_vibe_width);
        vibe_width->align(FL_ALIGN_LEFT);
        vibe_width->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_width
      { vibe_dpth = new SliderW(372, 268, 100, 10, "Depth");
        vibe_dpth->type(5);
        vibe_dpth->box(FL_FLAT_BOX);
        vibe_dpth->color((Fl_Color)178);
        vibe_dpth->selection_color((Fl_Color)62);
        vibe_dpth->labeltype(FL_NORMAL_LABEL);
        vibe_dpth->labelfont(0);
        vibe_dpth->labelsize(10);
        vibe_dpth->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_dpth->maximum(127);
        vibe_dpth->step(1);
        vibe_dpth->textcolor(7);
        vibe_dpth->callback((Fl_Callback*)cb_vibe_dpth);
        vibe_dpth->align(FL_ALIGN_LEFT);
        vibe_dpth->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_dpth
      { vibe_freq = new SliderW(372, 282, 100, 10, "Tempo");
        vibe_freq->type(5);
        vibe_freq->box(FL_FLAT_BOX);
        vibe_freq->color((Fl_Color)178);
        vibe_freq->selection_color((Fl_Color)62);
        vibe_freq->labeltype(FL_NORMAL_LABEL);
        vibe_freq->labelfont(0);
        vibe_freq->labelsize(10);
        vibe_freq->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_freq->minimum(1);
        vibe_freq->maximum(600);
        vibe_freq->step(1);
        vibe_freq->textcolor(7);
        vibe_freq->callback((Fl_Callback*)cb_vibe_freq);
        vibe_freq->align(FL_ALIGN_LEFT);
        vibe_freq->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_freq
      { vibe_rnd = new SliderW(372, 296, 100, 10, "Rnd");
        vibe_rnd->type(5);
        vibe_rnd->box(FL_FLAT_BOX);
        vibe_rnd->color((Fl_Color)178);
        vibe_rnd->selection_color((Fl_Color)62);
        vibe_rnd->labeltype(FL_NORMAL_LABEL);
        vibe_rnd->labelfont(0);
        vibe_rnd->labelsize(10);
        vibe_rnd->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_rnd->maximum(127);
        vibe_rnd->step(1);
        vibe_rnd->textcolor(7);
        vibe_rnd->callback((Fl_Callback*)cb_vibe_rnd);
        vibe_rnd->align(FL_ALIGN_LEFT);
        vibe_rnd->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_rnd
      { Fl_Choice* o = vibe_lfotype = new Fl_Choice(383, 310, 72, 16, "LFO Type");
        vibe_lfotype->down_box(FL_BORDER_BOX);
        vibe_lfotype->selection_color(FL_FOREGROUND_COLOR);
        vibe_lfotype->labelsize(10);
        vibe_lfotype->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_lfotype->textsize(10);
        vibe_lfotype->textcolor(7);
        vibe_lfotype->callback((Fl_Callback*)cb_vibe_lfotype);
        o->menu(menu_chorus_lfotype);
      } // Fl_Choice* vibe_lfotype
      { vibe_stdf = new SliderW(372, 330, 100, 10, "St.df");
        vibe_stdf->type(5);
        vibe_stdf->box(FL_FLAT_BOX);
        vibe_stdf->color((Fl_Color)178);
        vibe_stdf->selection_color((Fl_Color)62);
        vibe_stdf->labeltype(FL_NORMAL_LABEL);
        vibe_stdf->labelfont(0);
        vibe_stdf->labelsize(10);
        vibe_stdf->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_stdf->maximum(127);
        vibe_stdf->step(1);
        vibe_stdf->textcolor(7);
        vibe_stdf->callback((Fl_Callback*)cb_vibe_stdf);
        vibe_stdf->align(FL_ALIGN_LEFT);
        vibe_stdf->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_stdf
      { vibe_fb = new SliderW(372, 344, 100, 10, "Fb");
        vibe_fb->type(5);
        vibe_fb->box(FL_FLAT_BOX);
        vibe_fb->color((Fl_Color)178);
        vibe_fb->selection_color((Fl_Color)62);
        vibe_fb->labeltype(FL_NORMAL_LABEL);
        vibe_fb->labelfont(0);
        vibe_fb->labelsize(10);
        vibe_fb->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_fb->minimum(-64);
        vibe_fb->maximum(64);
        vibe_fb->step(1);
        vibe_fb->textcolor(7);
        vibe_fb->callback((Fl_Callback*)cb_vibe_fb);
        vibe_fb->align(FL_ALIGN_LEFT);
        vibe_fb->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_fb
      { vibe_LR = new SliderW(372, 358, 100, 10, "L/R.Cr");
        vibe_LR->type(5);
        vibe_LR->box(FL_FLAT_BOX);
        vibe_LR->color((Fl_Color)178);
        vibe_LR->selection_color((Fl_Color)62);
        vibe_LR->labeltype(FL_NORMAL_LABEL);
        vibe_LR->labelfont(0);
        vibe_LR->labelsize(10);
        vibe_LR->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_LR->minimum(-64);
        vibe_LR->maximum(64);
        vibe_LR->step(1);
        vibe_LR->textcolor(7);
        vibe_LR->callback((Fl_Callback*)cb_vibe_LR);
        vibe_LR->align(FL_ALIGN_LEFT);
        vibe_LR->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_LR
      { vibe_pan = new SliderW(372, 372, 100, 10, "Pan");
        vibe_pan->type(5);
        vibe_pan->box(FL_FLAT_BOX);
        vibe_pan->color((Fl_Color)178);
        vibe_pan->selection_color((Fl_Color)62);
        vibe_pan->labeltype(FL_NORMAL_LABEL);
        vibe_pan->labelfont(0);
        vibe_pan->labelsize(10);
        vibe_pan->labelcolor(FL_BACKGROUND2_COLOR);
        vibe_pan->minimum(-64);
        vibe_pan->maximum(64);
        vibe_pan->step(1);
        vibe_pan->textcolor(7);
        vibe_pan->callback((Fl_Callback*)cb_vibe_pan);
        vibe_pan->align(FL_ALIGN_LEFT);
        vibe_pan->when(FL_WHEN_CHANGED);
      } // SliderW* vibe_pan
      VIBE->end();
    } // Fl_Group* VIBE
    { Tuner = new Fl_Group(520, 24, 276, 58);
      Tuner->box(FL_UP_BOX);
      Tuner->color(FL_FOREGROUND_COLOR);
      Tuner->selection_color(FL_FOREGROUND_COLOR);
      Tuner->user_data((void*)(1));
      Tuner->align(96|FL_ALIGN_INSIDE);
      { tuner_activar = new Fl_Light_Button(526, 28, 38, 18, "On");
        tuner_activar->shortcut(0x74);
        tuner_activar->color((Fl_Color)62);
        tuner_activar->selection_color((Fl_Color)1);
        tuner_activar->labelsize(10);
        tuner_activar->callback((Fl_Callback*)cb_tuner_activar, (void*)(2));
        tuner_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* tuner_activar
      { TunerLed* o = tuner_bar = new TunerLed(586, 31, 206, 14);
        tuner_bar->box(FL_THIN_DOWN_BOX);
        tuner_bar->color(FL_DARK1);
        tuner_bar->selection_color(FL_RED);
        tuner_bar->labeltype(FL_NORMAL_LABEL);
        tuner_bar->labelfont(0);
        tuner_bar->labelsize(14);
        tuner_bar->labelcolor(FL_FOREGROUND_COLOR);
        tuner_bar->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        tuner_bar->when(FL_WHEN_RELEASE);
        o->minimum(-32);
        o->maximum(32);
        o->value(-32);
      } // TunerLed* tuner_bar
      { WNote = new Fl_Box(676, 57, 28, 22);
        WNote->labelfont(1);
        WNote->labelcolor(FL_BACKGROUND2_COLOR);
        WNote->user_data((void*)(7));
        WNote->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* WNote
      { WRfreq = new Fl_Box(588, 57, 76, 22);
        WRfreq->labelfont(1);
        WRfreq->labelcolor(FL_BACKGROUND2_COLOR);
        WRfreq->user_data((void*)(7));
        WRfreq->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* WRfreq
      { WNfreq = new Fl_Box(714, 57, 76, 22);
        WNfreq->labelfont(1);
        WNfreq->labelcolor(FL_BACKGROUND2_COLOR);
        WNfreq->user_data((void*)(7));
        WNfreq->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* WNfreq
      { PINCHO = new Fl_Box(673, 48, 32, 5, "@-4$8<");
        PINCHO->box(FL_FLAT_BOX);
        PINCHO->color((Fl_Color)55);
        PINCHO->labelcolor((Fl_Color)4);
        PINCHO->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* PINCHO
      { TUNER_LABEL = new Fl_Box(524, 63, 57, 14, "Tuner");
        TUNER_LABEL->labelfont(1);
        TUNER_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
        TUNER_LABEL->user_data((void*)(7));
      } // Fl_Box* TUNER_LABEL
      Tuner->end();
    } // Fl_Group* Tuner
    { InOut = new Fl_Group(2, 24, 164, 170);
      InOut->box(FL_UP_BOX);
      InOut->color(FL_FOREGROUND_COLOR);
      InOut->selection_color(FL_FOREGROUND_COLOR);
      InOut->user_data((void*)(1));
      InOut->align(96|FL_ALIGN_INSIDE);
      { ActivarGeneral = new Fl_Light_Button(6, 30, 52, 18, "FX On");
        ActivarGeneral->down_box(FL_BORDER_BOX);
        ActivarGeneral->shortcut(0x72);
        ActivarGeneral->color((Fl_Color)62);
        ActivarGeneral->selection_color((Fl_Color)1);
        ActivarGeneral->labelsize(10);
        ActivarGeneral->callback((Fl_Callback*)cb_ActivarGeneral, (void*)(2));
        ActivarGeneral->align(68|FL_ALIGN_INSIDE);
        ActivarGeneral->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* ActivarGeneral
      { BostBut = new Fl_Button(132, 30, 30, 14, "+10dB");
        BostBut->type(1);
        BostBut->shortcut(0xffc7);
        BostBut->color((Fl_Color)62);
        BostBut->labelsize(6);
        BostBut->callback((Fl_Callback*)cb_BostBut, (void*)(78));
      } // Fl_Button* BostBut
      { Balance = new SliderW(15, 48, 19, 126, "FX%");
        Balance->type(4);
        Balance->box(FL_FLAT_BOX);
        Balance->color(FL_FOREGROUND_COLOR);
        Balance->selection_color(FL_FOREGROUND_COLOR);
        Balance->labeltype(FL_NORMAL_LABEL);
        Balance->labelfont(0);
        Balance->labelsize(10);
        Balance->labelcolor((Fl_Color)31);
        Balance->minimum(100);
        Balance->maximum(0);
        Balance->step(1);
        Balance->value(100);
        Balance->textcolor(7);
        Balance->callback((Fl_Callback*)cb_Balance);
        Balance->align(FL_ALIGN_BOTTOM);
        Balance->when(FL_WHEN_CHANGED);
      } // SliderW* Balance
      { Nivel_Entrada = new SliderW(57, 48, 19, 126, "Input");
        Nivel_Entrada->type(4);
        Nivel_Entrada->box(FL_FLAT_BOX);
        Nivel_Entrada->color(FL_FOREGROUND_COLOR);
        Nivel_Entrada->selection_color(FL_FOREGROUND_COLOR);
        Nivel_Entrada->labeltype(FL_NORMAL_LABEL);
        Nivel_Entrada->labelfont(0);
        Nivel_Entrada->labelsize(10);
        Nivel_Entrada->labelcolor((Fl_Color)31);
        Nivel_Entrada->minimum(50);
        Nivel_Entrada->maximum(-50);
        Nivel_Entrada->step(1);
        Nivel_Entrada->textcolor(7);
        Nivel_Entrada->callback((Fl_Callback*)cb_Nivel_Entrada);
        Nivel_Entrada->align(FL_ALIGN_BOTTOM);
        Nivel_Entrada->when(FL_WHEN_CHANGED);
      } // SliderW* Nivel_Entrada
      { Nivel_Salida = new SliderW(115, 48, 19, 126, "Output");
        Nivel_Salida->type(4);
        Nivel_Salida->box(FL_FLAT_BOX);
        Nivel_Salida->color(FL_FOREGROUND_COLOR);
        Nivel_Salida->selection_color(FL_FOREGROUND_COLOR);
        Nivel_Salida->labeltype(FL_NORMAL_LABEL);
        Nivel_Salida->labelfont(0);
        Nivel_Salida->labelsize(10);
        Nivel_Salida->labelcolor((Fl_Color)31);
        Nivel_Salida->minimum(50);
        Nivel_Salida->maximum(-50);
        Nivel_Salida->step(1);
        Nivel_Salida->textcolor(7);
        Nivel_Salida->callback((Fl_Callback*)cb_Nivel_Salida);
        Nivel_Salida->align(FL_ALIGN_BOTTOM);
        Nivel_Salida->when(FL_WHEN_CHANGED);
      } // SliderW* Nivel_Salida
      { input_vul = new NewVum(84, 50, 8, 122);
        input_vul->type(2);
        input_vul->box(FL_NO_BOX);
        input_vul->color((Fl_Color)178);
        input_vul->selection_color((Fl_Color)90);
        input_vul->labeltype(FL_NORMAL_LABEL);
        input_vul->labelfont(0);
        input_vul->labelsize(14);
        input_vul->labelcolor(FL_FOREGROUND_COLOR);
        input_vul->minimum(15);
        input_vul->maximum(-48);
        input_vul->step(1);
        input_vul->value(-48);
        input_vul->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        input_vul->when(FL_WHEN_NEVER);
      } // NewVum* input_vul
      { input_vur = new NewVum(93, 50, 8, 122);
        input_vur->type(2);
        input_vur->box(FL_NO_BOX);
        input_vur->color((Fl_Color)178);
        input_vur->selection_color((Fl_Color)90);
        input_vur->labeltype(FL_NORMAL_LABEL);
        input_vur->labelfont(0);
        input_vur->labelsize(14);
        input_vur->labelcolor(FL_FOREGROUND_COLOR);
        input_vur->minimum(15);
        input_vur->maximum(-48);
        input_vur->step(1);
        input_vur->value(-48);
        input_vur->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        input_vur->when(FL_WHEN_NEVER);
      } // NewVum* input_vur
      { output_vul = new NewVum(142, 50, 8, 122);
        output_vul->type(2);
        output_vul->box(FL_NO_BOX);
        output_vul->color((Fl_Color)178);
        output_vul->selection_color((Fl_Color)90);
        output_vul->labeltype(FL_NORMAL_LABEL);
        output_vul->labelfont(0);
        output_vul->labelsize(14);
        output_vul->labelcolor(FL_FOREGROUND_COLOR);
        output_vul->minimum(15);
        output_vul->maximum(-48);
        output_vul->step(1);
        output_vul->value(-48);
        output_vul->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        output_vul->when(FL_WHEN_NEVER);
      } // NewVum* output_vul
      { output_vur = new NewVum(151, 50, 8, 122);
        output_vur->type(2);
        output_vur->box(FL_NO_BOX);
        output_vur->color((Fl_Color)178);
        output_vur->selection_color((Fl_Color)90);
        output_vur->labeltype(FL_NORMAL_LABEL);
        output_vur->labelfont(0);
        output_vur->labelsize(14);
        output_vur->labelcolor(FL_FOREGROUND_COLOR);
        output_vur->minimum(15);
        output_vur->maximum(-48);
        output_vur->step(1);
        output_vur->value(-48);
        output_vur->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        output_vur->when(FL_WHEN_NEVER);
      } // NewVum* output_vur
      { LABEL_IO = new Fl_Box(60, 30, 62, 14, "In/Out");
        LABEL_IO->labelfont(1);
        LABEL_IO->labelcolor(FL_BACKGROUND2_COLOR);
        LABEL_IO->user_data((void*)(7));
        LABEL_IO->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      } // Fl_Box* LABEL_IO
      InOut->end();
    } // Fl_Group* InOut
    { Midi = new Fl_Group(520, 85, 276, 52);
      Midi->box(FL_UP_BOX);
      Midi->color(FL_FOREGROUND_COLOR);
      Midi->selection_color(FL_FOREGROUND_COLOR);
      Midi->user_data((void*)(1));
      Midi->align(96|FL_ALIGN_INSIDE);
      { nidi_activar = new Fl_Light_Button(525, 89, 38, 18, "On");
        nidi_activar->shortcut(0x6d);
        nidi_activar->color((Fl_Color)62);
        nidi_activar->selection_color((Fl_Color)1);
        nidi_activar->labelsize(10);
        nidi_activar->callback((Fl_Callback*)cb_nidi_activar, (void*)(2));
        nidi_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* nidi_activar
      { MIDIOctave = new Fl_Choice(624, 118, 37, 16, "Octave");
        MIDIOctave->down_box(FL_BORDER_BOX);
        MIDIOctave->selection_color(FL_FOREGROUND_COLOR);
        MIDIOctave->labelsize(8);
        MIDIOctave->labelcolor(FL_BACKGROUND2_COLOR);
        MIDIOctave->textsize(10);
        MIDIOctave->textcolor(7);
        MIDIOctave->callback((Fl_Callback*)cb_MIDIOctave, (void*)(12));
        MIDIOctave->menu(menu_MIDIOctave);
      } // Fl_Choice* MIDIOctave
      { Midi_out_Counter = new Fl_Counter(601, 89, 60, 17, "Channel");
        Midi_out_Counter->type(1);
        Midi_out_Counter->color((Fl_Color)62);
        Midi_out_Counter->labelsize(9);
        Midi_out_Counter->labelcolor(FL_BACKGROUND2_COLOR);
        Midi_out_Counter->minimum(1);
        Midi_out_Counter->maximum(16);
        Midi_out_Counter->step(1);
        Midi_out_Counter->value(1);
        Midi_out_Counter->textsize(11);
        Midi_out_Counter->callback((Fl_Callback*)cb_Midi_out_Counter);
      } // Fl_Counter* Midi_out_Counter
      { Trig_Adj = new SliderW(667, 100, 117, 11, "Trigger");
        Trig_Adj->type(5);
        Trig_Adj->box(FL_FLAT_BOX);
        Trig_Adj->color((Fl_Color)178);
        Trig_Adj->selection_color((Fl_Color)62);
        Trig_Adj->labeltype(FL_NORMAL_LABEL);
        Trig_Adj->labelfont(0);
        Trig_Adj->labelsize(8);
        Trig_Adj->labelcolor(FL_BACKGROUND2_COLOR);
        Trig_Adj->minimum(2);
        Trig_Adj->maximum(60);
        Trig_Adj->step(1);
        Trig_Adj->textcolor(7);
        Trig_Adj->callback((Fl_Callback*)cb_Trig_Adj);
        Trig_Adj->align(FL_ALIGN_TOP_RIGHT);
        Trig_Adj->when(FL_WHEN_CHANGED);
      } // SliderW* Trig_Adj
      { Vel_Adj = new SliderW(667, 119, 117, 11, "Velocity");
        Vel_Adj->type(5);
        Vel_Adj->box(FL_FLAT_BOX);
        Vel_Adj->color((Fl_Color)178);
        Vel_Adj->selection_color((Fl_Color)62);
        Vel_Adj->labeltype(FL_NORMAL_LABEL);
        Vel_Adj->labelfont(0);
        Vel_Adj->labelsize(8);
        Vel_Adj->labelcolor(FL_BACKGROUND2_COLOR);
        Vel_Adj->minimum(1);
        Vel_Adj->maximum(100);
        Vel_Adj->step(1);
        Vel_Adj->textcolor(7);
        Vel_Adj->callback((Fl_Callback*)cb_Vel_Adj);
        Vel_Adj->align(FL_ALIGN_TOP_RIGHT);
        Vel_Adj->when(FL_WHEN_CHANGED);
      } // SliderW* Vel_Adj
      { Mled = new Fl_Box(571, 90, 10, 10);
        Mled->box(FL_ROUNDED_BOX);
        Mled->color(FL_RED);
        Mled->labelsize(18);
      } // Fl_Box* Mled
      { MIDI_LABEL = new Fl_Box(524, 117, 44, 14, "MIDI");
        MIDI_LABEL->labelfont(1);
        MIDI_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
        MIDI_LABEL->callback((Fl_Callback*)cb_MIDI_LABEL, (void*)(7));
        MIDI_LABEL->when(FL_WHEN_NEVER);
      } // Fl_Box* MIDI_LABEL
      Midi->end();
    } // Fl_Group* Midi
    { Metro = new Fl_Group(520, 85, 276, 52);
      Metro->box(FL_UP_BOX);
      Metro->color(FL_FOREGROUND_COLOR);
      Metro->selection_color(FL_FOREGROUND_COLOR);
      Metro->user_data((void*)(1));
      Metro->align(96|FL_ALIGN_INSIDE);
      { metro_activar = new Fl_Light_Button(525, 89, 38, 18, "On");
        metro_activar->shortcut(0x6d);
        metro_activar->color((Fl_Color)62);
        metro_activar->selection_color((Fl_Color)1);
        metro_activar->labelsize(10);
        metro_activar->callback((Fl_Callback*)cb_metro_activar, (void*)(2));
        metro_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* metro_activar
      { Fl_Choice* o = MetroBar = new Fl_Choice(624, 98, 37, 16, "Time Sig.");
        MetroBar->down_box(FL_BORDER_BOX);
        MetroBar->selection_color(FL_FOREGROUND_COLOR);
        MetroBar->labelsize(8);
        MetroBar->labelcolor(FL_BACKGROUND2_COLOR);
        MetroBar->textsize(10);
        MetroBar->textcolor(7);
        MetroBar->callback((Fl_Callback*)cb_MetroBar, (void*)(12));
        o->menu(menu_looper_bar);
      } // Fl_Choice* MetroBar
      { Metro_Volume = new SliderW(667, 100, 117, 11, "Volume");
        Metro_Volume->type(5);
        Metro_Volume->box(FL_FLAT_BOX);
        Metro_Volume->color((Fl_Color)178);
        Metro_Volume->selection_color((Fl_Color)62);
        Metro_Volume->labeltype(FL_NORMAL_LABEL);
        Metro_Volume->labelfont(0);
        Metro_Volume->labelsize(8);
        Metro_Volume->labelcolor(FL_BACKGROUND2_COLOR);
        Metro_Volume->maximum(100);
        Metro_Volume->step(1);
        Metro_Volume->value(50);
        Metro_Volume->textcolor(7);
        Metro_Volume->callback((Fl_Callback*)cb_Metro_Volume);
        Metro_Volume->align(FL_ALIGN_TOP_RIGHT);
        Metro_Volume->when(FL_WHEN_CHANGED);
      } // SliderW* Metro_Volume
      { Fl_Choice* o = MetroSound = new Fl_Choice(634, 118, 28, 16, "S");
        MetroSound->down_box(FL_BORDER_BOX);
        MetroSound->selection_color(FL_FOREGROUND_COLOR);
        MetroSound->labelsize(8);
        MetroSound->labelcolor(FL_BACKGROUND2_COLOR);
        MetroSound->textsize(10);
        MetroSound->textcolor(7);
        MetroSound->callback((Fl_Callback*)cb_MetroSound, (void*)(12));
        o->menu(menu_looper_ms);
      } // Fl_Choice* MetroSound
      { Metro_Tempo = new SliderW(667, 119, 117, 11, "Tempo");
        Metro_Tempo->type(5);
        Metro_Tempo->box(FL_FLAT_BOX);
        Metro_Tempo->color((Fl_Color)178);
        Metro_Tempo->selection_color((Fl_Color)62);
        Metro_Tempo->labeltype(FL_NORMAL_LABEL);
        Metro_Tempo->labelfont(0);
        Metro_Tempo->labelsize(8);
        Metro_Tempo->labelcolor(FL_BACKGROUND2_COLOR);
        Metro_Tempo->minimum(20);
        Metro_Tempo->maximum(340);
        Metro_Tempo->step(1);
        Metro_Tempo->value(100);
        Metro_Tempo->textcolor(7);
        Metro_Tempo->callback((Fl_Callback*)cb_Metro_Tempo);
        Metro_Tempo->align(FL_ALIGN_TOP_RIGHT);
        Metro_Tempo->when(FL_WHEN_CHANGED);
      } // SliderW* Metro_Tempo
      { Metro_Led = new Fl_Box(568, 90, 10, 10);
        Metro_Led->box(FL_ROUNDED_BOX);
        Metro_Led->color(FL_RED);
        Metro_Led->labelsize(18);
      } // Fl_Box* Metro_Led
      { Metro_Label = new Fl_Box(522, 117, 92, 14, "Metronome");
        Metro_Label->labelfont(1);
        Metro_Label->labelcolor(FL_BACKGROUND2_COLOR);
        Metro_Label->user_data((void*)(7));
        Metro_Label->when(FL_WHEN_NEVER);
      } // Fl_Box* Metro_Label
      Metro->end();
    } // Fl_Group* Metro
    { Presets = new Fl_Group(168, 24, 352, 170);
      Presets->box(FL_UP_BOX);
      Presets->color(FL_FOREGROUND_COLOR);
      Presets->selection_color(FL_FOREGROUND_COLOR);
      Presets->user_data((void*)(1));
      Presets->align(96|FL_ALIGN_INSIDE);
      { PRESETS_LABEL = new Fl_Box(174, 28, 62, 14, "Presets");
        PRESETS_LABEL->labelfont(1);
        PRESETS_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
        PRESETS_LABEL->user_data((void*)(7));
      } // Fl_Box* PRESETS_LABEL
      { L_B1 = new Fl_Button(418, 30, 22, 16, "1");
        L_B1->color((Fl_Color)62);
        L_B1->labelsize(10);
        L_B1->callback((Fl_Callback*)cb_L_B1, (void*)(77));
      } // Fl_Button* L_B1
      { L_B2 = new Fl_Button(442, 30, 22, 16, "2");
        L_B2->color((Fl_Color)62);
        L_B2->labelsize(10);
        L_B2->callback((Fl_Callback*)cb_L_B2, (void*)(77));
      } // Fl_Button* L_B2
      { L_B3 = new Fl_Button(466, 30, 22, 16, "3");
        L_B3->color((Fl_Color)62);
        L_B3->labelsize(10);
        L_B3->callback((Fl_Callback*)cb_L_B3, (void*)(77));
      } // Fl_Button* L_B3
      { L_B4 = new Fl_Button(490, 30, 22, 16, "U");
        L_B4->color((Fl_Color)62);
        L_B4->labelsize(10);
        L_B4->callback((Fl_Callback*)cb_L_B4, (void*)(77));
      } // Fl_Button* L_B4
      { S_new = new Fl_Button(174, 50, 64, 18, "New");
        S_new->shortcut(0x6e);
        S_new->color((Fl_Color)62);
        S_new->labelsize(12);
        S_new->callback((Fl_Callback*)cb_S_new, (void*)(77));
      } // Fl_Button* S_new
      { L_preset = new Fl_Button(240, 50, 64, 18, "Load");
        L_preset->shortcut(0x6c);
        L_preset->color((Fl_Color)62);
        L_preset->labelsize(12);
        L_preset->callback((Fl_Callback*)cb_L_preset, (void*)(77));
      } // Fl_Button* L_preset
      { S_preset = new Fl_Button(306, 50, 64, 18, "Save");
        S_preset->shortcut(0x73);
        S_preset->color((Fl_Color)62);
        S_preset->labelsize(12);
        S_preset->callback((Fl_Callback*)cb_S_preset, (void*)(77));
      } // Fl_Button* S_preset
      { Compare = new Fl_Light_Button(373, 50, 72, 18, "Compare");
        Compare->shortcut(0x70);
        Compare->color((Fl_Color)62);
        Compare->selection_color((Fl_Color)1);
        Compare->labelsize(12);
        Compare->callback((Fl_Callback*)cb_Compare, (void*)(7));
        Compare->align(68|FL_ALIGN_INSIDE);
        Compare->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* Compare
      { B_preset = new Fl_Button(448, 50, 64, 18, "Bank");
        B_preset->shortcut(0x62);
        B_preset->color((Fl_Color)62);
        B_preset->labelsize(12);
        B_preset->callback((Fl_Callback*)cb_B_preset, (void*)(77));
      } // Fl_Button* B_preset
      { Fl_Input* o = WPreset_Name = new Fl_Input(174, 72, 338, 30);
        WPreset_Name->color((Fl_Color)62);
        WPreset_Name->labelcolor(FL_BACKGROUND2_COLOR);
        WPreset_Name->textsize(24);
        WPreset_Name->textcolor(7);
        WPreset_Name->callback((Fl_Callback*)cb_WPreset_Name);
        WPreset_Name->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
        o->maximum_size(22);
      } // Fl_Input* WPreset_Name
      { Preset_Counter = new Fl_Counter(174, 106, 60, 20, "Preset");
        Preset_Counter->type(1);
        Preset_Counter->color((Fl_Color)62);
        Preset_Counter->selection_color(FL_FOREGROUND_COLOR);
        Preset_Counter->labelsize(11);
        Preset_Counter->labelcolor(FL_BACKGROUND2_COLOR);
        Preset_Counter->minimum(1);
        Preset_Counter->maximum(60);
        Preset_Counter->step(1);
        Preset_Counter->value(1);
        Preset_Counter->textsize(11);
        Preset_Counter->callback((Fl_Callback*)cb_Preset_Counter);
      } // Fl_Counter* Preset_Counter
      { DAuthor = new Fl_Box(246, 107, 266, 18);
        DAuthor->box(FL_DOWN_BOX);
        DAuthor->color((Fl_Color)62);
        DAuthor->user_data((void*)(7));
        DAuthor->align(100|FL_ALIGN_INSIDE);
      } // Fl_Box* DAuthor
      { RandomP = new Fl_Button(175, 141, 59, 14, "Random");
        RandomP->shortcut(0xffc6);
        RandomP->color((Fl_Color)62);
        RandomP->labelsize(10);
        RandomP->callback((Fl_Callback*)cb_RandomP, (void*)(77));
        RandomP->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        RandomP->when(FL_WHEN_RELEASE_ALWAYS);
      } // Fl_Button* RandomP
      { Open_Order = new Fl_Button(247, 132, 195, 24, "Put Order in your Rack");
        Open_Order->shortcut(0x6f);
        Open_Order->color((Fl_Color)62);
        Open_Order->callback((Fl_Callback*)cb_Open_Order, (void*)(77));
        Open_Order->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        Open_Order->when(FL_WHEN_RELEASE_ALWAYS);
      } // Fl_Button* Open_Order
      { Etit = new Fl_Button(174, 160, 340, 28);
        Etit->type(1);
        Etit->box(FL_NO_BOX);
        Etit->labeltype(FL_EMBOSSED_LABEL);
        Etit->labelfont(1);
        Etit->labelsize(21);
        Etit->callback((Fl_Callback*)cb_Etit);
        Etit->align(FL_ALIGN_TOP|FL_ALIGN_INSIDE);
      } // Fl_Button* Etit
      { Analy = new Analyzer(174, 160, 340, 28);
        Analy->box(FL_NO_BOX);
        Analy->color(FL_BACKGROUND_COLOR);
        Analy->selection_color(FL_BACKGROUND_COLOR);
        Analy->labeltype(FL_EMBOSSED_LABEL);
        Analy->labelfont(1);
        Analy->labelsize(22);
        Analy->labelcolor(FL_FOREGROUND_COLOR);
        Analy->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        Analy->when(FL_WHEN_RELEASE);
        Analy->hide();
      } // Analyzer* Analy
      { HideUE = new Fl_Button(445, 137, 32, 18, "Hide");
        HideUE->shortcut(0xffc6);
        HideUE->color((Fl_Color)62);
        HideUE->labelsize(10);
        HideUE->callback((Fl_Callback*)cb_HideUE, (void*)(77));
        HideUE->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        HideUE->when(FL_WHEN_RELEASE_ALWAYS);
      } // Fl_Button* HideUE
      { SwitchMod = new Fl_Button(480, 137, 32, 18, "Sw");
        SwitchMod->shortcut(0xffc6);
        SwitchMod->color((Fl_Color)62);
        SwitchMod->labelsize(10);
        SwitchMod->callback((Fl_Callback*)cb_SwitchMod, (void*)(77));
        SwitchMod->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
        SwitchMod->when(FL_WHEN_RELEASE_ALWAYS);
      } // Fl_Button* SwitchMod
      Presets->end();
    } // Fl_Group* Presets
    { Tap = new Fl_Group(520, 140, 276, 54);
      Tap->box(FL_UP_BOX);
      Tap->color(FL_FOREGROUND_COLOR);
      Tap->selection_color(FL_FOREGROUND_COLOR);
      Tap->user_data((void*)(1));
      Tap->align(96|FL_ALIGN_INSIDE);
      { Tap_activar = new Fl_Light_Button(525, 144, 38, 18, "On");
        Tap_activar->shortcut(0x6d);
        Tap_activar->color((Fl_Color)62);
        Tap_activar->selection_color((Fl_Color)1);
        Tap_activar->labelsize(10);
        Tap_activar->callback((Fl_Callback*)cb_Tap_activar, (void*)(2));
        Tap_activar->when(FL_WHEN_CHANGED);
      } // Fl_Light_Button* Tap_activar
      { T_SEL = new Fl_Choice(600, 145, 87, 15, "Input");
        T_SEL->down_box(FL_BORDER_BOX);
        T_SEL->labelsize(10);
        T_SEL->labelcolor(FL_BACKGROUND2_COLOR);
        T_SEL->textsize(10);
        T_SEL->textcolor(7);
        T_SEL->callback((Fl_Callback*)cb_T_SEL, (void*)(12));
        T_SEL->menu(menu_T_SEL);
      } // Fl_Choice* T_SEL
      { T_SET = new Fl_Choice(714, 145, 76, 15, "Set");
        T_SET->down_box(FL_BORDER_BOX);
        T_SET->labelsize(10);
        T_SET->labelcolor(FL_BACKGROUND2_COLOR);
        T_SET->textsize(10);
        T_SET->textcolor(7);
        T_SET->callback((Fl_Callback*)cb_T_SET, (void*)(12));
        T_SET->menu(menu_T_SET);
      } // Fl_Choice* T_SET
      { T_Apply = new Fl_Button(628, 172, 38, 15, "Apply");
        T_Apply->shortcut(0x67);
        T_Apply->labelsize(10);
        T_Apply->callback((Fl_Callback*)cb_T_Apply, (void*)(77));
      } // Fl_Button* T_Apply
      { T_BUT = new Fl_Button(671, 165, 38, 23, "Tap");
        T_BUT->shortcut(0x67);
        T_BUT->labelsize(12);
        T_BUT->callback((Fl_Callback*)cb_T_BUT, (void*)(77));
      } // Fl_Button* T_BUT
      { TAP_LABEL = new Fl_Box(524, 170, 93, 14, "Tap Tempo");
        TAP_LABEL->labelfont(1);
        TAP_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
        TAP_LABEL->user_data((void*)(7));
        TAP_LABEL->when(FL_WHEN_NEVER);
      } // Fl_Box* TAP_LABEL
      { T_DIS = new Fl_Value_Input(719, 165, 70, 22);
        T_DIS->minimum(20);
        T_DIS->maximum(360);
        T_DIS->step(1);
        T_DIS->value(100);
        T_DIS->textcolor(7);
        T_DIS->callback((Fl_Callback*)cb_T_DIS);
        T_DIS->align(FL_ALIGN_CENTER);
      } // Fl_Value_Input* T_DIS
      Tap->end();
    } // Fl_Group* Tap
    Principal->size_range(320, 240, 3200, 2400);
    Principal->end();
    Principal->resizable(Principal);
  } // Fl_Double_Window* Principal
  { BankWindow = new Fl_Double_Window(800, 600);
    BankWindow->color((Fl_Color)4);
    BankWindow->selection_color(FL_BACKGROUND2_COLOR);
    BankWindow->callback((Fl_Callback*)cb_BankWindow, (void*)(this));
    { Fondo3 = new Fl_Box(1, 1, 800, 600);
    } // Fl_Box* Fondo3
    { MenuB = new Fl_Menu_Bar(0, 0, 253, 20);
      MenuB->box(FL_NO_BOX);
      MenuB->color((Fl_Color)55);
      MenuB->selection_color(FL_BACKGROUND2_COLOR);
      MenuB->labelcolor(FL_BACKGROUND2_COLOR);
      MenuB->textcolor(7);
      MenuB->align(96|FL_ALIGN_INSIDE);
      MenuB->menu(menu_MenuB);
    } // Fl_Menu_Bar* MenuB
    { B_B1 = new Fl_Button(258, 14, 32, 24, "1");
      B_B1->color((Fl_Color)62);
      B_B1->labelsize(10);
      B_B1->callback((Fl_Callback*)cb_B_B1, (void*)(77));
    } // Fl_Button* B_B1
    { B_B2 = new Fl_Button(298, 14, 32, 24, "2");
      B_B2->color((Fl_Color)62);
      B_B2->labelsize(10);
      B_B2->callback((Fl_Callback*)cb_B_B2, (void*)(77));
    } // Fl_Button* B_B2
    { B_B3 = new Fl_Button(338, 14, 32, 24, "3");
      B_B3->color((Fl_Color)62);
      B_B3->labelsize(10);
      B_B3->callback((Fl_Callback*)cb_B_B3, (void*)(77));
    } // Fl_Button* B_B3
    { B_B4 = new Fl_Button(378, 14, 32, 24, "U");
      B_B4->color((Fl_Color)62);
      B_B4->labelsize(10);
      B_B4->callback((Fl_Callback*)cb_B_B4, (void*)(77));
    } // Fl_Button* B_B4
    { CH_UB = new Fl_Choice(549, 14, 117, 24, "User Banks       ");
      CH_UB->down_box(FL_BORDER_BOX);
      CH_UB->selection_color(FL_BACKGROUND2_COLOR);
      CH_UB->labelcolor(FL_BACKGROUND2_COLOR);
      CH_UB->textcolor(7);
      CH_UB->callback((Fl_Callback*)cb_CH_UB);
      CH_UB->when(FL_WHEN_RELEASE_ALWAYS);
    } // Fl_Choice* CH_UB
    { ob = new Fl_Group(0, 60, 800, 540);
      ob->labelsize(18);
      ob->end();
    } // Fl_Group* ob
    BankWindow->size_range(640, 480, 3200, 2400);
    BankWindow->end();
    BankWindow->resizable(BankWindow);
  } // Fl_Double_Window* BankWindow
  { Order = new Fl_Double_Window(500, 400);
    Order->color((Fl_Color)178);
    Order->callback((Fl_Callback*)cb_Order, (void*)(this));
    { Fondo1 = new Fl_Box(1, 1, 600, 400);
    } // Fl_Box* Fondo1
    { O_TITLE = new Fl_Box(25, 3, 438, 37, "Put Order in your Rack");
      O_TITLE->labelfont(1);
      O_TITLE->labelsize(33);
      O_TITLE->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* O_TITLE
    { Avail_Bro = new Fl_Browser(15, 50, 175, 225);
      Avail_Bro->type(2);
      Avail_Bro->labelsize(18);
      Avail_Bro->textsize(18);
      Avail_Bro->textcolor(7);
      Avail_Bro->user_data((void*)(99));
    } // Fl_Browser* Avail_Bro
    { Pon = new Fl_Button(200, 145, 50, 25, "@<->");
      Pon->labelsize(18);
      Pon->callback((Fl_Callback*)cb_Pon);
    } // Fl_Button* Pon
    { Order_Bro = new Fl_Browser(260, 50, 175, 225);
      Order_Bro->type(2);
      Order_Bro->labelsize(18);
      Order_Bro->textsize(18);
      Order_Bro->textcolor(7);
    } // Fl_Browser* Order_Bro
    { Sube = new Fl_Button(442, 120, 50, 25, "@$2->");
      Sube->labelsize(18);
      Sube->callback((Fl_Callback*)cb_Sube);
    } // Fl_Button* Sube
    { Baja = new Fl_Button(442, 160, 50, 25, "@$8->");
      Baja->labelsize(18);
      Baja->callback((Fl_Callback*)cb_Baja);
    } // Fl_Button* Baja
    { Filters = new Fl_Group(15, 280, 180, 110);
      { Fil0 = new Fl_Button(15, 284, 177, 15, "All");
        Fil0->type(102);
        Fil0->labelsize(10);
        Fil0->callback((Fl_Callback*)cb_Fil0);
        Fil0->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil0
      { Fil1 = new Fl_Button(105, 304, 86, 15, "Distortion");
        Fil1->type(102);
        Fil1->labelsize(10);
        Fil1->callback((Fl_Callback*)cb_Fil1);
        Fil1->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil1
      { Fil2 = new Fl_Button(15, 304, 78, 15, "Modulation");
        Fil2->type(102);
        Fil2->labelsize(10);
        Fil2->callback((Fl_Callback*)cb_Fil2);
        Fil2->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil2
      { Fil4 = new Fl_Button(105, 325, 86, 15, "Time");
        Fil4->type(102);
        Fil4->labelsize(10);
        Fil4->callback((Fl_Callback*)cb_Fil4);
        Fil4->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil4
      { Fil8 = new Fl_Button(15, 324, 78, 15, "Emulation");
        Fil8->type(102);
        Fil8->labelsize(10);
        Fil8->callback((Fl_Callback*)cb_Fil8);
        Fil8->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil8
      { Fil16 = new Fl_Button(105, 345, 86, 15, "Filters");
        Fil16->type(102);
        Fil16->labelsize(10);
        Fil16->callback((Fl_Callback*)cb_Fil16);
        Fil16->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil16
      { Fil32 = new Fl_Button(15, 344, 78, 15, "Dynamics");
        Fil32->type(102);
        Fil32->labelsize(10);
        Fil32->callback((Fl_Callback*)cb_Fil32);
        Fil32->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil32
      { Fil64 = new Fl_Button(105, 365, 86, 15, "Processing && EQ");
        Fil64->type(102);
        Fil64->labelsize(10);
        Fil64->callback((Fl_Callback*)cb_Fil64);
        Fil64->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil64
      { Fil128 = new Fl_Button(15, 365, 78, 15, "Synthesis");
        Fil128->type(102);
        Fil128->labelsize(10);
        Fil128->callback((Fl_Callback*)cb_Fil128);
        Fil128->when(FL_WHEN_CHANGED);
      } // Fl_Button* Fil128
      Filters->end();
    } // Fl_Group* Filters
    { Order_DeacHide = new Fl_Check_Button(420, 286, 23, 20, "Hide Unused Effect Widgets");
      Order_DeacHide->down_box(FL_DOWN_BOX);
      Order_DeacHide->labelsize(11);
      Order_DeacHide->labelcolor(FL_BACKGROUND2_COLOR);
      Order_DeacHide->callback((Fl_Callback*)cb_Order_DeacHide);
      Order_DeacHide->align(FL_ALIGN_LEFT);
    } // Fl_Check_Button* Order_DeacHide
    { ok_order = new Fl_Button(333, 349, 72, 26, "Ok");
      ok_order->callback((Fl_Callback*)cb_ok_order);
    } // Fl_Button* ok_order
    { Cancel_order = new Fl_Button(415, 349, 72, 26, "Cancel");
      Cancel_order->callback((Fl_Callback*)cb_Cancel_order);
    } // Fl_Button* Cancel_order
    Order->size_range(500, 400, 3200, 2400);
    Order->end();
    Order->resizable(Order);
  } // Fl_Double_Window* Order
  { Settings = new Fl_Double_Window(640, 528);
    Settings->color((Fl_Color)4);
    Settings->callback((Fl_Callback*)cb_Settings, (void*)(this));
    { Fondo2 = new Fl_Box(1, 1, 640, 528);
    } // Fl_Box* Fondo2
    { STabs = new Fl_Tabs(0, 0, 636, 535);
      STabs->user_data((void*)(1));
      { Look = new Fl_Group(5, 26, 630, 502, "Look");
        Look->box(FL_PLASTIC_DOWN_FRAME);
        Look->labelfont(1);
        Look->labelcolor(FL_BACKGROUND2_COLOR);
        Look->user_data((void*)(1));
        Look->align(FL_ALIGN_LEFT);
        { Fondo6 = new Fl_Box(5, 26, 630, 502);
        } // Fl_Box* Fondo6
        { scheme_ch = new Fl_Choice(60, 50, 88, 20, "Schema");
          scheme_ch->down_box(FL_BORDER_BOX);
          scheme_ch->labelsize(11);
          scheme_ch->labelcolor(FL_BACKGROUND2_COLOR);
          scheme_ch->textsize(12);
          scheme_ch->textcolor(7);
          scheme_ch->callback((Fl_Callback*)cb_scheme_ch);
          scheme_ch->menu(menu_scheme_ch);
        } // Fl_Choice* scheme_ch
        { Font_Bro = new Fl_Browser(20, 100, 400, 225, "Font");
          Font_Bro->type(1);
          Font_Bro->labelsize(11);
          Font_Bro->labelcolor(FL_BACKGROUND2_COLOR);
          Font_Bro->callback((Fl_Callback*)cb_Font_Bro);
          Font_Bro->align(FL_ALIGN_TOP);
          Font_Bro->when(FL_WHEN_CHANGED);
        } // Fl_Browser* Font_Bro
        { FSLabel = new Fl_Box(10, 333, 60, 17, "Font Size");
          FSLabel->labelsize(11);
          FSLabel->labelcolor(FL_BACKGROUND2_COLOR);
        } // Fl_Box* FSLabel
        { FSless = new Fl_Button(78, 330, 30, 20, "-");
          FSless->callback((Fl_Callback*)cb_FSless, (void*)(77));
        } // Fl_Button* FSless
        { FSplus = new Fl_Button(113, 330, 30, 20, "+");
          FSplus->callback((Fl_Callback*)cb_FSplus, (void*)(77));
        } // Fl_Button* FSplus
        { FSReset = new Fl_Button(148, 330, 57, 20, "Reset");
          FSReset->callback((Fl_Callback*)cb_FSReset, (void*)(77));
        } // Fl_Button* FSReset
        { CLLabel = new Fl_Box(10, 358, 40, 19, "Colors");
          CLLabel->labelsize(11);
          CLLabel->labelcolor(FL_BACKGROUND2_COLOR);
        } // Fl_Box* CLLabel
        { B_C = new Fl_Button(15, 380, 90, 25, "Buttons");
          B_C->callback((Fl_Callback*)cb_B_C, (void*)(77));
        } // Fl_Button* B_C
        { A_C = new Fl_Button(120, 380, 90, 25, "Labels");
          A_C->callback((Fl_Callback*)cb_A_C, (void*)(77));
        } // Fl_Button* A_C
        { L_C = new Fl_Button(225, 380, 90, 25, "Leds");
          L_C->callback((Fl_Callback*)cb_L_C, (void*)(77));
        } // Fl_Button* L_C
        { K_C = new Fl_Button(330, 380, 90, 25, "Background");
          K_C->callback((Fl_Callback*)cb_K_C, (void*)(77));
        } // Fl_Button* K_C
        { Enable_Back = new Fl_Check_Button(162, 409, 23, 20, "Enable Background Image");
          Enable_Back->down_box(FL_DOWN_BOX);
          Enable_Back->labelsize(11);
          Enable_Back->labelcolor(FL_BACKGROUND2_COLOR);
          Enable_Back->callback((Fl_Callback*)cb_Enable_Back);
          Enable_Back->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* Enable_Back
        { BackFiname = new Fl_File_Input(10, 445, 390, 30, "Background Image");
          BackFiname->labelsize(11);
          BackFiname->labelcolor(FL_BACKGROUND2_COLOR);
          BackFiname->textsize(12);
          BackFiname->textcolor(7);
          BackFiname->align(FL_ALIGN_TOP_LEFT);
        } // Fl_File_Input* BackFiname
        { BI_Browser = new Fl_Button(410, 455, 65, 20, "Browse");
          BI_Browser->callback((Fl_Callback*)cb_BI_Browser, (void*)(77));
        } // Fl_Button* BI_Browser
        { Enable_DeacHide = new Fl_Check_Button(169, 500, 23, 20, "Hide Unused Effect Widgets");
          Enable_DeacHide->down_box(FL_DOWN_BOX);
          Enable_DeacHide->labelsize(11);
          Enable_DeacHide->labelcolor(FL_BACKGROUND2_COLOR);
          Enable_DeacHide->callback((Fl_Callback*)cb_Enable_DeacHide);
          Enable_DeacHide->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* Enable_DeacHide
        Look->end();
      } // Fl_Group* Look
      { AUDIO_SET = new Fl_Group(0, 26, 635, 502, "Audio");
        AUDIO_SET->box(FL_PLASTIC_DOWN_FRAME);
        AUDIO_SET->labelfont(1);
        AUDIO_SET->labelcolor(FL_BACKGROUND2_COLOR);
        AUDIO_SET->user_data((void*)(1));
        AUDIO_SET->align(FL_ALIGN_LEFT);
        AUDIO_SET->hide();
        { Fondo7 = new Fl_Box(5, 26, 630, 502);
        } // Fl_Box* Fondo7
        { INSTATE = new Fl_Check_Button(96, 29, 23, 20, "FX On at start");
          INSTATE->down_box(FL_DOWN_BOX);
          INSTATE->labelsize(11);
          INSTATE->labelcolor(FL_BACKGROUND2_COLOR);
          INSTATE->callback((Fl_Callback*)cb_INSTATE);
          INSTATE->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* INSTATE
        { Filter_DC = new Fl_Check_Button(135, 53, 23, 20, "Filter Input DC Offset");
          Filter_DC->down_box(FL_DOWN_BOX);
          Filter_DC->labelsize(11);
          Filter_DC->labelcolor(FL_BACKGROUND2_COLOR);
          Filter_DC->callback((Fl_Callback*)cb_Filter_DC);
          Filter_DC->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* Filter_DC
        { Pre_Serve = new Fl_Check_Button(259, 77, 21, 20, "Preserve Gain/Master when Preset change");
          Pre_Serve->down_box(FL_DOWN_BOX);
          Pre_Serve->labelsize(11);
          Pre_Serve->labelcolor(FL_BACKGROUND2_COLOR);
          Pre_Serve->callback((Fl_Callback*)cb_Pre_Serve);
          Pre_Serve->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* Pre_Serve
        { Update_TAP = new Fl_Check_Button(239, 100, 21, 20, "Update TapTempo when Preset change");
          Update_TAP->down_box(FL_DOWN_BOX);
          Update_TAP->labelsize(11);
          Update_TAP->labelcolor(FL_BACKGROUND2_COLOR);
          Update_TAP->callback((Fl_Callback*)cb_Update_TAP);
          Update_TAP->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* Update_TAP
        { UPSAMPLE_C = new Fl_Check_Button(83, 124, 23, 20, "Upsampling");
          UPSAMPLE_C->down_box(FL_DOWN_BOX);
          UPSAMPLE_C->labelsize(11);
          UPSAMPLE_C->labelcolor(FL_BACKGROUND2_COLOR);
          UPSAMPLE_C->callback((Fl_Callback*)cb_UPSAMPLE_C);
          UPSAMPLE_C->align(FL_ALIGN_LEFT);
          UPSAMPLE_C->when(FL_WHEN_CHANGED);
        } // Fl_Check_Button* UPSAMPLE_C
        { Upr_Amo = new Fl_Choice(145, 126, 47, 18, "Amount");
          Upr_Amo->down_box(FL_BORDER_BOX);
          Upr_Amo->labelsize(10);
          Upr_Amo->labelcolor(FL_BACKGROUND2_COLOR);
          Upr_Amo->textsize(10);
          Upr_Amo->textcolor(7);
          Upr_Amo->callback((Fl_Callback*)cb_Upr_Amo);
          Upr_Amo->menu(menu_Upr_Amo);
        } // Fl_Choice* Upr_Amo
        { Upr_Qual = new Fl_Choice(217, 126, 72, 18, "Up");
          Upr_Qual->down_box(FL_BORDER_BOX);
          Upr_Qual->labelsize(10);
          Upr_Qual->labelcolor(FL_BACKGROUND2_COLOR);
          Upr_Qual->textsize(10);
          Upr_Qual->textcolor(7);
          Upr_Qual->callback((Fl_Callback*)cb_Upr_Qual);
          Upr_Qual->menu(menu_Upr_Qual);
        } // Fl_Choice* Upr_Qual
        { Fl_Choice* o = Downr_Qual = new Fl_Choice(329, 126, 73, 18, "Down");
          Downr_Qual->down_box(FL_BORDER_BOX);
          Downr_Qual->labelsize(10);
          Downr_Qual->labelcolor(FL_BACKGROUND2_COLOR);
          Downr_Qual->textsize(10);
          Downr_Qual->textcolor(7);
          Downr_Qual->callback((Fl_Callback*)cb_Downr_Qual);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Downr_Qual
        { L_SIZE = new Fl_Counter(133, 149, 47, 18, "Looper Size Seconds     ");
          L_SIZE->type(1);
          L_SIZE->labelsize(10);
          L_SIZE->labelcolor(FL_BACKGROUND2_COLOR);
          L_SIZE->minimum(0.5);
          L_SIZE->maximum(30);
          L_SIZE->step(0.5);
          L_SIZE->value(0.5);
          L_SIZE->textsize(10);
          L_SIZE->callback((Fl_Callback*)cb_L_SIZE);
          L_SIZE->align(FL_ALIGN_LEFT);
          L_SIZE->when(FL_WHEN_RELEASE);
        } // Fl_Counter* L_SIZE
        { LM_Volume = new Fl_Counter(338, 149, 47, 18, "Looper Metronome Volume  ");
          LM_Volume->type(1);
          LM_Volume->labelsize(10);
          LM_Volume->labelcolor(FL_BACKGROUND2_COLOR);
          LM_Volume->minimum(0);
          LM_Volume->maximum(100);
          LM_Volume->step(1);
          LM_Volume->value(50);
          LM_Volume->textsize(10);
          LM_Volume->callback((Fl_Callback*)cb_LM_Volume);
          LM_Volume->align(FL_ALIGN_LEFT);
          LM_Volume->when(FL_WHEN_RELEASE);
        } // Fl_Counter* LM_Volume
        { Har_Qual = new Fl_Choice(132, 173, 47, 18, "Harmonizer Quality      ");
          Har_Qual->down_box(FL_BORDER_BOX);
          Har_Qual->labelsize(10);
          Har_Qual->labelcolor(FL_BACKGROUND2_COLOR);
          Har_Qual->textsize(10);
          Har_Qual->textcolor(7);
          Har_Qual->callback((Fl_Callback*)cb_Har_Qual);
          Har_Qual->menu(menu_Har_Qual);
        } // Fl_Choice* Har_Qual
        { Ste_Qual = new Fl_Choice(296, 173, 47, 18, "StereoHarm Quality");
          Ste_Qual->down_box(FL_BORDER_BOX);
          Ste_Qual->labelsize(10);
          Ste_Qual->labelcolor(FL_BACKGROUND2_COLOR);
          Ste_Qual->textsize(10);
          Ste_Qual->textcolor(7);
          Ste_Qual->callback((Fl_Callback*)cb_Ste_Qual);
          Ste_Qual->menu(menu_Ste_Qual);
        } // Fl_Choice* Ste_Qual
        { Voc_Bands = new Fl_Choice(132, 196, 47, 18, "Vocoder Bands              ");
          Voc_Bands->down_box(FL_BORDER_BOX);
          Voc_Bands->labelsize(10);
          Voc_Bands->labelcolor(FL_BACKGROUND2_COLOR);
          Voc_Bands->textsize(10);
          Voc_Bands->textcolor(7);
          Voc_Bands->callback((Fl_Callback*)cb_Voc_Bands);
          Voc_Bands->menu(menu_Voc_Bands);
        } // Fl_Choice* Voc_Bands
        { FLPosition = new Fl_Check_Button(186, 222, 23, 20, "Limiter before Output Volume");
          FLPosition->down_box(FL_DOWN_BOX);
          FLPosition->labelsize(11);
          FLPosition->labelcolor(FL_BACKGROUND2_COLOR);
          FLPosition->callback((Fl_Callback*)cb_FLPosition);
          FLPosition->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* FLPosition
        { Calibration = new Fl_Counter(120, 249, 116, 21, "Tuner Calibration A4 ");
          Calibration->labelsize(10);
          Calibration->labelcolor(FL_BACKGROUND2_COLOR);
          Calibration->minimum(420);
          Calibration->maximum(460);
          Calibration->value(440);
          Calibration->textsize(10);
          Calibration->callback((Fl_Callback*)cb_Calibration);
          Calibration->align(FL_ALIGN_LEFT);
        } // Fl_Counter* Calibration
        { Fl_Counter* o = RTrigger = new Fl_Counter(367, 249, 116, 21, "Recognize Note Trigger");
          RTrigger->labelsize(10);
          RTrigger->labelcolor(FL_BACKGROUND2_COLOR);
          RTrigger->minimum(0.01);
          RTrigger->maximum(0.99);
          RTrigger->step(0.01);
          RTrigger->value(0.6);
          RTrigger->textsize(10);
          RTrigger->callback((Fl_Callback*)cb_RTrigger);
          RTrigger->align(FL_ALIGN_LEFT);
          o->lstep(0.1);
        } // Fl_Counter* RTrigger
        { RC_Opti = new Fl_Choice(160, 277, 72, 18, "Recognize Note Optimization");
          RC_Opti->down_box(FL_BORDER_BOX);
          RC_Opti->labelsize(10);
          RC_Opti->labelcolor(FL_BACKGROUND2_COLOR);
          RC_Opti->textsize(10);
          RC_Opti->textcolor(7);
          RC_Opti->callback((Fl_Callback*)cb_RC_Opti);
          RC_Opti->menu(menu_RC_Opti);
        } // Fl_Choice* RC_Opti
        { Har_Downsample = new Fl_Choice(145, 306, 70, 18, "Harmonizer Downsample ");
          Har_Downsample->down_box(FL_BORDER_BOX);
          Har_Downsample->labelsize(10);
          Har_Downsample->labelcolor(FL_BACKGROUND2_COLOR);
          Har_Downsample->textsize(10);
          Har_Downsample->textcolor(7);
          Har_Downsample->callback((Fl_Callback*)cb_Har_Downsample);
          Har_Downsample->menu(menu_Har_Downsample);
        } // Fl_Choice* Har_Downsample
        { Fl_Choice* o = Har_Down_Qua = new Fl_Choice(250, 306, 72, 18, "Down");
          Har_Down_Qua->down_box(FL_BORDER_BOX);
          Har_Down_Qua->labelsize(10);
          Har_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Har_Down_Qua->textsize(10);
          Har_Down_Qua->textcolor(7);
          Har_Down_Qua->callback((Fl_Callback*)cb_Har_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Har_Down_Qua
        { Fl_Choice* o = Har_Up_Qua = new Fl_Choice(343, 306, 72, 18, "Up");
          Har_Up_Qua->down_box(FL_BORDER_BOX);
          Har_Up_Qua->labelsize(10);
          Har_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Har_Up_Qua->textsize(10);
          Har_Up_Qua->textcolor(7);
          Har_Up_Qua->callback((Fl_Callback*)cb_Har_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Har_Up_Qua
        { Fl_Choice* o = Rev_Downsample = new Fl_Choice(145, 329, 70, 18, "Reverbtron Downsample  ");
          Rev_Downsample->down_box(FL_BORDER_BOX);
          Rev_Downsample->labelsize(10);
          Rev_Downsample->labelcolor(FL_BACKGROUND2_COLOR);
          Rev_Downsample->textsize(10);
          Rev_Downsample->textcolor(7);
          Rev_Downsample->callback((Fl_Callback*)cb_Rev_Downsample);
          o->menu(menu_Har_Downsample);
        } // Fl_Choice* Rev_Downsample
        { Fl_Choice* o = Rev_Down_Qua = new Fl_Choice(250, 329, 72, 18, "Down");
          Rev_Down_Qua->down_box(FL_BORDER_BOX);
          Rev_Down_Qua->labelsize(10);
          Rev_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Rev_Down_Qua->textsize(10);
          Rev_Down_Qua->textcolor(7);
          Rev_Down_Qua->callback((Fl_Callback*)cb_Rev_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Rev_Down_Qua
        { Fl_Choice* o = Rev_Up_Qua = new Fl_Choice(343, 329, 72, 18, "Up");
          Rev_Up_Qua->down_box(FL_BORDER_BOX);
          Rev_Up_Qua->labelsize(10);
          Rev_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Rev_Up_Qua->textsize(10);
          Rev_Up_Qua->textcolor(7);
          Rev_Up_Qua->callback((Fl_Callback*)cb_Rev_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Rev_Up_Qua
        { Fl_Choice* o = Con_Downsample = new Fl_Choice(145, 352, 70, 18, "Convolotron Downsample");
          Con_Downsample->down_box(FL_BORDER_BOX);
          Con_Downsample->labelsize(10);
          Con_Downsample->labelcolor(FL_BACKGROUND2_COLOR);
          Con_Downsample->textsize(10);
          Con_Downsample->textcolor(7);
          Con_Downsample->callback((Fl_Callback*)cb_Con_Downsample);
          o->menu(menu_Har_Downsample);
        } // Fl_Choice* Con_Downsample
        { Fl_Choice* o = Con_Down_Qua = new Fl_Choice(250, 352, 72, 18, "Down");
          Con_Down_Qua->down_box(FL_BORDER_BOX);
          Con_Down_Qua->labelsize(10);
          Con_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Con_Down_Qua->textsize(10);
          Con_Down_Qua->textcolor(7);
          Con_Down_Qua->callback((Fl_Callback*)cb_Con_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Con_Down_Qua
        { Fl_Choice* o = Con_Up_Qua = new Fl_Choice(343, 352, 72, 18, "Up");
          Con_Up_Qua->down_box(FL_BORDER_BOX);
          Con_Up_Qua->labelsize(10);
          Con_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Con_Up_Qua->textsize(10);
          Con_Up_Qua->textcolor(7);
          Con_Up_Qua->callback((Fl_Callback*)cb_Con_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Con_Up_Qua
        { Fl_Choice* o = Seq_Downsample = new Fl_Choice(145, 375, 70, 18, "Sequence Downsample    ");
          Seq_Downsample->down_box(FL_BORDER_BOX);
          Seq_Downsample->labelsize(10);
          Seq_Downsample->labelcolor(FL_BACKGROUND2_COLOR);
          Seq_Downsample->textsize(10);
          Seq_Downsample->textcolor(7);
          Seq_Downsample->callback((Fl_Callback*)cb_Seq_Downsample);
          o->menu(menu_Har_Downsample);
        } // Fl_Choice* Seq_Downsample
        { Fl_Choice* o = Seq_Down_Qua = new Fl_Choice(250, 375, 72, 18, "Down");
          Seq_Down_Qua->down_box(FL_BORDER_BOX);
          Seq_Down_Qua->labelsize(10);
          Seq_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Seq_Down_Qua->textsize(10);
          Seq_Down_Qua->textcolor(7);
          Seq_Down_Qua->callback((Fl_Callback*)cb_Seq_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Seq_Down_Qua
        { Fl_Choice* o = Seq_Up_Qua = new Fl_Choice(343, 375, 72, 18, "Up");
          Seq_Up_Qua->down_box(FL_BORDER_BOX);
          Seq_Up_Qua->labelsize(10);
          Seq_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Seq_Up_Qua->textsize(10);
          Seq_Up_Qua->textcolor(7);
          Seq_Up_Qua->callback((Fl_Callback*)cb_Seq_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Seq_Up_Qua
        { Fl_Choice* o = Shi_Downsample = new Fl_Choice(145, 398, 70, 18, "Shifter Downsample         ");
          Shi_Downsample->down_box(FL_BORDER_BOX);
          Shi_Downsample->labelsize(10);
          Shi_Downsample->labelcolor(FL_BACKGROUND2_COLOR);
          Shi_Downsample->textsize(10);
          Shi_Downsample->textcolor(7);
          Shi_Downsample->callback((Fl_Callback*)cb_Shi_Downsample);
          o->menu(menu_Har_Downsample);
        } // Fl_Choice* Shi_Downsample
        { Fl_Choice* o = Shi_Down_Qua = new Fl_Choice(250, 398, 72, 18, "Down");
          Shi_Down_Qua->down_box(FL_BORDER_BOX);
          Shi_Down_Qua->labelsize(10);
          Shi_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Shi_Down_Qua->textsize(10);
          Shi_Down_Qua->textcolor(7);
          Shi_Down_Qua->callback((Fl_Callback*)cb_Shi_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Shi_Down_Qua
        { Fl_Choice* o = Shi_Up_Qua = new Fl_Choice(343, 398, 72, 18, "Up");
          Shi_Up_Qua->down_box(FL_BORDER_BOX);
          Shi_Up_Qua->labelsize(10);
          Shi_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Shi_Up_Qua->textsize(10);
          Shi_Up_Qua->textcolor(7);
          Shi_Up_Qua->callback((Fl_Callback*)cb_Shi_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Shi_Up_Qua
        { Fl_Choice* o = Voc_Downsample = new Fl_Choice(145, 422, 70, 18, "Vocoder Downsample      ");
          Voc_Downsample->down_box(FL_BORDER_BOX);
          Voc_Downsample->labelsize(10);
          Voc_Downsample->labelcolor(FL_BACKGROUND2_COLOR);
          Voc_Downsample->textsize(10);
          Voc_Downsample->textcolor(7);
          Voc_Downsample->callback((Fl_Callback*)cb_Voc_Downsample);
          o->menu(menu_Har_Downsample);
        } // Fl_Choice* Voc_Downsample
        { Fl_Choice* o = Voc_Down_Qua = new Fl_Choice(250, 422, 72, 18, "Down");
          Voc_Down_Qua->down_box(FL_BORDER_BOX);
          Voc_Down_Qua->labelsize(10);
          Voc_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Voc_Down_Qua->textsize(10);
          Voc_Down_Qua->textcolor(7);
          Voc_Down_Qua->callback((Fl_Callback*)cb_Voc_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Voc_Down_Qua
        { Fl_Choice* o = Voc_Up_Qua = new Fl_Choice(343, 422, 72, 18, "Up");
          Voc_Up_Qua->down_box(FL_BORDER_BOX);
          Voc_Up_Qua->labelsize(10);
          Voc_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Voc_Up_Qua->textsize(10);
          Voc_Up_Qua->textcolor(7);
          Voc_Up_Qua->callback((Fl_Callback*)cb_Voc_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Voc_Up_Qua
        { Fl_Choice* o = Ste_Downsample = new Fl_Choice(145, 447, 70, 18, "StereoHarm Downsample");
          Ste_Downsample->down_box(FL_BORDER_BOX);
          Ste_Downsample->labelsize(10);
          Ste_Downsample->labelcolor(FL_BACKGROUND2_COLOR);
          Ste_Downsample->textsize(10);
          Ste_Downsample->textcolor(7);
          Ste_Downsample->callback((Fl_Callback*)cb_Ste_Downsample);
          o->menu(menu_Har_Downsample);
        } // Fl_Choice* Ste_Downsample
        { Fl_Choice* o = Ste_Down_Qua = new Fl_Choice(250, 447, 72, 18, "Down");
          Ste_Down_Qua->down_box(FL_BORDER_BOX);
          Ste_Down_Qua->labelsize(10);
          Ste_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Ste_Down_Qua->textsize(10);
          Ste_Down_Qua->textcolor(7);
          Ste_Down_Qua->callback((Fl_Callback*)cb_Ste_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Ste_Down_Qua
        { Fl_Choice* o = Ste_Up_Qua = new Fl_Choice(343, 447, 72, 18, "Up");
          Ste_Up_Qua->down_box(FL_BORDER_BOX);
          Ste_Up_Qua->labelsize(10);
          Ste_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Ste_Up_Qua->textsize(10);
          Ste_Up_Qua->textcolor(7);
          Ste_Up_Qua->callback((Fl_Callback*)cb_Ste_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Ste_Up_Qua
        { Wave_Amo = new Fl_Choice(145, 497, 70, 18, "Waveshape Resampling   ");
          Wave_Amo->down_box(FL_BORDER_BOX);
          Wave_Amo->labelsize(10);
          Wave_Amo->labelcolor(FL_BACKGROUND2_COLOR);
          Wave_Amo->textsize(10);
          Wave_Amo->textcolor(7);
          Wave_Amo->callback((Fl_Callback*)cb_Wave_Amo);
          Wave_Amo->menu(menu_Wave_Amo);
        } // Fl_Choice* Wave_Amo
        { Fl_Choice* o = Wave_Down_Qua = new Fl_Choice(252, 497, 72, 18, "Down");
          Wave_Down_Qua->down_box(FL_BORDER_BOX);
          Wave_Down_Qua->labelsize(10);
          Wave_Down_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Wave_Down_Qua->textsize(10);
          Wave_Down_Qua->textcolor(7);
          Wave_Down_Qua->callback((Fl_Callback*)cb_Wave_Down_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Wave_Down_Qua
        { Fl_Choice* o = Wave_Up_Qua = new Fl_Choice(345, 497, 72, 18, "Up");
          Wave_Up_Qua->down_box(FL_BORDER_BOX);
          Wave_Up_Qua->labelsize(10);
          Wave_Up_Qua->labelcolor(FL_BACKGROUND2_COLOR);
          Wave_Up_Qua->textsize(10);
          Wave_Up_Qua->textcolor(7);
          Wave_Up_Qua->callback((Fl_Callback*)cb_Wave_Up_Qua);
          o->menu(menu_Upr_Qual);
        } // Fl_Choice* Wave_Up_Qua
        AUDIO_SET->end();
      } // Fl_Group* AUDIO_SET
      { MIDI_SET = new Fl_Group(5, 26, 630, 502, "MIDI");
        MIDI_SET->box(FL_PLASTIC_DOWN_FRAME);
        MIDI_SET->labelfont(1);
        MIDI_SET->labelcolor(FL_BACKGROUND2_COLOR);
        MIDI_SET->user_data((void*)(1));
        MIDI_SET->align(FL_ALIGN_LEFT);
        MIDI_SET->hide();
        { Fondo8 = new Fl_Box(5, 26, 630, 502);
        } // Fl_Box* Fondo8
        { D_A_Connect = new Fl_Check_Button(135, 38, 105, 20, "Auto Connect MIDI In");
          D_A_Connect->down_box(FL_DOWN_BOX);
          D_A_Connect->labelsize(11);
          D_A_Connect->labelcolor(FL_BACKGROUND2_COLOR);
          D_A_Connect->callback((Fl_Callback*)cb_D_A_Connect);
          D_A_Connect->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* D_A_Connect
        { BMidiIn = new Fl_Browser(15, 72, 190, 111, "ALSA Sequencer Ports");
          BMidiIn->type(2);
          BMidiIn->selection_color(FL_FOREGROUND_COLOR);
          BMidiIn->labelsize(11);
          BMidiIn->labelcolor(FL_BACKGROUND2_COLOR);
          BMidiIn->textsize(12);
          BMidiIn->textcolor(7);
          BMidiIn->callback((Fl_Callback*)cb_BMidiIn);
          BMidiIn->align(FL_ALIGN_TOP_LEFT);
        } // Fl_Browser* BMidiIn
        { Midi_In_Counter = new Fl_Counter(103, 198, 60, 24, "Receive Channel");
          Midi_In_Counter->type(1);
          Midi_In_Counter->color((Fl_Color)25);
          Midi_In_Counter->labelsize(10);
          Midi_In_Counter->labelcolor(FL_BACKGROUND2_COLOR);
          Midi_In_Counter->minimum(1);
          Midi_In_Counter->maximum(16);
          Midi_In_Counter->step(1);
          Midi_In_Counter->value(1);
          Midi_In_Counter->textsize(11);
          Midi_In_Counter->callback((Fl_Callback*)cb_Midi_In_Counter);
          Midi_In_Counter->align(FL_ALIGN_LEFT);
        } // Fl_Counter* Midi_In_Counter
        { Har_In_Counter = new Fl_Counter(162, 235, 60, 24, "Harmonizer Receive Channel");
          Har_In_Counter->type(1);
          Har_In_Counter->color((Fl_Color)25);
          Har_In_Counter->labelsize(10);
          Har_In_Counter->labelcolor(FL_BACKGROUND2_COLOR);
          Har_In_Counter->minimum(1);
          Har_In_Counter->maximum(16);
          Har_In_Counter->step(1);
          Har_In_Counter->value(1);
          Har_In_Counter->textsize(11);
          Har_In_Counter->callback((Fl_Callback*)cb_Har_In_Counter);
          Har_In_Counter->align(FL_ALIGN_LEFT);
        } // Fl_Counter* Har_In_Counter
        { wMIDI = new Fl_Group(15, 285, 273, 23, "MIDI implementation");
          wMIDI->box(FL_PLASTIC_DOWN_FRAME);
          wMIDI->labelsize(10);
          wMIDI->labelcolor(FL_BACKGROUND2_COLOR);
          wMIDI->align(FL_ALIGN_TOP_LEFT);
          { Mw0 = new Fl_Check_Button(72, 287, 18, 18, "Default");
            Mw0->type(102);
            Mw0->down_box(FL_DOWN_BOX);
            Mw0->labelsize(11);
            Mw0->labelcolor(FL_BACKGROUND2_COLOR);
            Mw0->callback((Fl_Callback*)cb_Mw0);
            Mw0->align(FL_ALIGN_LEFT);
          } // Fl_Check_Button* Mw0
          { Mw1 = new Fl_Check_Button(183, 287, 18, 18, "MIDI Learn");
            Mw1->type(102);
            Mw1->down_box(FL_DOWN_BOX);
            Mw1->labelsize(11);
            Mw1->labelcolor(FL_BACKGROUND2_COLOR);
            Mw1->callback((Fl_Callback*)cb_Mw1);
            Mw1->align(FL_ALIGN_LEFT);
          } // Fl_Check_Button* Mw1
          wMIDI->end();
        } // Fl_Group* wMIDI
        { AAssign = new Fl_Check_Button(134, 319, 16, 15, "Auto Assign MIDI Learn");
          AAssign->down_box(FL_DOWN_BOX);
          AAssign->labelsize(10);
          AAssign->labelcolor(FL_BACKGROUND2_COLOR);
          AAssign->callback((Fl_Callback*)cb_AAssign);
          AAssign->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* AAssign
        { MTable = new Fl_Check_Button(157, 337, 16, 15, "MIDI Program Change Table");
          MTable->down_box(FL_DOWN_BOX);
          MTable->labelsize(10);
          MTable->labelcolor(FL_BACKGROUND2_COLOR);
          MTable->callback((Fl_Callback*)cb_MTable);
          MTable->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* MTable
        { scroll = new Fl_Scroll(15, 360, 585, 162);
          scroll->type(6);
          scroll->user_data((void*)(5000));
          scroll->end();
        } // Fl_Scroll* scroll
        MIDI_SET->end();
      } // Fl_Group* MIDI_SET
      { JACK_SET = new Fl_Group(5, 26, 630, 502, "Jack");
        JACK_SET->box(FL_PLASTIC_DOWN_FRAME);
        JACK_SET->labelfont(1);
        JACK_SET->labelcolor(FL_BACKGROUND2_COLOR);
        JACK_SET->user_data((void*)(1));
        JACK_SET->align(FL_ALIGN_LEFT);
        JACK_SET->hide();
        { Fondo9 = new Fl_Box(5, 26, 630, 502);
        } // Fl_Box* Fondo9
        { D_J_Connect = new Fl_Check_Button(114, 40, 25, 20, "Auto Connect Out");
          D_J_Connect->down_box(FL_DOWN_BOX);
          D_J_Connect->labelsize(11);
          D_J_Connect->labelcolor(FL_BACKGROUND2_COLOR);
          D_J_Connect->callback((Fl_Callback*)cb_D_J_Connect);
          D_J_Connect->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* D_J_Connect
        { JackCo = new Fl_Browser(10, 72, 235, 138, "Output Ports");
          JackCo->type(3);
          JackCo->selection_color(FL_FOREGROUND_COLOR);
          JackCo->labelsize(11);
          JackCo->labelcolor(FL_BACKGROUND2_COLOR);
          JackCo->textsize(12);
          JackCo->textcolor(7);
          JackCo->align(FL_ALIGN_TOP_LEFT);
        } // Fl_Browser* JackCo
        { D_IJ_Connect = new Fl_Check_Button(104, 228, 25, 20, "Auto Connect In");
          D_IJ_Connect->down_box(FL_DOWN_BOX);
          D_IJ_Connect->labelsize(11);
          D_IJ_Connect->labelcolor(FL_BACKGROUND2_COLOR);
          D_IJ_Connect->callback((Fl_Callback*)cb_D_IJ_Connect);
          D_IJ_Connect->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* D_IJ_Connect
        { JackIn = new Fl_Browser(10, 259, 235, 131, "Input Ports");
          JackIn->type(3);
          JackIn->selection_color(FL_FOREGROUND_COLOR);
          JackIn->labelsize(11);
          JackIn->labelcolor(FL_BACKGROUND2_COLOR);
          JackIn->textsize(12);
          JackIn->textcolor(7);
          JackIn->align(FL_ALIGN_TOP_LEFT);
        } // Fl_Browser* JackIn
        JACK_SET->end();
      } // Fl_Group* JACK_SET
      { MISC_SET = new Fl_Group(5, 26, 630, 502, "Misc");
        MISC_SET->box(FL_PLASTIC_DOWN_FRAME);
        MISC_SET->labelfont(1);
        MISC_SET->labelcolor(FL_BACKGROUND2_COLOR);
        MISC_SET->user_data((void*)(1));
        MISC_SET->align(FL_ALIGN_LEFT);
        MISC_SET->hide();
        { Fondo10 = new Fl_Box(5, 26, 630, 502);
        } // Fl_Box* Fondo10
        { Username = new Fl_Input(80, 32, 240, 21, "Username:");
          Username->labelsize(11);
          Username->labelcolor(FL_BACKGROUND2_COLOR);
          Username->textsize(11);
          Username->textcolor(7);
          Username->callback((Fl_Callback*)cb_Username);
        } // Fl_Input* Username
        { MES_DIS = new Fl_Check_Button(132, 68, 21, 20, "Disable Warnings    ");
          MES_DIS->down_box(FL_DOWN_BOX);
          MES_DIS->labelsize(11);
          MES_DIS->labelcolor(FL_BACKGROUND2_COLOR);
          MES_DIS->callback((Fl_Callback*)cb_MES_DIS);
          MES_DIS->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* MES_DIS
        { T_TIMEOUT = new Fl_Check_Button(132, 88, 21, 20, "Tap Tempo Timeout");
          T_TIMEOUT->down_box(FL_DOWN_BOX);
          T_TIMEOUT->labelsize(11);
          T_TIMEOUT->labelcolor(FL_BACKGROUND2_COLOR);
          T_TIMEOUT->callback((Fl_Callback*)cb_T_TIMEOUT);
          T_TIMEOUT->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* T_TIMEOUT
        { ENA_TOOL = new Fl_Check_Button(132, 108, 21, 20, "Enable Tooltips       ");
          ENA_TOOL->down_box(FL_DOWN_BOX);
          ENA_TOOL->labelsize(11);
          ENA_TOOL->labelcolor(FL_BACKGROUND2_COLOR);
          ENA_TOOL->callback((Fl_Callback*)cb_ENA_TOOL);
          ENA_TOOL->align(FL_ALIGN_LEFT);
        } // Fl_Check_Button* ENA_TOOL
        MISC_SET->end();
      } // Fl_Group* MISC_SET
      { BANK_SET = new Fl_Group(5, 26, 630, 502, "Bank");
        BANK_SET->box(FL_PLASTIC_DOWN_FRAME);
        BANK_SET->labelfont(1);
        BANK_SET->labelcolor(FL_BACKGROUND2_COLOR);
        BANK_SET->user_data((void*)(1));
        BANK_SET->align(FL_ALIGN_LEFT);
        BANK_SET->hide();
        { Fondo11 = new Fl_Box(5, 26, 630, 502);
        } // Fl_Box* Fondo11
        { BFiname = new Fl_File_Input(20, 50, 390, 30, "Bank Filename");
          BFiname->labelsize(11);
          BFiname->labelcolor(FL_BACKGROUND2_COLOR);
          BFiname->textsize(12);
          BFiname->textcolor(7);
          BFiname->align(FL_ALIGN_TOP_LEFT);
        } // Fl_File_Input* BFiname
        { BF_Browser = new Fl_Button(415, 60, 65, 20, "Browse");
          BF_Browser->callback((Fl_Callback*)cb_BF_Browser, (void*)(77));
        } // Fl_Button* BF_Browser
        { Udir = new Fl_File_Input(20, 102, 390, 30, "User Directory");
          Udir->labelsize(11);
          Udir->labelcolor(FL_BACKGROUND2_COLOR);
          Udir->textsize(12);
          Udir->textcolor(7);
          Udir->align(FL_ALIGN_TOP_LEFT);
        } // Fl_File_Input* Udir
        { UD_Browser = new Fl_Button(415, 112, 65, 20, "Browse");
          UD_Browser->callback((Fl_Callback*)cb_UD_Browser, (void*)(77));
        } // Fl_Button* UD_Browser
        BANK_SET->end();
      } // Fl_Group* BANK_SET
      STabs->end();
    } // Fl_Tabs* STabs
    Settings->end();
  } // Fl_Double_Window* Settings
  { MIDILearn = new Fl_Double_Window(640, 480);
    MIDILearn->callback((Fl_Callback*)cb_MIDILearn, (void*)(this));
    { Fondo4 = new Fl_Box(1, 1, 640, 480);
    } // Fl_Box* Fondo4
    { Epar = new Fl_Browser(10, 58, 201, 348);
      Epar->type(2);
      Epar->textcolor(7);
      Epar->callback((Fl_Callback*)cb_Epar, (void*)(99));
    } // Fl_Browser* Epar
    { GMM = new Fl_Button(10, 445, 135, 30, "Get MIDI Message");
      GMM->callback((Fl_Callback*)cb_GMM, (void*)(77));
    } // Fl_Button* GMM
    { TPresets = new Fl_Browser(430, 61, 201, 348);
      TPresets->type(2);
      TPresets->textcolor(7);
      TPresets->when(3);
    } // Fl_Browser* TPresets
    { CopyF = new Fl_Button(430, 20, 95, 30, "Copy from: ");
      CopyF->callback((Fl_Callback*)cb_CopyF, (void*)(77));
    } // Fl_Button* CopyF
    { CopyT = new Fl_Button(535, 20, 95, 30, "Copy to: ");
      CopyT->callback((Fl_Callback*)cb_CopyT, (void*)(77));
    } // Fl_Button* CopyT
    { Ares = new Fl_Group(215, 60, 205, 180);
      Ares->box(FL_THIN_DOWN_BOX);
      Ares->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
      { Ar1 = new Fl_Box(220, 65, 45, 30);
        Ar1->box(FL_DOWN_BOX);
      } // Fl_Box* Ar1
      { Ar2 = new Fl_Box(270, 65, 45, 30);
        Ar2->box(FL_DOWN_BOX);
      } // Fl_Box* Ar2
      { Ar3 = new Fl_Box(320, 65, 45, 30);
        Ar3->box(FL_DOWN_BOX);
      } // Fl_Box* Ar3
      { Ar4 = new Fl_Box(370, 65, 45, 30);
        Ar4->box(FL_DOWN_BOX);
      } // Fl_Box* Ar4
      { Ar5 = new Fl_Box(220, 100, 45, 30);
        Ar5->box(FL_DOWN_BOX);
      } // Fl_Box* Ar5
      { Ar6 = new Fl_Box(270, 100, 45, 30);
        Ar6->box(FL_DOWN_BOX);
      } // Fl_Box* Ar6
      { Ar7 = new Fl_Box(320, 100, 45, 30);
        Ar7->box(FL_DOWN_BOX);
      } // Fl_Box* Ar7
      { Ar8 = new Fl_Box(370, 100, 45, 30);
        Ar8->box(FL_DOWN_BOX);
      } // Fl_Box* Ar8
      { Ar9 = new Fl_Box(220, 135, 45, 30);
        Ar9->box(FL_DOWN_BOX);
      } // Fl_Box* Ar9
      { Ar10 = new Fl_Box(270, 135, 45, 30);
        Ar10->box(FL_DOWN_BOX);
      } // Fl_Box* Ar10
      { Ar11 = new Fl_Box(320, 135, 45, 30);
        Ar11->box(FL_DOWN_BOX);
      } // Fl_Box* Ar11
      { Ar12 = new Fl_Box(370, 135, 45, 30);
        Ar12->box(FL_DOWN_BOX);
      } // Fl_Box* Ar12
      { Ar13 = new Fl_Box(220, 170, 45, 30);
        Ar13->box(FL_DOWN_BOX);
      } // Fl_Box* Ar13
      { Ar14 = new Fl_Box(270, 170, 45, 30);
        Ar14->box(FL_DOWN_BOX);
      } // Fl_Box* Ar14
      { Ar15 = new Fl_Box(320, 170, 45, 30);
        Ar15->box(FL_DOWN_BOX);
      } // Fl_Box* Ar15
      { Ar16 = new Fl_Box(370, 170, 45, 30);
        Ar16->box(FL_DOWN_BOX);
      } // Fl_Box* Ar16
      { Ar17 = new Fl_Box(220, 205, 45, 30);
        Ar17->box(FL_DOWN_BOX);
      } // Fl_Box* Ar17
      { Ar18 = new Fl_Box(270, 205, 45, 30);
        Ar18->box(FL_DOWN_BOX);
      } // Fl_Box* Ar18
      { Ar19 = new Fl_Box(320, 205, 45, 30);
        Ar19->box(FL_DOWN_BOX);
      } // Fl_Box* Ar19
      { Ar20 = new Fl_Box(370, 205, 45, 30);
        Ar20->box(FL_DOWN_BOX);
      } // Fl_Box* Ar20
      Ares->end();
    } // Fl_Group* Ares
    { ClearA = new Fl_Button(245, 250, 150, 30, "Clear Assignements");
      ClearA->callback((Fl_Callback*)cb_ClearA, (void*)(77));
    } // Fl_Button* ClearA
    { ClearP = new Fl_Button(245, 285, 150, 30, "Clear Preset");
      ClearP->callback((Fl_Callback*)cb_ClearP, (void*)(77));
    } // Fl_Button* ClearP
    { Assign = new Fl_Button(112, 20, 98, 30, "Assign");
      Assign->callback((Fl_Callback*)cb_Assign, (void*)(77));
    } // Fl_Button* Assign
    { AssignA = new Fl_Button(10, 20, 98, 30, "Assign to All");
      AssignA->callback((Fl_Callback*)cb_AssignA, (void*)(77));
    } // Fl_Button* AssignA
    { CancelRec = new Fl_Button(200, 450, 60, 20, "Cancel");
      CancelRec->callback((Fl_Callback*)cb_CancelRec, (void*)(77));
    } // Fl_Button* CancelRec
    { Disp_Control = new Fl_Value_Input(155, 445, 40, 30);
      Disp_Control->minimum(1);
      Disp_Control->maximum(127);
      Disp_Control->step(1);
      Disp_Control->value(1);
      Disp_Control->textcolor(7);
      Disp_Control->callback((Fl_Callback*)cb_Disp_Control);
    } // Fl_Value_Input* Disp_Control
    { CopyTAll = new Fl_Button(480, 412, 150, 30, "Copy to All");
      CopyTAll->callback((Fl_Callback*)cb_CopyTAll, (void*)(77));
    } // Fl_Button* CopyTAll
    { CloseML = new Fl_Button(480, 445, 150, 30, "Close");
      CloseML->callback((Fl_Callback*)cb_CloseML, (void*)(77));
    } // Fl_Button* CloseML
    { Filters_ML = new Fl_Group(10, 410, 200, 31);
      Filters_ML->box(FL_DOWN_BOX);
      { M_fil_all = new Fl_Button(16, 415, 89, 20, "All");
        M_fil_all->type(102);
        M_fil_all->callback((Fl_Callback*)cb_M_fil_all);
      } // Fl_Button* M_fil_all
      { M_fil_current = new Fl_Button(113, 415, 89, 20, "Current");
        M_fil_current->type(102);
        M_fil_current->callback((Fl_Callback*)cb_M_fil_current);
      } // Fl_Button* M_fil_current
      Filters_ML->end();
    } // Fl_Group* Filters_ML
    MIDILearn->end();
  } // Fl_Double_Window* MIDILearn
  { AboutWin = new Fl_Double_Window(375, 235, "About Rakarrack");
    AboutWin->color((Fl_Color)36);
    AboutWin->callback((Fl_Callback*)cb_AboutWin, (void*)(this));
    { AB_Title = new Fl_Box(56, 4, 259, 41, "Rakarrack");
      AB_Title->labelfont(1);
      AB_Title->labelsize(40);
      AB_Title->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* AB_Title
    { AB_SubTitle = new Fl_Box(121, 39, 130, 22, "Audio F/X");
      AB_SubTitle->labelfont(1);
      AB_SubTitle->labelsize(16);
      AB_SubTitle->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* AB_SubTitle
    { About_Version = new Fl_Box(69, 60, 233, 15);
      About_Version->labelsize(12);
      About_Version->labelcolor(FL_BACKGROUND2_COLOR);
      About_Version->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    } // Fl_Box* About_Version
    { AB_url = new Fl_Box(68, 77, 234, 22, "http://rakarrack.sourceforge.net");
      AB_url->labelfont(1);
      AB_url->labelsize(13);
      AB_url->labelcolor((Fl_Color)6);
    } // Fl_Box* AB_url
    { AB_Authors = new Fl_Box(20, 96, 345, 26, "Copyrigth Josep Andreu Ryan Billing Douglas McClendon Arnout Engelen <2007 - \
2010>");
      AB_Authors->labelfont(1);
      AB_Authors->labelsize(8);
      AB_Authors->labelcolor(FL_BACKGROUND2_COLOR);
      AB_Authors->align(FL_ALIGN_WRAP);
    } // Fl_Box* AB_Authors
    { AB_A1 = new Fl_Box(44, 125, 281, 26, "Code of some effects and structure based on ZynAddSubFx by Paul Nasca Octavia\
n");
      AB_A1->labelfont(1);
      AB_A1->labelsize(8);
      AB_A1->labelcolor(FL_BACKGROUND2_COLOR);
      AB_A1->align(FL_ALIGN_WRAP);
    } // Fl_Box* AB_A1
    { AB_A2 = new Fl_Box(66, 172, 240, 15, "Code of Tuner taked from tuneit by Mario Lang");
      AB_A2->labelfont(1);
      AB_A2->labelsize(8);
      AB_A2->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* AB_A2
    { AB_A3 = new Fl_Box(84, 185, 219, 24, "Code of Compressor based in ArtsCompresor by Matthias Kretz & Stefan Westerfe\
ld");
      AB_A3->labelfont(1);
      AB_A3->labelsize(8);
      AB_A3->labelcolor(FL_BACKGROUND2_COLOR);
      AB_A3->align(FL_ALIGN_WRAP);
    } // Fl_Box* AB_A3
    { Fl_Button* o = new Fl_Button(48, 215, 92, 16, "LICENSE");
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_LICENSE);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(276, 215, 92, 16, "OK");
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_OK);
    } // Fl_Button* o
    { AB_A4 = new Fl_Box(64, 151, 250, 20, "Code of some effects based on swh-plugins LADSPA by Steve Harris");
      AB_A4->labelfont(1);
      AB_A4->labelsize(8);
      AB_A4->labelcolor(FL_BACKGROUND2_COLOR);
      AB_A4->align(FL_ALIGN_WRAP);
    } // Fl_Box* AB_A4
    AboutWin->end();
  } // Fl_Double_Window* AboutWin
  { Trigger = new Fl_Double_Window(205, 165);
    Trigger->callback((Fl_Callback*)cb_Trigger, (void*)(this));
    { Fondo5 = new Fl_Box(0, 1, 210, 164);
    } // Fl_Box* Fondo5
    { ACI_LABEL = new Fl_Box(25, 8, 135, 24, "Analog Control");
      ACI_LABEL->labelfont(1);
      ACI_LABEL->labelcolor(FL_BACKGROUND2_COLOR);
    } // Fl_Box* ACI_LABEL
    { aux_vu = new NewVum(5, 18, 16, 144);
      aux_vu->type(2);
      aux_vu->box(FL_NO_BOX);
      aux_vu->color((Fl_Color)178);
      aux_vu->selection_color((Fl_Color)90);
      aux_vu->labeltype(FL_NORMAL_LABEL);
      aux_vu->labelfont(0);
      aux_vu->labelsize(14);
      aux_vu->labelcolor(FL_FOREGROUND_COLOR);
      aux_vu->minimum(15);
      aux_vu->maximum(-48);
      aux_vu->step(1);
      aux_vu->value(-48);
      aux_vu->align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE);
      aux_vu->when(FL_WHEN_NEVER);
    } // NewVum* aux_vu
    { aux_source = new Fl_Choice(100, 37, 50, 17, "Source");
      aux_source->down_box(FL_BORDER_BOX);
      aux_source->labelsize(10);
      aux_source->labelcolor(FL_BACKGROUND2_COLOR);
      aux_source->textsize(10);
      aux_source->textcolor(7);
      aux_source->callback((Fl_Callback*)cb_aux_source);
      aux_source->menu(menu_aux_source);
    } // Fl_Choice* aux_source
    { aux_gain = new SliderW(99, 59, 100, 10, "Gain");
      aux_gain->type(5);
      aux_gain->box(FL_FLAT_BOX);
      aux_gain->color((Fl_Color)178);
      aux_gain->selection_color((Fl_Color)62);
      aux_gain->labeltype(FL_NORMAL_LABEL);
      aux_gain->labelfont(0);
      aux_gain->labelsize(10);
      aux_gain->labelcolor(FL_BACKGROUND2_COLOR);
      aux_gain->minimum(1);
      aux_gain->maximum(127);
      aux_gain->step(1);
      aux_gain->textcolor(7);
      aux_gain->callback((Fl_Callback*)cb_aux_gain);
      aux_gain->align(FL_ALIGN_LEFT);
      aux_gain->when(FL_WHEN_CHANGED);
    } // SliderW* aux_gain
    { aux_thres = new SliderW(100, 75, 100, 10, "Threshold");
      aux_thres->type(5);
      aux_thres->box(FL_FLAT_BOX);
      aux_thres->color((Fl_Color)178);
      aux_thres->selection_color((Fl_Color)62);
      aux_thres->labeltype(FL_NORMAL_LABEL);
      aux_thres->labelfont(0);
      aux_thres->labelsize(10);
      aux_thres->labelcolor(FL_BACKGROUND2_COLOR);
      aux_thres->minimum(-70);
      aux_thres->maximum(20);
      aux_thres->step(1);
      aux_thres->textcolor(7);
      aux_thres->callback((Fl_Callback*)cb_aux_thres);
      aux_thres->align(FL_ALIGN_LEFT);
      aux_thres->when(FL_WHEN_CHANGED);
    } // SliderW* aux_thres
    { aux_midi = new Fl_Value_Input(98, 96, 39, 22, "Midi Control");
      aux_midi->labelsize(10);
      aux_midi->labelcolor(FL_BACKGROUND2_COLOR);
      aux_midi->minimum(1);
      aux_midi->maximum(127);
      aux_midi->step(1);
      aux_midi->value(1);
      aux_midi->textsize(10);
      aux_midi->callback((Fl_Callback*)cb_aux_midi);
    } // Fl_Value_Input* aux_midi
    { aux_min = new SliderW(100, 130, 100, 10, "Minimum");
      aux_min->type(5);
      aux_min->box(FL_FLAT_BOX);
      aux_min->color((Fl_Color)178);
      aux_min->selection_color((Fl_Color)62);
      aux_min->labeltype(FL_NORMAL_LABEL);
      aux_min->labelfont(0);
      aux_min->labelsize(10);
      aux_min->labelcolor(FL_BACKGROUND2_COLOR);
      aux_min->maximum(127);
      aux_min->step(1);
      aux_min->textcolor(7);
      aux_min->callback((Fl_Callback*)cb_aux_min);
      aux_min->align(FL_ALIGN_LEFT);
      aux_min->when(FL_WHEN_CHANGED);
    } // SliderW* aux_min
    { aux_max = new SliderW(100, 150, 100, 10, "Maximum");
      aux_max->type(5);
      aux_max->box(FL_FLAT_BOX);
      aux_max->color((Fl_Color)178);
      aux_max->selection_color((Fl_Color)62);
      aux_max->labeltype(FL_NORMAL_LABEL);
      aux_max->labelfont(0);
      aux_max->labelsize(10);
      aux_max->labelcolor(FL_BACKGROUND2_COLOR);
      aux_max->maximum(127);
      aux_max->step(1);
      aux_max->value(127);
      aux_max->textcolor(7);
      aux_max->callback((Fl_Callback*)cb_aux_max);
      aux_max->align(FL_ALIGN_LEFT);
      aux_max->when(FL_WHEN_CHANGED);
    } // SliderW* aux_max
    Trigger->end();
  } // Fl_Double_Window* Trigger
  char tmp[64];
sprintf(tmp,"Version %s",VERSION);
About_Version->copy_label(tmp);
  return Trigger;
}

RKRGUI::RKRGUI(int argc, char**argv,RKR *rkr_) {
  Fl::args(argc,argv);
fl_open_display();
XpmCreatePixmapFromData(fl_display, DefaultRootWindow(fl_display),(char **)icono_rakarrack_128x128,&p ,&mask, NULL);

Fl::visual(FL_DOUBLE|FL_RGB);
//Fl::get_system_colors();
fl_register_images();
int num_fonts=0;
num_fonts = Fl::set_fonts(0);
rkr=rkr_;

back = NULL;
old = NULL;
make_window();

Principal->icon((char *)p);
BankWindow->icon((char *)p);
Order->icon((char *)p);
Settings->icon((char *)p);
AboutWin->icon((char *)p);
MIDILearn->icon((char *)p);
Trigger->icon((char *)p);

last_tecla=0;
made=0;
char tmp[256];
drag=1000;
nt=0;
at=0;
tta=0;
Analyzer_ON=0;
Scope_ON=0;

Sco->init(rkr->anall, rkr->analr, PERIOD);
Analy->init(rkr->anall, rkr->analr, PERIOD, SAMPLE_RATE);

memset(tmp,0, sizeof(tmp));
sprintf(tmp,"%s   v%s",rkr->jackcliname,VERSION); 
Principal->copy_label(tmp);
BankWin_Label(rkr->BankFilename);
memset(tmp,0, sizeof(tmp));
sprintf(tmp,"%s   v%s - Effects Order",rkr->jackcliname,VERSION);
Order->copy_label(tmp);
memset(tmp,0, sizeof(tmp));
sprintf(tmp,"%s   v%s - Settings",rkr->jackcliname,VERSION);
Settings->copy_label(tmp);
sprintf(tmp,"%s   v%s - MIDI Learn",rkr->jackcliname,VERSION);
MIDILearn->copy_label(tmp);
sprintf(tmp,"%s   v%s - ACI",rkr->jackcliname,VERSION);
Trigger->copy_label(tmp);


load_stat();
make_table_window();
Put_Loaded();
Principal->show(argc,argv);
put_icon(Principal);
ReadIntPresets();
if(rkr->deachide) HideUE->label("Show");else HideUE->label("Hide");
HideUE->redraw();


void * v=MT;
Fl::add_timeout(.04,tick,v);
Fl::add_handler(prevnext);
}

void RKRGUI::Background_Color_Change(Fl_Color bcolor) {
  MenuP->color(bcolor);
MenuB->color(bcolor);

back_color = bcolor;

Label_Color_Change(label_color);
if(!rkr->EnableBackgroundImage) back->color_average(back_color,0.0);
}

void RKRGUI::Label_Color_Change(Fl_Color bcolor) {
  label_color = bcolor;
chfsize(0);


for (int t=0; t<STabs->children();t++)
  {
   Fl_Widget *tabg = STabs->child(t);
        tabg->labelcolor(label_color);  
        tabg->selection_color(back_color);
        tabg->color(fore_color);   

   long long ud = (long long) tabg->user_data();

  if(ud==1)
  {
  
  Fl_Group *g = (Fl_Group *)tabg;     
      
     for(int i=0;i<g->children();i++)
       {
 
       Fl_Widget *w = g->child(i);

        w->labelcolor(label_color);  
        w->selection_color(back_color);
        w->color(fore_color);   
       }
   }
  }

for (int t=0; t<BankWindow->children();t++)
  {
    Fl_Widget *w = BankWindow->child(t);

     w->labelcolor(label_color);  
  }  


for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);

     w->labelcolor(label_color);  
  }  


for (int t=0; t<Order->children();t++)
  {
    Fl_Widget *w = Order->child(t);

     w->labelcolor(label_color);  
     w->selection_color(back_color);
     w->color(fore_color);
  }  

for (int t=0; t<Filters->children();t++)
  {
    Fl_Widget *w = Filters->child(t);

     w->labelcolor(label_color);  
     w->selection_color(back_color);
     w->color(fore_color);
  }  
    

for (int t=0; t<MIDILearn->children();t++)
  {
    Fl_Widget *w = MIDILearn->child(t);

     w->labelcolor(label_color);  
     w->selection_color(back_color);
     w->color(fore_color);
  }  

ACI_LABEL->labelcolor(fl_lighter(label_color));
aux_source->labelcolor(label_color);
aux_midi->labelcolor(label_color);

Fl::redraw();
}

void RKRGUI::Buttons_Color_Change(Fl_Color bcolor) {
  if (made)
{
for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);
    long long temp = (long long) w->user_data();
    if (temp > 0) w->color(bcolor); 
  }

B_B1->color(bcolor);
B_B2->color(bcolor);
B_B3->color(bcolor);
B_B4->color(bcolor);
CH_UB->color(bcolor);

}


 fore_color= bcolor;
 aux_source->color(bcolor);
 Label_Color_Change(label_color);
}

void RKRGUI::Leds_Color_Change(Fl_Color bcolor) {
  leds_color=bcolor;
chfsize(0);
}

void RKRGUI::put_icon(Fl_Window* window) {
  if (hints == NULL)
hints = XGetWMHints(fl_display, fl_xid(window));

hints->icon_pixmap=p;
hints->icon_mask=mask; 
hints->flags = IconPixmapHint | IconMaskHint;
XSetWMHints(fl_display, fl_xid(window), hints);
}

void RKRGUI::load_stat() {
  int x,y,w,h,k,b,f,l,a;

Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

rakarrack.get(rkr->PrefNom("Principal X"),x,1);
rakarrack.get(rkr->PrefNom("Principal Y"),y,1);
rakarrack.get(rkr->PrefNom("Principal W"),w,800);
rkr->resolution=w;
rakarrack.get(rkr->PrefNom("Principal H"),h,600);

char tmp[256];
sprintf (tmp, "%s/bg.png", DATADIR);

rakarrack.get(rkr->PrefNom("Enable Background Image"),rkr->EnableBackgroundImage,1);
rakarrack.get(rkr->PrefNom("Background Image"),rkr->BackgroundImage,tmp,256);
PutBackground();
rakarrack.get(rkr->PrefNom("FontSize"),rkr->relfontsize,0);
if( rkr->relfontsize!=0) chfsize(rkr->relfontsize);
rakarrack.get(rkr->PrefNom("Font"),rkr->font,0);

rakarrack.get(rkr->PrefNom("Background Color"),b, 774778368);
rakarrack.get(rkr->PrefNom("Foreground Color"),f,1602392832);
rakarrack.get(rkr->PrefNom("Leds Color"),l, -13485824);
rakarrack.get(rkr->PrefNom("Labels Color"),a, -1075849984);
rakarrack.get(rkr->PrefNom("Schema"), k,0);
scheme_ch->value(k);
scheme_ch->do_callback();
rakarrack.get(rkr->PrefNom("Hide Effects"), rkr->deachide,0);




Principal->resize(x,y,w,h);

rakarrack.get(rkr->PrefNom("BankWindow X"),x,1);
rakarrack.get(rkr->PrefNom("BankWindow Y"),y,1);
rakarrack.get(rkr->PrefNom("BankWindow W"),w,800);
rakarrack.get(rkr->PrefNom("BankWindow H"),h,600);

BankWindow->resize(x,y,w,h);

rakarrack.get(rkr->PrefNom("Order X"),x,1);
rakarrack.get(rkr->PrefNom("Order Y"),y,1);
rakarrack.get(rkr->PrefNom("Order W"),w,600);
rakarrack.get(rkr->PrefNom("Order H"),h,480);

Order->resize(x,y,w,h);

rakarrack.get(rkr->PrefNom("MIDI Learn X"),x,1);
rakarrack.get(rkr->PrefNom("MIDI Learn Y"),y,1);
rakarrack.get(rkr->PrefNom("MIDI Learn W"),w,640);
rakarrack.get(rkr->PrefNom("MIDI Learn H"),h,480);

MIDILearn->resize(x,y,w,h);

rakarrack.get(rkr->PrefNom("Trigger X"),x,1);
rakarrack.get(rkr->PrefNom("Trigger Y"),y,1);
rakarrack.get(rkr->PrefNom("Trigger W"),w,205);
rakarrack.get(rkr->PrefNom("Trigger H"),h,165);

if(h<165) h= 165;

Trigger->resize(x,y,w,h);



rakarrack.get(rkr->PrefNom("Settings X"),x,1);
rakarrack.get(rkr->PrefNom("Settings Y"),y,1);
rakarrack.get(rkr->PrefNom("Settings W"),w,640);
rakarrack.get(rkr->PrefNom("Settings H"),h,528);

if (w<640) w=640;
if (h<528) h=528;

Settings->resize(x,y,w,h);


back_color=(Fl_Color)b;
fore_color=(Fl_Color)f;
leds_color=(Fl_Color)l;
label_color=(Fl_Color)a;

Background_Color_Change(back_color);
Buttons_Color_Change(fore_color);
Leds_Color_Change(leds_color);
Label_Color_Change(label_color);

if (!commandline)
{
rakarrack.get(rkr->PrefNom("Preset Num"),k ,1);
rkr->Selected_Preset=k;
Preset_Counter->value(k);
Preset_Counter->do_callback();
}

rakarrack.get(rkr->PrefNom("MIDI Implementation"),rkr->MIDIway,0); 
if(!rkr->MIDIway) ML_Menu->deactivate();

rakarrack.get(rkr->PrefNom("MIDI Table"),rkr->midi_table,0); 
if(!rkr->midi_table) scroll->deactivate();


rakarrack.get(rkr->PrefNom("UserName"),rkr->UserRealName,"",127);
rakarrack.get(rkr->PrefNom("User Directory"),rkr->UDirFilename,DATADIR,127);
rakarrack.get(rkr->PrefNom("Preserve Gain/Master"),rkr->actuvol,0);
rakarrack.get(rkr->PrefNom("Metronome Volume"),rkr->Metro_Vol,50);
rkr->efx_Looper->setmvol(rkr->Metro_Vol);

rakarrack.get(rkr->PrefNom("Update Tap"),rkr->Tap_Updated,0);
rakarrack.get(rkr->PrefNom("MIDI IN Channel"),rkr->MidiCh,1);
rkr->MidiCh--;

rakarrack.get(rkr->PrefNom("MIDI IN Harmonizer"),rkr->HarCh,1);
rkr->HarCh--;
rakarrack.get(rkr->PrefNom("Limiter Position"),rkr->flpos,0);
rakarrack.get(rkr->PrefNom("Booster"),rkr->booster,1.0f);
if (rkr->booster==1.0) BostBut->value(0); else BostBut->value(1);


rakarrack.get(rkr->PrefNom("FX_init_state"),rkr->init_state,0);
rakarrack.get(rkr->PrefNom("Auto Assign"),rkr->autoassign,0);





if(rkr->init_state)
{
  rkr->Bypass=1;
  rkr->calculavol(1);
  rkr->calculavol(2);
}  


rakarrack.get(rkr->PrefNom("Recognize Optimization"),rkr->RCOpti,0);
RC_Opti->value(rkr->RCOpti);
RC_Opti->do_callback();


//MIDIConverter

rakarrack.get(rkr->PrefNom("Midi Out Channel"),k,1);
Midi_out_Counter->value(k);
Midi_out_Counter->do_callback();

rkr->efx_MIDIConverter->setmidichannel(k);
 
rakarrack.get(rkr->PrefNom("Trigger Adjust"),k,4);
Trig_Adj->value(k);
rkr->efx_MIDIConverter->setTriggerAdjust(k);


rakarrack.get(rkr->PrefNom("Velocity Adjust"),k,50);
Vel_Adj->value(k);
rkr->efx_MIDIConverter->setVelAdjust(k);

rakarrack.get(rkr->PrefNom("Converter Octave"),k,2);
MIDIOctave->value(k);
MIDIOctave->do_callback();

//Metronome

rakarrack.get(rkr->PrefNom("Internal Metronome Time"),k,2);
MetroBar->value(k);
MetroBar->do_callback();

rakarrack.get(rkr->PrefNom("Internal Metronome Sound"),k,0);
MetroSound->value(k);
MetroSound->do_callback();

rakarrack.get(rkr->PrefNom("Internal Metronome Volume"),k,50);
Metro_Volume->value(k);
Metro_Volume->do_callback();

rakarrack.get(rkr->PrefNom("Internal Metronome Tempo"),k,100);
Metro_Tempo->value(k);
Metro_Tempo->do_callback();

rakarrack.get(rkr->PrefNom("Internal Metronome Show"),rkr->sw_stat,0);

if(rkr->sw_stat==1) 
{ 
  Midi->hide();
  Metro->show();
}
else
 {
  Metro->hide();
  Midi->show();
 }


//Tap Tempo

rakarrack.get(rkr->PrefNom("TapTempo Input"),rkr->Tap_Selection,0);
T_SEL->value(rkr->Tap_Selection);
rakarrack.get(rkr->PrefNom("Tap Tempo Timeout"),rkr->t_timeout,0);
T_TIMEOUT->value(rkr->t_timeout);
rakarrack.get(rkr->PrefNom("TapTempo Set"),rkr->Tap_SetValue,0);
T_SET->value(rkr->Tap_SetValue);

rakarrack.get(rkr->PrefNom("Disable Warnings"),rkr->mess_dis,0);
rakarrack.get(rkr->PrefNom("Enable Tooltips"),rkr->ena_tool,1);
Fl_Tooltip::enable(rkr->ena_tool);
//Trigger

rakarrack.get(rkr->PrefNom("Aux Source"),rkr->Aux_Source,0);
aux_source->value(rkr->Aux_Source);
rakarrack.get(rkr->PrefNom("Aux Gain"),rkr->Aux_Gain,0);
aux_gain->value(rkr->Aux_Gain);
rakarrack.get(rkr->PrefNom("Aux Threshold"),rkr->Aux_Threshold,0);
aux_thres->value(rkr->Aux_Threshold);
rakarrack.get(rkr->PrefNom("Aux MIDI"),rkr->Aux_MIDI,1);
aux_midi->value(rkr->Aux_MIDI);
rakarrack.get(rkr->PrefNom("Aux Minimum"),rkr->Aux_Minimum,0);
aux_min->value(rkr->Aux_Minimum);
rakarrack.get(rkr->PrefNom("Aux Maximum"),rkr->Aux_Maximum,127);
aux_max->value(rkr->Aux_Maximum);


char temp[64];


for(int i=0; i<128; i++)
{
if(i<60) k=i;
if((i>59)&&(i<120))k=1000+i-60;
if(i>119) k=0;
memset(temp,0,sizeof(temp));
sprintf(temp, "Midi Table Program %d",i);
rakarrack.get(rkr->PrefNom(temp),f,k);



if(f<1000) 
{
rkr->M_table[i].bank=0;
rkr->M_table[i].preset=f;
}

if((f>999) && (f<2000)) 
{
rkr->M_table[i].bank=1;
rkr->M_table[i].preset=f-1000;
}

if((f>1999) && (f<3000))
{
rkr->M_table[i].bank=2;
rkr->M_table[i].preset=f-2000;
}


if((f>2999) && (f<4000))
{
rkr->M_table[i].bank=3;
rkr->M_table[i].preset=f-3000;
}


}
}

void RKRGUI::save_stat(int i) {
  Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

if (i==0)
{
rakarrack.set(rkr->PrefNom("Principal X"),Principal->x());
rakarrack.set(rkr->PrefNom("Principal Y"),Principal->y());
rakarrack.set(rkr->PrefNom("Principal W"),Principal->w());
rakarrack.set(rkr->PrefNom("Principal H"),Principal->h());
rakarrack.set(rkr->PrefNom("FontSize"), rkr->relfontsize);
rakarrack.set(rkr->PrefNom("Font"), rkr->font);

rakarrack.set(rkr->PrefNom("Background Color"), (int)back_color);
rakarrack.set(rkr->PrefNom("Foreground Color"), (int)fore_color);
rakarrack.set(rkr->PrefNom("Leds Color"), (int) leds_color);
rakarrack.set(rkr->PrefNom("Labels Color"),(int) label_color);
rakarrack.set(rkr->PrefNom("Schema"), (int) scheme_ch->value());
rakarrack.set(rkr->PrefNom("Hide Effects"), (int) rkr->deachide);


if ((Preset_Counter->value() >0) && (Preset_Counter->value() < 61))

rakarrack.set(rkr->PrefNom("Preset Num"),(int) Preset_Counter->value());

if (rkr->help_displayed)
{

rakarrack.set(rkr->PrefNom("Help X"),visor->x());
rakarrack.set(rkr->PrefNom("Help Y"),visor->y());
rakarrack.set(rkr->PrefNom("Help W"),visor->w());
rakarrack.set(rkr->PrefNom("Help H"),visor->h());
rakarrack.set(rkr->PrefNom("Help TextSize"),visor->textsize());
}



//MIDIConverter

rakarrack.set(rkr->PrefNom("Midi Out Channel"),(int)Midi_out_Counter->value()); 
rakarrack.set(rkr->PrefNom("Trigger Adjust"),(int)Trig_Adj->value());
rakarrack.set(rkr->PrefNom("Velocity Adjust"),(int)Vel_Adj->value());
rakarrack.set(rkr->PrefNom("Converter Octave"),(int)MIDIOctave->value());

//Metronome

rakarrack.set(rkr->PrefNom("Internal Metronome Time"),(int)MetroBar->value()); 
rakarrack.set(rkr->PrefNom("Internal Metronome Volume"),(int)Metro_Volume->value());
rakarrack.set(rkr->PrefNom("Internal Metronome Tempo"),(int)Metro_Tempo->value());
rakarrack.set(rkr->PrefNom("Internal Metronome Show"),(int)rkr->sw_stat);
rakarrack.set(rkr->PrefNom("Internal Metronome Sound"),(int)MetroSound->value());

//Booster
rakarrack.set(rkr->PrefNom("Booster"),rkr->booster);


//Tap Tempo
rakarrack.set(rkr->PrefNom("TapTempo Input"),(int)rkr->Tap_Selection); 
rakarrack.set(rkr->PrefNom("TapTempo Set"),(int)rkr->Tap_SetValue); 


}


if (i==1)
{
rakarrack.set(rkr->PrefNom("BankWindow X"),BankWindow->x());
rakarrack.set(rkr->PrefNom("BankWindow Y"),BankWindow->y());
rakarrack.set(rkr->PrefNom("BankWindow W"),BankWindow->w());
rakarrack.set(rkr->PrefNom("BankWindow H"),BankWindow->h());


}

if (i==5)
{
rakarrack.set(rkr->PrefNom("MIDI Learn X"),MIDILearn->x());
rakarrack.set(rkr->PrefNom("MIDI Learn Y"),MIDILearn->y());
rakarrack.set(rkr->PrefNom("MIDI Learn W"),MIDILearn->w());
rakarrack.set(rkr->PrefNom("MIDI Learn H"),MIDILearn->h());
}


if (i==6)
{
rakarrack.set(rkr->PrefNom("Trigger X"),Trigger->x());
rakarrack.set(rkr->PrefNom("Trigger Y"),Trigger->y());
rakarrack.set(rkr->PrefNom("Trigger W"),Trigger->w());
rakarrack.set(rkr->PrefNom("Trigger H"),Trigger->h());

rakarrack.set(rkr->PrefNom("Aux Source"),rkr->Aux_Source);
rakarrack.set(rkr->PrefNom("Aux Gain"),rkr->Aux_Gain);
rakarrack.set(rkr->PrefNom("Aux Threshold"),rkr->Aux_Threshold);
rakarrack.set(rkr->PrefNom("Aux MIDI"),rkr->Aux_MIDI);
rakarrack.set(rkr->PrefNom("Aux Minimum"),rkr->Aux_Minimum);
rakarrack.set(rkr->PrefNom("Aux Maximum"),rkr->Aux_Maximum);

}




if (i==2)
{
rakarrack.set(rkr->PrefNom("Order X"),Order->x());
rakarrack.set(rkr->PrefNom("Order Y"),Order->y());
rakarrack.set(rkr->PrefNom("Order W"),Order->w());
rakarrack.set(rkr->PrefNom("Order H"),Order->h());
}

if (i==3)
{
rakarrack.set(rkr->PrefNom("Settings X"),Settings->x());
rakarrack.set(rkr->PrefNom("Settings Y"),Settings->y());
rakarrack.set(rkr->PrefNom("Settings W"),Settings->w());
rakarrack.set(rkr->PrefNom("Settings H"),Settings->h());

rakarrack.set(rkr->PrefNom("UserName"),rkr->UserRealName);
rakarrack.set(rkr->PrefNom("Preserve Gain/Master"),rkr->actuvol);
rakarrack.set(rkr->PrefNom("Metronome Volume"),rkr->Metro_Vol);


rakarrack.set(rkr->PrefNom("Filter DC Offset"),rkr->DC_Offset);

rakarrack.set(rkr->PrefNom("Update Tap"),rkr->Tap_Updated);
rakarrack.set(rkr->PrefNom("Limiter Position"),rkr->flpos);
rakarrack.set(rkr->PrefNom("Recognize Optimization"),rkr->RCOpti);
rakarrack.set(rkr->PrefNom("Harmonizer Downsample"),rkr->Har_Down);
rakarrack.set(rkr->PrefNom("Harmonizer Up Quality"),rkr->Har_U_Q);
rakarrack.set(rkr->PrefNom("Harmonizer Down Quality"),rkr->Har_D_Q);
rakarrack.set(rkr->PrefNom("Reverbtron Downsample"),rkr->Rev_Down);
rakarrack.set(rkr->PrefNom("Reverbtron Up Quality"),rkr->Rev_U_Q);
rakarrack.set(rkr->PrefNom("Reverbtron Down Quality"),rkr->Rev_D_Q);
rakarrack.set(rkr->PrefNom("Convolotron Downsample"),rkr->Con_Down);
rakarrack.set(rkr->PrefNom("Convolotron Up Quality"),rkr->Con_U_Q);
rakarrack.set(rkr->PrefNom("Convolotron Down Quality"),rkr->Con_D_Q);
rakarrack.set(rkr->PrefNom("Sequence Downsample"),rkr->Seq_Down);
rakarrack.set(rkr->PrefNom("Sequence Up Quality"),rkr->Seq_U_Q);
rakarrack.set(rkr->PrefNom("Sequence Down Quality"),rkr->Seq_D_Q);
rakarrack.set(rkr->PrefNom("Shifter Downsample"),rkr->Shi_Down);
rakarrack.set(rkr->PrefNom("Shifter Up Quality"),rkr->Shi_U_Q);
rakarrack.set(rkr->PrefNom("Shifter Down Quality"),rkr->Shi_D_Q);
rakarrack.set(rkr->PrefNom("Vocoder Downsample"),rkr->Voc_Down);
rakarrack.set(rkr->PrefNom("Vocoder Up Quality"),rkr->Voc_U_Q);
rakarrack.set(rkr->PrefNom("Vocoder Down Quality"),rkr->Voc_D_Q);
rakarrack.set(rkr->PrefNom("StereoHarm Downsample"),rkr->Ste_Down);
rakarrack.set(rkr->PrefNom("StereoHarm Up Quality"),rkr->Ste_U_Q);
rakarrack.set(rkr->PrefNom("StereoHarm Down Quality"),rkr->Ste_D_Q);

rakarrack.set(rkr->PrefNom("Waveshape Resampling"),(int)Wave_Amo->value());
rakarrack.set(rkr->PrefNom("Waveshape Up Quality"),Wave_up_q);
rakarrack.set(rkr->PrefNom("Waveshape Down Quality"),Wave_down_q);
rakarrack.set(rkr->PrefNom("Calibration"),aFreq);
rakarrack.set(rkr->PrefNom("Recognize Trigger"),rkr->rtrig);

rakarrack.set(rkr->PrefNom("Vocoder Bands"),rkr->VocBands);



rakarrack.set(rkr->PrefNom("FX_init_state"),rkr->init_state);
rakarrack.set(rkr->PrefNom("Auto Assign"),rkr->autoassign);

rakarrack.set(rkr->PrefNom("UpSampling"),(int)UPSAMPLE_C->value());
rakarrack.set(rkr->PrefNom("UpQuality"),(int)Upr_Qual->value());
rakarrack.set(rkr->PrefNom("DownQuality"),(int)Downr_Qual->value());

rakarrack.set(rkr->PrefNom("UpAmount"),(int)Upr_Amo->value());
rakarrack.set(rkr->PrefNom("Looper Size"),L_SIZE->value());



rakarrack.set(rkr->PrefNom("FontSize"),rkr->relfontsize);
rakarrack.set(rkr->PrefNom("Bank Filename"),rkr->BankFilename);
rakarrack.set(rkr->PrefNom("User Directory"),rkr->UDirFilename);

rakarrack.set(rkr->PrefNom("Enable Background Image"),rkr->EnableBackgroundImage);
rakarrack.set(rkr->PrefNom("Background Image"),rkr->BackgroundImage);
rakarrack.set(rkr->PrefNom("Auto Connect MIDI IN"),rkr->aconnect_MI);
rakarrack.set(rkr->PrefNom("Auto Connect Jack"),rkr->aconnect_JA);
rakarrack.set(rkr->PrefNom("Auto Connect Jack In"),rkr->aconnect_JIA);


rakarrack.set(rkr->PrefNom("MIDI Implementation"),rkr->MIDIway);
rakarrack.set(rkr->PrefNom("MIDI Table"),rkr->midi_table);



i = BMidiIn->value();
char *temp;
temp = (char*) BMidiIn->text(i);
if (temp!=NULL)
rakarrack.set(rkr->PrefNom("MIDI IN Device"),temp);
rakarrack.set(rkr->PrefNom("MIDI IN Channel"),rkr->MidiCh+1);
rakarrack.set(rkr->PrefNom("MIDI IN Harmonizer"),rkr->HarCh+1);
rakarrack.set(rkr->PrefNom("Harmonizer Quality"),rkr->HarQual);
rakarrack.set(rkr->PrefNom("StereoHarm Quality"),rkr->SteQual);
rakarrack.set(rkr->PrefNom("Tap Tempo Timeout"),rkr->t_timeout);
rakarrack.set(rkr->PrefNom("Disable Warnings"),rkr->mess_dis);
rakarrack.set(rkr->PrefNom("Enable Tooltips"),rkr->ena_tool);



int k=1;
char temp1[128];


for(i=0; i<128;i++)
{
      memset(temp1,0, sizeof(temp1));
      sprintf(temp1, "Midi Table Program %d",i);
      rakarrack.set(rkr->PrefNom(temp1),rkr->M_table[i].bank*1000+rkr->M_table[i].preset);
}



for(i=1; i<=JackCo->size();i++)
{ 
 
  if (JackCo->selected(i))
    {
      memset(temp1,0, sizeof(temp1));
      sprintf(temp1,"Jack Port %d",k);
      rakarrack.set(rkr->PrefNom(temp1),JackCo->text(i));
      k++;
    }
      
}   
      
 rakarrack.set(rkr->PrefNom("Auto Connect Num"),k-1); 
  
k=1;
for(i=1; i<=JackIn->size();i++)
{ 
 
  if (JackIn->selected(i))
    {
      memset(temp1,0, sizeof(temp1));
      sprintf(temp1,"Jack Port In %d",k);
      rakarrack.set(rkr->PrefNom(temp1),JackIn->text(i));
      k++;
    }
      
}   
      
 rakarrack.set(rkr->PrefNom("Auto Connect In Num"),k-1); 
    



}
}

void RKRGUI::Put_Loaded() {
  //General
int i;


WPreset_Name->value(rkr->Preset_Name);
DAuthor->copy_label(rkr->Author);

Nivel_Entrada->value((int) (rkr->Input_Gain*100.0)-50);
rkr->calculavol(1);
Nivel_Salida->value((int) (rkr->Master_Volume*100.0)-50);
rkr->calculavol(2);
Balance->value((int)(rkr->Fraction_Bypass*100.0));


ActivarGeneral->value(rkr->Bypass);

if (rkr->Bypass==0)
{

rkr->val_il_sum=-50;
rkr->val_ir_sum=-50;

rkr->val_vl_sum=-50;
rkr->val_vr_sum=-50;

input_vul->value(-50);
input_vur->value(-50);

output_vul->value(-50);
output_vur->value(-50);


}


for(i=0;i<10;i++)
 {
   switch(rkr->efx_order[i])
    {
      

     case 0: //EQ1
     eq_activar->value(rkr->EQ1_Bypass);
     eq_preset->do_callback(eq_preset,1);
     break;

     case 1://Compressor
     compress_activar->value(rkr->Compressor_Bypass);
     compress_preset->do_callback(compress_preset,1);
     break;

     case 2://Distorsion
     dist_activar->value(rkr->Distorsion_Bypass);
     dist_preset->do_callback(dist_preset, 1);
     break;

     case 3://Overdrive
     ovrd_activar->value(rkr->Overdrive_Bypass);
     ovrd_preset->do_callback(ovrd_preset,1);
     break; 

     case 4://Echo
     echo_activar->value(rkr->Echo_Bypass);
     echo_preset->do_callback(echo_preset,1);
     break;
     
     case 5://Chorus
     chorus_activar->value(rkr->Chorus_Bypass);
     chorus_preset->do_callback(chorus_preset,1); 
     break;
     
     case 6://Phaser
     phaser_activar->value(rkr->Phaser_Bypass);
     phaser_preset->do_callback(phaser_preset,1);
     break;  

     case 7://Flanger
     flanger_activar->value(rkr->Flanger_Bypass);
     flanger_preset->do_callback(flanger_preset,1); 
     break;
 
     case 8://Reverb
     reverb_activar->value(rkr->Reverb_Bypass);
     reverb_preset->do_callback(reverb_preset,1);
     break;  

     case 9://EQ2
     eqp_activar->value(rkr->EQ2_Bypass);
     eqp_preset->do_callback(eqp_preset,1);
     break; 
     
     case 10://WahWah
     WhaWha_activar->value(rkr->WhaWha_Bypass);
     WhaWha_preset->do_callback(WhaWha_preset,1);
     break;

     case 11://AlienWah
     Alienwah_activar->value(rkr->Alienwah_Bypass);
     Alienwah_preset->do_callback(Alienwah_preset,1); 
     break;
     
     case 12://Cabinet
     Cabinet_output->value(rkr->lv[13][1]-64);
     Cabinet_preset->value(rkr->lv[13][0]);
     Cabinet_activar->value(rkr->Cabinet_Bypass);
     break;
 
     case 13://Pan
     pan_activar->value(rkr->Pan_Bypass);
     pan_preset->do_callback(pan_preset,1);
     break;
     
     case 14://Har
     har_activar->value(rkr->Harmonizer_Bypass);
     har_preset->do_callback(har_preset,1);
     break;

     case 15://MsicalDelay
     musdelay_activar->value(rkr->MusDelay_Bypass);
     musdelay_preset->do_callback(musdelay_preset,1);
     break; 

     case 16://NoiseGate
     gate_activar->value(rkr->Gate_Bypass);
     gate_preset->do_callback(gate_preset,1);
     break; 

     case 17://NewDist
     newdist_activar->value(rkr->NewDist_Bypass);
     newdist_preset->do_callback(newdist_preset,1);
     break;
     
     case 18://APhaser
     aphaser_activar->value(rkr->APhaser_Bypass);
     aphaser_preset->do_callback(aphaser_preset,1);
     break;

     case 19://Valve
     valve_activar->value(rkr->Valve_Bypass);
     valve_preset->do_callback(valve_preset,1);
     break;

     case 20://Dual_Flange
     dflange_activar->value(rkr->DFlange_Bypass);
     dflange_preset->do_callback(dflange_preset,1);
     break;

     case 21:// Ring
     ring_activar->value(rkr->Ring_Bypass);
     ring_preset->do_callback(ring_preset,1);
     break;  

     case 22:// Exciter
     exciter_activar->value(rkr->Exciter_Bypass);
     exciter_preset->do_callback(exciter_preset,1);
     break; 

     case 23://MBDist
     mbdist_activar->value(rkr->MBDist_Bypass);
     mbdist_preset->do_callback(mbdist_preset,1);
     break;

     case 24://Arpie
     arpie_activar->value(rkr->Arpie_Bypass);
     arpie_preset->do_callback(arpie_preset,1);
     break;

     case 25://Expander
     expander_activar->value(rkr->Expander_Bypass);
     expander_preset->do_callback(expander_preset,1);
     break;

     case 26://Shuffle
     shuffle_activar->value(rkr->Shuffle_Bypass);
     shuffle_preset->do_callback(shuffle_preset,1);
     break;

     case 27://Synthfilter
     synthfilter_activar->value(rkr->Synthfilter_Bypass);
     synthfilter_preset->do_callback(synthfilter_preset,1);
     break; 

     case 28://VaryBand
     mbvvol_activar->value(rkr->MBVvol_Bypass);
     mbvvol_preset->do_callback(mbvvol_preset,1);
     break;

     case 29://Convolotron
     convo_activar->value(rkr->Convol_Bypass);
     convo_preset->do_callback(convo_preset,1);
     break; 

     case 30://Looper
     looper_activar->value(rkr->Looper_Bypass);
     looper_preset->do_callback(looper_preset,1);
     update_looper();
     break;

     case 31://RyanWah
     ryanwah_activar->value(rkr->RyanWah_Bypass);
     ryanwah_preset->do_callback(ryanwah_preset,1);
     break;  
     
     case 32:// RBEcho
     rbecho_activar->value(rkr->RBEcho_Bypass);
     rbecho_preset->do_callback(rbecho_preset,1);
     break;
     
     case 33:// CoilCrafter
     coil_activar->value(rkr->CoilCrafter_Bypass);
     coil_preset->do_callback(coil_preset,1);
     break;

     case 34://ShelfBoost
     shelf_activar->value(rkr->ShelfBoost_Bypass);
     shelf_preset->do_callback(shelf_preset,1);
     break;
     
     case 35://Vocoder
     vo_activar->value(rkr->Vocoder_Bypass);
     vo_preset->do_callback(vo_preset,1);
     break;

     case 36://Sustainer
     sus_activar->value(rkr->Sustainer_Bypass);
     sus_preset->do_callback(sus_preset,1);
     break;
     
    case 37://Sequence
    seq_activar->value(rkr->Sequence_Bypass);
    seq_preset->do_callback(seq_preset,1);
    break;

    case 38://Shifter
    shifter_activar->value(rkr->Shifter_Bypass);
    shifter_preset->do_callback(shifter_preset,1);
    break;

    case 39://StompBox
    stomp_activar->value(rkr->StompBox_Bypass);
    stomp_preset->do_callback(stomp_preset,1);
    break;

    case 40://Reverbtron
    revtron_activar->value(rkr->Reverbtron_Bypass);
    revtron_preset->do_callback(revtron_preset,1);
    break;

    case 41://Echotron
    echotron_activar->value(rkr->Echotron_Bypass);
    echotron_preset->do_callback(echotron_preset,1);
    break;

    case 42://StereoHarm
    shar_activar->value(rkr->StereoHarm_Bypass);
    shar_preset->do_callback(shar_preset,1);
    break; 

    case 43://CompBand
    cband_activar->value(rkr->CompBand_Bypass);
    cband_preset->do_callback(cband_preset,1);
    break;

    case 44://Opticaltrem
    otrem_activar->value(rkr->Opticaltrem_Bypass);
    otrem_preset->do_callback(otrem_preset,1);
    break;

    case 45://Vibe
    vibe_activar->value(rkr->Vibe_Bypass);
    vibe_preset->do_callback(vibe_preset,1);
    break;
  }

}

reordena();
}

void RKRGUI::tick(void* v) {
  Fl_Box *o = (Fl_Box*)v;
o->do_callback();
Fl::repeat_timeout(.04,tick,v);
}

void RKRGUI::preset_click(Fl_Button* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->user_data()))->preset_click_i(o,v);
}

inline void RKRGUI::preset_click_i(Fl_Button* o, void*) {
  int ok;
int num; 
int tecla = Fl::event_key();
long long kk = (long long) o->user_data();
char temp2[128];


num = (int) kk;


if(drag!=1000)
{
 int en = search_but(Fl::event_x(),Fl::event_y());
 if(en != 1000)
 { 
 rkr->Bank[0]=rkr->Bank[en];
 rkr->Bank[en]=rkr->Bank[num];
 rkr->Bank[num]=rkr->Bank[0];
 Put_Loaded_Bank();
 rkr->modified=1;
 num=en;
 drag = 1000;
 }
}

if((Fl::event_is_click()==0)&&(Fl::event()==5)) 
{
drag = num; 
return;
}
else drag = 1000;

  
if ((Fl::event_button()==3) && (Fl::event()==FL_RELEASE))
{

Fl_Widget *w = ob->child(num-1);


if (strlen(rkr->Bank[num].Preset_Name) >0)
{ 
  Fl_Widget *m = fl_message_icon();
  m->parent()->copy_label(rkr->jackcliname);
  sprintf(temp2,"Overwrite? \"%s\"",w->label());
  ok=fl_choice(temp2,"No","Yes",NULL);
 if (!ok)
 { 
 o->value(0);
 o->redraw();
  return;
 }


}
 o->value(0);
 o->redraw();
 rkr->Preset_to_Bank(num);
 w->copy_label(rkr->Preset_Name);
 rkr->modified=1;
}



if ((Fl::event_button()==1) || tecla == 32)
{

if((num != rkr->Selected_Preset) || (rkr->new_bank_loaded))
{
Fl_Widget *w = ob->child(num-1);
unlight_preset(rkr->Selected_Preset);
rkr->Selected_Preset=num;
w->color(fl_darker(leds_color));
Preset_Counter->value(num);
Preset_Counter->do_callback();
}
}
}

void RKRGUI::make_window_banks() {
  int i,j,x,y,num;
int elw,elh;

elw=176*BankWindow->w()/800;
elh=32*BankWindow->h()/600;



ob->begin();

x=40;y=40;
num=1;

for (i=1;i<16;i++)
{
y +=elh+2;

for (j=1; j<5; j++)
{
   
     Fl_Button* butX = new Fl_Button(x+1, y+1, elw,elh,rkr->Bank[num].Preset_Name);
      butX->type(0);
      butX->color(fore_color);
      butX->box(FL_UP_BOX);
      butX->selection_color(leds_color);
      butX->labelcolor(label_color);
      butX->labelsize(14);
      butX->align(68|FL_ALIGN_INSIDE);
      butX->user_data((void*) (num));
      butX->value(0);
      butX->when(FL_WHEN_CHANGED |FL_WHEN_RELEASE_ALWAYS);
      butX->callback((Fl_Callback *)preset_click);
      ob->add(butX);

x +=elw+4;
num++;

}
 x=40;

}


ob->end();
made=1;

B_B1->color(fore_color);
B_B2->color(fore_color);
B_B3->color(fore_color);
B_B4->color(fore_color);
CH_UB->color(fore_color);

light_preset(rkr->Selected_Preset);
}

void RKRGUI::reordena() {
  int i;
unsigned int x[10],y[10];
ulong s[10];

s[0]=49;
s[1]=50;
s[2]=51;
s[3]=52;
s[4]=53;
s[5]=54;
s[6]=55;
s[7]=56;
s[8]=57;
s[9]=48;


x[0]=E1->x();
x[1]=E2->x();
x[2]=E3->x();
x[3]=E4->x();
x[4]=E5->x();
x[5]=E6->x();
x[6]=E7->x();
x[7]=E8->x();
x[8]=E9->x();
x[9]=E10->x();

y[0]=E1->y();
y[1]=E2->y();
y[2]=E3->y();
y[3]=E4->y();
y[4]=E5->y();
y[5]=E6->y();
y[6]=E7->y();
y[7]=E8->y();
y[8]=E9->y();
y[9]=E10->y();






//Hide All
	EQ->hide();
	COMPRESS->hide();
	DIST->hide();
        OVRD->hide(); 
	ECHO->hide();
        CHORUS->hide();
        PHASER->hide();
        FLANGER->hide();        
	REVERB->hide();
	PEQ->hide();
	WHAWHA->hide();
	ALIENWAH->hide();
	CABINET->hide();
	PAN->hide();
	HAR->hide();
	MUSDELAY->hide();
	GATE->hide();
	NEWDIST->hide();
	APHASER->hide();
	VALVE->hide();
	DFLANGE->hide();
	RING->hide();
	EXCITER->hide();
	MBDIST->hide();
	ARPIE->hide();
	EXPANDER->hide();
	SHUFFLE->hide();
	SYNTHFILTER->hide();
	MBVVOL->hide();
	CONVOLOTRON->hide();
	LOOPER->hide();
	RYANWAH->hide();
	RBECHO->hide();
	COILCRAFTER->hide();
	SHELFBOOST->hide();
	VOCODER->hide();
	SUSTAINER->hide();
	SEQUENCE->hide();
	SHIFTER->hide();
	STOMPBOX->hide();
	REVERBTRON->hide();
	ECHOTRON->hide();
	SHAR->hide();
	COMPBAND->hide();
	OTREM->hide();
	VIBE->hide();
	
	
	
   
 // Show   
    
    
for (i=0; i<10; i++)
{

switch (rkr->efx_order[i])
  {
  
    case 0:
       
       EQ->position(x[i],y[i]);
       eq_activar->shortcut(s[i]);
       if(!rkr->deachide) EQ->show();
       if(rkr->EQ1_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide) EQ->show();
       }
       else rkr->active[i]=0;
       break;   
       
       
    case 1:
       
       COMPRESS->position(x[i],y[i]);
       compress_activar->shortcut(s[i]);
       if(!rkr->deachide)COMPRESS->show();
       if(rkr->Compressor_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)COMPRESS->show();
       }
       else rkr->active[i]=0;
       break;   
       
     case 2:
    
       DIST->position(x[i],y[i]);
       dist_activar->shortcut(s[i]);
       if(!rkr->deachide)DIST->show();
       if(rkr->Distorsion_Bypass)
       {
       rkr->active[i]=1;
       if(rkr->deachide)DIST->show();
       }
       else rkr->active[i]=0;
       break;   
       
     case 3:
    
       OVRD->position(x[i],y[i]);
       ovrd_activar->shortcut(s[i]);
       if(!rkr->deachide)OVRD->show();
       if(rkr->Overdrive_Bypass)
       {
       rkr->active[i]=1;
       if(rkr->deachide)OVRD->show();
       }
       else rkr->active[i]=0;
       break;   
       
     case 4:
    
       ECHO->position(x[i],y[i]);
       echo_activar->shortcut(s[i]);
       if(!rkr->deachide)ECHO->show();
       if(rkr->Echo_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)ECHO->show();
       }
       else rkr->active[i]=0;
       break;   
       
     case 5:
    
       CHORUS->position(x[i],y[i]);
       chorus_activar->shortcut(s[i]);
       if(!rkr->deachide)CHORUS->show();
       if(rkr->Chorus_Bypass)
       {
       rkr->active[i]=1;
       if(rkr->deachide)CHORUS->show();
       }
       else rkr->active[i]=0;
       break;   
       
     case 6:
    
       PHASER->position(x[i],y[i]);
       phaser_activar->shortcut(s[i]);
       if(!rkr->deachide)PHASER->show();
       if(rkr->Phaser_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)PHASER->show();
       }
       else rkr->active[i]=0;
       break;   
       
     case 7:
    
       FLANGER->position(x[i],y[i]);
       flanger_activar->shortcut(s[i]);
       if(!rkr->deachide)FLANGER->show();
       if(rkr->Flanger_Bypass)
       {
       rkr->active[i]=1;
       if(rkr->deachide)FLANGER->show();
       }
       else rkr->active[i]=0;
       break;    
                    
     case 8:
    
       REVERB->position(x[i],y[i]);
       reverb_activar->shortcut(s[i]);
       if(!rkr->deachide)REVERB->show();
       if(rkr->Reverb_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)REVERB->show();
       }
       else rkr->active[i]=0;
       break;     
       
     case 9:
    
       PEQ->position(x[i],y[i]);
       eqp_activar->shortcut(s[i]);
       if(!rkr->deachide)PEQ->show();
       if(rkr->EQ2_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)PEQ->show();
       }
       else rkr->active[i]=0;
       break;     
     
     case 10:
    
       WHAWHA->position(x[i],y[i]);
       WhaWha_activar->shortcut(s[i]);
       if(!rkr->deachide)WHAWHA->show();
       if(rkr->WhaWha_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)WHAWHA->show();
       }
       else rkr->active[i]=0;
       break;  
       
     case 11:
    
       ALIENWAH->position(x[i],y[i]);
       Alienwah_activar->shortcut(s[i]);
       if(!rkr->deachide)ALIENWAH->show();
       if(rkr->Alienwah_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)ALIENWAH->show();
       }
       else rkr->active[i]=0;
       break;      
     
     case 12:
     
       CABINET->position(x[i],y[i]);   
       Cabinet_activar->shortcut(s[i]);
       if(!rkr->deachide)CABINET->show();
       if(rkr->Cabinet_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)CABINET->show();
       }
       else rkr->active[i]=0;
       break;
    
     case 13:
     
       PAN->position(x[i],y[i]);   
       pan_activar->shortcut(s[i]);
       if(!rkr->deachide)PAN->show();
       if(rkr->Pan_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)PAN->show();
       }
       else rkr->active[i]=0;
       break;
     
     case 14:
       HAR->position(x[i],y[i]);
       har_activar->shortcut(s[i]);
       if(!rkr->deachide)HAR->show();
       if(rkr->Harmonizer_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)HAR->show();
       }
       else rkr->active[i]=0;
       break;
     
     case 15:
       MUSDELAY->position(x[i],y[i]);
       musdelay_activar->shortcut(s[i]);
       if(!rkr->deachide)MUSDELAY->show();
       if(rkr->MusDelay_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)MUSDELAY->show();
       }
       else rkr->active[i]=0;
       break; 
       
     case 16:
       GATE->position(x[i],y[i]);
       gate_activar->shortcut(s[i]);
       if(!rkr->deachide)GATE->show();
       if(rkr->Gate_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)GATE->show();
       }
       else rkr->active[i]=0;
       break;  
     
     case 17:
       NEWDIST->position(x[i],y[i]);
       newdist_activar->shortcut(s[i]);
       if(!rkr->deachide)NEWDIST->show();
       if(rkr->NewDist_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)NEWDIST->show();
       }
       else rkr->active[i]=0;
       break;
      
     case 18:
       APHASER->position(x[i],y[i]);
       aphaser_activar->shortcut(s[i]);
       if(!rkr->deachide)APHASER->show();
       if(rkr->APhaser_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)APHASER->show();
       }
       else rkr->active[i]=0;
       break;
 
     case 19:
       VALVE->position(x[i],y[i]);
       valve_activar->shortcut(s[i]);
       if(!rkr->deachide)VALVE->show();
       if(rkr->Valve_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)VALVE->show();
       }       
       else rkr->active[i]=0;
       break;

     case 20:
       DFLANGE->position(x[i],y[i]);
       dflange_activar->shortcut(s[i]);
       if(!rkr->deachide)DFLANGE->show();
       if(rkr->DFlange_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)DFLANGE->show();
       }       
       else rkr->active[i]=0;
       break;

     case 21:
       RING->position(x[i],y[i]);
       ring_activar->shortcut(s[i]);
       if(!rkr->deachide)RING->show();
       if(rkr->Ring_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)RING->show();
       }
       else rkr->active[i]=0;
       break;

     case 22:
       EXCITER->position(x[i],y[i]);
       exciter_activar->shortcut(s[i]);
       if(!rkr->deachide)EXCITER->show();
       if(rkr->Exciter_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)EXCITER->show();
       }
       else rkr->active[i]=0;
       break;

     case 23:
       MBDIST->position(x[i],y[i]);
       mbdist_activar->shortcut(s[i]);
       if(!rkr->deachide)MBDIST->show();
       if(rkr->MBDist_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)MBDIST->show();
       }
       else rkr->active[i]=0;
       break;
     
     case 24:
       ARPIE->position(x[i],y[i]);
       arpie_activar->shortcut(s[i]);
       if(!rkr->deachide)ARPIE->show();
       if(rkr->Arpie_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)ARPIE->show();
       }
       else rkr->active[i]=0;
       break;   

     case 25:
       EXPANDER->position(x[i],y[i]);
       expander_activar->shortcut(s[i]);
       if(!rkr->deachide)EXPANDER->show();
       if(rkr->Expander_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)EXPANDER->show();
       }
       else rkr->active[i]=0;
       break;   

     case 26:
       SHUFFLE->position(x[i],y[i]);
       shuffle_activar->shortcut(s[i]);
       if(!rkr->deachide)SHUFFLE->show();
       if(rkr->Shuffle_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)SHUFFLE->show();
       }
       else rkr->active[i]=0;
       break;   

     case 27:
       SYNTHFILTER->position(x[i],y[i]);
       synthfilter_activar->shortcut(s[i]);
       if(!rkr->deachide)SYNTHFILTER->show();
       if(rkr->Synthfilter_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)SYNTHFILTER->show();
       }       
       else rkr->active[i]=0;
       
       break;   

     case 28:
       MBVVOL->position(x[i],y[i]);
       mbvvol_activar->shortcut(s[i]);
       if(!rkr->deachide)MBVVOL->show();
       if(rkr->MBVvol_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)MBVVOL->show();
       }
       else rkr->active[i]=0;
       break;   

     case 29:
       CONVOLOTRON->position(x[i],y[i]);
       convo_activar->shortcut(s[i]);
       if(!rkr->deachide)CONVOLOTRON->show();
       if(rkr->Convol_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)CONVOLOTRON->show();
       }
       else rkr->active[i]=0;
       break; 

     case 30:
       LOOPER->position(x[i],y[i]);
       looper_activar->shortcut(s[i]);
       if(!rkr->deachide)LOOPER->show();
       if(rkr->Looper_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)LOOPER->show();
       }       
       else rkr->active[i]=0;
       break; 

     case 31:
       RYANWAH->position(x[i],y[i]);
       ryanwah_activar->shortcut(s[i]);
       if(!rkr->deachide)RYANWAH->show();
       if(rkr->RyanWah_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)RYANWAH->show();
       }
       else rkr->active[i]=0;
       break; 

     case 32:
       RBECHO->position(x[i],y[i]);
       rbecho_activar->shortcut(s[i]);
       if(!rkr->deachide)RBECHO->show();
       if(rkr->RBEcho_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)RBECHO->show();
       }
       else rkr->active[i]=0;
       break; 

     case 33:
       COILCRAFTER->position(x[i],y[i]);
       coil_activar->shortcut(s[i]);
       if(!rkr->deachide)COILCRAFTER->show();
       if(rkr->CoilCrafter_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)COILCRAFTER->show();
       }
       else rkr->active[i]=0;
       break; 

     case 34:
       SHELFBOOST->position(x[i],y[i]);
       shelf_activar->shortcut(s[i]);
       if(!rkr->deachide)SHELFBOOST->show();
       if(rkr->ShelfBoost_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)SHELFBOOST->show();
       }
       else rkr->active[i]=0;
       break; 

   case 35:
       VOCODER->position(x[i],y[i]);
       vo_activar->shortcut(s[i]);
       if(!rkr->deachide)VOCODER->show();
       if(rkr->Vocoder_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)VOCODER->show();
       }
       else rkr->active[i]=0;
       break; 

   case 36:
       SUSTAINER->position(x[i],y[i]);
       sus_activar->shortcut(s[i]);
       if(!rkr->deachide)SUSTAINER->show();
       if(rkr->Sustainer_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)SUSTAINER->show();
       }
       else rkr->active[i]=0;
       break; 

   case 37:
       SEQUENCE->position(x[i],y[i]);
       seq_activar->shortcut(s[i]);
       if(!rkr->deachide)SEQUENCE->show();
       if(rkr->Sequence_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)SEQUENCE->show();
       }
       else rkr->active[i]=0;
       break; 

   case 38:
       SHIFTER->position(x[i],y[i]);
       shifter_activar->shortcut(s[i]);
       if(!rkr->deachide)SHIFTER->show();
       if(rkr->Shifter_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)SHIFTER->show();
       }
       else rkr->active[i]=0;
       break; 

   case 39:
       STOMPBOX->position(x[i],y[i]);
       stomp_activar->shortcut(s[i]);
       if(!rkr->deachide)STOMPBOX->show();
       if(rkr->StompBox_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)STOMPBOX->show();
       }
       else rkr->active[i]=0;
       break; 

   case 40:
       REVERBTRON->position(x[i],y[i]);
       revtron_activar->shortcut(s[i]);
       if(!rkr->deachide)REVERBTRON->show();
       if(rkr->Reverbtron_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)REVERBTRON->show();
       }
       else rkr->active[i]=0;
       break; 

   case 41:
       ECHOTRON->position(x[i],y[i]);
       echotron_activar->shortcut(s[i]);
       if(!rkr->deachide)ECHOTRON->show();
       if(rkr->Echotron_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)ECHOTRON->show();
       }
       else rkr->active[i]=0;
       break; 

   case 42:
       SHAR->position(x[i],y[i]);
       shar_activar->shortcut(s[i]);
       if(!rkr->deachide)SHAR->show();
       if(rkr->StereoHarm_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)SHAR->show();
       }
       else rkr->active[i]=0;
       break; 

   case 43:
       COMPBAND->position(x[i],y[i]);
       cband_activar->shortcut(s[i]);
       if(!rkr->deachide)COMPBAND->show();
       if(rkr->CompBand_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)COMPBAND->show();
       }
       else rkr->active[i]=0;
       break; 

   case 44:
       OTREM->position(x[i],y[i]);
       otrem_activar->shortcut(s[i]);
       if(!rkr->deachide)OTREM->show();
       if(rkr->Opticaltrem_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)OTREM->show();
       }
       else rkr->active[i]=0;
       break; 

   case 45:
       VIBE->position(x[i],y[i]);
       vibe_activar->shortcut(s[i]);
       if(!rkr->deachide)VIBE->show();
       if(rkr->Vibe_Bypass)
       {
       rkr->active[i]=1; 
       if(rkr->deachide)VIBE->show();
       }
       else rkr->active[i]=0;
       break; 


 }
 
 
 switch(i)
 {
    case 0:
       L1->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L1->hide(); else L1->show();
       break;
    case 1:
       L2->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L2->hide(); else L2->show();
       break;
    case 2:
       L3->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L3->hide(); else L3->show();
       break;
    case 3:
       L4->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L4->hide(); else L4->show();
       break;
    case 4:
       L5->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L5->hide(); else L5->show();
       break;
    case 5:
       L6->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L6->hide(); else L6->show();
       break;
    case 6:
       L7->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L7->hide(); else L7->show();
       break;
    case 7:
       L8->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L8->hide(); else L8->show();
       break;
    case 8:
       L9->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L9->hide(); else L9->show();
       break;
    case 9:
       L10->copy_label(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
       if((rkr->deachide) && (!rkr->active[i])) L10->hide(); else L10->show();
       break;
}
 
 
 }
 
  Principal->init_sizes();
 
  ChangeActives();
  
  
 
  Fl::redraw();
}

void RKRGUI::show_help() {
  int x,y,w,h,k;

char temp[128];


Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);

if (rkr->help_displayed==0)
{
 visor = new Fl_Help_Dialog;

rakarrack.get(rkr->PrefNom("Help X"),x,1);
rakarrack.get(rkr->PrefNom("Help Y"),y,1);
rakarrack.get(rkr->PrefNom("Help W"),w,640);
rakarrack.get(rkr->PrefNom("Help H"),h,480);
rakarrack.get(rkr->PrefNom("Help TextSize"),k,11);
visor->resize(x,y,w,h);
visor->textsize((unsigned char)k);
}


memset(temp,0, sizeof(temp));
sprintf(temp,"%s/html/help.html",HELPDIR);


 if (FILE * file = fopen(temp, "r"))
        {
                fclose(file);
                visor->load(temp);
		rkr->help_displayed=1;
		visor->show();
	}
}

void RKRGUI::show_lic() {
  int x,y,w,h,k;
char temp[128];


Fl_Preferences rakarrack (Fl_Preferences::USER, WEBSITE, PACKAGE);



if (rkr->help_displayed==0)
{
 visor = new Fl_Help_Dialog;

rakarrack.get(rkr->PrefNom("Help X"),x,1);
rakarrack.get(rkr->PrefNom("Help Y"),y,1);
rakarrack.get(rkr->PrefNom("Help W"),w,640);
rakarrack.get(rkr->PrefNom("Help H"),h,480);
rakarrack.get(rkr->PrefNom("Help TextSize"),k,11);
visor->resize(x,y,w,h);
visor->textsize((unsigned char)k);
}


memset(temp,0, sizeof(temp));
sprintf(temp,"%s/html/license.html",HELPDIR);
visor->load(temp);


rkr->help_displayed=1;

visor->show();
}

void RKRGUI::MiraClientes() {
  int i;
char temp[128];
char temp1[128];
char *masque;
char *name;
FILE *fp;

BMidiIn->clear();


if ((fp = fopen ("/proc/asound/seq/clients", "r")) != NULL)
  {
    memset (temp, 0, sizeof (temp));

      while (fgets (temp, sizeof temp, fp) != NULL)
           {
             
            if (strstr(temp,"Port") != NULL)
             
           {  
             
             strcpy(temp1,temp);
             strtok(temp1,"\"");
             name=strtok(NULL,"\"");
             masque=strtok(NULL,")");
             
             if ((masque[2]=='R') && (strstr(name,"rakarrack MC OUT")==0)) BMidiIn->add(name);
             
            } 
           } 
   }
   
   fclose(fp);
 
 
   
 JackCo->clear();
 
 const char **ports;
  
  
   if ((ports = jack_get_ports (rkr->jackclient, NULL, JACK_DEFAULT_AUDIO_TYPE, 
                               JackPortIsInput)) == NULL) {
                fprintf(stderr, "Cannot find any Input port\n");
    
                
        }
  
  else
  {
  i=0;
  
  while (ports[i] != NULL)
     {
      if((strstr(ports[i],"rakarrack:in_1")==0) && (strstr(ports[i],"rakarrack:in_2")==0))
      JackCo->add(ports[i]);
      i++; 
     }
     
    
         
   }  
   
   free(ports);
   
JackIn->clear();
 
 const char **iports;  
  
   if ((iports = jack_get_ports (rkr->jackclient, NULL, JACK_DEFAULT_AUDIO_TYPE, 
                               JackPortIsOutput)) == NULL) {
                fprintf(stderr, "Cannot find any Output port\n");
    
                
        }
  
  else
  {
  i=0;
  
  while (iports[i] != NULL)
     {
      if((strstr(iports[i],"rakarrack:out_1")==0) && (strstr(iports[i],"rakarrack:out_2")==0))
      JackIn->add(iports[i]);
      i++; 
     }
     
    
         
   }  
   
   free(iports);
}

void RKRGUI::MiraConfig() {
  int i = 1;
int k;
while (BMidiIn->text(i) != NULL)
{
if (strcmp(BMidiIn->text(i),rkr->MID)==0 ) BMidiIn->select(i,1);
i++; 
}

i=1;

while (JackCo->text(i) != NULL)
{

for (k=0; k < rkr->cuan_jack; k++)
if (strcmp(JackCo->text(i),rkr->jack_po[k].name)==0 ) JackCo->select(i,1);

i++; 
}


i=1;

while (JackIn->text(i) != NULL)
{

for (k=0; k < rkr->cuan_ijack; k++)
if (strcmp(JackIn->text(i),rkr->jack_poi[k].name)==0 ) JackIn->select(i,1);

i++; 
}




if (rkr->MIDIway) Mw1->setonly(); else Mw0->setonly();

rkr->m_displayed = 0;
Enable_Back->value(rkr->EnableBackgroundImage);
Enable_DeacHide->value(rkr->deachide);

BFiname->value(rkr->BankFilename);
BackFiname->value(rkr->BackgroundImage);
Udir->value(rkr->UDirFilename);
Username->value(rkr->UserRealName);
Pre_Serve->value(rkr->actuvol);
LM_Volume->value(rkr->Metro_Vol);
Filter_DC->value(rkr->DC_Offset);
FLPosition->value(rkr->flpos);
Har_Downsample->value(rkr->Har_Down);
Har_Down_Qua->value(rkr->Har_D_Q);
Har_Up_Qua->value(rkr->Har_U_Q);
Rev_Downsample->value(rkr->Rev_Down);
Rev_Down_Qua->value(rkr->Rev_D_Q);
Rev_Up_Qua->value(rkr->Rev_U_Q);
Con_Downsample->value(rkr->Con_Down);
Con_Down_Qua->value(rkr->Con_D_Q);
Con_Up_Qua->value(rkr->Con_U_Q);
Seq_Downsample->value(rkr->Seq_Down);
Seq_Down_Qua->value(rkr->Seq_D_Q);
Seq_Up_Qua->value(rkr->Seq_U_Q);
Shi_Downsample->value(rkr->Shi_Down);
Shi_Down_Qua->value(rkr->Shi_D_Q);
Shi_Up_Qua->value(rkr->Shi_U_Q);
Voc_Downsample->value(rkr->Voc_Down);
Voc_Down_Qua->value(rkr->Voc_D_Q);
Voc_Up_Qua->value(rkr->Voc_U_Q);
Ste_Downsample->value(rkr->Ste_Down);
Ste_Down_Qua->value(rkr->Ste_D_Q);
Ste_Up_Qua->value(rkr->Ste_U_Q);
Wave_Amo->value(Wave_res_amount);
Wave_Up_Qua->value(Wave_up_q);
Wave_Down_Qua->value(Wave_down_q);
Calibration->value(aFreq);
RTrigger->value(rkr->RecNote->trigfact);
RC_Opti->value(rkr->RCOpti);

switch(rkr->VocBands)
{
  case 16:
  Voc_Bands->value(0);
  break;
  case 32:
  Voc_Bands->value(1);
  break;
  case 64:
  Voc_Bands->value(2);
  break;
  case 128:
  Voc_Bands->value(3);
  break;
  case 256:
  Voc_Bands->value(4);
  break;
  
}
  


MTable->value(rkr->midi_table);

AAssign->value(rkr->autoassign);
Update_TAP->value(rkr->Tap_Updated);
INSTATE->value(rkr->init_state);
UPSAMPLE_C->value(rkr->upsample);
Upr_Qual->value(rkr->UpQual);
Downr_Qual->value(rkr->DownQual);
MES_DIS->value(rkr->mess_dis);
ENA_TOOL->value(rkr->ena_tool);
T_TIMEOUT->value(rkr->t_timeout);

Upr_Amo->value(rkr->UpAmo);
L_SIZE->value(rkr->looper_size);
D_A_Connect->value(rkr->aconnect_MI);
D_J_Connect->value(rkr->aconnect_JA);
D_IJ_Connect->value(rkr->aconnect_JIA);

Midi_In_Counter->value(rkr->MidiCh+1);
Har_In_Counter->value(rkr->HarCh+1);

switch(rkr->HarQual)
{
  case 4:
  Har_Qual->value(0);
  break;
  
  case 8:
  Har_Qual->value(1);
  break;
  
  case 16:
  Har_Qual->value(2);
  break;

  case 32:
  Har_Qual->value(3);
  break;


}  

switch(rkr->SteQual)
{
  case 4:
  Ste_Qual->value(0);
  break;
  
  case 8:
  Ste_Qual->value(1);
  break;
  
  case 16:
  Ste_Qual->value(2);
  break;

  case 32:
  Ste_Qual->value(3);
  break;


}  



if (rkr->aconnect_MI) BMidiIn->activate();
else BMidiIn->deactivate();

if (rkr->aconnect_JA) JackCo->activate();
else JackCo->deactivate();

if (rkr->aconnect_JIA) JackIn->activate();
else JackIn->deactivate();

Fl_Menu_Item *p;  
unsigned int SR_value=SAMPLE_RATE;

for(int j=0; j<menu_Har_Downsample->size(); j++)
 {
      p=menu_Har_Downsample->next(j);
      
      switch(j)
       {
            case 0:
             SR_value = SAMPLE_RATE;
             break;
            case 1:  
             SR_value = 96000;
             break;
            case 2:  
             SR_value = 48000;
             break;
            case 3:  
             SR_value = 44100;
             break;
            case 4:  
             SR_value = 32000;
             break;
            case 5:  
             SR_value = 22050;
             break;
            case 6:  
             SR_value = 16000;
             break;
            case 7:  
             SR_value = 12000;
             break;
            case 8:  
             SR_value = 8000;
             break;
            case 9:  
             SR_value = 4000;
             break;
       
       
       }     

        if((j>0) && (SAMPLE_RATE<=SR_value)) p->deactivate(); else p->activate();


 }
 
 
 Font_Bro->clear(); 
 Font_Bro->textcolor(label_color);
 k=0;
 k = Fl::set_fonts(0);
  for (i = 0; i < k; i++) {
    int t; const char *name = Fl::get_font_name((Fl_Font)i,&t);
    char buffer[128];
#if 1
    if (t) {
      char *p = buffer;
      if (t & FL_BOLD) {*p++ = '@'; *p++ = 'b';}
      if (t & FL_ITALIC) {*p++ = '@'; *p++ = 'i';}
      strcpy(p,name);
      name = buffer;
    }
#else // this is neat, but really slow on some X servers:
    sprintf(buffer, "@F%d@.%s", i, name);
    name = buffer;
#endif
    Font_Bro->add(name);

}

Font_Bro->value(rkr->font+1);
}

void RKRGUI::BankWin_Label(char *filename) {
  char tmp[256];


memset(tmp,0, sizeof(tmp));
sprintf(tmp,"%s   v%s - Bank Manager - %s",rkr->jackcliname,VERSION,fl_filename_name(filename));
BankWindow->copy_label(tmp);
}

void RKRGUI::is_modified() {
  int ok;


if (rkr->modified)
{

 Fl_Widget *w = fl_message_icon();
 w->parent()->copy_label(rkr->jackcliname);
 

 ok=fl_choice("Bank was modified, but not saved","Discard","Save",NULL);



 switch(ok)
  
    {
        case 0:
          break;

        case 1: 
          MIDI_LABEL->do_callback();
          break;  

    }

}
}

void RKRGUI::Put_Loaded_Bank() {
  int k=1;

for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);
    long long temp = (long long) w->user_data();
    if (temp > 0)
    {
     w->copy_label(rkr->Bank[k].Preset_Name);
     k++;
    }
  
  }
  
FillML(2);
}

void RKRGUI::Chord(int eff) {
  int tipo,undi;
tipo=0;
undi=0;

switch(eff)
{
case 0:
tipo=rkr->efx_Har->getpar(7);
undi=rkr->efx_Har->getpar(6);
break;
case 1:
tipo=rkr->efx_StereoHarm->getpar(9);
undi=rkr->efx_StereoHarm->getpar(8);
break;
}



sprintf(rkr->RC->NombreAcorde,"%s%s", rkr->RC->NCE[undi].Nom,rkr->RC->ChN[tipo].Nom);

rkr->RC->ctipo=tipo;
rkr->RC->fundi=undi;
rkr->RC->cc=1;
}

void RKRGUI::ActMIDI() {
  if (rkr->Mvalue==0) return;

int i;

for (i=1; i<(rkr->NumParams+26); i++)

{

  
 if (rkr->Mcontrol[i]==0) continue;
 
 rkr->Mcontrol[i]=0;


switch (i)
{
     case 12:
     Balance->value(rkr->Fraction_Bypass*100);
     Balance->redraw();
     break;
     case 14:
     Nivel_Entrada->value((int) (rkr->Input_Gain*100.0)-50);
     Nivel_Entrada->redraw();
     break;
     case 7:
     Nivel_Salida->value((int) (rkr->Master_Volume*100.0)-50);
     Nivel_Salida->redraw();
     break;  
     case 1:
     WhaWha_dpth->value(rkr->efx_WhaWha->getpar(6));
     WhaWha_dpth->redraw();
     break;
     case 20:
     Alienwah_dpth->value(rkr->efx_Alienwah->getpar(6));
     Alienwah_dpth->redraw();
     break;
     case 21:
     phaser_dpth->value(rkr->efx_Phaser->getpar(6));
     phaser_dpth->redraw();
     break;
     case 22:
     flanger_dpth->value(rkr->efx_Flanger->getpar(6));
     flanger_dpth->redraw();
     break;
     case 23:
     chorus_dpth->value(rkr->efx_Chorus->getpar(6));
     chorus_dpth->redraw();
     break;
     case 24:
     musdelay_gain1->value(rkr->efx_MusDelay->getpar(11)-64);
     musdelay_gain1->redraw();
     break;
     case 25:
     musdelay_gain2->value(rkr->efx_MusDelay->getpar(12)-64);
     musdelay_gain2->redraw();
     break;
     case 26:
     har_freq1->value(rkr->efx_Har->getpar(4));
     har_freq1->redraw();
     break;
     case 27:
     har_int->value(rkr->efx_Har->getpar(3)-12);
     har_int->redraw();
     break;
     case 28:
     WhaWha_WD->value(rkr->efx_WhaWha->getpar(0)-64);
     WhaWha_WD->redraw();
     break;
     case 29:
     ovrd_WD->value(rkr->efx_Overdrive->getpar(0)-64);
     ovrd_WD->redraw();
     break;
     case 30:
     dist_WD->value(rkr->efx_Distorsion->getpar(0)-64);
     dist_WD->redraw();
     break;
     case 31:
     har_WD->value(rkr->efx_Har->getpar(0)-64);
     har_WD->redraw();
     break;
     case 52:
     chorus_WD->value(rkr->efx_Chorus->getpar(0)-64);
     chorus_WD->redraw();
     break;
     case 53:
     flanger_WD->value(rkr->efx_Flanger->getpar(0)-64);
     flanger_WD->redraw();
     break;
     case 54:
     phaser_WD->value(rkr->efx_Phaser->getpar(0)-64);
     phaser_WD->redraw();
     break;
     case 55:
     Alienwah_WD->value(rkr->efx_Alienwah->getpar(0)-64);
     Alienwah_WD->redraw();
     break;
     case 56:
     musdelay_WD->value(rkr->efx_MusDelay->getpar(0)-64);
     musdelay_WD->redraw();
     break;
     case 57:
     reverb_WD->value(rkr->efx_Rev->getpar(0)-64);
     reverb_WD->redraw();
     break;
     case 58:
     pan_WD->value(rkr->efx_Pan->getpar(0)-64);
     pan_WD->redraw();
     break;
     case 59:
     echo_WD->value(rkr->efx_Echo->getpar(0)-64);
     echo_WD->redraw();
     break;
     case 46:
     echo_pan->value(rkr->efx_Echo->getpar(1)-64);
     echo_pan->redraw();
     break;
     case 47:
     ovrd_pan->value(rkr->efx_Overdrive->getpar(1)-64);
     ovrd_pan->redraw();
     break;
     case 48:
     dist_pan->value(rkr->efx_Distorsion->getpar(1)-64);
     dist_pan->redraw();
     break;
     case 49:
     har_pan->value(rkr->efx_Har->getpar(1)-64);
     har_pan->redraw();
     break;
     case 50:
     chorus_pan->value(rkr->efx_Chorus->getpar(1)-64);
     chorus_pan->redraw();
     break;
     case 51:
     flanger_pan->value(rkr->efx_Flanger->getpar(1)-64);
     flanger_pan->redraw();
     break;
     case 60:
     phaser_pan->value(rkr->efx_Phaser->getpar(1)-64);
     phaser_pan->redraw();
     break;
     case 61:
     Alienwah_pan->value(rkr->efx_Alienwah->getpar(1)-64);
     Alienwah_pan->redraw();
     break;
     case 62:
     musdelay_pan1->value(rkr->efx_MusDelay->getpar(1)-64);
     musdelay_pan1->redraw();
     break;
     case 63:
     reverb_pan->value(rkr->efx_Rev->getpar(1)-64);
     reverb_pan->redraw();
     break;
     case 65:
     musdelay_pan2->value(rkr->efx_MusDelay->getpar(7)-64);
     musdelay_pan2->redraw();
     break;
     case 66:
     WhaWha_pan->value(rkr->efx_WhaWha->getpar(1)-64);
     WhaWha_pan->redraw();
     break;
     case 67:
     pan_pan->value(rkr->efx_Pan->getpar(1)-64);
     pan_pan->redraw();
     break;
     case 68:
     ovrd_drive->value(rkr->efx_Overdrive->getpar(3));
     ovrd_drive->redraw();
     break;
     case 69:
     dist_drive->value(rkr->efx_Distorsion->getpar(3));
     dist_drive->redraw();
     break;
     case 70:
     ovrd_level->value(rkr->efx_Overdrive->getpar(4));
     ovrd_level->redraw();
     break;
     case 71:
     dist_level->value(rkr->efx_Distorsion->getpar(4));
     dist_level->redraw();
     break;
     case 72:
     chorus_freq->value(rkr->efx_Chorus->getpar(2));
     chorus_freq->redraw();
     break;
     case 73:
     flanger_freq->value(rkr->efx_Flanger->getpar(2));
     flanger_freq->redraw();
     break;
     case 74:
     phaser_freq->value(rkr->efx_Phaser->getpar(2));
     phaser_freq->redraw();
     break;
     case 75:
     WhaWha_freq->value(rkr->efx_WhaWha->getpar(2));
     WhaWha_freq->redraw();
     break;
     case 76:
     Alienwah_freq->value(rkr->efx_Alienwah->getpar(2));
     Alienwah_freq->redraw();
     break;
     case 77:
     pan_freq->value(rkr->efx_Pan->getpar(2));
     pan_freq->redraw();
     break;
     case 78:
     echo_fb->value(rkr->efx_Echo->getpar(5));
     echo_fb->redraw();
     break;
     case 79:
     chorus_fb->value(rkr->efx_Chorus->getpar(8));
     chorus_fb->redraw();
     break;
     case 80:
     flanger_fb->value(rkr->efx_Flanger->getpar(8));
     flanger_fb->redraw();
     break;
     case 81:
     phaser_fb->value(rkr->efx_Phaser->getpar(7));
     phaser_fb->redraw();
     break;
     case 82:
     Alienwah_fb->value(rkr->efx_Alienwah->getpar(7));
     Alienwah_fb->redraw();
     break;
     case 83:
     musdelay_fb1->value(rkr->efx_MusDelay->getpar(5));
     musdelay_fb1->redraw();
     break;
     case 84:
     musdelay_fb2->value(rkr->efx_MusDelay->getpar(9));
     musdelay_fb2->redraw();
     break;
     case 85:
     ovrd_lpf->value(rkr->efx_Overdrive->getpar(7));
     ovrd_lpf->redraw();
     break;
     case 86:
     dist_lpf->value(rkr->efx_Distorsion->getpar(7));
     dist_lpf->redraw();
     break;
     case 87:
     reverb_LPF->value(rkr->efx_Rev->getpar(7));
     reverb_LPF->redraw();
     break;
     case 88:
     ovrd_hpf->value(rkr->efx_Overdrive->getpar(8));
     ovrd_hpf->redraw();
     break;
     case 89:
     dist_hpf->value(rkr->efx_Distorsion->getpar(8));
     dist_hpf->redraw();
     break;
     case 90:
     reverb_HPF->value(rkr->efx_Rev->getpar(8));
     reverb_HPF->redraw();
     break;
     case 91:
     chorus_LR->value(rkr->efx_Chorus->getpar(9)-64);
     chorus_LR->redraw();
     break;
     case 92:
     flanger_LR->value(rkr->efx_Flanger->getpar(9)-64);
     flanger_LR->redraw();
     break;
     case 93:
     phaser_LR->value(rkr->efx_Phaser->getpar(9)-64);
     phaser_LR->redraw();
     break;
     case 94:
     ovrd_LRc->value(rkr->efx_Overdrive->getpar(2)-64);
     ovrd_LRc->redraw();
     break;
     case 95:
     dist_LRc->value(rkr->efx_Distorsion->getpar(2)-64);
     dist_LRc->redraw();
     break;
     case 96:
     Alienwah_LR->value(rkr->efx_Alienwah->getpar(9)-64);
     Alienwah_LR->redraw();
     break;
     case 97:
     echo_LRc->value(rkr->efx_Echo->getpar(4)-64);
     echo_LRc->redraw();
     break;
     case 98:
     musdelay_LRc->value(rkr->efx_MusDelay->getpar(4)-64);
     musdelay_LRc->redraw();
     break;
     case 99:
     chorus_stdf->value(rkr->efx_Chorus->getpar(5));
     chorus_stdf->redraw();
     break;
     case 100:
     flanger_stdf->value(rkr->efx_Flanger->getpar(5));
     flanger_stdf->redraw();
     break;
     case 101:
     phaser_stdf->value(rkr->efx_Phaser->getpar(5));
     phaser_stdf->redraw();
     break;
     case 102:
     WhaWha_stdf->value(rkr->efx_WhaWha->getpar(5));
     WhaWha_stdf->redraw();
     break;
     case 103:
     Alienwah_stdf->value(rkr->efx_Alienwah->getpar(5));
     Alienwah_stdf->redraw();
     break;
     case 104:
     pan_stdf->value(rkr->efx_Pan->getpar(5));
     pan_stdf->redraw();
     break;
     case 105:
     chorus_rnd->value(rkr->efx_Chorus->getpar(3));
     chorus_rnd->redraw();
     break;
     case 106:
     flanger_rnd->value(rkr->efx_Flanger->getpar(3));
     flanger_rnd->redraw();
     break;
     case 107:
     phaser_rnd->value(rkr->efx_Phaser->getpar(3));
     phaser_rnd->redraw();
     break;
     case 108:
     WhaWha_rnd->value(rkr->efx_WhaWha->getpar(3));
     WhaWha_rnd->redraw();
     break;
     case 109:
     Alienwah_rnd->value(rkr->efx_Alienwah->getpar(3));
     Alienwah_rnd->redraw();
     break;
     case 110:
     pan_rnd->value(rkr->efx_Pan->getpar(3));
     pan_rnd->redraw();
     break;
     case 111:
     WhaWha_ampsns->value(rkr->efx_WhaWha->getpar(7));
     WhaWha_ampsns->redraw();
     break;
     case 112:
     WhaWha_ampsnsinv->value(rkr->efx_WhaWha->getpar(8));
     WhaWha_ampsnsinv->redraw();
     break;
     case 113:
     WhaWha_smooth->value(rkr->efx_WhaWha->getpar(9));
     WhaWha_smooth->redraw();
     break;
     case 114:
     phaser_phase->value(rkr->efx_Phaser->getpar(11));
     phaser_phase->redraw();
     break;
     case 115:
     Alienwah_phase->value(rkr->efx_Alienwah->getpar(10));
     Alienwah_phase->redraw();
     break;
     case 116:
     ActOnOff();
     break;
     case 117:
     aphaser_WD->value(rkr->efx_APhaser->getpar(0)-64);
     aphaser_WD->redraw();
     break;
     case 118:
     aphaser_pan->value(rkr->efx_APhaser->getpar(1));
     aphaser_pan->redraw();
     break;
     case 119:
     aphaser_freq->value(rkr->efx_APhaser->getpar(2));
     aphaser_freq->redraw();
     break;
     case 120:
     aphaser_phase->value(rkr->efx_APhaser->getpar(11));
     aphaser_phase->redraw();
     break;
     case 121:
     aphaser_dpth->value(rkr->efx_APhaser->getpar(6));
     aphaser_dpth->redraw();
     break;
     case 122:
     aphaser_fb->value(rkr->efx_APhaser->getpar(7)-64);
     aphaser_fb->redraw();
     break;
     case 123:
     aphaser_LR->value(rkr->efx_APhaser->getpar(9));
     aphaser_LR->redraw();
     break;
     case 124:
     aphaser_stdf->value(rkr->efx_APhaser->getpar(5));
     aphaser_stdf->redraw();
     break;
     case 125:
     newdist_WD->value(rkr->efx_NewDist->getpar(0)-64);
     newdist_WD->redraw();
     break;
     case 126:
     newdist_pan->value(rkr->efx_NewDist->getpar(1)-64);
     newdist_pan->redraw();
     break;
     case 127:
     newdist_LRc->value(rkr->efx_NewDist->getpar(2)-64);
     newdist_LRc->redraw();
     break;
     case 2:
     newdist_drive->value(rkr->efx_NewDist->getpar(3));
     newdist_drive->redraw();
     break;
     case 3:
     newdist_level->value(rkr->efx_NewDist->getpar(4));
     newdist_level->redraw();
     break;
     case 4:
     newdist_lpf->value(rkr->efx_NewDist->getpar(7));
     newdist_lpf->redraw();
     break;
     case 5:
     newdist_hpf->value(rkr->efx_NewDist->getpar(8));
     newdist_hpf->redraw();
     break;
     case 6:
     newdist_st->value(rkr->efx_NewDist->getpar(9));
     newdist_st->redraw();
     break;
     case 8:
     newdist_oct->value(rkr->efx_NewDist->getpar(11));
     newdist_oct->redraw();
     break;
     case 9:
     dist_oct->value(rkr->efx_NewDist->getpar(12));
     dist_oct->redraw();
     break;
     case 130:
     eq_Gain->value(rkr->efx_EQ1->getpar(0)-64);
     eq_Gain->redraw();
     break;
     case 131:
     eq_Q->value(rkr->efx_EQ1->getpar(13)-64);
     eq_Q->redraw();
     break;
     case 132:
     eq_1->value(rkr->efx_EQ1->getpar(12)-64);
     eq_1->redraw();
     break;
     case 133:
     eq_2->value(rkr->efx_EQ1->getpar(17)-64);
     eq_2->redraw();
     break;
     case 134:
     eq_3->value(rkr->efx_EQ1->getpar(22)-64);
     eq_3->redraw();
     break;
     case 135:
     eq_4->value(rkr->efx_EQ1->getpar(27)-64);
     eq_4->redraw();
     break;
     case 136:
     eq_5->value(rkr->efx_EQ1->getpar(32)-64);
     eq_5->redraw();
     break;
     case 137:
     eq_6->value(rkr->efx_EQ1->getpar(37)-64);
     eq_6->redraw();
     break;
     case 138:
     eq_7->value(rkr->efx_EQ1->getpar(42)-64);
     eq_7->redraw();
     break;
     case 139:
     eq_8->value(rkr->efx_EQ1->getpar(47)-64);
     eq_8->redraw();
     break;
     case 140:
     eq_9->value(rkr->efx_EQ1->getpar(52)-64);
     eq_9->redraw();
     break;
     case 141:
     eq_10->value(rkr->efx_EQ1->getpar(57)-64);
     eq_10->redraw();
     break;
     case 142:
     compress_ATime->value(rkr->efx_Compressor->getpar(4));
     compress_ATime->redraw();
     break;
     case 143:
     compress_RTime->value(rkr->efx_Compressor->getpar(5));
     compress_RTime->redraw();
     break;
     case 144:
     compress_Ratio->value(rkr->efx_Compressor->getpar(2));
     compress_Ratio->redraw();
     break;
     case 145:
     compress_Knee->value(rkr->efx_Compressor->getpar(7));
     compress_Knee->redraw();
     break;
     case 146:
     compress_threshold->value(rkr->efx_Compressor->getpar(1));
     compress_threshold->redraw();
     break;
     case 147:
     compress_output->value(rkr->efx_Compressor->getpar(3));
     compress_output->redraw();
     break;
     case 148:
     eqp_Gain->value(rkr->efx_EQ2->getpar(0)-64);
     eqp_Gain->redraw();
     break;
     case 149:
     eqp_LF->value(rkr->efx_EQ2->getpar(11));
     eqp_LF->redraw();
     break;
     case 150:
     eqp_LFg->value(rkr->efx_EQ2->getpar(12)-64);
     eqp_LFg->redraw();
     break;
     case 151:
     eqp_LQ->value(rkr->efx_EQ2->getpar(13)-64);
     eqp_LQ->redraw();
     break;	
     case 152:
     eqp_MF->value(rkr->efx_EQ2->getpar(16));
     eqp_MF->redraw();
     break;
     case 153:
     eqp_MFg->value(rkr->efx_EQ2->getpar(17)-64);
     eqp_MFg->redraw();
     break;
     case 154:
     eqp_MQ->value(rkr->efx_EQ2->getpar(18)-64);
     eqp_MQ->redraw();
     break;
     case 155:
     eqp_HF->value(rkr->efx_EQ2->getpar(21));
     eqp_HF->redraw();
     break;
     case 156:
     eqp_HFg->value(rkr->efx_EQ2->getpar(22)-64);
     eqp_HFg->redraw();
     break;
     case 157:
     eqp_HQ->value(rkr->efx_EQ2->getpar(23)-64);
     eqp_HQ->redraw();
     break;
     case 158:
     dflange_WD->value(rkr->efx_DFlange->getpar(0));
     dflange_WD->redraw();
     break;
     case 159:
     dflange_pan->value(rkr->efx_DFlange->getpar(1));
     dflange_pan->redraw();
     break;
     case 160:
     dflange_LR->value(rkr->efx_DFlange->getpar(2));
     dflange_LR->redraw();
     break;
     case 161:
     dflange_depth->value(rkr->efx_DFlange->getpar(3));
     dflange_depth->redraw();
     break;
     case 162:
     dflange_width->value(rkr->efx_DFlange->getpar(4));
     dflange_width->redraw();
     break;
     case 163:
     dflange_offset->value(rkr->efx_DFlange->getpar(5));
     dflange_offset->redraw();
     break;
     case 164:
     dflange_fb->value(rkr->efx_DFlange->getpar(6));
     dflange_fb->redraw();
     break;
     case 165:
     dflange_lpf->value(rkr->efx_DFlange->getpar(7));
     dflange_lpf->redraw();
     break;
     case 166:
     dflange_freq->value(rkr->efx_DFlange->getpar(10));
     dflange_freq->redraw();
     break;
     case 167:
     dflange_stdf->value(rkr->efx_DFlange->getpar(11));
     dflange_stdf->redraw();
     break;
     case 168:
     dflange_rnd->value(rkr->efx_DFlange->getpar(13));
     dflange_rnd->redraw();
     break;
     case 169:
     valve_WD->value(rkr->efx_Valve->getpar(0)-64);
     valve_WD->redraw();
     break;
     case 170:
     valve_LRc->value(rkr->efx_Valve->getpar(2)-64);
     valve_LRc->redraw();
     break;
     case 171:
     valve_pan->value(rkr->efx_Valve->getpar(1)-64);
     valve_pan->redraw();
     break;
     case 172:
     valve_level->value(rkr->efx_Valve->getpar(4));
     valve_level->redraw();
     break;
     case 173:
     valve_drive->value(rkr->efx_Valve->getpar(3));
     valve_drive->redraw();
     break;
     case 174:
     valve_Q->value(rkr->efx_Valve->getpar(10));
     valve_Q->redraw();
     break;
     case 175:
     valve_Pre->value(rkr->efx_Valve->getpar(12));
     valve_Pre->redraw();
     break;
     case 176:
     valve_lpf->value(rkr->efx_Valve->getpar(6));
     valve_lpf->redraw();
     break;
     case 177:
     valve_hpf->value(rkr->efx_Valve->getpar(7));
     valve_hpf->redraw();
     break;
     case 178:
     ring_WD->value(rkr->efx_Ring->getpar(0));
     ring_WD->redraw();
     break;  
     case 179:
     ring_LRc->value(rkr->efx_Ring->getpar(2));
     ring_LRc->redraw();
     break;  
     case 180:
     ring_input->value(rkr->efx_Ring->getpar(11));
     ring_input->redraw();
     break;  
     case 181:
     ring_level->value(rkr->efx_Ring->getpar(3));
     ring_level->redraw();
     break;  
     case 182:
     ring_pan->value(rkr->efx_Ring->getpar(1));
     ring_pan->redraw();
     break;  
     case 183:
     ring_depth->value(rkr->efx_Ring->getpar(4));
     ring_depth->redraw();
     break;  
     case 184:
     ring_freq->value(rkr->efx_Ring->getpar(5));
     ring_freq->redraw();
     break;  
     case 185:
     ring_sin->value(rkr->efx_Ring->getpar(7));
     ring_sin->redraw();
     break;  
     case 186:
     ring_tri->value(rkr->efx_Ring->getpar(8));
     ring_tri->redraw();
     break;  
     case 187:
     ring_saw->value(rkr->efx_Ring->getpar(9));
     ring_saw->redraw();
     break;  
     case 188:
     ring_squ->value(rkr->efx_Ring->getpar(10));
     ring_squ->redraw();
     break;  
     case 189:
     ex_Gain->value(rkr->efx_Exciter->getpar(0));
     ex_Gain->redraw();
     break;
     case 190:
     ex_hfreq->value(rkr->efx_Exciter->getpar(11));
     ex_hfreq->redraw();
     break;
     case 191:
     ex_lfreq->value(rkr->efx_Exciter->getpar(12));
     ex_lfreq->redraw();
     break;
     case 192:
     ex_1->value(rkr->efx_Exciter->getpar(1));
     ex_1->redraw();
     break;
     case 193:
     ex_2->value(rkr->efx_Exciter->getpar(2));
     ex_2->redraw();
     break;
     case 194:
     ex_3->value(rkr->efx_Exciter->getpar(3));
     ex_3->redraw();
     break;
     case 195:
     ex_4->value(rkr->efx_Exciter->getpar(4));
     ex_4->redraw();
     break;
     case 196:
     ex_5->value(rkr->efx_Exciter->getpar(5));
     ex_5->redraw();
     break;
     case 197:
     ex_6->value(rkr->efx_Exciter->getpar(6));
     ex_6->redraw();
     break;
     case 198:
     ex_7->value(rkr->efx_Exciter->getpar(7));
     ex_7->redraw();
     break;
     case 199:
     ex_8->value(rkr->efx_Exciter->getpar(8));
     ex_8->redraw();
     break;
     case 200:
     ex_9->value(rkr->efx_Exciter->getpar(9));
     ex_9->redraw();
     break;
     case 201:
     ex_10->value(rkr->efx_Exciter->getpar(10));
     ex_10->redraw();
     break;
     case 202:
     mbdist_WD->value(rkr->efx_MBDist->getpar(0)-64);
     mbdist_WD->redraw();
     break;
     case 203:
     mbdist_LRc->value(rkr->efx_MBDist->getpar(2)-64);
     mbdist_LRc->redraw();
     break;
     case 204:
     mbdist_drive->value(rkr->efx_MBDist->getpar(3));
     mbdist_drive->redraw();
     break;
     case 205:
     mbdist_level->value(rkr->efx_MBDist->getpar(4));
     mbdist_level->redraw();
     break;
     case 206:
     mbdist_volL->value(rkr->efx_MBDist->getpar(8));
     mbdist_volL->redraw();
     break;
     case 207:
     mbdist_volM->value(rkr->efx_MBDist->getpar(9));
     mbdist_volM->redraw();
     break;
     case 208:
     mbdist_volH->value(rkr->efx_MBDist->getpar(10));
     mbdist_volH->redraw();
     break;
     case 209:
     mbdist_cross1->value(rkr->efx_MBDist->getpar(12));
     mbdist_cross1->redraw();
     break;
     case 210:
     mbdist_cross2->value(rkr->efx_MBDist->getpar(13));
     mbdist_cross2->redraw();
     break;
     case 211:
     mbdist_pan->value(rkr->efx_MBDist->getpar(1)-64);
     mbdist_pan->redraw();
     break;
     case 212:
     arpie_WD->value(rkr->efx_Arpie->getpar(0));
     arpie_WD->redraw();
     break; 	
     case 213:
     arpie_arpe->value(rkr->efx_Arpie->getpar(7));
     arpie_arpe->redraw();
     break; 	
     case 214:
     arpie_pan->value(rkr->efx_Arpie->getpar(1));
     arpie_pan->redraw();
     break; 	
     case 215:
     arpie_delay->value(rkr->efx_Arpie->getpar(2));
     arpie_delay->redraw();
     break; 	
     case 216:
     arpie_LRdl->value(rkr->efx_Arpie->getpar(3));
     arpie_LRdl->redraw();
     break; 	
     case 217:
     arpie_LRc->value(rkr->efx_Arpie->getpar(4));
     arpie_LRc->redraw();
     break; 	
     case 218:
     arpie_fb->value(rkr->efx_Arpie->getpar(5));
     arpie_fb->redraw();
     break; 	
     case 219:
     arpie_damp->value(rkr->efx_Arpie->getpar(6));
     arpie_damp->redraw();
     break; 	
     case 220:
     expander_ATime->value(rkr->efx_Expander->getpar(3));
     expander_ATime->redraw();
     break;
     case 221:
     expander_RTime->value(rkr->efx_Expander->getpar(4));
     expander_RTime->redraw();
     break;
     case 222:
     expander_shape->value(rkr->efx_Expander->getpar(2));
     expander_shape->redraw();
     break;
     case 223:
     expander_threshold->value(rkr->efx_Expander->getpar(1));
     expander_threshold->redraw();
     break;
     case 224:
     expander_level->value(rkr->efx_Expander->getpar(7));
     expander_level->redraw();
     break;
     case 225:
     expander_LPF->value(rkr->efx_Expander->getpar(5));
     expander_LPF->redraw();
     break;
     case 226:
     expander_HPF->value(rkr->efx_Expander->getpar(6));
     expander_HPF->redraw();
     break;
     case 227:
     shuffle_WD->value(rkr->efx_Shuffle->getpar(0)-64);
     shuffle_WD->redraw();
     break;
     case 228:
     shuffle_cross1->value(rkr->efx_Shuffle->getpar(5));
     shuffle_cross1->redraw();
     break; 
     case 229:
     shuffle_volL->value(rkr->efx_Shuffle->getpar(1));
     shuffle_volL->redraw();
     break; 
     case 230:
     shuffle_cross2->value(rkr->efx_Shuffle->getpar(6));
     shuffle_cross2->redraw();
     break; 
     case 231:
     shuffle_volML->value(rkr->efx_Shuffle->getpar(2));
     shuffle_volML->redraw();
     break; 
     case 232:
     shuffle_cross3->value(rkr->efx_Shuffle->getpar(7));
     shuffle_cross3->redraw();
     break; 
     case 233:
     shuffle_volMH->value(rkr->efx_Shuffle->getpar(3));
     shuffle_volMH->redraw();
     break; 
     case 234:
     shuffle_cross4->value(rkr->efx_Shuffle->getpar(8));
     shuffle_cross4->redraw();
     break; 
     case 235:
     shuffle_volH->value(rkr->efx_Shuffle->getpar(4));
     shuffle_volH->redraw();
     break; 
     case 236:
     shuffle_Q->value(rkr->efx_Shuffle->getpar(9));
     shuffle_Q->redraw();
     break; 
     case 237:
     synthfilter_WD->value(rkr->efx_Synthfilter->getpar(0)-64);
     synthfilter_WD->redraw();
     break;
     case 238:
     synthfilter_Distort->value(rkr->efx_Synthfilter->getpar(1));
     synthfilter_Distort->redraw();
     break;
     case 239:
     synthfilter_freq->value(rkr->efx_Synthfilter->getpar(2));
     synthfilter_freq->redraw();
     break;
     case 240:
     synthfilter_stdf->value(rkr->efx_Synthfilter->getpar(5));
     synthfilter_stdf->redraw();
     break;
     case 241:
     synthfilter_width->value(rkr->efx_Synthfilter->getpar(6));
     synthfilter_width->redraw();
     break;
     case 242:
     synthfilter_fb->value(rkr->efx_Synthfilter->getpar(7));
     synthfilter_fb->redraw();
     break;
     case 243:
     synthfilter_dpth->value(rkr->efx_Synthfilter->getpar(11));
     synthfilter_dpth->redraw();
     break;
     case 244:
     synthfilter_EnvSens->value(rkr->efx_Synthfilter->getpar(12));
     synthfilter_EnvSens->redraw();
     break;
     case 245:
     synthfilter_ATime->value(rkr->efx_Synthfilter->getpar(13));
     synthfilter_ATime->redraw();
     break;
     case 246:
     synthfilter_RTime->value(rkr->efx_Synthfilter->getpar(14));
     synthfilter_RTime->redraw();
     break;
     case 247:
     synthfilter_Offset->value(rkr->efx_Synthfilter->getpar(15));
     synthfilter_Offset->redraw();
     break;
     case 248:
     mbvvol_WD->value(rkr->efx_MBVvol->getpar(0)-64);
     mbvvol_WD->redraw();
     break;
     case 249:
     mbvvol_freq1->value(rkr->efx_MBVvol->getpar(1));
     mbvvol_freq1->redraw();
     break;
     case 250:
     mbvvol_stdf1->value(rkr->efx_MBVvol->getpar(3));
     mbvvol_stdf1->redraw();
     break;
     case 251:
     mbvvol_freq2->value(rkr->efx_MBVvol->getpar(4));
     mbvvol_freq2->redraw();
     break;
     case 252:
     mbvvol_stdf2->value(rkr->efx_MBVvol->getpar(6));
     mbvvol_stdf2->redraw();
     break;
     case 253:
     mbvvol_cross1->value(rkr->efx_MBVvol->getpar(7));
     mbvvol_cross1->redraw();
     break;
     case 254:
     mbvvol_cross2->value(rkr->efx_MBVvol->getpar(8));
     mbvvol_cross2->redraw();
     break;
     case 255:
     mbvvol_cross3->value(rkr->efx_MBVvol->getpar(9));
     mbvvol_cross3->redraw();
     break;
     case 256:
     ryanwah_WD->value(rkr->efx_RyanWah->getpar(0)-64);
     ryanwah_WD->redraw();
     break;
     case 257:
     ryanwah_lp->value(rkr->efx_RyanWah->getpar(10));
     ryanwah_lp->redraw();
     break;
     case 258:
     ryanwah_bp->value(rkr->efx_RyanWah->getpar(11));
     ryanwah_bp->redraw();
     break;
     case 259:
     ryanwah_hp->value(rkr->efx_RyanWah->getpar(12));
     ryanwah_hp->redraw();
     break;
     case 260:
     ryanwah_dpth->value(rkr->efx_RyanWah->getpar(6));
     ryanwah_dpth->redraw();
     break;
     case 261:
     ryanwah_freq->value(rkr->efx_RyanWah->getpar(2));
     ryanwah_freq->redraw();
     break;
     case 262:
     ryanwah_q->value(rkr->efx_RyanWah->getpar(1));
     ryanwah_q->redraw();
     break;
     case 263:
     ryanwah_rng->value(rkr->efx_RyanWah->getpar(14));
     ryanwah_rng->redraw();
     break;
     case 264:
     ryanwah_ampsnsinv->value(rkr->efx_RyanWah->getpar(8));
     ryanwah_ampsnsinv->redraw();
     break;
     case 265:
     ryanwah_ampsns->value(rkr->efx_RyanWah->getpar(7));
     ryanwah_ampsns->redraw();
     break;
     case 266:
     ryanwah_smooth->value(rkr->efx_RyanWah->getpar(9));
     ryanwah_smooth->redraw();
     break;
     case 267:
     looper_WD->value(rkr->efx_Looper->getpar(0)-64);
     looper_WD->redraw();
     break;
     case 268:
     looper_level1->value(rkr->efx_Looper->getpar(6));
     looper_level1->redraw();
     break; 
     case 269:
     looper_level2->value(rkr->efx_Looper->getpar(10));
     looper_level2->redraw();
     break; 
     case 270:
     looper_rv->value(rkr->efx_Looper->getpar(5));
     looper_rv->redraw();
     break;
     case 271:
     looper_ap->value(rkr->efx_Looper->getpar(9));
     looper_ap->redraw();
     break;
     case 272:
     looper_play->value(rkr->efx_Looper->getpar(1));
     update_looper();
     break;
     case 273:
     looper_stop->value(rkr->efx_Looper->getpar(2));
     update_looper();
     break;
     case 274:
     looper_record->value(rkr->efx_Looper->getpar(3));
     update_looper();
     break;
     case 275:
     looper_r1->value(rkr->efx_Looper->getpar(11));
     looper_r1->redraw();
     break;
     case 276:
     looper_r2->value(rkr->efx_Looper->getpar(12));
     looper_r2->redraw();
     break;
     case 277:
     looper_t1->value(rkr->efx_Looper->getpar(7));
     update_looper();
     break;
     case 278:
     looper_t2->value(rkr->efx_Looper->getpar(8));
     update_looper();
     break;
     case 279:
     looper_clear->value(rkr->efx_Looper->getpar(4));
     update_looper();
     break;
     case 280:
     convo_WD->value(rkr->efx_Convol->getpar(0)-64);
     convo_WD->redraw();
     break;
     case 281:
     convo_pan->value(rkr->efx_Convol->getpar(1)-64);
     convo_pan->redraw();
     break;
     case 282:
     convo_level->value(rkr->efx_Convol->getpar(7));
     convo_level->redraw();
     break;
     case 283:
     convo_damp->value(rkr->efx_Convol->getpar(6));
     convo_damp->redraw();
     break;
     case 284:
     convo_fb->value(rkr->efx_Convol->getpar(10));
     convo_fb->redraw();
     break;
     case 285:
     convo_length->value(rkr->efx_Convol->getpar(3));
     convo_length->redraw();
     break;
     case 286:
     coil_WD->value(rkr->efx_CoilCrafter->getpar(0));
     coil_WD->redraw();
     break;
     case 287:
     coil_tone->value(rkr->efx_CoilCrafter->getpar(7));
     coil_tone->redraw();
     break;
     case 288:
     coil_freq1->value(rkr->efx_CoilCrafter->getpar(3));
     coil_freq1->redraw();
     break;
     case 289:
     coil_q1->value(rkr->efx_CoilCrafter->getpar(4));
     coil_q1->redraw();
     break;
     case 290:
     coil_freq2->value(rkr->efx_CoilCrafter->getpar(5));
     coil_freq2->redraw();
     break;
     case 291:
     coil_q2->value(rkr->efx_CoilCrafter->getpar(6));
     coil_q2->redraw();
     break;
     case 292:
     shelf_gain->value(rkr->efx_ShelfBoost->getpar(0));
     shelf_gain->redraw();     
     break;
     case 293:
     shelf_level->value(rkr->efx_ShelfBoost->getpar(4));
     shelf_level->redraw();     
     break;
     case 294:
     shelf_freq1->value(rkr->efx_ShelfBoost->getpar(2));
     shelf_freq1->redraw();     
     break;
     case 295:
     shelf_q1->value(rkr->efx_ShelfBoost->getpar(1));
     shelf_q1->redraw();     
     break;
     case 296:
     vo_WD->value(rkr->efx_Vocoder->getpar(0)-64); 
     vo_WD->redraw();
     break;
     case 297:
     vo_pan->value(rkr->efx_Vocoder->getpar(1)-64); 
     vo_pan->redraw();
     break;
     case 298:
     vo_input->value(rkr->efx_Vocoder->getpar(4)); 
     vo_input->redraw();
     break;
     case 299:
     vo_mu->value(rkr->efx_Vocoder->getpar(2)); 
     vo_mu->redraw();
     break;
     case 300:
     vo_q->value(rkr->efx_Vocoder->getpar(3)); 
     vo_q->redraw();
     break;
     case 301:
     vo_ring->value(rkr->efx_Vocoder->getpar(6)); 
     vo_ring->redraw();
     break;
     case 302:
     vo_level->value(rkr->efx_Vocoder->getpar(5)); 
     vo_level->redraw();
     break;
     case 303:
     rbecho_WD->value(rkr->efx_RBEcho->getpar(0)-64);
     rbecho_WD->redraw();
     break;
     case 304:
     rbecho_RV->value(rkr->efx_RBEcho->getpar(7));
     rbecho_RV->redraw();
     break;
     case 305:
     rbecho_pan->value(rkr->efx_RBEcho->getpar(1)-64);
     rbecho_pan->redraw();
     break;
     case 306:
     rbecho_delay->value(rkr->efx_RBEcho->getpar(2));
     rbecho_delay->redraw();
     break;
     case 307:
     rbecho_LRdl->value(rkr->efx_RBEcho->getpar(3));
     rbecho_LRdl->redraw();
     break;
     case 308:
     rbecho_fb->value(rkr->efx_RBEcho->getpar(5));
     rbecho_fb->redraw();
     break;
     case 309:
     rbecho_damp->value(rkr->efx_RBEcho->getpar(6));
     rbecho_damp->redraw();
     break;
     case 310:
     rbecho_es->value(rkr->efx_RBEcho->getpar(9));
     rbecho_es->redraw();
     break;
     case 311:
     rbecho_angle->value(rkr->efx_RBEcho->getpar(4)-64);
     rbecho_angle->redraw();
     break;
     case 312:
     sus_gain->value(rkr->efx_Sustainer->getpar(0));
     sus_gain->redraw();
     break;
     case 313:
     sus_sus->value(rkr->efx_Sustainer->getpar(1));
     sus_sus->redraw();
     break;
     case 314:
     seq_WD->value(rkr->efx_Sequence->getpar(8)-64);
     seq_WD->redraw();
     break;
     case 315:
     seq_1->value(rkr->efx_Sequence->getpar(0));
     seq_1->redraw();
     break;
     case 316:
     seq_2->value(rkr->efx_Sequence->getpar(1));
     seq_2->redraw();
     break;
     case 317:
     seq_3->value(rkr->efx_Sequence->getpar(2));
     seq_3->redraw();
     break;
     case 318:
     seq_4->value(rkr->efx_Sequence->getpar(3));
     seq_4->redraw();
     break;
     case 319:
     seq_5->value(rkr->efx_Sequence->getpar(4));
     seq_5->redraw();
     break;
     case 320:
     seq_6->value(rkr->efx_Sequence->getpar(5));
     seq_6->redraw();
     break;
     case 321:
     seq_7->value(rkr->efx_Sequence->getpar(6));
     seq_7->redraw();
     break;
     case 322:
     seq_8->value(rkr->efx_Sequence->getpar(7));
     seq_8->redraw();
     break;
     case 323:
     seq_tempo->value(rkr->efx_Sequence->getpar(9));
     seq_tempo->redraw();
     break;
     case 324:
     seq_q->value(rkr->efx_Sequence->getpar(10)-64);
     seq_q->redraw();
     break;
     case 325:
     seq_stdf->value(rkr->efx_Sequence->getpar(12));
     seq_stdf->redraw();
     break;
     case 326:
     shifter_WD->value(rkr->efx_Shifter->getpar(0)-64);
     shifter_WD->redraw();
     break;
     case 327:
     shifter_int->value(rkr->efx_Shifter->getpar(6));
     shifter_int->redraw();
     break;
     case 328:
     shifter_gain->value(rkr->efx_Shifter->getpar(2)-64);
     shifter_gain->redraw();
     break;
     case 329:
     shifter_pan->value(rkr->efx_Shifter->getpar(1)-64);
     shifter_pan->redraw();
     break;
     case 330:
     shifter_attack->value(rkr->efx_Shifter->getpar(3));
     shifter_attack->redraw();
     break;
     case 331:
     shifter_decay->value(rkr->efx_Shifter->getpar(4));
     shifter_decay->redraw();
     break;
     case 332:
     shifter_thre->value(rkr->efx_Shifter->getpar(5));
     shifter_thre->redraw();
     break;
     case 333:
     shifter_whammy->value(rkr->efx_Shifter->getpar(9));
     shifter_whammy->redraw();
     break;
     case 334:
     stomp_WD->value(rkr->efx_StompBox->getpar(0));
     stomp_WD->redraw();
     break;
     case 335:
     stomp_gain->value(rkr->efx_StompBox->getpar(4));
     stomp_gain->redraw();
     break;
     case 336:
     stomp_low->value(rkr->efx_StompBox->getpar(3)-64);
     stomp_low->redraw();
     break;
     case 337:
     stomp_mid->value(rkr->efx_StompBox->getpar(2)-64);
     stomp_mid->redraw();
     break;
     case 338:
     stomp_high->value(rkr->efx_StompBox->getpar(1)-64);
     stomp_high->redraw();
     break;
     case 339:
     revtron_WD->value(rkr->efx_Reverbtron->getpar(0)-64);
     revtron_WD->redraw();
     break;
     case 340:
     revtron_pan->value(rkr->efx_Reverbtron->getpar(11)-64);
     revtron_pan->redraw();
     break;
     case 341:
     revtron_level->value(rkr->efx_Reverbtron->getpar(7));
     revtron_level->redraw();
     break;
     case 342:
     revtron_damp->value(rkr->efx_Reverbtron->getpar(6));
     revtron_damp->redraw();
     break;
     case 343:
     revtron_fb->value(rkr->efx_Reverbtron->getpar(10)-64);
     revtron_fb->redraw();
     break;
     case 344:
     revtron_length->value(rkr->efx_Reverbtron->getpar(3));
     revtron_length->redraw();
     break;
     case 345:
     revtron_strech->value(rkr->efx_Reverbtron->getpar(9)-64);
     revtron_strech->redraw();
     break;
     case 346:
     revtron_idelay->value(rkr->efx_Reverbtron->getpar(5));
     revtron_idelay->redraw();
     break;
     case 347:
     revtron_fade->value(rkr->efx_Reverbtron->getpar(1));
     revtron_fade->redraw();
     break;
     case 348:
     echotron_WD->value(rkr->efx_Echotron->getpar(0)-64);
     echotron_WD->redraw();
     break;
     case 349:
     echotron_pan->value(rkr->efx_Echotron->getpar(11)-64);
     echotron_pan->redraw();
     break;
     case 350:
     echotron_tempo->value(rkr->efx_Echotron->getpar(5));
     echotron_tempo->redraw();
     break;
     case 351:
     echotron_damp->value(rkr->efx_Echotron->getpar(6));
     echotron_damp->redraw();
     break;
     case 352:
     echotron_fb->value(rkr->efx_Echotron->getpar(10)-64);
     echotron_fb->redraw();
     break;
     case 353:
     echotron_lrcross->value(rkr->efx_Echotron->getpar(7)-64);
     echotron_lrcross->redraw();
     break;
     case 354:
     echotron_width->value(rkr->efx_Echotron->getpar(2));
     echotron_width->redraw();
     break;
     case 355:
     echotron_deep->value(rkr->efx_Echotron->getpar(1)-64);
     echotron_deep->redraw();
     break;
     case 356:
     echotron_stdf->value(rkr->efx_Echotron->getpar(9));
     echotron_stdf->redraw();
     break;
     case 357:
     echotron_length->value(rkr->efx_Echotron->getpar(3));
     echotron_length->redraw();
     break;
     case 358:
     shar_WD->value(rkr->efx_StereoHarm->getpar(0)-64);
     shar_WD->redraw();
     break;
     case 359:
     shar_intl->value(rkr->efx_StereoHarm->getpar(2));
     shar_intl->redraw();
     break;
     case 360:
     shar_chl->value(rkr->efx_StereoHarm->getpar(3));
     shar_chl->redraw();
     break;
     case 361:
     shar_ganl->value(rkr->efx_StereoHarm->getpar(1)-64);
     shar_ganl->redraw();
     break;
     case 362:
     shar_intr->value(rkr->efx_StereoHarm->getpar(5));
     shar_intr->redraw();
     break;
     case 363:
     shar_chr->value(rkr->efx_StereoHarm->getpar(6));
     shar_chr->redraw();
     break;
     case 364:
     shar_ganr->value(rkr->efx_StereoHarm->getpar(4)-64);
     shar_ganr->redraw();
     break;
     case 365:
     shar_lrc->value(rkr->efx_StereoHarm->getpar(11)-64);
     shar_lrc->redraw();
     break;
     case 366:
     shar_note->value(rkr->efx_StereoHarm->getpar(8));
     shar_note->redraw();
     Chord(1);
     break;
     case 367:
     shar_type->value(rkr->efx_StereoHarm->getpar(9));
     shar_type->redraw();
     Chord(1);
     break;
     case 368:
     cband_WD->value(rkr->efx_CompBand->getpar(0)-64);
     cband_WD->redraw();
     break;
     case 369:
     cband_gain->value(rkr->efx_CompBand->getpar(12));
     cband_gain->redraw();
     break;
     case 370:
     cband_Lratio->value(rkr->efx_CompBand->getpar(1));
     cband_Lratio->redraw();
     break;
     case 371:
     cband_MLratio->value(rkr->efx_CompBand->getpar(2));
     cband_MLratio->redraw();
     break;
     case 372:
     cband_MHratio->value(rkr->efx_CompBand->getpar(3));
     cband_MHratio->redraw();
     break;
     case 373:
     cband_Hratio->value(rkr->efx_CompBand->getpar(4));
     cband_Hratio->redraw();
     break;
     case 374:
     cband_Lthres->value(rkr->efx_CompBand->getpar(5));
     cband_Lthres->redraw();
     break;
     case 375:
     cband_MLthres->value(rkr->efx_CompBand->getpar(6));
     cband_MLthres->redraw();
     break;
     case 376:
     cband_MHthres->value(rkr->efx_CompBand->getpar(7));
     cband_MHthres->redraw();
     break;
     case 377:
     cband_Hthres->value(rkr->efx_CompBand->getpar(8));
     cband_Hthres->redraw();
     break;
     case 378:
     cband_cross1->value(rkr->efx_CompBand->getpar(9));
     cband_cross1->redraw();
     break;
     case 379:
     cband_cross2->value(rkr->efx_CompBand->getpar(10));
     cband_cross2->redraw();
     break;
     case 380:
     cband_cross3->value(rkr->efx_CompBand->getpar(11));
     cband_cross3->redraw();
     break;
     case 381:
     otrem_dpth->value(rkr->efx_Opticaltrem->getpar(0));
     otrem_dpth->redraw();
     break;
     case 382:
     otrem_freq->value(rkr->efx_Opticaltrem->getpar(1));
     otrem_freq->redraw();
     break;
     case 383:
     otrem_rnd->value(rkr->efx_Opticaltrem->getpar(2));
     otrem_rnd->redraw();
     break;
     case 384:
     otrem_stdf->value(rkr->efx_Opticaltrem->getpar(4));
     otrem_stdf->redraw();
     break;
     case 385:
     otrem_pan->value(rkr->efx_Opticaltrem->getpar(5)-64);
     otrem_pan->redraw();
     break;
     case 386:
     vibe_WD->value(rkr->efx_Vibe->getpar(6)-64);
     vibe_WD->redraw();
     break;
     case 387:
     vibe_width->value(rkr->efx_Vibe->getpar(0));
     vibe_width->redraw();
     break;
     case 388:
     vibe_dpth->value(rkr->efx_Vibe->getpar(8));
     vibe_dpth->redraw();
     break;
     case 389:
     vibe_freq->value(rkr->efx_Vibe->getpar(1));
     vibe_freq->redraw();
     break;
     case 390:
     vibe_rnd->value(rkr->efx_Vibe->getpar(2));
     vibe_rnd->redraw();
     break;
     case 391:
     vibe_stdf->value(rkr->efx_Vibe->getpar(4));
     vibe_stdf->redraw();
     break;
     case 392:
     vibe_fb->value(rkr->efx_Vibe->getpar(7)-64);
     vibe_fb->redraw();
     break;
     case 393:
     vibe_LR->value(rkr->efx_Vibe->getpar(9)-64);
     vibe_LR->redraw();
     break;
     case 394:
     vibe_pan->value(rkr->efx_Vibe->getpar(6)-64);
     vibe_pan->redraw();
     break;
       	
     
      
}


}


rkr->Mvalue=0;
}

void RKRGUI::ActOnOff() {
  int miralo;


while(rkr->OnOffC>0)
{


if(rkr->Mnumeff[rkr->OnOffC] >2000) miralo = rkr->Mnumeff[rkr->OnOffC]-2000;
else
if(rkr->Mnumeff[rkr->OnOffC] >=1000) miralo=rkr->Mnumeff[rkr->OnOffC]-1000;
else
miralo = rkr->efx_order[rkr->Mnumeff[rkr->OnOffC]];

switch(miralo)
{
  case 0:
  eq_activar->value(rkr->EQ1_Bypass);
  eq_activar->do_callback();
  break;
  case 1:
  compress_activar->value(rkr->Compressor_Bypass);
  compress_activar->do_callback();
  break;
  case 2:
  dist_activar->value(rkr->Distorsion_Bypass);
  dist_activar->do_callback();
  break;
  case 3:
  ovrd_activar->value(rkr->Overdrive_Bypass);
  ovrd_activar->do_callback();
  break;
  case 4:
  echo_activar->value(rkr->Echo_Bypass);
  echo_activar->do_callback();
  break;
  case 5:
  chorus_activar->value(rkr->Chorus_Bypass);
  chorus_activar->do_callback();
  break;
  case 6:
  phaser_activar->value(rkr->Phaser_Bypass);
  phaser_activar->do_callback();
  break;
  case 7:
  flanger_activar->value(rkr->Flanger_Bypass);
  flanger_activar->do_callback();
  break;
  case 8:
  reverb_activar->value(rkr->Reverb_Bypass);
  reverb_activar->do_callback();
  break;
  case 9:
  eqp_activar->value(rkr->EQ2_Bypass);
  eqp_activar->do_callback();
  break;
  case 10:
  WhaWha_activar->value(rkr->WhaWha_Bypass);
  WhaWha_activar->do_callback();
  break;
  case 11:
  Alienwah_activar->value(rkr->Alienwah_Bypass);
  Alienwah_activar->do_callback();
  break;
  case 12:
  Cabinet_activar->value(rkr->Cabinet_Bypass);
  Cabinet_activar->do_callback();
  break;
  case 13:
  pan_activar->value(rkr->Pan_Bypass);
  pan_activar->do_callback();
  break;
  case 14:
  har_activar->value(rkr->Harmonizer_Bypass);
  har_activar->do_callback();
  break;
  case 15:
  musdelay_activar->value(rkr->MusDelay_Bypass);
  musdelay_activar->do_callback();
  break;
  case 16:
  gate_activar->value(rkr->Gate_Bypass);
  gate_activar->do_callback();
  break;
  case 17:
  newdist_activar->value(rkr->NewDist_Bypass);
  newdist_activar->do_callback();
  break;
  case 18:
  aphaser_activar->value(rkr->APhaser_Bypass);
  aphaser_activar->do_callback();
  break;
  case 19:
  valve_activar->value(rkr->Valve_Bypass);
  valve_activar->do_callback();
  break;
  case 20:
  dflange_activar->value(rkr->DFlange_Bypass);
  dflange_activar->do_callback();
  break;
  case 21:
  ring_activar->value(rkr->Ring_Bypass);
  ring_activar->do_callback();
  break;
  case 22:
  exciter_activar->value(rkr->Exciter_Bypass);
  exciter_activar->do_callback();
  break;
  case 23:
  mbdist_activar->value(rkr->MBDist_Bypass);
  mbdist_activar->do_callback();
  break;
  case 24:
  arpie_activar->value(rkr->Arpie_Bypass);
  arpie_activar->do_callback();
  break;
  case 25:
  expander_activar->value(rkr->Expander_Bypass);
  expander_activar->do_callback();
  break;
  case 26:
  shuffle_activar->value(rkr->Shuffle_Bypass);
  shuffle_activar->do_callback();
  break;
  case 27:
  synthfilter_activar->value(rkr->Synthfilter_Bypass);
  synthfilter_activar->do_callback();
  break;
  case 28:
  mbvvol_activar->value(rkr->MBVvol_Bypass);
  mbvvol_activar->do_callback();
  break;
  case 29:
  convo_activar->value(rkr->Convol_Bypass);
  convo_activar->do_callback();
  break;
  case 30:
  looper_activar->value(rkr->Looper_Bypass);
  looper_activar->do_callback();
  break;
  case 31:
  ryanwah_activar->value(rkr->RyanWah_Bypass);
  ryanwah_activar->do_callback();
  break;  
  case 32:
  rbecho_activar->value(rkr->RBEcho_Bypass);
  rbecho_activar->do_callback();
  break;
  case 33:
  coil_activar->value(rkr->CoilCrafter_Bypass);
  coil_activar->do_callback();
  break;
  case 34:
  shelf_activar->value(rkr->ShelfBoost_Bypass);
  shelf_activar->do_callback();
  break;
  case 35:
  vo_activar->value(rkr->Vocoder_Bypass);
  vo_activar->do_callback();
  break;
  case 36:
  sus_activar->value(rkr->Sustainer_Bypass);
  sus_activar->do_callback();
  break;
  case 37:
  seq_activar->value(rkr->Sequence_Bypass);
  seq_activar->do_callback();
  break;
 case 38:
  shifter_activar->value(rkr->Shifter_Bypass);
  shifter_activar->do_callback();
  break;
 case 39:
  stomp_activar->value(rkr->StompBox_Bypass);
  stomp_activar->do_callback();
  break;
 case 40:
  revtron_activar->value(rkr->Reverbtron_Bypass);
  revtron_activar->do_callback();
  break;
 case 41:
  echotron_activar->value(rkr->Echotron_Bypass);
  echotron_activar->do_callback();
  break;
 case 42:
  shar_activar->value(rkr->StereoHarm_Bypass);
  shar_activar->do_callback();
  break;
 case 43:
  cband_activar->value(rkr->CompBand_Bypass);
  cband_activar->do_callback();
  break;
 case 44:
  otrem_activar->value(rkr->Opticaltrem_Bypass);
  otrem_activar->do_callback();
  break;
case 45:
  vibe_activar->value(rkr->Vibe_Bypass);
  vibe_activar->do_callback();
  break;

  
  case 121:
  Tap_activar->value(rkr->Tap_Bypass);
  Tap_activar->do_callback();
  break;
  case 122:
  nidi_activar->value(rkr->MIDIConverter_Bypass);
  nidi_activar->do_callback();
  break;
  case 123:
  tuner_activar->value(rkr->Tuner_Bypass);
  tuner_activar->do_callback();
  break;
  case 124:
  ActivarGeneral->value(rkr->Bypass);
  ActivarGeneral->do_callback();
  break;
     

}

rkr->OnOffC--;


}
}

void RKRGUI::light_preset(int npreset) {
  if(!made) return;

for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);
    long long temp = (long long) w->user_data();
    if (temp == npreset)
    {
     w->color(fl_darker(leds_color));
     break;
     }
  
  }
}

void RKRGUI::unlight_preset(int npreset) {
  if(!made) return;

for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);
    long long temp = (long long) w->user_data();
    if (temp == npreset)
    {
     w->color(fore_color);
     break;
     }
  
  }
}

void RKRGUI::PutBackground() {
  delete back;
back = new Fl_Tiled_Image(new Fl_PNG_Image(rkr->BackgroundImage),1600,1200);
if(!rkr->EnableBackgroundImage)
back->color_average(back_color,0.0);

InOut->image(back);
EQ->image(InOut->image());
COMPRESS->image(InOut->image());
DIST->image(InOut->image());
OVRD->image(InOut->image());
ECHO->image(InOut->image());
CHORUS->image(InOut->image());
FLANGER->image(InOut->image());
WHAWHA->image(InOut->image());
ALIENWAH->image(InOut->image());
PHASER->image(InOut->image());
REVERB->image(InOut->image());
PEQ->image(InOut->image());
CABINET->image(InOut->image());
PAN->image(InOut->image());
HAR->image(InOut->image());
MUSDELAY->image(InOut->image());
GATE->image(InOut->image());
NEWDIST->image(InOut->image());
APHASER->image(InOut->image());
VALVE->image(InOut->image());
DFLANGE->image(InOut->image());
RING->image(InOut->image());
EXCITER->image(InOut->image());
MBDIST->image(InOut->image());
ARPIE->image(InOut->image());
EXPANDER->image(InOut->image());
SHUFFLE->image(InOut->image());
SYNTHFILTER->image(InOut->image());
MBVVOL->image(InOut->image());
CONVOLOTRON->image(InOut->image());
LOOPER->image(InOut->image());
RYANWAH->image(InOut->image());
RBECHO->image(InOut->image());
COILCRAFTER->image(InOut->image());
SHELFBOOST->image(InOut->image());
VOCODER->image(InOut->image());
SUSTAINER->image(InOut->image());
SEQUENCE->image(InOut->image());
SHIFTER->image(InOut->image());
STOMPBOX->image(InOut->image());
REVERBTRON->image(InOut->image());
ECHOTRON->image(InOut->image());
SHAR->image(InOut->image());
COMPBAND->image(InOut->image());
OTREM->image(InOut->image());
VIBE->image(InOut->image());


Tap->image(InOut->image());
Presets->image(InOut->image());
Tuner->image(InOut->image());
Midi->image(InOut->image());
Metro->image(InOut->image());
fondo->image(InOut->image());
TITTLE_L->image(InOut->image());
Fondo1->image(InOut->image());
Fondo2->image(InOut->image());
Fondo3->image(InOut->image());
Fondo4->image(InOut->image());
Fondo5->image(InOut->image());
Fondo6->image(InOut->image());
Fondo7->image(InOut->image());
Fondo8->image(InOut->image());
Fondo9->image(InOut->image());
Fondo10->image(InOut->image());
Fondo11->image(InOut->image());










Etit->image(InOut->image());
Ares->image(InOut->image());

MenuP->image(InOut->image());
MenuB->image(InOut->image());


Fl::redraw();
}

void RKRGUI::chfsize(int value) {
  unsigned char k;



for (int t=0; t<Principal->children();t++)
  {
    Fl_Widget *w = Principal->child(t);
    long long ud = (long long) w->user_data();
  
     k= w->labelsize();
     k+=value;
     if((ud<770) || (ud>779))
     {
     if((k>2)&&(k<16)) w->labelsize(k);
     }
     else
     if((k>6)&&(k<20)) w->labelsize(k);
     
     if(ud != 5) w->labelcolor(label_color); else w->labelcolor(leds_color); 
     if (ud !=2) w->selection_color(back_color); else w->selection_color(leds_color);
     
   
    
    if (ud==1)
    {
          
     Fl_Group *g = (Fl_Group *)w;     
      
     for(int i=0;i<g->children();i++)
       {

         Fl_Widget *c = g->child(i);
         long long uh = (long long) c->user_data();
         

          k= c->labelsize();
          k+=value;
          if((uh==7) || (uh == 77))
          {
          if((k>6)&&(k<20))c->labelsize(k);
          }
          else
          if((k>2)&&(k<16))c->labelsize(k);
          if(uh != 5) c->labelcolor(label_color); else c->labelcolor(leds_color);
          if (uh !=7) c->selection_color(back_color); 
          if ((uh==2)||(uh==7)||(uh==77) || (uh == 78)) c->selection_color(leds_color);
          c->color(fore_color);
          c->labelfont(rkr->font);
       
          if(((uh >=12000) && (uh <=12100)) || (uh ==12))
           {
  
             Fl_Menu_*n = (Fl_Menu_*)c;
             
             Fl_Menu_Item *m = (Fl_Menu_Item*) n->menu(); 
             Fl_Menu_Item *p;  
             for(int s=0; s<m->size(); s++)
                  {
                    p=m->next(s);
                    k=p->labelsize();
                    k+=value;
                    if((k>2) &&(k<16))p->labelsize(k);
                    
                   }
             
       
  
            } 
       
  
  
          
       } 
    } 
 
  }



          k= WPreset_Name->textsize();
          k+=value;
          if((k>10)&&(k<32))WPreset_Name->textsize(k);


          CLIP_LED->selection_color(FL_RED);





ChangeActives();

 
Fl::redraw();
}

void RKRGUI::adjustfont() {
  int change,value;

change = Principal->w() - rkr->resolution;
value=change/100;
rkr->resolution=Principal->w();
rkr->relfontsize +=value;
chfsize(value);
}

void RKRGUI::ChangeActives() {
  Fl_Color on = fl_lighter(label_color);
Fl_Color off = fl_darker(label_color);


if(rkr->active[0]) L1->labelcolor(on); else L1->labelcolor(off);
if(rkr->active[1]) L2->labelcolor(on); else L2->labelcolor(off);
if(rkr->active[2]) L3->labelcolor(on); else L3->labelcolor(off);
if(rkr->active[3]) L4->labelcolor(on); else L4->labelcolor(off);
if(rkr->active[4]) L5->labelcolor(on); else L5->labelcolor(off);
if(rkr->active[5]) L6->labelcolor(on); else L6->labelcolor(off);
if(rkr->active[6]) L7->labelcolor(on); else L7->labelcolor(off);
if(rkr->active[7]) L8->labelcolor(on); else L8->labelcolor(off);
if(rkr->active[8]) L9->labelcolor(on); else L9->labelcolor(off);
if(rkr->active[9]) L10->labelcolor(on); else L10->labelcolor(off);



if(rkr->MIDIConverter_Bypass) MIDI_LABEL->labelcolor(on); else MIDI_LABEL->labelcolor(off);
if(rkr->Metro_Bypass) Metro_Label->labelcolor(on); else Metro_Label->labelcolor(off);
if(rkr->Tap_Bypass) TAP_LABEL->labelcolor(on); else TAP_LABEL->labelcolor(off);
if(rkr->Tuner_Bypass) TUNER_LABEL->labelcolor(on); else TUNER_LABEL->labelcolor(off);
if(rkr->Bypass) LABEL_IO->labelcolor(on); else LABEL_IO->labelcolor(off);
if((rkr->upsample) && (rkr->Bypass)) 
{
UPS_LED->color(leds_color);
UPS_LED->redraw();
}
 else
{ 
 UPS_LED->color(fl_darker(leds_color));
 UPS_LED->redraw();
}
CLIP_LED->color(fl_darker(FL_RED));
LMT_LED->color(fl_darker(leds_color));
}

void RKRGUI::findpos(int num, int value, Fl_Widget *w) {
  int i;
Fl_Color on = fl_lighter(label_color);
Fl_Color off= fl_darker(label_color);

for(i=0; i<10; i++)
 {
    if (rkr->efx_order[i]== num)
      {
        rkr->active[i]=value;
        break;
       }
  }
  
  
  
  
  switch(i)
  
  {
  
     case 0:
     if(value) L1->labelcolor(on); else L1->labelcolor(off);
     L1->redraw_label();
     break;  
     
     case 1:
     if(value) L2->labelcolor(on); else L2->labelcolor(off);
     L2->redraw_label();
     break;  
       
     case 2:
     if(value) L3->labelcolor(on); else L3->labelcolor(off);
     L3->redraw_label();
     break;  
       
     case 3:
     if(value) L4->labelcolor(on); else L4->labelcolor(off);
     L4->redraw_label();
     break;  
       
     case 4:
     if(value) L5->labelcolor(on); else L5->labelcolor(off);
     L5->redraw_label();
     break;  
       
     case 5:
     if(value) L6->labelcolor(on); else L6->labelcolor(off);
     L6->redraw_label();
     break;  
       
     case 6:
     if(value) L7->labelcolor(on); else L7->labelcolor(off);
     L7->redraw_label();
     break;  
       
     case 7:
     if(value) L8->labelcolor(on); else L8->labelcolor(off);
     L8->redraw_label();
     break;  
       
     case 8:
     if(value) L9->labelcolor(on); else L9->labelcolor(off);
     L9->redraw_label();
     break;  
       
     case 9:
     if(value) L10->labelcolor(on); else L10->labelcolor(off);
     L10->redraw_label();
     break;  
       
 }
}

void RKRGUI::Put_Skin(int last) {
  Principal->resize(Principal->x(),Principal->y(),rkr->resolution,rkr->sh);

back_color=(Fl_Color)rkr->sback_color;
fore_color=(Fl_Color)rkr->sfore_color;
leds_color=(Fl_Color)rkr->sleds_color;
label_color=(Fl_Color)rkr->slabel_color;

scheme_ch->value(rkr->sschema);
scheme_ch->do_callback();
PutBackground();
chfsize(rkr->relfontsize - last);
Leds_Color_Change(leds_color);
Buttons_Color_Change(fore_color);


save_stat(3);
Fl::redraw();
}

void RKRGUI::FillML(int type) {
  int i,j,k;
char tmp[256];
memset(tmp,0, sizeof(tmp));


sprintf(tmp,"%s   v%s - MIDI Learn - Preset : %s",rkr->jackcliname,VERSION,rkr->Bank[rkr->Selected_Preset].Preset_Name);
MIDILearn->copy_label(tmp);

memset(rkr->ML_clist,0,sizeof(rkr->ML_clist));
Epar->clear();
k=0;

switch(rkr->ML_filter) 
{
  
 case 0:
 for(i=0; i<rkr->NumParams; i++) Epar->add(rkr->efx_params[i].Nom);  
 break;

 case 1:
 for(i=0;i<rkr->NumParams;i++)
      {
        if(rkr->efx_params[i].Effect==50)
         { 
         Epar->add(rkr->efx_params[i].Nom); 
         rkr->ML_clist[k]=rkr->efx_params[i].Ato;
         k++;
         }
      
      } 
 for(j=0;j<10;j++)
  {
    for(i=0;i<rkr->NumParams;i++)
      {
        if(rkr->efx_params[i].Effect==rkr->efx_order[j])
         { 
         Epar->add(rkr->efx_params[i].Nom); 
         rkr->ML_clist[k]=rkr->efx_params[i].Ato;
         k++;
         }
      
      } 
      
  }
  
  
  break;
}

Epar->redraw();




TPresets->clear();
for(i=1; i<=60; i++)  TPresets->add(rkr->Bank[i].Preset_Name);
TPresets->select(rkr->Selected_Preset,1);
TPresets->redraw();

DisAssigns();
}

void RKRGUI::DisAssigns() {
  int i,j,k;
char tmp[8];

int the_one;

if (rkr->ML_filter==0)
 the_one = rkr->efx_params[(int)Epar->value()-1].Ato;
 else
 the_one = rkr->ML_clist[(int)Epar->value()-1];


k=0;

for(i=0;i<128;i++)
  {
    for(j=0;j<20;j++)
      { 
        
       if(rkr->XUserMIDI[i][j] == the_one)
         {
           k++;     
           memset(tmp,0, sizeof(tmp));
           sprintf(tmp, "%d", i);
           
           switch (k)
           {
           case 1:
              Ar1->copy_label(tmp);
              Ar1->redraw();
              break;     
                            
           case 2:
              Ar2->copy_label(tmp);
              Ar2->redraw();
              break;     
        
           case 3:
              Ar3->copy_label(tmp);
              Ar3->redraw();
              break;     
        
           case 4:
              Ar4->copy_label(tmp);
              Ar4->redraw();
              break;     
        
           case 5:
              Ar5->copy_label(tmp);
              Ar5->redraw();
              break;     
        
           case 6:
              Ar6->copy_label(tmp);
              Ar6->redraw();
              break;     
    
           case 7:
              Ar7->copy_label(tmp);
              Ar7->redraw();
              break;     
    
           case 8:
              Ar8->copy_label(tmp);
              Ar8->redraw();
              break;     
    
           case 9:
              Ar9->copy_label(tmp);
              Ar9->redraw();
              break;     
    
           case 10:
              Ar10->copy_label(tmp);
              Ar10->redraw();
              break;     
        
           case 11:
              Ar11->copy_label(tmp);
              Ar11->redraw();
              break;     
        
           case 12:
              Ar12->copy_label(tmp);
              Ar12->redraw();
              break;     
        
           case 13:
              Ar13->copy_label(tmp);
              Ar13->redraw();
              break;     
    
           case 14:
              Ar14->copy_label(tmp);
              Ar14->redraw();
              break;     

           case 15:
              Ar15->copy_label(tmp);
              Ar15->redraw();
              break;     

           case 16:
              Ar16->copy_label(tmp);
              Ar16->redraw();
              break;     
        
           case 17:
              Ar17->copy_label(tmp);
              Ar17->redraw();
              break;     
        
           case 18:
              Ar18->copy_label(tmp);
              Ar18->redraw();
              break;     
    
           case 19:
              Ar19->copy_label(tmp);
              Ar19->redraw();
              break;     

           case 20:
              Ar20->copy_label(tmp);
              Ar20->redraw();
              break;     


           }



       } 

 }         

}


           k++;     
           
           for(i=k;i<=20;i++)
           {
 
           memset(tmp,0,sizeof(tmp));
           
           switch (i)
           {
           case 1:
              Ar1->copy_label(tmp);
              Ar1->redraw();
              break;     
                            
           case 2:
              Ar2->copy_label(tmp);
              Ar2->redraw();
              break;     
        
           case 3:
              Ar3->copy_label(tmp);
              Ar3->redraw();
              break;     
        
           case 4:
              Ar4->copy_label(tmp);
              Ar4->redraw();
              break;     
        
           case 5:
              Ar5->copy_label(tmp);
              Ar5->redraw();
              break;     
        
           case 6:
              Ar6->copy_label(tmp);
              Ar6->redraw();
              break;     
    
           case 7:
              Ar7->copy_label(tmp);
              Ar7->redraw();
              break;     
    
           case 8:
              Ar8->copy_label(tmp);
              Ar8->redraw();
              break;     
    
           case 9:
              Ar9->copy_label(tmp);
              Ar9->redraw();
              break;     
    
           case 10:
              Ar10->copy_label(tmp);
              Ar10->redraw();
              break;     
        
           case 11:
              Ar11->copy_label(tmp);
              Ar11->redraw();
              break;     
        
           case 12:
              Ar12->copy_label(tmp);
              Ar12->redraw();
              break;     
        
           case 13:
              Ar13->copy_label(tmp);
              Ar13->redraw();
              break;     
    
           case 14:
              Ar14->copy_label(tmp);
              Ar14->redraw();
              break;     

           case 15:
              Ar15->copy_label(tmp);
              Ar15->redraw();
              break;     

           case 16:
              Ar16->copy_label(tmp);
              Ar16->redraw();
              break;     
        
           case 17:
              Ar17->copy_label(tmp);
              Ar17->redraw();
              break;     
        
           case 18:
              Ar18->copy_label(tmp);
              Ar18->redraw();
              break;     
    
           case 19:
              Ar19->copy_label(tmp);
              Ar19->redraw();
              break;     

           case 20:
              Ar20->copy_label(tmp);
              Ar20->redraw();
              break;     


}          

}
}

void RKRGUI::Prepare_Order() {
  int i;
Order_Bro->clear();


for (i=0; i<10;i++) 
{
rkr->new_order[i]=rkr->efx_order[i];
rkr->saved_order[i]=rkr->efx_order[i];
Order_Bro->add(rkr->efx_names[Busca_Eff(rkr->efx_order[i])].Nom);
}

Fill_Avail(rkr->eff_filter);

Order_Bro->select(1);
}

void RKRGUI::Show_Next_Time() {
  if(rkr->mess_dis) return;
Fl_Widget *w = fl_message_icon();
w->parent()->copy_label(rkr->jackcliname);         
fl_message("This setting will be changed the next time you run rakarrack");
}

void RKRGUI::update_looper() {
  rkr->efx_Looper->getstate();

looper_play->value(rkr->efx_Looper->progstate[0]);
looper_play->redraw();
looper_record->value(rkr->efx_Looper->progstate[2]);
looper_record->redraw();
looper_stop->value(rkr->efx_Looper->progstate[1]);
looper_stop->redraw();
if(rkr->efx_Looper->progstate[2])
{
  Box_P->copy_label("Stop");
  looper_stop->copy_label("@square");  
}
else
{
  Box_P->copy_label("Pause");
  looper_stop->copy_label("@||");
}
  
looper_t1->value(rkr->efx_Looper->progstate[4]);
looper_t1->redraw();
looper_t2->value(rkr->efx_Looper->progstate[5]);
looper_t2->redraw();
}

void RKRGUI::UpdateTGUI() {
  if(rkr->Looper_Bypass)
   {
   looper_Tempo->value(rkr->efx_Looper->getpar(14));
   looper_Tempo->redraw();
   }  

if(rkr->Chorus_Bypass)
  {
  chorus_freq->value(rkr->efx_Chorus->getpar(2));
  chorus_freq->redraw();
  }
  
  if(rkr->Flanger_Bypass)
  {
  flanger_freq->value(rkr->efx_Flanger->getpar(2));
  flanger_freq->redraw();
  }
  
  if(rkr->Phaser_Bypass)
  {
  phaser_freq->value(rkr->efx_Phaser->getpar(2));
  phaser_freq->redraw();
  }
  
  if(rkr->Pan_Bypass)
  {
  pan_freq->value(rkr->efx_Pan->getpar(2));
  pan_freq->redraw();
  }
  
  if(rkr->WhaWha_Bypass)
  {
  WhaWha_freq->value(rkr->efx_WhaWha->getpar(2));
  WhaWha_freq->redraw();
  }
  
  if(rkr->Alienwah_Bypass)
  {
  Alienwah_freq->value(rkr->efx_Alienwah->getpar(2));
  Alienwah_freq->redraw();
  }
  
  if(rkr->MusDelay_Bypass)
  {
  musdelay_tempo->value(rkr->efx_MusDelay->getpar(10));
  musdelay_tempo->redraw();
  }
  
  if(rkr->APhaser_Bypass)
  {
  aphaser_freq->value(rkr->efx_APhaser->getpar(2));
  aphaser_freq->redraw();
  }
  
  if(rkr->DFlange_Bypass)
  {
  dflange_freq->value(rkr->efx_DFlange->getpar(10));
  dflange_freq->redraw();
  }
  
  if(rkr->Synthfilter_Bypass)
  {
  synthfilter_freq->value(rkr->efx_Synthfilter->getpar(2));
  synthfilter_freq->redraw();
  }
  
  if(rkr->RyanWah_Bypass)
  {
  ryanwah_freq->value(rkr->efx_RyanWah->getpar(2));
  ryanwah_freq->redraw();
  }
    
  if(rkr->MBVvol_Bypass)
  {
  mbvvol_freq1->value(rkr->efx_MBVvol->getpar(1));
  mbvvol_freq1->redraw();
  }
  
  if(rkr->MBVvol_Bypass)
  {
  mbvvol_freq2->value(rkr->efx_MBVvol->getpar(4));
  mbvvol_freq2->redraw();
  }
  
  if(rkr->Arpie_Bypass)
  {
  arpie_delay->value(rkr->efx_Arpie->getpar(2));
  arpie_delay->redraw();
  }
 
  if(rkr->RBEcho_Bypass)
  {
   rbecho_delay->value(rkr->efx_RBEcho->getpar(2));
   rbecho_delay->redraw();
  }
  if(rkr->Sequence_Bypass)
  {
   seq_tempo->value(rkr->efx_Sequence->getpar(9));
   seq_tempo->redraw();
  }
  if(rkr->Echo_Bypass)
  { 
   echo_delay->value(rkr->efx_Echo->getpar(2));
   echo_delay->redraw();
  }
  if(rkr->Echotron_Bypass)
  { 
   echotron_tempo->value(rkr->efx_Echotron->getpar(5));
   echotron_tempo->redraw();
  }
  if(rkr->Opticaltrem_Bypass)
  {
    otrem_freq->value(rkr->efx_Opticaltrem->getpar(1));
    otrem_freq->redraw();  
  }
  if(rkr->Vibe_Bypass)
  {
    vibe_freq->value(rkr->efx_Vibe->getpar(1));
    vibe_freq->redraw();  
  }
}

void RKRGUI::ActACI() {
  int value;
int i,amax,amin;
float gain =  0.0;
float tmp = 0.0;

switch(rkr->Aux_Source)
{
   case 0:
      gain =  dB2rap (75.0f * (float)rkr->Aux_Gain / 127.0f);
      tmp = rkr->val_a_sum * gain;
      break;
   case 1:
      gain =  (float)rkr->Aux_Gain / 127.0f;
      tmp = dB2rap(rkr->val_il_sum) * 12.0f * gain ;
      break;
   case 2:
      gain =  (float)rkr->Aux_Gain / 127.0f;
      tmp = dB2rap(rkr->val_ir_sum) * 12.0f * gain;
      break;
}

float aux_vulevel =  (float)CLAMP(rap2dB(tmp), -48.0, 15.0);

float threshold = (float) rkr->Aux_Threshold;
aux_vu->value(aux_vulevel);

if (aux_vulevel < threshold) tmp=0.0;

if(tmp>1.0) tmp= 1.0f;

 amax = rkr->Aux_Maximum;
 amin = rkr->Aux_Minimum;

value = amin + lrintf((float)(amax - amin)* tmp);

if(value != rkr->last_auxvalue)
{

if(rkr->MIDIway)
{

for(i=0; i<20;i++)
    {
      if (rkr->XUserMIDI[rkr->Aux_MIDI][i])
          rkr->process_midi_controller_events(rkr->XUserMIDI[rkr->Aux_MIDI][i],value);
          else break;
   }        

}
else rkr->process_midi_controller_events(rkr->Aux_MIDI,value);   

rkr->last_auxvalue = value;

}
}

int RKRGUI::Busca_Eff(int num) {
  int i;
for(i=0; i<rkr->NumEffects;i++)
 {
   if(rkr->efx_names[i].Pos==num) 
   break;
 }  
 return(i);
}

void RKRGUI::Fill_Avail(int filter) {
  int i,j,t,k;

Avail_Bro->clear();

t=1;
for (i=0; i<rkr->NumEffects;i++)
{
  
    k=0;
 for (j=0;j<10;j++)
   { 
     if (rkr->new_order[j]==rkr->efx_names[i].Pos) k=1;
   }     
 
 if(!k)
 
 { 
 
  if((rkr->efx_names[i].Type&rkr->eff_filter)==rkr->eff_filter) 
 { 
  Avail_Bro->add(rkr->efx_names[i].Nom);
  rkr->availables[t]=rkr->efx_names[i].Pos;
  t++;
 }
 
 }

}

Avail_Bro->select(1);
}

void RKRGUI::highlight() {
  int tipo=0;
long long k=0;

Fl_Widget *w;

if (Fl::focus() == TITTLE_L) Fl::focus(Open_Order);
if (Fl::focus() == Etit) Fl::focus(Open_Order);
w = Fl::belowmouse();

if(w != NULL)
{
tipo=(int)w->type();
k = (long long) w->user_data();
}
else
{
if(old != NULL)
{
old->color(fore_color);
old->redraw();
}
}


if((tipo==1) || (k == 77)) 
{
if(old != NULL)
{
old->color(fore_color);
old->redraw();
}
   w->color(fl_color_average(fore_color,fl_lighter(fore_color),.8));
   w->redraw();
   old = w;
}

else
{
if(old != NULL)
{
old->color(fore_color);
old->redraw();
old->redraw_label();
}
}

if(k==99)
{
Fl_Browser *b;
b = (Fl_Browser *) w;
int tecla=Fl::event_key();
if(tecla != last_tecla)
{
 last_tecla = tecla; 
 for(int i=1; i<=b->size(); i++)
  {
    if (b->text(i)[0]>=tecla-32) 
     {
       b->select(i,1);
       break;
     }  

  }

}



}
}

int RKRGUI::search_but(int x, int y) {
  for (int t=0; t<ob->children();t++)
  {
    Fl_Widget *w = ob->child(t);

    if( (x>=w->x() ) && (x<=(w->x()+w->w())) && (y>=w->y() ) && (y<=(w->y()+w->h())))   
    
    { 
      long long kn = (long long) w->user_data();
      return((int)kn);
    }



  }
  
  
return(1000);
}

void RKRGUI::ScanDir() {
  char nombank[256];
char nombre[64];

DIR *dir=opendir(rkr->UDirFilename);

if (dir==NULL) return;

CH_UB->clear();

struct dirent *fs;

while ((fs=readdir(dir)))
{

if (strstr(fs->d_name,".rkrb")!=NULL)              
  { 
    memset(nombank,0,sizeof(nombank));
    sprintf(nombank,"%s/%s",rkr->UDirFilename,fs->d_name);
    if(rkr->CheckOldBank(nombank)==0)
    {
     memset(nombre,0,sizeof(nombre));
     strncpy(nombre,fs->d_name,strlen(fs->d_name)-5);
     if(nombre != NULL) CH_UB->add(nombre);  
    }
  
   }

   
}
 
CH_UB->value(0);
closedir(dir);
}

int RKRGUI::prevnext(int e) {
  if(e==5)
{
 Fl_Widget *w = Fl::belowmouse();
 long long k = (long long) w->user_data();
 if((k<770)||( k>779)) return 0;
 drag=k-770;
 return 1;
}
 
if((drag!=1000) && (Fl::event_button1()==0))
{
Fl_Widget *w = Fl::belowmouse();
long long k = (long long) w->user_data();
if((k<770)||( k>779)) return 0;
if(drag != (int)k-770) ((RKRGUI*)(w->parent()->user_data()))->Prep_Reorden(drag,(int)k-770);
drag=1000;
return 1;
}

if(e != 12) return 0;
else
{

if((Fl::event_key(43)) || (Fl::event_key(FL_KP + 43))) 
{
stecla=1;
return 1;
}

if((Fl::event_key(45)) || (Fl::event_key(FL_KP + 45)))
{
stecla=2;
return 1;
}

if(Fl::event_key(65471))
{
stecla=3;
return 1;
}

if(Fl::event_key(65472))
{
stecla=4;
return 1;
}

if(Fl::event_key(65379))
{
 Fl_Widget *w = Fl::belowmouse();
 long long k = (long long) w->user_data();
 if((k>11999) && (k<12100)) 
 ((RKRGUI*)(w->parent()->parent()->user_data()))->addpreset(w,k-12000);
return 1;

}


if(Fl::event_key(65535))
{
 Fl_Widget *w = Fl::belowmouse();
 long long k = (long long) w->user_data();
 if((k>11999) && (k<12100)) 
 ((RKRGUI*)(w->parent()->parent()->user_data()))->delpreset(w,k-12000);
return 1;

}









}

return 0;
}

void RKRGUI::getMIDIControl(int num) {
  int i = 0;
rkr->comemouse=1;
PrepareML();
while (i<Epar->size())
{

 if ((rkr->ML_filter==0) && (rkr->efx_params[i].Ato == num))
 
  {
    Epar->select(i+1);
    break;
   }

 if ((rkr->ML_filter==1) && (rkr->ML_clist[i] == num))
  {
    Epar->select(i+1);
    break;
   }


i++;

}

DisAssigns();
GMM->do_callback();
}

void RKRGUI::PrepareML() {
  FillML(0);
if(rkr->comemouse==0)
{
 MIDILearn->show();
 put_icon(MIDILearn);
 return;
} 

if(rkr->comemouse) 
{
 if(rkr->autoassign==0)
   {
       MIDILearn->show();
       put_icon(MIDILearn);
       return;
   } 
}
}

inline void RKRGUI::addpreset(Fl_Widget *w, int num) {
  if(num==12) return;
const char *name = fl_input("Preset Name?","");
if(name==NULL) return;
char NewName[64];
memset(NewName,0,sizeof(NewName));
sprintf(NewName,"*%s",name);
add_name(w,NewName);
rkr->SaveIntPreset(num,NewName);
}

void RKRGUI::add_name(Fl_Widget *w, char *name) {
  Fl_Choice *s = (Fl_Choice * ) w;
s->add(name);


Fl_Menu_*n = (Fl_Menu_*)s->menu();
Fl_Menu_Item *m = (Fl_Menu_Item*) n; 
Fl_Menu_Item *p;  
int k=10;

for(int i=0; i<m->size(); i++)
    {
     p=m->next(i);
     if(i==0)k=p->labelsize();
     p->labelsize(k);
     }
}

Fl_Widget * RKRGUI::FindWidget(int num) {
  for (int t=0; t<Principal->children();t++)
  {
    Fl_Widget *w = Principal->child(t);
    long long ud = (long long) w->user_data();
     
    if (ud==1)
    {
          
     Fl_Group *g = (Fl_Group *)w;     
      
     for(int i=0;i<g->children();i++)
       {

         Fl_Widget *c = g->child(i);
         long long uh = (long long) c->user_data();
         if(uh==(num+12000)) return c;
        }
     }          
   }
   
return NULL;
}

void RKRGUI::ReadIntPresets() {
  FILE *fn;
char tempfile[256];
char buf[256];
char *name;
char *sbuf;
int num=0;
memset(tempfile,0,sizeof(tempfile));

sprintf (tempfile, "%s%s", getenv ("HOME"), "/.rkrintpreset");

if (( fn = fopen (tempfile, "r")) != NULL)
{
   while (fgets (buf, sizeof buf, fn) != NULL)
    
     {
        
       sbuf = buf;
       sscanf(buf,"%d",&num);
       name = strsep(&sbuf,",");
       name = strsep(&sbuf,",");
       add_name(FindWidget(num), name);
     }
 fclose(fn);
}
}

inline void RKRGUI::delpreset(Fl_Widget *w, int num) {
  if(num==12) return;
int ok;
char temp2[128];
char Rname[128];
Fl_Choice *s = (Fl_Choice * ) w;
if(strncmp(s->text(),"*",1)!=0) 
{
 fl_message("Released Internal Presets can not be deleted ");
 return;
} 

sprintf(temp2,"Delete? \"%s\"",s->text());
ok=fl_choice(temp2,"No","Yes",NULL);
if (!ok) return;
memset(Rname,0,sizeof(Rname));
sprintf(Rname,"%s",s->text());
s->remove(s->value());
s->value(0);
s->redraw();
rkr->DelIntPreset(num,Rname);
}

void RKRGUI::Prep_Reorden(int source, int dest) {
  int x = rkr->efx_order[source];
int y = rkr->efx_order[dest];

rkr->efx_order[source]=y;
rkr->efx_order[dest]=x;

reordena();

if (Order->visible())Prepare_Order();
}

void RKRGUI::make_table_window() {
  scroll->begin();

  for (int y=0; y<128; y++)
   {
    char buf[20]; sprintf(buf,"%d",y);
  
    Fl_Box* b = new Fl_Box(6,y*25+22,60,25);
    b->box(FL_DOWN_BOX);
    b->copy_label(buf);
    b->labelcolor(FL_WHITE);
    b->user_data((void *) 8000);
    
    Fl_Choice* cb = new Fl_Choice(120,y*25+25,60,20);
    cb->copy_label("Bank");
    cb->labelcolor(FL_WHITE);
    cb->add("1");
    cb->add("2");
    cb->add("3");
    cb->add("U");
    cb->user_data((void *) (1000+y));
    cb->callback((Fl_Callback *)bank_click); 
    scroll->add(cb);
    
    Fl_Choice* cp = new Fl_Choice(260,y*25+25,220,20);
    cp->copy_label("Preset");
    cp->labelcolor(FL_WHITE);
    cp->user_data((void *) (2000+y));
    cp->callback((Fl_Callback *)p_click); 
    scroll->add(cp);
  
  
  }
  scroll->end();
  
Put_MidiTable();
 

 scroll->position(0,-339);
}

void RKRGUI::bank_click(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->parent()->user_data()))->bank_click_i(o,v);
}

inline void RKRGUI::bank_click_i(Fl_Choice* o, void*) {
  long long kk = (long long) o->user_data();
int num = (int) kk;

rkr->M_table[num-1000].bank=(int) o->value();
fill_mptable(num+1000,rkr->M_table[num-1000].bank);
}

void RKRGUI::p_click(Fl_Choice* o, void* v) {
  ((RKRGUI*)(o->parent()->parent()->parent()->parent()->user_data()))->p_click_i(o,v);
}

inline void RKRGUI::p_click_i(Fl_Choice* o, void*) {
  long long kk = (long long) o->user_data();
int num = (int) kk;

rkr->M_table[num-2000].preset=o->value();
}

void RKRGUI::fill_mptable(int num,int value) {
  for (int t=0; t<scroll->children();t++)
  {
    Fl_Widget *w = scroll->child(t);
    long long temp = (long long) w->user_data();
    if ((int)temp == num)
    {
     Fl_Choice *p = (Fl_Choice * ) w; 
     p->clear(); 
     for(int i=1; i<=60;i++)
     p->add(rkr->B_Names[value][i].Preset_Name);
     break;
    }
  }
}

void RKRGUI::mtfillvalue(int num,int value) {
  for (int t=0; t<scroll->children();t++)
  {
    Fl_Widget *w = scroll->child(t);
    long long temp = (long long) w->user_data();
    if ((int)temp == num)
    {
     Fl_Choice *p = (Fl_Choice * ) w; 
     p->value(value); 
     break;
    }
  }
}

void RKRGUI::Put_MidiTable() {
  for(int i=0;i<128;i++)
{
 mtfillvalue(i+1000, rkr->M_table[i].bank);
 fill_mptable(i+2000, rkr->M_table[i].bank);
 mtfillvalue(i+2000, rkr->M_table[i].preset);
}
}

void RKRGUI::RandomPreset() {
  int i,j,l;
int SelEff[10];
int numEff = (int) (RND*6) + 1;
long long k;


S_new->do_callback();

SelEff[0]=(int)(RND*rkr->NumEffects);

for(i=1;i<10;i++) 
{
 l=0;
 while (l==0)
 {
   SelEff[i]=(int)(RND* rkr->NumEffects);
   for(j=0;j<i;j++)
    {
      if(SelEff[j]==SelEff[i])
       {
         l=0; 
         break;
       }    
      else
      l=1;
    }
 }


}





 for(i=0; i<10; i++)
{
  rkr->efx_order[i]=SelEff[i];
  
}


  


for(i=0;i<10;i++)
 {

   switch(rkr->efx_order[i])
    {
      

     case 0: //EQ1
     if (i<numEff)rkr->EQ1_Bypass=1; else rkr->EQ1_Bypass=0;
     eq_activar->value(rkr->EQ1_Bypass);
     break;

     case 1://Compressor
     if (i<numEff)rkr->Compressor_Bypass=1; else rkr->Compressor_Bypass=0;
     compress_activar->value(rkr->Compressor_Bypass);
     break;

     case 2://Distorsion
     if (i<numEff) rkr->Distorsion_Bypass=1; else rkr->Distorsion_Bypass=0; 
     dist_activar->value(rkr->Distorsion_Bypass);
     break;

     case 3://Overdrive
     if (i<numEff)rkr->Overdrive_Bypass=1; else rkr->Overdrive_Bypass=0;
     ovrd_activar->value(rkr->Overdrive_Bypass);
     break; 

     case 4://Echo
     if (i<numEff)rkr->Echo_Bypass=1; else rkr->Echo_Bypass=0;
     echo_activar->value(rkr->Echo_Bypass);
     break;
     
     case 5://Chorus
     if (i<numEff)rkr->Chorus_Bypass=1; else rkr->Chorus_Bypass=0;
     chorus_activar->value(rkr->Chorus_Bypass);
     break;
     
     case 6://Phaser
     if (i<numEff)rkr->Phaser_Bypass=1; else rkr->Phaser_Bypass=0;
     phaser_activar->value(rkr->Phaser_Bypass);
     break;  

     case 7://Flanger
     if (i<numEff)rkr->Flanger_Bypass=1; else rkr->Flanger_Bypass=0;
     flanger_activar->value(rkr->Flanger_Bypass);
     break;
 
     case 8://Reverb
     if (i<numEff)rkr->Reverb_Bypass=1; else rkr->Reverb_Bypass=0;
     reverb_activar->value(rkr->Reverb_Bypass);
     break;  

     case 9://EQ2
     if (i<numEff)rkr->EQ2_Bypass=1; else rkr->EQ2_Bypass=0; 
     eqp_activar->value(rkr->EQ2_Bypass);
     break; 
     
     case 10://WahWah
     if (i<numEff)rkr->WhaWha_Bypass=1; else rkr->WhaWha_Bypass=0;
     WhaWha_activar->value(rkr->WhaWha_Bypass);
     break;

     case 11://AlienWah
     if (i<numEff)rkr->Alienwah_Bypass=1; else rkr->Alienwah_Bypass=0;
     Alienwah_activar->value(rkr->Alienwah_Bypass);
     break;
     
     case 12://Cabinet
     if (i<numEff)rkr->Cabinet_Bypass=1; else rkr->Cabinet_Bypass=0;
     Cabinet_activar->value(rkr->Cabinet_Bypass);
     break;
 
     case 13://Pan
     if (i<numEff)rkr->Pan_Bypass=1; else rkr->Pan_Bypass=0;
     pan_activar->value(rkr->Pan_Bypass);
     break;
     
     case 14://Har
     if (i<numEff)rkr->Harmonizer_Bypass=1; else rkr->Harmonizer_Bypass=0;
     har_activar->value(rkr->Harmonizer_Bypass);
     break;

     case 15://MsicalDelay
     if (i<numEff)rkr->MusDelay_Bypass=1; else rkr->MusDelay_Bypass=0;
     musdelay_activar->value(rkr->MusDelay_Bypass);
     break; 

     case 16://NoiseGate
     if (i<numEff)rkr->Gate_Bypass=1; else rkr->Gate_Bypass=0;
     gate_activar->value(rkr->Gate_Bypass);
     break; 

     case 17://NewDist
     if (i<numEff)rkr->NewDist_Bypass=1; else rkr->NewDist_Bypass=0;
     newdist_activar->value(rkr->NewDist_Bypass);
     break;
     
     case 18://APhaser
     if (i<numEff)rkr->APhaser_Bypass=1; else rkr->APhaser_Bypass=0;
     aphaser_activar->value(rkr->APhaser_Bypass);
     break;

     case 19://Valve
     if (i<numEff)rkr->Valve_Bypass=1; else rkr->Valve_Bypass=0;
     valve_activar->value(rkr->Valve_Bypass);
     break;

     case 20://Dual_Flange
     if (i<numEff)rkr->DFlange_Bypass=1; else rkr->DFlange_Bypass=0;
     dflange_activar->value(rkr->DFlange_Bypass);
     break;

     case 21:// Ring
     if (i<numEff)rkr->Ring_Bypass=1; else rkr->Ring_Bypass=0;
     ring_activar->value(rkr->Ring_Bypass);
     break;  

     case 22:// Exciter
     if (i<numEff)rkr->Exciter_Bypass=1; else rkr->Exciter_Bypass=0;
     exciter_activar->value(rkr->Exciter_Bypass);
     break; 

     case 23://MBDist
     if (i<numEff)rkr->MBDist_Bypass=1; else rkr->MBDist_Bypass=0;
     mbdist_activar->value(rkr->MBDist_Bypass);
     break;

     case 24://Arpie
     if (i<numEff)rkr->Arpie_Bypass=1;else rkr->Arpie_Bypass=0;
     arpie_activar->value(rkr->Arpie_Bypass);
     break;

     case 25://Expander
     if (i<numEff)rkr->Expander_Bypass=1; else rkr->Expander_Bypass=0;
     expander_activar->value(rkr->Expander_Bypass);
     break;

     case 26://Shuffle
     if (i<numEff)rkr->Shuffle_Bypass=1; else rkr->Shuffle_Bypass=0;
     shuffle_activar->value(rkr->Shuffle_Bypass);
     break;

     case 27://Synthfilter
     if (i<numEff)rkr->Synthfilter_Bypass=1; else rkr->Synthfilter_Bypass=0;
     synthfilter_activar->value(rkr->Synthfilter_Bypass);
     break; 

     case 28://VaryBand
     if (i<numEff)rkr->MBVvol_Bypass=1; else rkr->MBVvol_Bypass=0;
     mbvvol_activar->value(rkr->MBVvol_Bypass);
     break;

     case 29://Convolotron
     if (i<numEff)rkr->Convol_Bypass=1; else rkr->Convol_Bypass=0;
     convo_activar->value(rkr->Convol_Bypass);
     break; 

     case 30://Looper
     if (i<numEff)rkr->Looper_Bypass=1; else rkr->Looper_Bypass=0;
     looper_activar->value(rkr->Looper_Bypass);
     update_looper();
     break;

     case 31://RyanWah
     if (i<numEff)rkr->RyanWah_Bypass=1; else rkr->RyanWah_Bypass=0;
     ryanwah_activar->value(rkr->RyanWah_Bypass);
     break;  
     
     case 32:// RBEcho
     if (i<numEff)rkr->RBEcho_Bypass=1; else rkr->RBEcho_Bypass=0;
     rbecho_activar->value(rkr->RBEcho_Bypass);
     break;
     
     case 33:// CoilCrafter
     if (i<numEff)rkr->CoilCrafter_Bypass=1; else rkr->CoilCrafter_Bypass=0;
     coil_activar->value(rkr->CoilCrafter_Bypass);
     break;

     case 34://ShelfBoost
     if (i<numEff)rkr->ShelfBoost_Bypass=1; else rkr->ShelfBoost_Bypass=0;
     shelf_activar->value(rkr->ShelfBoost_Bypass);
     break;
     
     case 35://Vocoder
     if (i<numEff)rkr->Vocoder_Bypass=1; else rkr->Vocoder_Bypass=0;
     vo_activar->value(rkr->Vocoder_Bypass);
     break;

     case 36://Sustainer
     if (i<numEff)rkr->Sustainer_Bypass=1; else rkr->Sustainer_Bypass=0;
     sus_activar->value(rkr->Sustainer_Bypass);
     break;
     
    case 37://Sequence
    if (i<numEff)rkr->Sequence_Bypass=1; else rkr->Sequence_Bypass=0;
    seq_activar->value(rkr->Sequence_Bypass);
    break;

    case 38://Shifter
    if (i<numEff)rkr->Shifter_Bypass=1; else rkr->Shifter_Bypass=0;
    shifter_activar->value(rkr->Shifter_Bypass);
    break;

    case 39://StompBox
    if (i<numEff)rkr->StompBox_Bypass=1; else rkr->StompBox_Bypass=0;
    stomp_activar->value(rkr->StompBox_Bypass);
    break;

    case 40://Reverbtron
    if (i<numEff)rkr->Reverbtron_Bypass=1; else rkr->Reverbtron_Bypass=0;
    revtron_activar->value(rkr->Reverbtron_Bypass);
    break;

    case 41://Echotron
    if (i<numEff)rkr->Echotron_Bypass=1; else rkr->Echotron_Bypass=0;
    echotron_activar->value(rkr->Echotron_Bypass);
    break;

    case 42://StereoHarm
    if (i<numEff)rkr->StereoHarm_Bypass=1; else rkr->StereoHarm_Bypass=0;
    shar_activar->value(rkr->StereoHarm_Bypass);
    break; 

    case 43://CompBand
    if (i<numEff)rkr->CompBand_Bypass=1; else rkr->CompBand_Bypass=0;
    cband_activar->value(rkr->CompBand_Bypass);
    break;

    case 44://Opticaltrem
    if (i<numEff)rkr->Opticaltrem_Bypass=1; else rkr->Opticaltrem_Bypass=0;
    otrem_activar->value(rkr->Opticaltrem_Bypass);
    break;

    case 45://Vibe
    if (i<numEff)rkr->Vibe_Bypass=1; else rkr->Vibe_Bypass=0;
    vibe_activar->value(rkr->Vibe_Bypass);
    break;
  }




 Fl_Widget *w = FindWidget(SelEff[i]);
 Fl_Choice *s = (Fl_Choice *) w;
 k = (long long) s->user_data();
 int Esel = (int)(RND * s->size());
 s->value(Esel);
 s->do_callback(w,k);
}

FillML(0);
Prepare_Order();
Put_Loaded();

ActivarGeneral->value(1);
ActivarGeneral->do_callback();
}
