# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Bcm.idl.

use strict;

package Raritan::RPC::pdumodel::Bcm;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "pdumodel.Bcm:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::pdumodel::Bcm::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

sub getChannelCount($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getChannelCount', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::pdumodel::Bcm::ChannelConfig;

sub getChannelConfigs($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getChannelConfigs', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::pdumodel::Bcm::ChannelConfig::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::pdumodel::Bcm::ChannelConfig;

sub setChannelConfig($$$) {
    my ($self, $channel, $config) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'channel'} = 1 * $channel;
    $args->{'config'} = Raritan::RPC::pdumodel::Bcm::ChannelConfig::encode($config);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setChannelConfig', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('pdumodel.Bcm', 1, 0, 0, 'Raritan::RPC::pdumodel::Bcm');
1;
