/* ScummVM Tools
 *
 * ScummVM Tools is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef LAB_H
#define LAB_H

#include "common/endian.h"
#include <string>
#include <iostream>

#define GT_GRIM 1
#define GT_EMI 2

struct lab_header {
	uint32 magic;
	uint32 magic2;
	uint32 num_entries;
	uint32 string_table_size;
	uint32 string_table_offset;
};

struct lab_entry {
	uint32 fname_offset;
	uint32 start;
	uint32 size;
	uint32 reserved;
};

class Lab {
	std::string _filename;
	uint8 g_type;
	uint32 offset;
	uint32 bufSize;
	lab_header head;
	lab_entry *entries;
	char *buf;
	char *str_table;
	FILE *infile;
	void Load(std::string filename);
public:
	Lab(std::string filename);
	~Lab();

	int getNumEntries() { return head.num_entries; }

	std::string getFileName(int index);
	std::istream *getFile(std::string filename);
	int getIndex(std::string filename);
	int getLength(std::string filename);
};

std::istream *getFile(std::string filename, Lab *lab);
std::istream *getFile(std::string filename, Lab *lab, int &length);

#endif
